proc Read_chan_data24 { chan offset } {
    read_chan_data24 $chan $offset
}

proc read_chan_data24 { chan offset } {

    global ETPUCxCR_CPBA
    global np

    set addr [mem 22:[chanAddrCr 0 $chan] %x $np]
    set addr [expr $addr & [format 0x%.8x $ETPUCxCR_CPBA]]
    set addr [expr $addr << 3]

    set data [mem 0:[format 0x%.8x [expr [expr $addr + $offset] & 0xfffffffc]] %x $np]
    set data [expr $data & 0x00ffffff]

    return $data
}


proc Read_chan_data24s { chan offset } {
    read_chan_data24s $chan $offset
}

proc read_chan_data24s { chan offset } {

    set data [read_chan_data24 $chan $offset]
    
    if [expr $data & 0x00800000] {
      set data [expr $data - 0x1000000]
    }

    return $data
}


proc Read_chan_data8 { chan offset } {
    read_chan_data8 $chan $offset
}

proc read_chan_data8 { chan offset } {

    global ETPUCxCR_CPBA
    global np

    set addr [mem 22:[chanAddrCr 0 $chan] %x $np]
    set addr [expr $addr & [format 0x%.8x $ETPUCxCR_CPBA]]
    set addr [expr $addr << 3]

    set data [mem 0:[format 0x%.8x [expr [expr $addr + $offset] & 0xfffffffc]] %x $np]
    set data [expr $data >> 24]

    return $data
}


proc Read_chan_hsrr { chan } {
    read_chan_hsrr $chan
}

proc read_chan_hsrr { chan } {

    global ETPUCxHSRR_HSR

    return [get_bit [chanAddrHsrr 0 $chan] $ETPUCxHSRR_HSR 0]
}


proc Precision_bits { err {range 1} } {
	precision_bits $err $range
}

proc precision_bits { err {range 1} } {
	if {$err == 0} {
    	return 24
	} else {
		return [expr -log(abs($err/$range))/log(2)]
	}
}
