/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : sysclk_init.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : Mode Entry, System Clock, CMU initialization file.
 *
 ******************************************************************************** 
 *
 * Detail Description     : This file contains definations for initialization functions
 *                          of Mode Entry, System Clock and CMU module. Mode Entry function
 *                          will configure the system SoC for different operating modes.
 *                          In System Clock function the Clock Generation Module parameters
 *                          are initialized for DRUN mode. CMU function is initialized to
 *                          monitor the system clock parameters and report the failures.
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "sysclk_init.h"


/* *********************************************************** */
/*       Global functions            */
/* *********************************************************** */


void sysclk_module_init_fnc(void)
{
    mode_entry_init_fnc();
        /* Mode Entry Initialization Function */
    sysclk_init_fnc();
        /* System Clock Initialization Function */
    cmu_init_fnc();
        /* CMU Initialization Function */
}


void mode_entry_init_fnc(void)
{

/* ----------------------------------------------------------- */
/*              Magic Carpet Initialization - Start            */
/* ----------------------------------------------------------- */


/* ----------------------------------------------------------- */
/*              Mode Entry Setup            */
/* ----------------------------------------------------------- */

    ME.MER.R = 0x0000001D;
        /* STOP0 Mode : Disabled    */
        /* HALT0 Mode : Disabled    */
        /* RUN3 Mode : Disabled    */
        /* RUN2 Mode : Disabled    */
        /* RUN1 Mode : Disabled    */
        /* RUN0 Mode : Enabled    */
        /* DRUN Mode : Enabled    */
        /* SAFE Mode : Enabled    */
        /* TEST Mode : Disabled    */
        /* RESET Mode : Enabled    */
/*---------------------------TEST Mode--------------------------------*/
    ME.TEST.R = 0x001F0010;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: ON    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): OFF    */
        /* Crystal Oscillator: OFF    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: 16MHz internal RC oscillator     */
/*---------------------------SAFE Mode--------------------------------*/
    ME.SAFE.R  = 0x009F0010;
        /* I/O Power Down Control: Enabled    */
        /* Main Voltage Regulator Control: ON    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): OFF    */
        /* Crystal Oscillator: OFF    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: 16MHz internal RC oscillator     */
/*---------------------------RUN0 Mode--------------------------------*/
    ME.RUN[0].R = 0x001F0010;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: ON    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): OFF    */
        /* Crystal Oscillator: OFF    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: 16MHz internal RC oscillator     */
/*---------------------------RUN1 Mode--------------------------------*/
    ME.RUN[1].R = 0x001F0010;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: ON    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): OFF    */
        /* Crystal Oscillator: OFF    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: 16MHz internal RC oscillator     */
/*---------------------------RUN2 Mode--------------------------------*/
    ME.RUN[2].R = 0x001F0010;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: ON    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): OFF    */
        /* Crystal Oscillator: OFF    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: 16MHz internal RC oscillator     */
/*---------------------------RUN3 Mode--------------------------------*/
    ME.RUN[3].R = 0x001F0010;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: ON    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): OFF    */
        /* Crystal Oscillator: OFF    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: 16MHz internal RC oscillator     */
/*---------------------------HALT0 Mode--------------------------------*/
    ME.HALT0.R = 0x00150010;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: ON    */
        /* Data Flash Power Down Control: Power Down    */
        /* Code Flash Power Down Control: Power Down    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): OFF    */
        /* Crystal Oscillator: OFF    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: 16MHz internal RC oscillator     */
/*---------------------------STOP0 Mode--------------------------------*/
    ME.STOP0.R = 0x00150010;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: ON    */
        /* Data Flash Power Down Control: Power Down    */
        /* Code Flash Power Down Control: Power Down    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): OFF    */
        /* Crystal Oscillator: OFF    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: 16MHz internal RC oscillator     */

/* ----------------------------------------------------------- */
/*              Peripheral RUN Mode Configuration            */
/* ----------------------------------------------------------- */

    ME.RUNPC[0].R = 0x000000FE;
        /* Peripheral Operation in RUN3  mode: Enabled    */
        /* Peripheral Operation in RUN2  mode: Enabled    */
        /* Peripheral Operation in RUN1  mode: Enabled    */
        /* Peripheral Operation in RUN0  mode: Enabled    */
        /* Peripheral Operation in DRUN  mode: Enabled    */
        /* Peripheral Operation in SAFE  mode: Enabled    */
        /* Peripheral Operation in TEST  mode: Enabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[1].R = 0x00000008;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[2].R = 0x00000008;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[3].R = 0x00000008;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[4].R = 0x00000008;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[5].R = 0x00000008;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[6].R = 0x00000008;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[7].R = 0x00000008;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */


/* ----------------------------------------------------------- */
/*              Peripheral Low-Power Mode Configuration            */
/* ----------------------------------------------------------- */

    ME.LPPC[0].R = 0x00000500;
        /* Peripheral Operation in STOP0 mode: Enabled    */
        /* Peripheral Operation in HALT0 mode: Enabled    */

    ME.LPPC[1].R = 0x00000000;
        /* Peripheral Operation in STOP0 mode: Disabled    */
        /* Peripheral Operation in HALT0 mode: Disabled    */

    ME.LPPC[2].R = 0x00000000;
        /* Peripheral Operation in STOP0 mode: Disabled    */
        /* Peripheral Operation in HALT0 mode: Disabled    */

    ME.LPPC[3].R = 0x00000000;
        /* Peripheral Operation in STOP0 mode: Disabled    */
        /* Peripheral Operation in HALT0 mode: Disabled    */

    ME.LPPC[4].R = 0x00000000;
        /* Peripheral Operation in STOP0 mode: Disabled    */
        /* Peripheral Operation in HALT0 mode: Disabled    */

    ME.LPPC[5].R = 0x00000000;
        /* Peripheral Operation in STOP0 mode: Disabled    */
        /* Peripheral Operation in HALT0 mode: Disabled    */

    ME.LPPC[6].R = 0x00000000;
        /* Peripheral Operation in STOP0 mode: Disabled    */
        /* Peripheral Operation in HALT0 mode: Disabled    */

    ME.LPPC[7].R = 0x00000000;
        /* Peripheral Operation in STOP0 mode: Disabled    */
        /* Peripheral Operation in HALT0 mode: Disabled    */


/* ----------------------------------------------------------- */
/*              Peripheral Mode Control Setup            */
/* ----------------------------------------------------------- */

    /* DSPI_0 Control */
    ME.PCTL[4].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* DSPI_1 Control */
    ME.PCTL[5].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* DSPI_2 Control */
    ME.PCTL[6].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* DSPI_3 Control */
    ME.PCTL[7].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* FlexCAN_0 Control */
    ME.PCTL[16].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* FlexRay Control */
    ME.PCTL[24].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* SafetyPort Control */
    ME.PCTL[26].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* ADC_0 Control */
    ME.PCTL[32].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* ADC_1 Control */
    ME.PCTL[33].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* CTU_0 Control */
    ME.PCTL[35].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* eTimer0 Control */
    ME.PCTL[38].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* eTimer1 Control */
    ME.PCTL[39].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* FlexPWM0 Control */
    ME.PCTL[41].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* LINFLEX_0 Control */
    ME.PCTL[48].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* LINFLEX_1 Control */
    ME.PCTL[49].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */

    /* PIT Control */
    ME.PCTL[92].R = 0x00;
        /* Peripheral Operation in Debug mode: Disabled    */
        /* Low-Power Mode Peripheral Configuration: Low-Power Mode Configuration 0    */
        /* RUN Mode Peripheral Configuration: RUN Mode Configuration 0    */


/* ----------------------------------------------------------- */
/*              Interrupt Setup            */
/* ----------------------------------------------------------- */

    ME.IM.R = 0x00000000;
        /* Invalid Mode Configuration Interrupt: Disabled    */
        /* Invalid Mode Interrupt: Disabled    */
        /* SAFE Mode Interrupt: Disabled    */
        /* Mode Transition Complete Interrupt: Disabled    */

/* ----------------------------------------------------------- */
/*              Operating Modes Setup - End                */
/* ----------------------------------------------------------- */

}

void sysclk_init_fnc(void)
{

/* ----------------------------------------------------------- */
/*              Enable All Auxiliary Clocks            */
/* ----------------------------------------------------------- */
    CGM.AC0DC.B.DE0 = 0x1;
            /* FlexPWM Clock (Aux Clock 0 Divider): Enabled */
    CGM.AC1DC.B.DE0 = 0x1;
            /* CMU1 Monitored Clock(Aux Clock 1 Divider): Enabled */
    CGM.AC2DC.B.DE0 = 0x1;
            /* Safety Port Clock(Aux Clock 2 Divider): Enabled */
    CGM.AC3DC.B.DE0 = 0x1;
            /* FlexRay Clock(Aux Clock 3 Divider): Enabled */

/* ---------------Set Maximum CMU RC Divider--------------------  */
    CGM.CMU_0_CSR.R = 0x00000006;
            /* RC Clock Division factor: 8 */

/* ----------------------------------------------------------- */
/*              Clock Source Configuration            */
/* ----------------------------------------------------------- */

    CGM.OSC_CTL.R = 0x00800000;
        /* Oscillator Output is Disabled as rootclock    */
        /* The End of Count Value for XOSC = 128    */
        /* The XOSC Clock Interrupt: Disabled    */
        /* The XOSC Clock Divider: 1    */

    CGM.FMPLL[0].CR.R = 0x05400001;
        /* Input Division Factor: 2    */
        /* Output Division Factor: 4    */
        /* Loop Division Factor: 64    */
        /* Progressive Clock Switching Disabled in Standby Mode    */

    CGM.FMPLL[0].MR.R = 0x00000000;
        /* The selected Spread Type: Center Spread    */
        /* The Modulation Period for FMPLL: 0    */
        /* Frequency modulation for PLL: Disabled    */
        /* The Increment Step for FMPLL: 0    */

    CGM.FMPLL[1].CR.R = 0x12400001;
        /* Input Division Factor: 5    */
        /* Output Division Factor: 8    */
        /* Loop Division Factor: 64    */
        /* Progressive Clock Switching Disabled in Standby Mode    */

    CGM.FMPLL[1].MR.R = 0x00000000;
        /* The selected Spread Type: Center Spread    */
        /* The Modulation Period for FMPLL: 0    */
        /* Frequency modulation for PLL: Disabled    */
        /* The Increment Step for FMPLL: 0    */



/* ----------------------------------------------------------- */
/*                    System Clock Setup  (PLL0)                 */
/* ----------------------------------------------------------- */


/* ----------------   PLL Configuration  ------------------- */

    ME.DRUN.R = 0x001F00F0;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: Enabled    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL(PLL1): ON    */
        /* System PLL(PLL0): ON    */
        /* Crystal Oscillator: ON    */
        /* 16MHz IRC: ON    */
        /* System Clock Source:16MHz Internal RC     */

        /* Re-enter in DRUN mode to update the configuration */
    ME.MCTL.R = 0x30005AF0;    
        /* Mode & Key */
    ME.MCTL.R = 0x3000A50F;    
        /* Mode & Key  Inverted  */
    while(0x1 == ME.GS.B.S_MTRANS){};    
        /* Wait for mode entry to complete  */
    while(0x3 != ME.GS.B.S_CURRENTMODE){};    
        /* Check DRUN mode has been entered  */

        /* Wait for PLL to lock - will not lock before DRUN Re-entry  */
    while(0x0 == CGM.FMPLL[0].CR.B.S_LOCK){};    

    ME.DRUN.R = 0x001F00F4;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: Enabled    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL (PLL1): ON    */
        /* System PLL (PLL0): ON    */
        /* Crystal Oscillator: ON    */
        /* 16MHz IRC: ON    */
        /* System Clock Source: System PLL    */

        /* Re-enter in DRUN mode to update the configuration */
    ME.MCTL.R = 0x30005AF0;    
        /* Mode & Key */
    ME.MCTL.R = 0x3000A50F;    
        /* Mode & Key  Inverted  */
    while(0x1 == ME.GS.B.S_MTRANS){};    
        /* Wait for mode entry to complete  */
    while(0x3 != ME.GS.B.S_CURRENTMODE){};    
        /* Check DRUN mode has been entered  */

        /* Poll Global Status Register to get current System Clock  */
    while(0x4 != ME.GS.B.S_SYSCLK){};    
        /* Fail is stuck here  */


/* ----------------------------------------------------------- */
/*          Activate the clock Configuration              */
/* -----------------------------------------------------------  */

    ME.MCTL.R = ((ME.GS.B.S_CURRENTMODE << 28) | 0x00005AF0);    
    ME.MCTL.R = ((ME.GS.B.S_CURRENTMODE << 28) | 0x0000A50F);    

/* ----------------------------------------------------------- */
/*                    System Output Clock Setup                 */
/* ----------------------------------------------------------- */

    CGM.OCDSSC.R = 0x00000000;    
        /* Clock Divider: 1 */
        /* Output Clock Source: 16MHz Internal RC oscillator */
    CGM.OCEN.B.EN = 0x0;    
        /* Output Clock: Disabled */


/* ----------------------------------------------------------- */
/*          Auxiliary Clock Setup              */
/* -----------------------------------------------------------  */

/* -------------------Auxiliary Clock 0------------------------  */

    CGM.AC0SC.R = 0x00000000;
        /*Auxiliary Clock 0 Source: 16MHz Internal RC Oscillator*/
    CGM.AC0DC.B.DIV0 = 0x0;
        /* FlexPWM Clock Divider Value: 1    */

/* -------------------Auxiliary Clock 1------------------------  */

    CGM.AC1SC.R = 0x00000000;
        /* Auxiliary Clock 1 Source: Secondary PLL(PLL1)    */
    CGM.AC1DC.B.DIV0 = 0x0;
        /* CMU1 Monitored Clock Divider Value: 1    */

/* -------------------Auxiliary Clock 2------------------------ */

    CGM.AC2SC.R = 0x00000000;
        /* Auxiliary Clock 2 Source:16MHz Internal RC Oscillator    */
    CGM.AC2DC.B.DIV0 = 0x0;
        /* Safety Port Clock Divider Value: 1    */

/* -------------------Auxiliary Clock 3------------------------ */

    CGM.AC3SC.R = 0x02000000;
        /* Auxiliary Clock 3 Source:Crystal Oscillator    */
    CGM.AC3DC.B.DIV0 = 0x0;
        /* FlexRay Clock Divider Value: 1    */
}

void cmu_init_fnc(void)
{

/*-----------------------CMU 0 Setup------------------------*/

    CGM.CMU_0_MDR.R = 0x00000000;
        /* IRC Measurement Duration in IRC Clock Cycles: 0 */

    CGM.CMU_0_HFREFR_A.R = 0x00000FFF;
        /* High Frequency Reference Value for FMPLL0: 1023.75MHz */

    CGM.CMU_0_LFREFR_A.R = 0x00000000;
        /* Low Frequency Reference Value for FMPLL0: 0.0MHz */

    CGM.CMU_0_CSR.R = 0x00000006;
        /* RC Oscillator to be calibrated by Frequency Meter: 16MHz IRC*/
        /* RC Clock Division factor: 8 */
        /* Clock Monitoring Unit 0: Disable */

/*-----------------------CMU 1 Setup------------------------*/

    CGM.CMU_1_HFREFR_A.R = 0x00000FFF;
        /* High Frequency Reference Value for FMPLL1: 1023.75MHz */

    CGM.CMU_1_LFREFR_A.R = 0x00000000;
        /* Low Frequency Reference Value for FMPLL1: 0.0MHz */

    CGM.CMU_1_CSR.R = 0x00000000;
        /* Clock Monitoring Unit 1: Disable */

}

void mode_entry_post_config_fnc(void)
{
/* ----------------------------------------------------------- */
/*              Peripheral RUN Mode Configuration            */
/* ----------------------------------------------------------- */

    ME.RUNPC[0].R = 0x000000FE;
        /* Peripheral Operation in RUN3  mode: Enabled    */
        /* Peripheral Operation in RUN2  mode: Enabled    */
        /* Peripheral Operation in RUN1  mode: Enabled    */
        /* Peripheral Operation in RUN0  mode: Enabled    */
        /* Peripheral Operation in DRUN  mode: Enabled    */
        /* Peripheral Operation in SAFE  mode: Enabled    */
        /* Peripheral Operation in TEST  mode: Enabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[1].R = 0x00000000;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[2].R = 0x00000000;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[3].R = 0x00000000;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */


    ME.RUNPC[4].R = 0x00000000;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[5].R = 0x00000000;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[6].R = 0x00000000;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */

    ME.RUNPC[7].R = 0x00000000;
        /* Peripheral Operation in RUN3  mode: Disabled    */
        /* Peripheral Operation in RUN2  mode: Disabled    */
        /* Peripheral Operation in RUN1  mode: Disabled    */
        /* Peripheral Operation in RUN0  mode: Disabled    */
        /* Peripheral Operation in DRUN  mode: Disabled    */
        /* Peripheral Operation in SAFE  mode: Disabled    */
        /* Peripheral Operation in TEST  mode: Disabled    */
        /* Peripheral Operation in RESET  mode: Disabled    */


/* ----------------------------------------------------------- */
/*      DRUN  Clock & Auxiliary Clock Divider Settings    */
/* ----------------------------------------------------------- */

    ME.DRUN.R = 0x001F0074;
        /* I/O Power Down Control: Disabled    */
        /* Main Voltage Regulator Control: Enabled    */
        /* Data Flash Power Down Control: Normal    */
        /* Code Flash Power Down Control: Normal    */
        /* Secondary PLL (PLL1): OFF    */
        /* System PLL (PLL0): ON    */
        /* Crystal Oscillator: ON    */
        /* 16MHz IRC:  ON    */
        /* System Clock Source: System PLL    */

    CGM.AC0DC.B.DE0 = 0x1;
            /* FlexPWM Clock (Aux Clock 0 Divider):  Enabled */
    CGM.AC1DC.B.DE0 = 0x1;
            /* CMU1 Monitored Clock(Aux Clock 1 Divider): Enabled */
    CGM.AC2DC.B.DE0 = 0x1;
            /* Safety Port Clock(Aux Clock 2 Divider): Enabled */
    CGM.AC3DC.B.DE0 = 0x0;
            /* FlexRay Clock(Aux Clock 3 Divider): Disabled */

/* ----------------------------------------------------------- */
/*                     DRUN Re-Entry                    */
/* ----------------------------------------------------------- */

        /* Re-enter in DRUN mode to update the configuration */
    ME.MCTL.R = 0x30005AF0;    
        /* Mode & Key */
    ME.MCTL.R = 0x3000A50F;    
        /* Mode & Key  Inverted */
    while(0x1 == ME.GS.B.S_MTRANS){};    
        /* Wait for mode entry to complete */
    while(0x3 != ME.GS.B.S_CURRENTMODE){};    
        /* Check DRUN mode has been entered  */
}
 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

