/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : swt_init.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : SWT Initialization file
 *
 ******************************************************************************** 
 *
 * Detail Description     : This file contains Software Watchdog Timer (SWT) parameter
 *                          initialization function.The function configures SWT parameters
 *                          such as watchdog status, watchdog timeout, debug mode control,
 *                          sleep mode control, window mode status & window value. Also,
 *                          the file has a function for Watchdog Service Routine.
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "swt_init.h"




/********************* Initialization Function(s) *********************** */


void swt_init_fnc(void)
{

    vint32_t init_status=0;
    uint32_t delay=100;
        /*check whether the Hardware is enabled or not    */

    if(1 != SWT.CR.B.HLK)    
    {
        SWT.SR.B.WSC = 0xC520;    
        SWT.SR.B.WSC = 0xD928;    
            /* Disable Software lock of register by writing sequence register with unlock data     */


        while((1 == SWT.CR.B.SLK) && (0 < (delay--))){}    
            /* Wait until Soft-Lock is disabled     */

            if(1 != SWT.CR.B.SLK)    
            {    
                /* Proceed with initialization    */
                init_status = 0;    
            }    
            else    
            {    
                init_status = 1;    
                    /* SWT initialization cannot be proceed as software lock is still enabled     */
            }    
    }    
    else
    {    
        init_status = 1;    
            /* SWT initialization cannot be proceed as Hardware lock is still enabled */
    
    }
    if(0 == init_status)
    {
        SWT.CR.B.WEN = 0;
            /* Software Watchdog Timer: Disabled */
    
        SWT.TO.R = 0x500;    
            /* Software Watchdog Timer timeout is 0.08ms    */

        SWT.WN.R = 0x0;    
            /* Service Sequence Window Time: 0ms */

        SWT.CR.R = 0x8000010A;
            /* Master Access Control for Master 0: Enabled */
            /* Service Sequence: Fixed Service Sequence */
            /* SWT Reset on Invalid Access: Enabled */
            /* SWT Window Mode: Disabled */
            /* SWT Interrupt Then Reset: Disabled */
            /* SWT Hard Lock: Disabled */
            /* SWT Soft Lock: Disabled */
            /* SWT Clock Source Selected: 16MHz IRC*/
            /* SWT Stop Mode Control: Disabled */
            /* SWT Debug Mode Control: Enabled */
            /* Software Watchdog Timer: Disabled */

    }
}

/********************* SWT Service Sequence Function *********************** */

void swt_srvc_seq_fnc(void)
{
    uint32_t u32ServiceKey1,u32ServiceKey2;

    if(1 == SWT.CR.B.KEY)
    {
        SWT.SR.B.WSC = 0xC520;
        SWT.SR.B.WSC = 0xD928;
            /* Disable SWT Soft Lock */

        /* Generate the service keys as per Pseudorandom Key Generator */
        /* SKn+1 = (17*SKn + 3) MOD 2^16 */
        u32ServiceKey1 = ((SWT.SK.R * 17) + 3) % (65536);
        u32ServiceKey2 = ((u32ServiceKey1 * 17) + 3) % (65536);
        SWT.SR.B.WSC = u32ServiceKey1;
        SWT.SR.B.WSC = u32ServiceKey2;
            /* Service the SWT */
        SWT.SK.R = u32ServiceKey2;
            /* Update the SWT_SK register with a new Key */
    }
    else
    {
        /* Service keys as per fixed sequence */
        SWT.SR.B.WSC = 0xA602;
        SWT.SR.B.WSC = 0xB480;
    }
}


 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

