/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : stm_init.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : STM Initialization file
 *
 ******************************************************************************** 
 *
 * Detail Description     : This file contains definition for System Timer Module (STM)
 *                          initialization function.The function configures STM parameters
 *                          such as STM module status, Counter pre-scalar, Individual
 *                          Channel status & compare value.
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "stm_init.h"




/********************* Initialization Function(s) *********************** */


void stm_init_fnc(void)
{

    STM.CR0.B.TEN = 0x0 ;    
        /* Disable System Timer Module for initialization          */

/* ----------------------------------------------------------- */
/*                     Configure Counter Prescaler                */
/* ----------------------------------------------------------- */

    STM.CR0.B.CPS = 0 ;    
        /* Counter Prescaler is 1        */

/* ----------------------------------------------------------- */
/*                     Configure System Timer Registers                */
/* ----------------------------------------------------------- */

    STM.CMP0.R =0x00000000 ;    
        /* System Timer Channel 0's Compare value is :0    */
    
    STM.CCR0.B.CEN =0x0 ;    
        /* System Timer Channel 0: Disabled    */
    
    STM.CMP1.R =0x00000000 ;    
        /* System Timer Channel 1's Compare value is :0    */
    
    STM.CCR1.B.CEN =0x0 ;    
        /* System Timer Channel 1: Disabled    */
    
    STM.CMP2.R =0x00000000 ;    
        /* System Timer Channel 2's Compare value is :0    */
    
    STM.CCR2.B.CEN =0x0 ;    
        /* System Timer Channel 2: Disabled    */
    
    STM.CMP3.R =0x00000000 ;    
        /* System Timer Channel 3's Compare value is :0    */
    
    STM.CCR3.B.CEN =0x0 ;    
        /* System Timer Channel 3: Disabled    */
    


    STM.CR0.B.TEN = 0 ;    
        /* System Timer Module is:  Disabled        */

}

 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

