/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : siu_init.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : This file contains Pads, external Interrupts and Wakeups configuration
 *
 ******************************************************************************** 
 *
 * Detail Description     : This File contains function for peripheral assignment for each
 *                          pads, External Interrupt configuration, Wakeup configuration
 *                          and Trigger configuration. It also handles Port parallel masking.
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "rappid_ref.h"
#include "siu_init.h"




/* ----------------------------------------------------------- */
/*	                SIU Initialization                         */
/* ----------------------------------------------------------- */
void siu_init_fnc(void)
{
    siu_portA_init_fnc();
    siu_portB_init_fnc();
    siu_portC_init_fnc();
    siu_portD_init_fnc();
    siu_portE_init_fnc();
    siu_portF_init_fnc();
    siu_portG_init_fnc();
    siu_general_init_fnc();
    siu_parallel_port_init_fnc();
    siu_unused_pins_init_fnc();
    siu_psmi_init_fnc();
}


/* ----------------------------------------------------------- */
/*                 SIU PORT A PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_portA_init_fnc(void)
{
    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[0]  ETC_0[0]_SCK_2_FCU[0]_PA[0] (73) */
    /* ----------------------------------------------------------- */
       SIU.PCR[0].R = 0x0100;
             /* Selected Function : PA[0] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[1]  ETC_0[1]_SOUT_2_FCU[1]_PA[1] (74) */
    /* ----------------------------------------------------------- */
       SIU.PCR[1].R = 0x0100;
             /* Selected Function : PA[1] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[2]  ETC_0[2]_SIN_2_PWM_A[3]_PA[2] (84) */
    /* ----------------------------------------------------------- */
       SIU.PCR[2].R = 0x0100;
             /* Selected Function : PA[2] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[3]  ETC_0[3]_CS0_2_PWM_B[3]_PA[3] (92) */
    /* ----------------------------------------------------------- */
       SIU.PCR[3].R = 0x0100;
             /* Selected Function : PA[3] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[4]  ETC_1[0]_CS1_2_ETC_0[4]_PA[4] (108) */
    /* ----------------------------------------------------------- */
       SIU.PCR[4].R = 0x0100;
             /* Selected Function : PA[4] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[5]  CS0_1_ETC_1[5]_CS7_0_PA[5] (14) */
    /* ----------------------------------------------------------- */
       SIU.PCR[5].R = 0x0100;
             /* Selected Function : PA[5] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[6]  SCK_1_PA[6] (2) */
    /* ----------------------------------------------------------- */
       SIU.PCR[6].R = 0x0100;
             /* Selected Function : PA[6] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[7]  SOUT_1_PA[7] (10) */
    /* ----------------------------------------------------------- */
       SIU.PCR[7].R = 0x0100;
             /* Selected Function : PA[7] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[8]  SIN_1_PA[8] (12) */
    /* ----------------------------------------------------------- */
       SIU.PCR[8].R = 0x0100;
             /* Selected Function : PA[8] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[9]  CS1_2_FAULT[0]_PWM_B[3]_PA[9] (134) */
    /* ----------------------------------------------------------- */
       SIU.PCR[9].R = 0x0100;
             /* Selected Function : PA[9] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[10]  CS0_2_PWM_B[0]_PWM_X[2]_PA[10] (118) */
    /* ----------------------------------------------------------- */
       SIU.PCR[10].R = 0x0100;
             /* Selected Function : PA[10] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[11]  SCK_2_PWM_A[0]_PWM_A[2]_PA[11] (120) */
    /* ----------------------------------------------------------- */
       SIU.PCR[11].R = 0x0100;
             /* Selected Function : PA[11] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[12]  SOUT_2_PWM_A[2]_PWM_B[2]_PA[12] (122) */
    /* ----------------------------------------------------------- */
       SIU.PCR[12].R = 0x0100;
             /* Selected Function : PA[12] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[13]  SIN_2_PWM_B[2]_FAULT[0]_PA[13] (136) */
    /* ----------------------------------------------------------- */
       SIU.PCR[13].R = 0x0100;
             /* Selected Function : PA[13] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[14]  SP_TXD_ETC_1[4]_PA[14] (143) */
    /* ----------------------------------------------------------- */
       SIU.PCR[14].R = 0x0100;
             /* Selected Function : PA[14] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[15]  SP_RXD_ETC_1[4]_PA[15] (144) */
    /* ----------------------------------------------------------- */
       SIU.PCR[15].R = 0x0100;
             /* Selected Function : PA[15] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

}


/* ----------------------------------------------------------- */
/*                 SIU PORT B PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_portB_init_fnc(void)
{
    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[16]  CNTXD_0_ETC_1[2]_DEBUG[0]_PB[0] (109) */
    /* ----------------------------------------------------------- */
       SIU.PCR[16].R = 0x0600;
             /* User Assigned Signal Name : PB0_CAN0_TX  */
             /* Selected Function : CNTXD_0        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[17]  CNRXD_0_ETC_1[3]_DEBUG[1]_PB[1] (110) */
    /* ----------------------------------------------------------- */
       SIU.PCR[17].R = 0x0100;
             /* User Assigned Signal Name : PB1_CAN0_RX  */
             /* Selected Function : PB[1] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[18]  LIN_TXD_0_DEBUG[2]_PB[2] (114) */
    /* ----------------------------------------------------------- */
       SIU.PCR[18].R = 0x0600;
             /* User Assigned Signal Name : PB2_UART_TX  */
             /* Selected Function : LIN_TXD_0        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[19]  LIN_RXD_0_DEBUG[3]_PB[3] (116) */
    /* ----------------------------------------------------------- */
       SIU.PCR[19].R = 0x0100;
             /* User Assigned Signal Name : PB3_UART_RX  */
             /* Selected Function : PB[3] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[20]  TDO/TDOC_PB[4] (89) */
    /* ----------------------------------------------------------- */
       SIU.PCR[20].R = 0x0100;
             /* Selected Function : PB[4] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[21]  TDI/TDIC_PB[5] (86) */
    /* ----------------------------------------------------------- */
       SIU.PCR[21].R = 0x0100;
             /* Selected Function : PB[5] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[22]  CLKOUT_CS2_2_PB[6] (138) */
    /* ----------------------------------------------------------- */
       SIU.PCR[22].R = 0x0100;
             /* Selected Function : PB[6] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[23]  AN_0[0]_LIN_RXD_0_PB[7] (43) */
    /* ----------------------------------------------------------- */
       SIU.PCR[23].R = 0x0100;
             /* Selected Function : PB[7]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[24]  AN_0[1]_ETC_0[5] I_PB[8] (47) */
    /* ----------------------------------------------------------- */
       SIU.PCR[24].R = 0x0100;
             /* Selected Function : PB[8]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[25]  AN[11]_PB[9] (52) */
    /* ----------------------------------------------------------- */
       SIU.PCR[25].R = 0x0100;
             /* Selected Function : PB[9]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[26]  AN[12]_PB[10] (53) */
    /* ----------------------------------------------------------- */
       SIU.PCR[26].R = 0x0100;
             /* Selected Function : PB[10]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[27]  AN[13]_PB[11] (54) */
    /* ----------------------------------------------------------- */
       SIU.PCR[27].R = 0x0100;
             /* Selected Function : PB[11]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[28]  AN[14]_PB[12] (55) */
    /* ----------------------------------------------------------- */
       SIU.PCR[28].R = 0x0100;
             /* Selected Function : PB[12]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[29]  AN_1[0]_LIN_RXD_1_PB[13] (60) */
    /* ----------------------------------------------------------- */
       SIU.PCR[29].R = 0x0100;
             /* Selected Function : PB[13]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[30]  AN_1[1]_ETC_0[4] I_PB[14] (64) */
    /* ----------------------------------------------------------- */
       SIU.PCR[30].R = 0x0100;
             /* Selected Function : PB[14]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[31]  AN_1[2]_PB[15] (62) */
    /* ----------------------------------------------------------- */
       SIU.PCR[31].R = 0x0100;
             /* Selected Function : PB[15]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

}


/* ----------------------------------------------------------- */
/*                 SIU PORT C PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_portC_init_fnc(void)
{
    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[32]  AN_1[3]_PC[0] (66) */
    /* ----------------------------------------------------------- */
       SIU.PCR[32].R = 0x0100;
             /* Selected Function : PC[0]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[33]  AN_0[2]_PC[1] (41) */
    /* ----------------------------------------------------------- */
       SIU.PCR[33].R = 0x0100;
             /* Selected Function : PC[1]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[34]  AN_0[3]_PC[2] (45) */
    /* ----------------------------------------------------------- */
       SIU.PCR[34].R = 0x0100;
             /* Selected Function : PC[2]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[35]  CS1_0_ETC_1[4]_LIN_TXD_1_PC[3] (16) */
    /* ----------------------------------------------------------- */
       SIU.PCR[35].R = 0x0100;
             /* Selected Function : PC[3] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[36]  CS0_0_PWM_X[1]_DEBUG[4]_PC[4] (11) */
    /* ----------------------------------------------------------- */
       SIU.PCR[36].R = 0x0600;
             /* User Assigned Signal Name : PC4_DSPI0_CS0_Output  */
             /* Selected Function : CS0_0 O        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[37]  SCK_0_FAULT[3]_DEBUG[5]_PC[5] (13) */
    /* ----------------------------------------------------------- */
       SIU.PCR[37].R = 0x0600;
             /* User Assigned Signal Name : PC5_DSPI0_CLK_Output  */
             /* Selected Function : SCK_0 O        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[38]  SOUT_0_PWM_B[1]_DEBUG[6]_PC[6] (142) */
    /* ----------------------------------------------------------- */
       SIU.PCR[38].R = 0x0600;
             /* User Assigned Signal Name : PC6_DSPI0_Data_Output  */
             /* Selected Function : SOUT_0        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[39]  SIN_0_PWM_A[1]_DEBUG[7]_PC[7] (15) */
    /* ----------------------------------------------------------- */
       SIU.PCR[39].R = 0x0100;
             /* User Assigned Signal Name : PC7_DSPI0_Data_Input  */
             /* Selected Function : PC[7] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[40]  CS1_1_FAULT[2]_CS6_0_PC[8] (130) */
    /* ----------------------------------------------------------- */
       SIU.PCR[40].R = 0x0100;
             /* Selected Function : PC[8] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[41]  CS3_2_FAULT[2]_PWM_X[3]_PC[9] (123) */
    /* ----------------------------------------------------------- */
       SIU.PCR[41].R = 0x0100;
             /* Selected Function : PC[9] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[42]  CS2_2_FAULT[1]_PWM_A[3]_PC[10] (111) */
    /* ----------------------------------------------------------- */
       SIU.PCR[42].R = 0x0100;
             /* Selected Function : PC[10] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[43]  ETC_0[4]_CS2_2_CS0_3_PC[11] (80) */
    /* ----------------------------------------------------------- */
       SIU.PCR[43].R = 0x0100;
             /* Selected Function : PC[11] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[44]  ETC_0[5]_CS3_2_CS1_3_PC[12] (82) */
    /* ----------------------------------------------------------- */
       SIU.PCR[44].R = 0x0100;
             /* Selected Function : PC[12] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[45]  ETC_1[1]_EXT_IN_EXT_SYNC_PC[13] (101) */
    /* ----------------------------------------------------------- */
       SIU.PCR[45].R = 0x0100;
             /* Selected Function : PC[13] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[46]  ETC_1[2]_EXT_TGR_PC[14] (103) */
    /* ----------------------------------------------------------- */
       SIU.PCR[46].R = 0x0100;
             /* Selected Function : PC[14] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[47]  CA_TR_EN_ETC_1[0]_PWM_A[1]_EXT_IN_EXT_SYNC_PC[15] (124) */
    /* ----------------------------------------------------------- */
       SIU.PCR[47].R = 0x0100;
             /* Selected Function : PC[15] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

}


/* ----------------------------------------------------------- */
/*                 SIU PORT D PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_portD_init_fnc(void)
{
    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[48]  CA_TX_ETC_1[1]_PWM_B[1]_PD[0] (125) */
    /* ----------------------------------------------------------- */
       SIU.PCR[48].R = 0x0100;
             /* Selected Function : PD[0] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[49]  CA_RX_ETC_1[2]_EXT_TGR_PD[1] (3) */
    /* ----------------------------------------------------------- */
       SIU.PCR[49].R = 0x0100;
             /* Selected Function : PD[1] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[50]  CB_RX_ETC_1[3]_PWM_X[3]_PD[2] (140) */
    /* ----------------------------------------------------------- */
       SIU.PCR[50].R = 0x0100;
             /* User Assigned Signal Name : PD2_Switch_Input  */
             /* Selected Function : PD[2] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[51]  CB_TX_ETC_1[4]_PWM_A[3]_PD[3] (128) */
    /* ----------------------------------------------------------- */
       SIU.PCR[51].R = 0x0100;
             /* Selected Function : PD[3] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[52]  CB_TR_EN_ETC_1[5]_PWM_B[3]_PD[4] (129) */
    /* ----------------------------------------------------------- */
       SIU.PCR[52].R = 0x0200;
             /* User Assigned Signal Name : PD4_LED1_Output  */
             /* Selected Function : PD[4] O        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[53]  CS3_0_FCU[0]_SOUT_3_PD[5] (33) */
    /* ----------------------------------------------------------- */
       SIU.PCR[53].R = 0x0200;
             /* User Assigned Signal Name : PD5_LED2_Output  */
             /* Selected Function : PD[5] O        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[54]  CS2_0_SCK_3_FAULT[1]_PD[6] (34) */
    /* ----------------------------------------------------------- */
       SIU.PCR[54].R = 0x0200;
             /* User Assigned Signal Name : PD6_LED3_Output  */
             /* Selected Function : PD[6] O        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[55]  CS3_1_FCU[1]_CS4_0_SIN_3_PD[7] (37) */
    /* ----------------------------------------------------------- */
       SIU.PCR[55].R = 0x0200;
             /* User Assigned Signal Name : PD7_LED4_Output  */
             /* Selected Function : PD[7] O        */
             /* Output Buffers : Enabled          */
             /* Input Buffers : Disabled          */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[56]  CS2_1_FAULT[3]_CS5_0_PD[8] (32) */
    /* ----------------------------------------------------------- */
       SIU.PCR[56].R = 0x0100;
             /* Selected Function : PD[8] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[57]  PWM_X[0]_LIN_TXD_1_PD[9] (26) */
    /* ----------------------------------------------------------- */
       SIU.PCR[57].R = 0x0100;
             /* Selected Function : PD[9] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[58]  PWM_A[0]_CS0_3_PD[10] (76) */
    /* ----------------------------------------------------------- */
       SIU.PCR[58].R = 0x0100;
             /* Selected Function : PD[10] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[59]  PWM_B[0]_CS1_3_SCK_3_PD[11] (78) */
    /* ----------------------------------------------------------- */
       SIU.PCR[59].R = 0x0100;
             /* Selected Function : PD[11] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[60]  PWM_X[1]_LIN_RXD_1_PD[12] (99) */
    /* ----------------------------------------------------------- */
       SIU.PCR[60].R = 0x0100;
             /* Selected Function : PD[12] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[61]  PWM_A[1]_CS2_3_SOUT_3_PD[13] (95) */
    /* ----------------------------------------------------------- */
       SIU.PCR[61].R = 0x0100;
             /* Selected Function : PD[13] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[62]  PWM_B[1]_CS3_3_SIN_3_PD[14] (105) */
    /* ----------------------------------------------------------- */
       SIU.PCR[62].R = 0x0100;
             /* Selected Function : PD[14] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[63]  AN_1[4]_PD[15] (58) */
    /* ----------------------------------------------------------- */
       SIU.PCR[63].R = 0x0100;
             /* Selected Function : PD[15]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

}


/* ----------------------------------------------------------- */
/*                 SIU PORT E PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_portE_init_fnc(void)
{
    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[64]  AN_1[5]_PE[0] (68) */
    /* ----------------------------------------------------------- */
       SIU.PCR[64].R = 0x2000;
             /* User Assigned Signal Name : ADC1_Ch5_Potentiometer_Input  */
             /* Selected Function : AN_1[5]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Disabled          */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Enabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[65]  AN_0[4]_PE[1] (39) */
    /* ----------------------------------------------------------- */
       SIU.PCR[65].R = 0x0100;
             /* Selected Function : PE[1]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[66]  AN_0[5]_PE[2] (49) */
    /* ----------------------------------------------------------- */
       SIU.PCR[66].R = 0x0100;
             /* Selected Function : PE[2]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[67]  AN_0[6]_PE[3] (40) */
    /* ----------------------------------------------------------- */
       SIU.PCR[67].R = 0x0100;
             /* Selected Function : PE[3]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[68]  AN_0[7]_PE[4] (42) */
    /* ----------------------------------------------------------- */
       SIU.PCR[68].R = 0x0100;
             /* Selected Function : PE[4]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[69]  AN_0[8]_PE[5] (44) */
    /* ----------------------------------------------------------- */
       SIU.PCR[69].R = 0x0100;
             /* Selected Function : PE[5]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[70]  AN_0[9]_PE[6] (46) */
    /* ----------------------------------------------------------- */
       SIU.PCR[70].R = 0x0100;
             /* Selected Function : PE[6]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[71]  AN_0[10]_PE[7] (48) */
    /* ----------------------------------------------------------- */
       SIU.PCR[71].R = 0x0100;
             /* Selected Function : PE[7]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[72]  AN_1[6]_PE[8] (59) */
    /* ----------------------------------------------------------- */
       SIU.PCR[72].R = 0x0100;
             /* Selected Function : PE[8]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[73]  AN_1[7]_PE[9] (61) */
    /* ----------------------------------------------------------- */
       SIU.PCR[73].R = 0x0100;
             /* Selected Function : PE[9]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[74]  AN_1[8]_PE[10] (63) */
    /* ----------------------------------------------------------- */
       SIU.PCR[74].R = 0x0100;
             /* Selected Function : PE[10]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[75]  AN_1[9]_PE[11] (65) */
    /* ----------------------------------------------------------- */
       SIU.PCR[75].R = 0x0100;
             /* Selected Function : PE[11]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[76]  AN_1[10]_PE[12] (67) */
    /* ----------------------------------------------------------- */
       SIU.PCR[76].R = 0x0100;
             /* Selected Function : PE[12]        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */
             /* Safe Mode Control: Disabled   */
             /* Analog Pad Switch : Disabled   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[77]  SCK_3_PE[13] (117) */
    /* ----------------------------------------------------------- */
       SIU.PCR[77].R = 0x0100;
             /* Selected Function : PE[13] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[78]  SOUT_3_PE[14]  (119) */
    /* ----------------------------------------------------------- */
       SIU.PCR[78].R = 0x0100;
             /* Selected Function : PE[14]  I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[79]  SIN_3_PE[15] (121) */
    /* ----------------------------------------------------------- */
       SIU.PCR[79].R = 0x0100;
             /* Selected Function : PE[15] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

}


/* ----------------------------------------------------------- */
/*                 SIU PORT F PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_portF_init_fnc(void)
{
    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[80]  DBG0_CS3_3_PF[0] (133) */
    /* ----------------------------------------------------------- */
       SIU.PCR[80].R = 0x0100;
             /* Selected Function : PF[0] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[81]  DBG1_CS2_3_PF[1] (135) */
    /* ----------------------------------------------------------- */
       SIU.PCR[81].R = 0x0100;
             /* Selected Function : PF[1] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[82]  DBG2_CS1_3_PF[2] (137) */
    /* ----------------------------------------------------------- */
       SIU.PCR[82].R = 0x0100;
             /* Selected Function : PF[2] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[83]  DBG3_CS0_3_PF[3]  (139) */
    /* ----------------------------------------------------------- */
       SIU.PCR[83].R = 0x0100;
             /* Selected Function : PF[3]  I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[84]  MDO[3]_PF[4] (4) */
    /* ----------------------------------------------------------- */
       SIU.PCR[84].R = 0x0100;
             /* Selected Function : PF[4] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[85]  MDO[2]_PF[5]  (5) */
    /* ----------------------------------------------------------- */
       SIU.PCR[85].R = 0x0100;
             /* Selected Function : PF[5]  I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[86]  MDO[1]_PF[6] (8) */
    /* ----------------------------------------------------------- */
       SIU.PCR[86].R = 0x0100;
             /* Selected Function : PF[6] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[87]  MCKO_PF[7] (19) */
    /* ----------------------------------------------------------- */
       SIU.PCR[87].R = 0x0100;
             /* Selected Function : PF[7] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[88]  MSEO1_PF[8] (20) */
    /* ----------------------------------------------------------- */
       SIU.PCR[88].R = 0x0100;
             /* Selected Function : PF[8] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[89]  MSEO0_PF[9] (23) */
    /* ----------------------------------------------------------- */
       SIU.PCR[89].R = 0x0100;
             /* Selected Function : PF[9] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[90]  EVTO_PF[10] (24) */
    /* ----------------------------------------------------------- */
       SIU.PCR[90].R = 0x0100;
             /* Selected Function : PF[10] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[91]  EVTI_PF[11] (25) */
    /* ----------------------------------------------------------- */
       SIU.PCR[91].R = 0x0100;
             /* Selected Function : PF[11] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[92]  ETC_1[3]_PF[12]  (106) */
    /* ----------------------------------------------------------- */
       SIU.PCR[92].R = 0x0100;
             /* Selected Function : PF[12]  I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[93]  ETC_1[4]_PF[13] (112) */
    /* ----------------------------------------------------------- */
       SIU.PCR[93].R = 0x0100;
             /* Selected Function : PF[13] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[94]  LIN_TXD_1_PF[14] (115) */
    /* ----------------------------------------------------------- */
       SIU.PCR[94].R = 0x0100;
             /* Selected Function : PF[14] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[95]  LIN_RXD_1_PF[15] (113) */
    /* ----------------------------------------------------------- */
       SIU.PCR[95].R = 0x0100;
             /* Selected Function : PF[15] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

}


/* ----------------------------------------------------------- */
/*                 SIU PORT G PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_portG_init_fnc(void)
{
    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[96]  FCU[0]_PG[0] (38) */
    /* ----------------------------------------------------------- */
       SIU.PCR[96].R = 0x0100;
             /* Selected Function : PG[0] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[97]  FCU[1]_PG[1] (141) */
    /* ----------------------------------------------------------- */
       SIU.PCR[97].R = 0x0100;
             /* Selected Function : PG[1] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[98]  PWM_X[2]_PG[2] (102) */
    /* ----------------------------------------------------------- */
       SIU.PCR[98].R = 0x0100;
             /* Selected Function : PG[2] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[99]  PWM_A[2]_PG[3] (104) */
    /* ----------------------------------------------------------- */
       SIU.PCR[99].R = 0x0100;
             /* Selected Function : PG[3] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[100]  PWM_B[2]_PG[4] (100) */
    /* ----------------------------------------------------------- */
       SIU.PCR[100].R = 0x0100;
             /* Selected Function : PG[4] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[101]  PWM_X[3]_PG[5] (85) */
    /* ----------------------------------------------------------- */
       SIU.PCR[101].R = 0x0100;
             /* Selected Function : PG[5] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[102]  PWM_A[3]_PG[6] (98) */
    /* ----------------------------------------------------------- */
       SIU.PCR[102].R = 0x0100;
             /* Selected Function : PG[6] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[103]  PWM_B[3]_PG[7] (83) */
    /* ----------------------------------------------------------- */
       SIU.PCR[103].R = 0x0100;
             /* Selected Function : PG[7] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[104]  FAULT[0]_PG[8] (81) */
    /* ----------------------------------------------------------- */
       SIU.PCR[104].R = 0x0100;
             /* Selected Function : PG[8] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[105]  FAULT[1]_PG[9] (79) */
    /* ----------------------------------------------------------- */
       SIU.PCR[105].R = 0x0100;
             /* Selected Function : PG[9] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[106]  FAULT[2]_PG[10] (77) */
    /* ----------------------------------------------------------- */
       SIU.PCR[106].R = 0x0100;
             /* Selected Function : PG[10] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

    /* ----------------------------------------------------------- */
    /*      Pad Configuration Register PCR[107]  FAULT[3]_PG[11] (75) */
    /* ----------------------------------------------------------- */
       SIU.PCR[107].R = 0x0100;
             /* Selected Function : PG[11] I        */
             /* Output Buffers : Disabled         */
             /* Input Buffers : Enabled           */
             /* Output Drain : Disabled           */
             /* Slew Rate Control : Minimum       */
             /* Weak Pull Up/Down : Disabled      */
             /* Weak Pull Up/Down Select : Down   */

}


/* ----------------------------------------------------------- */
/*               SIU General PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_general_init_fnc(void)
{

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Clock Prescaler Register- IFCPR    */
    /* ----------------------------------------------------------- */
        SIU.IFCPR.R = 0x00000000;
 		    /* Filter Clock Prescalar:- 1     */

    /* ----------------------------------------------------------- */
    /*   Interrupt Request Enable Register- IRER    */
    /* ----------------------------------------------------------- */
        SIU.IRER.R = 0x00000000;
             /* Edge Trigger External Interrupt 0 Enable :-Disabled */
             /* Edge Trigger External Interrupt 1 Enable :-Disabled */
             /* Edge Trigger External Interrupt 2 Enable :-Disabled */
             /* Edge Trigger External Interrupt 3 Enable :-Disabled */
             /* Edge Trigger External Interrupt 4 Enable :-Disabled */
             /* Edge Trigger External Interrupt 5 Enable :-Disabled */
             /* Edge Trigger External Interrupt 6 Enable :-Disabled */
             /* Edge Trigger External Interrupt 7 Enable :-Disabled */
             /* Edge Trigger External Interrupt 8 Enable :-Disabled */
             /* Edge Trigger External Interrupt 9 Enable :-Disabled */
             /* Edge Trigger External Interrupt 10 Enable :-Disabled */
             /* Edge Trigger External Interrupt 11 Enable :-Disabled */
             /* Edge Trigger External Interrupt 12 Enable :-Disabled */
             /* Edge Trigger External Interrupt 13 Enable :-Disabled */
             /* Edge Trigger External Interrupt 14 Enable :-Disabled */
             /* Edge Trigger External Interrupt 15 Enable :-Disabled */
             /* Edge Trigger External Interrupt 16 Enable :-Disabled */
             /* Edge Trigger External Interrupt 17 Enable :-Disabled */
             /* Edge Trigger External Interrupt 18 Enable :-Disabled */
             /* Edge Trigger External Interrupt 19 Enable :-Disabled */
             /* Edge Trigger External Interrupt 20 Enable :-Disabled */
             /* Edge Trigger External Interrupt 21 Enable :-Disabled */
             /* Edge Trigger External Interrupt 22 Enable :-Disabled */
             /* Edge Trigger External Interrupt 23 Enable :-Disabled */
             /* Edge Trigger External Interrupt 24 Enable :-Disabled */
             /* Edge Trigger External Interrupt 25 Enable :-Disabled */
             /* Edge Trigger External Interrupt 26 Enable :-Disabled */
             /* Edge Trigger External Interrupt 27 Enable :-Disabled */
             /* Edge Trigger External Interrupt 28 Enable :-Disabled */
             /* Edge Trigger External Interrupt 29 Enable :-Disabled */
             /* Edge Trigger External Interrupt 30 Enable :-Disabled */
             /* Edge Trigger External Interrupt 31 Enable :-Disabled */

    /* ----------------------------------------------------------- */
    /*   External IRQ Rising-Edge Event Enable Register - IREER    */
    /* ----------------------------------------------------------- */
        SIU.IREER.R = 0x00000000;

             /* IRQ 0 Rising-Edge Event : Disabled */
             /* IRQ 1 Rising-Edge Event : Disabled */
             /* IRQ 2 Rising-Edge Event : Disabled */
             /* IRQ 3 Rising-Edge Event : Disabled */
             /* IRQ 4 Rising-Edge Event : Disabled */
             /* IRQ 5 Rising-Edge Event : Disabled */
             /* IRQ 6 Rising-Edge Event : Disabled */
             /* IRQ 7 Rising-Edge Event : Disabled */
             /* IRQ 8 Rising-Edge Event : Disabled */
             /* IRQ 9 Rising-Edge Event : Disabled */
             /* IRQ 10 Rising-Edge Event : Disabled */
             /* IRQ 11 Rising-Edge Event : Disabled */
             /* IRQ 12 Rising-Edge Event : Disabled */
             /* IRQ 13 Rising-Edge Event : Disabled */
             /* IRQ 14 Rising-Edge Event : Disabled */
             /* IRQ 15 Rising-Edge Event : Disabled */
             /* IRQ 16 Rising-Edge Event : Disabled */
             /* IRQ 17 Rising-Edge Event : Disabled */
             /* IRQ 18 Rising-Edge Event : Disabled */
             /* IRQ 19 Rising-Edge Event : Disabled */
             /* IRQ 20 Rising-Edge Event : Disabled */
             /* IRQ 21 Rising-Edge Event : Disabled */
             /* IRQ 22 Rising-Edge Event : Disabled */
             /* IRQ 23 Rising-Edge Event : Disabled */
             /* IRQ 24 Rising-Edge Event : Disabled */
             /* IRQ 25 Rising-Edge Event : Disabled */
             /* IRQ 26 Rising-Edge Event : Disabled */
             /* IRQ 27 Rising-Edge Event : Disabled */
             /* IRQ 28 Rising-Edge Event : Disabled */
             /* IRQ 29 Rising-Edge Event : Disabled */
             /* IRQ 30 Rising-Edge Event : Disabled */
             /* IRQ 31 Rising-Edge Event : Disabled */

    /* ----------------------------------------------------------- */
    /*   External IRQ Falling-Edge Event Enable Register - IFEER   */
    /* ----------------------------------------------------------- */
        SIU.IFEER.R = 0x00000000;

             /* IRQ 0 Falling-Edge Event : Disabled */
             /* IRQ 1 Falling-Edge Event : Disabled */
             /* IRQ 2 Falling-Edge Event : Disabled */
             /* IRQ 3 Falling-Edge Event : Disabled */
             /* IRQ 4 Falling-Edge Event : Disabled */
             /* IRQ 5 Falling-Edge Event : Disabled */
             /* IRQ 6 Falling-Edge Event : Disabled */
             /* IRQ 7 Falling-Edge Event : Disabled */
             /* IRQ 8 Falling-Edge Event : Disabled */
             /* IRQ 9 Falling-Edge Event : Disabled */
             /* IRQ 10 Falling-Edge Event : Disabled */
             /* IRQ 11 Falling-Edge Event : Disabled */
             /* IRQ 12 Falling-Edge Event : Disabled */
             /* IRQ 13 Falling-Edge Event : Disabled */
             /* IRQ 14 Falling-Edge Event : Disabled */
             /* IRQ 15 Falling-Edge Event : Disabled */
             /* IRQ 16 Falling-Edge Event : Disabled */
             /* IRQ 17 Falling-Edge Event : Disabled */
             /* IRQ 18 Falling-Edge Event : Disabled */
             /* IRQ 19 Falling-Edge Event : Disabled */
             /* IRQ 20 Falling-Edge Event : Disabled */
             /* IRQ 21 Falling-Edge Event : Disabled */
             /* IRQ 22 Falling-Edge Event : Disabled */
             /* IRQ 23 Falling-Edge Event : Disabled */
             /* IRQ 24 Falling-Edge Event : Disabled */
             /* IRQ 25 Falling-Edge Event : Disabled */
             /* IRQ 26 Falling-Edge Event : Disabled */
             /* IRQ 27 Falling-Edge Event : Disabled */
             /* IRQ 28 Falling-Edge Event : Disabled */
             /* IRQ 29 Falling-Edge Event : Disabled */
             /* IRQ 30 Falling-Edge Event : Disabled */
             /* IRQ 31 Falling-Edge Event : Disabled */

    /* ----------------------------------------------------------- */
    /*    Interrupt Filter Enable Register - IFER    */
    /* ----------------------------------------------------------- */
        SIU.IFER.R = 0x00000000;
             /* Analog glitch filter on External Input 0 Pad:- Disabled */
             /* Analog glitch filter on External Input 1 Pad:- Disabled */
             /* Analog glitch filter on External Input 2 Pad:- Disabled */
             /* Analog glitch filter on External Input 3 Pad:- Disabled */
             /* Analog glitch filter on External Input 4 Pad:- Disabled */
             /* Analog glitch filter on External Input 5 Pad:- Disabled */
             /* Analog glitch filter on External Input 6 Pad:- Disabled */
             /* Analog glitch filter on External Input 7 Pad:- Disabled */
             /* Analog glitch filter on External Input 8 Pad:- Disabled */
             /* Analog glitch filter on External Input 9 Pad:- Disabled */
             /* Analog glitch filter on External Input 10 Pad:- Disabled */
             /* Analog glitch filter on External Input 11 Pad:- Disabled */
             /* Analog glitch filter on External Input 12 Pad:- Disabled */
             /* Analog glitch filter on External Input 13 Pad:- Disabled */
             /* Analog glitch filter on External Input 14 Pad:- Disabled */
             /* Analog glitch filter on External Input 15 Pad:- Disabled */
             /* Analog glitch filter on External Input 16 Pad:- Disabled */
             /* Analog glitch filter on External Input 17 Pad:- Disabled */
             /* Analog glitch filter on External Input 18 Pad:- Disabled */
             /* Analog glitch filter on External Input 19 Pad:- Disabled */
             /* Analog glitch filter on External Input 20 Pad:- Disabled */
             /* Analog glitch filter on External Input 21 Pad:- Disabled */
             /* Analog glitch filter on External Input 22 Pad:- Disabled */
             /* Analog glitch filter on External Input 23 Pad:- Disabled */
             /* Analog glitch filter on External Input 24 Pad:- Disabled */
             /* Analog glitch filter on External Input 25 Pad:- Disabled */
             /* Analog glitch filter on External Input 26 Pad:- Disabled */
             /* Analog glitch filter on External Input 27 Pad:- Disabled */
             /* Analog glitch filter on External Input 28 Pad:- Disabled */
             /* Analog glitch filter on External Input 29 Pad:- Disabled */
             /* Analog glitch filter on External Input 30 Pad:- Disabled */
             /* Analog glitch filter on External Input 31 Pad:- Disabled */

    /* ----------------------------------------------------------- */
    /*          NMI Configuration Register - NCR       */
    /* ----------------------------------------------------------- */
        WKUP.NCR.R = 0x00000000;
             /* NMI Destination Source Select:- Non-maskable interrupt */
             /* NMI Rising Edge Trigger Event:- Disabled  */
             /* NMI Falling Edge Trigger Event:- Disabled  */
             /* Analog glitch filter on NMI Input pad:- Disabled    */
    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register0- IFMC0    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[0].R = 0x00000000;
        /* External Interrupt0 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register1- IFMC1    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[1].R = 0x00000000;
        /* External Interrupt1 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register2- IFMC2    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[2].R = 0x00000000;
        /* External Interrupt2 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register3- IFMC3    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[3].R = 0x00000000;
        /* External Interrupt3 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register4- IFMC4    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[4].R = 0x00000000;
        /* External Interrupt4 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register5- IFMC5    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[5].R = 0x00000000;
        /* External Interrupt5 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register6- IFMC6    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[6].R = 0x00000000;
        /* External Interrupt6 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register7- IFMC7    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[7].R = 0x00000000;
        /* External Interrupt7 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register8- IFMC8    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[8].R = 0x00000000;
        /* External Interrupt8 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register9- IFMC9    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[9].R = 0x00000000;
        /* External Interrupt9 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register10- IFMC10    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[10].R = 0x00000000;
        /* External Interrupt10 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register11- IFMC11    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[11].R = 0x00000000;
        /* External Interrupt11 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register12- IFMC12    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[12].R = 0x00000000;
        /* External Interrupt12 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register13- IFMC13    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[13].R = 0x00000000;
        /* External Interrupt13 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register14- IFMC14    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[14].R = 0x00000000;
        /* External Interrupt14 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register15- IFMC15    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[15].R = 0x00000000;
        /* External Interrupt15 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register16- IFMC16    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[16].R = 0x00000000;
        /* External Interrupt16 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register17- IFMC17    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[17].R = 0x00000000;
        /* External Interrupt17 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register18- IFMC18    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[18].R = 0x00000000;
        /* External Interrupt18 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register19- IFMC19    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[19].R = 0x00000000;
        /* External Interrupt19 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register20- IFMC20    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[20].R = 0x00000000;
        /* External Interrupt20 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register21- IFMC21    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[21].R = 0x00000000;
        /* External Interrupt21 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register22- IFMC22    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[22].R = 0x00000000;
        /* External Interrupt22 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register23- IFMC23    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[23].R = 0x00000000;
        /* External Interrupt23 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register24- IFMC24    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[24].R = 0x00000000;
        /* External Interrupt24 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register25- IFMC25    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[25].R = 0x00000000;
        /* External Interrupt25 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register26- IFMC26    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[26].R = 0x00000000;
        /* External Interrupt26 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register27- IFMC27    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[27].R = 0x00000000;
        /* External Interrupt27 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register28- IFMC28    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[28].R = 0x00000000;
        /* External Interrupt28 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register29- IFMC29    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[29].R = 0x00000000;
        /* External Interrupt29 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register30- IFMC30    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[30].R = 0x00000000;
        /* External Interrupt30 maximum Filter Counter:- 0 */

    /* ----------------------------------------------------------- */
    /*   Interrupt Filter Maximum Counter Register31- IFMC31    */
    /* ----------------------------------------------------------- */
        SIU.IFMC[31].R = 0x00000000;
        /* External Interrupt31 maximum Filter Counter:- 0 */

}


/* ----------------------------------------------------------- */
/*                 SIU Parrallel PORT PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_parallel_port_init_fnc(void)
{
  /* ----------------------------------------------------------- */
  /*       Masked Parallel GPIO Pin Data Output Register 0        */
  /* ----------------------------------------------------------- */
        SIU.MPGPDO[0].R = 0x00000000;
           /*   Port A Mask: 0x0000       */
           /*   Port A Data: 0x0000       */

  /* ----------------------------------------------------------- */
  /*       Masked Parallel GPIO Pin Data Output Register 1        */
  /* ----------------------------------------------------------- */
        SIU.MPGPDO[1].R = 0x00000000;
           /*   Port B Mask: 0x0000       */
           /*   Port B Data: 0x0000       */

  /* ----------------------------------------------------------- */
  /*       Masked Parallel GPIO Pin Data Output Register 2        */
  /* ----------------------------------------------------------- */
        SIU.MPGPDO[2].R = 0x00000000;
           /*   Port C Mask: 0x0000       */
           /*   Port C Data: 0x0000       */

  /* ----------------------------------------------------------- */
  /*       Masked Parallel GPIO Pin Data Output Register 3        */
  /* ----------------------------------------------------------- */
        SIU.MPGPDO[3].R = 0x00000000;
           /*   Port D Mask: 0x0000       */
           /*   Port D Data: 0x0000       */

  /* ----------------------------------------------------------- */
  /*       Masked Parallel GPIO Pin Data Output Register 4        */
  /* ----------------------------------------------------------- */
        SIU.MPGPDO[4].R = 0x00000000;
           /*   Port E Mask: 0x0000       */
           /*   Port E Data: 0x0000       */

  /* ----------------------------------------------------------- */
  /*       Masked Parallel GPIO Pin Data Output Register 5        */
  /* ----------------------------------------------------------- */
        SIU.MPGPDO[5].R = 0x00000000;
           /*   Port F Mask: 0x0000       */
           /*   Port F Data: 0x0000       */

  /* ----------------------------------------------------------- */
  /*       Masked Parallel GPIO Pin Data Output Register 6        */
  /* ----------------------------------------------------------- */
        SIU.MPGPDO[6].R = 0x00000000;
           /*   Port G Mask: 0x0000       */
           /*   Port G Data: 0x0000       */


}


/* ----------------------------------------------------------- */
/*               SIU Unused Pins Configuration                 */
/* ----------------------------------------------------------- */
void siu_unused_pins_init_fnc(void)
{
}


/* ----------------------------------------------------------- */
/*               SIU PSMI PAD Configuration                 */
/* ----------------------------------------------------------- */
void siu_psmi_init_fnc(void)
{
/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[0]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[0].R = 0x00;
                /*Function Pad Selected EXT_IN :- PCR45*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[1]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[1].R = 0x00;
                /*Function Pad Selected DSPI2_SSCK :- PCR0*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[2]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[2].R = 0x00;
                /*Function Pad Selected DSPI2_SIN :- PCR2*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[3]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[3].R = 0x00;
                /*Function Pad Selected DSPI2_SS :- PCR3*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[4]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[4].R = 0x00;
                /*Function Pad Selected DSPI3_SSCK :- PCR54*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[5]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[5].R = 0x00;
                /*Function Pad Selected DSPI3_SIN :- PCR55*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[6]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[6].R = 0x00;
                /*Function Pad Selected DSPI3_SS :- PCR43*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[7]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[7].R = 0x00;
                /*Function Pad Selected eTIMER0_ECT_4 :- PCR4*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[8]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[8].R = 0x00;
                /*Function Pad Selected eTIMER0_ECT_5 :- PCR44*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[9]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[9].R = 0x00;
                /*Function Pad Selected eTIMER1_ECT_0 :- PCR4*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[10]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[10].R = 0x00;
                /*Function Pad Selected eTIMER1_ECT_1 :- PCR45*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[11]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[11].R = 0x00;
                /*Function Pad Selected eTIMER1_ECT_2 :- PCR16*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[12]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[12].R = 0x00;
                /*Function Pad Selected eTIMER1_ECT_3 :- PCR17*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[13]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[13].R = 0x00;
                /*Function Pad Selected eTIMER1_ECT_4 :- PCR14*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[14]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[14].R = 0x00;
                /*Function Pad Selected eTIMER1_ECT_5 :- PCR5*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[15]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[15].R = 0x00;
                /*Function Pad Selected FLEXPWM_EXT_SYNC :- PCR45*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[16]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[16].R = 0x00;
                /*Function Pad Selected FLEXPWM_FAULT0 :- PCR9*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[17]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[17].R = 0x00;
                /*Function Pad Selected FLEXPWM_FAULT1 :- PCR42*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[18]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[18].R = 0x00;
                /*Function Pad Selected FLEXPWM_FAULT2 :- PCR40*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[19]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[19].R = 0x00;
                /*Function Pad Selected FLEXPWM_FAULT3 :- PCR37*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[20]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[20].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMA_0 :- PCR11*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[21]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[21].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMA_1 :- PCR39*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[22]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[22].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMA_2 :- PCR11*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[23]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[23].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMA_3 :- PCR2*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[24]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[24].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMB_0 :- PCR10*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[25]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[25].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMB_1 :- PCR38*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[26]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[26].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMB_2 :- PCR12*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[27]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[27].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMB_3 :- PCR3*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[28]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[28].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMX_1 :- PCR36*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[29]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[29].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMX_2 :- PCR10*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[30]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[30].R = 0x00;
                /*Function Pad Selected FLEXPWM_PWMX_3 :- PCR41*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[31]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[31].R = 0x00;
                /*Function Pad Selected LIN0_RXD :- PCR19*/

/*-----------------------------------------------------------*/
/* Pad Selection for Multiplex Input Register PSMI[32]      */
/*-----------------------------------------------------------*/
               SIU.PSMI[32].R = 0x00;
                /*Function Pad Selected LIN1_RXD :- PCR29*/

}



 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

