/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : main.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:28:35
 *
 * Created on Date        : 12-Feb-2014 16:28:37
 *
 * Brief Description      : This file contains main() function call.
 *
 ******************************************************************************** 
 *
 * Detail Description     : This file contains main() routine which calls system initialization
 *                          routine and interrupt enable routine if defined.
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "rappid_ref.h"
#include "rappid_utils.h"
#include "sys_init.h"
#include "freemaster.h"
#include "adc_drv.h"
#include "sbc_hld.h"
#include "gpio_drv.h"
#include "CANapi.h"
#include "pot_hld.h"


/**********************  Function Prototype here *************************/

void main(void);
void ProcessCAN(void);
void ProcessADC(void);
void ProcessGPIO(void);

/**********************  Global variables here *************************/
/* CAN messages to transmit */
unsigned char msgOKCAN[8] = {1,1,0,0,0,0,0,0};
unsigned char msgErrorCAN[8] = {1,0xFF,0,0,0,0,0,0};

uint16_t potValue;		/* Potentiometer ADC input value*/
uint8_t switchState;	/* State of switch S3 input */

/*********************  Initialization Function(s) ************************/

void main(void)
{

/* ----------------------------------------------------------- */
/*	             System Initialization Function                  */
/* ----------------------------------------------------------- */
   sys_init_fnc();
   
   /* Initialize SBC */
   SBC_Init_DBG();   

   /* FreeMASTER internal variables initialization */
   FMSTR_Init();

   /* Initialize CAN filter */ 
   SetCanRxFilter(1, 0, 0);	
   
   /* Turn off LEDs */  
   GPIO_SetState(52, 1);
   GPIO_SetState(53, 1);
   GPIO_SetState(54, 1);
   GPIO_SetState(55, 1);
   
/********* Enable External Interrupt *********/
   EnableExternalInterrupts();
   while(1)
   {
		FMSTR_Poll();
		ProcessCAN();
		ProcessADC();
		ProcessGPIO();
   }
}

/******************************************************************************
*   Function: ProcessCAN
*
*   Description: Process CAN messages
*
******************************************************************************/
void ProcessCAN(void)
{
	can_msg_struct msgCanRX;
	
	if (CanRxMbFull(0) == 1)		/* Check if CAN message received */
	{
	    msgCanRX = CanRxMsg(0);	
	    if (msgCanRX.data[0] == 0)	/* If first data byte is 0, turn off LED4 and send positive response */
	    {
	    	GPIO_SetState(55, 1);
	    	CanTxMsg (2, 1, 8, (uint8_t *)msgOKCAN, 0);
	    }
	    else if (msgCanRX.data[0] == 1)/* If first data byte is 1, turn on LED4 and send positive response */
	    {
	    	GPIO_SetState(55, 0);
	    	CanTxMsg (2, 1, 8, (uint8_t *)msgOKCAN, 0); 
	    }
	    else			/* If first data byte is not 0 or 1, send a negative response */
	    {
	    	CanTxMsg (2, 1, 8, (uint8_t *)msgErrorCAN, 0);
	    }	    		
	}
}

/******************************************************************************
*   Function: ProcessADC
*
*   Description: Processes ADC input 
*
******************************************************************************/
void ProcessADC(void)
{
	potValue = Pot_Get_Value();
	if(potValue <= 512) 	/* If Potentiometer input is <= 512 turn on LED2, otherwise turn off LED2 */
	{
		GPIO_SetState(53, 0);
	}
	else
	{
		GPIO_SetState(53, 1);
	}
}

/******************************************************************************
*   Function: ProcessGPIO
*
*   Description: Processes switch input 
*
******************************************************************************/
void ProcessGPIO(void)
{
	switchState = GPIO_GetState(50); 	/* Check switch S3 state */
	if (switchState)		/* If Switch S3 is pressed, turn on LED3, otherwise turn off LED3*/
	{
		GPIO_SetState(54, 1);		
	}
	else
	{
		GPIO_SetState(54, 0);   			
	}	
}
 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

