/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : intc_init.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : This file contains  the interrupt service routine for the SIU
 *
 ******************************************************************************** 
 *
 * Detail Description     : This file contains initialization function for Interrupt.
 *                          It sets the vector mode ,size and global priority .It 
 *                          also defines the Interrupt enable Function.
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "rappid_ref.h"
#include "intc_init.h"
#include "rappid_utils.h"


extern uint32_t IntcIsrVectorTable [];
/*********************  Initialization Function(s) ************************/

void intc_init_fnc (void)
{
/*--------------------------------------------------------------------*/
/*                         INTC General Setup                            */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/*  			INTC Module Configuration Register (INTC_MCR) 	      */
/*--------------------------------------------------------------------*/
    INTC.MCR.R = 0x00000000;
    /* Module Control Register - MCR                   */
    /* Bit 18 - The vector table size for e200z0 Core is: 4 bytes     */
    /* Bit 23 - The module for e200z0 Core is in Software Vector Mode */

/*--------------------------------------------------------------------*/
/*    INTC Module Configuration Register For e200z0 Core (IACKR) 	   */
/*--------------------------------------------------------------------*/
    INTC.IACKR.R = (vuint32_t)&IntcIsrVectorTable;
    /* Interrupt Acknowledge Register for e200z0 Core - IACKR      */
    /* Bits 0-21 - The vector base address for e200z0 Core is: 0     */

/* -------------------------------------------------------------------*/
/*             INTC Module Configuration Register (INTC_PSR)         */
/* -------------------------------------------------------------------*/

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 0          */
/* -------------------------------------------------------------------*/
    INTC.PSR[0].R = 0x00;
    /* Software settable Clear flag 0 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 1          */
/* -------------------------------------------------------------------*/
    INTC.PSR[1].R = 0x00;
    /* Software settable Clear flag 1 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 2          */
/* -------------------------------------------------------------------*/
    INTC.PSR[2].R = 0x00;
    /* Software settable Clear flag 2 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 3          */
/* -------------------------------------------------------------------*/
    INTC.PSR[3].R = 0x00;
    /* Software settable Clear flag 3 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 4          */
/* -------------------------------------------------------------------*/
    INTC.PSR[4].R = 0x00;
    /* Software settable Clear flag 4 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 5          */
/* -------------------------------------------------------------------*/
    INTC.PSR[5].R = 0x00;
    /* Software settable Clear flag 5 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 6          */
/* -------------------------------------------------------------------*/
    INTC.PSR[6].R = 0x00;
    /* Software settable Clear flag 6 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 7          */
/* -------------------------------------------------------------------*/
    INTC.PSR[7].R = 0x00;
    /* Software settable Clear flag 7 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 9          */
/* -------------------------------------------------------------------*/
    INTC.PSR[9].R = 0x00;
    /* Platform Flash combined Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 10          */
/* -------------------------------------------------------------------*/
    INTC.PSR[10].R = 0x00;
    /* eDMA Combined Error Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 11          */
/* -------------------------------------------------------------------*/
    INTC.PSR[11].R = 0x00;
    /* eDMA Channel 0 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 12          */
/* -------------------------------------------------------------------*/
    INTC.PSR[12].R = 0x00;
    /* eDMA Channel 1 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 13          */
/* -------------------------------------------------------------------*/
    INTC.PSR[13].R = 0x00;
    /* eDMA Channel 2 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 14          */
/* -------------------------------------------------------------------*/
    INTC.PSR[14].R = 0x00;
    /* eDMA Channel 3 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 15          */
/* -------------------------------------------------------------------*/
    INTC.PSR[15].R = 0x00;
    /* eDMA Channel 4 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 16          */
/* -------------------------------------------------------------------*/
    INTC.PSR[16].R = 0x00;
    /* eDMA Channel 5 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 17          */
/* -------------------------------------------------------------------*/
    INTC.PSR[17].R = 0x00;
    /* eDMA Channel 6 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 18          */
/* -------------------------------------------------------------------*/
    INTC.PSR[18].R = 0x00;
    /* eDMA Channel 7 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 19          */
/* -------------------------------------------------------------------*/
    INTC.PSR[19].R = 0x00;
    /* eDMA Channel 8 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 20          */
/* -------------------------------------------------------------------*/
    INTC.PSR[20].R = 0x00;
    /* eDMA Channel 9 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 21          */
/* -------------------------------------------------------------------*/
    INTC.PSR[21].R = 0x00;
    /* eDMA Channel 10 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 22          */
/* -------------------------------------------------------------------*/
    INTC.PSR[22].R = 0x00;
    /* eDMA Channel 11 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 23          */
/* -------------------------------------------------------------------*/
    INTC.PSR[23].R = 0x00;
    /* eDMA Channel 12 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 24          */
/* -------------------------------------------------------------------*/
    INTC.PSR[24].R = 0x00;
    /* eDMA Channel 13 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 25          */
/* -------------------------------------------------------------------*/
    INTC.PSR[25].R = 0x00;
    /* eDMA Channel 14 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 26          */
/* -------------------------------------------------------------------*/
    INTC.PSR[26].R = 0x00;
    /* eDMA Channel 15 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 28          */
/* -------------------------------------------------------------------*/
    INTC.PSR[28].R = 0x00;
    /* SWT Timeout Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 30          */
/* -------------------------------------------------------------------*/
    INTC.PSR[30].R = 0x00;
    /* STM Channel 0 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 31          */
/* -------------------------------------------------------------------*/
    INTC.PSR[31].R = 0x00;
    /* STM Channel 1 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 32          */
/* -------------------------------------------------------------------*/
    INTC.PSR[32].R = 0x00;
    /* STM Channel 2 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 33          */
/* -------------------------------------------------------------------*/
    INTC.PSR[33].R = 0x00;
    /* STM Channel 3 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 35          */
/* -------------------------------------------------------------------*/
    INTC.PSR[35].R = 0x00;
    /* ECC_DBD Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 36          */
/* -------------------------------------------------------------------*/
    INTC.PSR[36].R = 0x00;
    /* ECC_SBC Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 41          */
/* -------------------------------------------------------------------*/
    INTC.PSR[41].R = 0x00;
    /* SIU External IRQ_0-7 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 42          */
/* -------------------------------------------------------------------*/
    INTC.PSR[42].R = 0x00;
    /* SIU External IRQ_8-15 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 43          */
/* -------------------------------------------------------------------*/
    INTC.PSR[43].R = 0x00;
    /* SIU External IRQ_16-23 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 44          */
/* -------------------------------------------------------------------*/
    INTC.PSR[44].R = 0x00;
    /* SIU External IRQ_24-31 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 51          */
/* -------------------------------------------------------------------*/
    INTC.PSR[51].R = 0x00;
    /* Safe mode Interrupt Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 52          */
/* -------------------------------------------------------------------*/
    INTC.PSR[52].R = 0x00;
    /* Mode Transition Interrupt Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 53          */
/* -------------------------------------------------------------------*/
    INTC.PSR[53].R = 0x00;
    /* Invalid Mode Interrupt Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 54          */
/* -------------------------------------------------------------------*/
    INTC.PSR[54].R = 0x00;
    /* Invalid Mode Config  Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 56          */
/* -------------------------------------------------------------------*/
    INTC.PSR[56].R = 0x00;
    /* Functional-destructive alternate event Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 57          */
/* -------------------------------------------------------------------*/
    INTC.PSR[57].R = 0x00;
    /* XOSC counter expired Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 59          */
/* -------------------------------------------------------------------*/
    INTC.PSR[59].R = 0x01;
    /* PIT Channel 0 Priority is: 1        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 60          */
/* -------------------------------------------------------------------*/
    INTC.PSR[60].R = 0x00;
    /* PIT Channel 1 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 61          */
/* -------------------------------------------------------------------*/
    INTC.PSR[61].R = 0x00;
    /* PIT Channel 2 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 62          */
/* -------------------------------------------------------------------*/
    INTC.PSR[62].R = 0x00;
    /* ADC_0_EOC Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 63          */
/* -------------------------------------------------------------------*/
    INTC.PSR[63].R = 0x00;
    /* ADC_0_ER Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 64          */
/* -------------------------------------------------------------------*/
    INTC.PSR[64].R = 0x00;
    /* ADC_0_WD Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 65          */
/* -------------------------------------------------------------------*/
    INTC.PSR[65].R = 0x00;
    /* CAN_0_Error Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 66          */
/* -------------------------------------------------------------------*/
    INTC.PSR[66].R = 0x00;
    /* CAN_0_Bus_off_TX_warning_RX_warning Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 67          */
/* -------------------------------------------------------------------*/
    INTC.PSR[67].R = 0x00;
    /* CAN_0_Wakeup Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 68          */
/* -------------------------------------------------------------------*/
    INTC.PSR[68].R = 0x00;
    /* CAN_0_BUF_00_03 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 69          */
/* -------------------------------------------------------------------*/
    INTC.PSR[69].R = 0x00;
    /* CAN_0_BUF_04_07 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 70          */
/* -------------------------------------------------------------------*/
    INTC.PSR[70].R = 0x00;
    /* CAN_0_BUF_08_11 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 71          */
/* -------------------------------------------------------------------*/
    INTC.PSR[71].R = 0x00;
    /* CAN_0_BUF_12_15 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 72          */
/* -------------------------------------------------------------------*/
    INTC.PSR[72].R = 0x00;
    /* CAN_0_BUF_16_31 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 74          */
/* -------------------------------------------------------------------*/
    INTC.PSR[74].R = 0x00;
    /* DSPI_0_SR[TFUF/RFOF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 75          */
/* -------------------------------------------------------------------*/
    INTC.PSR[75].R = 0x00;
    /* DSPI_0_SR[EOQF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 76          */
/* -------------------------------------------------------------------*/
    INTC.PSR[76].R = 0x00;
    /* DSPI_0_SR[TFFF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 77          */
/* -------------------------------------------------------------------*/
    INTC.PSR[77].R = 0x00;
    /* DSPI_0_SR[TCF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 78          */
/* -------------------------------------------------------------------*/
    INTC.PSR[78].R = 0x00;
    /* DSPI_0_SR[RFDF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 79          */
/* -------------------------------------------------------------------*/
    INTC.PSR[79].R = 0x00;
    /* LINFlex_0_RXI Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 80          */
/* -------------------------------------------------------------------*/
    INTC.PSR[80].R = 0x00;
    /* LINFlex_0_TXI Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 81          */
/* -------------------------------------------------------------------*/
    INTC.PSR[81].R = 0x00;
    /* LINFlex_0_ERR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 82          */
/* -------------------------------------------------------------------*/
    INTC.PSR[82].R = 0x00;
    /* ADC_1_EOC Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 83          */
/* -------------------------------------------------------------------*/
    INTC.PSR[83].R = 0x00;
    /* ADC_1_ER Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 84          */
/* -------------------------------------------------------------------*/
    INTC.PSR[84].R = 0x00;
    /* ADC_1_WD Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 94          */
/* -------------------------------------------------------------------*/
    INTC.PSR[94].R = 0x00;
    /* DSPI_1_SR[TFUF/RFOF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 95          */
/* -------------------------------------------------------------------*/
    INTC.PSR[95].R = 0x00;
    /* DSPI_1_SR[EOQF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 96          */
/* -------------------------------------------------------------------*/
    INTC.PSR[96].R = 0x00;
    /* DSPI_1_SR[TFFF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 97          */
/* -------------------------------------------------------------------*/
    INTC.PSR[97].R = 0x00;
    /* DSPI_1_SR[TCF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 98          */
/* -------------------------------------------------------------------*/
    INTC.PSR[98].R = 0x00;
    /* DSPI_1_SR[RFDF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 99          */
/* -------------------------------------------------------------------*/
    INTC.PSR[99].R = 0x00;
    /* LINFlex_1_RXI Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 100          */
/* -------------------------------------------------------------------*/
    INTC.PSR[100].R = 0x00;
    /* LINFlex_1_TXI Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 101          */
/* -------------------------------------------------------------------*/
    INTC.PSR[101].R = 0x00;
    /* LINFlex_1_ERR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 114          */
/* -------------------------------------------------------------------*/
    INTC.PSR[114].R = 0x00;
    /* DSPI_2_SR[TFUF/RFOF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 115          */
/* -------------------------------------------------------------------*/
    INTC.PSR[115].R = 0x00;
    /* DSPI_2_SR[EOQF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 116          */
/* -------------------------------------------------------------------*/
    INTC.PSR[116].R = 0x00;
    /* DSPI_2_SR[TFFF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 117          */
/* -------------------------------------------------------------------*/
    INTC.PSR[117].R = 0x00;
    /* DSPI_2_SR[TCF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 118          */
/* -------------------------------------------------------------------*/
    INTC.PSR[118].R = 0x00;
    /* DSPI_2_SR[RFDF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 127          */
/* -------------------------------------------------------------------*/
    INTC.PSR[127].R = 0x00;
    /* PIT Channel 3 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 133          */
/* -------------------------------------------------------------------*/
    INTC.PSR[133].R = 0x00;
    /* FlexRay CIFRR.FNEAIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 134          */
/* -------------------------------------------------------------------*/
    INTC.PSR[134].R = 0x00;
    /* FlexRay CIFRR.FNEBIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 135          */
/* -------------------------------------------------------------------*/
    INTC.PSR[135].R = 0x00;
    /* FlexRay CIFRR.WUPIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 136          */
/* -------------------------------------------------------------------*/
    INTC.PSR[136].R = 0x00;
    /* FlexRay CIFRR.PRIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 137          */
/* -------------------------------------------------------------------*/
    INTC.PSR[137].R = 0x00;
    /* FlexRay CIFRR.CHIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 138          */
/* -------------------------------------------------------------------*/
    INTC.PSR[138].R = 0x00;
    /* FlexRay CIFRR.TBIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 139          */
/* -------------------------------------------------------------------*/
    INTC.PSR[139].R = 0x00;
    /* FlexRay CIFRR.RBIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 140          */
/* -------------------------------------------------------------------*/
    INTC.PSR[140].R = 0x00;
    /* FlexRay CIFRR.MIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 157          */
/* -------------------------------------------------------------------*/
    INTC.PSR[157].R = 0x00;
    /* eTIMER_0 TC0IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 158          */
/* -------------------------------------------------------------------*/
    INTC.PSR[158].R = 0x00;
    /* eTIMER_0 TC1IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 159          */
/* -------------------------------------------------------------------*/
    INTC.PSR[159].R = 0x00;
    /* eTIMER_0 TC2IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 160          */
/* -------------------------------------------------------------------*/
    INTC.PSR[160].R = 0x00;
    /* eTIMER_0 TC3IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 161          */
/* -------------------------------------------------------------------*/
    INTC.PSR[161].R = 0x00;
    /* eTIMER_0 TC4IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 162          */
/* -------------------------------------------------------------------*/
    INTC.PSR[162].R = 0x00;
    /* eTIMER_0 TC5IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 165          */
/* -------------------------------------------------------------------*/
    INTC.PSR[165].R = 0x00;
    /* eTIMER_0 WTIF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 167          */
/* -------------------------------------------------------------------*/
    INTC.PSR[167].R = 0x00;
    /* eTIMER_0 RCF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 168          */
/* -------------------------------------------------------------------*/
    INTC.PSR[168].R = 0x00;
    /* eTIMER_1 TC0IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 169          */
/* -------------------------------------------------------------------*/
    INTC.PSR[169].R = 0x00;
    /* eTIMER_1 TC1IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 170          */
/* -------------------------------------------------------------------*/
    INTC.PSR[170].R = 0x00;
    /* eTIMER_1 TC2IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 171          */
/* -------------------------------------------------------------------*/
    INTC.PSR[171].R = 0x00;
    /* eTIMER_1 TC3IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 172          */
/* -------------------------------------------------------------------*/
    INTC.PSR[172].R = 0x00;
    /* eTIMER_1 TC4IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 173          */
/* -------------------------------------------------------------------*/
    INTC.PSR[173].R = 0x00;
    /* eTIMER_1 TC5IR Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 178          */
/* -------------------------------------------------------------------*/
    INTC.PSR[178].R = 0x00;
    /* eTIMER_1 RCF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 179          */
/* -------------------------------------------------------------------*/
    INTC.PSR[179].R = 0x00;
    /* FlexPWM_0 RF0 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 180          */
/* -------------------------------------------------------------------*/
    INTC.PSR[180].R = 0x00;
    /* FlexPWM_0 COF0 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 181          */
/* -------------------------------------------------------------------*/
    INTC.PSR[181].R = 0x00;
    /* FlexPWM_0 CAF0 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 182          */
/* -------------------------------------------------------------------*/
    INTC.PSR[182].R = 0x00;
    /* FlexPWM_0 RF1 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 183          */
/* -------------------------------------------------------------------*/
    INTC.PSR[183].R = 0x00;
    /* FlexPWM_0 COF1 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 184          */
/* -------------------------------------------------------------------*/
    INTC.PSR[184].R = 0x00;
    /* FlexPWM_0 CAF1 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 185          */
/* -------------------------------------------------------------------*/
    INTC.PSR[185].R = 0x00;
    /* FlexPWM_0 RF2 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 186          */
/* -------------------------------------------------------------------*/
    INTC.PSR[186].R = 0x00;
    /* FlexPWM_0 COF2 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 187          */
/* -------------------------------------------------------------------*/
    INTC.PSR[187].R = 0x00;
    /* FlexPWM_0 CAF2 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 188          */
/* -------------------------------------------------------------------*/
    INTC.PSR[188].R = 0x00;
    /* FlexPWM_0 RF3 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 189          */
/* -------------------------------------------------------------------*/
    INTC.PSR[189].R = 0x00;
    /* FlexPWM_0 COF3 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 190          */
/* -------------------------------------------------------------------*/
    INTC.PSR[190].R = 0x00;
    /* FlexPWM_0 CAF3 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 191          */
/* -------------------------------------------------------------------*/
    INTC.PSR[191].R = 0x00;
    /* FlexPWM_0 FFLAG Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 192          */
/* -------------------------------------------------------------------*/
    INTC.PSR[192].R = 0x00;
    /* FlexPWM_0 REF Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 193          */
/* -------------------------------------------------------------------*/
    INTC.PSR[193].R = 0x00;
    /* CTU_0 MRS_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 194          */
/* -------------------------------------------------------------------*/
    INTC.PSR[194].R = 0x00;
    /* CTU_0 T0_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 195          */
/* -------------------------------------------------------------------*/
    INTC.PSR[195].R = 0x00;
    /* CTU_0 T1_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 196          */
/* -------------------------------------------------------------------*/
    INTC.PSR[196].R = 0x00;
    /* CTU_0 T2_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 197          */
/* -------------------------------------------------------------------*/
    INTC.PSR[197].R = 0x00;
    /* CTU_0 T3_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 198          */
/* -------------------------------------------------------------------*/
    INTC.PSR[198].R = 0x00;
    /* CTU_0 T4_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 199          */
/* -------------------------------------------------------------------*/
    INTC.PSR[199].R = 0x00;
    /* CTU_0 T5_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 200          */
/* -------------------------------------------------------------------*/
    INTC.PSR[200].R = 0x00;
    /* CTU_0 T6_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 201          */
/* -------------------------------------------------------------------*/
    INTC.PSR[201].R = 0x00;
    /* CTU_0 T7_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 202          */
/* -------------------------------------------------------------------*/
    INTC.PSR[202].R = 0x00;
    /* CTU_0 FIFO0_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 203          */
/* -------------------------------------------------------------------*/
    INTC.PSR[203].R = 0x00;
    /* CTU_0 FIFO1_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 204          */
/* -------------------------------------------------------------------*/
    INTC.PSR[204].R = 0x00;
    /* CTU_0 FIFO2_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 205          */
/* -------------------------------------------------------------------*/
    INTC.PSR[205].R = 0x00;
    /* CTU_0 FIFO3_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 206          */
/* -------------------------------------------------------------------*/
    INTC.PSR[206].R = 0x00;
    /* CTU_0 ADC_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 207          */
/* -------------------------------------------------------------------*/
    INTC.PSR[207].R = 0x00;
    /* CTU_0 ERR_I Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 208          */
/* -------------------------------------------------------------------*/
    INTC.PSR[208].R = 0x00;
    /* SAFEPORT_Error Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 209          */
/* -------------------------------------------------------------------*/
    INTC.PSR[209].R = 0x00;
    /* SAFEPORT_Bus_off_TX_warning_RX_warning Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 210          */
/* -------------------------------------------------------------------*/
    INTC.PSR[210].R = 0x00;
    /* SAFEPORT_Wakeup Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 211          */
/* -------------------------------------------------------------------*/
    INTC.PSR[211].R = 0x00;
    /* SAFEPORT BUF_0_3 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 212          */
/* -------------------------------------------------------------------*/
    INTC.PSR[212].R = 0x00;
    /* SAFEPORT BUF_4_7 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 213          */
/* -------------------------------------------------------------------*/
    INTC.PSR[213].R = 0x00;
    /* SAFEPORT BUF_8_11 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 214          */
/* -------------------------------------------------------------------*/
    INTC.PSR[214].R = 0x00;
    /* SAFEPORT BUF_12_15 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 215          */
/* -------------------------------------------------------------------*/
    INTC.PSR[215].R = 0x00;
    /* SAFEPORT BUF_16_31 Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 217          */
/* -------------------------------------------------------------------*/
    INTC.PSR[217].R = 0x00;
    /* DSPI_3_SR[TFUF/RFOF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 218          */
/* -------------------------------------------------------------------*/
    INTC.PSR[218].R = 0x00;
    /* DSPI_3_SR[EOQF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 219          */
/* -------------------------------------------------------------------*/
    INTC.PSR[219].R = 0x00;
    /* DSPI_3_SR[TFFF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 220          */
/* -------------------------------------------------------------------*/
    INTC.PSR[220].R = 0x00;
    /* DSPI_3_SR[TCF] Priority is: 0        */

/* -------------------------------------------------------------------*/
/*	           Priority Set Register for interrupt vector 221          */
/* -------------------------------------------------------------------*/
    INTC.PSR[221].R = 0x00;
    /* DSPI_3_SR[RFDF] Priority is: 0        */



    en_int_fnc(0);

}

/*********************  Interrupt Enable Function *************************/

void en_int_fnc (vuint32_t priority)
{
/* -------------------------------------------------------------------*/
/*	           Enable Routine - Priority equal 0-15                   */
/*	    (0 - Enable All interrupts, 15 - Disable All interrupts)      */
/* -------------------------------------------------------------------*/
/*--------------------------------------------------------------------*/
/*    INTC Current Priority Register  for Core e200z0 (INTC_CPR)     */
/*--------------------------------------------------------------------*/
    INTC.CPR.R = priority;
    /* Bits 4 ~ 0 - The Interrupt Prevention Limit for Core e200z0 is: 0*/


}


 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

