/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : adc_init.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : This file contains the ADC Configuration and initialization functions.
 *
 ******************************************************************************** 
 *
 * Detail Description     : This File contains function that setup Normal & injected channels,
 *                          Sampling, PreSampling, interrupt, Threshold and CTU.
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "adc_init.h"






/*********************  Initialization Function(s) ************************/

void adc_init_fnc(void)
{

/*-----------------------------------------------------------*/
/*            Abort all conversion in process                */
/*-----------------------------------------------------------*/

    
        ADC_0.MCR.B.ABORT = 1; 

        ADC_1.MCR.B.ABORT = 1;
                
/*-----------------------------------------------------------*/
/*            ADC Sampling and ThresHold Configuration                    */
/*-----------------------------------------------------------*/

        adc_sampling_setup_fnc();            
/*-----------------------------------------------------------*/
/*            ADC General Setup                    */
/*-----------------------------------------------------------*/

        adc_general_setup_fnc();            

/*-----------------------------------------------------------*/
/*            ADC CTU Configuration        */
/*-----------------------------------------------------------*/
        adc_ctu_fnc();            

/*-----------------------------------------------------------*/
/*            ADC Interrupt Configuration                            */
/*-----------------------------------------------------------*/

        adc_interrupt_setup_fnc();            

/*-----------------------------------------------------------*/
/*            ADC Channel Configuration                    */
/*-----------------------------------------------------------*/

        adc_channel_setup_fnc();            

/*-----------------------------------------------------------*/
/*            ADC Trigger Configuration                    */
/*-----------------------------------------------------------*/

        adc_trigger_setup_fnc();            
/*-----------------------------------------------------------*/
/*            DMA Setup Function(s)                    */
/*-----------------------------------------------------------*/

        adc_dma_setup_fnc();        
/*-----------------------------------------------------------*/
/*            Exit the ABORT state                    */
/*-----------------------------------------------------------*/

        ADC_0.MCR.B.ABORT = 0; 

        ADC_1.MCR.B.ABORT = 0;
    
}

/*********************  Trigger Initialization Function(s) ************************/

void adc_trigger_setup_fnc()
{
/*-----------------------------------------------------------*/
/*                    ADC 0 Trigger Configuration            */
/*-----------------------------------------------------------*/
        ADC_0.MCR.R = 0x00000001;            
            /* Injection Trigger : Disabled     */
            /* Injection trigger edge : Falling*/

/*-----------------------------------------------------------*/
/*                    ADC 1 Trigger Configuration            */
/*-----------------------------------------------------------*/

        ADC_1.MCR.R = 0x00000000;            
            /* Injection Trigger : Disabled     */
            /* Injection trigger edge :  Falling */
}
/*********************  Interrupt Initialization Function(s) ************************/

void adc_interrupt_setup_fnc()
{
/*-----------------------------------------------------------*/
/*                    Interrupt Mask Register(ADC0_IMR)        */
/*-----------------------------------------------------------*/

        ADC_0.IMR.R = 0x00000000;    
            /* End of Chain Conversion Interrupt : Disabled */
            /* End of Injected Chain Interrupt : Disabled */
            /* End of Channel Conversion Interrupt : Disabled */
            /* End of Injected Channel Interrupt : Disabled */
            /* Error in Offset Refresh Interrupt : Disabled */
            /* Offset Cancellation Over Interrupt : Disabled */
            /* End of CTU conversion Interrupt : Disabled */

/*-----------------------------------------------------------*/
/*                    Interrupt Mask Register(ADC1_IMR)        */
/*-----------------------------------------------------------*/

        ADC_1.IMR.R = 0x00000000;    
                /* End of Chain Conversion Interrupt : Disabled */
                /* End of Injected Chain Interrupt : Disabled */
                /* End of Channel Conversion Interrupt : Disabled */
                /* End of Injected Channel Interrupt : Disabled */
                /* Error in Offset Refresh Interrupt : Disabled */
                /* Offset Cancellation Over Interrupt : Disabled */
                /* End of CTU conversion Interrupt : Disabled */
}

/*********************  Sampling Initialization Function(s) ************************/

void adc_sampling_setup_fnc()
{

/*-----------------------------------------------------------*/
/*                ADC_0 Sampling Control            */
/*-----------------------------------------------------------*/

/*-----------------------------------------------------------*/
/*                Conversion Timing Register 0(ADC_0_CTR0)    */
/*-----------------------------------------------------------*/
        ADC_0.CTR[0].R = 0x00000203;
            /*Phase duration Latch : Disabled */
            /*Input Sampling Duration : 3 clock Cycles     */
            /*Input Comparison Duration : 1 clock Cycles     */

/*-----------------------------------------------------------*/
/*                Offset  Word Register (ADC_OFFWR)    */
/*-----------------------------------------------------------*/
        ADC_0.OFFWR.B.OFFSETWORD = 0x00000000;
            /* Offset Loading : Disabled     */
            /* External Offset Word : 0    */

/*-----------------------------------------------------------*/
/*             Main Configuration Register (ADC_0_MCR)    */
/*-----------------------------------------------------------*/
            ADC_0.MCR.R = 0x00000000;
                /* Offset Cancellation Phase : Disabled */
                /* Offset Refresh during Idle mode :Disabled     */
            ADC_0.MCR.B.PWDN = 0x0;
                /* Exit from power down state*/
            
            while(ADC_0.MCR.B.OFFCANC)
            {
                /*No Operation*/
            }

                /* Note that offset cancellation is performed only after coming 
                out of powerdown state. As a consequence, OFFCANC bit must be
                set before PWDN bit resetting after the offset cancellation
                phase is over the 8-bit offset coefficient is stored in the
                Offset word register OFFREG and as a consequence, the OFFCANC bit is cleared */

/*-----------------------------------------------------------*/
/*                ADC_1 Sampling Control            */
/*-----------------------------------------------------------*/

/*-----------------------------------------------------------*/
/*                Conversion Timing Register 0(ADC_1_CTR0)    */
/*-----------------------------------------------------------*/
        ADC_1.CTR[0].R = 0x00000203;
            /*Phase duration Latch : Disabled */
            /*Input Sampling Duration : 3 clock Cycles     */
            /*Input Comparison Duration : 1 clock Cycles     */

/*-----------------------------------------------------------*/
/*                Offset  Word Register (ADC_OFFWR)    */
/*-----------------------------------------------------------*/
        ADC_1.OFFWR.B.OFFSETWORD = 0x00000000;
            /* Offset Loading : Disabled     */
            /* External Offset Word : 0    */

/*-----------------------------------------------------------*/
/*             Main Configuration Register (ADC_1_MCR)    */
/*-----------------------------------------------------------*/
            ADC_1.MCR.R = 0x00000000;
                /* Offset Cancellation Phase : Disabled */
                /* Offset Refresh during Idle mode :Disabled     */
            ADC_1.MCR.B.PWDN = 0x0;
                /* Exit from power down state*/
            
            while(ADC_1.MCR.B.OFFCANC)
            {
                /*No Operation*/
            }

                /* Note that offset cancellation is performed only after coming 
                out of powerdown state. As a consequence, OFFCANC bit must be
                set before PWDN bit resetting after the offset cancellation
                phase is over the 8-bit offset coefficient is stored in the
                Offset word register OFFREG and as a consequence, the OFFCANC bit is cleared */
}
/*********************  General Initialization Function(s) ************************/

void adc_general_setup_fnc(void)
{

/*-----------------------------------------------------------*/
/*                ADC 0 Device Setup             */
/*-----------------------------------------------------------*/

        ADC_0.MCR.R = 0x00000001;
            /* Auto Clock Off feature : Disabled */
            /* Conversion data Overwrite: Disabled */
            /* Conversion Data Aligned: Right Aligned */
            /* Conversion Mode Selected :  One Shot */
            /* ADC Conversion clock selected as :  System Clock/2 */
            /* ADC PowerDown Mode is :  Enabled */


        ADC_0.DSDR.R = 0x00000000;
            /* The Decode Signal Delay : 0 clock Cycle      */

        ADC_0.PDEDR.R = 0x00000000;
            /* The Power Down Delay : 0 clock Cycle      */

/*-----------------------------------------------------------*/
/*                ADC 1 Device Setup             */
/*-----------------------------------------------------------*/

        ADC_1.MCR.R = 0x00000000;
            /* Auto Clock Off feature : Disabled */
            /* Conversion data Overwrite: Disabled */
            /* Conversion Data Aligned: Right Aligned */
            /* Conversion Mode Selected :  One Shot */
            /* ADC Conversion clock selected as :  System Clock/2 */


        ADC_1.DSDR.R = 0x00000000;
            /* The Decode Signal Delay : 0 clock Cycle      */

        ADC_1.PDEDR.R = 0x00000000;
            /* The Power Down Delay : 0 clock Cycle      */

}
/*********************  Channel Initialization Function(s) ************************/

void adc_channel_setup_fnc(void)
{

/*-----------------------------------------------------------*/
/*                ADC 0 Channel Setup            */
/*-----------------------------------------------------------*/

/*-----------------------------------------------------------*/
/*    Normal Channel Conversion Mask Register 0(ADC_0_NCMR0)*/
/*-----------------------------------------------------------*/
        ADC_0.NCMR[0].R = 0x00000000;
            /* ADC Channel 0 in Normal Mode : Disabled */
            /* ADC Channel 1 in Normal Mode : Disabled */
            /* ADC Channel 2 in Normal Mode : Disabled */
            /* ADC Channel 3 in Normal Mode : Disabled */
            /* ADC Channel 4 in Normal Mode : Disabled */
            /* ADC Channel 5 in Normal Mode : Disabled */
            /* ADC Channel 6 in Normal Mode : Disabled */
            /* ADC Channel 7 in Normal Mode : Disabled */
            /* ADC Channel 8 in Normal Mode : Disabled */
            /* ADC Channel 9 in Normal Mode : Disabled */
            /* ADC Channel 10 in Normal Mode : Disabled */
            /* ADC Channel 11 in Normal Mode : Disabled */
            /* ADC Channel 12 in Normal Mode : Disabled */
            /* ADC Channel 13 in Normal Mode : Disabled */
            /* ADC Channel 14 in Normal Mode : Disabled */
            /* ADC Channel 15 in Normal Mode : Disabled */

/*-----------------------------------------------------------*/
/*        Injected Channel Conversion Mask Register 0(ADC_0_JCMR0)*/
/*-----------------------------------------------------------*/
        ADC_0.JCMR[0].R = 0x00000000;
            /* ADC Channel 0 in Injected Mode : Disabled */
            /* ADC Channel 1 in Injected Mode : Disabled */
            /* ADC Channel 2 in Injected Mode : Disabled */
            /* ADC Channel 3 in Injected Mode : Disabled */
            /* ADC Channel 4 in Injected Mode : Disabled */
            /* ADC Channel 5 in Injected Mode : Disabled */
            /* ADC Channel 6 in Injected Mode : Disabled */
            /* ADC Channel 7 in Injected Mode : Disabled */
            /* ADC Channel 8 in Injected Mode : Disabled */
            /* ADC Channel 9 in Injected Mode : Disabled */
            /* ADC Channel 10 in Injected Mode : Disabled */
            /* ADC Channel 11 in Injected Mode : Disabled */
            /* ADC Channel 12 in Injected Mode : Disabled */
            /* ADC Channel 13 in Injected Mode : Disabled */
            /* ADC Channel 14 in Injected Mode : Disabled */
            /* ADC Channel 15 in Injected Mode : Disabled */

/*-----------------------------------------------------------*/
/*         Threshold Control Register 0 (ADC_0_TRC0)            */
/*-----------------------------------------------------------*/
        ADC_0.TRC[0].R = 0x00000000;
            /* Threshold detection for WatchDog 0 : Disabled */
            /* Threshold Inversion for WatchDog 0:DIsabled */
            /* Threshold Channel Select for WatchDog 0 : 0    */

/*-----------------------------------------------------------*/
/*         Threshold Control Register 1 (ADC_0_TRC1)            */
/*-----------------------------------------------------------*/
        ADC_0.TRC[1].R = 0x00000000;
            /* Threshold detection for WatchDog 1 : Disabled */
            /* Threshold Inversion for WatchDog 1:DIsabled */
            /* Threshold Channel Select for WatchDog 1 : 0    */

/*-----------------------------------------------------------*/
/*         Threshold Control Register 2 (ADC_0_TRC2)            */
/*-----------------------------------------------------------*/
        ADC_0.TRC[2].R = 0x00000000;
            /* Threshold detection for WatchDog 2 : Disabled */
            /* Threshold Inversion for WatchDog 2:DIsabled */
            /* Threshold Channel Select for WatchDog 2 : 0    */

/*-----------------------------------------------------------*/
/*         Threshold Control Register 3 (ADC_0_TRC3)            */
/*-----------------------------------------------------------*/
        ADC_0.TRC[3].R = 0x00000000;
            /* Threshold detection for WatchDog 3 : Disabled */
            /* Threshold Inversion for WatchDog 3:DIsabled */
            /* Threshold Channel Select for WatchDog 3 : 0    */

/*-----------------------------------------------------------*/
/*            Threshold Register 0 (ADC_0_THRHLR0)          */
/*-----------------------------------------------------------*/
        ADC_0.THRHLR[0].R = 0x03FF0000;
            /* Lower Threshold value : 0    */
            /* Higher Threshold value : 1023    */

/*-----------------------------------------------------------*/
/*            Threshold Register 1 (ADC_0_THRHLR1)          */
/*-----------------------------------------------------------*/
        ADC_0.THRHLR[1].R = 0x03FF0000;
            /* Lower Threshold value : 0    */
            /* Higher Threshold value : 1023    */

/*-----------------------------------------------------------*/
/*            Threshold Register 2 (ADC_0_THRHLR2)          */
/*-----------------------------------------------------------*/
        ADC_0.THRHLR[2].R = 0x03FF0000;
            /* Lower Threshold value : 0    */
            /* Higher Threshold value : 1023    */

/*-----------------------------------------------------------*/
/*            Threshold Register 3 (ADC_0_THRHLR3)          */
/*-----------------------------------------------------------*/
        ADC_0.THRHLR[3].R = 0x03FF0000;
            /* Lower Threshold value : 0    */
            /* Higher Threshold value : 1023    */

/*-----------------------------------------------------------*/
/*Watchdog Threshold Interrupt Mask Register (ADC_0_WTIMR) */
/*-----------------------------------------------------------*/
        ADC_0.WTIMR.R = 0x00000000;
            /* Low Threshold Interrupt for Watchdog 0 : Disabled */
            /* Low Threshold Interrupt for Watchdog 1 : Disabled */
            /* Low Threshold Interrupt for Watchdog 2 : Disabled */
            /* Low Threshold Interrupt for Watchdog 3 : Disabled */
            /* High Threshold Interrupt for Watchdog 0 : Disabled */
            /* High Threshold Interrupt for Watchdog 1 : Disabled */
            /* High Threshold Interrupt for Watchdog 2 : Disabled */
            /* High Threshold Interrupt for Watchdog 3 : Disabled */



/*-----------------------------------------------------------*/
/*                ADC 1 Channel Setup            */
/*-----------------------------------------------------------*/

/*-----------------------------------------------------------*/
/*    Normal Channel Conversion Mask Register 0(ADC_1_NCMR0)*/
/*-----------------------------------------------------------*/
        ADC_1.NCMR[0].R = 0x00000020;
            /* ADC Channel 0 in Normal Mode : Disabled */
            /* ADC Channel 1 in Normal Mode : Disabled */
            /* ADC Channel 2 in Normal Mode : Disabled */
            /* ADC Channel 3 in Normal Mode : Disabled */
            /* ADC Channel 4 in Normal Mode : Disabled */
            /* ADC Channel 5 in Normal Mode : Enabled */
            /* ADC Channel 6 in Normal Mode : Disabled */
            /* ADC Channel 7 in Normal Mode : Disabled */
            /* ADC Channel 8 in Normal Mode : Disabled */
            /* ADC Channel 9 in Normal Mode : Disabled */
            /* ADC Channel 10 in Normal Mode : Disabled */
            /* ADC Channel 11 in Normal Mode : Disabled */
            /* ADC Channel 12 in Normal Mode : Disabled */
            /* ADC Channel 13 in Normal Mode : Disabled */
            /* ADC Channel 14 in Normal Mode : Disabled */
            /* ADC Channel 15 in Normal Mode : Disabled */

/*-----------------------------------------------------------*/
/*        Injected Channel Conversion Mask Register 0(ADC_1_JCMR0)*/
/*-----------------------------------------------------------*/
        ADC_1.JCMR[0].R = 0x00000000;
            /* ADC Channel 0 in Injected Mode : Disabled */
            /* ADC Channel 1 in Injected Mode : Disabled */
            /* ADC Channel 2 in Injected Mode : Disabled */
            /* ADC Channel 3 in Injected Mode : Disabled */
            /* ADC Channel 4 in Injected Mode : Disabled */
            /* ADC Channel 5 in Injected Mode : Disabled */
            /* ADC Channel 6 in Injected Mode : Disabled */
            /* ADC Channel 7 in Injected Mode : Disabled */
            /* ADC Channel 8 in Injected Mode : Disabled */
            /* ADC Channel 9 in Injected Mode : Disabled */
            /* ADC Channel 10 in Injected Mode : Disabled */
            /* ADC Channel 11 in Injected Mode : Disabled */
            /* ADC Channel 12 in Injected Mode : Disabled */
            /* ADC Channel 13 in Injected Mode : Disabled */
            /* ADC Channel 14 in Injected Mode : Disabled */
            /* ADC Channel 15 in Injected Mode : Disabled */

/*-----------------------------------------------------------*/
/*         Threshold Control Register 0 (ADC_1_TRC0)            */
/*-----------------------------------------------------------*/
        ADC_1.TRC[0].R = 0x00000000;
            /* Threshold detection for WatchDog 0 : Disabled */
            /* Threshold Inversion for WatchDog 0:DIsabled */
            /* Threshold Channel Select for WatchDog 0 : 0*/

/*-----------------------------------------------------------*/
/*         Threshold Control Register 1 (ADC_1_TRC1)            */
/*-----------------------------------------------------------*/
        ADC_1.TRC[1].R = 0x00000000;
            /* Threshold detection for WatchDog 1 : Disabled */
            /* Threshold Inversion for WatchDog 1:DIsabled */
            /* Threshold Channel Select for WatchDog 1 : 0*/

/*-----------------------------------------------------------*/
/*         Threshold Control Register 2 (ADC_1_TRC2)            */
/*-----------------------------------------------------------*/
        ADC_1.TRC[2].R = 0x00000000;
            /* Threshold detection for WatchDog 2 : Disabled */
            /* Threshold Inversion for WatchDog 2:DIsabled */
            /* Threshold Channel Select for WatchDog 2 : 0*/

/*-----------------------------------------------------------*/
/*         Threshold Control Register 3 (ADC_1_TRC3)            */
/*-----------------------------------------------------------*/
        ADC_1.TRC[3].R = 0x00000000;
            /* Threshold detection for WatchDog 3 : Disabled */
            /* Threshold Inversion for WatchDog 3:DIsabled */
            /* Threshold Channel Select for WatchDog 3 : 0*/

/*-----------------------------------------------------------*/
/*            Threshold Register 0 (ADC_1_THRHLR0)          */
/*-----------------------------------------------------------*/
        ADC_1.THRHLR[0].R = 0x03FF0000;
            /* Lower Threshold value : 0    */
            /* Higher Threshold value : 1023    */

/*-----------------------------------------------------------*/
/*            Threshold Register 1 (ADC_1_THRHLR1)          */
/*-----------------------------------------------------------*/
        ADC_1.THRHLR[1].R = 0x03FF0000;
            /* Lower Threshold value : 0    */
            /* Higher Threshold value : 1023    */

/*-----------------------------------------------------------*/
/*            Threshold Register 2 (ADC_1_THRHLR2)          */
/*-----------------------------------------------------------*/
        ADC_1.THRHLR[2].R = 0x03FF0000;
            /* Lower Threshold value : 0    */
            /* Higher Threshold value : 1023    */

/*-----------------------------------------------------------*/
/*            Threshold Register 3 (ADC_1_THRHLR3)          */
/*-----------------------------------------------------------*/
        ADC_1.THRHLR[3].R = 0x03FF0000;
            /* Lower Threshold value : 0    */
            /* Higher Threshold value : 1023    */

/*-----------------------------------------------------------*/
/*Watchdog Threshold Interrupt Mask Register (ADC_1_WTIMR) */
/*-----------------------------------------------------------*/
        ADC_1.WTIMR.R = 0x00000000;
            /* Low Threshold Interrupt for Watchdog 0 : Disabled */
            /* Low Threshold Interrupt for Watchdog 1 : Disabled */
            /* Low Threshold Interrupt for Watchdog 2 : Disabled */
            /* Low Threshold Interrupt for Watchdog 3 : Disabled */
            /* High Threshold Interrupt for Watchdog 0 : Disabled */
            /* High Threshold Interrupt for Watchdog 1 : Disabled */
            /* High Threshold Interrupt for Watchdog 2 : Disabled */
            /* High Threshold Interrupt for Watchdog 3 : Disabled */

}

/*********************  DMA Setup Function(s)************************/

void adc_dma_setup_fnc()
{
/*-----------------------------------------------------------*/
/*            ADC 0  DMA Enable Register (DMAE)            */
/*-----------------------------------------------------------*/
        ADC_0.DMAE.R = 0x00000000;    
            /*DMA Global : Disabled */
            /*DMA clear sequence : ACK from DMA */
/*-----------------------------------------------------------*/
/*            ADC 0  DMA Channel Select Registers DMAR_0        */
/*-----------------------------------------------------------*/
        ADC_0.DMAR[0].R =0x00000000;
            /* DMA 0 Disabled */
            /* DMA 1 Disabled */
            /* DMA 2 Disabled */
            /* DMA 3 Disabled */
            /* DMA 4 Disabled */
            /* DMA 5 Disabled */
            /* DMA 6 Disabled */
            /* DMA 7 Disabled */
            /* DMA 8 Disabled */
            /* DMA 9 Disabled */
            /* DMA 10 Disabled */
            /* DMA 11 Disabled */
            /* DMA 12 Disabled */
            /* DMA 13 Disabled */
            /* DMA 14 Disabled */
            /* DMA 15 Disabled */

/*-----------------------------------------------------------*/
/*             ADC 1 DMA Enable Register (DMAE)        */
/*-----------------------------------------------------------*/
        ADC_1.DMAE.R = 0x00000000;    
            /*DMA Global : Disabled */
            /*DMA clear sequence : ACK from DMA */
/*-----------------------------------------------------------*/
/*            ADC 1  DMA Channel Select Registers DMAR_0        */
/*-----------------------------------------------------------*/
        ADC_1.DMAR[0].R =0x00000000;
            /* DMA 0 Disabled */
            /* DMA 1 Disabled */
            /* DMA 2 Disabled */
            /* DMA 3 Disabled */
            /* DMA 4 Disabled */
            /* DMA 5 Disabled */
            /* DMA 6 Disabled */
            /* DMA 7 Disabled */
            /* DMA 8 Disabled */
            /* DMA 9 Disabled */
            /* DMA 10 Disabled */
            /* DMA 11 Disabled */
            /* DMA 12 Disabled */
            /* DMA 13 Disabled */
            /* DMA 14 Disabled */
            /* DMA 15 Disabled */
}

/*********************  CTU Initialization Function(s)  ************************/

void adc_ctu_fnc()
{
        
/*-----------------------------------------------------------*/
/*             ADC 0 CTU Control         */
/*-----------------------------------------------------------*/
        ADC_0.MCR.B.CTUEN =0;
            /* Cross Triggering Unit :  Disabled */

/*-----------------------------------------------------------*/
/*             ADC 1 CTU Control             */
/*-----------------------------------------------------------*/
        ADC_1.MCR.B.CTUEN =0;
            /* Cross Triggering Unit :  Disabled */

/*-----------------------------------------------------------*/
/*             Trigger generator sub unit control register CTU_TGSCR         */
/*-----------------------------------------------------------*/
        CTU_0.TGSCR.R =0x0000;
            /* Trigger Mode : Triggered */
            /* MRS Selection in Sequential Mode :0*/
            /* Prescaler :1*/
            /* Toggle mode for external trigger : Disabled*/

/*-----------------------------------------------------------*/
/*             Trigger 0 compare register  CTU_TCR[0]        */
/*-----------------------------------------------------------*/
         CTU_0.TCR[0].R  = 0x0000;
            /* Trigger 0 Compare Value  : 0*/

/*-----------------------------------------------------------*/
/*             Trigger 1 compare register  CTU_TCR[1]        */
/*-----------------------------------------------------------*/
         CTU_0.TCR[1].R  = 0x0000;
            /* Trigger 1 Compare Value  : 0*/

/*-----------------------------------------------------------*/
/*             Trigger 0 compare register  CTU_TCR[2]        */
/*-----------------------------------------------------------*/
         CTU_0.TCR[2].R  = 0x0000;
            /* Trigger 2 Compare Value  : 0*/

/*-----------------------------------------------------------*/
/*             Trigger 3 compare register  CTU_TCR[3]        */
/*-----------------------------------------------------------*/
         CTU_0.TCR[3].R  = 0x0000;
            /* Trigger 3 Compare Value  : 0*/

/*-----------------------------------------------------------*/
/*             Trigger 4 compare register  CTU_TCR[4]        */
/*-----------------------------------------------------------*/
         CTU_0.TCR[4].R  = 0x0000;
            /* Trigger 4 Compare Value  : 0*/

/*-----------------------------------------------------------*/
/*             Trigger 5 compare register  CTU_TCR[5]        */
/*-----------------------------------------------------------*/
         CTU_0.TCR[5].R  = 0x0000;
            /* Trigger 5 Compare Value  : 0*/

/*-----------------------------------------------------------*/
/*             Trigger 6 compare register  CTU_TCR[6]        */
/*-----------------------------------------------------------*/
         CTU_0.TCR[6].R  = 0x0000;
            /* Trigger 6 Compare Value  : 0*/

/*-----------------------------------------------------------*/
/*             Trigger 0 compare register  CTU_TCR[7]        */
/*-----------------------------------------------------------*/
         CTU_0.TCR[7].R  = 0x0000;
            /* Trigger 7 Compare Value  : 0*/

/*-----------------------------------------------------------*/
/*             TGS counter compare register CTU_TGSCCR         */
/*-----------------------------------------------------------*/
         CTU_0.TGSCCR.R  = 0x0000;
            /* Counter Compare value  : 0*/

/*-----------------------------------------------------------*/
/*             TGS counter reload register CTU_TGRCRR         */
/*-----------------------------------------------------------*/
         CTU_0.TGSCRR.R  = 0x0000;
            /* Counter Reload value  : 0*/

/*-----------------------------------------------------------*/
/*              Trigger generator sub unit input selection register CTU_TGSISR         */
/*-----------------------------------------------------------*/
         CTU_0.TGSISR.R  = 0x00000000;
            /*Input 0 selection : None*/
            /*Input 1 selection : None*/
            /*Input 2 selection : None*/
            /*Input 3 selection : None*/
            /*Input 4 selection : None*/
            /*Input 5 selection : None*/
            /*Input 6 selection : None*/
            /*Input 7 selection : None*/
            /*Input 8 selection : None*/
            /*Input 9 selection : None*/
            /*Input 10 selection : None*/
            /*Input 11 selection : None*/
            /*Input 12 selection : None*/
            /*Input 13 selection : None*/
            /*Input 14 selection : None*/
            /*Input 15 selection : None*/

/*********************  Cross Triggering Scheduling  ************************/

/*-----------------------------------------------------------*/
/*              Trigger handler control register 1 CTU_THCR1         */
/*-----------------------------------------------------------*/
        CTU_0.THCR1.R = 0x00000000;
            /* Trigger 0 Disabled*/
            /* Trigger 1 Disabled*/
            /* Trigger 2 Disabled*/
            /* Trigger 3 Disabled*/
            /* Trigger  0 ADC command output :  Disabled*/
            /* Trigger  1 ADC command output :  Disabled*/
            /* Trigger  2 ADC command output :  Disabled*/
            /* Trigger  3 ADC command output :  Disabled*/
            /* Trigger  0 Timer 0 output :  Disabled*/
            /* Trigger  1 Timer 0 output :  Disabled*/
            /* Trigger  2 Timer 0 output :  Disabled*/
            /* Trigger  3 Timer 0 output :  Disabled*/
            /* Trigger  0 Timer 1 output :  Disabled*/
            /* Trigger  1 Timer 1 output :  Disabled*/
            /* Trigger  2 Timer 1 output :  Disabled*/
            /* Trigger  3 Timer 1 output :  Disabled*/
            /* Trigger  0 External Trigger output  :  Disabled*/
            /* Trigger  1 External Trigger output  :  Disabled*/
            /* Trigger  2 External Trigger output  :  Disabled*/
            /* Trigger  3 External Trigger output  :  Disabled*/

/*-----------------------------------------------------------*/
/*              Trigger handler control register 2 CTU_THCR2         */
/*-----------------------------------------------------------*/
        CTU_0.THCR2.R = 0x00000000;
            /* Trigger 4 Disabled*/
            /* Trigger 5 Disabled*/
            /* Trigger 6 Disabled*/
            /* Trigger 7 Disabled*/
            /* Trigger  4 ADC command output :  Disabled*/
            /* Trigger  5 ADC command output :  Disabled*/
            /* Trigger  6 ADC command output :  Disabled*/
            /* Trigger  7 ADC command output :  Disabled*/
            /* Trigger  4 Timer 0 output :  Disabled*/
            /* Trigger  5 Timer 0 output :  Disabled*/
            /* Trigger 6 Timer 0 output :  Disabled*/
            /* Trigger  7 Timer 0 output :  Disabled*/
            /* Trigger  4 Timer 1 output :  Disabled*/
            /* Trigger  5 Timer 1 output :  Disabled*/
            /* Trigger  6 Timer 1 output :  Disabled*/
            /* Trigger  7 Timer 1 output :  Disabled*/
            /* Trigger  4 External Trigger output  :  Disabled*/
            /* Trigger  5 External Trigger output  :  Disabled*/
            /* Trigger  6 External Trigger output  :  Disabled*/
            /* Trigger  7 External Trigger output  :  Disabled*/

/*-----------------------------------------------------------*/
/*              Commands list control register 1 CTU_CLCR1         */
/*-----------------------------------------------------------*/
            CTU_0.CLCR1.R =0x00000000;
            /*Trigger 0 Command List Address  :0*/
            /*Trigger 1 Command List Address  :0*/
            /*Trigger 2 Command List Address  :0*/
            /*Trigger 3 Command List Address  :0*/

/*-----------------------------------------------------------*/
/*             Commands list control register 2 CTU_CLCR2         */
/*-----------------------------------------------------------*/
         CTU_0.CLCR2.R =0x00000000;
            /* Trigger 4 Command List Address  :0*/
            /* Trigger 5 Command List Address  :0*/
            /* Trigger 6 Command List Address  :0*/
            /* Trigger 7 Command List Address  :0*/


/****************  Command List Configuration  ****************/

/*-----------------------------------------------------------*/
/*              Cross triggering unit interrupt/DMA register         */
/*-----------------------------------------------------------*/
        CTU_0.CTUIR.R = 0x0000;
            /* Trigger 0 Interrupt : Disabled */
            /* Trigger 1 Interrupt : Disabled */
            /* Trigger 2 Interrupt : Disabled */
            /* Trigger 3 Interrupt : Disabled */
            /* Trigger 4 Interrupt : Disabled */
            /* Trigger 5 Interrupt : Disabled */
            /* Trigger 6 Interrupt : Disabled */
            /* Trigger 7 Interrupt : Disabled */
            /* Interrupt Error :  Disabled */
            /* MRS Interrupt :  Disabled */
            /* DMA transfer :  Disabled */

/*-----------------------------------------------------------*/
/*      Cross triggering unit control register CTU_CTUCR         */
/*-----------------------------------------------------------*/
        CTU_0.CTUCR.R = 0x0000;
            /* Trigger 0 Software Generated   :Disabled*/
            /* Trigger 1 Software Generated   :Disabled*/
            /* Trigger 2 Software Generated   :Disabled*/
            /* Trigger 3 Software Generated   :Disabled*/
            /* Trigger 4 Software Generated   :Disabled*/
            /* Trigger 5 Software Generated   :Disabled*/
            /* Trigger 6 Software Generated   :Disabled*/
            /* Trigger 7 Software Generated   :Disabled*/
            /* TGS Input Selection Register Reload :  Disabled */
            /* General Reload :  Disabled, This bit is Disabled while initialization */
            /* MRS Software Generated :  Disabled */
            /* Digital Filter   :  Disabled */
            /* CTU Output   :  Enabled */

/***********  CTU Control and Interrupt Configuration  ****************/
/*-----------------------------------------------------------*/
/*          Cross triggering unit power control register CTU_CTUPCR         */
/*-----------------------------------------------------------*/
        CTU_0.CTUPCR.B.MDIS =0;
            /*Module :  Enabled */

/*-----------------------------------------------------------*/
/*              Control ON time register CTU_COTR         */
/*-----------------------------------------------------------*/
         CTU_0.COTR.B.COTR  = 0x0000;
            /* Control ON-Time and Guard Time: 0 Cycles*/

/*-----------------------------------------------------------*/
/*          Cross triggering unit digital filter CTU_CTUDF         */
/*-----------------------------------------------------------*/

         CTU_0.CTUFILTER.R  = 0x0000;
            /*Signal is taken as valid after :0 Occurrances */


/*-----------------------------------------------------------*/
/*              FIFO DMA control register CTU_FDCR         */
/*-----------------------------------------------------------*/
         CTU_0.CR.R  = 0x0000;
            /* DMA for the FIFO_0: Disabled */
            /* DMA for the FIFO_1: Disabled */
            /* DMA for the FIFO_2: Disabled */
            /* DMA for the FIFO_3: Disabled */


/*-----------------------------------------------------------*/
/*              FIFO Interrupt control register CTU_FCR         */
/*-----------------------------------------------------------*/
         CTU_0.FCR.R  = 0x00000000;
            /* FIFO Full interrupt for FIFO_0: Disabled */
            /* FIFO Full interrupt for FIFO_1: Disabled */
            /* FIFO Full interrupt for FIFO_2: Disabled */
            /* FIFO Full interrupt for FIFO_3: Disabled */
            /* FIFO Empty interrupt for FIFO_0: Disabled */
            /* FIFO Empty interrupt for FIFO_1: Disabled */
            /* FIFO Empty interrupt for FIFO_2: Disabled */
            /* FIFO Empty interrupt for FIFO_3: Disabled */
            /* FIFO threshold Overflow interrupt for FIFO_0: Disabled */
            /* FIFO threshold Overflow interrupt for FIFO_1: Disabled */
            /* FIFO threshold Overflow interrupt for FIFO_2: Disabled */
            /* FIFO threshold Overflow interrupt for FIFO_3: Disabled */
            /* FIFO Overrun interrupt for FIFO_0: Disabled */
            /* FIFO Overrun interrupt for FIFO_1: Disabled */
            /* FIFO Overrun interrupt for FIFO_2: Disabled */
            /* FIFO Overrun interrupt for FIFO_3: Disabled */


/*-----------------------------------------------------------*/
/*              FIFO threshold CTU_FTH (TH1)         */
/*-----------------------------------------------------------*/
         CTU_0.TH1.R  = 0x00000000;
            /* Threshold value for FIFO_0:0*/
            /* Threshold value for FIFO_1:0*/
            /* Threshold value for FIFO_2:0*/
            /* Threshold value for FIFO_3:0*/

/*-----------------------------------------------------------*/
/*              General Reload Feature                       */
/*-----------------------------------------------------------*/
        CTU_0.CTUCR.B.GRE = 0;
            /* General Reload :  Disabled */

}

 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

