/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : adc_ctu_var.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : This file contains the CTU variable and Queues definition.
 *
 ******************************************************************************** 
 *
 * Detail Description     : This File contains variable and Queue used to hold CTU commands.
 *                          These commands are move to CTU Data Register on DMA request.
 *                          Queues and variable can also be used with interrupts
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "typedefs.h"



/********************  ADC DMA Variables  **********************/

vuint32_t adc_0_datareg[16]= {0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U};/* Read Buffer for  ADC 0*/
vuint32_t adc_1_datareg[16]= {0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U,0U};/* Read Buffer for  ADC 1*/

/********************  CTU DMA Variables  **********************/

vuint32_t CTU_FIFO_0[1]= {0U};/*Read Buffer for FIFO 0*/
vuint32_t CTU_FIFO_1[1]= {0U};/*Read Buffer for FIFO 1*/
vuint32_t CTU_FIFO_2[1]= {0U};/*Read Buffer for FIFO 2*/
vuint32_t CTU_FIFO_3[1]= {0U};/*Read Buffer for FIFO 3*/


 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

