/*
 * ADC.c
 *
 *  Created on: 03/08/2012
 *      Author: B34981
 */

#include "ADC.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    ADC_Init - Initiates the Channel0 to read the Potentiometer with standard features
* 				as 8-bit resolution. 
* @param    none
* @return   none
*
************************************************************************************************/  
void ADC_Init()
{
	ADC_SC3_ADICLK = 0;						/* Bus clock selected*/
	ADC_SC3_ADIV   = 0;						/* Divide ration = 1, clock rate = Input clock */
	ADC_SC2_ADTRG  = 0;						/* Software trigger*/
	ADC_SC2_ACFE   = 0;						/* Disable compare function*/
	ADC_SC1_ADCO   = 0;						/* No continuous conversion*/
	ADC_SC1_AIEN   = 0;						/* Disable conversion complete interrupt*/
	ADC_APCTL1_ADPC0 = 1;					/* Enable ADC pin 0 */
	ADC_SC3_MODE   = 0;						/* 8-bit mode resolution*/
}


/***********************************************************************************************
*
* @brief    ADC_Read - Read the selected ADC channel
* @param    ch - channel to read
* @return   UINT8 8-bit resolution result
*
************************************************************************************************/
UINT8 ADC_Read(UINT8 ch)
{
	ADC_SC1_ADCH = ch;					/* Set the channel to read, trigger ADC */
	while(!ADC_SC1_COCO);				/* While conversion hasn't been completed */
	return ADC_RL;						/* Return ADC read */
}  

