/******************************************************************************								
*    LAB2 - Flex Timer (FTM)                                                  *								
*                                                                             *								
*       This lab demonstrates how to use the FTM module to generate           *								
*    periodical interrupts of different frequencies. Each of the four LEDs    *								
*    is configured to toggle at a different frequency which is configurable   *								
*    using the FTM_SetPeriod() function.                                      *								
******************************************************************************/								



/**********************************************************************************************
* External objects
**********************************************************************************************/
#include <hidef.h> 
#include "derivative.h"

#include "main.h"
#include "COP.h"
#include "CLK.h"
#include "FTM.h"


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/

/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/
	void FTM_Interrupt(UINT8 ch);

/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

	
/***********************************************************************************************
*
* @brief    GPIO_Init - Initialize the LEDs as outputs
* @param    none
* @return   none
*
************************************************************************************************/
void GPIO_Init()
{
  PORT_PTGOE_PTGOE0 = 1;		/* Init LEDs as outputs */
  PORT_PTGOE_PTGOE1 = 1;
  PORT_PTGOE_PTGOE2 = 1;
  PORT_PTGOE_PTGOE3 = 1;	
  
  PORT_PTDIE_PTDIE4 = 1;		/* Button pins as inputs */
  PORT_PTDIE_PTDIE5 = 1;
  
  PORT_PTGD = 0xFF;				/* LEDs OFF */		
}	
	
	
	
/***********************************************************************************************
*
* @brief    main() - Program entry function
* @param    none
* @return   none
*
************************************************************************************************/  
void main(void) {
  
  COP_Disable();			/* Disable Watchdog */
  CLK_Init();				/* Configure clocks to run at 16Mhz */
  GPIO_Init();				/* Configure button pins as inputs and LED pins as outputs */
  
  
  
  FTM_SetPeriod(0, 0xFFFF);				/* Configure FTM channel 0 to toggle each 0xFFFF x 2 uS */
  FTM_SetPeriod(1, 0xDFFF);				/* Configure FTM channel 0 to toggle each 0xDFFF x 2 uS */
  FTM_SetPeriod(2, 0xBFFF);				/* Configure FTM channel 0 to toggle each 0xBFFF x 2 uS */
  FTM_SetPeriod(3, 0x9FFF);				/* Configure FTM channel 0 to toggle each 0x9FFF x 2 uS */
  FTM_SetCallback(FTM_Interrupt);		/* Set the callback function to be called */
  FTM_Init();							/* Initialize the FTM module */
  EnableInterrupts;
  for(;;) 
  {	
	  
  }
  
}


/***********************************************************************************************
*
* @brief    FTM_Interrupt(UINT8 ch). Function callback called by the FTM module on each timer interrupt.
* @param    none
* @return   none
*
************************************************************************************************/  
void FTM_Interrupt(UINT8 ch)
	{
		switch(ch)
		{
		case 0:
			LED1_TOGGLE;
			break;
		case 1:
			LED2_TOGGLE;
			break;
		case 2:
			LED3_TOGGLE;
			break;
		case 3:
			LED4_TOGGLE;
			break;
		}
	}
