/*
 * SCI.c
 *
 *  Created on: 01/08/2012
 *      Author: B34981
 */

#include "SCI.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/
pt2FuncU8 SCI_Callback;

/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/
void SCI_RX_ISR(void);


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    SCI_Init - Initializes the SCI2 to run at 9600 bauds assuming bus clock of 16Mhz
* @param    none
* @return   none
*
************************************************************************************************/  
void SCI_Init()
{
	SCI2_BDH_SBNS = 0;			/* One stop bit only */
	SCI2_BD = SCI2_BD | 104;	/* Select the baud rate, BD_Divider = BUS_CLK/16/BAUDRATE = 16M/16/9600 = 104 */	 
    
    SCI2_C1  = 0;     			/* 8bit mode, 1 stop bit, no parity */
    SCI2_C2_TE  = 1;  			/* Enable TX */
    SCI2_C2_RE  = 1;  			/* Enable RX */
    
    SCI2_C2_RIE  = 1;  			/* Enable Reception Interrupt */
}


/***********************************************************************************************
*
* @brief    SCI_SetCallback - Set a callback function to execute when a byte is received on the SCI2
* @param    pointer to function with an UINT8 argument
* @return   none
*
************************************************************************************************/  
void SCI_SetCallback(pt2FuncU8 ptr)
{
	SCI_Callback = ptr;	
}

/***********************************************************************************************
*
* @brief    SCI_SendChar - Send a single byte on SCI2 
* @param    byte to send
* @return   none
*
************************************************************************************************/  
void SCI_SendChar(UINT8 send)
{
  UINT8 dummy;

  while(!( SCI2_S1 & SCI2_S1_TDRE_MASK));
  dummy = SCI2_S1;
  SCI2_D  = send;
}


/***********************************************************************************************
*
* @brief    SCI_GetChar - Retrieve the received char from the SCI2 buffer (should be called from Interrupt) 
* @param    none
* @return   received byte
*
************************************************************************************************/  
UINT8 SCI_GetChar()
{
  UINT8 dummy;

  while(( SCI2_S1 & SCI2_S1_RDRF_MASK) !=SCI2_S1_RDRF_MASK);
  dummy = SCI2_S1;
  dummy = SCI2_D;
  return dummy;
} 


/***********************************************************************************************
*
* @brief    SCI_RX_ISR - SCI2 reception interrupt, calls the user defined callback function 
* @param    none
* @return   none
*
************************************************************************************************/
interrupt VectorNumber_Vsci2rx void SCI_RX_ISR()
{
UINT8 data=0;

SCI2_S1_RDRF = 1;		/* Clear reception flag */

SCI_Callback(SCI_GetChar());
}
