/*
 *########################################################################
 *                (c) Copyright 2013 Freescale Semiconductor, Inc.
 *                         ALL RIGHTS RESERVED. 
 *########################################################################
 * 
 * Brief Description     : ADC driver file
 *
 **************************************************************************
*/
/******************************************************************************
* Includes
******************************************************************************/
#include "adc_drv.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Local Functions
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Static variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/

/******************************************************************************
*   Function: A2D_GetSingleCh_12bit
*
*   Description: Sets up, starts, and returns a conversion for a single channel
*
******************************************************************************/
uint16_t A2D_GetSingleCh_12bit(uint32_t ch)
{
    uint16_t result;

    ADC_1.NCMR0.R = (uint32_t)(0x00000001 << ch);

    ADC_1.MCR.B.NSTART = 1;  /* Trigger ADC Conversion */

    while (ADC_1.CDR[ch].B.VALID != 1)
    {
    }
    result = (uint16_t)((ADC_1.CDR[ch].B.CDATA));

    return(result);
}

/******************************************************************************
*   Function: A2D_GetSingleCh_10bit
*
*   Description: Sets up, starts, and returns a conversion for a single channel
*
******************************************************************************/
uint16_t A2D_GetSingleCh_10bit(uint32_t ch)
{
    uint16_t result;

    ADC_0.NCMR0.R = (uint32_t)(0x00000001 << ch);
    if (ch >= 32)
    {
        ADC_0.NCMR1.R = (uint32_t)(0x00000001 << (ch - 32));
    }
    if (ch >= 64)
    {
        ADC_0.NCMR2.R = (uint32_t)(0x00000001 << (ch - 64));
    }

    ADC_0.MCR.B.NSTART = 1;  /* Trigger ADC Conversion */

    while (ADC_0.CDR[ch].B.VALID != 1)
    {
    }
    result = (uint16_t)((ADC_0.CDR[ch].B.CDATA));

    return(result);
}

/******************************************************************************
*   Function: A2D_GetChResult_12bit
*
*   Description: Returns the result value for a single channel
*
******************************************************************************/
uint16_t A2D_GetChResult_12bit(uint32_t ch)
{
    uint16_t result;

    if (ch < 16)    /* Verify the channel count value */
    {
        result = (uint16_t)((ADC_1.CDR[ch].B.CDATA));
    }
    return(result);
}
/******************************************************************************
*   Function: A2D_GetChResult_10bit
*
*   Description: Returns the result value for a single channel
*
******************************************************************************/
uint16_t A2D_GetChResult_10bit(uint32_t ch)
{
    uint16_t result;

    if ((ch >= 32) && (ch <= 59))    /* Verify the channel count value */
    {
        result = (uint16_t)((ADC_0.CDR[ch].B.CDATA));
    }

    return(result);
}
/******************************************************************************
*   Function: A2D_SetupCh_12bit
*
*   Description: Sets up channel for the ADC converter
*
******************************************************************************/
void A2D_SetupCh_12bit(uint32_t ch)
{
   if (ch < 16)    /* Verify the channel count value */
   {
      ADC_1.NCMR0.R = (uint32_t)((0x00000001 << ch) | ADC_1.NCMR0.R);
   }
}

/******************************************************************************
*   Function: A2D_SetupCh_10bit
*
*   Description: Sets up channel for the ADC converter
*
******************************************************************************/
void A2D_SetupCh_10bit(uint32_t ch)
{
	if (ch < 96)    /* Verify the channel count value */
	{
		ADC_0.NCMR0.R = (uint32_t)((0x00000001 << ch) | ADC_0.NCMR0.R);
		if (ch >= 32)
		{
		    ADC_0.NCMR1.R = (uint32_t)((0x00000001 << (ch - 32)) | ADC_0.NCMR1.R);
		}
		if (ch >= 64)
		{
		    ADC_0.NCMR2.R = (uint32_t)((0x00000001 << (ch - 64)) | ADC_0.NCMR2.R);
		}
	}
 }
 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/



