/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name: arch.h$
*
* $Date:      May-14-2013$
*
* $Version:   2.5.7.0$
*
* Description: Peripheral space map of the MC56F827xx device
*
*****************************************************************************/

#ifndef __ARCH_H
#define __ARCH_H

#ifndef __TYPES_H
#error types.h must be included before arch.h
#endif

/* System Integration Module */

#define SIM_VERSION 8   // MC56F827xx
#define SIM_VERSION_8

typedef volatile struct 
{
    ARCH_REG4(UWord16, sim_control, sim_ctrl, control, ControlReg);
    ARCH_REG4(UWord16, sim_rststs,  sim_rstat, rststs, StatusReg);
    ARCH_REG1(UWord16, sim_reserved1[4]);
    ARCH_REG3(UWord16, sim_msh_id,  sim_mshid, msh_id);
    ARCH_REG3(UWord16, sim_lsh_id,  sim_lshid, lsh_id);
    ARCH_REG3(UWord16, sim_power,   sim_pwr, power);
    ARCH_REG1(UWord16, sim_reserved2);
    ARCH_REG3(UWord16, sim_clkosr,  sim_clkout, clkosr);
    ARCH_REG1(UWord16, sim_pcr);
    ARCH_REG1(UWord16, sim_pce0);
    ARCH_REG1(UWord16, sim_pce1);
    ARCH_REG1(UWord16, sim_pce2);
    ARCH_REG1(UWord16, sim_pce3);
    ARCH_REG1(UWord16, sim_sd0);
    ARCH_REG1(UWord16, sim_sd1);
    ARCH_REG1(UWord16, sim_sd2);
    ARCH_REG1(UWord16, sim_sd3);
    ARCH_REG3(UWord16, sim_isalh,   sim_iosahi, isalh);
    ARCH_REG3(UWord16, sim_isall,   sim_iosalo, isall);
    ARCH_REG1(UWord16, sim_prot);
    ARCH_REG1(UWord16, sim_gpsal);
    ARCH_REG1(UWord16, sim_gpsbl);
    ARCH_REG1(UWord16, sim_gpscl);
    ARCH_REG1(UWord16, sim_gpsch);
    ARCH_REG1(UWord16, sim_reserved3);
    ARCH_REG1(UWord16, sim_gpsel);
    ARCH_REG1(UWord16, sim_reserved4);
    ARCH_REG1(UWord16, sim_gpsfl);
    ARCH_REG1(UWord16, sim_gpsfh);
    ARCH_REG1(UWord16, sim_reserved5);
    ARCH_REG1(UWord16, sim_reserved6);
    ARCH_REG2(UWord16, sim_ips0, sim_ipsn); 
    ARCH_REG1(UWord16, sim_misc0);
    ARCH_REG1(UWord16, sim_pswr0);
    ARCH_REG1(UWord16, sim_pswr1);
    ARCH_REG1(UWord16, sim_pswr2);
    ARCH_REG1(UWord16, sim_pswr3);
    ARCH_REG1(UWord16, sim_pwrmode);
    ARCH_REG1(UWord16, sim_reserved7);
    ARCH_REG1(UWord16, sim_reserved8);
    ARCH_REG1(UWord16, sim_reserved9);
    ARCH_REG1(UWord16, sim_nvmopt2h);
    ARCH_REG1(UWord16, sim_nvmopt2l);
    ARCH_REG1(UWord16, sim_reserved10[23]);
    ARCH_REG1(UWord16, sim_scr0);
    ARCH_REG1(UWord16, sim_scr1);
    ARCH_REG1(UWord16, sim_scr2);
    ARCH_REG1(UWord16, sim_scr3);
    ARCH_REG1(UWord16, sim_scr4);
    ARCH_REG1(UWord16, sim_scr5);
    ARCH_REG1(UWord16, sim_scr6);
    ARCH_REG1(UWord16, sim_scr7);
    
    ARCH_REG1(UWord16, sim_reserved11[179]);

} arch_sSIM;

/* Quad Timer Module */

#define QT_VERSION 5
#define QT_VERSION_5

typedef volatile struct
{
    ARCH_REG4(UWord16, tmrcmp1,   comp1, cmp1, CompareReg1);
    ARCH_REG4(UWord16, tmrcmp2,   comp2, cmp2, CompareReg2);
    ARCH_REG4(UWord16, tmrcap,    capt, cap, CaptureReg);
    ARCH_REG3(UWord16, tmrload,   load, LoadReg);
    ARCH_REG3(UWord16, tmrhold,   hold, HoldReg);
    ARCH_REG3(UWord16, tmrcntr,   cntr, CounterReg);
    ARCH_REG3(UWord16, tmrctrl,   ctrl, ControlReg);
    ARCH_REG4(UWord16, tmrscr,    sctrl, scr, StatusControlReg);
    ARCH_REG2(UWord16, tmrcmpld1, cmpld1);
    ARCH_REG2(UWord16, tmrcmpld2, cmpld2);
    ARCH_REG3(UWord16, tmrcomscr, csctrl, comscr);
    ARCH_REG1(UWord16, filt);
    ARCH_REG1(UWord16, dma);
    ARCH_REG1(UWord16, reserved[2]);
    ARCH_REG1(UWord16, enbl);

} arch_sTimerChannel;

typedef volatile struct
{
    ARCH_REG2(arch_sTimerChannel, ch0, Channel0);
    ARCH_REG2(arch_sTimerChannel, ch1, Channel1);
    ARCH_REG2(arch_sTimerChannel, ch2, Channel2);
    ARCH_REG2(arch_sTimerChannel, ch3, Channel3);

} arch_sTimer;
/* EFPWM Module */

#define EFPWM_VERSION 3	// MC56F827xx
#define EFPWM_VERSION_3
#define EFPWM_HAS_FAULTS  0xf

typedef volatile struct
{
    ARCH_REG1(Word16, smcnt); // FlexPWM base address + 0h  read only
    ARCH_REG1(Word16, sminit); // 1h --
    ARCH_REG1(UWord16, smctrl2); // 2h --
    ARCH_REG1(UWord16, smctrl);  // 3h --
    ARCH_REG1(UWord16, reserved1); // 4h 
    ARCH_REG1(Word16, smval0); // 5h --
    ARCH_REG1(UWord16, smfracval1); // 6h --
    ARCH_REG1(Word16, smval1); // 7h --
    ARCH_REG1(UWord16, smfracval2); // 8h --
    ARCH_REG1(Word16, smval2);  //9h  --
    ARCH_REG1(UWord16, smfracval3); // Ah --
    ARCH_REG1(Word16, smval3); // Bh --
    ARCH_REG1(UWord16, smfracval4); // Ch --
    ARCH_REG1(Word16, smval4); // Dh --
    ARCH_REG1(UWord16, smfracval5); // Eh --
    ARCH_REG1(Word16, smval5); // Fh --
    ARCH_REG1(UWord16, smfrctrl); // 10h --
    ARCH_REG1(UWord16, smoctrl); // 11h --
    ARCH_REG1(UWord16, smsts); // 12h read only
    ARCH_REG1(UWord16, sminten); // 13h --
    ARCH_REG1(UWord16, smdmaen); // 14h - new reg. comparing to Anguilla Black, DMA enable
    ARCH_REG1(UWord16, smtctrl); // 15h --
    ARCH_REG2(UWord16, smdismap, smdismap0); // 16h ?????, Fault disable mapping reg 0, fault channel 0 --
    ARCH_REG1(UWord16, smdismap1); // 17h  new reg. comparing to Anguilla Black, fault channel 1 --
    ARCH_REG1(UWord16, smdtcnt0); // 18h ???? - not the same address comparing to Anguilla Black --
    ARCH_REG1(UWord16, smdtcnt1); // 19h ???? - not the same address comparing to Anguilla Black --
    ARCH_REG1(UWord16, smcaptctrla); // 1Ah ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcaptcompa); // 1Bh ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcaptctrlb); // 1Ch ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcaptcompb); // 1Dh ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcaptctrlx); // 1Eh ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcaptcompx); // 1Fh ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval0); // 20h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval0cyc); // 21h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval1); // 22h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval1cyc); // 23h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval2); // 24h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval2cyc); // 25h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval3); // 26h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval3cyc); // 27h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval4); // 28h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval4cyc); // 29h ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval5); // 2Ah ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, smcval5cyc); // 2Bh ???? - new reg. comparing to Anguilla Black
    ARCH_REG1(UWord16, reserved3[4]);//
} arch_sEFPWMSubFracCaptModule;  // structure length = 30h = 48d

//Debug LP
typedef volatile struct
{
    ARCH_REG1(Word16, smcnt);
    ARCH_REG1(Word16, sminit);
    ARCH_REG1(UWord16, smctrl2);
    ARCH_REG1(UWord16, smctrl);
    ARCH_REG1(UWord16, reserved1);
    ARCH_REG1(Word16, smval0);
    ARCH_REG1(UWord16, reserved10);
    ARCH_REG1(Word16,  smval1);
    ARCH_REG1(UWord16, reserved11);
    ARCH_REG1(Word16, smval2); // 10
    ARCH_REG1(UWord16, reserved12);
    ARCH_REG1(Word16, smval3);
    ARCH_REG1(UWord16, reserved13);
    ARCH_REG1(Word16, smval4);
    ARCH_REG1(UWord16, reserved14);
    ARCH_REG1(Word16, smval5);
    ARCH_REG1(UWord16, reserved15);
    ARCH_REG1(UWord16, smoctrl);
    ARCH_REG1(UWord16, smsts);
    ARCH_REG1(UWord16, sminten); //20
    ARCH_REG1(UWord16, reserved2);
    ARCH_REG1(UWord16, smtctrl);
    ARCH_REG1(UWord16, smdismap);
    ARCH_REG1(UWord16, smdtcnt0);
    ARCH_REG1(UWord16, smdtcnt1);
    ARCH_REG1(UWord16, reserved3);
    ARCH_REG1(UWord16, smcaptctrla);
    ARCH_REG1(UWord16, smcaptcompa);
    ARCH_REG1(UWord16, smcaptctrlb);
    ARCH_REG1(UWord16, smcaptcompb); // 30
    ARCH_REG1(UWord16, smcaptctrlx);
    ARCH_REG1(UWord16, smcaptcompx);
    ARCH_REG1(Word16, smcval0);
    ARCH_REG1(UWord16, reserved4);
    ARCH_REG1(Word16, smcval1);
    ARCH_REG1(UWord16, reserved5);
    ARCH_REG1(Word16, smcval2);
    ARCH_REG1(UWord16, reserved6);
    ARCH_REG1(Word16, smcval3);
    ARCH_REG1(UWord16, reserved7); // 40
    ARCH_REG1(Word16, smcval4);
    ARCH_REG1(UWord16, reserved8);
    ARCH_REG1(Word16, smcval5); // 43
    ARCH_REG1(UWord16, reserved9[5]); //48
} arch_sEFPWMSubCaptModule;

typedef volatile struct
{
    ARCH_REG2(arch_sEFPWMSubFracCaptModule, Sub0, Submodule0);
    ARCH_REG2(arch_sEFPWMSubFracCaptModule, Sub1, Submodule1);
    ARCH_REG2(arch_sEFPWMSubFracCaptModule, Sub2, Submodule2);
    ARCH_REG2(arch_sEFPWMSubFracCaptModule, Sub3, Submodule3);
    ARCH_REG1(UWord16, outen); // FlexPWM base address + C0h
    ARCH_REG1(UWord16, mask); // C1h
    ARCH_REG1(UWord16, swcount); //C2h
    ARCH_REG1(UWord16, dtsrcsel); // C3h
    ARCH_REG1(UWord16, mctrl); // C4h
    ARCH_REG1(UWord16, mctrl2); // C5h
    ARCH_REG2(UWord16, fctrl, fctrl0); // LP C6h - old reg but new name due to multiple ctrl regs
    ARCH_REG2(UWord16, fsts, fsts0); // C7h - old reg but new name due to multiple sts regs
    ARCH_REG2(UWord16, ffilt, ffilt0); // C8h - old reg but new name due to multiple filt regs
    ARCH_REG1(UWord16, ftst0); // C9h - new register comparing to Anguilla Black
    ARCH_REG1(UWord16, fctrl1); // CAh - new register comparing to Anguilla Black
    ARCH_REG1(UWord16, fsts1); // CBh - new register comparing to Anguilla Black
    ARCH_REG1(UWord16, ffilt1); // CCh - new register comparing to Anguilla Black 
    ARCH_REG1(UWord16, ftst1); // CDh - new register comparing to Anguilla Black
    ARCH_REG1(UWord16, reserved3[50]); //0x32 
} arch_sEFPWM;

/* Interrupt Controller */

#define INTC_VERSION 6  // For 844,854,827
#define INTC_VERSION_6
#define INTC_HAS_IRQPINS 0
typedef volatile struct
{
    ARCH_REG2(UWord16, ipr[13],     PriorityReg[13]);
    ARCH_REG2(UWord16, vba,        VecBaseReg);
    ARCH_REG2(UWord16, fim0,       FastInt0MatchReg);
    ARCH_REG2(UWord16, fival0,     FastInt0AddrLReg);
    ARCH_REG2(UWord16, fivah0,     FastInt0AddrHReg);
    ARCH_REG2(UWord16, fim1,       FastInt1MatchReg);
    ARCH_REG2(UWord16, fival1,     FastInt1AddrLReg);
    ARCH_REG2(UWord16, fivah1,     FastInt1AddrHReg);
    ARCH_REG2(UWord16, irqp[7],    IntPendingReg[7]);
    ARCH_REG3(UWord16, ictl,       ControlReg, ctrl);
    ARCH_REG1(UWord16, reserved1[4]);

} arch_sIntc;



/* A/D Converter */

#define ADC_VERSION 7	// 56F827xx devices, see MC56F827xxRM.pdf
#define ADC_VERSION_7

typedef volatile struct
{

    ARCH_REG4(UWord16, adctl1,    ctrl1, adcr1, Control1Reg); // offset - 0x0000, module base address - 0xE500, module size - from 0xE500 to 0xE57F
    ARCH_REG4(UWord16, adctl2,    ctrl2, adcr2, Control2Reg); // 0x0001
    ARCH_REG3(UWord16, adzcc,     zxctrl1, ZeroCrossControlReg1); // 0x0002, new reg name, orig names - zxctrl, ZeroCrossControlReg
    ARCH_REG2(UWord16, zxctrl2,   ZeroCrossControlReg2); // 0x0003, new reg
    ARCH_REG3(UWord16, adlst1,    clist1, ChannelList1Reg); // 0x0004
    ARCH_REG3(UWord16, adlst2,    clist2, ChannelList2Reg); // 0x0005
    ARCH_REG3(UWord16, adlst3,    clist3, ChannelList3Reg); // 0x0006
    ARCH_REG3(UWord16, adlst4,    clist4, ChannelList4Reg); // 0x0007
    ARCH_REG3(UWord16, adsdis,    sdis, DisableReg); // 0x0008
    ARCH_REG3(UWord16, adstat,    stat, StatusReg); // 0x0009
    ARCH_REG2(UWord16, cnrdy, rdy); // 0x000A, new reg name
    ARCH_REG1(UWord16, lolimstat); // 0x000B, new reg
    ARCH_REG1(UWord16, hilimstat); // 0x000C, new reg
    ARCH_REG3(UWord16, adzcstat,  zxstat, ZeroCrossStatusReg); // 0x000D
    ARCH_REG3(UWord16, adrslt[16], rslt[16], ResultReg[16]); //0x000E - 0x001D, 16 registers -> rslt0 - rslt15
    ARCH_REG3(UWord16, adllmt[16], lolim[16], LowLimitReg[16]); //0x001E - 0x002D, 16 registers -> lolim0 - lolim15, more lolim registers
    ARCH_REG3(UWord16, adhlmt[16], hilim[16], HighLimitReg[16]); //0x002E - 0x003D, 16 registers -> hilim0 - hilim15, more hilim registers
    ARCH_REG3(UWord16, adofs[16],  offst[16], OffsetReg[16]); //0x003E - 0x004D, 16 registers -> offst0 - offst15, more offst registers
    ARCH_REG2(UWord16, adcpower,  pwr); // 0x004E
    ARCH_REG2(UWord16, adc_cal,   cal); // 0x004F
    ARCH_REG2(UWord16, adc_gc1,   gc1); // 0x0050
    ARCH_REG2(UWord16, adc_gc2,   gc2); // 0x0051
    ARCH_REG2(UWord16, adc_sctrl, sctrl); // 0x052
    ARCH_REG2(UWord16, adc_pwr2,  pwr2); // 0x0053
    ARCH_REG4(UWord16, adctl3,    ctrl3, adcr3, Control3Reg); // 0x0054, new reg
    ARCH_REG2(UWord16, schlten, adc_schlten); // 0x0055, new reg   
    ARCH_REG1(UWord16, reserved2[2]);
    ARCH_REG2(UWord16, zxctrl3,   ZeroCrossControlReg3); //0x0058
    ARCH_REG3(UWord16, adlst5,    clist5, ChannelList5Reg);//0x0059
    ARCH_REG2(UWord16, adsdis2, 	  sdis2); //0x005A
    ARCH_REG2(UWord16, cnrdy2, rdy2); //0x005B
    ARCH_REG1(UWord16, lolimstat2); //0x005C
    ARCH_REG1(UWord16, hilimstat2); //0x005D
    ARCH_REG3(UWord16, adzcstat2,  zxstat2, ZeroCrossStatusReg2); //0x005E
    ARCH_REG3(UWord16, adrslt2[4], rslt2[4], ResultReg2[4]); //0x005F - 0x0062
    ARCH_REG3(UWord16, adllmt2[4], lolim2[4], LowLimitReg2[4]); //0x0063 - 0x0066
    ARCH_REG3(UWord16, adhlmt2[4], hilim2[4], HighLimitReg2[4]); //0x0067 - 0x006A
    ARCH_REG3(UWord16, adofs2[4],  offst2[4], OffsetReg2[4]); //0x006B - 0x006E
    ARCH_REG2(UWord16, adc_gc3,   gc3); //0x006f
    ARCH_REG2(UWord16, adc_sctrl2, sctrl2); //0x0070
    ARCH_REG1(UWord16, schlten2); //0x0071    
    ARCH_REG1(UWord16, reserved[14]); // 14 words reserved   
} arch_sADC;

/* Queued Serial Communication Interface */

#define SCI_VERSION 6
#define SCI_VERSION_6        // for 56f827xx

typedef volatile struct
{
    ARCH_REG3(UWord16, scibr,    BaudRateReg, rate);
    ARCH_REG3(UWord16, scicr,    ControlReg, ctrl1);
    ARCH_REG3(UWord16, scicr2,   ControlReg2, ctrl2); /* VERSION_2,3-specific */
    ARCH_REG3(UWord16, scisr,    StatusReg, stat);
    ARCH_REG3(UWord16, scidr,    DataReg, data);
    ARCH_REG1(UWord16, ctrl3);                       /* VERSION_5-specific */
    ARCH_REG1(UWord16, reserved2[10]);

} arch_sSCI;

#define SPI_VERSION 5
#define SPI_VERSION_5


typedef volatile struct
{
    ARCH_REG3(UWord16, spscr,    sctrl, ControlReg);
    ARCH_REG4(UWord16, spdsr,    dsctrl, spdscr, DataSizeReg);
    ARCH_REG3(UWord16, spdrr,    drcv, DataRxReg);
    ARCH_REG3(UWord16, spdtr,    dxmit, DataTxReg);
    ARCH_REG2(UWord16, fifo, spfifo);
    ARCH_REG2(UWord16, delay, spwait);
    ARCH_REG1(UWord16, spctl2);
    ARCH_REG1(UWord16, reserved1[9]);

} arch_sSPI;

//* IIC Interface */

#define IIC_VERSION 6
#define IIC_VERSION_6

typedef volatile struct
{
	ARCH_REG2(UWord16, iica1, addr1);
	ARCH_REG3(UWord16, iicf,  ibfd,  fdiv);
	ARCH_REG3(UWord16, iicc1, ctrl1, cr1);
	ARCH_REG3(UWord16, iics,  stat,  ibsr);
	ARCH_REG3(UWord16, iicd,  data, ibdr);
	ARCH_REG3(UWord16, iicc2, ctrl2, cr2);
	ARCH_REG2(UWord16, iicfilt, iic_filt);
	ARCH_REG1(UWord16, iicra);
	ARCH_REG2(UWord16, iicsmb, iic_smbcsr);
	ARCH_REG2(UWord16, iica2, addr2);
	ARCH_REG1(UWord16, iicslth);
	ARCH_REG1(UWord16, iicsltl);
	ARCH_REG1(UWord16, reserved1[4]);
	
} arch_sIIC;


/* Watchdog Module */

#define COP_VERSION 5 // for 827
#define COP_VERSION_5

typedef volatile struct
{
    ARCH_REG3(UWord16, copctl,   ControlReg, ctrl);
    ARCH_REG3(UWord16, copto,    TimeoutReg, tout);
    ARCH_REG3(UWord16, copctr,   ServiceReg, cntr);
    ARCH_REG1(UWord16, intval);
    ARCH_REG1(UWord16, window);
    ARCH_REG1(UWord16, reserved1[11]);

} arch_sCOP;



/* PLL/OCCS Module */

#define OCCS_VERSION 7 // for MC56F827xx
#define OCCS_VERSION_7
#define OCCS_HAS_RXOSC 1

typedef volatile struct
{
    ARCH_REG3(UWord16, pllcr,   ctrl, ControlReg);  //0x00
    ARCH_REG3(UWord16, plldb,   divby, DivideReg);  //0x01
    ARCH_REG3(UWord16, pllsr,   stat, StatusReg);   //0x02
    ARCH_REG1(UWord16, testr);                      //0x03 
    ARCH_REG3(UWord16, osctl,   octrl,   osctl1);   //0x04 
    ARCH_REG1(UWord16, osctl2);                     //0x05 
    ARCH_REG1(UWord16, clkchkr);                    //0x06
    ARCH_REG1(UWord16, clkchkt);                    //0x07
    ARCH_REG1(UWord16, prot);                       //0x08
    ARCH_REG1(UWord16, reserved1[7]);

} arch_sPLL; 

/* General Purpose I/O */

#define GPIO_VERSION 4  // for 56f845xx, 56f844xx
#define GPIO_VERSION_4

typedef volatile struct
{
    ARCH_REG3(UWord16, pur,      pupen, PullUpReg);
    ARCH_REG3(UWord16, dr,       data, DataReg);
    ARCH_REG3(UWord16, ddr,      ddir, DataDirectionReg);
    ARCH_REG3(UWord16, per,      peren, PeripheralReg);
    ARCH_REG3(UWord16, iar,      iassrt, IntAssertReg);
    ARCH_REG3(UWord16, ienr,     ien, IntEnableReg);
    ARCH_REG3(UWord16, ipolr,    iepol, IntPolarityReg);
    ARCH_REG3(UWord16, ipr,      ipend, IntPendingReg);
    ARCH_REG3(UWord16, iesr,     iedge, IntEdgeSensReg);
    ARCH_REG3(UWord16, ppmode,   ppoutm, PushPullModeReg);
    ARCH_REG3(UWord16, rawdata,  rdata, RawInputReg);
    ARCH_REG2(UWord16, drive,    DriveStrengthReg);  /* VERSION_2,3-specific */
    ARCH_REG1(UWord16, pus);                         /*  VERSION_4-specific*/
    ARCH_REG3(UWord16, slew,     SlewRateControlReg, sre); /*  VERSION_3-specific*/
    ARCH_REG1(UWord16, reserved1[2]);

} arch_sPort;



/* Crossbar switch */

#define XBAR_VERSION 3  // for 56f827
#define XBAR_VERSION_3

typedef volatile struct 
{
    ARCH_REG3(UWord16, xb_xbc0, xbc0, xbara_sel0);
    ARCH_REG3(UWord16, xb_xbc1, xbc1, xbara_sel1);
    ARCH_REG3(UWord16, xb_xbc2, xbc2, xbara_sel2);
    ARCH_REG3(UWord16, xb_xbc3, xbc3, xbara_sel3);
    ARCH_REG3(UWord16, xb_xbc4, xbc4, xbara_sel4);
    ARCH_REG3(UWord16, xb_xbc5, xbc5, xbara_sel5);
    ARCH_REG3(UWord16, xb_xbc6, xbc6, xbara_sel6);
    ARCH_REG3(UWord16, xb_xbc7, xbc7, xbara_sel7);
    ARCH_REG3(UWord16, xb_xbc8, xbc8, xbara_sel8);
    ARCH_REG3(UWord16, xb_xbc9, xbc9, xbara_sel9);
    ARCH_REG3(UWord16, xb_xbc10, xbc10, xbara_sel10);
    ARCH_REG3(UWord16, xb_xbc11, xbc11, xbara_sel11);
    ARCH_REG3(UWord16, xb_xbc12, xbc12, xbara_sel12);
    ARCH_REG3(UWord16, xb_xbc13, xbc13, xbara_sel13);
    ARCH_REG3(UWord16, xb_xbc14, xbc14, xbara_sel14);
    ARCH_REG1(UWord16, xbara_sel15);
    ARCH_REG1(UWord16, xbara_sel16);
    ARCH_REG1(UWord16, xbara_sel17);
    ARCH_REG1(UWord16, xbara_sel18);
    ARCH_REG1(UWord16, xbara_sel19);
    ARCH_REG1(UWord16, xbara_sel20);
    ARCH_REG1(UWord16, xbara_ctrl0);
    ARCH_REG1(UWord16, xbara_ctrl1);
    UWord16 reserved45[0x9];
	
} arch_sXBARA;

typedef volatile struct 
{
    ARCH_REG1(UWord16, xbarb_sel0);
    ARCH_REG1(UWord16, xbarb_sel1);
    ARCH_REG1(UWord16, xbarb_sel2);
    ARCH_REG1(UWord16, xbarb_sel3);
    ARCH_REG1(UWord16, xbarb_sel4);
    ARCH_REG1(UWord16, xbarb_sel5);
    ARCH_REG1(UWord16, xbarb_sel6);
    ARCH_REG1(UWord16, xbarb_sel7);
    UWord16 reserved45[0x18];
} arch_sXBARB;

/* CRC generator */

#define CRC_VERSION 1
#define CRC_VERSION_1

typedef volatile struct {
    ARCH_REG2(UWord16, crc_crch, crch);
    ARCH_REG2(UWord16, crc_crcl, crcl);
    ARCH_REG2(UWord16, crc_transponse, transponse);
    ARCH_REG1(UWord16, reserved1[13]);
    
} arch_sCRC;


/* Periodic Interrupt Timer */

#define PIT_VERSION 2
#define PIT_VERSION_2

typedef volatile struct 
{
    ARCH_REG1(UWord16, ctrl);   
    ARCH_REG1(UWord16, mod);
    ARCH_REG1(UWord16, cntr);
    UWord16 reserved[0xD];

} arch_sPIT;

/* Crossbar AND/OR/INVERT (AOI) Module */

#define AOI_VERSION 1
#define AOI_VERSION_1
typedef volatile struct 
{
    ARCH_REG1(UWord16, bfcrt010);
    ARCH_REG1(UWord16, bfcrt230);
    ARCH_REG1(UWord16, bfcrt011);
    ARCH_REG1(UWord16, bfcrt231);
    ARCH_REG1(UWord16, bfcrt012);
    ARCH_REG1(UWord16, bfcrt232);
    ARCH_REG1(UWord16, bfcrt013);
    ARCH_REG1(UWord16, bfcrt233);
    UWord16 reserved[0x18];

} arch_sAOI;

/* Power Management Controller (PMC) */

#define PMC_VERSION 2
#define PMC_VERSION_2
typedef volatile struct 
{
    ARCH_REG1(UWord16, ctrl);
    ARCH_REG1(UWord16, sts);
    UWord16 reserved[0x0E];
} arch_sPMC;

/* Analog Comparator */

#define HSCMP_VERSION 3
#define HSCMP_VERSION_3

typedef volatile struct 
{
    ARCH_REG1(UWord16, cr0);
    ARCH_REG1(UWord16, cr1);
    ARCH_REG1(UWord16, fpr);
    ARCH_REG1(UWord16, scr);
    ARCH_REG1(UWord16, daccr);
    ARCH_REG1(UWord16, muxcr);
    ARCH_REG1(UWord16, reserved1[2]);

} arch_sHSCMP;

/* Digital to Analog Converter */

#define DAC_VERSION 2
#define DAC_VERSION_2

typedef volatile struct {
    ARCH_REG2(UWord16, ctrl, ctrl0);
    ARCH_REG1(UWord16, data);
    ARCH_REG1(UWord16, step);
    ARCH_REG1(UWord16, minval);
    ARCH_REG1(UWord16, maxval);
    ARCH_REG1(UWord16, status);
    ARCH_REG1(UWord16, ctrl1);
    ARCH_REG1(UWord16, reserved1[9]);

} arch_sDAC;

/* Direct memory access module  */

#define DMA_VERSION 1
#define DMA_VERSION_1

typedef volatile struct {
    ARCH_REG1(UWord32, sar);
    ARCH_REG1(UWord32, dar);
    ARCH_REG1(UWord32, dsr_bcr);
    ARCH_REG1(UWord32, dcr);
} arch_sDMAchannel;

typedef volatile struct {
    ARCH_REG1(UWord32, reqc);
    ARCH_REG1(UWord16, reserved1[126]);
    ARCH_REG1(arch_sDMAchannel, channel_0);
    ARCH_REG1(arch_sDMAchannel, channel_1);
    ARCH_REG1(arch_sDMAchannel, channel_2);
    ARCH_REG1(arch_sDMAchannel, channel_3);
    ARCH_REG1(UWord16, reserved2[5472]);
} arch_sDMA;

/* External Watchdog Monitor */

#define EWM_VERSION 1 
#define EWM_VERSION_1

typedef volatile struct
{
    ARCH_REG2(UWord16, ctrl         , ewm_ctrl             );
    ARCH_REG2(UWord16, serv         , ewm_serv             );
    ARCH_REG2(UWord16, cmpl         , ewm_cmpl             );
    ARCH_REG2(UWord16, cmph         , ewm_cmph             );
    ARCH_REG2(UWord16, clkctrl      , ewm_clkctrl          );
    ARCH_REG2(UWord16, clkprescaler , ewm_clkprescaler     );
    ARCH_REG1(UWord16, reserved1[10]);
} arch_sEWM;

/* msCAN */

#define MSCAN_VERSION 2
#define MSCAN_VERSION_2

typedef volatile struct {
    ARCH_REG1(UWord16, idr0);
    ARCH_REG1(UWord16, idr1);
    ARCH_REG1(UWord16, idr2);
    ARCH_REG1(UWord16, idr3);
    ARCH_REG1(UWord16, dsr0);
    ARCH_REG1(UWord16, dsr1);
    ARCH_REG1(UWord16, dsr2);
    ARCH_REG1(UWord16, dsr3);
    ARCH_REG1(UWord16, dsr4);
    ARCH_REG1(UWord16, dsr5);
    ARCH_REG1(UWord16, dsr6);
    ARCH_REG1(UWord16, dsr7);
    ARCH_REG1(UWord16, dlr);
    ARCH_REG1(UWord16, tbpr);
    ARCH_REG1(UWord16, tsrh);
    ARCH_REG1(UWord16, tsrl);
    
} arch_sMSCAN_MB;

typedef volatile struct {
     ARCH_REG2(UWord16, canctl0, ctrl0); 
     ARCH_REG2(UWord16, canctl1, ctrl1); 
     ARCH_REG2(UWord16, canbtr0, btr0); 
     ARCH_REG2(UWord16, canbtr1, btr1); 
     ARCH_REG2(UWord16, canrflg, rflg); 
     ARCH_REG2(UWord16, canrier, rier); 
     ARCH_REG2(UWord16, cantflg, tflg); 
     ARCH_REG2(UWord16, cantcr,  tier); 
     ARCH_REG2(UWord16, cantarq, tarq); 
     ARCH_REG2(UWord16, cantaak, taak); 
     ARCH_REG2(UWord16, cantbsel, bsel); 
     ARCH_REG2(UWord16, canidac, idac); 
     ARCH_REG1(UWord16, reserved1);
     ARCH_REG2(UWord16, canmisc, misc);
     ARCH_REG2(UWord16, canrxerr, rxerr); 
     ARCH_REG2(UWord16, cantxerr, txerr); 
     ARCH_REG2(UWord16, canidar0, idar0);
     ARCH_REG2(UWord16, canidar1, idar1);
     ARCH_REG2(UWord16, canidar2, idar2);
     ARCH_REG2(UWord16, canidar3, idar3);
     ARCH_REG2(UWord16, canidmr0, idmr0);
     ARCH_REG2(UWord16, canidmr1, idmr1);
     ARCH_REG2(UWord16, canidmr2, idmr2);
     ARCH_REG2(UWord16, canidmr3, idmr3);
     ARCH_REG2(UWord16, canidar4, idar4);
     ARCH_REG2(UWord16, canidar5, idar5);
     ARCH_REG2(UWord16, canidar6, idar6);
     ARCH_REG2(UWord16, canidar7, idar7);
     ARCH_REG2(UWord16, canidmr4, idmr4);
     ARCH_REG2(UWord16, canidmr5, idmr5);
     ARCH_REG2(UWord16, canidmr6, idmr6);
     ARCH_REG2(UWord16, canidmr7, idmr7);

     arch_sMSCAN_MB canrb;
     arch_sMSCAN_MB cantb;

     ARCH_REG1(UWord16, reserved2[192]);
         
} arch_sMSCAN;


#define FMC_VERSION 2 
#define FMC_VERSION_2

typedef volatile struct
{
    ARCH_REG2(UWord32, pfapr      ,       fmc_pfapr        );
    ARCH_REG2(UWord32, pfb0cr     ,       fmc_pfb0cr       );
    ARCH_REG1(UWord16, reserved1[124]);
    ARCH_REG2(UWord32, tagvdw0s0  ,       fmc_tagvdw0s0    );
    ARCH_REG2(UWord32, tagvdw0s1  ,       fmc_tagvdw0s1    );
    ARCH_REG2(UWord32, tagvdw0s2  ,       fmc_tagvdw0s2    );
    ARCH_REG2(UWord32, tagvdw0s3  ,       fmc_tagvdw0s3    );
    ARCH_REG2(UWord32, tagvdw1s0  ,       fmc_tagvdw1s0    );
    ARCH_REG2(UWord32, tagvdw1s1  ,       fmc_tagvdw1s1    );
    ARCH_REG2(UWord32, tagvdw1s2  ,       fmc_tagvdw1s2    );
    ARCH_REG2(UWord32, tagvdw1s3  ,       fmc_tagvdw1s3    );
    ARCH_REG2(UWord32, tagvdw2s0  ,       fmc_tagvdw2s0    );
    ARCH_REG2(UWord32, tagvdw2s1  ,       fmc_tagvdw2s1    );
    ARCH_REG2(UWord32, tagvdw2s2  ,       fmc_tagvdw2s2    );
    ARCH_REG2(UWord32, tagvdw2s3  ,       fmc_tagvdw2s3    );
    ARCH_REG2(UWord32, tagvdw3s0  ,       fmc_tagvdw3s0    );
    ARCH_REG2(UWord32, tagvdw3s1  ,       fmc_tagvdw3s1    );
    ARCH_REG2(UWord32, tagvdw3s2  ,       fmc_tagvdw3s2    );
    ARCH_REG2(UWord32, tagvdw3s3  ,       fmc_tagvdw3s3    );
    ARCH_REG1(UWord16, reserved2[96]);   
    ARCH_REG2(UWord32, dataw0s0   ,       fmc_dataw0s0     );
    ARCH_REG2(UWord32, dataw0s1   ,       fmc_dataw0s1     );
    ARCH_REG2(UWord32, dataw0s2   ,       fmc_dataw0s2     );
    ARCH_REG2(UWord32, dataw0s3   ,       fmc_dataw0s3     );
    ARCH_REG2(UWord32, dataw1s0   ,       fmc_dataw1s0     );
    ARCH_REG2(UWord32, dataw1s1   ,       fmc_dataw1s1     );
    ARCH_REG2(UWord32, dataw1s2   ,       fmc_dataw1s2     );
    ARCH_REG2(UWord32, dataw1s3   ,       fmc_dataw1s3     );
    ARCH_REG2(UWord32, dataw2s0   ,       fmc_dataw2s0     );
    ARCH_REG2(UWord32, dataw2s1   ,       fmc_dataw2s1     );
    ARCH_REG2(UWord32, dataw2s2   ,       fmc_dataw2s2     );
    ARCH_REG2(UWord32, dataw2s3   ,       fmc_dataw2s3     );
    ARCH_REG2(UWord32, dataw3s0   ,       fmc_dataw3s0     );
    ARCH_REG2(UWord32, dataw3s1   ,       fmc_dataw3s1     );
    ARCH_REG2(UWord32, dataw3s2   ,       fmc_dataw3s2     );
    ARCH_REG2(UWord32, dataw3s3   ,       fmc_dataw3s3     );
    ARCH_REG1(UWord16, reserved3[224]);
} arch_sFMC;


/* Miscellaneous Control Module */

#define MCM_VERSION 1 
#define MCM_VERSION_1

typedef volatile struct
{
  ARCH_REG1(UWord16, reserved1[8]);
  ARCH_REG2(UWord16, mcm_plasc, plasc );
  ARCH_REG1(UWord16, reserved2[1]);
  ARCH_REG2(UWord16, mcm_plamc, plamc);
  ARCH_REG1(UWord16, reserved3[1]);
  ARCH_REG2(UWord32, mcm_cpcr, cpcr);
  ARCH_REG1(UWord32, reserved4[1]);
  ARCH_REG2(UWord32, mcm_cfadr, cfadr);
  ARCH_REG1(UWord32, reserved5[1]);
  ARCH_REG2(UWord16, mcm_cfatr, cfatr);
  ARCH_REG2(UWord16, mcm_cfloc, cfloc);
  ARCH_REG2(UWord16, mcm_cfier, cfier);
  ARCH_REG2(UWord16, mcm_cfisr, cfisr);
  ARCH_REG2(UWord32, mcm_cfdtr, cfdtr);
  ARCH_REG1(UWord16, reserved6[5]);
  ARCH_REG2(UWord32, mcm_rpcr, rpcr );
  ARCH_REG1(UWord32, reserved7[1]);
  ARCH_REG2(UWord32, mcm_uflashbar, uflashbar);
  ARCH_REG1(UWord32, reserved8[1]);
  ARCH_REG2(UWord32, mcm_uprambar, uprambar);
  ARCH_REG1(UWord16, reserved9[5]);
  ARCH_REG2(UWord32, mcm_srposp, srposp);
  ARCH_REG1(UWord32, reserved10[1]);
  ARCH_REG2(UWord32, mcm_srpipc, srpipc);
  ARCH_REG1(UWord32, reserved11[1]);
  ARCH_REG2(UWord32, mcm_srpmpc, srpmpc);
} arch_sMCM;
/* Flash Status Register */

#define FTFL_VERSION 2 
#define FTFL_VERSION_2

typedef volatile struct
{
  ARCH_REG2(UWord8, ftfl_fstat , fstat );
  ARCH_REG2(UWord8, ftfl_fcnfg , fcnfg );
  ARCH_REG2(UWord8, ftfl_fsec  , fsec  );
  ARCH_REG2(UWord8, ftfl_fopt  , fopt  );
  ARCH_REG2(UWord8, ftfl_fccob3, fccob3);
  ARCH_REG2(UWord8, ftfl_fccob2, fccob2);
  ARCH_REG2(UWord8, ftfl_fccob1, fccob1);
  ARCH_REG2(UWord8, ftfl_fccob0, fccob0);
  ARCH_REG2(UWord8, ftfl_fccob7, fccob7);
  ARCH_REG2(UWord8, ftfl_fccob6, fccob6);
  ARCH_REG2(UWord8, ftfl_fccob5, fccob5);
  ARCH_REG2(UWord8, ftfl_fccob4, fccob4);
  ARCH_REG2(UWord8, ftfl_fccobb, fccobb);
  ARCH_REG2(UWord8, ftfl_fccoba, fccoba);
  ARCH_REG2(UWord8, ftfl_fccob9, fccob9);
  ARCH_REG2(UWord8, ftfl_fccob8, fccob8);
  ARCH_REG2(UWord8, ftfl_fprot3, fprot3);
  ARCH_REG2(UWord8, ftfl_fprot2, fprot2);
  ARCH_REG2(UWord8, ftfl_fprot1, fprot1);
  ARCH_REG2(UWord8, ftfl_fprot0, fprot0);
} arch_sFTFL;

#define  DMA_BASE     0xC800 
#define  FMC_BASE     0xDE00
#define  DACA_BASE    0xE000 
#define  DACB_BASE    0xE010 
#define  HSCMPA_BASE  0xE020  
#define  HSCMPB_BASE  0xE028  
#define  HSCMPC_BASE  0xE030  
#define  HSCMPD_BASE  0xE038  
#define  SCI0_BASE    0xE080 
#define  SCI1_BASE    0xE090        
#define  SPI0_BASE    0xE0B0 
#define  SPI1_BASE    0xE0C0         
#define  IIC_BASE     0xE0E0 
#define  PIT0_BASE    0xE100 
#define  PIT1_BASE    0xE110            
#define  TMRA_BASE    0xE140 
#define  CRC_BASE     0xE1C0         
#define  GPIO_A_BASE  0xE200 
#define  GPIO_B_BASE  0xE210 
#define  GPIO_C_BASE  0xE220 
#define  GPIO_D_BASE  0xE230 
#define  GPIO_E_BASE  0xE240 
#define  GPIO_F_BASE  0xE250        
#define  PMC_BASE     0xE2A0 
#define  OCCS_BASE    0xE2B0 
#define  INTC_BASE    0xE300 
#define  COP_BASE     0xE320 
#define  EWM_BASE     0xE330 
#define  XBARA_BASE   0xE340 
#define  XBARB_BASE   0xE360 
#define  AOI_BASE     0xE380    
//#define  FTFA_BASE    0xE3C0 
#define  SIM_BASE     0xE400 
#define  ADC_BASE     0xE500    
#define  EFPWMA_BASE  0xE600         
#define  CAN_BASE     0xE700 

#define  MCM_BASE     0x18000
#define  FTFL_BASE    0x1C780

typedef volatile struct
{
    UWord16             reserved0[0x800];     /* Reserved     0xC000 */
    arch_sDMA           Dma;                  /* DMA_BASE     0xC800 */
    arch_sFMC           Fmc;                  /* FMC_BASE     0xDE00 */
    arch_sDAC           DacA;                 /* DACA_BASE    0xE000 */
    arch_sDAC           DacB;                 /* DACB_BASE    0xE010 */
    arch_sHSCMP         HscmpA;               /* HSCMPA_BASE  0xE020 */
    arch_sHSCMP         HscmpB;               /* HSCMPB_BASE  0xE028 */
    arch_sHSCMP         HscmpC;               /* HSCMPC_BASE  0xE030 */
    arch_sHSCMP         HscmpD;               /* HSCMPD_BASE  0xE038 */
    UWord16             reserved07[0x40];     /* Reserved     0xE040 */
    arch_sSCI           Sci0;                 /* SCI0_BASE    0xE080 */
    arch_sSCI           Sci1;                 /* SCI1_BASE    0xE090 */
    UWord16             reserved10[0x10];     /* Reserved     0xE0A0 */
    arch_sSPI           Spi0;                 /* SPI0_BASE    0xE0B0 */
    arch_sSPI           Spi1;                 /* SPI1_BASE    0xE0C0 */
    UWord16             reserved13[0x10];     /* Reserved     0xE0D0 */
    arch_sIIC           Iic;                  /* I2C_BASE     0xE0E0 */
    UWord16             reserved15[0x10];     /* Reserved     0xE0F0 */
    arch_sPIT           Pit0;                 /* PIT0_BASE    0xE100 */
    arch_sPIT           Pit1;                 /* PIT1_BASE    0xE110 */
    UWord16             reserved18[0x20];     /* Reserved     0xE120 */
    arch_sTimer         TimerA;               /* TMRA_BASE    0xE140 */
    UWord16             reserved23[0x40];     /* Reserved     0xE180 */
    arch_sCRC           Crc;                  /* CRC_BASE     0xE1C0 */
    UWord16	            reserved25[0x30];     /* Reserved     0xE1D0 */
    arch_sPort          PortA;                /* GPIO_A_BASE   0xE200 */
    arch_sPort          PortB;                /* GPIO_B_BASE   0xE210 */
    arch_sPort          PortC;                /* GPIO_C_BASE   0xE220 */
    arch_sPort          PortD;                /* GPIO_D_BASE   0xE230 */
    arch_sPort          PortE;                /* GPIO_E_BASE   0xE240 */
    arch_sPort          PortF;                /* GPIO_F_BASE   0xE250 */
    UWord16             reserved32[0x40];     /* Reserved     0xE260 */
    arch_sPMC           Pmc;                  /* PMC_BASE     0xE2A0 */
    arch_sPLL           Pll;                  /* OCCS_BASE    0xE2B0 */
    UWord16             reserved35[0x40];     /* Reserved     0xE2C0 */
    arch_sIntc          Intc;                 /* INTC_BASE    0xE300 */
    arch_sCOP           Cop;                  /* COP_BASE     0xE320 */
    UWord16             reserved38[0x10];     /* EWM_BASE     0xE330 */
    arch_sXBARA         XbarA;                /* XBARA_BASE   0xE340 */
    arch_sXBARB         XbarB;                /* XBARB_BASE   0xE360 */
    arch_sAOI           Aoi;                  /* XBAR_AOI_BASE 0xE380 */
    UWord16             reserved42[0x20];     /* Reserved     0xE3A0 */
    UWord16             reserved43[0x40];     /* Reserved     0xE3C0 */
    arch_sSIM           Sim;                  /* SIM_BASE     0xE400 */
    arch_sADC           Adc;                  /* ADC1_BASE    0xE500 */
    UWord16             reserved46[0x80];     /* Reserved     0xE540 */	
    arch_sEFPWM         EfpwmA;               /* EFPWMA_BASE  0xE600 */
    arch_sMSCAN         MSCan;                /* CAN_BASE     0xE700 */
    UWord16             reserved49[0x800];    /* Reserved     0xE800 */
    UWord16             reserved50[0x1000];   /* Reserved     0xF000 */

} arch_sIO;

typedef volatile struct
{   arch_sMCM           Mcm;                    /* MCM_BASE     0x18000 */
    UWord16             reserved59[0x4746];     /* Reserved     0x18040 */  
    arch_sFTFL          Ftfl;                   /* FTFL_BASE    0x1C780 */ 
} arch_sIOFar;


/* The location of the following structure is defined in linker.cmd */
extern arch_sIO    ArchIO;

/* second arch IO sutructure to achieve access above address 0xffff */
extern arch_sIOFar   ArchIOFar;

/* you can try to use direct address access too */
//#define ArchIO (*(volatile arch_sIO*) 0xf000)

#endif

