/*******************************************************************************
*
* File Name: main.c
*
* Description: Main application file generated automatically from the 
*              DSP56800E_Quick_Start stationery
*
* Target: MC56F82748 device
*
*******************************************************************************/
/*******************************************************************************
*
* This application demonstrates the PWMs, Timer, ADC, XBAR and PDB on 56F847xx
* 
* 1. Peripherals are configured using QuickStart GCT r2.6
* 
* 2. Project is based on CodeWarrior 10.4
* 
* 3. The target HW is TWR-56F8200 
* 
* 4. The internal fault signal is generated from internal comparator HSCMP_A. 
*    The comparator compares reference signal set by 6-bit DAC to 0.567 V and 
*    12-bit DAC that generates triangle waveform. The periodic comparator output
*    pulse is connected to PWM fault input 1 via XBAR channel 30. The fault 
*    level is set to high polarity (FLVL1 = 1) and disables PWM_A1 and PWM_B1 
*    outputs setting them to logic 0. The fault clearing is set to the automatic 
*    mode with a half cycle recovery time.
*    
* 5. The external fault signal is generated by pressing the SW1 button. 
*    The fault signal is connected to PWM fault input 0 via XBAR channel 29. 
*    The fault level is set to low polarity (FLVL0 = 0) and disables PWM_A0 and 
*    PWM_B0 outputs setting them to logic 0. But PWM_A0 output is set to active 
*    low polarity which also inverts PWM_A0 output to logic 1 if the output is 
*    disabled by the fault. The fault flag generates the interrupt request. 
*    The code put to the interrupt service routine Extern_Fault_ISR() turns 
*    the LED8 on and waits until SW2 button is pressed. Then the fault flag is 
*    cleared, PWM_A0 and PWM_B0 outputs are enabled, and the LED8 is turned off.  
***************************************************************************//*!

/* required DSP56F800E_Quick_Start header */
#include "qs.h"

/* low-level driver headers for each module used */
#include "occs.h"
#include "sys.h"
#include "adc.h"
#include "cop.h"
#include "crc.h"
#include "dac.h"
#include "dma.h"
#include "ewm.h"
#include "fmc.h"
#include "ftfl.h"
#include "gpio.h"
#include "hscmp.h"
#include "iic.h"
#include "intc.h"
#include "mcm.h"
#include "mscan.h"
#include "pwm.h"
#include "pit.h"
#include "pmc.h"
#include "qtimer.h"
#include "sci.h"
#include "spi.h"
#include "aoi.h"
#include "xbar.h"
#include "freemaster.h"


void main (void) 
{
	/* initialise SYS module */
    ioctl(SYS, SYS_INIT, NULL);

    /* configure COP module */
    ioctl(COP, COP_INIT, NULL);
    
    /* configure all GPIO modules */
    ioctl(GPIO, GPIO_INIT_ALL, NULL);

    /* configure PWM module */
    ioctl(EFPWMA,EFPWM_INIT,NULL);
    
    /* configure XBAR module */
    ioctl(XBAR_A,XBAR_A_INIT,NULL);
    
    /* configure DAC */
    ioctl(DAC_A,DAC_INIT,NULL);
    
    /* configure HS CMP0 */
    ioctl(HSCMP_A,HSCMP_INIT,NULL);

    /* initialise interrupt controller and enable interrupts */
    ioctl(INTC, INTC_INIT, NULL);
    
    /* clear selected fault flags 0&1 after reset*/
    ioctl(EFPWMA,EFPWM_CLEAR_FAULT_FLAGS, EFPWM_FAULT_0 | EFPWM_FAULT_1 );
    
    /* enable interrupts  */
    archEnableInt();
    
    
    /* main loop */
    while(1)
    {
    	
    }	
}

/* fault interrupt service routine generated by FAULT0 */
#pragma interrupt saveall
void Extern_Fault_ISR(void)
{
  	/* clear PWM fault flags */
  	/* set TWR_56F8200 LED8 */
  	ioctl(GPIO_F,GPIO_SET_PIN,BIT_6);
  	
  	/*  wait until SW1 is pressed*/
  	while(ioctl(GPIO_F,GPIO_READ_DATA,NULL)&BIT_7);
  	
  	/* clear Fault flag 0 */
  	ioctl(EFPWMA,EFPWM_CLEAR_FAULT_FLAGS, EFPWM_FAULT_0 );
  	
  	/* clear TWR_56F8200 LED8 */
  	ioctl(GPIO_F,GPIO_CLEAR_PIN,BIT_6);
	
}
