/************************************************************************/
/*    Phase-shift PWM with external current limit control               */
/************************************************************************/
/* Desc: Configure eTimer0 channel 1 in gated clock
/*       channel 0 = primary clock
/*       channel 0 is the input for the Ilimit pulse
/************************************************************************/
/* Author: Yves Briant 
/* Date:   14/03/2010
/************************************************************************/
#include "MPC5643L.h"
#include "eTimer.h"

/****************************************************************************/
/* void ConfigureETimer0(void)			 								    */
/****************************************************************************/
/* Desc: configure eTimer channel1 for gated clock output mode				*/
/****************************************************************************/
void ConfigureETimer0(void) 
{
  ETIMER_0.CHANNEL[1].CTRL1.B.CNTMODE = 2; //Count rising and falling edges of primary source
  ETIMER_0.CHANNEL[1].CTRL1.B.PRISRC  = 0; //Primary source=channel0 input
  ETIMER_0.CHANNEL[1].CTRL1.B.ONCE    = 0; //Count repeatedly
  ETIMER_0.CHANNEL[1].CTRL1.B.LENGTH  = 0; //Continue to roll-over
  ETIMER_0.CHANNEL[1].CTRL1.B.DIR     = 0; //Count up
  ETIMER_0.CHANNEL[1].CTRL1.B.SECSRC  = 0; //Sec source = channel0 input - not used 
  
  ETIMER_0.CHANNEL[1].CTRL2.B.OEN     = 1; //Output OFLAG on channel1
  ETIMER_0.CHANNEL[1].CTRL2.B.OUTMODE = 15;//gated clock output while counter is active
  
  ETIMER_0.ENBL.R = 2;                     //Enable channel 1
   
}
