#include "jdp_extended.h"
#include "linflex_lin_master.h"
#include "linflex_lin_slave.h"
#include "intc.h"
#include "test_config.h"
#include "typedefs.h"
#include "jdp.h"
#include "LIN_tcd_001.h"

#define DRUN_MODE 3

void DISABLE_WATCHDOG(void);
void MC_MODE_INIT(void);
void SET_CLK(void);

/****************************************************************
* FUNCTION : DISABLE_WATCHDOG
* DESCRIPTION : It disables the software watchdog timer
* INPUTS : None
* OUTPUTS : None
****************************************************************/
void DISABLE_WATCHDOG(void)
{
  SWT.SR.R = 0x0000c520; /* key */
  SWT.SR.R = 0x0000d928; /* key */
  SWT.CR.R = 0x8000010A; /* disable WEN */
}

/****************************************************************
* FUNCTION : MC_MODE_INIT
* DESCRIPTION : It initializes the Magic Carpet module
* INPUTS : None
* OUTPUTS : None
****************************************************************/
void MC_MODE_INIT(void)
{
   /* Enable all peripheral clocks */
   CGM.SCDC.R = 0x80808080;
   /* Setting RUN Configuration Register ME_RUN_PC[0] */
   ME.RUNPC[0].R=0x000000FE; /* Peripheral ON in every mode */

   /* Re-enter in DRUN mode to update */
   ME.MCTL.R = (DRUN_MODE << 28 | 0x00005AF0);        /* Mode & Key */
   ME.MCTL.R = (DRUN_MODE << 28 | 0x0000A50F);        /* Mode & Key */
   /* Wait for mode entry to complete */
   while(ME.GS.B.S_MTRANS==1);
   /* Check DRUN mode has been entered */
   while(ME.GS.B.S_CURRENTMODE!=DRUN_MODE);
}

/****************************************************************
* FUNCTION : SET_CLK
* DESCRIPTION : Configures SYS CLK
* INPUTS : None
* OUTPUTS : None
****************************************************************/
void SET_CLK(void)
{
  ME.DRUN.B.SYSCLK=0x0;              /* system clock is IRC */

  /* RE enter the drun mode, to update the configuration */
  ME.MCTL.R = 0x30005AF0;            /* Mode & Key */
  ME.MCTL.R = 0x3000A50F;            /* Mode & Key inverted */
  while(ME.GS.B.S_MTRANS==1);        /* Wait for mode entry to complete */
  while(ME.GS.B.S_CURRENTMODE!=0x3); /* Check DRUN mode has been entered */
}

/* LINFlex0 interrupts */

#ifdef LINFLEX0_LIN_MASTER
void LINFLEX_0_RX_ISR(void)
{
	LINFLEX_LIN_Master_RX_ISR(0);
}
void LINFLEX_0_ERR_ISR(void)
{
	LINFLEX_LIN_Master_ERR_ISR(0);
}
void LINFLEX_0_TX_ISR(void)
{
	LINFLEX_LIN_Master_TX_ISR(0);
}
#else
#ifdef LINFLEX0_LIN_SLAVE
void LINFLEX_0_RX_ISR(void)
{
	LINFLEX_LIN_Slave_RX_ISR(0);
}
void LINFLEX_0_ERR_ISR(void)
{
	LINFLEX_LIN_Slave_ERR_ISR(0);
}
void LINFLEX_0_TX_ISR(void)
{
	LINFLEX_LIN_Slave_TX_ISR(0);
}
#else
#ifdef LINFLEX0_RS232
void LINFLEX_0_RX_ISR(void)
{
	LINFLEX_UART_RX_ISR(0);
}
void LINFLEX_0_ERR_ISR(void)
{
	LINFLEX_UART_ERR_ISR(0);
}
void LINFLEX_0_TX_ISR(void)
{
	LINFLEX_UART_TX_ISR(0);
}
#else
void LINFLEX_0_RX_ISR(void)
{
}
void LINFLEX_0_ERR_ISR(void)
{
}
void LINFLEX_0_TX_ISR(void)
{
}
#endif
#endif
#endif

/* LINFlex1 interrupts */

#ifdef LINFLEX1_LIN_MASTER
void LINFLEX_1_RX_ISR(void)
{
	LINFLEX_LIN_Master_RX_ISR(1);
}
void LINFLEX_1_ERR_ISR(void)
{
	LINFLEX_LIN_Master_ERR_ISR(1);
}
void LINFLEX_1_TX_ISR(void)
{
	LINFLEX_LIN_Master_TX_ISR(1);
}
#else
#ifdef LINFLEX1_LIN_SLAVE
void LINFLEX_1_RX_ISR(void)
{
	LINFLEX_LIN_Slave_RX_ISR(1);
}
void LINFLEX_1_ERR_ISR(void)
{
	LINFLEX_LIN_Slave_ERR_ISR(1);
}
void LINFLEX_1_TX_ISR(void)
{
	LINFLEX_LIN_Slave_TX_ISR(1);
}
#else
#ifdef LINFLEX1_RS232
void LINFLEX_1_RX_ISR(void)
{
	LINFLEX_UART_RX_ISR(1);
}
void LINFLEX_1_ERR_ISR(void)
{
	LINFLEX_UART_ERR_ISR(1);
}
void LINFLEX_1_TX_ISR(void)
{
	LINFLEX_UART_TX_ISR(1);
}
#else
void LINFLEX_1_RX_ISR(void)
{
}
void LINFLEX_1_ERR_ISR(void)
{
}
void LINFLEX_1_TX_ISR(void)
{
}
#endif
#endif
#endif

int main(void)
{
	DISABLE_WATCHDOG();
    MC_MODE_INIT();     // enable all peripherals in all modes and all peripheral clocks
    SET_CLK();

	initIrqVectors();		/* Initialize exceptions: only need to load IVPR */
	initINTC();			    /* Initialize INTC for software vector mode */

	INTC.PSR[79].R  = 0x02;  // LINFLEX_0_RX interrupt priority level
	INTC.PSR[80].R  = 0x02;  // LINFLEX_0_TX interrupt priority level
	INTC.PSR[81].R  = 0x02;  // LINFLEX_0_ERR interrupt priority level

	INTC.PSR[99].R  = 0x02;  // LINFLEX_1_RX interrupt priority level
	INTC.PSR[100].R = 0x02;  // LINFLEX_1_TX interrupt priority level
	INTC.PSR[101].R = 0x02;  // LINFLEX_1_ERR interrupt priority level

	enableIrq();             // Ensure INTC current prority=0 & enable IRQ

	SIU.PCR[0].R  = 0x0200; /* PA0 as output */  /* tied high in LINFLEX_0_RX interrupt routine */
	SIU.PCR[1].R  = 0x0200; /* PA1 as output */  /* tied high in LINFLEX_0_TX interrupt routine */
	SIU.PCR[3].R  = 0x0200; /* PA3 as output */  /* tied high in LINFLEX_0_ERR interrupt routine */
	SIU.PCR[4].R  = 0x0200; /* PA4 as output */
	SIU.PCR[6].R  = 0x0200; /* PA6 as output */  /* tied high in LINFLEX_1_RX interrupt routine */
    SIU.PCR[7].R  = 0x0200; /* PA7 as output */  /* tied high in LINFLEX_1_ERR interrupt routine */
	SIU.PCR[8].R  = 0x0200; /* PA8 as output */  /* tied high in LINFLEX_1_TX interrupt routine */
	SIU.PCR[9].R  = 0x0200; /* PA9 as output */  /* tied high in LINFLEX_2_RX interrupt routine */
	SIU.PCR[10].R = 0x0200; /* PA10 as output */ /* tied high in LINFLEX_2_ERR interrupt routine */
	SIU.PCR[11].R = 0x0200; /* PA11 as output */ /* tied high in LINFLEX_2_TX interrupt routine */
	SIU.PCR[12].R = 0x0200; /* PA12 as output */ /* tied high in LINFLEX_3_TX interrupt routine */

#ifdef LINFLEX0_LIN_MASTER
	LINFLEX_LIN_Master_Init(0,LIN_BAUDRATE);
#endif

#ifdef LINFLEX1_LIN_MASTER
	LINFLEX_LIN_Master_Init(1,LIN_BAUDRATE);
#endif

#ifdef LINFLEX0_LIN_SLAVE
 	LINFLEX_LIN_Slave_Init(0,LIN_BAUDRATE);
#endif

#ifdef LINFLEX1_LIN_SLAVE
 	LINFLEX_LIN_Slave_Init(1,LIN_BAUDRATE);
#endif

#ifdef LINFLEX0_RS232
	LINFLEX_UART_Init(0,UART_BAUDRATE);
#endif
#ifdef LINFLEX1_RS232
	LINFLEX_UART_Init(1,UART_BAUDRATE);
#endif

	LIN_tcd_001();

	while(1)
	{
	}
}
