#include "jdp_extended.h"

void LINFlex_ChangeBaudrate(vuint8_t LINFlex_Index, vuint8_t Frequency, vuint16_t Baudrate)
{
	switch(Frequency)
	{
		case 16:		// ipg_clock_lin=16MHz
			switch(Baudrate)
			{
				case 1:	// Baudrate = 1 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 0;
					LINFLEX(LINFlex_Index).LINIBRR.R = 1048575;
					break;

				case 300:	// Baudrate = 300 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 5;
					LINFLEX(LINFlex_Index).LINIBRR.R = 3333;
					break;

				case 600:	// Baudrate = 600 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 11;
					LINFLEX(LINFlex_Index).LINIBRR.R = 1666;
					break;

				case 1200:	// Baudrate = 1200 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 5;
					LINFLEX(LINFlex_Index).LINIBRR.R = 833;
					break;

				case 2400:	// Baudrate = 2400 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 11;
					LINFLEX(LINFlex_Index).LINIBRR.R = 416;
					break;

				case 4800:	// Baudrate = 4800 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 5;
					LINFLEX(LINFlex_Index).LINIBRR.R = 208;
					break;

				case 9600:	// Baudrate = 9600 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 3;
					LINFLEX(LINFlex_Index).LINIBRR.R = 104;
					break;

				case 19200:	// Baudrate = 19200 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 1;
					LINFLEX(LINFlex_Index).LINIBRR.R = 52;
					break;

				case 20000:	// Baudrate = 20000 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 0;
					LINFLEX(LINFlex_Index).LINIBRR.R = 50;
					break;

				case 1000000:	// Baudrate = 1 Mbps
					LINFLEX(LINFlex_Index).LINFBRR.R = 0;
					LINFLEX(LINFlex_Index).LINIBRR.R = 1;
					break;
			}
			break;
		case 32:		// ipg_clock_lin=32MHz
			switch(Baudrate)
			{
				case 2:	// Baudrate = 2 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 0;
					LINFLEX(LINFlex_Index).LINIBRR.R = 1048575;
					break;

				case 300:	// Baudrate = 300 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 11;
					LINFLEX(LINFlex_Index).LINIBRR.R = 6666;
					break;

				case 600:	// Baudrate = 600 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 5;
					LINFLEX(LINFlex_Index).LINIBRR.R = 3333;
					break;

				case 1200:	// Baudrate = 1200 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 11;
					LINFLEX(LINFlex_Index).LINIBRR.R = 1666;
					break;

				case 2400:	// Baudrate = 2400 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 5;
					LINFLEX(LINFlex_Index).LINIBRR.R = 833;
					break;

				case 4800:	// Baudrate = 4800 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 11;
					LINFLEX(LINFlex_Index).LINIBRR.R = 416;
					break;

				case 9600:	// Baudrate = 9600 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 5;
					LINFLEX(LINFlex_Index).LINIBRR.R = 208;
					break;

				case 19200:	// Baudrate = 19200 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 3;
					LINFLEX(LINFlex_Index).LINIBRR.R = 104;
					break;

				case 20000:	// Baudrate = 20000 bps
					LINFLEX(LINFlex_Index).LINFBRR.R = 0;
					LINFLEX(LINFlex_Index).LINIBRR.R = 100;
					break;

				case 1000000:	// Baudrate = 1 Mbps
					LINFLEX(LINFlex_Index).LINFBRR.R = 0;
					LINFLEX(LINFlex_Index).LINIBRR.R = 2;
					break;
			}
			break;
		default:
			break;
	}
}

void LINFlex_ConfigurePads(vuint8_t LINFlex_Index)
{
	switch (LINFlex_Index)
	{
		case 0:
			/* Configure Transmit pin */
			SIU.PCR[LINFLEX0_PCR_Index].B.PA = LINFLEX0_AF_Index; /* Select alternative mode */
			SIU.PCR[LINFLEX0_PCR_Index].B.OBE = 1; /* Output buffer enable */

			/* Configure Receice pin */
			SIU.PCR[LINFLEX0_PCR_Index+1].B.IBE = 1; /* Input buffer enable */
			SIU.PSMI[31].B.PADSEL = 0;		/* PSMI for D12 */
			break;

		case 1:
			/* Configure Transmit pin */
			SIU.PCR[LINFLEX1_PCR_Index_TX].B.PA = LINFLEX1_AF_Index; /* Select alternative mode */
			SIU.PCR[LINFLEX1_PCR_Index_TX].B.OBE = 1; /* Output buffer enable */

			/* Configure Receice pin */
			SIU.PCR[LINFLEX1_PCR_Index_RX].B.IBE = 1; /* Input buffer enable */
			SIU.PSMI[32].B.PADSEL = 1;		/* PSMI for D12 */
			break;

		default:
			break;
	}
}
