#include "jdp.h"

extern const vuint32_t IntcIsrVectorTable[];
extern vuint32_t ___IV_ADDR;     		// Defined in the linker file */

extern IVOR4Handler();

void initIrqVectors(void) {
	asm(" e_lis r3, __IV_ADDR@h");
	asm(" e_or2i r3, __IV_ADDR@l");
	asm(" mtIVPR r3");
}

void initINTC(void) {
  INTC.MCR.B.HVEN = 0;	   /* Initialize INTC for software vector mode */
  INTC.MCR.B.VTES = 0;     /* Use default vector table entry offsets of 4 B */
  INTC.IACKR.R = (uint32_t) &IntcIsrVectorTable[0]; /* Set INTC ISR vector table base addr. */
}

void enableIrq(void) {
  INTC.CPR.B.PRI = 0;	    /* Ensure INTC's current priority is 0 */
  asm(" wrteei 1");	    	/* Enable external interrupts */
}

void disableIrq(void) {
  asm(" wrteei 0");	    	/* Enable external interrupts */
}