#**************************************************************************/
#* FILE NAME: ctr0.s          		   COPYRIGHT (c) Freescale 2007   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* This is the crt0 file for an MPC5500/JDP device running from internal  */                                                                        
#* and with VLE enabled at startup.					  */
#* This initialises the SRAM and copies unitialised values from flash	  */
#* into RAM.															  */
#=========================================================================*/
#* This software is part of the "JPC563 MCM" Validation.		  */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1	  R. Moran		 27/Jun/07    Initial Version		  */
#**************************************************************************/


#------------------------------------------------------------- .rcw section --	
	.section .rcw
	.LONG 0x015A015A		# Watchdog disabled, VLE Enabled
	.LONG _start			# Code starts at _start
#-----------------------------------------------------------------------------		

	.file		"crt0.c"
	.section .vletext,va
	.vle
	.globl		_start
	.align		2
	e_add2i.		r0,0		# Debuggers may object to starting at 0.

	
_start:
	#e_ori		r26, r26, 0
	#e_lis		r11, __SP_INIT@h        # Initialize stack pointer r1 to
	#e_or2i		r11, __SP_INIT@l        # value in linker command file.
	e_lis           r11, __ghsend_stack@ha  # Initialize stack pointer r1 to
        e_or2i          r11, __ghsend_stack@l   # linker defined end of stack section. 
	mr			r1,r11			

	e_lis		r13, _SDA_BASE_@h       # Initialize r13 to sdata base
	e_or2i		r13, _SDA_BASE_@l       # (provided by linker).    

	e_lis		r2, _SDA2_BASE_@h       # Initialize r2 to sdata2 base
	e_or2i		r2, _SDA2_BASE_@l       # (provided by linker).
	
	e_addi		r0,r0,0			# Clear r0.
	e_stwu		r0,-64(r1)		# Terminate stack.


#//--------- Initialise SRAM --------------------------------------------
#// loop counter to get all of SRAM
        e_li            r5, 0x2000              # Number of 32 bit words 0x2000 = 8192 words = 32kbyte
        mtctr           r5                      # configure control register for use with bdnz
    
#// base address of the internal SRAM
        e_lis           r5, 0x4000
        e_or2i          r5, 0x0000

        e_li            r3, 0x0
sram_loop:
        e_stwu          r3, 0(r5)               # write all 32 registers to SRAM
        e_addi          r5,r5,4                 # increment the ram ptr
        e_bdnz          sram_loop               # loop for all of SRAM
#//--------- end init SRAM ----------------------------------------------
    
#//--------- Load un-initialised values into RAM ------------------------   

        e_lis           r9, __ROM_COPY_SIZE@ha  #// Load upper SRAM load size (# of bytes) into R9
        e_or2i          r9, __ROM_COPY_SIZE@l   #// Load lower SRAM load size into R9                                   
        e_cmp16i        r9,0                                            #// Compare to see if equal to 0                                  
        e_beq           ROMCPYEND               #// Exit cfg_ROMCPY if size is zero
                                                
        mtctr           r9                      #// Store # of bytes to be moved in spr CTR
                                        
        e_lis           r10, __ROM_COPY_START@ha#// Load address of first SRAM load into R10
        e_or2i          r10, __ROM_COPY_START@l #// Load lower address of SRAM load into R10
        e_subi          r10,r10, 1              #// Decrement address to prepare for ROMCPYLOOP
                                                                                        
# Load SRAM base address (__SRAM_CPY_START) for loading instructions into R5
        e_lis           r5, __RAM_COPY_START@h  # Load upper SRAM address into R5
        e_or2i          r5, __RAM_COPY_START@l  # Load lower SRAM address into R5
        e_subi          r5, r5, 1               # Decrement address to prepare for ROMCPYLOOP

ROMCPYLOOP:
        e_lbzu          r4, 1(r10)              # Load data byte at R10 into R4,incrementing (update) ROM address
        e_stbu          r4, 1(r5)               # Store R4 data byte into SRAM at R5 and update SRAM address 
        e_bdnz          ROMCPYLOOP              # Branch if more bytes to load from ROM
#
ROMCPYEND: 

#------------------------------------------------------------
# Start of code added to initialize the Motorola/ETAS MPC565 EVB.

	e_bl		main
