#include "typedefs.h"
#include "linflex_uart.h"
#include "jdp_extended.h"

void LIN_tcd_019()
{
	int index=0;
	uint8_t  msg_to_be_sent[4];

	LINFLEX_Init_Receive_Buffer (1, 4);

	LINFLEX(1).UARTCR.B.RXEN = 1;        // Enable Receiver
	LINFLEX(0).UARTCR.B.TXEN = 1;        // Enable Transmitter

	for (index = 0; index < 256; index++)
	{
		LINFLEX_UART_DataReceived = 0;

		msg_to_be_sent[0] = 0x00 + index;
		msg_to_be_sent[1] = 0x56;
		msg_to_be_sent[2] = 0x34;
		msg_to_be_sent[3] = 0x12;

		LINFLEX_TxUART(0, msg_to_be_sent, 4);

		while(LINFLEX_UART_DataReceived != 1);
	}
}
