#include "typedefs.h"
#include "linflex_lin_master.h"

void LIN_tcd_006()
{
	uint8_t MasterResponseToBeSent[8];

	// Fill Filter
	LINFLEX(1).LINCR1.B.INIT = 1;  /* enter initialization mode */

	LINFLEX(1).IFER.B.FACT = 0x1;  /* Enable Filter 0 */

	LINFLEX(1).IFMR.B.IFM0 = 0x0;  /* Filters in ID list mode */

	LINFLEX(1).IFCR0.B.DFL = 63;   /* 64 byte data */
	LINFLEX(1).IFCR0.B.DIR = 0x0;  /* Slave to receive data */
	LINFLEX(1).IFCR0.B.CCS = 0x0;  /* Enhanced Checksum */
	LINFLEX(1).IFCR0.B.ID  = 0x7;  /* Identifier */

	LINFLEX(1).LINCR1.B.INIT = 0;  /* enter normal mode */

	// Set response to be sent
	MasterResponseToBeSent[0]='a';
	MasterResponseToBeSent[1]='b';
	MasterResponseToBeSent[2]='c';
	MasterResponseToBeSent[3]='d';
	MasterResponseToBeSent[4]='e';
	MasterResponseToBeSent[5]='f';
	MasterResponseToBeSent[6]='g';
	MasterResponseToBeSent[7]='h';

	// Start transmission
	LINFLEX_LIN_Master_Send_Frame (0, 64, 0, 0x7, MasterResponseToBeSent);
}
