#**************************************************************************/
#* FILE NAME: mpc5500_xcptn.c              COPYRIGHT (c) Freescale 2007   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* This is the branch table for the IVOR4 vectors in HW vector mode.      */
#* The "IVORnTable" label is aligned with the IVPR. The specific IVOR4    */
#* vector handler must be offset from this by 0x800 + (Vector << 2 bits)  */
#* Syntax specifically written for GHS v5.0 compiler					  */
#* This file starts in memory at the beginning of the ".xcptn" section.	  */
#=========================================================================*/
#* This software is part of the "JPC563 MCM" Validation.				  */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1	  R. Moran		 27/Jun/07    Initial Version					  */
#**************************************************************************/
	.globl   IVORnTable

	.section .xcptn,va         # The "v" indicates VLE code
	.vle
	
    # Position of IVPR    
IVORnTable:
     
	.offset 0x0
	e_bl dummy
	
	.offset 0x10
	e_bl dummy
	
	.offset 0x20
	e_bl dummy
	
	.offset 0x30
	e_bl dummy
	
	.offset 0x40
	e_b IVOR4Handler
	
 dummy:
	 nop
	 e_b dummy
	 
