MEMORY
{
  	FLASH    : ORIGIN = 0x00000000,  LENGTH = 512k
#        SRAM     : ORIGIN = 0x40000000,  LENGTH = 40K
        SRAM     : ORIGIN = 0x40000000,  LENGTH = 36K
}

CONSTANTS 
{
    heap_reserve    = 1024
    stack_reserve   = 1024
    coderam_reserve = 2048
}

SECTIONS
{

	###############################################################
  	# FLASH Sections
  	###############################################################

	.rcw  	 : { *(.rcw) } 	> FLASH
	.start	 : { *(.start)} > .
    	.text    : {}		> .
    	.vletext : {}		> .
    
	# runtime lib code for GHS system call emulation (file-IO e.g.) 
	.syscall	: {}	> .
	
	# Read-Only Data incl. SDA2 (small data area2 for ro-data)
	.sdata2 ALIGN(4) : {}	> .
	.rodata		 : {}	> .	
 
   	# Sections to be copied from Flash -> RAM 
  	# Order MUST match the order of appropriate RAM Sections below
  	.ROM.data    ALIGN(4) ROM(.data)    	: {}	> . 
  	.ROM.sdabase ALIGN(4) ROM(.sdabase)     : {}	> .
	.ROM.sdata            ROM(.sdata)       : {}	> .	

	# special information used by the GHS runtime libs stored here
	.secinfo	: {}	> .
	.fixaddr	: {}	> .
	.fixtype	: {}	> .

	.isrvectbl ALIGN(0x800): {}
	.xcptn ALIGN(0x4000): {} 
	###############################################################
  	# SRAM Sections
  	###############################################################

  	# Initialized Data
  	.coderam  PAD(coderam_reserve) : {}  > SRAM
	.data     ALIGN(4)             : {}  > .	
 	.sdabase  ALIGN(4)             : {}  > .
  	.sdata                         : {}  > .
	
  	#Zero Initialized Data									     	
  	.sbss			: {}	> .
        .bss	                : {}	> .

  	#Heap
  	.heap    ALIGN(16) PAD(heap_reserve)    : {}	> .
  
  	#Stack
  	.stack   ALIGN(16) PAD(stack_reserve)	: {} 	> .

	###############################################################
  	# Linker defined symbols
  	###############################################################

	__ROM_COPY_START	= ADDR(.ROM.data);
	__ROM_COPY_END		= ENDADDR(.ROM.sdata);
	__ROM_COPY_SIZE		= __ROM_COPY_END - __ROM_COPY_START;
	__RAM_COPY_START	= ADDR(.data);
    __ghs_ramstart  		= MEMADDR(SRAM);
    __ghs_ramend    		= MEMENDADDR(SRAM);
    __ghs_romstart  		= MEMADDR(SRAM);
    __ghs_romend    		= MEMENDADDR(SRAM);

    __ghs_rambootcodestart 	= 0;           
    __ghs_rambootcodeend 	= 0;           
    __ghs_rombootcodestart 	= MEMADDR(SRAM);
    __ghs_rombootcodeend 	= MEMENDADDR(SRAM);

/* Interrupt Handler Parameters */
__IV_ADDR      = ADDR(.xcptn);

}
