/*************************************** 
*
* Freescale Semiconductor Inc. 
* (c) Copyright 2012 Freescale Semiconductor, Inc. 
* ALL RIGHTS RESERVED 
*
****************************************//*
*
* @file etimer_api.h 
* 
* @author B37643
* 
* @brief  Description about file
*/ 

#ifndef __ETIMER__API 
#define __ETIMER__API

#include "typedefs.h"
#include "MPC5744P.h"
#include "typedefs_UINT8.h"

//Pin configuration
#define	DIRECTION_IN	0
#define DIRECTION_OUT	1

#define SLEWRATE_0		0
#define SLEWRATE_1		1
#define SLEWRATE_2		2
#define SLEWRATE_3		3

//Mode entry - b37643
#define ME_KEY		0x5AF0
#define ME_IKEY		0xA50F

#define ME_TEST		0x1
#define ME_SAFE		0x2
#define	ME_DRUN		0x3
#define	ME_RUN0		0x4
#define	ME_RUN1		0x5
#define	ME_RUN2		0x6
#define	ME_RUN3		0x7
#define	ME_HALT0	0x8
#define ME_STOP0	0xA

#define SYS_RCO		0x0
#define SYS_OSC		0x1
#define SYS_PL0		0x2
#define SYS_PL1		0x4

#define DIV1		0x0
#define DIV2		0x1
#define DIV4		0x2
#define DIV8		0x3
#define DIV16		0x4
#define DIV32		0x5
#define DIV64		0x6
#define DIV128		0x7

#define MAX_COUNT	0xFFFF
#define MIN_FREQ	0xFDE8 //65000

//active level
#define HIGH		0
#define LOW			1

/*************************************
Declaration of APIs exposed
*************************************/
int ETIMER_INIT(void);
int ETIMER_RESET(int);

void Upgrate_PLL	(uint32_t *uk_mode,uint8_t which, uint8_t mode);
void Set_pll		(uint16_t PLL_value, uint8_t which_PLL, uint8_t mode);

volatile struct ETIMER_tag *eTimer;	//structure for Master

/*************************************
Structures and enums to be used by other users for using these APIs
*************************************/


#endif 

