// --------------------------------------------------------------------------
// COPYRIGHT (c) Freescale 2009
// Freescale Confidential Proprietary
// All Rights Reserved
// --------------------------------------------------------------------------
//!\file    init_functions.c
//!\brief   This file contains the initialization functions of the device
//
// TYPE: C Source file
// DEPARTMENT: MSG
// CREATED BY: Ankur Sharma  (B17102)
// --------------------------------------------------------------------------
// PURPOSE:  This file contains the initialization functions of the device
// --------------------------------------------------------------------------
// $Log: init_functions.c.rca $
// 
//  Revision: 1.5 Tue Jul 31 14:10:24 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.4 Tue Jul 31 11:35:51 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.3 Mon Jul 16 11:02:02 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.2 Wed May  9 07:42:17 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.1 Mon May  7 07:26:31 2012 B17104
//  *** empty comment string ***
// 
//  Revision: 1.17 Wed Mar  7 03:01:47 2012 MadhusudanAggarwalFSL
//  *** empty comment string ***
// 
//  Revision: 1.16 Tue Mar  6 22:54:26 2012 ArunMishraFSL
//  Clean File with correct sequence of System dividers as per RM.
// 
//  Revision: 1.14 Sun Mar  4 23:25:37 2012 MadhusudanAggarwalFSL
//  Updated with Sys clock at 200MHz.
// 
//  Revision: 1.13 Fri Mar  2 00:31:03 2012 MadhusudanAggarwalFSL
//  Updated with Core=200MHz, Peripheral=80MHz and pBridge=50MHz.
// 
//  Revision: 1.12 Tue Jan  3 05:17:52 2012 MadhusudanAggarwalFSL
//  *** empty comment string ***
// 
//  Revision: 1.11 Tue Dec 20 03:24:23 2011 MadhusudanAggarwalFSL
//  Updated as per Mckinley.
// 
//  Revision: 1.10 Mon Dec 19 23:09:02 2011 MadhusudanAggarwalFSL
//  *** empty comment string ***
// 
//  Revision: 1.9 Thu Jul 14 01:19:05 2011 PankajKushwahaFSL
//  Checked in as per latest CGM module
// 
//  Revision: 1.8 Wed Jul 13 22:46:17 2011 YaqubMohamedFSL
//  *** empty comment string ***
// 
//  Revision: 1.7 Wed Jul 13 22:25:59 2011 YaqubMohamedFSL
//  EXTAL clk as root clk settings enabled
// 
//  Revision: 1.6 Tue Jun 14 04:37:46 2011 YaqubMohamedFSL
//  EXTAL as root clock option added
// 
//  Revision: 1.5 Wed Jun  1 22:52:37 2011 AijazFatimaFSL
//  Modified wrt new header file
// 
//  Revision: 1.4 Fri Apr 29 00:35:47 2011 AijazFatimaFSL
//  Added Aux clock divider in MC_MODE_INIT
// 
//  Revision: 1.3 Wed Apr 27 02:06:45 2011 PankajKushwahaFSL
//  Added #ifdef THIRDEYE support
// 
//  Revision: 1.2 Wed Apr 27 00:50:27 2011 AijazFatimaFSL
//  *** empty comment string ***
// 
//  Revision: 1.1 Tue Apr 19 04:10:00 2011 AijazFatimaFSL
//  Initial version
// 
//  Revision: 1.5 Thu Jan  6 00:29:41 2011 B17104
//  Updated with SysCLk=200MHz.
// 
//  Revision: 1.4 Wed Jan  5 00:44:51 2011 B22414
//  *** empty comment string ***
// 
//  Revision: 1.3 Wed Dec 29 03:27:50 2010 B22414
//  *** empty comment string ***
// 
//  Revision: 1.2 Tue Dec 28 23:45:56 2010 B22414
//  *** empty comment string ***
// 
//  Revision: 1.1 Wed Dec 22 04:12:20 2010 B22414
//  Cobra90 initial validation code
// 
//  Revision: 1.7 Tue Aug 31 12:29:43 2010 AnkurSharmaFSL
//  *** empty comment string ***
// 
//  Revision: 1.4 Fri Aug 20 15:20:54 2010 AnkurSharmaFSL
//  *** empty comment string ***
// 
//  Revision: 1.3 Thu Aug 12 16:37:09 2010 AnkurSharmaFSL
//  *** empty comment string ***
// 
//  Revision: 1.2 Mon Jul 26 14:05:10 2010 AnkurSharmaFSL
//  *** empty comment string ***
// 
//  Revision: 1.1 Tue Mar 16 12:17:16 2010 AnkurSharmaFSL
//  Initial Versions for Bolero3M
// 
//  Revision: 1.2 Mon Feb  1 09:50:27 2010 AnkurSharmaFSL
//  *** empty comment string ***
// 
//  Revision: 1.6 Wed Apr  8 14:32:01 2009 MadhusudanAggarwalFSL
//  *** empty comment string ***
// 
//  Revision: 1.5 Mon Apr  6 11:08:38 2009 MadhusudanAggarwalFSL
//  *** empty comment string ***
// 
//  Revision: 1.4 Fri Apr  3 18:30:09 2009 NeerajManglaFSL
//  Changing the ME setting to enable the osc acc to cut2  Changed OSC enable in ME according to cut2
// 
//  Revision: 1.3 Mon Mar 30 14:06:54 2009 AijazFatimaFSL
//  Code modified to run with ThirdEye
// 
//  Revision: 1.2 Wed Mar 18 17:02:23 2009 MadhusudanAggarwalFSL
//  Generalised some clock functions.
//
//  Revision: 1.1 Thu Mar  5 18:02:41 2009 AnkurSharmaFSL
//  Initial Check In
// -------------------------------------------------------------------------


#include "common.h"
void PLL_sys(void);
void PLL_PD_Pulse(void);
void initialize_global_variable(void);
#define DRUN_MODE 3


/**
 *\brief Disables the software watchdog
 *
 *This function disables the software watchdog by giving the key
 */

void DISABLE_WATCHDOG()
{
  SWT_0.SR.R = 0x0000c520; /* key */
  SWT_0.SR.R = 0x0000d928; /* key */
  SWT_0.CR.R = 0x8000010A; /* disable WEN */
}

/**
 *\brief Enables the software watchdog
 *
 *This function enables the software watchdog by giving the key
 */

void ENABLE_WATCHDOG_DEBUG()
{
  SWT_0.SR.R = 0x0000c520; /* key */
  SWT_0.SR.R = 0x0000d928; /* key */
  SWT_0.CR.R = 0x80000109; /* disable WEN */
}


/****************************************************************
* FUNCTION : MC_MODE_INIT
* DESCRIPTION : It initializes the Magic Carpet module
* INPUTS : None
* OUTPUTS : None
****************************************************************/
void MC_MODE_INIT(void)
{
   volatile int x;

   MC_ME.ME.R = 0x000005FF; 
   /* Setting RUN Configuration Register ME_RUN_PC[0] */
   MC_ME.RUN_PC[0].R=0x000000FE; /* Peripheral ON in every mode */
   XOSC.CTL.B.OSCM  =1;
   XOSC.CTL.B.EOCV = 0x80;
   MC_ME.MCTL.R = 0x40005AF0;     	 /* Mode & Key */
   MC_ME.MCTL.R = 0x4000A50F;             /* Mode & Key inverted */

   MC_ME.RUN_MC[0].B.XOSCON=1; 	//Enable the EXTAL clk
   MC_ME.DRUN_MC.B.XOSCON=1; 	//Enable the EXTAL clk
   /* RE enter the drun mode, to update the configuration */
   MC_ME.MCTL.R = 0x30005AF0;     	         /* Mode & Key */
   MC_ME.MCTL.R = 0x3000A50F;                /* Mode & Key inverted */
   while(MC_ME.GS.B.S_MTRANS == 1);	/* Wait for mode entry to complete */
   while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);       /* Check DRUN mode has been entered */
   while(!MC_ME.GS.B.S_XOSC);		 	// Wait for clock to stabilise

   //AIPS_A.MPRA.R = 0x77777777;
   //AIPS_B.MPRA.R = 0x77777777;

   // Configure Sysclk0 for clkout
   SIUL2.MSCR[22].R=0x890001;

   MC_CGM.AC6_SC.R = 0x01000000;		// Select PLL PHI as output
   MC_CGM.AC6_DC0.R=0x80030000;		// Enable Divider & div by 10

   MC_CGM.AC0_SC.B.SELCTL=2;		// source AC0 is PLL0 PHI 
   MC_CGM.AC0_DC0.R = 0x80000000;	// Aux clock select 0 divider 0 --> div by 1 (MOTC_CLK)
   MC_CGM.AC0_DC1.R = 0x80070000;   	// Aux clock select 0 divider 1 --> div by 8 (SWG_CLK)
   MC_CGM.AC0_DC2.R = 0x80010000;   	// Aux clock select 0 divider 2 --> div by 2 (ADC_CLK)
 
   MC_CGM.AC1_DC0.R = 0x80010000;  	// Aux clock select 1 divider 0 --> div by 2 (FRAY_PLL_CLK)
   MC_CGM.AC1_DC1.R = 0x80030000;  	// Aux clock select 1 divider 1 --> div by 4 (SENT_CLK)

   MC_CGM.AC2_DC0.R = 0x80070000; 	// Aux clock select 2 divider 0 --> div by 8 (CAN_PLL_CLK)
   MC_CGM.PCS_SDUR.R = 0xFF;		// Configure Switch Duration

  MC_ME.DRUN_MC.B.SYSCLK = 1;            /* Select system clock as PLL PHI */
  MC_ME.MCTL.R = 0x30005AF0;     	 /* Mode & Key */
  MC_ME.MCTL.R = 0x3000A50F;             /* Mode & Key inverted */
  
  while(MC_ME.GS.B.S_MTRANS==1);	 /* Wait for mode entry to complete */
  while(MC_ME.GS.B.S_CURRENT_MODE!=0x3); /* Check DRUN mode has been entered */  
  while(MC_ME.GS.B.S_SYSCLK != 1);       /* fail is stuck here	 */
  
   sci_init(20);
   PLL_sys();
/*   PLL_sys();
 -    MC_CGM.AC6_DC0.R=0x80090000;		// Enable Divider & div by 10
 -    MC_CGM.AC6_SC.R = 0x02000000;		// Select PLL PHI as output 
 -  //  MC_CGM.AC0_DC0.B.DE=1;          // Enable Aux clk divider for PER_CLK*/
   
}

void PLL_sys()
{
  int freq, clk,i;
  
  MC_CGM.PCS_SDUR.R = 0xFF;	// Configure Switch Duration

  MC_ME.DRUN_MC.B.SYSCLK = 1;            /* Select system clock as PLL PHI */
  MC_ME.MCTL.R = 0x30005AF0;     	 /* Mode & Key */
  MC_ME.MCTL.R = 0x3000A50F;             /* Mode & Key inverted */
  
  while(MC_ME.GS.B.S_MTRANS==1);	 /* Wait for mode entry to complete */
  while(MC_ME.GS.B.S_CURRENT_MODE!=0x3); /* Check DRUN mode has been entered */  
  while(MC_ME.GS.B.S_SYSCLK != 1);       /* fail is stuck here	 */
  
  MC_CGM.AC3_SC.B.SELCTL = 1; 	// Select XOSC as PLL ref

   // Select the Sys Clk Divider values before configuring the PLL out
 // MC_CGM.SC_DC0.R = 0x80010000;	// Configure Sysclk divider0

  //Generating PLL PHI to output 400MHz
  PLLDIG.PLL0DV.B.RFDPHI = 4;	// PHI output: VCO divide by 2
  PLLDIG.PLL0DV.B.RFDPHI1 = 4;	// PHI1 output: VCO divide by 4 
  PLLDIG.PLL0DV.B.PREDIV = 2;	// Divide by 4
  PLLDIG.PLL0DV.B.MFD = 0x24;	// Multiply by 30

  // PLLpower cycle pulse and wait for PLL lock
  PLL_PD_Pulse();
  MC_CGM.AC6_DC0.R=0x800E0000;
  MC_CGM.AC6_SC.R = 0x02000000;
  MC_CGM.SC_DC0.R = 0x80030000;
  
  MC_ME.DRUN_MC.B.SYSCLK = 2;            /* Select system clock as PLL PHI */
  MC_ME.MCTL.R = 0x30005AF0;     	 /* Mode & Key */
  MC_ME.MCTL.R = 0x3000A50F;             /* Mode & Key inverted */
  
  while(MC_ME.GS.B.S_MTRANS==1);	 /* Wait for mode entry to complete */
  while(MC_ME.GS.B.S_CURRENT_MODE!=0x3); /* Check DRUN mode has been entered */  
  while(MC_ME.GS.B.S_SYSCLK != 2);       /* fail is stuck here	 */
  sci_init(45); //sys clock is pll0
 
  // Configure PER_CLK 
/*  MC_CGM.AC0_SC.B.SELCTL = 2;	 // Select PLL PHI
 -   MC_CGM.AC0_DC0.B.DE = 1;
 -   MC_CGM.AC0_DC0.B.DIV = 4;	// Divide by 5*/
}

void PLL_PD_Pulse(){
  MC_ME.DRUN_MC.B.PLL0ON=0; 	// Disable the PLL0
  /* RE  enter the drun mode, to update the configuration */
  MC_ME.MCTL.R = 0x30005AF0;     	 /* Mode & Key */
  MC_ME.MCTL.R = 0x3000A50F;                /* Mode & Key inverted */
  while(MC_ME.GS.B.S_MTRANS == 1);		         /* Wait for mode entry to complete */
  while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);       /* Check DRUN mode has been entered */

  MC_ME.DRUN_MC.B.PLL0ON=1; 	// Enable the PLL0
  /* RE  enter the drun mode, to update the configuration */
  MC_ME.MCTL.R = 0x30005AF0;     	         /* Mode & Key */
  MC_ME.MCTL.R = 0x3000A50F;                /* Mode & Key inverted */
  while(MC_ME.GS.B.S_MTRANS == 1);		         /* Wait for mode entry to complete */
  while(MC_ME.GS.B.S_CURRENT_MODE != 0x3);       /* Check DRUN mode has been entered */
  //waiting for PLL0 to lock
  while(PLLDIG.PLL0SR.B.LOCK ==0);
}


