#**************************************************************************/
#* FILE NAME: ctr0.s              		   COPYRIGHT (c) Freescale 2007   */
#*                                                All Rights Reserved     */
#* DESCRIPTION:                                                           */
#* This is the crt0 file for an MPC5500/JDP device running from internal  */                                                                        
#* and with VLE enabled at startup.									      */
#* This initialises the SRAM and copies unitialised values from flash	  */
#* into RAM.															  */
#=========================================================================*/
#* This software is part of the "JPC563 MCM" Validation.				  */
#*========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 0.1	  R. Moran		 27/Jun/07    Initial Version					  */
#**************************************************************************/


#------------------------------------------------------------- .rcw section --	
	.section .rcw
	.LONG 0x015A0000		# Watchdog disabled, VLE Enabled
	.LONG __start_master		# Code starts at _start
#-----------------------------------------------------------------------------		

	.file		"crt0.c"
	.section .vletext,va
	.vle
	.globl		__start_master
	.align 		2
	e_add2i.	r0,0
	
__start_master:
	#core register initialization (exception and cond register)
        e_li		r0,0
//        mtxer		r0
//        mtcr		r0

	# Initialize general purpose registers with 0's
		
        // r1 is stack frame pointer, always valid, init later
	// r2 is addt'l data area pointer (sdata2)
        e_li    	r3, 0
	// r4-r7 is initialized by the code below 
        e_li  		r8, 0
        e_li  		r9, 0
        e_li  		r10, 0
	// r11 is used for stack pointer setting, init later
        e_li  		r12, 0
	// r13 is small data area (sdata) pointer register, init later 
        e_li  		r14, 0
        e_li  		r15, 0
        e_li  		r16, 0
        e_li  		r17, 0
        e_li  		r18, 0
        e_li 		r19, 0
        e_li  		r20, 0
        e_li  		r21, 0
        e_li  		r22, 0
        e_li  		r23, 0
        e_li    	r24, 0
        e_li    	r25, 0
        e_li    	r26, 0
        e_li    	r27, 0
        e_li    	r28, 0
        e_li    	r29, 0
        e_li    	r30, 0
        e_li    	r31, 0


 ##------- Disable Watchdog  -----------------------------------------------

	e_lis     r6,0xFC05
	e_or2i    r6,0x0010
	e_li      r7,0xC520
	se_stw    r7,0x0(r6)
	e_li      r7,0xD928
	se_stw    r7,0x0(r6) # Disengage soft-lock

	e_lis     r6,0xFC05
	e_or2i    r6,0x0000
	e_lis     r7,0xff00
	e_or2i    r7,0x10A
	se_stw    r7,0x0(r6) # WEN = 0


	#e_ori		r26, r26, 0
	e_lis		r11, __SP_INIT@h    # Initialize stack pointer r1 to
	e_or2i		r11, __SP_INIT@l    # value in linker command file. 
	mr			r1,r11			

	e_lis		r13, _SDA_BASE_@h   # Initialize r13 to sdata base
	e_or2i		r13, _SDA_BASE_@l   # (provided by linker).    

	e_lis		r2, _SDA2_BASE_@h   # Initialize r2 to sdata2 base
	e_or2i		r2, _SDA2_BASE_@l   # (provided by linker).
	
	e_addi		r0,r0,0				# Clear r0.
	e_stwu		r0,-64(r1)			# Terminate stack.



//#*****************************
//# Enable SPE
//#*****************************
	mfmsr r6
	e_or2is  r6, 0x0200
	mtmsr r6


#************************
#enable ME bit in MSR
#***********************
mfmsr r6
e_or2i r6,0x1000
mtmsr r6


    e_bl MC_MODE_INIT
	e_bl main
	  
       

		
