#include "MPC5604B.h"

/* Global variables definition to display the signals on the scope of FreeMASTER tool */
volatile int	Light_Signal_OUT = 0;

void initModesAndClock(void) {
  ME.MER.R = 0x0000001D;          /* Enable DRUN, RUN0, SAFE, RESET modes */
                                  /* Initialize PLL before turning it on: */
/* Use 1 of the next 2 lines depending on crystal frequency: */
  CGM.FMPLL_CR.R = 0x02400100;    /* 8 MHz xtal: Set PLL0 to 64 MHz */   
/*CGM.FMPLL_CR.R = 0x12400100;*/  /* 40 MHz xtal: Set PLL0 to 64 MHz */   
  ME.RUN[0].R = 0x001F0074;       /* RUN0 cfg: 16MHzIRCON, OSC0ON,PLL0ON, syclk=PLL */
  ME.RUNPC[1].R = 0x00000010; 	  /* Peri. Cfg. 1 settings: only run in RUN0 mode */
  ME.PCTL[68].R = 0x01;           /* MPC56xxB/S SIUL:  select ME.RUNPC[1] */	
  
  ME.MCTL.R = 0x40005AF0;         		/* Enter RUN0 Mode & Key */
  ME.MCTL.R = 0x4000A50F;         		/* Enter RUN0 Mode & Inverted Key */  
  while (ME.GS.B.S_MTRANS) {}     		/* Wait for mode transition to complete */    
                                  	    /* Note: could wait here using timer and/or I_TC IRQ */
  while(ME.GS.B.S_CURRENTMODE != 4) {} 	/* Verify RUN0 is the current mode */
}

void initPeriClkGen(void) {
}

void disableWatchdog(void) {
  SWT.SR.R = 0x0000c520;     /* Write keys to clear soft lock bit */
  SWT.SR.R = 0x0000d928; 
  SWT.CR.R = 0x8000010A;     /* Clear watchdog enable (WEN) */
}  

int main(void) {
  const int LIGHT_ON  = 64;	
  const int LIGHT_OFF = 0;
  const int TimeDelay = 9500000;
  volatile int i = 0;

  initModesAndClock(); 		// Initialize mode entries and system clock
  initPeriClkGen();  		// Initialize peripheral clock generation for peripherals
  disableWatchdog();		/* Disable watchdog */
  	
  SIU.PCR[64].R = 0x0100; 	// configure PE0 pin (SW1) as GPIO input
  							// external pull up is used on TKR board  							
  SIU.PCR[68].R = 0x0200; 	// configure PE4 pin (LED1) as GPIO output

  /* Loop forever */
  for (;;) {
	  
	Light_Signal_OUT = LIGHT_ON;

	for(i=0;i<TimeDelay;i++){};			// generate a time delay
    
    if(SIU.GPDI[64].R) {				// if PE0 pin is high toggle PE0 pin
    	SIU.GPDO[68].R ^= 0x1;			// it works as following:
    									// if SW1 not pressed LED1 is blinking
    									// if SW1 pressed LED1 is ON or OFF
    }

   	Light_Signal_OUT = LIGHT_OFF;
   	
   	for(i=0;i<TimeDelay;i++){};			// generate a time delay
  }
}
