/*
 * FTMRZ.c
 *
 *  Created on: Mar 15, 2013
 *      Author: B34981
 */


/**********************************************************************************************
* Includes
**********************************************************************************************/
#include "FTMRZ.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/
extern ProgramStruct PS;					/* Data structure used by the programming routine */
extern pt2Func FTMRZ_Prog_Phrase_RAM;

/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

void FTMRZ_Init()
{
	if(!FCLKDIV_FDIVLD)				/* 	Condition which checks if the register has or has not been written since last reset*/
	{
		while(!FSTAT_CCIF)			/* 	Waits until the last command issued to the memory controller has been finished*/
		{
		}
		FCLKDIV = 0x1F;				/* 	Set the clock scaler so that memory frequency is 1MHz. Check table on RM */
	}
}


#pragma CODE_SEG SHADOW_ROM			/* The following functions must be placed on the SHADOW section to be moved to RAM */

/***********************************************************************************************
*
* @brief    FTMRZ_Erase_Flash - Erase flash registers except the Bootloader region
* @param    defines in Main.h
* @return   none
*
************************************************************************************************/  
void FTMRZ_Erase_Flash()
{
	
UINT32 u32add = FLASH_START_ADD;
UINT16 u16eraseCntr = 0;
UINT8 u8StartupAddress[3];

	for(u16eraseCntr = 0; u16eraseCntr < FLASH_SECTORS_TO_ERASE; u16eraseCntr++)
	{
		FCCOBIX = 0x01;							/*Reflects parameters needed by the command. Varies from command to command. If not set correctly ACCERR flag will be set, preventing the command from being executed*/
		FCCOB0HI = 0x0A;						/*Erase sector command*/
		FCCOB0LO = (UINT8)(u32add >> 16);		/*Global address to identify P-Flash block*/
		FCCOB1HI = (UINT8)(u32add >> 8);		/*Global address anywhere inside the sector to be erased. It must match with the beginning of a phrase*/
		FCCOB1LO = (UINT8)(u32add);
		FSTAT = 0xB0;							/* Writing 1 in the ACCERR and FPVIOL bits clears them. They must be cleared before issuing any commands.
												   CCIF must be cleared in order to launch the command */
		while(!FSTAT_CCIF)						/* Waits until the last command issued to the memory controller has been finished*/
		{		
		}
		u32add += FLASH_SECTOR_SIZE;			/* Set the address of the next sector */
	}
		
	u8StartupAddress[0] = (*(UINT8 *)(0xFFFFFD)); 	/* Save the startup address to restore after erasing */
	u8StartupAddress[1] = (*(UINT8 *)(0xFFFFFE));
	u8StartupAddress[2] = (*(UINT8 *)(0xFFFFFF));			
			
	PS.Data[0] = (*(UINT8 *)(0xFFFE08));			/* Store the protection bytes before erasing the last sector */
	PS.Data[1] = (*(UINT8 *)(0xFFFE09));
	PS.Data[2] = (*(UINT8 *)(0xFFFE0A));
	PS.Data[3] = (*(UINT8 *)(0xFFFE0B));
	PS.Data[4] = (*(UINT8 *)(0xFFFE0C));
	PS.Data[5] = (*(UINT8 *)(0xFFFE0D));
	PS.Data[6] = (*(UINT8 *)(0xFFFE0E));		  
	PS.Data[7] = (*(UINT8 *)(0xFFFE0F));		  
		
	/* Erase the last flash sector, holding the protection bit, the interrupt vectors and the startup vector */
	u32add = FLASH_VECTOR_SECTOR_ADD;
	FCCOBIX = 0x01;							/*Reflects parameters needed by the command. Varies from command to command. If not set correctly ACCERR flag will be set, preventing the command from being executed*/
	FCCOB0HI = 0x0A;						/*Erase sector command*/
	FCCOB0LO = (UINT8)(u32add >> 16);		/*Global address to identify P-Flash block*/
	FCCOB1HI = (UINT8)(u32add >> 8);		/*Global address anywhere inside the sector to be erased. It must match with the beginning of a phrase*/
	FCCOB1LO = (UINT8)(u32add);
	FSTAT = 0xB0;							/* Writing 1 in the ACCERR and FPVIOL bits clears them. They must be cleared before issuing any commands.
											   CCIF must be cleared in order to launch the command */
	while(!FSTAT_CCIF)						/* Waits until the last command issued to the memory controller has been finished*/
	{		
	}					
	
	PS.Add.DWord = 0xFFFE08;				/* 0xFFFE0F is the flash security byte, 0xFFFE08 is the boundary address */
	FTMRZ_Prog_Phrase_RAM();				/* Program the PS (the protection bit) */	
	
	PS.Add.DWord = 0xFFFFF8;				/* 0xFFFFFC is the startup vector, 0xFFFFF8 is the boundary address */
	PS.Data[7] = u8StartupAddress[2];		/* Store the previous startup vector on the programming structure */
	PS.Data[6] = u8StartupAddress[1];		
	PS.Data[5] = u8StartupAddress[0];		
	PS.Data[4] = 0x00;		  				
	FTMRZ_Prog_Phrase_RAM();				/* Program the startup vector */
}


/***********************************************************************************************
*
* @brief    FTMRZ_Prog_Phrase - Program 8 bytes stored on the PS Program Structure
* @param    defines in Main.h
* @return   none
*
************************************************************************************************/  
void FTMRZ_Prog_Phrase()
{
	UINT16 u16i = 0;
	
	FCCOBIX = 0x05;							/* Reflects parameters needed by the command. Varies from command to command. If not set correctly ACCERR flag will be set, preventing the command from being executed*/
	FCCOB0HI = 0x06;						/* Program command */
	FCCOB0LO = PS.Add.Byte[1];				/* In PS, the address is stored as a four byte address, so skip index 0 */				
	FCCOB1HI = PS.Add.Byte[2];				
	FCCOB1LO = PS.Add.Byte[3];
	FCCOB2HI = PS.Data[0];					
	FCCOB2LO = PS.Data[1];
	FCCOB3HI = PS.Data[2];
	FCCOB3LO = PS.Data[3];
	FCCOB4HI = PS.Data[4];
	FCCOB4LO = PS.Data[5];
	FCCOB5HI = PS.Data[6];
	FCCOB5LO = PS.Data[7];
	FSTAT = 0xB0;							/* Writing 1 in the ACCERR and FPVIOL bits clears them. They must be cleared before issuing any commands.
												   CCIF must be cleared in order to launch the command */
	while(!FSTAT_CCIF)						/* Waits until the last command issued to the memory controller has been finished*/
	{		
	}
	
	for(u16i = 0; u16i < 8; u16i++)			/* Clear the program structure to default values */
	{
		PS.Data[u16i] = 0xFF;
	}
}

#pragma CODE_SEG DEFAULT




