/******************************************************************************
  Copyright 2009  Freescale Semiconductor. All rights reserved.

  Module:           init.c 
  Description:      ME & CGM configuration
  Version:          0.1
  Revision:         0.1
  Date(yyyy.mm.dd): 08 April 2010
  Author(s):        b04629
  Company:          Freescale Semiconductor
                    East Kilbride                                                   
                    Scotland                                                    
 ****************************** Revision History ******************************
    Date(yyyy.mm.dd):   Name              Description 
  
 ******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS 
 WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE 
 TIME. AS A RESULT, FRESCALE SEMICONDUCTOR SHALL NOT BE HELD LIABLE FOR ANY 
 DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
 FROM THE CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE 
 CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 *****************************************************************************/
#include "lcd.h"


void DISABLE_SWT()
{
  SWT.SR.R = 0x0000c520; /* key */
  SWT.SR.R = 0x0000d928; /* key */
  SWT.CR.R = 0x8000010A; /* disable WEN */
}                                                                                                                                                                                                                                                                   

void PLL_64MHZ()
{
  /* Configure CLKOUT on PA0 */
  SIU.PCR[0].R         = 0x0A00;  /* PA0 clkout               */
  CGM.OC_EN.R          = 1;       /* Enable Output Clock      */
  CGM.OCDS_SC.B.SELDIV = 2;       /* Divide Output Clock by 4 */
  CGM.OCDS_SC.B.SELCTL = 2;       /* PLL is Output Clock      */
  
  ME.RUN[0].B.FXOSCON = 1;       /* Enable external osc */ 
  ME.RUN[0].B.FMPLLON  = 1;       /* Enable PLL */
  ME.RUN[0].B.SYSCLK   = 0x4;     /* System clock is PLL */
  
  CGM.FMPLL_CR.B.IDF  = 0x1;  /* Input Divider  = 2  -> 4 MHz   */
  CGM.FMPLL_CR.B.NDIV = 64;   /* Loop Divider   = 64 -> 256 MHz */
  CGM.FMPLL_CR.B.ODF  = 0x1;  /* Output Divider = 4  -> 64 MHz  */
  
  ME.MCTL.R = 0x40005AF0;         /* Mode & Key */
  ME.MCTL.R = 0x4000A50F;         /* Mode & Key inverted */
  while(ME.GS.B.S_MTRANS==1) {};  /* Wait for mode entry to complete */
}

void ME_CGM_init(void)
{
   /* ME_PCTL[all periph] default points to ME_RUN_PC[0] */
   ME.RUNPC[0].R=0x000000FE; /* Peripheral ON in every mode */
   /* Peripheral Clocks */
   CGM.SC_DC[2].B.DIV = emios_peripheral_prescaler-1;
   CGM.SC_DC[1].B.DIV = 0x0;
   CGM.SC_DC[0].B.DIV = 0x0;
   PLL_64MHZ();
}




void sys_init(void)
{
	
  /* Disable Watchdog */
  DISABLE_SWT(); 
  /* Configure mode and clocks */            
  ME_CGM_init(); 
  
  /* configure PLL for 64MHZ based on 8MHZ OSC  */ 
  PLL_64MHZ();
  

}