#include "MPC5674F_MVx264.h"
#include "main.h"
#include "fs_gpio.h"       /* SIU pin configuration */
#include "etpu_util.h"     /* General C Functions for the eTPU */
#include "etpu_gct.h"      /* eTPU configuration */
#include "etpu_pwm.h"      /* eTPU PWMM API */

/******************************************************************************
* Local function prototypes
******************************************************************************/
void GPIO_Init(void);
void FMPLL_Init(void);

void main(void) {
 volatile int i = 0;
 volatile int err_code = 0;	
 
 GPIO_Init();
 FMPLL_Init();
   
 /* Initialize eTPU */
 err_code = my_system_etpu_init();
 
 if (err_code == 0) 

  	/* Start eTPU */
  	my_system_etpu_start();

  /* Loop forever */
  for (;;) {
    i++;
  }
}

/***************************************************************************//*!
*
* @brief   Init device I/O pin.
*
* @return  N/A
*
******************************************************************************/
void GPIO_Init(void){
  const uint16_t gpio_output_pad_config =
    FS_GPIO_IO_FUNCTION +
    FS_GPIO_MAXIMUM_SLEW_RATE + 
    FS_GPIO_OUTPUT_DRAIN_DISABLE +
    FS_GPIO_READBACK_ENABLE +
    FS_GPIO_OUTPUT_BUFFER_ENABLE;
  const uint16_t etpu_output_pad_config =
    FS_GPIO_PRIMARY_FUNCTION +
    FS_GPIO_MAXIMUM_SLEW_RATE + 
    FS_GPIO_OUTPUT_DRAIN_DISABLE +
    FS_GPIO_READBACK_ENABLE +
    FS_GPIO_OUTPUT_BUFFER_ENABLE;
  const uint16_t etpu_input_pad_config =
    FS_GPIO_PRIMARY_FUNCTION +
    FS_GPIO_INPUT_BUFFER_ENABLE;
  
  /* initialize eTPU outputs */
  fs_gpio_config(FS_GPIO_ETPUA0, etpu_output_pad_config);
}

/***************************************************************************//*!
*
* @brief   Init FMPLL - 100MHz System Clock.
*
* @return  N/A
*
******************************************************************************/
void FMPLL_Init(void)
{
  volatile uint32_t timeout = 0;
      
  /* system clock divider is bypassed */
  SIU.SYSDIV.B.BYPASS = 1;          

  /* set the default Output Divide Ratios (RDF) to highest value */ 
  FMPLL.ESYNCR2.B.ERFD = 63;

  /* set the enhanced Pre-Divider to 10 */
  FMPLL.ESYNCR1.B.EPREDIV = 9;

  /* set the Feedback Divide Ratios (EMFD) to 84 */
  FMPLL.ESYNCR1.B.EMFD = 84;

  /* Clock Mode Selection - Normal mode with crystal reference */
  FMPLL.ESYNCR1.B.CLKCFG = 7;

  /* Wait for PLL to LOCK  */
  while ((FMPLL.SYNSR.B.LOCK==0) && (timeout < 10000))
  {
    timeout++;      /* Just do a simple software based loop counter */
  } 

  if (timeout < 10000 )
  {
    /* PLL locked - update the EFRD field with computed value */
    FMPLL.ESYNCR2.B.ERFD = 1;
  }
}



