/*****************************************************************************/
/*                                                                           */
/*   FILE NAME     :  irq_init_core0.c                                       */
/*   DESCRIPTION   :  Example source for initializing the core 0 interrupts  */
/*                                                                           */
/*****************************************************************************/

#include "../headers/project.h"
extern const uint32_t IntcIsrVectorTable[];

/*****************************************************************************/
/*   Function:     Irq_Init_Core0                                            */
/*   Description:  This function intializes the core 0 params of the INTC    */
/*                 and enables the external interrupts for that core         */
/*****************************************************************************/
void Irq_Init_Core0(void) {
    volatile int temp;

    /* Read IACKR before enabling interrupts */
    temp = INTC_0.IACKR0.R;
    
    /* Set INTC ISR vector table base address. Both cores share the same
       vector table. */
    INTC_0.IACKR0.R = (uint32_t) &IntcIsrVectorTable[0];

    /* Ensure INTC's current priority is 0 */
    INTC_0.CPR0.B.PRI = 0;
    
    /* Enable external interrupts */
    asm(" wrteei 1");       
}
