#/****************************************************************************/
#/*                                                                          */
#/* FILE NAME     :  vectors_core1.s                                         */
#/* DESCRIPTION   :  Sets the IVPR and IVOR registers                        */
#/*                  registers for the e200z4                                */
#/*                  This code is relocated by SW to core 1 IMEM before      */
#/*                  execution.                                              */
#/* DATE          :  July 31, 2013                                           */
#/*                                                                          */
#/****************************************************************************/

#/* labels used by copy to IMEM routine */
    .extern      IVOR4_Handler_core1
    .section    .xptn_vectors_core1, "axv"
    .vle


IVORnTable_core1:
#/**************************************************/
#/*    IVOR 0 Vector                               */
IVOR0_core1:
    nop
    e_b IVOR0_core1

#/**************************************************/
#/*    IVOR 1 Vector                               */
.offset 0x10
IVOR1_core1:
    nop
    e_b IVOR1_core1
    
#/**************************************************/
#/*    IVOR 2 Vector                               */
.offset 0x20
IVOR2_core1:
    nop
    e_b IVOR2_core1

#/**************************************************/
#/*    IVOR 3 Vector                               */
.offset 0x30
IVOR3_core1:
    nop
    e_b IVOR3_core1
    
#/**************************************************/
#/*    IVOR 4 Vector                               */
.offset 0x40
IVOR4_core1:
    nop
    e_b IVOR4_Handler_core1     

#/**************************************************/
#/*    IVOR 5 Vector                               */
.offset 0x50
IVOR5_core1:
    nop
    e_b IVOR5_core1
    
#/**************************************************/
#/*    IVOR 6 Vector                               */
.offset 0x60
IVOR6_core1:
    nop
    e_b IVOR6_core1

#/**************************************************/
#/*    IVOR 7 Vector                               */
.offset 0x70
IVOR7_core1:
    nop
    e_b IVOR7_core1

#/**************************************************/
#/*    IVOR 8 Vector                               */
.offset 0x80
IVOR8_core1:
    nop
    e_b IVOR8_core1

#/**************************************************/
#/*    IVOR 9 Vector                               */
.offset 0x90
IVOR9_core1:
    nop
    e_b IVOR9_core1

#/**************************************************/
#/*    IVOR 10 Vector                              */
.offset 0xA0
IVOR10_core1:
    nop
    e_b IVOR10_core1    

#/**************************************************/
#/*    IVOR 11 Vector                              */
.offset 0xB0
IVOR11_core1:
    nop
    e_b IVOR11_core1    

#/**************************************************/
#/*    IVOR 12 Vector                              */
.offset 0xC0
IVOR12_core1:
    nop
    e_b IVOR12_core1

#/**************************************************/
#/*    IVOR 13 Vector                              */
.offset 0xD0
IVOR13_core1:
    nop
    e_b IVOR13_core1

#/**************************************************/
#/*    IVOR 14 Vector                              */
.offset 0xE0
IVOR14_core1:
    nop
    e_b IVOR14_core1                                                  

#/**************************************************/
#/*    IVOR 15 Vector                              */
.offset 0xF0
IVOR15_core1:                             
    nop                           
    e_b IVOR15_core1                                                              
