/*
 * File:		fredom_test.c
 * Purpose:		Main process
 *
 */

#include "common.h"
#include "freedom_gpio.h"
#include "pit.h"
#include "hal_i2c.h"
#include "hal_dev_mma8451.h"
#include "angle_cal.h"
#include "task_mgr.h"
#include "global.h"
#include "TSIDrv.h"
#include "global.h"
#include "mcg.h"
#include "flag.h"


uint8 str1[] = "hola";
/*
*/


#define TPM_Cn_MODE  (TPM_CnSC_MSB_MASK | TPM_CnSC_ELSA_MASK)
#define TPM_MODULE    1000
#define TPM_INIT_VAL    25
#define SET_LED_GREEN(x)   TPM0_C2V = (x)
#define SET_LED_RED(x)     TPM0_C3V = (x)
#define SET_LED_BLUE(x)    TPM0_C1V = (x)


void accel_demo(void);
void accel_read(void);
void TPM_init(void);


/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
signed short accel_x, accel_y, accel_z;
signed short resultx, resulty, resultz;





#define RED_MASK   0x01
#define GREEN_MASK 0x02
#define BLUE_MASK  0x04

  

void accel_init(void)
{
    unsigned char tmp;
    printf("****Accelerometor init ****\n");
   //Configure MMA8451 sensor //MMA8451Q
    hal_dev_mma8451_init();      //Initialize I2C modules
    tmp = hal_dev_mma8451_read_reg(0x2a);
    hal_dev_mma8451_write_reg(0x2a,tmp|0x01);
}



void accel_read(void)
{
  
        if((hal_dev_mma8451_read_reg(0x00)&0xf) != 0)
        {

            accel_x   = hal_dev_mma8451_read_reg(0x01)<<8;
            accel_x  |= hal_dev_mma8451_read_reg(0x02);
            accel_x >>= 2;

            accel_y   = hal_dev_mma8451_read_reg(0x03)<<8;
            accel_y  |= hal_dev_mma8451_read_reg(0x04);
            accel_y >>= 2;

            accel_z   = hal_dev_mma8451_read_reg(0x05)<<8;
            accel_z  |= hal_dev_mma8451_read_reg(0x06);
            accel_z >>= 2;

            resultx   = hal_dev_mma8451_read_reg(0x01)<<8;
            resultx  |= hal_dev_mma8451_read_reg(0x02);
            resultx >>= 8;

            resulty   = hal_dev_mma8451_read_reg(0x03)<<8;
            resulty  |= hal_dev_mma8451_read_reg(0x04);
            resulty >>= 8;

            resultz   = hal_dev_mma8451_read_reg(0x05)<<8;
            resultz  |= hal_dev_mma8451_read_reg(0x06);
            resultz >>= 8;
            
            
            angle_calculation(); //-900  to  900            
            detect_fall_detection();
            
            accel_demo();
            
            
        }
        
    
}

#define T_DELAY_LED  10


void accel_demo(void)
{
        static int note,notez;
        static int note1,notez1;
        static int note2,notez2;
    //     static int cont=0x1;
        if (ti_accel_sampling==0)
       {
         accel_read();              
         ti_accel_sampling = 10;            
       } 
 
  
        
       
        note  = yz_angle/100;  //9-9
        note1 = xy_angle/100;  //9-9
        note2 = xz_angle/100;  //9-9
        
        
        if (note != notez && yz_mag > 20 && !ti_delay)   //yz
        {
         if (note <-9) note=-9;
         if (note >9)  note =9;
         if (notez < note) notez++;
         if (notez > note) notez--;
        SET_LED_GREEN(notez*55+500);
        ti_delay = T_DELAY_LED;
        } 
         
        if (note1 != notez1 && xz_mag > 20 && !ti_delay)
        {
         if (note1 <-9) note1=-9;
         if (note1 >9)  note1 =9;
         if (notez1 < note1) notez1++;
         if (notez1 > note1) notez1--;
         SET_LED_RED(notez1*55+500);
         ti_delay = T_DELAY_LED;
        } 


       if (note2 != notez2 && xy_mag > 20 && !ti_delay)
        {
         if (note2 <-9) note2=-9;
         if (note2 >9)  note2 =9;
         if (notez2 < note2) notez2++;
         if (notez2 > note2) notez2--;
         SET_LED_BLUE(notez2*55+500);
         ti_delay = T_DELAY_LED;
        } 

  if (xy_mag < 20 &&  AbsolutePercentegePosition>0 ) 
      { 
  
         SET_LED_BLUE(AbsolutePercentegePosition*10);
         SET_LED_RED(AbsolutePercentegePosition*10);
         SET_LED_GREEN(AbsolutePercentegePosition*10);
      }
         
         
        }
        



/**   buzzer_TPM_init
 * \brief    Initialize LPTPM for RGB led control   
 * \brief    FTM2 and FTM  in PWM edge aligned mode 
 * \author   b01252
 * \param    none
 * \return   none
 */  


void TPM_init(void)
  { 
 
   SIM_SCGC5 |= SIM_SCGC5_PORTB_MASK | SIM_SCGC5_PORTA_MASK;
   
   SIM_SCGC6|=( SIM_SCGC6_TPM0_MASK | SIM_SCGC6_TPM1_MASK);   
   
   SIM_SOPT2 |= SIM_SOPT2_TPMSRC(1); //
   
      
   PORTB_PCR8 = (0|PORT_PCR_MUX(2)); /* TPM0_CH3 enable on PTB18 */
   PORTB_PCR9 = (0|PORT_PCR_MUX(2)); /* TPM0_CH2 enable on PTB19 */
   PORTB_PCR10  = (0|PORT_PCR_MUX(2)); /* TPM0_CH1 enable on PTD1 */
   

   TPM0_MOD  = TPM_MODULE;  /* 0x0063 / 25MHz = 4uS PWM period */
   TPM0_C1SC = TPM_Cn_MODE;   /* No Interrupts; High True pulses on Edge Aligned PWM */
   TPM0_C2SC = TPM_Cn_MODE;   /* No Interrupts; High True pulses on Edge Aligned PWM */
   TPM0_C3SC = TPM_Cn_MODE;   /* No Interrupts; High True pulses on Edge Aligned PWM */
   TPM0_C1V  = TPM_INIT_VAL;  /* 90% pulse width */
   TPM0_C2V  = TPM_INIT_VAL;  /* 90% pulse width */
   TPM0_C3V  = TPM_INIT_VAL;  /* 90% pulse width */
   TPM0_SC   = TPM_SC_CMOD(1) | TPM_SC_PS(0);     /* Edge Aligned PWM running from BUSCLK / 1 */
  
  }





void vfn_test_accel(void)
{
     if (ti_accel_sampling==0)
       {
         accel_read();              
         ti_accel_sampling = 10;            
       } 
 
  
}


/*

*/

void vfn_rgb_test(void)
 { 
  static char seq_count=0;
   
  if (!ti_task)
  {  
   seq_count++;
   ti_task = 500;
   switch (seq_count)  
   {
    case 4: 
       SET_LED_GREEN(200);
       SET_LED_RED(0);
       SET_LED_BLUE(0);
         
     break;
    case 3: 
       SET_LED_GREEN(0);
       SET_LED_RED(200);
       SET_LED_BLUE(0);
     break;
   case 2: 
       SET_LED_GREEN(0);
       SET_LED_RED(0);
       SET_LED_BLUE(200);
     break;
    case 1: 
       SET_LED_GREEN(100);
       SET_LED_RED(100);
       SET_LED_BLUE(100);
      
     break;

   default:
     seq_count=0;
     next_task(accel_demo);
   };
   
   
  
  
  }
    
     
   
    
 }


const int Led_sequence[] =
   {
     0x0,
     RED_MASK,
     GREEN_MASK,
     BLUE_MASK,
     RED_MASK  | GREEN_MASK,
     RED_MASK  | BLUE_MASK,
     BLUE_MASK | GREEN_MASK,
     GREEN_MASK,
     BLUE_MASK,
     RED_MASK,
     0x0,
   };
  

/********************************************************************/
        char aux1;
int main (void)
{
        gpio_init();
      
        Pit_init();
        TSI_Init();    
        TPM_init();
          
        next_task(vfn_rgb_test);
        printf("\nRunning the fredom_test project.\n");
        accel_init();
        

	while(1)
	{
          ptr_next_task();  // do the actual function 
          TSI_SliderRead();
          
          // check touch state,
          if( AbsolutePercentegePosition > 80 ) 
          {
            Write_WorkMode(WORK_MODE_BOOT_LOADER);
            SCB_AIRCR = SCB_AIRCR_SYSRESETREQ_MASK|0x05fa0000;
            while(1);
          }
	} 
}
/********************************************************************/

