
/*
 * File:        iic_slave.c
 * Purpose:     Provide common adc routines
 *
 * Notes:       
 *              
 */

#include "common.h"
#include "iic_slave.h"
#include "FC_protocol.h"
//
/***********************************************************************/
// local variable declaration
/***********************************************************************/
#define IIC_SLAVE_ADDRESS       0xb0
/***********************************************************************/
// local variable declaration
/***********************************************************************/
static unsigned char m_ucRecBuff[IIC_RX_BUFF_LENGTH];
static unsigned char m_ucSendBuff[IIC_TX_BUFF_LENGTH];
static uint32_t m_ucRecIndex;
static uint32_t m_ucSendIndex;
static uint32_t *m_pRxFrameLength;
//static uint8_t   m_bSlaveTxFlag;
/***********************************************************************/
// globe variable declaration
/***********************************************************************/
unsigned char g_bIICRecFrameFlag;
unsigned char g_ucIICRxFrameBuff[IIC_RX_BUFF_LENGTH+5];
unsigned char g_ucIICTxFrameBuff[IIC_TX_BUFF_LENGTH+5];
/***********************************************************************/
// local function
/***********************************************************************/
void IIC_Init( void );
void IIC_Irq( void );
void IIC_WriteTxBuff( unsigned char *pData,uint32_t uiLength );
void IIC_WriteTxComACK( unsigned char Command );
void IIC_WriteOneByteToTxBuff( unsigned char ucData );
/***********************************************************************/
// function prototype
/***********************************************************************/
void IIC_Init( void )
{
	SIM_SCGC5 |= SIM_SCGC5_PORTA_MASK; // enable PORTA clock
	PORTB_PCR3 = PORT_PCR_MUX(2);
	PORTB_PCR4 = PORT_PCR_MUX(2);

	SIM_SCGC4 |= SIM_SCGC4_I2C0_MASK;  // enable IIC0 clock
	enable_irq(8);
	I2C0_A1 = IIC_SLAVE_ADDRESS;
	I2C0_C1 = I2C_C1_WUEN_MASK|
	        I2C_C1_IICIE_MASK|
	         I2C_C1_IICEN_MASK;

	// clear frame rec flag
	g_bIICRecFrameFlag = 0;

}

volatile  unsigned char Dummy;
void IIC_Irq( void )
{
    if( I2C0_S & I2C_S_IICIF_MASK )
    {
      	I2C0_S |= I2C_S_IICIF_MASK;
      	if( I2C0_S & I2C_S_ARBL_MASK )
      	{
      		I2C0_S |= I2C_S_ARBL_MASK;
      		 if( !(I2C0_S & I2C_S_IAAS_MASK) )
      		 {
      		 	// IIAAS is 0
      		 	return;
      		 }
      	}
		if( I2C0_S & I2C_S_IAAS_MASK )
		{
			I2C0_C1 &= ~I2C_C1_TXAK_MASK;

			// clear index counter
			m_ucSendIndex = 0;
			m_ucRecIndex = 0;
			// clear frame rec flag
			g_bIICRecFrameFlag = 0;
			if( I2C0_S & I2C_S_SRW_MASK )
			{
				// slave send data
				I2C0_C1 |= I2C_C1_TX_MASK;
				I2C0_D = m_ucSendBuff[m_ucSendIndex++];
               
			}
			else
			{
			    I2C0_C1 &= ~I2C_C1_TX_MASK;
			    Dummy = I2C0_D;
             
			}
		}
		else
		{
			if( I2C0_S & I2C_S_SRW_MASK )
       		{
				// if require ACK from master
				if( I2C0_S & I2C_S_RXAK_MASK )
				{
					// no receive the ACK
					I2C0_C1 &= ~I2C_C1_TX_MASK;
			    	Dummy = I2C0_D;
			    	// switch to RX
            	}
				else
				{
					I2C0_D = m_ucSendBuff[m_ucSendIndex++];
				}
			}
			else
			{
				m_ucRecBuff[m_ucRecIndex++] = I2C0_D;
				if( m_ucRecIndex > sizeof(uint32_t) )
				{
					m_pRxFrameLength = (uint32_t *)&m_ucRecBuff[0];
					if( m_ucRecIndex >= (*m_pRxFrameLength) )
					{
						// receive a frame data from master
						g_bIICRecFrameFlag = 1; 
						Memcpy_Byte((uint8_t *)&g_ucIICRxFrameBuff[0],(uint8_t *)&m_ucRecBuff[0],m_ucRecIndex);

						// reset index counter
						m_ucRecIndex = 0;

						// change MCU state to BUSY
						m_ucSendBuff[0] = SLAVE_MCU_STATE_BUSY;
					}
				}
			}
		}
    }
}


void IIC_WriteTxBuff( unsigned char *pData,uint32_t uiLength )
{
	Memcpy_Byte( (uint8_t *)&m_ucSendBuff[1],(uint8_t *)pData, uiLength);
}

void IIC_WriteTxComACK( unsigned char Command )
{
	m_ucSendBuff[0] = Command|0x80;
}

void IIC_WriteOneByteToTxBuff( unsigned char ucData )
{
	m_ucSendBuff[1] = ucData;
}

