/*
 * FC_Topology.c
 *
 *  Created on: Dec 12, 2011
 *      Author: B37531
 */
#include "common.h"
#include "uart.h"
#include "FC_protocol.h"
#include "flash_FTFL.h" /* include flash driver header file */
#include "flag.h"
#include "iic_slave.h"
/********************************************************************/
////////////////////////////////////////////////////
// variable declare

static unsigned char m_ucMCU_ID_InfoBuff[64];
static unsigned char m_ucMCU_ID_InfoLength;
uint16_t uiNumberCount = 0;
unsigned char g_ucFC_State;
static uint8_t  m_ucDataBuff[WRITE_BLOCK_SIZE];
const FC_IDENT_INFO m_MCU_Info = {
    0,
	FC_PROTOCOL_VERSION,			
	IDENT_SDID,	
	FLASH_NUM,
	USER_FLASH_START_ADDR,		
	USER_FLASH_END_ADDR,			
	RELOCATION_VERTOR_ADDR,		
	INTERRUPT_VERTOR_ADDR,		
	ERASE_BLOCK_SIZE,			
	WRITE_BLOCK_SIZE,			
	K15_STRING
};


#pragma section="FlashConfig"
typedef union _FlashConfig_t
{
  unsigned int Data[4];
  struct {
    unsigned int BackDoorKey[2];
    unsigned char FPROT0;
    unsigned char FPROT1;
    unsigned char FPROT2;
    unsigned char FPROT3;
    unsigned char Fsec;             // FSEC 
    unsigned char Fopt;             // FOPT
    unsigned char Reserved1;       
    unsigned char Reserved2;  
  };
} FlashConfig_t;

#pragma location = "FlashConfig"
__root const FlashConfig_t Config @ "FlashConfig" =
{
 0xFFFFFFFF,
 0xFFFFFFFF, 
 0xFFFFFFFF, 
 0xFFFFFFFE,
};



/**************************************************************/
void FC_Init( void );
void JumpToUserApplication(uint32_t userStartup);
void LONG_Convert(uint32_t *pLong);
void MCU_ID_Package( void );
unsigned char FC_CheckReceiveFrame( unsigned char * ucData, uint32_t Length );
unsigned char FC_Check( void );


void FC_Init( void )
{
	MCU_ID_Package( );
}

unsigned char FC_CheckReceiveFrame( unsigned char *pData, uint32_t Length )
{
	uint32_t i;
	uint8_t ucSum;
	ucSum = 0;
	for(i=0;i<(Length-1);i++)
	{
		ucSum += pData[i];
	}
	if( ucSum == pData[Length-1] )
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

void MCU_ID_Package( void )
{
	ADDRESS_TYPE *pTempAddress;
    uint32_t *pRxFrameLenth;
	uint32_t uiIndex;
	uint32_t i;
	unsigned char Sum;
	m_ucMCU_ID_InfoBuff[4] = m_MCU_Info.Version;
	m_ucMCU_ID_InfoBuff[5] = (unsigned char)m_MCU_Info.Sdid>>8;
	m_ucMCU_ID_InfoBuff[6] = (unsigned char)m_MCU_Info.Sdid;
	
	uiIndex = 7;
	pTempAddress = (ADDRESS_TYPE *)&m_MCU_Info.BlocksCnt;
	for(i=0;i<7;i++)
	{
		m_ucMCU_ID_InfoBuff[uiIndex++] = pTempAddress[i].Bytes.hh;
		m_ucMCU_ID_InfoBuff[uiIndex++] = pTempAddress[i].Bytes.hl;
		m_ucMCU_ID_InfoBuff[uiIndex++] = pTempAddress[i].Bytes.lh;
		m_ucMCU_ID_InfoBuff[uiIndex++] = pTempAddress[i].Bytes.ll;
	}
	i = 0;
	do
	{
		m_ucMCU_ID_InfoBuff[uiIndex++] = m_MCU_Info.IdString[i];
	}while(m_MCU_Info.IdString[i++]);
	pRxFrameLenth = (uint32_t *)&m_ucMCU_ID_InfoBuff[0];
	*pRxFrameLenth = uiIndex + 1;
	Sum = 0;
	for( i=0;i<uiIndex;i++ )
	{
		Sum += m_ucMCU_ID_InfoBuff[4+i];
	}
	m_ucMCU_ID_InfoBuff[uiIndex++] = Sum;
	m_ucMCU_ID_InfoLength = uiIndex;

}
	
unsigned char FC_Check( void )
{
	uint32_t *pRxFrameLenth;
	uint32_t uiAddress;
	unsigned char *pReadAddress;
	if( g_bIICRecFrameFlag )
	{
		g_bIICRecFrameFlag = 0;

		pRxFrameLenth = (uint32_t *)&g_ucIICRxFrameBuff[0];
		// check received frame
		if( FC_CheckReceiveFrame(&g_ucIICRxFrameBuff[0],*pRxFrameLenth))
		{
			switch(g_ucIICRxFrameBuff[sizeof(uint32_t)])
			{
			case FC_CMD_HOOK:
				IIC_WriteTxComACK(FC_CMD_HOOK);
				IIC_WriteOneByteToTxBuff(FC_CMD_ACK);
				break;
			case FC_CMD_IDENT:
				{
					IIC_WriteTxComACK(FC_CMD_IDENT);
					IIC_WriteTxBuff(&m_ucMCU_ID_InfoBuff[0],m_ucMCU_ID_InfoLength);
                }
			break;
			case FC_CMD_ERASE:
				{
					Memcpy_Byte((uint8_t *)&uiAddress,
					(uint8_t *)&g_ucIICRxFrameBuff[sizeof(uint32_t)+1],sizeof(uint32_t));
					
					LONG_Convert(&uiAddress);
					if(!Flash_SectorErase(uiAddress))
					{
						IIC_WriteTxComACK(FC_CMD_ERASE);
						IIC_WriteOneByteToTxBuff(FC_CMD_ACK);
					}
					else
					{
						IIC_WriteTxComACK(FC_CMD_ERASE);
						IIC_WriteOneByteToTxBuff(FC_CMD_NACK);
					}
			}
			break;
			case FC_CMD_WRITE:
				{
					Memcpy_Byte((uint8_t *)&uiAddress,
					(uint8_t *)&g_ucIICRxFrameBuff[sizeof(uint32_t)+1],sizeof(uint32_t));
					LONG_Convert(&uiAddress);
                    Memcpy_Byte((uint8_t *)&m_ucDataBuff[0],
                    	(uint8_t *)&g_ucIICRxFrameBuff[sizeof(uint32_t)*2+2],
                		g_ucIICRxFrameBuff[sizeof(uint32_t)*2+1]);
			              
                   if( !Flash_ByteProgram(uiAddress,
				   (uint32_t *)&m_ucDataBuff[0],g_ucIICRxFrameBuff[sizeof(uint32_t)*2+1]) )
					{
						IIC_WriteTxComACK(FC_CMD_WRITE);
						IIC_WriteOneByteToTxBuff(FC_CMD_ACK);
					}
					else
					{
						IIC_WriteTxComACK(FC_CMD_WRITE);
                        IIC_WriteOneByteToTxBuff(FC_CMD_NACK);
					}
			}
			break;
			case FC_CMD_READ:
				{
					Memcpy_Byte((uint8_t *)&uiAddress,
					(uint8_t *)&g_ucIICRxFrameBuff[sizeof(uint32_t)+1],sizeof(uint32_t));
					LONG_Convert(&uiAddress);
					pReadAddress = (uint8_t *)uiAddress;
					IIC_WriteTxComACK(FC_CMD_READ);
					IIC_WriteTxBuff(pReadAddress,g_ucIICRxFrameBuff[sizeof(uint32_t)*2+1]);
					
			}
			break;
			case FC_CMD_QUIT:
				{
					// modify the flag to user mode
					 Write_WorkMode(WORK_MODE_USER_APP);

					 // modify the vector table
					 SCB_VTOR = RELOCATION_VERTOR_ADDR;
					 JumpToUserApplication(RELOCATION_VERTOR_ADDR);   
										   
			}
			break;
			default:
				//uart0_putchar( TERM_PORT,0xfc );
				break;
			}
		}
		else
		{
			IIC_WriteTxComACK(FC_CMD_ERROR);
		}

		return 1;
	}
	return 0;
}
		


void JumpToUserApplication(uint32_t userStartup)
{
    /* set up stack pointer */  
    asm("LDR     r1, [r0]");
    asm("mov     r13, r1");
    /* jump to application reset vector */
    asm("ADDS      r0,r0,#0x04 ");
    asm("LDR      r0, [r0]");
    asm("BX       r0");
}

void LONG_Convert(uint32_t *pLong)
{
	unsigned char *p;
	unsigned char ucTemp;
	p = ( unsigned char *)pLong;
	ucTemp = p[0];
	p[0] = p[3];
	p[3] = ucTemp;
	ucTemp = p[1];
	p[1] = p[2];
	p[2] = ucTemp;
}
void Memcpy_Byte(uint8_t * Dest,uint8_t * Src,uint32_t Size)
{
	while(Size--)
	{
		*Dest++ = *Src++;
	}
}
