/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: DMA_test.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************//*!

/*Include shared modules, which are used for whole project*/
#include "Types.h"
#include "derivative.h"
#include "main.h"

extern uint16_t  		ui16ADCresults[16];
extern PWMA_REG_UPDATE  udtPWMAvalreg;
extern PWMB_REG_READ  	udtPWMBcapreg;
/***************************************************************************//*!
*
* @brief   DMA Modules Initialization
*
* @param   void
*
* @return  none
*
******************************************************************************
*	DMA0 - ADC result registers reading, ADC EOS generate DMA request #12
*      
*
******************************************************************************/
void DMA0_Init(PWMB_REG_READ *ptr)
{
	// set source and destination addresses, shift left due to byte addressing
	DMA_SAR0 = ((uint32_t)(&PWMB_SM0CVAL0)<<1);
	DMA_DAR0 = ((uint32_t)(ptr)<<1);
		
	// clear status machine of DMA0 and set request from PWMB0 Capture = 10
	DMA_REQC |= DMA_REQC_CFSM0 | DMA_REQC_DMAC0_1 | DMA_REQC_DMAC0_3; 
	
	// source size = WORD, destination size = WORD, DEST, SOURCE increments set
	DMA_DCR0 |=   DMA_DCR0_SSIZE_1 |  DMA_DCR0_DSIZE_1 |  DMA_DCR0_SINC | DMA_DCR0_DINC | DMA_DCR0_ERQ;
	
	/* Enable DMA transfer completed interrupt - priority 1 */
	DMA_DCR0 |= DMA_DCR0_EINT;
	INTC_IPR3 |= INTC_IPR3_DMACH0_1;
	
	// clear status register
	DMA_DSR_BCR0 |= DMA_DSR_BCR0_DONE;
	// set byte number to be transfered
	DMA_DSR_BCR0 |= (DMA_DSR_BCR0_BCR & 24);
	
}

void DMA0_Preset(PWMB_REG_READ *ptr)
{
	// set source and destination addresses
	DMA_SAR0 = ((uint32_t)(&PWMB_SM0CVAL0)<<1);
	DMA_DAR0 = ((uint32_t)(ptr)<<1);
	// clear all status register
	DMA_DSR_BCR0 |= DMA_DSR_BCR0_DONE;
	// set byte number to be transfered
	DMA_DSR_BCR0 |= (DMA_DSR_BCR0_BCR & 24);}

void DMA1_Init(void)
{
	// set source and destination addresses, shift left due to byte addressing
	DMA_SAR1 = ((uint32_t)(&ADC12_RSLT0)<<1);
	DMA_DAR1 = ((uint32_t)(ui16ADCresults)<<1);
	
	// clear status machine of DMA1 and set request from ADC 12 EOS
	DMA_REQC |= DMA_REQC_CFSM1 | DMA_REQC_DMAC1_2 | DMA_REQC_DMAC1_3; 
	
	// source size = WORD, destination size = WORD, DEST, SOURCE increments set
	DMA_DCR1 |=   DMA_DCR1_SSIZE_1 |  DMA_DCR1_DSIZE_1 |  DMA_DCR1_SINC | DMA_DCR1_DINC | DMA_DCR1_ERQ;
	
	/* Enable DMA transfer completed interrupt - priority 1 */
	DMA_DCR1 |= DMA_DCR1_EINT;
	INTC_IPR3 |= INTC_IPR3_DMACH1_1;
	
	// clear status register
	DMA_DSR_BCR1 |= DMA_DSR_BCR1_DONE;
	// set byte number to be transfered
	DMA_DSR_BCR1 |= (DMA_DSR_BCR1_BCR & 32);
	
}

void DMA2_Init(PWMA_REG_UPDATE *ptr)
{
	// set source and destination addresses, shift left due to byte addressing
	DMA_SAR2 = ((uint32_t)(ptr)<<1);
	DMA_DAR2 = ((uint32_t)(&PWMA_SM0VAL0)<<1);	
	// clear status machine of DMA2 
	DMA_REQC |= DMA_REQC_CFSM2;
	// set request from PWMA write request
	DMA_REQC |= DMA_REQC_DMAC2_3 | DMA_REQC_DMAC2_1 | DMA_REQC_DMAC2_0; 
		
	// enable peripheral request
	DMA_DCR2 |=  DMA_DCR2_ERQ;
	// source size = WORD, destination size = WORD, SOURCE increments set, cycle-steal
	DMA_DCR2 |=  DMA_DCR2_SINC | DMA_DCR2_DINC | DMA_DCR2_SSIZE_1 |  DMA_DCR1_DSIZE_1; 
	
	// Enable DMA transfer completed interrupt - priority 1 
	DMA_DCR2 |= DMA_DCR2_EINT;
	INTC_IPR3 |= INTC_IPR3_DMACH2_1;
		
	// clear status register
	DMA_DSR_BCR2 |= DMA_DSR_BCR2_DONE;
	// set byte number to be transfered
	DMA_DSR_BCR2 |= (DMA_DSR_BCR2_BCR & 22);
	
}

void DMA2_Preset(PWMA_REG_UPDATE *ptr)
{
	ptr->SM0.pwmsmval2++;
	ptr->SM0.pwmsmval3--;
	ptr->SM0.pwmsmval4++;
	ptr->SM0.pwmsmval5--;
	ptr->SM0.pwmsmfracval2++;
	
	DMA_SAR2 = ((uint32_t)(ptr)<<1);
	DMA_DAR2 = ((uint32_t)(&PWMA_SM0VAL0)<<1);	
		
	// clear all status register
	DMA_DSR_BCR2 |= DMA_DSR_BCR2_DONE;
		
	// set byte number to be transfered
	DMA_DSR_BCR2 |= (DMA_DSR_BCR2_BCR & 22);
}


/******************************************************************************/
/**************************         END          ******************************/
/******************************************************************************/