/******************************************************************************
* 
* Copyright (c) 2012 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
/*!
********************************************************************************
*
* FILE NAME: PWM_B_Init.c   
*
* TARGET: MC56F8400 device
*
*******************************************************************************
*
* Detailed Description of the file.
*
***************************************************************************/

#ifndef __PWM_B_test_H
#define __PWM_B_test_H

typedef struct
{
    Word16 pwmsmcval0;
    Word16 pwmsmcval0cyc;
    Word16 pwmsmcval1;
    Word16 pwmsmcval1cyc;
    Word16 pwmsmcval2;
    Word16 pwmsmcval2cyc;
    Word16 pwmsmcval3;
    Word16 pwmsmcval3cyc;
    Word16 pwmsmcval4;
    Word16 pwmsmcval4cyc;
    Word16 pwmsmcval5;
    Word16 pwmsmcval5cyc;
} PWMB_CAP_REG;

typedef struct
{
	PWMB_CAP_REG SM0;
} PWMB_REG_READ;

/******************************************************************************
* Global functions
******************************************************************************/
extern void PWM_B_Init(PWMB_REG_READ *ptr);
extern void PWM_B_Read_Cap(PWMB_REG_READ *ptr);


#endif // __PWM_B_H