//////////////////////////////////////////////////////////////////////////////////////
// File: MC56F84789.h
// Purpose: Define the peripheral registers.
// This file has been automatically generated from the APIF knowledgebase
//////////////////////////////////////////////////////////////////////////////////////
#ifndef __CPU_H
typedef unsigned char           uint8_t;
typedef volatile uint8_t        vuint8_t;
typedef unsigned short int      uint16_t;
typedef volatile uint16_t       vuint16_t;
typedef unsigned long           uint32_t;
typedef volatile uint32_t       vuint32_t;
#endif __CPU_H
//
//////////////////////////////////////////////////////////////////////////////////////
// Generic Bit Definitions Used Elsewhere in this File
#ifndef __CPU_H
#define  BIT0                        0x1
#define  BIT1                        0x2
#define  BIT2                        0x4
#define  BIT3                        0x8
#define  BIT4                        0x10
#define  BIT5                        0x20
#define  BIT6                        0x40
#define  BIT7                        0x80
#define  BIT8                        0x100
#define  BIT9                        0x200
#define  BIT10                       0x400
#define  BIT11                       0x800
#define  BIT12                       0x1000
#define  BIT13                       0x2000
#define  BIT14                       0x4000
#define  BIT15                       0x8000
#define  BIT16                       0x10000
#define  BIT17                       0x20000
#define  BIT18                       0x40000
#define  BIT19                       0x80000
#define  BIT20                       0x100000
#define  BIT21                       0x200000
#define  BIT22                       0x400000
#define  BIT23                       0x800000
#define  BIT24                       0x1000000
#define  BIT25                       0x2000000
#define  BIT26                       0x4000000
#define  BIT27                       0x8000000
#define  BIT28                       0x10000000
#define  BIT29                       0x20000000
#define  BIT30                       0x40000000
#define  BIT31                       0x80000000
#endif __CPU_H
//////////////////////////////////////////////////////////////////////////////////////
//
// Peripheral Base Address Defines in Alphabetical Order
//
#define  ADC12_BASE                  (*(vuint16_t *) (0xE500)) // for C, then embedded assembly
#define  FADC12_BASE                 0xE500

#define  ADC16_BASE                  (*(vuint16_t *) (0xE580)) // for C, then embedded assembly
#define  FADC16_BASE                 0xE580

#define  AOI_BASE                    (*(vuint16_t *) (0xE380)) // for C, then embedded assembly
#define  FAOI_BASE                   0xE380

#define  CAN_BASE                    (*(vuint16_t *) (0xE800)) // for C, then embedded assembly
#define  FCAN_BASE                   0xE800

#define  CMPA_BASE                   (*(vuint16_t *) (0xE020)) // for C, then embedded assembly
#define  FCMPA_BASE                  0xE020

#define  CMPB_BASE                   (*(vuint16_t *) (0xE028)) // for C, then embedded assembly
#define  FCMPB_BASE                  0xE028

#define  CMPC_BASE                   (*(vuint16_t *) (0xE030)) // for C, then embedded assembly
#define  FCMPC_BASE                  0xE030

#define  CMPD_BASE                   (*(vuint16_t *) (0xE038)) // for C, then embedded assembly
#define  FCMPD_BASE                  0xE038

#define  COP_BASE                    (*(vuint16_t *) (0xE320)) // for C, then embedded assembly
#define  FCOP_BASE                   0xE320

#define  CRC_BASE                    (*(vuint16_t *) (0xE1C0)) // for C, then embedded assembly
#define  FCRC_BASE                   0xE1C0

#define  DAC_BASE                    (*(vuint16_t *) (0xE000)) // for C, then embedded assembly
#define  FDAC_BASE                   0xE000

#define  DMA_BASE                    (*(vuint16_t *) (0xC800)) // for C, then embedded assembly
#define  FDMA_BASE                   0xC800

#define  ENC_BASE                    (*(vuint16_t *) (0xE1E0)) // for C, then embedded assembly
#define  FENC_BASE                   0xE1E0

#define  EWM_BASE                    (*(vuint16_t *) (0xE330)) // for C, then embedded assembly
#define  FEWM_BASE                   0xE330

#define  FMC_BASE                    (*(vuint16_t *) (0xDE00)) // for C, then embedded assembly
#define  FFMC_BASE                   0xDE00

#define  FTFL_BASE                   (*(vuint8_t *) (0x1C780)) // for C, then embedded assembly
#define  FFTFL_BASE                  0x1C780

#define  GPIOA_BASE                  (*(vuint16_t *) (0xE200)) // for C, then embedded assembly
#define  FGPIOA_BASE                 0xE200

#define  GPIOB_BASE                  (*(vuint16_t *) (0xE210)) // for C, then embedded assembly
#define  FGPIOB_BASE                 0xE210

#define  GPIOC_BASE                  (*(vuint16_t *) (0xE220)) // for C, then embedded assembly
#define  FGPIOC_BASE                 0xE220

#define  GPIOD_BASE                  (*(vuint16_t *) (0xE230)) // for C, then embedded assembly
#define  FGPIOD_BASE                 0xE230

#define  GPIOE_BASE                  (*(vuint16_t *) (0xE240)) // for C, then embedded assembly
#define  FGPIOE_BASE                 0xE240

#define  GPIOF_BASE                  (*(vuint16_t *) (0xE250)) // for C, then embedded assembly
#define  FGPIOF_BASE                 0xE250

#define  GPIOG_BASE                  (*(vuint16_t *) (0xE260)) // for C, then embedded assembly
#define  FGPIOG_BASE                 0xE260

#define  I2C0_BASE                   (*(vuint16_t *) (0xE0E0)) // for C, then embedded assembly
#define  FI2C0_BASE                  0xE0E0

#define  I2C1_BASE                   (*(vuint16_t *) (0xE0F0)) // for C, then embedded assembly
#define  FI2C1_BASE                  0xE0F0

#define  INTC_BASE                   (*(vuint16_t *) (0xE300)) // for C, then embedded assembly
#define  FINTC_BASE                  0xE300

#define  MCM_BASE                    (*(vuint8_t *) (0x18000)) // for C, then embedded assembly
#define  FMCM_BASE                   0x18000

#define  OCCS_BASE                   (*(vuint16_t *) (0xE2B0)) // for C, then embedded assembly
#define  FOCCS_BASE                  0xE2B0

#define  PDB0_BASE                   (*(vuint16_t *) (0xE120)) // for C, then embedded assembly
#define  FPDB0_BASE                  0xE120

#define  PDB1_BASE                   (*(vuint16_t *) (0xE130)) // for C, then embedded assembly
#define  FPDB1_BASE                  0xE130

#define  PIT0_BASE                   (*(vuint16_t *) (0xE100)) // for C, then embedded assembly
#define  FPIT0_BASE                  0xE100

#define  PIT1_BASE                   (*(vuint16_t *) (0xE110)) // for C, then embedded assembly
#define  FPIT1_BASE                  0xE110

#define  PMC_BASE                    (*(vuint16_t *) (0xE2A0)) // for C, then embedded assembly
#define  FPMC_BASE                   0xE2A0

#define  PWMA_BASE                   (*(vuint16_t *) (0xE600)) // for C, then embedded assembly
#define  FPWMA_BASE                  0xE600

#define  PWMB_BASE                   (*(vuint16_t *) (0xE700)) // for C, then embedded assembly
#define  FPWMB_BASE                  0xE700

#define  QSCI0_BASE                  (*(vuint16_t *) (0xE080)) // for C, then embedded assembly
#define  FQSCI0_BASE                 0xE080

#define  QSCI1_BASE                  (*(vuint16_t *) (0xE090)) // for C, then embedded assembly
#define  FQSCI1_BASE                 0xE090

#define  QSCI2_BASE                  (*(vuint16_t *) (0xE0A0)) // for C, then embedded assembly
#define  FQSCI2_BASE                 0xE0A0

#define  QSPI0_BASE                  (*(vuint16_t *) (0xE0B0)) // for C, then embedded assembly
#define  FQSPI0_BASE                 0xE0B0

#define  QSPI1_BASE                  (*(vuint16_t *) (0xE0C0)) // for C, then embedded assembly
#define  FQSPI1_BASE                 0xE0C0

#define  QSPI2_BASE                  (*(vuint16_t *) (0xE0D0)) // for C, then embedded assembly
#define  FQSPI2_BASE                 0xE0D0

#define  SIM_BASE                    (*(vuint16_t *) (0xE400)) // for C, then embedded assembly
#define  FSIM_BASE                   0xE400

#define  TMRA_BASE                   (*(vuint16_t *) (0xE140)) // for C, then embedded assembly
#define  FTMRA_BASE                  0xE140

#define  TMRB_BASE                   (*(vuint16_t *) (0xE180)) // for C, then embedded assembly
#define  FTMRB_BASE                  0xE180

#define  XBARA_BASE                  (*(vuint16_t *) (0xE340)) // for C, then embedded assembly
#define  FXBARA_BASE                 0xE340

#define  XBARB_BASE                  (*(vuint16_t *) (0xE360)) // for C, then embedded assembly
#define  FXBARB_BASE                 0xE360


//////////////////////////////////////////////////////////////////////////////////////
// The following section defines the IO register locations.
//////////////////////////////////////////////////////////////////////////////////////

#define  ADC12_CTRL1                 (*(vuint16_t *) (0xE500)) // for C, then embedded assembly
#define  FADC12_CTRL1                0xE500

#define  ADC12_CTRL2                 (*(vuint16_t *) (0xE501)) // for C, then embedded assembly
#define  FADC12_CTRL2                0xE501

#define  ADC12_ZXCTRL1               (*(vuint16_t *) (0xE502)) // for C, then embedded assembly
#define  FADC12_ZXCTRL1              0xE502

#define  ADC12_ZXCTRL2               (*(vuint16_t *) (0xE503)) // for C, then embedded assembly
#define  FADC12_ZXCTRL2              0xE503

#define  ADC12_CLIST1                (*(vuint16_t *) (0xE504)) // for C, then embedded assembly
#define  FADC12_CLIST1               0xE504

#define  ADC12_CLIST2                (*(vuint16_t *) (0xE505)) // for C, then embedded assembly
#define  FADC12_CLIST2               0xE505

#define  ADC12_CLIST3                (*(vuint16_t *) (0xE506)) // for C, then embedded assembly
#define  FADC12_CLIST3               0xE506

#define  ADC12_CLIST4                (*(vuint16_t *) (0xE507)) // for C, then embedded assembly
#define  FADC12_CLIST4               0xE507

#define  ADC12_SDIS                  (*(vuint16_t *) (0xE508)) // for C, then embedded assembly
#define  FADC12_SDIS                 0xE508

#define  ADC12_STAT                  (*(vuint16_t *) (0xE509)) // for C, then embedded assembly
#define  FADC12_STAT                 0xE509

#define  ADC12_RDY                   (*(vuint16_t *) (0xE50A)) // for C, then embedded assembly
#define  FADC12_RDY                  0xE50A

#define  ADC12_LOLIMSTAT             (*(vuint16_t *) (0xE50B)) // for C, then embedded assembly
#define  FADC12_LOLIMSTAT            0xE50B

#define  ADC12_HILIMSTAT             (*(vuint16_t *) (0xE50C)) // for C, then embedded assembly
#define  FADC12_HILIMSTAT            0xE50C

#define  ADC12_ZXSTAT                (*(vuint16_t *) (0xE50D)) // for C, then embedded assembly
#define  FADC12_ZXSTAT               0xE50D

#define  ADC12_RSLT0                 (*(vuint16_t *) (0xE50E)) // for C, then embedded assembly
#define  FADC12_RSLT0                0xE50E

#define  ADC12_RSLT1                 (*(vuint16_t *) (0xE50F)) // for C, then embedded assembly
#define  FADC12_RSLT1                0xE50F

#define  ADC12_RSLT2                 (*(vuint16_t *) (0xE510)) // for C, then embedded assembly
#define  FADC12_RSLT2                0xE510

#define  ADC12_RSLT3                 (*(vuint16_t *) (0xE511)) // for C, then embedded assembly
#define  FADC12_RSLT3                0xE511

#define  ADC12_RSLT4                 (*(vuint16_t *) (0xE512)) // for C, then embedded assembly
#define  FADC12_RSLT4                0xE512

#define  ADC12_RSLT5                 (*(vuint16_t *) (0xE513)) // for C, then embedded assembly
#define  FADC12_RSLT5                0xE513

#define  ADC12_RSLT6                 (*(vuint16_t *) (0xE514)) // for C, then embedded assembly
#define  FADC12_RSLT6                0xE514

#define  ADC12_RSLT7                 (*(vuint16_t *) (0xE515)) // for C, then embedded assembly
#define  FADC12_RSLT7                0xE515

#define  ADC12_RSLT8                 (*(vuint16_t *) (0xE516)) // for C, then embedded assembly
#define  FADC12_RSLT8                0xE516

#define  ADC12_RSLT9                 (*(vuint16_t *) (0xE517)) // for C, then embedded assembly
#define  FADC12_RSLT9                0xE517

#define  ADC12_RSLT10                (*(vuint16_t *) (0xE518)) // for C, then embedded assembly
#define  FADC12_RSLT10               0xE518

#define  ADC12_RSLT11                (*(vuint16_t *) (0xE519)) // for C, then embedded assembly
#define  FADC12_RSLT11               0xE519

#define  ADC12_RSLT12                (*(vuint16_t *) (0xE51A)) // for C, then embedded assembly
#define  FADC12_RSLT12               0xE51A

#define  ADC12_RSLT13                (*(vuint16_t *) (0xE51B)) // for C, then embedded assembly
#define  FADC12_RSLT13               0xE51B

#define  ADC12_RSLT14                (*(vuint16_t *) (0xE51C)) // for C, then embedded assembly
#define  FADC12_RSLT14               0xE51C

#define  ADC12_RSLT15                (*(vuint16_t *) (0xE51D)) // for C, then embedded assembly
#define  FADC12_RSLT15               0xE51D

#define  ADC12_LOLIM0                (*(vuint16_t *) (0xE51E)) // for C, then embedded assembly
#define  FADC12_LOLIM0               0xE51E

#define  ADC12_LOLIM1                (*(vuint16_t *) (0xE51F)) // for C, then embedded assembly
#define  FADC12_LOLIM1               0xE51F

#define  ADC12_LOLIM2                (*(vuint16_t *) (0xE520)) // for C, then embedded assembly
#define  FADC12_LOLIM2               0xE520

#define  ADC12_LOLIM3                (*(vuint16_t *) (0xE521)) // for C, then embedded assembly
#define  FADC12_LOLIM3               0xE521

#define  ADC12_LOLIM4                (*(vuint16_t *) (0xE522)) // for C, then embedded assembly
#define  FADC12_LOLIM4               0xE522

#define  ADC12_LOLIM5                (*(vuint16_t *) (0xE523)) // for C, then embedded assembly
#define  FADC12_LOLIM5               0xE523

#define  ADC12_LOLIM6                (*(vuint16_t *) (0xE524)) // for C, then embedded assembly
#define  FADC12_LOLIM6               0xE524

#define  ADC12_LOLIM7                (*(vuint16_t *) (0xE525)) // for C, then embedded assembly
#define  FADC12_LOLIM7               0xE525

#define  ADC12_LOLIM8                (*(vuint16_t *) (0xE526)) // for C, then embedded assembly
#define  FADC12_LOLIM8               0xE526

#define  ADC12_LOLIM9                (*(vuint16_t *) (0xE527)) // for C, then embedded assembly
#define  FADC12_LOLIM9               0xE527

#define  ADC12_LOLIM10               (*(vuint16_t *) (0xE528)) // for C, then embedded assembly
#define  FADC12_LOLIM10              0xE528

#define  ADC12_LOLIM11               (*(vuint16_t *) (0xE529)) // for C, then embedded assembly
#define  FADC12_LOLIM11              0xE529

#define  ADC12_LOLIM12               (*(vuint16_t *) (0xE52A)) // for C, then embedded assembly
#define  FADC12_LOLIM12              0xE52A

#define  ADC12_LOLIM13               (*(vuint16_t *) (0xE52B)) // for C, then embedded assembly
#define  FADC12_LOLIM13              0xE52B

#define  ADC12_LOLIM14               (*(vuint16_t *) (0xE52C)) // for C, then embedded assembly
#define  FADC12_LOLIM14              0xE52C

#define  ADC12_LOLIM15               (*(vuint16_t *) (0xE52D)) // for C, then embedded assembly
#define  FADC12_LOLIM15              0xE52D

#define  ADC12_HILIM0                (*(vuint16_t *) (0xE52E)) // for C, then embedded assembly
#define  FADC12_HILIM0               0xE52E

#define  ADC12_HILIM1                (*(vuint16_t *) (0xE52F)) // for C, then embedded assembly
#define  FADC12_HILIM1               0xE52F

#define  ADC12_HILIM2                (*(vuint16_t *) (0xE530)) // for C, then embedded assembly
#define  FADC12_HILIM2               0xE530

#define  ADC12_HILIM3                (*(vuint16_t *) (0xE531)) // for C, then embedded assembly
#define  FADC12_HILIM3               0xE531

#define  ADC12_HILIM4                (*(vuint16_t *) (0xE532)) // for C, then embedded assembly
#define  FADC12_HILIM4               0xE532

#define  ADC12_HILIM5                (*(vuint16_t *) (0xE533)) // for C, then embedded assembly
#define  FADC12_HILIM5               0xE533

#define  ADC12_HILIM6                (*(vuint16_t *) (0xE534)) // for C, then embedded assembly
#define  FADC12_HILIM6               0xE534

#define  ADC12_HILIM7                (*(vuint16_t *) (0xE535)) // for C, then embedded assembly
#define  FADC12_HILIM7               0xE535

#define  ADC12_HILIM8                (*(vuint16_t *) (0xE536)) // for C, then embedded assembly
#define  FADC12_HILIM8               0xE536

#define  ADC12_HILIM9                (*(vuint16_t *) (0xE537)) // for C, then embedded assembly
#define  FADC12_HILIM9               0xE537

#define  ADC12_HILIM10               (*(vuint16_t *) (0xE538)) // for C, then embedded assembly
#define  FADC12_HILIM10              0xE538

#define  ADC12_HILIM11               (*(vuint16_t *) (0xE539)) // for C, then embedded assembly
#define  FADC12_HILIM11              0xE539

#define  ADC12_HILIM12               (*(vuint16_t *) (0xE53A)) // for C, then embedded assembly
#define  FADC12_HILIM12              0xE53A

#define  ADC12_HILIM13               (*(vuint16_t *) (0xE53B)) // for C, then embedded assembly
#define  FADC12_HILIM13              0xE53B

#define  ADC12_HILIM14               (*(vuint16_t *) (0xE53C)) // for C, then embedded assembly
#define  FADC12_HILIM14              0xE53C

#define  ADC12_HILIM15               (*(vuint16_t *) (0xE53D)) // for C, then embedded assembly
#define  FADC12_HILIM15              0xE53D

#define  ADC12_OFFST0                (*(vuint16_t *) (0xE53E)) // for C, then embedded assembly
#define  FADC12_OFFST0               0xE53E

#define  ADC12_OFFST1                (*(vuint16_t *) (0xE53F)) // for C, then embedded assembly
#define  FADC12_OFFST1               0xE53F

#define  ADC12_OFFST2                (*(vuint16_t *) (0xE540)) // for C, then embedded assembly
#define  FADC12_OFFST2               0xE540

#define  ADC12_OFFST3                (*(vuint16_t *) (0xE541)) // for C, then embedded assembly
#define  FADC12_OFFST3               0xE541

#define  ADC12_OFFST4                (*(vuint16_t *) (0xE542)) // for C, then embedded assembly
#define  FADC12_OFFST4               0xE542

#define  ADC12_OFFST5                (*(vuint16_t *) (0xE543)) // for C, then embedded assembly
#define  FADC12_OFFST5               0xE543

#define  ADC12_OFFST6                (*(vuint16_t *) (0xE544)) // for C, then embedded assembly
#define  FADC12_OFFST6               0xE544

#define  ADC12_OFFST7                (*(vuint16_t *) (0xE545)) // for C, then embedded assembly
#define  FADC12_OFFST7               0xE545

#define  ADC12_OFFST8                (*(vuint16_t *) (0xE546)) // for C, then embedded assembly
#define  FADC12_OFFST8               0xE546

#define  ADC12_OFFST9                (*(vuint16_t *) (0xE547)) // for C, then embedded assembly
#define  FADC12_OFFST9               0xE547

#define  ADC12_OFFST10               (*(vuint16_t *) (0xE548)) // for C, then embedded assembly
#define  FADC12_OFFST10              0xE548

#define  ADC12_OFFST11               (*(vuint16_t *) (0xE549)) // for C, then embedded assembly
#define  FADC12_OFFST11              0xE549

#define  ADC12_OFFST12               (*(vuint16_t *) (0xE54A)) // for C, then embedded assembly
#define  FADC12_OFFST12              0xE54A

#define  ADC12_OFFST13               (*(vuint16_t *) (0xE54B)) // for C, then embedded assembly
#define  FADC12_OFFST13              0xE54B

#define  ADC12_OFFST14               (*(vuint16_t *) (0xE54C)) // for C, then embedded assembly
#define  FADC12_OFFST14              0xE54C

#define  ADC12_OFFST15               (*(vuint16_t *) (0xE54D)) // for C, then embedded assembly
#define  FADC12_OFFST15              0xE54D

#define  ADC12_PWR                   (*(vuint16_t *) (0xE54E)) // for C, then embedded assembly
#define  FADC12_PWR                  0xE54E

#define  ADC12_CAL                   (*(vuint16_t *) (0xE54F)) // for C, then embedded assembly
#define  FADC12_CAL                  0xE54F

#define  ADC12_GC1                   (*(vuint16_t *) (0xE550)) // for C, then embedded assembly
#define  FADC12_GC1                  0xE550

#define  ADC12_GC2                   (*(vuint16_t *) (0xE551)) // for C, then embedded assembly
#define  FADC12_GC2                  0xE551

#define  ADC12_SCTRL                 (*(vuint16_t *) (0xE552)) // for C, then embedded assembly
#define  FADC12_SCTRL                0xE552

#define  ADC12_PWR2                  (*(vuint16_t *) (0xE553)) // for C, then embedded assembly
#define  FADC12_PWR2                 0xE553

#define  ADC12_CTRL3                 (*(vuint16_t *) (0xE554)) // for C, then embedded assembly
#define  FADC12_CTRL3                0xE554

#define  ADC12_SCHLTEN               (*(vuint16_t *) (0xE555)) // for C, then embedded assembly
#define  FADC12_SCHLTEN              0xE555

#define  ADC16_SC1A                  (*(vuint32_t *) (0xE580)) // for C, then embedded assembly
#define  FADC16_SC1A                 0xE580

#define  ADC16_CFG1                  (*(vuint32_t *) (0xE584)) // for C, then embedded assembly
#define  FADC16_CFG1                 0xE584

#define  ADC16_CFG2                  (*(vuint32_t *) (0xE586)) // for C, then embedded assembly
#define  FADC16_CFG2                 0xE586

#define  ADC16_RA                    (*(vuint32_t *) (0xE588)) // for C, then embedded assembly
#define  FADC16_RA                   0xE588

#define  ADC16_CV1                   (*(vuint32_t *) (0xE58C)) // for C, then embedded assembly
#define  FADC16_CV1                  0xE58C

#define  ADC16_CV2                   (*(vuint32_t *) (0xE58E)) // for C, then embedded assembly
#define  FADC16_CV2                  0xE58E

#define  ADC16_SC2                   (*(vuint32_t *) (0xE590)) // for C, then embedded assembly
#define  FADC16_SC2                  0xE590

#define  ADC16_SC3                   (*(vuint32_t *) (0xE592)) // for C, then embedded assembly
#define  FADC16_SC3                  0xE592

#define  ADC16_OFS                   (*(vuint32_t *) (0xE594)) // for C, then embedded assembly
#define  FADC16_OFS                  0xE594

#define  ADC16_PG                    (*(vuint32_t *) (0xE596)) // for C, then embedded assembly
#define  FADC16_PG                   0xE596

#define  ADC16_MG                    (*(vuint32_t *) (0xE598)) // for C, then embedded assembly
#define  FADC16_MG                   0xE598

#define  ADC16_CLPD                  (*(vuint32_t *) (0xE59A)) // for C, then embedded assembly
#define  FADC16_CLPD                 0xE59A

#define  ADC16_CLPS                  (*(vuint32_t *) (0xE59C)) // for C, then embedded assembly
#define  FADC16_CLPS                 0xE59C

#define  ADC16_CLP4                  (*(vuint32_t *) (0xE59E)) // for C, then embedded assembly
#define  FADC16_CLP4                 0xE59E

#define  ADC16_CLP3                  (*(vuint32_t *) (0xE5A0)) // for C, then embedded assembly
#define  FADC16_CLP3                 0xE5A0

#define  ADC16_CLP2                  (*(vuint32_t *) (0xE5A2)) // for C, then embedded assembly
#define  FADC16_CLP2                 0xE5A2

#define  ADC16_CLP1                  (*(vuint32_t *) (0xE5A4)) // for C, then embedded assembly
#define  FADC16_CLP1                 0xE5A4

#define  ADC16_CLP0                  (*(vuint32_t *) (0xE5A6)) // for C, then embedded assembly
#define  FADC16_CLP0                 0xE5A6

#define  ADC16_CLMD                  (*(vuint32_t *) (0xE5AA)) // for C, then embedded assembly
#define  FADC16_CLMD                 0xE5AA

#define  ADC16_CLMS                  (*(vuint32_t *) (0xE5AC)) // for C, then embedded assembly
#define  FADC16_CLMS                 0xE5AC

#define  ADC16_CLM4                  (*(vuint32_t *) (0xE5AE)) // for C, then embedded assembly
#define  FADC16_CLM4                 0xE5AE

#define  ADC16_CLM3                  (*(vuint32_t *) (0xE5B0)) // for C, then embedded assembly
#define  FADC16_CLM3                 0xE5B0

#define  ADC16_CLM2                  (*(vuint32_t *) (0xE5B2)) // for C, then embedded assembly
#define  FADC16_CLM2                 0xE5B2

#define  ADC16_CLM1                  (*(vuint32_t *) (0xE5B4)) // for C, then embedded assembly
#define  FADC16_CLM1                 0xE5B4

#define  ADC16_CLM0                  (*(vuint32_t *) (0xE5B6)) // for C, then embedded assembly
#define  FADC16_CLM0                 0xE5B6

#define  AOI_BFCRT010                (*(vuint16_t *) (0xE380)) // for C, then embedded assembly
#define  FAOI_BFCRT010               0xE380

#define  AOI_BFCRT230                (*(vuint16_t *) (0xE381)) // for C, then embedded assembly
#define  FAOI_BFCRT230               0xE381

#define  AOI_BFCRT011                (*(vuint16_t *) (0xE382)) // for C, then embedded assembly
#define  FAOI_BFCRT011               0xE382

#define  AOI_BFCRT231                (*(vuint16_t *) (0xE383)) // for C, then embedded assembly
#define  FAOI_BFCRT231               0xE383

#define  AOI_BFCRT012                (*(vuint16_t *) (0xE384)) // for C, then embedded assembly
#define  FAOI_BFCRT012               0xE384

#define  AOI_BFCRT232                (*(vuint16_t *) (0xE385)) // for C, then embedded assembly
#define  FAOI_BFCRT232               0xE385

#define  AOI_BFCRT013                (*(vuint16_t *) (0xE386)) // for C, then embedded assembly
#define  FAOI_BFCRT013               0xE386

#define  AOI_BFCRT233                (*(vuint16_t *) (0xE387)) // for C, then embedded assembly
#define  FAOI_BFCRT233               0xE387

#define  CAN_MCR                     (*(vuint32_t *) (0xE800)) // for C, then embedded assembly
#define  FCAN_MCR                    0xE800

#define  CAN_CTRL1                   (*(vuint32_t *) (0xE802)) // for C, then embedded assembly
#define  FCAN_CTRL1                  0xE802

#define  CAN_TIMER                   (*(vuint32_t *) (0xE804)) // for C, then embedded assembly
#define  FCAN_TIMER                  0xE804

#define  CAN_RXMGMASK                (*(vuint32_t *) (0xE808)) // for C, then embedded assembly
#define  FCAN_RXMGMASK               0xE808

#define  CAN_RX14MASK                (*(vuint32_t *) (0xE80A)) // for C, then embedded assembly
#define  FCAN_RX14MASK               0xE80A

#define  CAN_RX15MASK                (*(vuint32_t *) (0xE80C)) // for C, then embedded assembly
#define  FCAN_RX15MASK               0xE80C

#define  CAN_ECR                     (*(vuint32_t *) (0xE80E)) // for C, then embedded assembly
#define  FCAN_ECR                    0xE80E

#define  CAN_ESR1                    (*(vuint32_t *) (0xE810)) // for C, then embedded assembly
#define  FCAN_ESR1                   0xE810

#define  CAN_IMASK2                  (*(vuint32_t *) (0xE812)) // for C, then embedded assembly
#define  FCAN_IMASK2                 0xE812

#define  CAN_IMASK1                  (*(vuint32_t *) (0xE814)) // for C, then embedded assembly
#define  FCAN_IMASK1                 0xE814

#define  CAN_IFLAG2                  (*(vuint32_t *) (0xE816)) // for C, then embedded assembly
#define  FCAN_IFLAG2                 0xE816

#define  CAN_IFLAG1                  (*(vuint32_t *) (0xE818)) // for C, then embedded assembly
#define  FCAN_IFLAG1                 0xE818

#define  CAN_CTRL2                   (*(vuint32_t *) (0xE81A)) // for C, then embedded assembly
#define  FCAN_CTRL2                  0xE81A

#define  CAN_ESR2                    (*(vuint32_t *) (0xE81C)) // for C, then embedded assembly
#define  FCAN_ESR2                   0xE81C

#define  CAN_CRCR                    (*(vuint32_t *) (0xE822)) // for C, then embedded assembly
#define  FCAN_CRCR                   0xE822

#define  CAN_RXFGMASK                (*(vuint32_t *) (0xE824)) // for C, then embedded assembly
#define  FCAN_RXFGMASK               0xE824

#define  CAN_RXFIR                   (*(vuint32_t *) (0xE826)) // for C, then embedded assembly
#define  FCAN_RXFIR                  0xE826

#define  CAN_CS0                     (*(vuint32_t *) (0xE880)) // for C, then embedded assembly
#define  FCAN_CS0                    0xE880

#define  CAN_ID0                     (*(vuint32_t *) (0xE884)) // for C, then embedded assembly
#define  FCAN_ID0                    0xE884

#define  CAN_WORD00                  (*(vuint32_t *) (0xE888)) // for C, then embedded assembly
#define  FCAN_WORD00                 0xE888

#define  CAN_WORD10                  (*(vuint32_t *) (0xE88C)) // for C, then embedded assembly
#define  FCAN_WORD10                 0xE88C

#define  CAN_CS1                     (*(vuint32_t *) (0xE890)) // for C, then embedded assembly
#define  FCAN_CS1                    0xE890

#define  CAN_ID1                     (*(vuint32_t *) (0xE894)) // for C, then embedded assembly
#define  FCAN_ID1                    0xE894

#define  CAN_WORD01                  (*(vuint32_t *) (0xE898)) // for C, then embedded assembly
#define  FCAN_WORD01                 0xE898

#define  CAN_WORD11                  (*(vuint32_t *) (0xE89C)) // for C, then embedded assembly
#define  FCAN_WORD11                 0xE89C

#define  CAN_CS2                     (*(vuint32_t *) (0xE8A0)) // for C, then embedded assembly
#define  FCAN_CS2                    0xE8A0

#define  CAN_ID2                     (*(vuint32_t *) (0xE8A4)) // for C, then embedded assembly
#define  FCAN_ID2                    0xE8A4

#define  CAN_WORD02                  (*(vuint32_t *) (0xE8A8)) // for C, then embedded assembly
#define  FCAN_WORD02                 0xE8A8

#define  CAN_WORD12                  (*(vuint32_t *) (0xE8AC)) // for C, then embedded assembly
#define  FCAN_WORD12                 0xE8AC

#define  CAN_CS3                     (*(vuint32_t *) (0xE8B0)) // for C, then embedded assembly
#define  FCAN_CS3                    0xE8B0

#define  CAN_ID3                     (*(vuint32_t *) (0xE8B4)) // for C, then embedded assembly
#define  FCAN_ID3                    0xE8B4

#define  CAN_WORD03                  (*(vuint32_t *) (0xE8B8)) // for C, then embedded assembly
#define  FCAN_WORD03                 0xE8B8

#define  CAN_WORD13                  (*(vuint32_t *) (0xE8BC)) // for C, then embedded assembly
#define  FCAN_WORD13                 0xE8BC

#define  CAN_CS4                     (*(vuint32_t *) (0xE8C0)) // for C, then embedded assembly
#define  FCAN_CS4                    0xE8C0

#define  CAN_ID4                     (*(vuint32_t *) (0xE8C4)) // for C, then embedded assembly
#define  FCAN_ID4                    0xE8C4

#define  CAN_WORD04                  (*(vuint32_t *) (0xE8C8)) // for C, then embedded assembly
#define  FCAN_WORD04                 0xE8C8

#define  CAN_WORD14                  (*(vuint32_t *) (0xE8CC)) // for C, then embedded assembly
#define  FCAN_WORD14                 0xE8CC

#define  CAN_CS5                     (*(vuint32_t *) (0xE8D0)) // for C, then embedded assembly
#define  FCAN_CS5                    0xE8D0

#define  CAN_ID5                     (*(vuint32_t *) (0xE8D4)) // for C, then embedded assembly
#define  FCAN_ID5                    0xE8D4

#define  CAN_WORD05                  (*(vuint32_t *) (0xE8D8)) // for C, then embedded assembly
#define  FCAN_WORD05                 0xE8D8

#define  CAN_WORD15                  (*(vuint32_t *) (0xE8DC)) // for C, then embedded assembly
#define  FCAN_WORD15                 0xE8DC

#define  CAN_CS6                     (*(vuint32_t *) (0xE8E0)) // for C, then embedded assembly
#define  FCAN_CS6                    0xE8E0

#define  CAN_ID6                     (*(vuint32_t *) (0xE8E4)) // for C, then embedded assembly
#define  FCAN_ID6                    0xE8E4

#define  CAN_WORD06                  (*(vuint32_t *) (0xE8E8)) // for C, then embedded assembly
#define  FCAN_WORD06                 0xE8E8

#define  CAN_WORD16                  (*(vuint32_t *) (0xE8EC)) // for C, then embedded assembly
#define  FCAN_WORD16                 0xE8EC

#define  CAN_CS7                     (*(vuint32_t *) (0xE8F0)) // for C, then embedded assembly
#define  FCAN_CS7                    0xE8F0

#define  CAN_ID7                     (*(vuint32_t *) (0xE8F4)) // for C, then embedded assembly
#define  FCAN_ID7                    0xE8F4

#define  CAN_WORD07                  (*(vuint32_t *) (0xE8F8)) // for C, then embedded assembly
#define  FCAN_WORD07                 0xE8F8

#define  CAN_WORD17                  (*(vuint32_t *) (0xE8FC)) // for C, then embedded assembly
#define  FCAN_WORD17                 0xE8FC

#define  CAN_CS8                     (*(vuint32_t *) (0xE900)) // for C, then embedded assembly
#define  FCAN_CS8                    0xE900

#define  CAN_ID8                     (*(vuint32_t *) (0xE904)) // for C, then embedded assembly
#define  FCAN_ID8                    0xE904

#define  CAN_WORD08                  (*(vuint32_t *) (0xE908)) // for C, then embedded assembly
#define  FCAN_WORD08                 0xE908

#define  CAN_WORD18                  (*(vuint32_t *) (0xE90C)) // for C, then embedded assembly
#define  FCAN_WORD18                 0xE90C

#define  CAN_CS9                     (*(vuint32_t *) (0xE910)) // for C, then embedded assembly
#define  FCAN_CS9                    0xE910

#define  CAN_ID9                     (*(vuint32_t *) (0xE914)) // for C, then embedded assembly
#define  FCAN_ID9                    0xE914

#define  CAN_WORD09                  (*(vuint32_t *) (0xE918)) // for C, then embedded assembly
#define  FCAN_WORD09                 0xE918

#define  CAN_WORD19                  (*(vuint32_t *) (0xE91C)) // for C, then embedded assembly
#define  FCAN_WORD19                 0xE91C

#define  CAN_CS10                    (*(vuint32_t *) (0xE920)) // for C, then embedded assembly
#define  FCAN_CS10                   0xE920

#define  CAN_ID10                    (*(vuint32_t *) (0xE924)) // for C, then embedded assembly
#define  FCAN_ID10                   0xE924

#define  CAN_WORD010                 (*(vuint32_t *) (0xE928)) // for C, then embedded assembly
#define  FCAN_WORD010                0xE928

#define  CAN_WORD110                 (*(vuint32_t *) (0xE92C)) // for C, then embedded assembly
#define  FCAN_WORD110                0xE92C

#define  CAN_CS11                    (*(vuint32_t *) (0xE930)) // for C, then embedded assembly
#define  FCAN_CS11                   0xE930

#define  CAN_ID11                    (*(vuint32_t *) (0xE934)) // for C, then embedded assembly
#define  FCAN_ID11                   0xE934

#define  CAN_WORD011                 (*(vuint32_t *) (0xE938)) // for C, then embedded assembly
#define  FCAN_WORD011                0xE938

#define  CAN_WORD111                 (*(vuint32_t *) (0xE93C)) // for C, then embedded assembly
#define  FCAN_WORD111                0xE93C

#define  CAN_CS12                    (*(vuint32_t *) (0xE940)) // for C, then embedded assembly
#define  FCAN_CS12                   0xE940

#define  CAN_ID12                    (*(vuint32_t *) (0xE944)) // for C, then embedded assembly
#define  FCAN_ID12                   0xE944

#define  CAN_WORD012                 (*(vuint32_t *) (0xE948)) // for C, then embedded assembly
#define  FCAN_WORD012                0xE948

#define  CAN_WORD112                 (*(vuint32_t *) (0xE94C)) // for C, then embedded assembly
#define  FCAN_WORD112                0xE94C

#define  CAN_CS13                    (*(vuint32_t *) (0xE950)) // for C, then embedded assembly
#define  FCAN_CS13                   0xE950

#define  CAN_ID13                    (*(vuint32_t *) (0xE954)) // for C, then embedded assembly
#define  FCAN_ID13                   0xE954

#define  CAN_WORD013                 (*(vuint32_t *) (0xE958)) // for C, then embedded assembly
#define  FCAN_WORD013                0xE958

#define  CAN_WORD113                 (*(vuint32_t *) (0xE95C)) // for C, then embedded assembly
#define  FCAN_WORD113                0xE95C

#define  CAN_CS14                    (*(vuint32_t *) (0xE960)) // for C, then embedded assembly
#define  FCAN_CS14                   0xE960

#define  CAN_ID14                    (*(vuint32_t *) (0xE964)) // for C, then embedded assembly
#define  FCAN_ID14                   0xE964

#define  CAN_WORD014                 (*(vuint32_t *) (0xE968)) // for C, then embedded assembly
#define  FCAN_WORD014                0xE968

#define  CAN_WORD114                 (*(vuint32_t *) (0xE96C)) // for C, then embedded assembly
#define  FCAN_WORD114                0xE96C

#define  CAN_CS15                    (*(vuint32_t *) (0xE970)) // for C, then embedded assembly
#define  FCAN_CS15                   0xE970

#define  CAN_ID15                    (*(vuint32_t *) (0xE974)) // for C, then embedded assembly
#define  FCAN_ID15                   0xE974

#define  CAN_WORD015                 (*(vuint32_t *) (0xE978)) // for C, then embedded assembly
#define  FCAN_WORD015                0xE978

#define  CAN_WORD115                 (*(vuint32_t *) (0xE97C)) // for C, then embedded assembly
#define  FCAN_WORD115                0xE97C

#define  CAN_RXIMR0                  (*(vuint32_t *) (0xEC40)) // for C, then embedded assembly
#define  FCAN_RXIMR0                 0xEC40

#define  CAN_RXIMR1                  (*(vuint32_t *) (0xEC42)) // for C, then embedded assembly
#define  FCAN_RXIMR1                 0xEC42

#define  CAN_RXIMR2                  (*(vuint32_t *) (0xEC44)) // for C, then embedded assembly
#define  FCAN_RXIMR2                 0xEC44

#define  CAN_RXIMR3                  (*(vuint32_t *) (0xEC46)) // for C, then embedded assembly
#define  FCAN_RXIMR3                 0xEC46

#define  CAN_RXIMR4                  (*(vuint32_t *) (0xEC48)) // for C, then embedded assembly
#define  FCAN_RXIMR4                 0xEC48

#define  CAN_RXIMR5                  (*(vuint32_t *) (0xEC4A)) // for C, then embedded assembly
#define  FCAN_RXIMR5                 0xEC4A

#define  CAN_RXIMR6                  (*(vuint32_t *) (0xEC4C)) // for C, then embedded assembly
#define  FCAN_RXIMR6                 0xEC4C

#define  CAN_RXIMR7                  (*(vuint32_t *) (0xEC4E)) // for C, then embedded assembly
#define  FCAN_RXIMR7                 0xEC4E

#define  CAN_RXIMR8                  (*(vuint32_t *) (0xEC50)) // for C, then embedded assembly
#define  FCAN_RXIMR8                 0xEC50

#define  CAN_RXIMR9                  (*(vuint32_t *) (0xEC52)) // for C, then embedded assembly
#define  FCAN_RXIMR9                 0xEC52

#define  CAN_RXIMR10                 (*(vuint32_t *) (0xEC54)) // for C, then embedded assembly
#define  FCAN_RXIMR10                0xEC54

#define  CAN_RXIMR11                 (*(vuint32_t *) (0xEC56)) // for C, then embedded assembly
#define  FCAN_RXIMR11                0xEC56

#define  CAN_RXIMR12                 (*(vuint32_t *) (0xEC58)) // for C, then embedded assembly
#define  FCAN_RXIMR12                0xEC58

#define  CAN_RXIMR13                 (*(vuint32_t *) (0xEC5A)) // for C, then embedded assembly
#define  FCAN_RXIMR13                0xEC5A

#define  CAN_RXIMR14                 (*(vuint32_t *) (0xEC5C)) // for C, then embedded assembly
#define  FCAN_RXIMR14                0xEC5C

#define  CAN_RXIMR15                 (*(vuint32_t *) (0xEC5E)) // for C, then embedded assembly
#define  FCAN_RXIMR15                0xEC5E

#define  CMPA_CR0                    (*(vuint16_t *) (0xE020)) // for C, then embedded assembly
#define  FCMPA_CR0                   0xE020

#define  CMPA_CR1                    (*(vuint16_t *) (0xE021)) // for C, then embedded assembly
#define  FCMPA_CR1                   0xE021

#define  CMPA_FPR                    (*(vuint16_t *) (0xE022)) // for C, then embedded assembly
#define  FCMPA_FPR                   0xE022

#define  CMPA_SCR                    (*(vuint16_t *) (0xE023)) // for C, then embedded assembly
#define  FCMPA_SCR                   0xE023

#define  CMPA_DACCR                  (*(vuint16_t *) (0xE024)) // for C, then embedded assembly
#define  FCMPA_DACCR                 0xE024

#define  CMPA_MUXCR                  (*(vuint16_t *) (0xE025)) // for C, then embedded assembly
#define  FCMPA_MUXCR                 0xE025

#define  CMPB_CR0                    (*(vuint16_t *) (0xE028)) // for C, then embedded assembly
#define  FCMPB_CR0                   0xE028

#define  CMPB_CR1                    (*(vuint16_t *) (0xE029)) // for C, then embedded assembly
#define  FCMPB_CR1                   0xE029

#define  CMPB_FPR                    (*(vuint16_t *) (0xE02A)) // for C, then embedded assembly
#define  FCMPB_FPR                   0xE02A

#define  CMPB_SCR                    (*(vuint16_t *) (0xE02B)) // for C, then embedded assembly
#define  FCMPB_SCR                   0xE02B

#define  CMPB_DACCR                  (*(vuint16_t *) (0xE02C)) // for C, then embedded assembly
#define  FCMPB_DACCR                 0xE02C

#define  CMPB_MUXCR                  (*(vuint16_t *) (0xE02D)) // for C, then embedded assembly
#define  FCMPB_MUXCR                 0xE02D

#define  CMPC_CR0                    (*(vuint16_t *) (0xE030)) // for C, then embedded assembly
#define  FCMPC_CR0                   0xE030

#define  CMPC_CR1                    (*(vuint16_t *) (0xE031)) // for C, then embedded assembly
#define  FCMPC_CR1                   0xE031

#define  CMPC_FPR                    (*(vuint16_t *) (0xE032)) // for C, then embedded assembly
#define  FCMPC_FPR                   0xE032

#define  CMPC_SCR                    (*(vuint16_t *) (0xE033)) // for C, then embedded assembly
#define  FCMPC_SCR                   0xE033

#define  CMPC_DACCR                  (*(vuint16_t *) (0xE034)) // for C, then embedded assembly
#define  FCMPC_DACCR                 0xE034

#define  CMPC_MUXCR                  (*(vuint16_t *) (0xE035)) // for C, then embedded assembly
#define  FCMPC_MUXCR                 0xE035

#define  CMPD_CR0                    (*(vuint16_t *) (0xE038)) // for C, then embedded assembly
#define  FCMPD_CR0                   0xE038

#define  CMPD_CR1                    (*(vuint16_t *) (0xE039)) // for C, then embedded assembly
#define  FCMPD_CR1                   0xE039

#define  CMPD_FPR                    (*(vuint16_t *) (0xE03A)) // for C, then embedded assembly
#define  FCMPD_FPR                   0xE03A

#define  CMPD_SCR                    (*(vuint16_t *) (0xE03B)) // for C, then embedded assembly
#define  FCMPD_SCR                   0xE03B

#define  CMPD_DACCR                  (*(vuint16_t *) (0xE03C)) // for C, then embedded assembly
#define  FCMPD_DACCR                 0xE03C

#define  CMPD_MUXCR                  (*(vuint16_t *) (0xE03D)) // for C, then embedded assembly
#define  FCMPD_MUXCR                 0xE03D

#define  COP_CTRL                    (*(vuint16_t *) (0xE320)) // for C, then embedded assembly
#define  FCOP_CTRL                   0xE320

#define  COP_TOUT                    (*(vuint16_t *) (0xE321)) // for C, then embedded assembly
#define  FCOP_TOUT                   0xE321

#define  COP_CNTR                    (*(vuint16_t *) (0xE322)) // for C, then embedded assembly
#define  FCOP_CNTR                   0xE322

#define  COP_INTVAL                  (*(vuint16_t *) (0xE323)) // for C, then embedded assembly
#define  FCOP_INTVAL                 0xE323

#define  CRC_CRC                     (*(vuint32_t *) (0xE1C0)) // for C, then embedded assembly
#define  FCRC_CRC                    0xE1C0

#define  CRC_GPOLY                   (*(vuint32_t *) (0xE1C2)) // for C, then embedded assembly
#define  FCRC_GPOLY                  0xE1C2

#define  CRC_CTRL                    (*(vuint32_t *) (0xE1C4)) // for C, then embedded assembly
#define  FCRC_CTRL                   0xE1C4

#define  DAC_CTRL0                   (*(vuint16_t *) (0xE000)) // for C, then embedded assembly
#define  FDAC_CTRL0                  0xE000

#define  DAC_DATAREG                 (*(vuint16_t *) (0xE001)) // for C, then embedded assembly
#define  FDAC_DATAREG                0xE001

#define  DAC_STEPVAL                 (*(vuint16_t *) (0xE002)) // for C, then embedded assembly
#define  FDAC_STEPVAL                0xE002

#define  DAC_MINVAL                  (*(vuint16_t *) (0xE003)) // for C, then embedded assembly
#define  FDAC_MINVAL                 0xE003

#define  DAC_MAXVAL                  (*(vuint16_t *) (0xE004)) // for C, then embedded assembly
#define  FDAC_MAXVAL                 0xE004

#define  DAC_STATUS                  (*(vuint16_t *) (0xE005)) // for C, then embedded assembly
#define  FDAC_STATUS                 0xE005

#define  DAC_CTRL1                   (*(vuint16_t *) (0xE006)) // for C, then embedded assembly
#define  FDAC_CTRL1                  0xE006

#define  DMA_REQC                    (*(vuint32_t *) (0xC800)) // for C, then embedded assembly
#define  FDMA_REQC                   0xC800

#define  DMA_SAR0                    (*(vuint32_t *) (0xC880)) // for C, then embedded assembly
#define  FDMA_SAR0                   0xC880

#define  DMA_DAR0                    (*(vuint32_t *) (0xC882)) // for C, then embedded assembly
#define  FDMA_DAR0                   0xC882

#define  DMA_DSR_BCR0                (*(vuint32_t *) (0xC884)) // for C, then embedded assembly
#define  FDMA_DSR_BCR0               0xC884

#define  DMA_DCR0                    (*(vuint32_t *) (0xC886)) // for C, then embedded assembly
#define  FDMA_DCR0                   0xC886

#define  DMA_SAR1                    (*(vuint32_t *) (0xC888)) // for C, then embedded assembly
#define  FDMA_SAR1                   0xC888

#define  DMA_DAR1                    (*(vuint32_t *) (0xC88A)) // for C, then embedded assembly
#define  FDMA_DAR1                   0xC88A

#define  DMA_DSR_BCR1                (*(vuint32_t *) (0xC88C)) // for C, then embedded assembly
#define  FDMA_DSR_BCR1               0xC88C

#define  DMA_DCR1                    (*(vuint32_t *) (0xC88E)) // for C, then embedded assembly
#define  FDMA_DCR1                   0xC88E

#define  DMA_SAR2                    (*(vuint32_t *) (0xC890)) // for C, then embedded assembly
#define  FDMA_SAR2                   0xC890

#define  DMA_DAR2                    (*(vuint32_t *) (0xC892)) // for C, then embedded assembly
#define  FDMA_DAR2                   0xC892

#define  DMA_DSR_BCR2                (*(vuint32_t *) (0xC894)) // for C, then embedded assembly
#define  FDMA_DSR_BCR2               0xC894

#define  DMA_DCR2                    (*(vuint32_t *) (0xC896)) // for C, then embedded assembly
#define  FDMA_DCR2                   0xC896

#define  DMA_SAR3                    (*(vuint32_t *) (0xC898)) // for C, then embedded assembly
#define  FDMA_SAR3                   0xC898

#define  DMA_DAR3                    (*(vuint32_t *) (0xC89A)) // for C, then embedded assembly
#define  FDMA_DAR3                   0xC89A

#define  DMA_DSR_BCR3                (*(vuint32_t *) (0xC89C)) // for C, then embedded assembly
#define  FDMA_DSR_BCR3               0xC89C

#define  DMA_DCR3                    (*(vuint32_t *) (0xC89E)) // for C, then embedded assembly
#define  FDMA_DCR3                   0xC89E

#define  ENC_CTRL                    (*(vuint16_t *) (0xE1E0)) // for C, then embedded assembly
#define  FENC_CTRL                   0xE1E0

#define  ENC_FILT                    (*(vuint16_t *) (0xE1E1)) // for C, then embedded assembly
#define  FENC_FILT                   0xE1E1

#define  ENC_WTR                     (*(vuint16_t *) (0xE1E2)) // for C, then embedded assembly
#define  FENC_WTR                    0xE1E2

#define  ENC_POSD                    (*(vuint16_t *) (0xE1E3)) // for C, then embedded assembly
#define  FENC_POSD                   0xE1E3

#define  ENC_POSDH                   (*(vuint16_t *) (0xE1E4)) // for C, then embedded assembly
#define  FENC_POSDH                  0xE1E4

#define  ENC_REV                     (*(vuint16_t *) (0xE1E5)) // for C, then embedded assembly
#define  FENC_REV                    0xE1E5

#define  ENC_REVH                    (*(vuint16_t *) (0xE1E6)) // for C, then embedded assembly
#define  FENC_REVH                   0xE1E6

#define  ENC_UPOS                    (*(vuint16_t *) (0xE1E7)) // for C, then embedded assembly
#define  FENC_UPOS                   0xE1E7

#define  ENC_LPOS                    (*(vuint16_t *) (0xE1E8)) // for C, then embedded assembly
#define  FENC_LPOS                   0xE1E8

#define  ENC_UPOSH                   (*(vuint16_t *) (0xE1E9)) // for C, then embedded assembly
#define  FENC_UPOSH                  0xE1E9

#define  ENC_LPOSH                   (*(vuint16_t *) (0xE1EA)) // for C, then embedded assembly
#define  FENC_LPOSH                  0xE1EA

#define  ENC_UINIT                   (*(vuint16_t *) (0xE1EB)) // for C, then embedded assembly
#define  FENC_UINIT                  0xE1EB

#define  ENC_LINIT                   (*(vuint16_t *) (0xE1EC)) // for C, then embedded assembly
#define  FENC_LINIT                  0xE1EC

#define  ENC_IMR                     (*(vuint16_t *) (0xE1ED)) // for C, then embedded assembly
#define  FENC_IMR                    0xE1ED

#define  ENC_TST                     (*(vuint16_t *) (0xE1EE)) // for C, then embedded assembly
#define  FENC_TST                    0xE1EE

#define  ENC_CTRL2                   (*(vuint16_t *) (0xE1EF)) // for C, then embedded assembly
#define  FENC_CTRL2                  0xE1EF

#define  ENC_UMOD                    (*(vuint16_t *) (0xE1F0)) // for C, then embedded assembly
#define  FENC_UMOD                   0xE1F0

#define  ENC_LMOD                    (*(vuint16_t *) (0xE1F1)) // for C, then embedded assembly
#define  FENC_LMOD                   0xE1F1

#define  ENC_UCOMP                   (*(vuint16_t *) (0xE1F2)) // for C, then embedded assembly
#define  FENC_UCOMP                  0xE1F2

#define  ENC_LCOMP                   (*(vuint16_t *) (0xE1F3)) // for C, then embedded assembly
#define  FENC_LCOMP                  0xE1F3

#define  EWM_CTRL                    (*(vuint16_t *) (0xE330)) // for C, then embedded assembly
#define  FEWM_CTRL                   0xE330

#define  EWM_SERV                    (*(vuint16_t *) (0xE331)) // for C, then embedded assembly
#define  FEWM_SERV                   0xE331

#define  EWM_CMPL                    (*(vuint16_t *) (0xE332)) // for C, then embedded assembly
#define  FEWM_CMPL                   0xE332

#define  EWM_CMPH                    (*(vuint16_t *) (0xE333)) // for C, then embedded assembly
#define  FEWM_CMPH                   0xE333

#define  EWM_CLKCTRL                 (*(vuint16_t *) (0xE334)) // for C, then embedded assembly
#define  FEWM_CLKCTRL                0xE334

#define  EWM_CLKPRESCALER            (*(vuint16_t *) (0xE335)) // for C, then embedded assembly
#define  FEWM_CLKPRESCALER           0xE335

#define  FMC_PFAPR                   (*(vuint32_t *) (0xDE00)) // for C, then embedded assembly
#define  FFMC_PFAPR                  0xDE00

#define  FMC_PFB0CR                  (*(vuint32_t *) (0xDE02)) // for C, then embedded assembly
#define  FFMC_PFB0CR                 0xDE02

#define  FMC_PFB1CR                  (*(vuint32_t *) (0xDE04)) // for C, then embedded assembly
#define  FFMC_PFB1CR                 0xDE04

#define  FMC_TAGVDW0S0               (*(vuint32_t *) (0xDE80)) // for C, then embedded assembly
#define  FFMC_TAGVDW0S0              0xDE80

#define  FMC_TAGVDW0S1               (*(vuint32_t *) (0xDE82)) // for C, then embedded assembly
#define  FFMC_TAGVDW0S1              0xDE82

#define  FMC_TAGVDW0S2               (*(vuint32_t *) (0xDE84)) // for C, then embedded assembly
#define  FFMC_TAGVDW0S2              0xDE84

#define  FMC_TAGVDW0S3               (*(vuint32_t *) (0xDE86)) // for C, then embedded assembly
#define  FFMC_TAGVDW0S3              0xDE86

#define  FMC_TAGVDW0S4               (*(vuint32_t *) (0xDE88)) // for C, then embedded assembly
#define  FFMC_TAGVDW0S4              0xDE88

#define  FMC_TAGVDW0S5               (*(vuint32_t *) (0xDE8A)) // for C, then embedded assembly
#define  FFMC_TAGVDW0S5              0xDE8A

#define  FMC_TAGVDW0S6               (*(vuint32_t *) (0xDE8C)) // for C, then embedded assembly
#define  FFMC_TAGVDW0S6              0xDE8C

#define  FMC_TAGVDW0S7               (*(vuint32_t *) (0xDE8E)) // for C, then embedded assembly
#define  FFMC_TAGVDW0S7              0xDE8E

#define  FMC_TAGVDW1S0               (*(vuint32_t *) (0xDE90)) // for C, then embedded assembly
#define  FFMC_TAGVDW1S0              0xDE90

#define  FMC_TAGVDW1S1               (*(vuint32_t *) (0xDE92)) // for C, then embedded assembly
#define  FFMC_TAGVDW1S1              0xDE92

#define  FMC_TAGVDW1S2               (*(vuint32_t *) (0xDE94)) // for C, then embedded assembly
#define  FFMC_TAGVDW1S2              0xDE94

#define  FMC_TAGVDW1S3               (*(vuint32_t *) (0xDE96)) // for C, then embedded assembly
#define  FFMC_TAGVDW1S3              0xDE96

#define  FMC_TAGVDW1S4               (*(vuint32_t *) (0xDE98)) // for C, then embedded assembly
#define  FFMC_TAGVDW1S4              0xDE98

#define  FMC_TAGVDW1S5               (*(vuint32_t *) (0xDE9A)) // for C, then embedded assembly
#define  FFMC_TAGVDW1S5              0xDE9A

#define  FMC_TAGVDW1S6               (*(vuint32_t *) (0xDE9C)) // for C, then embedded assembly
#define  FFMC_TAGVDW1S6              0xDE9C

#define  FMC_TAGVDW1S7               (*(vuint32_t *) (0xDE9E)) // for C, then embedded assembly
#define  FFMC_TAGVDW1S7              0xDE9E

#define  FMC_TAGVDW2S0               (*(vuint32_t *) (0xDEA0)) // for C, then embedded assembly
#define  FFMC_TAGVDW2S0              0xDEA0

#define  FMC_TAGVDW2S1               (*(vuint32_t *) (0xDEA2)) // for C, then embedded assembly
#define  FFMC_TAGVDW2S1              0xDEA2

#define  FMC_TAGVDW2S2               (*(vuint32_t *) (0xDEA4)) // for C, then embedded assembly
#define  FFMC_TAGVDW2S2              0xDEA4

#define  FMC_TAGVDW2S3               (*(vuint32_t *) (0xDEA6)) // for C, then embedded assembly
#define  FFMC_TAGVDW2S3              0xDEA6

#define  FMC_TAGVDW2S4               (*(vuint32_t *) (0xDEA8)) // for C, then embedded assembly
#define  FFMC_TAGVDW2S4              0xDEA8

#define  FMC_TAGVDW2S5               (*(vuint32_t *) (0xDEAA)) // for C, then embedded assembly
#define  FFMC_TAGVDW2S5              0xDEAA

#define  FMC_TAGVDW2S6               (*(vuint32_t *) (0xDEAC)) // for C, then embedded assembly
#define  FFMC_TAGVDW2S6              0xDEAC

#define  FMC_TAGVDW2S7               (*(vuint32_t *) (0xDEAE)) // for C, then embedded assembly
#define  FFMC_TAGVDW2S7              0xDEAE

#define  FMC_TAGVDW3S0               (*(vuint32_t *) (0xDEB0)) // for C, then embedded assembly
#define  FFMC_TAGVDW3S0              0xDEB0

#define  FMC_TAGVDW3S1               (*(vuint32_t *) (0xDEB2)) // for C, then embedded assembly
#define  FFMC_TAGVDW3S1              0xDEB2

#define  FMC_TAGVDW3S2               (*(vuint32_t *) (0xDEB4)) // for C, then embedded assembly
#define  FFMC_TAGVDW3S2              0xDEB4

#define  FMC_TAGVDW3S3               (*(vuint32_t *) (0xDEB6)) // for C, then embedded assembly
#define  FFMC_TAGVDW3S3              0xDEB6

#define  FMC_TAGVDW3S4               (*(vuint32_t *) (0xDEB8)) // for C, then embedded assembly
#define  FFMC_TAGVDW3S4              0xDEB8

#define  FMC_TAGVDW3S5               (*(vuint32_t *) (0xDEBA)) // for C, then embedded assembly
#define  FFMC_TAGVDW3S5              0xDEBA

#define  FMC_TAGVDW3S6               (*(vuint32_t *) (0xDEBC)) // for C, then embedded assembly
#define  FFMC_TAGVDW3S6              0xDEBC

#define  FMC_TAGVDW3S7               (*(vuint32_t *) (0xDEBE)) // for C, then embedded assembly
#define  FFMC_TAGVDW3S7              0xDEBE

#define  FMC_DATAW0S0U               (*(vuint32_t *) (0xDF00)) // for C, then embedded assembly
#define  FFMC_DATAW0S0U              0xDF00

#define  FMC_DATAW0S0L               (*(vuint32_t *) (0xDF02)) // for C, then embedded assembly
#define  FFMC_DATAW0S0L              0xDF02

#define  FMC_DATAW0S1U               (*(vuint32_t *) (0xDF04)) // for C, then embedded assembly
#define  FFMC_DATAW0S1U              0xDF04

#define  FMC_DATAW0S1L               (*(vuint32_t *) (0xDF06)) // for C, then embedded assembly
#define  FFMC_DATAW0S1L              0xDF06

#define  FMC_DATAW0S2U               (*(vuint32_t *) (0xDF08)) // for C, then embedded assembly
#define  FFMC_DATAW0S2U              0xDF08

#define  FMC_DATAW0S2L               (*(vuint32_t *) (0xDF0A)) // for C, then embedded assembly
#define  FFMC_DATAW0S2L              0xDF0A

#define  FMC_DATAW0S3U               (*(vuint32_t *) (0xDF0C)) // for C, then embedded assembly
#define  FFMC_DATAW0S3U              0xDF0C

#define  FMC_DATAW0S3L               (*(vuint32_t *) (0xDF0E)) // for C, then embedded assembly
#define  FFMC_DATAW0S3L              0xDF0E

#define  FMC_DATAW0S4U               (*(vuint32_t *) (0xDF10)) // for C, then embedded assembly
#define  FFMC_DATAW0S4U              0xDF10

#define  FMC_DATAW0S4L               (*(vuint32_t *) (0xDF12)) // for C, then embedded assembly
#define  FFMC_DATAW0S4L              0xDF12

#define  FMC_DATAW0S5U               (*(vuint32_t *) (0xDF14)) // for C, then embedded assembly
#define  FFMC_DATAW0S5U              0xDF14

#define  FMC_DATAW0S5L               (*(vuint32_t *) (0xDF16)) // for C, then embedded assembly
#define  FFMC_DATAW0S5L              0xDF16

#define  FMC_DATAW0S6U               (*(vuint32_t *) (0xDF18)) // for C, then embedded assembly
#define  FFMC_DATAW0S6U              0xDF18

#define  FMC_DATAW0S6L               (*(vuint32_t *) (0xDF1A)) // for C, then embedded assembly
#define  FFMC_DATAW0S6L              0xDF1A

#define  FMC_DATAW0S7U               (*(vuint32_t *) (0xDF1C)) // for C, then embedded assembly
#define  FFMC_DATAW0S7U              0xDF1C

#define  FMC_DATAW0S7L               (*(vuint32_t *) (0xDF1E)) // for C, then embedded assembly
#define  FFMC_DATAW0S7L              0xDF1E

#define  FMC_DATAW1S0U               (*(vuint32_t *) (0xDF20)) // for C, then embedded assembly
#define  FFMC_DATAW1S0U              0xDF20

#define  FMC_DATAW1S0L               (*(vuint32_t *) (0xDF22)) // for C, then embedded assembly
#define  FFMC_DATAW1S0L              0xDF22

#define  FMC_DATAW1S1U               (*(vuint32_t *) (0xDF24)) // for C, then embedded assembly
#define  FFMC_DATAW1S1U              0xDF24

#define  FMC_DATAW1S1L               (*(vuint32_t *) (0xDF26)) // for C, then embedded assembly
#define  FFMC_DATAW1S1L              0xDF26

#define  FMC_DATAW1S2U               (*(vuint32_t *) (0xDF28)) // for C, then embedded assembly
#define  FFMC_DATAW1S2U              0xDF28

#define  FMC_DATAW1S2L               (*(vuint32_t *) (0xDF2A)) // for C, then embedded assembly
#define  FFMC_DATAW1S2L              0xDF2A

#define  FMC_DATAW1S3U               (*(vuint32_t *) (0xDF2C)) // for C, then embedded assembly
#define  FFMC_DATAW1S3U              0xDF2C

#define  FMC_DATAW1S3L               (*(vuint32_t *) (0xDF2E)) // for C, then embedded assembly
#define  FFMC_DATAW1S3L              0xDF2E

#define  FMC_DATAW1S4U               (*(vuint32_t *) (0xDF30)) // for C, then embedded assembly
#define  FFMC_DATAW1S4U              0xDF30

#define  FMC_DATAW1S4L               (*(vuint32_t *) (0xDF32)) // for C, then embedded assembly
#define  FFMC_DATAW1S4L              0xDF32

#define  FMC_DATAW1S5U               (*(vuint32_t *) (0xDF34)) // for C, then embedded assembly
#define  FFMC_DATAW1S5U              0xDF34

#define  FMC_DATAW1S5L               (*(vuint32_t *) (0xDF36)) // for C, then embedded assembly
#define  FFMC_DATAW1S5L              0xDF36

#define  FMC_DATAW1S6U               (*(vuint32_t *) (0xDF38)) // for C, then embedded assembly
#define  FFMC_DATAW1S6U              0xDF38

#define  FMC_DATAW1S6L               (*(vuint32_t *) (0xDF3A)) // for C, then embedded assembly
#define  FFMC_DATAW1S6L              0xDF3A

#define  FMC_DATAW1S7U               (*(vuint32_t *) (0xDF3C)) // for C, then embedded assembly
#define  FFMC_DATAW1S7U              0xDF3C

#define  FMC_DATAW1S7L               (*(vuint32_t *) (0xDF3E)) // for C, then embedded assembly
#define  FFMC_DATAW1S7L              0xDF3E

#define  FMC_DATAW2S0U               (*(vuint32_t *) (0xDF40)) // for C, then embedded assembly
#define  FFMC_DATAW2S0U              0xDF40

#define  FMC_DATAW2S0L               (*(vuint32_t *) (0xDF42)) // for C, then embedded assembly
#define  FFMC_DATAW2S0L              0xDF42

#define  FMC_DATAW2S1U               (*(vuint32_t *) (0xDF44)) // for C, then embedded assembly
#define  FFMC_DATAW2S1U              0xDF44

#define  FMC_DATAW2S1L               (*(vuint32_t *) (0xDF46)) // for C, then embedded assembly
#define  FFMC_DATAW2S1L              0xDF46

#define  FMC_DATAW2S2U               (*(vuint32_t *) (0xDF48)) // for C, then embedded assembly
#define  FFMC_DATAW2S2U              0xDF48

#define  FMC_DATAW2S2L               (*(vuint32_t *) (0xDF4A)) // for C, then embedded assembly
#define  FFMC_DATAW2S2L              0xDF4A

#define  FMC_DATAW2S3U               (*(vuint32_t *) (0xDF4C)) // for C, then embedded assembly
#define  FFMC_DATAW2S3U              0xDF4C

#define  FMC_DATAW2S3L               (*(vuint32_t *) (0xDF4E)) // for C, then embedded assembly
#define  FFMC_DATAW2S3L              0xDF4E

#define  FMC_DATAW2S4U               (*(vuint32_t *) (0xDF50)) // for C, then embedded assembly
#define  FFMC_DATAW2S4U              0xDF50

#define  FMC_DATAW2S4L               (*(vuint32_t *) (0xDF52)) // for C, then embedded assembly
#define  FFMC_DATAW2S4L              0xDF52

#define  FMC_DATAW2S5U               (*(vuint32_t *) (0xDF54)) // for C, then embedded assembly
#define  FFMC_DATAW2S5U              0xDF54

#define  FMC_DATAW2S5L               (*(vuint32_t *) (0xDF56)) // for C, then embedded assembly
#define  FFMC_DATAW2S5L              0xDF56

#define  FMC_DATAW2S6U               (*(vuint32_t *) (0xDF58)) // for C, then embedded assembly
#define  FFMC_DATAW2S6U              0xDF58

#define  FMC_DATAW2S6L               (*(vuint32_t *) (0xDF5A)) // for C, then embedded assembly
#define  FFMC_DATAW2S6L              0xDF5A

#define  FMC_DATAW2S7U               (*(vuint32_t *) (0xDF5C)) // for C, then embedded assembly
#define  FFMC_DATAW2S7U              0xDF5C

#define  FMC_DATAW2S7L               (*(vuint32_t *) (0xDF5E)) // for C, then embedded assembly
#define  FFMC_DATAW2S7L              0xDF5E

#define  FMC_DATAW3S0U               (*(vuint32_t *) (0xDF60)) // for C, then embedded assembly
#define  FFMC_DATAW3S0U              0xDF60

#define  FMC_DATAW3S0L               (*(vuint32_t *) (0xDF62)) // for C, then embedded assembly
#define  FFMC_DATAW3S0L              0xDF62

#define  FMC_DATAW3S1U               (*(vuint32_t *) (0xDF64)) // for C, then embedded assembly
#define  FFMC_DATAW3S1U              0xDF64

#define  FMC_DATAW3S1L               (*(vuint32_t *) (0xDF66)) // for C, then embedded assembly
#define  FFMC_DATAW3S1L              0xDF66

#define  FMC_DATAW3S2U               (*(vuint32_t *) (0xDF68)) // for C, then embedded assembly
#define  FFMC_DATAW3S2U              0xDF68

#define  FMC_DATAW3S2L               (*(vuint32_t *) (0xDF6A)) // for C, then embedded assembly
#define  FFMC_DATAW3S2L              0xDF6A

#define  FMC_DATAW3S3U               (*(vuint32_t *) (0xDF6C)) // for C, then embedded assembly
#define  FFMC_DATAW3S3U              0xDF6C

#define  FMC_DATAW3S3L               (*(vuint32_t *) (0xDF6E)) // for C, then embedded assembly
#define  FFMC_DATAW3S3L              0xDF6E

#define  FMC_DATAW3S4U               (*(vuint32_t *) (0xDF70)) // for C, then embedded assembly
#define  FFMC_DATAW3S4U              0xDF70

#define  FMC_DATAW3S4L               (*(vuint32_t *) (0xDF72)) // for C, then embedded assembly
#define  FFMC_DATAW3S4L              0xDF72

#define  FMC_DATAW3S5U               (*(vuint32_t *) (0xDF74)) // for C, then embedded assembly
#define  FFMC_DATAW3S5U              0xDF74

#define  FMC_DATAW3S5L               (*(vuint32_t *) (0xDF76)) // for C, then embedded assembly
#define  FFMC_DATAW3S5L              0xDF76

#define  FMC_DATAW3S6U               (*(vuint32_t *) (0xDF78)) // for C, then embedded assembly
#define  FFMC_DATAW3S6U              0xDF78

#define  FMC_DATAW3S6L               (*(vuint32_t *) (0xDF7A)) // for C, then embedded assembly
#define  FFMC_DATAW3S6L              0xDF7A

#define  FMC_DATAW3S7U               (*(vuint32_t *) (0xDF7C)) // for C, then embedded assembly
#define  FFMC_DATAW3S7U              0xDF7C

#define  FMC_DATAW3S7L               (*(vuint32_t *) (0xDF7E)) // for C, then embedded assembly
#define  FFMC_DATAW3S7L              0xDF7E

#define  FTFL_FSTAT                  (*(vuint8_t *) (0x1C780)) // for C, then embedded assembly
#define  FFTFL_FSTAT                 0x1C780

#define  FTFL_FCNFG                  (*(vuint8_t *) (0x1C781)) // for C, then embedded assembly
#define  FFTFL_FCNFG                 0x1C781

#define  FTFL_FSEC                   (*(vuint8_t *) (0x1C782)) // for C, then embedded assembly
#define  FFTFL_FSEC                  0x1C782

#define  FTFL_FOPT                   (*(vuint8_t *) (0x1C783)) // for C, then embedded assembly
#define  FFTFL_FOPT                  0x1C783

#define  FTFL_FCCOB3                 (*(vuint8_t *) (0x1C784)) // for C, then embedded assembly
#define  FFTFL_FCCOB3                0x1C784

#define  FTFL_FCCOB2                 (*(vuint8_t *) (0x1C785)) // for C, then embedded assembly
#define  FFTFL_FCCOB2                0x1C785

#define  FTFL_FCCOB1                 (*(vuint8_t *) (0x1C786)) // for C, then embedded assembly
#define  FFTFL_FCCOB1                0x1C786

#define  FTFL_FCCOB0                 (*(vuint8_t *) (0x1C787)) // for C, then embedded assembly
#define  FFTFL_FCCOB0                0x1C787

#define  FTFL_FCCOB7                 (*(vuint8_t *) (0x1C788)) // for C, then embedded assembly
#define  FFTFL_FCCOB7                0x1C788

#define  FTFL_FCCOB6                 (*(vuint8_t *) (0x1C789)) // for C, then embedded assembly
#define  FFTFL_FCCOB6                0x1C789

#define  FTFL_FCCOB5                 (*(vuint8_t *) (0x1C78A)) // for C, then embedded assembly
#define  FFTFL_FCCOB5                0x1C78A

#define  FTFL_FCCOB4                 (*(vuint8_t *) (0x1C78B)) // for C, then embedded assembly
#define  FFTFL_FCCOB4                0x1C78B

#define  FTFL_FCCOBB                 (*(vuint8_t *) (0x1C78C)) // for C, then embedded assembly
#define  FFTFL_FCCOBB                0x1C78C

#define  FTFL_FCCOBA                 (*(vuint8_t *) (0x1C78D)) // for C, then embedded assembly
#define  FFTFL_FCCOBA                0x1C78D

#define  FTFL_FCCOB9                 (*(vuint8_t *) (0x1C78E)) // for C, then embedded assembly
#define  FFTFL_FCCOB9                0x1C78E

#define  FTFL_FCCOB8                 (*(vuint8_t *) (0x1C78F)) // for C, then embedded assembly
#define  FFTFL_FCCOB8                0x1C78F

#define  FTFL_FPROT3                 (*(vuint8_t *) (0x1C790)) // for C, then embedded assembly
#define  FFTFL_FPROT3                0x1C790

#define  FTFL_FPROT2                 (*(vuint8_t *) (0x1C791)) // for C, then embedded assembly
#define  FFTFL_FPROT2                0x1C791

#define  FTFL_FPROT1                 (*(vuint8_t *) (0x1C792)) // for C, then embedded assembly
#define  FFTFL_FPROT1                0x1C792

#define  FTFL_FPROT0                 (*(vuint8_t *) (0x1C793)) // for C, then embedded assembly
#define  FFTFL_FPROT0                0x1C793

#define  FTFL_FEPROT                 (*(vuint8_t *) (0x1C796)) // for C, then embedded assembly
#define  FFTFL_FEPROT                0x1C796

#define  FTFL_FDPROT                 (*(vuint8_t *) (0x1C797)) // for C, then embedded assembly
#define  FFTFL_FDPROT                0x1C797

#define  GPIOA_PUR                   (*(vuint16_t *) (0xE200)) // for C, then embedded assembly
#define  FGPIOA_PUR                  0xE200

#define  GPIOA_DR                    (*(vuint16_t *) (0xE201)) // for C, then embedded assembly
#define  FGPIOA_DR                   0xE201

#define  GPIOA_DDR                   (*(vuint16_t *) (0xE202)) // for C, then embedded assembly
#define  FGPIOA_DDR                  0xE202

#define  GPIOA_PER                   (*(vuint16_t *) (0xE203)) // for C, then embedded assembly
#define  FGPIOA_PER                  0xE203

#define  GPIOA_IAR                   (*(vuint16_t *) (0xE204)) // for C, then embedded assembly
#define  FGPIOA_IAR                  0xE204

#define  GPIOA_IENR                  (*(vuint16_t *) (0xE205)) // for C, then embedded assembly
#define  FGPIOA_IENR                 0xE205

#define  GPIOA_IPOLR                 (*(vuint16_t *) (0xE206)) // for C, then embedded assembly
#define  FGPIOA_IPOLR                0xE206

#define  GPIOA_IPR                   (*(vuint16_t *) (0xE207)) // for C, then embedded assembly
#define  FGPIOA_IPR                  0xE207

#define  GPIOA_IESR                  (*(vuint16_t *) (0xE208)) // for C, then embedded assembly
#define  FGPIOA_IESR                 0xE208

#define  GPIOA_PPMODE                (*(vuint16_t *) (0xE209)) // for C, then embedded assembly
#define  FGPIOA_PPMODE               0xE209

#define  GPIOA_RAWDATA               (*(vuint16_t *) (0xE20A)) // for C, then embedded assembly
#define  FGPIOA_RAWDATA              0xE20A

#define  GPIOA_DRIVE                 (*(vuint16_t *) (0xE20B)) // for C, then embedded assembly
#define  FGPIOA_DRIVE                0xE20B

#define  GPIOA_PUS                   (*(vuint16_t *) (0xE20C)) // for C, then embedded assembly
#define  FGPIOA_PUS                  0xE20C

#define  GPIOA_SRE                   (*(vuint16_t *) (0xE20D)) // for C, then embedded assembly
#define  FGPIOA_SRE                  0xE20D

#define  GPIOB_PUR                   (*(vuint16_t *) (0xE210)) // for C, then embedded assembly
#define  FGPIOB_PUR                  0xE210

#define  GPIOB_DR                    (*(vuint16_t *) (0xE211)) // for C, then embedded assembly
#define  FGPIOB_DR                   0xE211

#define  GPIOB_DDR                   (*(vuint16_t *) (0xE212)) // for C, then embedded assembly
#define  FGPIOB_DDR                  0xE212

#define  GPIOB_PER                   (*(vuint16_t *) (0xE213)) // for C, then embedded assembly
#define  FGPIOB_PER                  0xE213

#define  GPIOB_IAR                   (*(vuint16_t *) (0xE214)) // for C, then embedded assembly
#define  FGPIOB_IAR                  0xE214

#define  GPIOB_IENR                  (*(vuint16_t *) (0xE215)) // for C, then embedded assembly
#define  FGPIOB_IENR                 0xE215

#define  GPIOB_IPOLR                 (*(vuint16_t *) (0xE216)) // for C, then embedded assembly
#define  FGPIOB_IPOLR                0xE216

#define  GPIOB_IPR                   (*(vuint16_t *) (0xE217)) // for C, then embedded assembly
#define  FGPIOB_IPR                  0xE217

#define  GPIOB_IESR                  (*(vuint16_t *) (0xE218)) // for C, then embedded assembly
#define  FGPIOB_IESR                 0xE218

#define  GPIOB_PPMODE                (*(vuint16_t *) (0xE219)) // for C, then embedded assembly
#define  FGPIOB_PPMODE               0xE219

#define  GPIOB_RAWDATA               (*(vuint16_t *) (0xE21A)) // for C, then embedded assembly
#define  FGPIOB_RAWDATA              0xE21A

#define  GPIOB_DRIVE                 (*(vuint16_t *) (0xE21B)) // for C, then embedded assembly
#define  FGPIOB_DRIVE                0xE21B

#define  GPIOB_PUS                   (*(vuint16_t *) (0xE21C)) // for C, then embedded assembly
#define  FGPIOB_PUS                  0xE21C

#define  GPIOB_SRE                   (*(vuint16_t *) (0xE21D)) // for C, then embedded assembly
#define  FGPIOB_SRE                  0xE21D

#define  GPIOC_PUR                   (*(vuint16_t *) (0xE220)) // for C, then embedded assembly
#define  FGPIOC_PUR                  0xE220

#define  GPIOC_DR                    (*(vuint16_t *) (0xE221)) // for C, then embedded assembly
#define  FGPIOC_DR                   0xE221

#define  GPIOC_DDR                   (*(vuint16_t *) (0xE222)) // for C, then embedded assembly
#define  FGPIOC_DDR                  0xE222

#define  GPIOC_PER                   (*(vuint16_t *) (0xE223)) // for C, then embedded assembly
#define  FGPIOC_PER                  0xE223

#define  GPIOC_IAR                   (*(vuint16_t *) (0xE224)) // for C, then embedded assembly
#define  FGPIOC_IAR                  0xE224

#define  GPIOC_IENR                  (*(vuint16_t *) (0xE225)) // for C, then embedded assembly
#define  FGPIOC_IENR                 0xE225

#define  GPIOC_IPOLR                 (*(vuint16_t *) (0xE226)) // for C, then embedded assembly
#define  FGPIOC_IPOLR                0xE226

#define  GPIOC_IPR                   (*(vuint16_t *) (0xE227)) // for C, then embedded assembly
#define  FGPIOC_IPR                  0xE227

#define  GPIOC_IESR                  (*(vuint16_t *) (0xE228)) // for C, then embedded assembly
#define  FGPIOC_IESR                 0xE228

#define  GPIOC_PPMODE                (*(vuint16_t *) (0xE229)) // for C, then embedded assembly
#define  FGPIOC_PPMODE               0xE229

#define  GPIOC_RAWDATA               (*(vuint16_t *) (0xE22A)) // for C, then embedded assembly
#define  FGPIOC_RAWDATA              0xE22A

#define  GPIOC_DRIVE                 (*(vuint16_t *) (0xE22B)) // for C, then embedded assembly
#define  FGPIOC_DRIVE                0xE22B

#define  GPIOC_PUS                   (*(vuint16_t *) (0xE22C)) // for C, then embedded assembly
#define  FGPIOC_PUS                  0xE22C

#define  GPIOC_SRE                   (*(vuint16_t *) (0xE22D)) // for C, then embedded assembly
#define  FGPIOC_SRE                  0xE22D

#define  GPIOD_PUR                   (*(vuint16_t *) (0xE230)) // for C, then embedded assembly
#define  FGPIOD_PUR                  0xE230

#define  GPIOD_DR                    (*(vuint16_t *) (0xE231)) // for C, then embedded assembly
#define  FGPIOD_DR                   0xE231

#define  GPIOD_DDR                   (*(vuint16_t *) (0xE232)) // for C, then embedded assembly
#define  FGPIOD_DDR                  0xE232

#define  GPIOD_PER                   (*(vuint16_t *) (0xE233)) // for C, then embedded assembly
#define  FGPIOD_PER                  0xE233

#define  GPIOD_IAR                   (*(vuint16_t *) (0xE234)) // for C, then embedded assembly
#define  FGPIOD_IAR                  0xE234

#define  GPIOD_IENR                  (*(vuint16_t *) (0xE235)) // for C, then embedded assembly
#define  FGPIOD_IENR                 0xE235

#define  GPIOD_IPOLR                 (*(vuint16_t *) (0xE236)) // for C, then embedded assembly
#define  FGPIOD_IPOLR                0xE236

#define  GPIOD_IPR                   (*(vuint16_t *) (0xE237)) // for C, then embedded assembly
#define  FGPIOD_IPR                  0xE237

#define  GPIOD_IESR                  (*(vuint16_t *) (0xE238)) // for C, then embedded assembly
#define  FGPIOD_IESR                 0xE238

#define  GPIOD_PPMODE                (*(vuint16_t *) (0xE239)) // for C, then embedded assembly
#define  FGPIOD_PPMODE               0xE239

#define  GPIOD_RAWDATA               (*(vuint16_t *) (0xE23A)) // for C, then embedded assembly
#define  FGPIOD_RAWDATA              0xE23A

#define  GPIOD_DRIVE                 (*(vuint16_t *) (0xE23B)) // for C, then embedded assembly
#define  FGPIOD_DRIVE                0xE23B

#define  GPIOD_PUS                   (*(vuint16_t *) (0xE23C)) // for C, then embedded assembly
#define  FGPIOD_PUS                  0xE23C

#define  GPIOD_SRE                   (*(vuint16_t *) (0xE23D)) // for C, then embedded assembly
#define  FGPIOD_SRE                  0xE23D

#define  GPIOE_PUR                   (*(vuint16_t *) (0xE240)) // for C, then embedded assembly
#define  FGPIOE_PUR                  0xE240

#define  GPIOE_DR                    (*(vuint16_t *) (0xE241)) // for C, then embedded assembly
#define  FGPIOE_DR                   0xE241

#define  GPIOE_DDR                   (*(vuint16_t *) (0xE242)) // for C, then embedded assembly
#define  FGPIOE_DDR                  0xE242

#define  GPIOE_PER                   (*(vuint16_t *) (0xE243)) // for C, then embedded assembly
#define  FGPIOE_PER                  0xE243

#define  GPIOE_IAR                   (*(vuint16_t *) (0xE244)) // for C, then embedded assembly
#define  FGPIOE_IAR                  0xE244

#define  GPIOE_IENR                  (*(vuint16_t *) (0xE245)) // for C, then embedded assembly
#define  FGPIOE_IENR                 0xE245

#define  GPIOE_IPOLR                 (*(vuint16_t *) (0xE246)) // for C, then embedded assembly
#define  FGPIOE_IPOLR                0xE246

#define  GPIOE_IPR                   (*(vuint16_t *) (0xE247)) // for C, then embedded assembly
#define  FGPIOE_IPR                  0xE247

#define  GPIOE_IESR                  (*(vuint16_t *) (0xE248)) // for C, then embedded assembly
#define  FGPIOE_IESR                 0xE248

#define  GPIOE_PPMODE                (*(vuint16_t *) (0xE249)) // for C, then embedded assembly
#define  FGPIOE_PPMODE               0xE249

#define  GPIOE_RAWDATA               (*(vuint16_t *) (0xE24A)) // for C, then embedded assembly
#define  FGPIOE_RAWDATA              0xE24A

#define  GPIOE_DRIVE                 (*(vuint16_t *) (0xE24B)) // for C, then embedded assembly
#define  FGPIOE_DRIVE                0xE24B

#define  GPIOE_PUS                   (*(vuint16_t *) (0xE24C)) // for C, then embedded assembly
#define  FGPIOE_PUS                  0xE24C

#define  GPIOE_SRE                   (*(vuint16_t *) (0xE24D)) // for C, then embedded assembly
#define  FGPIOE_SRE                  0xE24D

#define  GPIOF_PUR                   (*(vuint16_t *) (0xE250)) // for C, then embedded assembly
#define  FGPIOF_PUR                  0xE250

#define  GPIOF_DR                    (*(vuint16_t *) (0xE251)) // for C, then embedded assembly
#define  FGPIOF_DR                   0xE251

#define  GPIOF_DDR                   (*(vuint16_t *) (0xE252)) // for C, then embedded assembly
#define  FGPIOF_DDR                  0xE252

#define  GPIOF_PER                   (*(vuint16_t *) (0xE253)) // for C, then embedded assembly
#define  FGPIOF_PER                  0xE253

#define  GPIOF_IAR                   (*(vuint16_t *) (0xE254)) // for C, then embedded assembly
#define  FGPIOF_IAR                  0xE254

#define  GPIOF_IENR                  (*(vuint16_t *) (0xE255)) // for C, then embedded assembly
#define  FGPIOF_IENR                 0xE255

#define  GPIOF_IPOLR                 (*(vuint16_t *) (0xE256)) // for C, then embedded assembly
#define  FGPIOF_IPOLR                0xE256

#define  GPIOF_IPR                   (*(vuint16_t *) (0xE257)) // for C, then embedded assembly
#define  FGPIOF_IPR                  0xE257

#define  GPIOF_IESR                  (*(vuint16_t *) (0xE258)) // for C, then embedded assembly
#define  FGPIOF_IESR                 0xE258

#define  GPIOF_PPMODE                (*(vuint16_t *) (0xE259)) // for C, then embedded assembly
#define  FGPIOF_PPMODE               0xE259

#define  GPIOF_RAWDATA               (*(vuint16_t *) (0xE25A)) // for C, then embedded assembly
#define  FGPIOF_RAWDATA              0xE25A

#define  GPIOF_DRIVE                 (*(vuint16_t *) (0xE25B)) // for C, then embedded assembly
#define  FGPIOF_DRIVE                0xE25B

#define  GPIOF_PUS                   (*(vuint16_t *) (0xE25C)) // for C, then embedded assembly
#define  FGPIOF_PUS                  0xE25C

#define  GPIOF_SRE                   (*(vuint16_t *) (0xE25D)) // for C, then embedded assembly
#define  FGPIOF_SRE                  0xE25D

#define  GPIOG_PUR                   (*(vuint16_t *) (0xE260)) // for C, then embedded assembly
#define  FGPIOG_PUR                  0xE260

#define  GPIOG_DR                    (*(vuint16_t *) (0xE261)) // for C, then embedded assembly
#define  FGPIOG_DR                   0xE261

#define  GPIOG_DDR                   (*(vuint16_t *) (0xE262)) // for C, then embedded assembly
#define  FGPIOG_DDR                  0xE262

#define  GPIOG_PER                   (*(vuint16_t *) (0xE263)) // for C, then embedded assembly
#define  FGPIOG_PER                  0xE263

#define  GPIOG_IAR                   (*(vuint16_t *) (0xE264)) // for C, then embedded assembly
#define  FGPIOG_IAR                  0xE264

#define  GPIOG_IENR                  (*(vuint16_t *) (0xE265)) // for C, then embedded assembly
#define  FGPIOG_IENR                 0xE265

#define  GPIOG_IPOLR                 (*(vuint16_t *) (0xE266)) // for C, then embedded assembly
#define  FGPIOG_IPOLR                0xE266

#define  GPIOG_IPR                   (*(vuint16_t *) (0xE267)) // for C, then embedded assembly
#define  FGPIOG_IPR                  0xE267

#define  GPIOG_IESR                  (*(vuint16_t *) (0xE268)) // for C, then embedded assembly
#define  FGPIOG_IESR                 0xE268

#define  GPIOG_PPMODE                (*(vuint16_t *) (0xE269)) // for C, then embedded assembly
#define  FGPIOG_PPMODE               0xE269

#define  GPIOG_RAWDATA               (*(vuint16_t *) (0xE26A)) // for C, then embedded assembly
#define  FGPIOG_RAWDATA              0xE26A

#define  GPIOG_DRIVE                 (*(vuint16_t *) (0xE26B)) // for C, then embedded assembly
#define  FGPIOG_DRIVE                0xE26B

#define  GPIOG_PUS                   (*(vuint16_t *) (0xE26C)) // for C, then embedded assembly
#define  FGPIOG_PUS                  0xE26C

#define  GPIOG_SRE                   (*(vuint16_t *) (0xE26D)) // for C, then embedded assembly
#define  FGPIOG_SRE                  0xE26D

#define  I2C0_A1                     (*(vuint16_t *) (0xE0E0)) // for C, then embedded assembly
#define  FI2C0_A1                    0xE0E0

#define  I2C0_F                      (*(vuint16_t *) (0xE0E1)) // for C, then embedded assembly
#define  FI2C0_F                     0xE0E1

#define  I2C0_C1                     (*(vuint16_t *) (0xE0E2)) // for C, then embedded assembly
#define  FI2C0_C1                    0xE0E2

#define  I2C0_S                      (*(vuint16_t *) (0xE0E3)) // for C, then embedded assembly
#define  FI2C0_S                     0xE0E3

#define  I2C0_D                      (*(vuint16_t *) (0xE0E4)) // for C, then embedded assembly
#define  FI2C0_D                     0xE0E4

#define  I2C0_C2                     (*(vuint16_t *) (0xE0E5)) // for C, then embedded assembly
#define  FI2C0_C2                    0xE0E5

#define  I2C0_FLT                    (*(vuint16_t *) (0xE0E6)) // for C, then embedded assembly
#define  FI2C0_FLT                   0xE0E6

#define  I2C0_RA                     (*(vuint16_t *) (0xE0E7)) // for C, then embedded assembly
#define  FI2C0_RA                    0xE0E7

#define  I2C0_SMB                    (*(vuint16_t *) (0xE0E8)) // for C, then embedded assembly
#define  FI2C0_SMB                   0xE0E8

#define  I2C0_A2                     (*(vuint16_t *) (0xE0E9)) // for C, then embedded assembly
#define  FI2C0_A2                    0xE0E9

#define  I2C0_SLTH                   (*(vuint16_t *) (0xE0EA)) // for C, then embedded assembly
#define  FI2C0_SLTH                  0xE0EA

#define  I2C0_SLTL                   (*(vuint16_t *) (0xE0EB)) // for C, then embedded assembly
#define  FI2C0_SLTL                  0xE0EB

#define  I2C1_A1                     (*(vuint16_t *) (0xE0F0)) // for C, then embedded assembly
#define  FI2C1_A1                    0xE0F0

#define  I2C1_F                      (*(vuint16_t *) (0xE0F1)) // for C, then embedded assembly
#define  FI2C1_F                     0xE0F1

#define  I2C1_C1                     (*(vuint16_t *) (0xE0F2)) // for C, then embedded assembly
#define  FI2C1_C1                    0xE0F2

#define  I2C1_S                      (*(vuint16_t *) (0xE0F3)) // for C, then embedded assembly
#define  FI2C1_S                     0xE0F3

#define  I2C1_D                      (*(vuint16_t *) (0xE0F4)) // for C, then embedded assembly
#define  FI2C1_D                     0xE0F4

#define  I2C1_C2                     (*(vuint16_t *) (0xE0F5)) // for C, then embedded assembly
#define  FI2C1_C2                    0xE0F5

#define  I2C1_FLT                    (*(vuint16_t *) (0xE0F6)) // for C, then embedded assembly
#define  FI2C1_FLT                   0xE0F6

#define  I2C1_RA                     (*(vuint16_t *) (0xE0F7)) // for C, then embedded assembly
#define  FI2C1_RA                    0xE0F7

#define  I2C1_SMB                    (*(vuint16_t *) (0xE0F8)) // for C, then embedded assembly
#define  FI2C1_SMB                   0xE0F8

#define  I2C1_A2                     (*(vuint16_t *) (0xE0F9)) // for C, then embedded assembly
#define  FI2C1_A2                    0xE0F9

#define  I2C1_SLTH                   (*(vuint16_t *) (0xE0FA)) // for C, then embedded assembly
#define  FI2C1_SLTH                  0xE0FA

#define  I2C1_SLTL                   (*(vuint16_t *) (0xE0FB)) // for C, then embedded assembly
#define  FI2C1_SLTL                  0xE0FB

#define  INTC_IPR0                   (*(vuint16_t *) (0xE300)) // for C, then embedded assembly
#define  FINTC_IPR0                  0xE300

#define  INTC_IPR1                   (*(vuint16_t *) (0xE301)) // for C, then embedded assembly
#define  FINTC_IPR1                  0xE301

#define  INTC_IPR2                   (*(vuint16_t *) (0xE302)) // for C, then embedded assembly
#define  FINTC_IPR2                  0xE302

#define  INTC_IPR3                   (*(vuint16_t *) (0xE303)) // for C, then embedded assembly
#define  FINTC_IPR3                  0xE303

#define  INTC_IPR4                   (*(vuint16_t *) (0xE304)) // for C, then embedded assembly
#define  FINTC_IPR4                  0xE304

#define  INTC_IPR5                   (*(vuint16_t *) (0xE305)) // for C, then embedded assembly
#define  FINTC_IPR5                  0xE305

#define  INTC_IPR6                   (*(vuint16_t *) (0xE306)) // for C, then embedded assembly
#define  FINTC_IPR6                  0xE306

#define  INTC_IPR7                   (*(vuint16_t *) (0xE307)) // for C, then embedded assembly
#define  FINTC_IPR7                  0xE307

#define  INTC_IPR8                   (*(vuint16_t *) (0xE308)) // for C, then embedded assembly
#define  FINTC_IPR8                  0xE308

#define  INTC_IPR9                   (*(vuint16_t *) (0xE309)) // for C, then embedded assembly
#define  FINTC_IPR9                  0xE309

#define  INTC_IPR10                  (*(vuint16_t *) (0xE30A)) // for C, then embedded assembly
#define  FINTC_IPR10                 0xE30A

#define  INTC_IPR11                  (*(vuint16_t *) (0xE30B)) // for C, then embedded assembly
#define  FINTC_IPR11                 0xE30B

#define  INTC_IPR12                  (*(vuint16_t *) (0xE30C)) // for C, then embedded assembly
#define  FINTC_IPR12                 0xE30C

#define  INTC_VBA                    (*(vuint16_t *) (0xE30D)) // for C, then embedded assembly
#define  FINTC_VBA                   0xE30D

#define  INTC_FIM0                   (*(vuint16_t *) (0xE30E)) // for C, then embedded assembly
#define  FINTC_FIM0                  0xE30E

#define  INTC_FIVAL0                 (*(vuint16_t *) (0xE30F)) // for C, then embedded assembly
#define  FINTC_FIVAL0                0xE30F

#define  INTC_FIVAH0                 (*(vuint16_t *) (0xE310)) // for C, then embedded assembly
#define  FINTC_FIVAH0                0xE310

#define  INTC_FIM1                   (*(vuint16_t *) (0xE311)) // for C, then embedded assembly
#define  FINTC_FIM1                  0xE311

#define  INTC_FIVAL1                 (*(vuint16_t *) (0xE312)) // for C, then embedded assembly
#define  FINTC_FIVAL1                0xE312

#define  INTC_FIVAH1                 (*(vuint16_t *) (0xE313)) // for C, then embedded assembly
#define  FINTC_FIVAH1                0xE313

#define  INTC_IRQP0                  (*(vuint16_t *) (0xE314)) // for C, then embedded assembly
#define  FINTC_IRQP0                 0xE314

#define  INTC_IRQP1                  (*(vuint16_t *) (0xE315)) // for C, then embedded assembly
#define  FINTC_IRQP1                 0xE315

#define  INTC_IRQP2                  (*(vuint16_t *) (0xE316)) // for C, then embedded assembly
#define  FINTC_IRQP2                 0xE316

#define  INTC_IRQP3                  (*(vuint16_t *) (0xE317)) // for C, then embedded assembly
#define  FINTC_IRQP3                 0xE317

#define  INTC_IRQP4                  (*(vuint16_t *) (0xE318)) // for C, then embedded assembly
#define  FINTC_IRQP4                 0xE318

#define  INTC_IRQP5                  (*(vuint16_t *) (0xE319)) // for C, then embedded assembly
#define  FINTC_IRQP5                 0xE319

#define  INTC_IRQP6                  (*(vuint16_t *) (0xE31A)) // for C, then embedded assembly
#define  FINTC_IRQP6                 0xE31A

#define  INTC_CTRL                   (*(vuint16_t *) (0xE31B)) // for C, then embedded assembly
#define  FINTC_CTRL                  0xE31B

#define  MCM_PLASC                   (*(vuint16_t *) (0xC004)) // for C, then embedded assembly
#define  FMCM_PLASC                  0x18008

#define  MCM_PLAMC                   (*(vuint16_t *) (0xC005)) // for C, then embedded assembly
#define  FMCM_PLAMC                  0x1800A

#define  MCM_CPCR                    (*(vuint32_t *) (0xC006)) // for C, then embedded assembly
#define  FMCM_CPCR                   0x1800C

#define  MCM_CFADR                   (*(vuint32_t *) (0xC008)) // for C, then embedded assembly
#define  FMCM_CFADR                  0x18010

#define  MCM_CFATR                   (*(vuint8_t *) (0x18014)) // for C, then embedded assembly
#define  FMCM_CFATR                  0x18014

#define  MCM_CFLOC                   (*(vuint8_t *) (0x18015)) // for C, then embedded assembly
#define  FMCM_CFLOC                  0x18015

#define  MCM_CFIER                   (*(vuint8_t *) (0x18016)) // for C, then embedded assembly
#define  FMCM_CFIER                  0x18016

#define  MCM_CFISR                   (*(vuint8_t *) (0x18017)) // for C, then embedded assembly
#define  FMCM_CFISR                  0x18017

#define  MCM_CFDTR                   (*(vuint32_t *) (0xC00C)) // for C, then embedded assembly
#define  FMCM_CFDTR                  0x18018

#define  MCM_RPCR                    (*(vuint32_t *) (0xC010)) // for C, then embedded assembly
#define  FMCM_RPCR                   0x18020

#define  MCM_UFLASHBAR               (*(vuint32_t *) (0xC012)) // for C, then embedded assembly
#define  FMCM_UFLASHBAR              0x18024

#define  MCM_UPRAMBAR                (*(vuint32_t *) (0xC014)) // for C, then embedded assembly
#define  FMCM_UPRAMBAR               0x18028

#define  MCM_SRPOSP                  (*(vuint32_t *) (0xC018)) // for C, then embedded assembly
#define  FMCM_SRPOSP                 0x18030

#define  MCM_SRPIPC                  (*(vuint32_t *) (0xC01A)) // for C, then embedded assembly
#define  FMCM_SRPIPC                 0x18034

#define  MCM_SRPMPC                  (*(vuint32_t *) (0xC01C)) // for C, then embedded assembly
#define  FMCM_SRPMPC                 0x18038

#define  OCCS_CTRL                   (*(vuint16_t *) (0xE2B0)) // for C, then embedded assembly
#define  FOCCS_CTRL                  0xE2B0

#define  OCCS_DIVBY                  (*(vuint16_t *) (0xE2B1)) // for C, then embedded assembly
#define  FOCCS_DIVBY                 0xE2B1

#define  OCCS_STAT                   (*(vuint16_t *) (0xE2B2)) // for C, then embedded assembly
#define  FOCCS_STAT                  0xE2B2

#define  OCCS_OSCTL1                 (*(vuint16_t *) (0xE2B4)) // for C, then embedded assembly
#define  FOCCS_OSCTL1                0xE2B4

#define  OCCS_OSCTL2                 (*(vuint16_t *) (0xE2B5)) // for C, then embedded assembly
#define  FOCCS_OSCTL2                0xE2B5

#define  OCCS_CLKCHKR                (*(vuint16_t *) (0xE2B6)) // for C, then embedded assembly
#define  FOCCS_CLKCHKR               0xE2B6

#define  OCCS_CLKCHKT                (*(vuint16_t *) (0xE2B7)) // for C, then embedded assembly
#define  FOCCS_CLKCHKT               0xE2B7

#define  OCCS_PROT                   (*(vuint16_t *) (0xE2B8)) // for C, then embedded assembly
#define  FOCCS_PROT                  0xE2B8

#define  PDB0_MCTRL                  (*(vuint16_t *) (0xE120)) // for C, then embedded assembly
#define  FPDB0_MCTRL                 0xE120

#define  PDB0_CTRLA                  (*(vuint16_t *) (0xE121)) // for C, then embedded assembly
#define  FPDB0_CTRLA                 0xE121

#define  PDB0_CTRLC                  (*(vuint16_t *) (0xE122)) // for C, then embedded assembly
#define  FPDB0_CTRLC                 0xE122

#define  PDB0_DELAYA                 (*(vuint16_t *) (0xE123)) // for C, then embedded assembly
#define  FPDB0_DELAYA                0xE123

#define  PDB0_DELAYB                 (*(vuint16_t *) (0xE124)) // for C, then embedded assembly
#define  FPDB0_DELAYB                0xE124

#define  PDB0_DELAYC                 (*(vuint16_t *) (0xE125)) // for C, then embedded assembly
#define  FPDB0_DELAYC                0xE125

#define  PDB0_DELAYD                 (*(vuint16_t *) (0xE126)) // for C, then embedded assembly
#define  FPDB0_DELAYD                0xE126

#define  PDB0_MOD                    (*(vuint16_t *) (0xE127)) // for C, then embedded assembly
#define  FPDB0_MOD                   0xE127

#define  PDB0_CNTR                   (*(vuint16_t *) (0xE128)) // for C, then embedded assembly
#define  FPDB0_CNTR                  0xE128

#define  PDB1_MCTRL                  (*(vuint16_t *) (0xE130)) // for C, then embedded assembly
#define  FPDB1_MCTRL                 0xE130

#define  PDB1_CTRLA                  (*(vuint16_t *) (0xE131)) // for C, then embedded assembly
#define  FPDB1_CTRLA                 0xE131

#define  PDB1_CTRLC                  (*(vuint16_t *) (0xE132)) // for C, then embedded assembly
#define  FPDB1_CTRLC                 0xE132

#define  PDB1_DELAYA                 (*(vuint16_t *) (0xE133)) // for C, then embedded assembly
#define  FPDB1_DELAYA                0xE133

#define  PDB1_DELAYB                 (*(vuint16_t *) (0xE134)) // for C, then embedded assembly
#define  FPDB1_DELAYB                0xE134

#define  PDB1_DELAYC                 (*(vuint16_t *) (0xE135)) // for C, then embedded assembly
#define  FPDB1_DELAYC                0xE135

#define  PDB1_DELAYD                 (*(vuint16_t *) (0xE136)) // for C, then embedded assembly
#define  FPDB1_DELAYD                0xE136

#define  PDB1_MOD                    (*(vuint16_t *) (0xE137)) // for C, then embedded assembly
#define  FPDB1_MOD                   0xE137

#define  PDB1_CNTR                   (*(vuint16_t *) (0xE138)) // for C, then embedded assembly
#define  FPDB1_CNTR                  0xE138

#define  PIT0_CTRL                   (*(vuint16_t *) (0xE100)) // for C, then embedded assembly
#define  FPIT0_CTRL                  0xE100

#define  PIT0_MOD                    (*(vuint16_t *) (0xE101)) // for C, then embedded assembly
#define  FPIT0_MOD                   0xE101

#define  PIT0_CNTR                   (*(vuint16_t *) (0xE102)) // for C, then embedded assembly
#define  FPIT0_CNTR                  0xE102

#define  PIT1_CTRL                   (*(vuint16_t *) (0xE110)) // for C, then embedded assembly
#define  FPIT1_CTRL                  0xE110

#define  PIT1_MOD                    (*(vuint16_t *) (0xE111)) // for C, then embedded assembly
#define  FPIT1_MOD                   0xE111

#define  PIT1_CNTR                   (*(vuint16_t *) (0xE112)) // for C, then embedded assembly
#define  FPIT1_CNTR                  0xE112

#define  PMC_CTRL                    (*(vuint16_t *) (0xE2A0)) // for C, then embedded assembly
#define  FPMC_CTRL                   0xE2A0

#define  PMC_STS                     (*(vuint16_t *) (0xE2A1)) // for C, then embedded assembly
#define  FPMC_STS                    0xE2A1

#define  PWMA_SM0CNT                 (*(vuint16_t *) (0xE600)) // for C, then embedded assembly
#define  FPWMA_SM0CNT                0xE600

#define  PWMA_SM0INIT                (*(vuint16_t *) (0xE601)) // for C, then embedded assembly
#define  FPWMA_SM0INIT               0xE601

#define  PWMA_SM0CTRL2               (*(vuint16_t *) (0xE602)) // for C, then embedded assembly
#define  FPWMA_SM0CTRL2              0xE602

#define  PWMA_SM0CTRL                (*(vuint16_t *) (0xE603)) // for C, then embedded assembly
#define  FPWMA_SM0CTRL               0xE603

#define  PWMA_SM0VAL0                (*(vuint16_t *) (0xE605)) // for C, then embedded assembly
#define  FPWMA_SM0VAL0               0xE605

#define  PWMA_SM0FRACVAL1            (*(vuint16_t *) (0xE606)) // for C, then embedded assembly
#define  FPWMA_SM0FRACVAL1           0xE606

#define  PWMA_SM0VAL1                (*(vuint16_t *) (0xE607)) // for C, then embedded assembly
#define  FPWMA_SM0VAL1               0xE607

#define  PWMA_SM0FRACVAL2            (*(vuint16_t *) (0xE608)) // for C, then embedded assembly
#define  FPWMA_SM0FRACVAL2           0xE608

#define  PWMA_SM0VAL2                (*(vuint16_t *) (0xE609)) // for C, then embedded assembly
#define  FPWMA_SM0VAL2               0xE609

#define  PWMA_SM0FRACVAL3            (*(vuint16_t *) (0xE60A)) // for C, then embedded assembly
#define  FPWMA_SM0FRACVAL3           0xE60A

#define  PWMA_SM0VAL3                (*(vuint16_t *) (0xE60B)) // for C, then embedded assembly
#define  FPWMA_SM0VAL3               0xE60B

#define  PWMA_SM0FRACVAL4            (*(vuint16_t *) (0xE60C)) // for C, then embedded assembly
#define  FPWMA_SM0FRACVAL4           0xE60C

#define  PWMA_SM0VAL4                (*(vuint16_t *) (0xE60D)) // for C, then embedded assembly
#define  FPWMA_SM0VAL4               0xE60D

#define  PWMA_SM0FRACVAL5            (*(vuint16_t *) (0xE60E)) // for C, then embedded assembly
#define  FPWMA_SM0FRACVAL5           0xE60E

#define  PWMA_SM0VAL5                (*(vuint16_t *) (0xE60F)) // for C, then embedded assembly
#define  FPWMA_SM0VAL5               0xE60F

#define  PWMA_SM0FRCTRL              (*(vuint16_t *) (0xE610)) // for C, then embedded assembly
#define  FPWMA_SM0FRCTRL             0xE610

#define  PWMA_SM0OCTRL               (*(vuint16_t *) (0xE611)) // for C, then embedded assembly
#define  FPWMA_SM0OCTRL              0xE611

#define  PWMA_SM0STS                 (*(vuint16_t *) (0xE612)) // for C, then embedded assembly
#define  FPWMA_SM0STS                0xE612

#define  PWMA_SM0INTEN               (*(vuint16_t *) (0xE613)) // for C, then embedded assembly
#define  FPWMA_SM0INTEN              0xE613

#define  PWMA_SM0DMAEN               (*(vuint16_t *) (0xE614)) // for C, then embedded assembly
#define  FPWMA_SM0DMAEN              0xE614

#define  PWMA_SM0TCTRL               (*(vuint16_t *) (0xE615)) // for C, then embedded assembly
#define  FPWMA_SM0TCTRL              0xE615

#define  PWMA_SM0DISMAP0             (*(vuint16_t *) (0xE616)) // for C, then embedded assembly
#define  FPWMA_SM0DISMAP0            0xE616

#define  PWMA_SM0DISMAP1             (*(vuint16_t *) (0xE617)) // for C, then embedded assembly
#define  FPWMA_SM0DISMAP1            0xE617

#define  PWMA_SM0DTCNT0              (*(vuint16_t *) (0xE618)) // for C, then embedded assembly
#define  FPWMA_SM0DTCNT0             0xE618

#define  PWMA_SM0DTCNT1              (*(vuint16_t *) (0xE619)) // for C, then embedded assembly
#define  FPWMA_SM0DTCNT1             0xE619

#define  PWMA_SM0CAPTCTRLA           (*(vuint16_t *) (0xE61A)) // for C, then embedded assembly
#define  FPWMA_SM0CAPTCTRLA          0xE61A

#define  PWMA_SM0CAPTCOMPA           (*(vuint16_t *) (0xE61B)) // for C, then embedded assembly
#define  FPWMA_SM0CAPTCOMPA          0xE61B

#define  PWMA_SM0CAPTCTRLB           (*(vuint16_t *) (0xE61C)) // for C, then embedded assembly
#define  FPWMA_SM0CAPTCTRLB          0xE61C

#define  PWMA_SM0CAPTCOMPB           (*(vuint16_t *) (0xE61D)) // for C, then embedded assembly
#define  FPWMA_SM0CAPTCOMPB          0xE61D

#define  PWMA_SM0CAPTCTRLX           (*(vuint16_t *) (0xE61E)) // for C, then embedded assembly
#define  FPWMA_SM0CAPTCTRLX          0xE61E

#define  PWMA_SM0CAPTCOMPX           (*(vuint16_t *) (0xE61F)) // for C, then embedded assembly
#define  FPWMA_SM0CAPTCOMPX          0xE61F

#define  PWMA_SM0CVAL0               (*(vuint16_t *) (0xE620)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL0              0xE620

#define  PWMA_SM0CVAL0CYC            (*(vuint16_t *) (0xE621)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL0CYC           0xE621

#define  PWMA_SM0CVAL1               (*(vuint16_t *) (0xE622)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL1              0xE622

#define  PWMA_SM0CVAL1CYC            (*(vuint16_t *) (0xE623)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL1CYC           0xE623

#define  PWMA_SM0CVAL2               (*(vuint16_t *) (0xE624)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL2              0xE624

#define  PWMA_SM0CVAL2CYC            (*(vuint16_t *) (0xE625)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL2CYC           0xE625

#define  PWMA_SM0CVAL3               (*(vuint16_t *) (0xE626)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL3              0xE626

#define  PWMA_SM0CVAL3CYC            (*(vuint16_t *) (0xE627)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL3CYC           0xE627

#define  PWMA_SM0CVAL4               (*(vuint16_t *) (0xE628)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL4              0xE628

#define  PWMA_SM0CVAL4CYC            (*(vuint16_t *) (0xE629)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL4CYC           0xE629

#define  PWMA_SM0CVAL5               (*(vuint16_t *) (0xE62A)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL5              0xE62A

#define  PWMA_SM0CVAL5CYC            (*(vuint16_t *) (0xE62B)) // for C, then embedded assembly
#define  FPWMA_SM0CVAL5CYC           0xE62B

#define  PWMA_SM1CNT                 (*(vuint16_t *) (0xE630)) // for C, then embedded assembly
#define  FPWMA_SM1CNT                0xE630

#define  PWMA_SM1INIT                (*(vuint16_t *) (0xE631)) // for C, then embedded assembly
#define  FPWMA_SM1INIT               0xE631

#define  PWMA_SM1CTRL2               (*(vuint16_t *) (0xE632)) // for C, then embedded assembly
#define  FPWMA_SM1CTRL2              0xE632

#define  PWMA_SM1CTRL                (*(vuint16_t *) (0xE633)) // for C, then embedded assembly
#define  FPWMA_SM1CTRL               0xE633

#define  PWMA_SM1VAL0                (*(vuint16_t *) (0xE635)) // for C, then embedded assembly
#define  FPWMA_SM1VAL0               0xE635

#define  PWMA_SM1FRACVAL1            (*(vuint16_t *) (0xE636)) // for C, then embedded assembly
#define  FPWMA_SM1FRACVAL1           0xE636

#define  PWMA_SM1VAL1                (*(vuint16_t *) (0xE637)) // for C, then embedded assembly
#define  FPWMA_SM1VAL1               0xE637

#define  PWMA_SM1FRACVAL2            (*(vuint16_t *) (0xE638)) // for C, then embedded assembly
#define  FPWMA_SM1FRACVAL2           0xE638

#define  PWMA_SM1VAL2                (*(vuint16_t *) (0xE639)) // for C, then embedded assembly
#define  FPWMA_SM1VAL2               0xE639

#define  PWMA_SM1FRACVAL3            (*(vuint16_t *) (0xE63A)) // for C, then embedded assembly
#define  FPWMA_SM1FRACVAL3           0xE63A

#define  PWMA_SM1VAL3                (*(vuint16_t *) (0xE63B)) // for C, then embedded assembly
#define  FPWMA_SM1VAL3               0xE63B

#define  PWMA_SM1FRACVAL4            (*(vuint16_t *) (0xE63C)) // for C, then embedded assembly
#define  FPWMA_SM1FRACVAL4           0xE63C

#define  PWMA_SM1VAL4                (*(vuint16_t *) (0xE63D)) // for C, then embedded assembly
#define  FPWMA_SM1VAL4               0xE63D

#define  PWMA_SM1FRACVAL5            (*(vuint16_t *) (0xE63E)) // for C, then embedded assembly
#define  FPWMA_SM1FRACVAL5           0xE63E

#define  PWMA_SM1VAL5                (*(vuint16_t *) (0xE63F)) // for C, then embedded assembly
#define  FPWMA_SM1VAL5               0xE63F

#define  PWMA_SM1FRCTRL              (*(vuint16_t *) (0xE640)) // for C, then embedded assembly
#define  FPWMA_SM1FRCTRL             0xE640

#define  PWMA_SM1OCTRL               (*(vuint16_t *) (0xE641)) // for C, then embedded assembly
#define  FPWMA_SM1OCTRL              0xE641

#define  PWMA_SM1STS                 (*(vuint16_t *) (0xE642)) // for C, then embedded assembly
#define  FPWMA_SM1STS                0xE642

#define  PWMA_SM1INTEN               (*(vuint16_t *) (0xE643)) // for C, then embedded assembly
#define  FPWMA_SM1INTEN              0xE643

#define  PWMA_SM1DMAEN               (*(vuint16_t *) (0xE644)) // for C, then embedded assembly
#define  FPWMA_SM1DMAEN              0xE644

#define  PWMA_SM1TCTRL               (*(vuint16_t *) (0xE645)) // for C, then embedded assembly
#define  FPWMA_SM1TCTRL              0xE645

#define  PWMA_SM1DISMAP0             (*(vuint16_t *) (0xE646)) // for C, then embedded assembly
#define  FPWMA_SM1DISMAP0            0xE646

#define  PWMA_SM1DISMAP1             (*(vuint16_t *) (0xE647)) // for C, then embedded assembly
#define  FPWMA_SM1DISMAP1            0xE647

#define  PWMA_SM1DTCNT0              (*(vuint16_t *) (0xE648)) // for C, then embedded assembly
#define  FPWMA_SM1DTCNT0             0xE648

#define  PWMA_SM1DTCNT1              (*(vuint16_t *) (0xE649)) // for C, then embedded assembly
#define  FPWMA_SM1DTCNT1             0xE649

#define  PWMA_SM1CAPTCTRLA           (*(vuint16_t *) (0xE64A)) // for C, then embedded assembly
#define  FPWMA_SM1CAPTCTRLA          0xE64A

#define  PWMA_SM1CAPTCOMPA           (*(vuint16_t *) (0xE64B)) // for C, then embedded assembly
#define  FPWMA_SM1CAPTCOMPA          0xE64B

#define  PWMA_SM1CAPTCTRLB           (*(vuint16_t *) (0xE64C)) // for C, then embedded assembly
#define  FPWMA_SM1CAPTCTRLB          0xE64C

#define  PWMA_SM1CAPTCOMPB           (*(vuint16_t *) (0xE64D)) // for C, then embedded assembly
#define  FPWMA_SM1CAPTCOMPB          0xE64D

#define  PWMA_SM1CAPTCTRLX           (*(vuint16_t *) (0xE64E)) // for C, then embedded assembly
#define  FPWMA_SM1CAPTCTRLX          0xE64E

#define  PWMA_SM1CAPTCOMPX           (*(vuint16_t *) (0xE64F)) // for C, then embedded assembly
#define  FPWMA_SM1CAPTCOMPX          0xE64F

#define  PWMA_SM1CVAL0               (*(vuint16_t *) (0xE650)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL0              0xE650

#define  PWMA_SM1CVAL0CYC            (*(vuint16_t *) (0xE651)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL0CYC           0xE651

#define  PWMA_SM1CVAL1               (*(vuint16_t *) (0xE652)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL1              0xE652

#define  PWMA_SM1CVAL1CYC            (*(vuint16_t *) (0xE653)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL1CYC           0xE653

#define  PWMA_SM1CVAL2               (*(vuint16_t *) (0xE654)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL2              0xE654

#define  PWMA_SM1CVAL2CYC            (*(vuint16_t *) (0xE655)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL2CYC           0xE655

#define  PWMA_SM1CVAL3               (*(vuint16_t *) (0xE656)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL3              0xE656

#define  PWMA_SM1CVAL3CYC            (*(vuint16_t *) (0xE657)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL3CYC           0xE657

#define  PWMA_SM1CVAL4               (*(vuint16_t *) (0xE658)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL4              0xE658

#define  PWMA_SM1CVAL4CYC            (*(vuint16_t *) (0xE659)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL4CYC           0xE659

#define  PWMA_SM1CVAL5               (*(vuint16_t *) (0xE65A)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL5              0xE65A

#define  PWMA_SM1CVAL5CYC            (*(vuint16_t *) (0xE65B)) // for C, then embedded assembly
#define  FPWMA_SM1CVAL5CYC           0xE65B

#define  PWMA_SM2CNT                 (*(vuint16_t *) (0xE660)) // for C, then embedded assembly
#define  FPWMA_SM2CNT                0xE660

#define  PWMA_SM2INIT                (*(vuint16_t *) (0xE661)) // for C, then embedded assembly
#define  FPWMA_SM2INIT               0xE661

#define  PWMA_SM2CTRL2               (*(vuint16_t *) (0xE662)) // for C, then embedded assembly
#define  FPWMA_SM2CTRL2              0xE662

#define  PWMA_SM2CTRL                (*(vuint16_t *) (0xE663)) // for C, then embedded assembly
#define  FPWMA_SM2CTRL               0xE663

#define  PWMA_SM2VAL0                (*(vuint16_t *) (0xE665)) // for C, then embedded assembly
#define  FPWMA_SM2VAL0               0xE665

#define  PWMA_SM2FRACVAL1            (*(vuint16_t *) (0xE666)) // for C, then embedded assembly
#define  FPWMA_SM2FRACVAL1           0xE666

#define  PWMA_SM2VAL1                (*(vuint16_t *) (0xE667)) // for C, then embedded assembly
#define  FPWMA_SM2VAL1               0xE667

#define  PWMA_SM2FRACVAL2            (*(vuint16_t *) (0xE668)) // for C, then embedded assembly
#define  FPWMA_SM2FRACVAL2           0xE668

#define  PWMA_SM2VAL2                (*(vuint16_t *) (0xE669)) // for C, then embedded assembly
#define  FPWMA_SM2VAL2               0xE669

#define  PWMA_SM2FRACVAL3            (*(vuint16_t *) (0xE66A)) // for C, then embedded assembly
#define  FPWMA_SM2FRACVAL3           0xE66A

#define  PWMA_SM2VAL3                (*(vuint16_t *) (0xE66B)) // for C, then embedded assembly
#define  FPWMA_SM2VAL3               0xE66B

#define  PWMA_SM2FRACVAL4            (*(vuint16_t *) (0xE66C)) // for C, then embedded assembly
#define  FPWMA_SM2FRACVAL4           0xE66C

#define  PWMA_SM2VAL4                (*(vuint16_t *) (0xE66D)) // for C, then embedded assembly
#define  FPWMA_SM2VAL4               0xE66D

#define  PWMA_SM2FRACVAL5            (*(vuint16_t *) (0xE66E)) // for C, then embedded assembly
#define  FPWMA_SM2FRACVAL5           0xE66E

#define  PWMA_SM2VAL5                (*(vuint16_t *) (0xE66F)) // for C, then embedded assembly
#define  FPWMA_SM2VAL5               0xE66F

#define  PWMA_SM2FRCTRL              (*(vuint16_t *) (0xE670)) // for C, then embedded assembly
#define  FPWMA_SM2FRCTRL             0xE670

#define  PWMA_SM2OCTRL               (*(vuint16_t *) (0xE671)) // for C, then embedded assembly
#define  FPWMA_SM2OCTRL              0xE671

#define  PWMA_SM2STS                 (*(vuint16_t *) (0xE672)) // for C, then embedded assembly
#define  FPWMA_SM2STS                0xE672

#define  PWMA_SM2INTEN               (*(vuint16_t *) (0xE673)) // for C, then embedded assembly
#define  FPWMA_SM2INTEN              0xE673

#define  PWMA_SM2DMAEN               (*(vuint16_t *) (0xE674)) // for C, then embedded assembly
#define  FPWMA_SM2DMAEN              0xE674

#define  PWMA_SM2TCTRL               (*(vuint16_t *) (0xE675)) // for C, then embedded assembly
#define  FPWMA_SM2TCTRL              0xE675

#define  PWMA_SM2DISMAP0             (*(vuint16_t *) (0xE676)) // for C, then embedded assembly
#define  FPWMA_SM2DISMAP0            0xE676

#define  PWMA_SM2DISMAP1             (*(vuint16_t *) (0xE677)) // for C, then embedded assembly
#define  FPWMA_SM2DISMAP1            0xE677

#define  PWMA_SM2DTCNT0              (*(vuint16_t *) (0xE678)) // for C, then embedded assembly
#define  FPWMA_SM2DTCNT0             0xE678

#define  PWMA_SM2DTCNT1              (*(vuint16_t *) (0xE679)) // for C, then embedded assembly
#define  FPWMA_SM2DTCNT1             0xE679

#define  PWMA_SM2CAPTCTRLA           (*(vuint16_t *) (0xE67A)) // for C, then embedded assembly
#define  FPWMA_SM2CAPTCTRLA          0xE67A

#define  PWMA_SM2CAPTCOMPA           (*(vuint16_t *) (0xE67B)) // for C, then embedded assembly
#define  FPWMA_SM2CAPTCOMPA          0xE67B

#define  PWMA_SM2CAPTCTRLB           (*(vuint16_t *) (0xE67C)) // for C, then embedded assembly
#define  FPWMA_SM2CAPTCTRLB          0xE67C

#define  PWMA_SM2CAPTCOMPB           (*(vuint16_t *) (0xE67D)) // for C, then embedded assembly
#define  FPWMA_SM2CAPTCOMPB          0xE67D

#define  PWMA_SM2CAPTCTRLX           (*(vuint16_t *) (0xE67E)) // for C, then embedded assembly
#define  FPWMA_SM2CAPTCTRLX          0xE67E

#define  PWMA_SM2CAPTCOMPX           (*(vuint16_t *) (0xE67F)) // for C, then embedded assembly
#define  FPWMA_SM2CAPTCOMPX          0xE67F

#define  PWMA_SM2CVAL0               (*(vuint16_t *) (0xE680)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL0              0xE680

#define  PWMA_SM2CVAL0CYC            (*(vuint16_t *) (0xE681)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL0CYC           0xE681

#define  PWMA_SM2CVAL1               (*(vuint16_t *) (0xE682)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL1              0xE682

#define  PWMA_SM2CVAL1CYC            (*(vuint16_t *) (0xE683)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL1CYC           0xE683

#define  PWMA_SM2CVAL2               (*(vuint16_t *) (0xE684)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL2              0xE684

#define  PWMA_SM2CVAL2CYC            (*(vuint16_t *) (0xE685)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL2CYC           0xE685

#define  PWMA_SM2CVAL3               (*(vuint16_t *) (0xE686)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL3              0xE686

#define  PWMA_SM2CVAL3CYC            (*(vuint16_t *) (0xE687)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL3CYC           0xE687

#define  PWMA_SM2CVAL4               (*(vuint16_t *) (0xE688)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL4              0xE688

#define  PWMA_SM2CVAL4CYC            (*(vuint16_t *) (0xE689)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL4CYC           0xE689

#define  PWMA_SM2CVAL5               (*(vuint16_t *) (0xE68A)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL5              0xE68A

#define  PWMA_SM2CVAL5CYC            (*(vuint16_t *) (0xE68B)) // for C, then embedded assembly
#define  FPWMA_SM2CVAL5CYC           0xE68B

#define  PWMA_SM3CNT                 (*(vuint16_t *) (0xE690)) // for C, then embedded assembly
#define  FPWMA_SM3CNT                0xE690

#define  PWMA_SM3INIT                (*(vuint16_t *) (0xE691)) // for C, then embedded assembly
#define  FPWMA_SM3INIT               0xE691

#define  PWMA_SM3CTRL2               (*(vuint16_t *) (0xE692)) // for C, then embedded assembly
#define  FPWMA_SM3CTRL2              0xE692

#define  PWMA_SM3CTRL                (*(vuint16_t *) (0xE693)) // for C, then embedded assembly
#define  FPWMA_SM3CTRL               0xE693

#define  PWMA_SM3VAL0                (*(vuint16_t *) (0xE695)) // for C, then embedded assembly
#define  FPWMA_SM3VAL0               0xE695

#define  PWMA_SM3FRACVAL1            (*(vuint16_t *) (0xE696)) // for C, then embedded assembly
#define  FPWMA_SM3FRACVAL1           0xE696

#define  PWMA_SM3VAL1                (*(vuint16_t *) (0xE697)) // for C, then embedded assembly
#define  FPWMA_SM3VAL1               0xE697

#define  PWMA_SM3FRACVAL2            (*(vuint16_t *) (0xE698)) // for C, then embedded assembly
#define  FPWMA_SM3FRACVAL2           0xE698

#define  PWMA_SM3VAL2                (*(vuint16_t *) (0xE699)) // for C, then embedded assembly
#define  FPWMA_SM3VAL2               0xE699

#define  PWMA_SM3FRACVAL3            (*(vuint16_t *) (0xE69A)) // for C, then embedded assembly
#define  FPWMA_SM3FRACVAL3           0xE69A

#define  PWMA_SM3VAL3                (*(vuint16_t *) (0xE69B)) // for C, then embedded assembly
#define  FPWMA_SM3VAL3               0xE69B

#define  PWMA_SM3FRACVAL4            (*(vuint16_t *) (0xE69C)) // for C, then embedded assembly
#define  FPWMA_SM3FRACVAL4           0xE69C

#define  PWMA_SM3VAL4                (*(vuint16_t *) (0xE69D)) // for C, then embedded assembly
#define  FPWMA_SM3VAL4               0xE69D

#define  PWMA_SM3FRACVAL5            (*(vuint16_t *) (0xE69E)) // for C, then embedded assembly
#define  FPWMA_SM3FRACVAL5           0xE69E

#define  PWMA_SM3VAL5                (*(vuint16_t *) (0xE69F)) // for C, then embedded assembly
#define  FPWMA_SM3VAL5               0xE69F

#define  PWMA_SM3FRCTRL              (*(vuint16_t *) (0xE6A0)) // for C, then embedded assembly
#define  FPWMA_SM3FRCTRL             0xE6A0

#define  PWMA_SM3OCTRL               (*(vuint16_t *) (0xE6A1)) // for C, then embedded assembly
#define  FPWMA_SM3OCTRL              0xE6A1

#define  PWMA_SM3STS                 (*(vuint16_t *) (0xE6A2)) // for C, then embedded assembly
#define  FPWMA_SM3STS                0xE6A2

#define  PWMA_SM3INTEN               (*(vuint16_t *) (0xE6A3)) // for C, then embedded assembly
#define  FPWMA_SM3INTEN              0xE6A3

#define  PWMA_SM3DMAEN               (*(vuint16_t *) (0xE6A4)) // for C, then embedded assembly
#define  FPWMA_SM3DMAEN              0xE6A4

#define  PWMA_SM3TCTRL               (*(vuint16_t *) (0xE6A5)) // for C, then embedded assembly
#define  FPWMA_SM3TCTRL              0xE6A5

#define  PWMA_SM3DISMAP0             (*(vuint16_t *) (0xE6A6)) // for C, then embedded assembly
#define  FPWMA_SM3DISMAP0            0xE6A6

#define  PWMA_SM3DISMAP1             (*(vuint16_t *) (0xE6A7)) // for C, then embedded assembly
#define  FPWMA_SM3DISMAP1            0xE6A7

#define  PWMA_SM3DTCNT0              (*(vuint16_t *) (0xE6A8)) // for C, then embedded assembly
#define  FPWMA_SM3DTCNT0             0xE6A8

#define  PWMA_SM3DTCNT1              (*(vuint16_t *) (0xE6A9)) // for C, then embedded assembly
#define  FPWMA_SM3DTCNT1             0xE6A9

#define  PWMA_SM3CAPTCTRLA           (*(vuint16_t *) (0xE6AA)) // for C, then embedded assembly
#define  FPWMA_SM3CAPTCTRLA          0xE6AA

#define  PWMA_SM3CAPTCOMPA           (*(vuint16_t *) (0xE6AB)) // for C, then embedded assembly
#define  FPWMA_SM3CAPTCOMPA          0xE6AB

#define  PWMA_SM3CAPTCTRLB           (*(vuint16_t *) (0xE6AC)) // for C, then embedded assembly
#define  FPWMA_SM3CAPTCTRLB          0xE6AC

#define  PWMA_SM3CAPTCOMPB           (*(vuint16_t *) (0xE6AD)) // for C, then embedded assembly
#define  FPWMA_SM3CAPTCOMPB          0xE6AD

#define  PWMA_SM3CAPTCTRLX           (*(vuint16_t *) (0xE6AE)) // for C, then embedded assembly
#define  FPWMA_SM3CAPTCTRLX          0xE6AE

#define  PWMA_SM3CAPTCOMPX           (*(vuint16_t *) (0xE6AF)) // for C, then embedded assembly
#define  FPWMA_SM3CAPTCOMPX          0xE6AF

#define  PWMA_SM3CVAL0               (*(vuint16_t *) (0xE6B0)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL0              0xE6B0

#define  PWMA_SM3CVAL0CYC            (*(vuint16_t *) (0xE6B1)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL0CYC           0xE6B1

#define  PWMA_SM3CVAL1               (*(vuint16_t *) (0xE6B2)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL1              0xE6B2

#define  PWMA_SM3CVAL1CYC            (*(vuint16_t *) (0xE6B3)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL1CYC           0xE6B3

#define  PWMA_SM3CVAL2               (*(vuint16_t *) (0xE6B4)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL2              0xE6B4

#define  PWMA_SM3CVAL2CYC            (*(vuint16_t *) (0xE6B5)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL2CYC           0xE6B5

#define  PWMA_SM3CVAL3               (*(vuint16_t *) (0xE6B6)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL3              0xE6B6

#define  PWMA_SM3CVAL3CYC            (*(vuint16_t *) (0xE6B7)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL3CYC           0xE6B7

#define  PWMA_SM3CVAL4               (*(vuint16_t *) (0xE6B8)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL4              0xE6B8

#define  PWMA_SM3CVAL4CYC            (*(vuint16_t *) (0xE6B9)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL4CYC           0xE6B9

#define  PWMA_SM3CVAL5               (*(vuint16_t *) (0xE6BA)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL5              0xE6BA

#define  PWMA_SM3CVAL5CYC            (*(vuint16_t *) (0xE6BB)) // for C, then embedded assembly
#define  FPWMA_SM3CVAL5CYC           0xE6BB

#define  PWMA_OUTEN                  (*(vuint16_t *) (0xE6C0)) // for C, then embedded assembly
#define  FPWMA_OUTEN                 0xE6C0

#define  PWMA_MASK                   (*(vuint16_t *) (0xE6C1)) // for C, then embedded assembly
#define  FPWMA_MASK                  0xE6C1

#define  PWMA_SWCOUT                 (*(vuint16_t *) (0xE6C2)) // for C, then embedded assembly
#define  FPWMA_SWCOUT                0xE6C2

#define  PWMA_DTSRCSEL               (*(vuint16_t *) (0xE6C3)) // for C, then embedded assembly
#define  FPWMA_DTSRCSEL              0xE6C3

#define  PWMA_MCTRL                  (*(vuint16_t *) (0xE6C4)) // for C, then embedded assembly
#define  FPWMA_MCTRL                 0xE6C4

#define  PWMA_MCTRL2                 (*(vuint16_t *) (0xE6C5)) // for C, then embedded assembly
#define  FPWMA_MCTRL2                0xE6C5

#define  PWMA_FCTRL0                 (*(vuint16_t *) (0xE6C6)) // for C, then embedded assembly
#define  FPWMA_FCTRL0                0xE6C6

#define  PWMA_FSTS0                  (*(vuint16_t *) (0xE6C7)) // for C, then embedded assembly
#define  FPWMA_FSTS0                 0xE6C7

#define  PWMA_FFILT0                 (*(vuint16_t *) (0xE6C8)) // for C, then embedded assembly
#define  FPWMA_FFILT0                0xE6C8

#define  PWMA_FTST0                  (*(vuint16_t *) (0xE6C9)) // for C, then embedded assembly
#define  FPWMA_FTST0                 0xE6C9

#define  PWMA_FCTRL1                 (*(vuint16_t *) (0xE6CA)) // for C, then embedded assembly
#define  FPWMA_FCTRL1                0xE6CA

#define  PWMA_FSTS1                  (*(vuint16_t *) (0xE6CB)) // for C, then embedded assembly
#define  FPWMA_FSTS1                 0xE6CB

#define  PWMA_FFILT1                 (*(vuint16_t *) (0xE6CC)) // for C, then embedded assembly
#define  FPWMA_FFILT1                0xE6CC

#define  PWMA_FTST1                  (*(vuint16_t *) (0xE6CD)) // for C, then embedded assembly
#define  FPWMA_FTST1                 0xE6CD

#define  PWMB_SM0CNT                 (*(vuint16_t *) (0xE700)) // for C, then embedded assembly
#define  FPWMB_SM0CNT                0xE700

#define  PWMB_SM0INIT                (*(vuint16_t *) (0xE701)) // for C, then embedded assembly
#define  FPWMB_SM0INIT               0xE701

#define  PWMB_SM0CTRL2               (*(vuint16_t *) (0xE702)) // for C, then embedded assembly
#define  FPWMB_SM0CTRL2              0xE702

#define  PWMB_SM0CTRL                (*(vuint16_t *) (0xE703)) // for C, then embedded assembly
#define  FPWMB_SM0CTRL               0xE703

#define  PWMB_SM0VAL0                (*(vuint16_t *) (0xE705)) // for C, then embedded assembly
#define  FPWMB_SM0VAL0               0xE705

#define  PWMB_SM0VAL1                (*(vuint16_t *) (0xE707)) // for C, then embedded assembly
#define  FPWMB_SM0VAL1               0xE707

#define  PWMB_SM0VAL2                (*(vuint16_t *) (0xE709)) // for C, then embedded assembly
#define  FPWMB_SM0VAL2               0xE709

#define  PWMB_SM0VAL3                (*(vuint16_t *) (0xE70B)) // for C, then embedded assembly
#define  FPWMB_SM0VAL3               0xE70B

#define  PWMB_SM0VAL4                (*(vuint16_t *) (0xE70D)) // for C, then embedded assembly
#define  FPWMB_SM0VAL4               0xE70D

#define  PWMB_SM0VAL5                (*(vuint16_t *) (0xE70F)) // for C, then embedded assembly
#define  FPWMB_SM0VAL5               0xE70F

#define  PWMB_SM0OCTRL               (*(vuint16_t *) (0xE711)) // for C, then embedded assembly
#define  FPWMB_SM0OCTRL              0xE711

#define  PWMB_SM0STS                 (*(vuint16_t *) (0xE712)) // for C, then embedded assembly
#define  FPWMB_SM0STS                0xE712

#define  PWMB_SM0INTEN               (*(vuint16_t *) (0xE713)) // for C, then embedded assembly
#define  FPWMB_SM0INTEN              0xE713

#define  PWMB_SM0DMAEN               (*(vuint16_t *) (0xE714)) // for C, then embedded assembly
#define  FPWMB_SM0DMAEN              0xE714

#define  PWMB_SM0TCTRL               (*(vuint16_t *) (0xE715)) // for C, then embedded assembly
#define  FPWMB_SM0TCTRL              0xE715

#define  PWMB_SM0DISMAP0             (*(vuint16_t *) (0xE716)) // for C, then embedded assembly
#define  FPWMB_SM0DISMAP0            0xE716

#define  PWMB_SM0DISMAP1             (*(vuint16_t *) (0xE717)) // for C, then embedded assembly
#define  FPWMB_SM0DISMAP1            0xE717

#define  PWMB_SM0DTCNT0              (*(vuint16_t *) (0xE718)) // for C, then embedded assembly
#define  FPWMB_SM0DTCNT0             0xE718

#define  PWMB_SM0DTCNT1              (*(vuint16_t *) (0xE719)) // for C, then embedded assembly
#define  FPWMB_SM0DTCNT1             0xE719

#define  PWMB_SM0CAPTCTRLA           (*(vuint16_t *) (0xE71A)) // for C, then embedded assembly
#define  FPWMB_SM0CAPTCTRLA          0xE71A

#define  PWMB_SM0CAPTCOMPA           (*(vuint16_t *) (0xE71B)) // for C, then embedded assembly
#define  FPWMB_SM0CAPTCOMPA          0xE71B

#define  PWMB_SM0CAPTCTRLB           (*(vuint16_t *) (0xE71C)) // for C, then embedded assembly
#define  FPWMB_SM0CAPTCTRLB          0xE71C

#define  PWMB_SM0CAPTCOMPB           (*(vuint16_t *) (0xE71D)) // for C, then embedded assembly
#define  FPWMB_SM0CAPTCOMPB          0xE71D

#define  PWMB_SM0CAPTCTRLX           (*(vuint16_t *) (0xE71E)) // for C, then embedded assembly
#define  FPWMB_SM0CAPTCTRLX          0xE71E

#define  PWMB_SM0CAPTCOMPX           (*(vuint16_t *) (0xE71F)) // for C, then embedded assembly
#define  FPWMB_SM0CAPTCOMPX          0xE71F

#define  PWMB_SM0CVAL0               (*(vuint16_t *) (0xE720)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL0              0xE720

#define  PWMB_SM0CVAL0CYC            (*(vuint16_t *) (0xE721)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL0CYC           0xE721

#define  PWMB_SM0CVAL1               (*(vuint16_t *) (0xE722)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL1              0xE722

#define  PWMB_SM0CVAL1CYC            (*(vuint16_t *) (0xE723)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL1CYC           0xE723

#define  PWMB_SM0CVAL2               (*(vuint16_t *) (0xE724)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL2              0xE724

#define  PWMB_SM0CVAL2CYC            (*(vuint16_t *) (0xE725)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL2CYC           0xE725

#define  PWMB_SM0CVAL3               (*(vuint16_t *) (0xE726)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL3              0xE726

#define  PWMB_SM0CVAL3CYC            (*(vuint16_t *) (0xE727)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL3CYC           0xE727

#define  PWMB_SM0CVAL4               (*(vuint16_t *) (0xE728)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL4              0xE728

#define  PWMB_SM0CVAL4CYC            (*(vuint16_t *) (0xE729)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL4CYC           0xE729

#define  PWMB_SM0CVAL5               (*(vuint16_t *) (0xE72A)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL5              0xE72A

#define  PWMB_SM0CVAL5CYC            (*(vuint16_t *) (0xE72B)) // for C, then embedded assembly
#define  FPWMB_SM0CVAL5CYC           0xE72B

#define  PWMB_SM1CNT                 (*(vuint16_t *) (0xE730)) // for C, then embedded assembly
#define  FPWMB_SM1CNT                0xE730

#define  PWMB_SM1INIT                (*(vuint16_t *) (0xE731)) // for C, then embedded assembly
#define  FPWMB_SM1INIT               0xE731

#define  PWMB_SM1CTRL2               (*(vuint16_t *) (0xE732)) // for C, then embedded assembly
#define  FPWMB_SM1CTRL2              0xE732

#define  PWMB_SM1CTRL                (*(vuint16_t *) (0xE733)) // for C, then embedded assembly
#define  FPWMB_SM1CTRL               0xE733

#define  PWMB_SM1VAL0                (*(vuint16_t *) (0xE735)) // for C, then embedded assembly
#define  FPWMB_SM1VAL0               0xE735

#define  PWMB_SM1VAL1                (*(vuint16_t *) (0xE737)) // for C, then embedded assembly
#define  FPWMB_SM1VAL1               0xE737

#define  PWMB_SM1VAL2                (*(vuint16_t *) (0xE739)) // for C, then embedded assembly
#define  FPWMB_SM1VAL2               0xE739

#define  PWMB_SM1VAL3                (*(vuint16_t *) (0xE73B)) // for C, then embedded assembly
#define  FPWMB_SM1VAL3               0xE73B

#define  PWMB_SM1VAL4                (*(vuint16_t *) (0xE73D)) // for C, then embedded assembly
#define  FPWMB_SM1VAL4               0xE73D

#define  PWMB_SM1VAL5                (*(vuint16_t *) (0xE73F)) // for C, then embedded assembly
#define  FPWMB_SM1VAL5               0xE73F

#define  PWMB_SM1OCTRL               (*(vuint16_t *) (0xE741)) // for C, then embedded assembly
#define  FPWMB_SM1OCTRL              0xE741

#define  PWMB_SM1STS                 (*(vuint16_t *) (0xE742)) // for C, then embedded assembly
#define  FPWMB_SM1STS                0xE742

#define  PWMB_SM1INTEN               (*(vuint16_t *) (0xE743)) // for C, then embedded assembly
#define  FPWMB_SM1INTEN              0xE743

#define  PWMB_SM1DMAEN               (*(vuint16_t *) (0xE744)) // for C, then embedded assembly
#define  FPWMB_SM1DMAEN              0xE744

#define  PWMB_SM1TCTRL               (*(vuint16_t *) (0xE745)) // for C, then embedded assembly
#define  FPWMB_SM1TCTRL              0xE745

#define  PWMB_SM1DISMAP0             (*(vuint16_t *) (0xE746)) // for C, then embedded assembly
#define  FPWMB_SM1DISMAP0            0xE746

#define  PWMB_SM1DISMAP1             (*(vuint16_t *) (0xE747)) // for C, then embedded assembly
#define  FPWMB_SM1DISMAP1            0xE747

#define  PWMB_SM1DTCNT0              (*(vuint16_t *) (0xE748)) // for C, then embedded assembly
#define  FPWMB_SM1DTCNT0             0xE748

#define  PWMB_SM1DTCNT1              (*(vuint16_t *) (0xE749)) // for C, then embedded assembly
#define  FPWMB_SM1DTCNT1             0xE749

#define  PWMB_SM1CAPTCTRLA           (*(vuint16_t *) (0xE74A)) // for C, then embedded assembly
#define  FPWMB_SM1CAPTCTRLA          0xE74A

#define  PWMB_SM1CAPTCOMPA           (*(vuint16_t *) (0xE74B)) // for C, then embedded assembly
#define  FPWMB_SM1CAPTCOMPA          0xE74B

#define  PWMB_SM1CAPTCTRLB           (*(vuint16_t *) (0xE74C)) // for C, then embedded assembly
#define  FPWMB_SM1CAPTCTRLB          0xE74C

#define  PWMB_SM1CAPTCOMPB           (*(vuint16_t *) (0xE74D)) // for C, then embedded assembly
#define  FPWMB_SM1CAPTCOMPB          0xE74D

#define  PWMB_SM1CAPTCTRLX           (*(vuint16_t *) (0xE74E)) // for C, then embedded assembly
#define  FPWMB_SM1CAPTCTRLX          0xE74E

#define  PWMB_SM1CAPTCOMPX           (*(vuint16_t *) (0xE74F)) // for C, then embedded assembly
#define  FPWMB_SM1CAPTCOMPX          0xE74F

#define  PWMB_SM1CVAL0               (*(vuint16_t *) (0xE750)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL0              0xE750

#define  PWMB_SM1CVAL0CYC            (*(vuint16_t *) (0xE751)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL0CYC           0xE751

#define  PWMB_SM1CVAL1               (*(vuint16_t *) (0xE752)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL1              0xE752

#define  PWMB_SM1CVAL1CYC            (*(vuint16_t *) (0xE753)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL1CYC           0xE753

#define  PWMB_SM1CVAL2               (*(vuint16_t *) (0xE754)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL2              0xE754

#define  PWMB_SM1CVAL2CYC            (*(vuint16_t *) (0xE755)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL2CYC           0xE755

#define  PWMB_SM1CVAL3               (*(vuint16_t *) (0xE756)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL3              0xE756

#define  PWMB_SM1CVAL3CYC            (*(vuint16_t *) (0xE757)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL3CYC           0xE757

#define  PWMB_SM1CVAL4               (*(vuint16_t *) (0xE758)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL4              0xE758

#define  PWMB_SM1CVAL4CYC            (*(vuint16_t *) (0xE759)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL4CYC           0xE759

#define  PWMB_SM1CVAL5               (*(vuint16_t *) (0xE75A)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL5              0xE75A

#define  PWMB_SM1CVAL5CYC            (*(vuint16_t *) (0xE75B)) // for C, then embedded assembly
#define  FPWMB_SM1CVAL5CYC           0xE75B

#define  PWMB_SM2CNT                 (*(vuint16_t *) (0xE760)) // for C, then embedded assembly
#define  FPWMB_SM2CNT                0xE760

#define  PWMB_SM2INIT                (*(vuint16_t *) (0xE761)) // for C, then embedded assembly
#define  FPWMB_SM2INIT               0xE761

#define  PWMB_SM2CTRL2               (*(vuint16_t *) (0xE762)) // for C, then embedded assembly
#define  FPWMB_SM2CTRL2              0xE762

#define  PWMB_SM2CTRL                (*(vuint16_t *) (0xE763)) // for C, then embedded assembly
#define  FPWMB_SM2CTRL               0xE763

#define  PWMB_SM2VAL0                (*(vuint16_t *) (0xE765)) // for C, then embedded assembly
#define  FPWMB_SM2VAL0               0xE765

#define  PWMB_SM2VAL1                (*(vuint16_t *) (0xE767)) // for C, then embedded assembly
#define  FPWMB_SM2VAL1               0xE767

#define  PWMB_SM2VAL2                (*(vuint16_t *) (0xE769)) // for C, then embedded assembly
#define  FPWMB_SM2VAL2               0xE769

#define  PWMB_SM2VAL3                (*(vuint16_t *) (0xE76B)) // for C, then embedded assembly
#define  FPWMB_SM2VAL3               0xE76B

#define  PWMB_SM2VAL4                (*(vuint16_t *) (0xE76D)) // for C, then embedded assembly
#define  FPWMB_SM2VAL4               0xE76D

#define  PWMB_SM2VAL5                (*(vuint16_t *) (0xE76F)) // for C, then embedded assembly
#define  FPWMB_SM2VAL5               0xE76F

#define  PWMB_SM2OCTRL               (*(vuint16_t *) (0xE771)) // for C, then embedded assembly
#define  FPWMB_SM2OCTRL              0xE771

#define  PWMB_SM2STS                 (*(vuint16_t *) (0xE772)) // for C, then embedded assembly
#define  FPWMB_SM2STS                0xE772

#define  PWMB_SM2INTEN               (*(vuint16_t *) (0xE773)) // for C, then embedded assembly
#define  FPWMB_SM2INTEN              0xE773

#define  PWMB_SM2DMAEN               (*(vuint16_t *) (0xE774)) // for C, then embedded assembly
#define  FPWMB_SM2DMAEN              0xE774

#define  PWMB_SM2TCTRL               (*(vuint16_t *) (0xE775)) // for C, then embedded assembly
#define  FPWMB_SM2TCTRL              0xE775

#define  PWMB_SM2DISMAP0             (*(vuint16_t *) (0xE776)) // for C, then embedded assembly
#define  FPWMB_SM2DISMAP0            0xE776

#define  PWMB_SM2DISMAP1             (*(vuint16_t *) (0xE777)) // for C, then embedded assembly
#define  FPWMB_SM2DISMAP1            0xE777

#define  PWMB_SM2DTCNT0              (*(vuint16_t *) (0xE778)) // for C, then embedded assembly
#define  FPWMB_SM2DTCNT0             0xE778

#define  PWMB_SM2DTCNT1              (*(vuint16_t *) (0xE779)) // for C, then embedded assembly
#define  FPWMB_SM2DTCNT1             0xE779

#define  PWMB_SM2CAPTCTRLA           (*(vuint16_t *) (0xE77A)) // for C, then embedded assembly
#define  FPWMB_SM2CAPTCTRLA          0xE77A

#define  PWMB_SM2CAPTCOMPA           (*(vuint16_t *) (0xE77B)) // for C, then embedded assembly
#define  FPWMB_SM2CAPTCOMPA          0xE77B

#define  PWMB_SM2CAPTCTRLB           (*(vuint16_t *) (0xE77C)) // for C, then embedded assembly
#define  FPWMB_SM2CAPTCTRLB          0xE77C

#define  PWMB_SM2CAPTCOMPB           (*(vuint16_t *) (0xE77D)) // for C, then embedded assembly
#define  FPWMB_SM2CAPTCOMPB          0xE77D

#define  PWMB_SM2CAPTCTRLX           (*(vuint16_t *) (0xE77E)) // for C, then embedded assembly
#define  FPWMB_SM2CAPTCTRLX          0xE77E

#define  PWMB_SM2CAPTCOMPX           (*(vuint16_t *) (0xE77F)) // for C, then embedded assembly
#define  FPWMB_SM2CAPTCOMPX          0xE77F

#define  PWMB_SM2CVAL0               (*(vuint16_t *) (0xE780)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL0              0xE780

#define  PWMB_SM2CVAL0CYC            (*(vuint16_t *) (0xE781)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL0CYC           0xE781

#define  PWMB_SM2CVAL1               (*(vuint16_t *) (0xE782)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL1              0xE782

#define  PWMB_SM2CVAL1CYC            (*(vuint16_t *) (0xE783)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL1CYC           0xE783

#define  PWMB_SM2CVAL2               (*(vuint16_t *) (0xE784)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL2              0xE784

#define  PWMB_SM2CVAL2CYC            (*(vuint16_t *) (0xE785)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL2CYC           0xE785

#define  PWMB_SM2CVAL3               (*(vuint16_t *) (0xE786)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL3              0xE786

#define  PWMB_SM2CVAL3CYC            (*(vuint16_t *) (0xE787)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL3CYC           0xE787

#define  PWMB_SM2CVAL4               (*(vuint16_t *) (0xE788)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL4              0xE788

#define  PWMB_SM2CVAL4CYC            (*(vuint16_t *) (0xE789)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL4CYC           0xE789

#define  PWMB_SM2CVAL5               (*(vuint16_t *) (0xE78A)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL5              0xE78A

#define  PWMB_SM2CVAL5CYC            (*(vuint16_t *) (0xE78B)) // for C, then embedded assembly
#define  FPWMB_SM2CVAL5CYC           0xE78B

#define  PWMB_SM3CNT                 (*(vuint16_t *) (0xE790)) // for C, then embedded assembly
#define  FPWMB_SM3CNT                0xE790

#define  PWMB_SM3INIT                (*(vuint16_t *) (0xE791)) // for C, then embedded assembly
#define  FPWMB_SM3INIT               0xE791

#define  PWMB_SM3CTRL2               (*(vuint16_t *) (0xE792)) // for C, then embedded assembly
#define  FPWMB_SM3CTRL2              0xE792

#define  PWMB_SM3CTRL                (*(vuint16_t *) (0xE793)) // for C, then embedded assembly
#define  FPWMB_SM3CTRL               0xE793

#define  PWMB_SM3VAL0                (*(vuint16_t *) (0xE795)) // for C, then embedded assembly
#define  FPWMB_SM3VAL0               0xE795

#define  PWMB_SM3VAL1                (*(vuint16_t *) (0xE797)) // for C, then embedded assembly
#define  FPWMB_SM3VAL1               0xE797

#define  PWMB_SM3VAL2                (*(vuint16_t *) (0xE799)) // for C, then embedded assembly
#define  FPWMB_SM3VAL2               0xE799

#define  PWMB_SM3VAL3                (*(vuint16_t *) (0xE79B)) // for C, then embedded assembly
#define  FPWMB_SM3VAL3               0xE79B

#define  PWMB_SM3VAL4                (*(vuint16_t *) (0xE79D)) // for C, then embedded assembly
#define  FPWMB_SM3VAL4               0xE79D

#define  PWMB_SM3VAL5                (*(vuint16_t *) (0xE79F)) // for C, then embedded assembly
#define  FPWMB_SM3VAL5               0xE79F

#define  PWMB_SM3OCTRL               (*(vuint16_t *) (0xE7A1)) // for C, then embedded assembly
#define  FPWMB_SM3OCTRL              0xE7A1

#define  PWMB_SM3STS                 (*(vuint16_t *) (0xE7A2)) // for C, then embedded assembly
#define  FPWMB_SM3STS                0xE7A2

#define  PWMB_SM3INTEN               (*(vuint16_t *) (0xE7A3)) // for C, then embedded assembly
#define  FPWMB_SM3INTEN              0xE7A3

#define  PWMB_SM3DMAEN               (*(vuint16_t *) (0xE7A4)) // for C, then embedded assembly
#define  FPWMB_SM3DMAEN              0xE7A4

#define  PWMB_SM3TCTRL               (*(vuint16_t *) (0xE7A5)) // for C, then embedded assembly
#define  FPWMB_SM3TCTRL              0xE7A5

#define  PWMB_SM3DISMAP0             (*(vuint16_t *) (0xE7A6)) // for C, then embedded assembly
#define  FPWMB_SM3DISMAP0            0xE7A6

#define  PWMB_SM3DISMAP1             (*(vuint16_t *) (0xE7A7)) // for C, then embedded assembly
#define  FPWMB_SM3DISMAP1            0xE7A7

#define  PWMB_SM3DTCNT0              (*(vuint16_t *) (0xE7A8)) // for C, then embedded assembly
#define  FPWMB_SM3DTCNT0             0xE7A8

#define  PWMB_SM3DTCNT1              (*(vuint16_t *) (0xE7A9)) // for C, then embedded assembly
#define  FPWMB_SM3DTCNT1             0xE7A9

#define  PWMB_SM3CAPTCTRLA           (*(vuint16_t *) (0xE7AA)) // for C, then embedded assembly
#define  FPWMB_SM3CAPTCTRLA          0xE7AA

#define  PWMB_SM3CAPTCOMPA           (*(vuint16_t *) (0xE7AB)) // for C, then embedded assembly
#define  FPWMB_SM3CAPTCOMPA          0xE7AB

#define  PWMB_SM3CAPTCTRLB           (*(vuint16_t *) (0xE7AC)) // for C, then embedded assembly
#define  FPWMB_SM3CAPTCTRLB          0xE7AC

#define  PWMB_SM3CAPTCOMPB           (*(vuint16_t *) (0xE7AD)) // for C, then embedded assembly
#define  FPWMB_SM3CAPTCOMPB          0xE7AD

#define  PWMB_SM3CAPTCTRLX           (*(vuint16_t *) (0xE7AE)) // for C, then embedded assembly
#define  FPWMB_SM3CAPTCTRLX          0xE7AE

#define  PWMB_SM3CAPTCOMPX           (*(vuint16_t *) (0xE7AF)) // for C, then embedded assembly
#define  FPWMB_SM3CAPTCOMPX          0xE7AF

#define  PWMB_SM3CVAL0               (*(vuint16_t *) (0xE7B0)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL0              0xE7B0

#define  PWMB_SM3CVAL0CYC            (*(vuint16_t *) (0xE7B1)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL0CYC           0xE7B1

#define  PWMB_SM3CVAL1               (*(vuint16_t *) (0xE7B2)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL1              0xE7B2

#define  PWMB_SM3CVAL1CYC            (*(vuint16_t *) (0xE7B3)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL1CYC           0xE7B3

#define  PWMB_SM3CVAL2               (*(vuint16_t *) (0xE7B4)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL2              0xE7B4

#define  PWMB_SM3CVAL2CYC            (*(vuint16_t *) (0xE7B5)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL2CYC           0xE7B5

#define  PWMB_SM3CVAL3               (*(vuint16_t *) (0xE7B6)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL3              0xE7B6

#define  PWMB_SM3CVAL3CYC            (*(vuint16_t *) (0xE7B7)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL3CYC           0xE7B7

#define  PWMB_SM3CVAL4               (*(vuint16_t *) (0xE7B8)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL4              0xE7B8

#define  PWMB_SM3CVAL4CYC            (*(vuint16_t *) (0xE7B9)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL4CYC           0xE7B9

#define  PWMB_SM3CVAL5               (*(vuint16_t *) (0xE7BA)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL5              0xE7BA

#define  PWMB_SM3CVAL5CYC            (*(vuint16_t *) (0xE7BB)) // for C, then embedded assembly
#define  FPWMB_SM3CVAL5CYC           0xE7BB

#define  PWMB_OUTEN                  (*(vuint16_t *) (0xE7C0)) // for C, then embedded assembly
#define  FPWMB_OUTEN                 0xE7C0

#define  PWMB_MASK                   (*(vuint16_t *) (0xE7C1)) // for C, then embedded assembly
#define  FPWMB_MASK                  0xE7C1

#define  PWMB_SWCOUT                 (*(vuint16_t *) (0xE7C2)) // for C, then embedded assembly
#define  FPWMB_SWCOUT                0xE7C2

#define  PWMB_DTSRCSEL               (*(vuint16_t *) (0xE7C3)) // for C, then embedded assembly
#define  FPWMB_DTSRCSEL              0xE7C3

#define  PWMB_MCTRL                  (*(vuint16_t *) (0xE7C4)) // for C, then embedded assembly
#define  FPWMB_MCTRL                 0xE7C4

#define  PWMB_FCTRL0                 (*(vuint16_t *) (0xE7C6)) // for C, then embedded assembly
#define  FPWMB_FCTRL0                0xE7C6

#define  PWMB_FSTS0                  (*(vuint16_t *) (0xE7C7)) // for C, then embedded assembly
#define  FPWMB_FSTS0                 0xE7C7

#define  PWMB_FFILT0                 (*(vuint16_t *) (0xE7C8)) // for C, then embedded assembly
#define  FPWMB_FFILT0                0xE7C8

#define  PWMB_FTST0                  (*(vuint16_t *) (0xE7C9)) // for C, then embedded assembly
#define  FPWMB_FTST0                 0xE7C9

#define  PWMB_FCTRL1                 (*(vuint16_t *) (0xE7CA)) // for C, then embedded assembly
#define  FPWMB_FCTRL1                0xE7CA

#define  PWMB_FSTS1                  (*(vuint16_t *) (0xE7CB)) // for C, then embedded assembly
#define  FPWMB_FSTS1                 0xE7CB

#define  PWMB_FFILT1                 (*(vuint16_t *) (0xE7CC)) // for C, then embedded assembly
#define  FPWMB_FFILT1                0xE7CC

#define  PWMB_FTST1                  (*(vuint16_t *) (0xE7CD)) // for C, then embedded assembly
#define  FPWMB_FTST1                 0xE7CD

#define  QSCI0_RATE                  (*(vuint16_t *) (0xE080)) // for C, then embedded assembly
#define  FQSCI0_RATE                 0xE080

#define  QSCI0_CTRL1                 (*(vuint16_t *) (0xE081)) // for C, then embedded assembly
#define  FQSCI0_CTRL1                0xE081

#define  QSCI0_CTRL2                 (*(vuint16_t *) (0xE082)) // for C, then embedded assembly
#define  FQSCI0_CTRL2                0xE082

#define  QSCI0_STAT                  (*(vuint16_t *) (0xE083)) // for C, then embedded assembly
#define  FQSCI0_STAT                 0xE083

#define  QSCI0_DATA                  (*(vuint16_t *) (0xE084)) // for C, then embedded assembly
#define  FQSCI0_DATA                 0xE084

#define  QSCI0_CTRL3                 (*(vuint16_t *) (0xE085)) // for C, then embedded assembly
#define  FQSCI0_CTRL3                0xE085

#define  QSCI1_RATE                  (*(vuint16_t *) (0xE090)) // for C, then embedded assembly
#define  FQSCI1_RATE                 0xE090

#define  QSCI1_CTRL1                 (*(vuint16_t *) (0xE091)) // for C, then embedded assembly
#define  FQSCI1_CTRL1                0xE091

#define  QSCI1_CTRL2                 (*(vuint16_t *) (0xE092)) // for C, then embedded assembly
#define  FQSCI1_CTRL2                0xE092

#define  QSCI1_STAT                  (*(vuint16_t *) (0xE093)) // for C, then embedded assembly
#define  FQSCI1_STAT                 0xE093

#define  QSCI1_DATA                  (*(vuint16_t *) (0xE094)) // for C, then embedded assembly
#define  FQSCI1_DATA                 0xE094

#define  QSCI1_CTRL3                 (*(vuint16_t *) (0xE095)) // for C, then embedded assembly
#define  FQSCI1_CTRL3                0xE095

#define  QSCI2_RATE                  (*(vuint16_t *) (0xE0A0)) // for C, then embedded assembly
#define  FQSCI2_RATE                 0xE0A0

#define  QSCI2_CTRL1                 (*(vuint16_t *) (0xE0A1)) // for C, then embedded assembly
#define  FQSCI2_CTRL1                0xE0A1

#define  QSCI2_CTRL2                 (*(vuint16_t *) (0xE0A2)) // for C, then embedded assembly
#define  FQSCI2_CTRL2                0xE0A2

#define  QSCI2_STAT                  (*(vuint16_t *) (0xE0A3)) // for C, then embedded assembly
#define  FQSCI2_STAT                 0xE0A3

#define  QSCI2_DATA                  (*(vuint16_t *) (0xE0A4)) // for C, then embedded assembly
#define  FQSCI2_DATA                 0xE0A4

#define  QSCI2_CTRL3                 (*(vuint16_t *) (0xE0A5)) // for C, then embedded assembly
#define  FQSCI2_CTRL3                0xE0A5

#define  QSPI0_SPSCR                 (*(vuint16_t *) (0xE0B0)) // for C, then embedded assembly
#define  FQSPI0_SPSCR                0xE0B0

#define  QSPI0_SPDSR                 (*(vuint16_t *) (0xE0B1)) // for C, then embedded assembly
#define  FQSPI0_SPDSR                0xE0B1

#define  QSPI0_SPDRR                 (*(vuint16_t *) (0xE0B2)) // for C, then embedded assembly
#define  FQSPI0_SPDRR                0xE0B2

#define  QSPI0_SPDTR                 (*(vuint16_t *) (0xE0B3)) // for C, then embedded assembly
#define  FQSPI0_SPDTR                0xE0B3

#define  QSPI0_SPFIFO                (*(vuint16_t *) (0xE0B4)) // for C, then embedded assembly
#define  FQSPI0_SPFIFO               0xE0B4

#define  QSPI0_SPWAIT                (*(vuint16_t *) (0xE0B5)) // for C, then embedded assembly
#define  FQSPI0_SPWAIT               0xE0B5

#define  QSPI0_SPCTL2                (*(vuint16_t *) (0xE0B6)) // for C, then embedded assembly
#define  FQSPI0_SPCTL2               0xE0B6

#define  QSPI1_SPSCR                 (*(vuint16_t *) (0xE0C0)) // for C, then embedded assembly
#define  FQSPI1_SPSCR                0xE0C0

#define  QSPI1_SPDSR                 (*(vuint16_t *) (0xE0C1)) // for C, then embedded assembly
#define  FQSPI1_SPDSR                0xE0C1

#define  QSPI1_SPDRR                 (*(vuint16_t *) (0xE0C2)) // for C, then embedded assembly
#define  FQSPI1_SPDRR                0xE0C2

#define  QSPI1_SPDTR                 (*(vuint16_t *) (0xE0C3)) // for C, then embedded assembly
#define  FQSPI1_SPDTR                0xE0C3

#define  QSPI1_SPFIFO                (*(vuint16_t *) (0xE0C4)) // for C, then embedded assembly
#define  FQSPI1_SPFIFO               0xE0C4

#define  QSPI1_SPWAIT                (*(vuint16_t *) (0xE0C5)) // for C, then embedded assembly
#define  FQSPI1_SPWAIT               0xE0C5

#define  QSPI1_SPCTL2                (*(vuint16_t *) (0xE0C6)) // for C, then embedded assembly
#define  FQSPI1_SPCTL2               0xE0C6

#define  QSPI2_SPSCR                 (*(vuint16_t *) (0xE0D0)) // for C, then embedded assembly
#define  FQSPI2_SPSCR                0xE0D0

#define  QSPI2_SPDSR                 (*(vuint16_t *) (0xE0D1)) // for C, then embedded assembly
#define  FQSPI2_SPDSR                0xE0D1

#define  QSPI2_SPDRR                 (*(vuint16_t *) (0xE0D2)) // for C, then embedded assembly
#define  FQSPI2_SPDRR                0xE0D2

#define  QSPI2_SPDTR                 (*(vuint16_t *) (0xE0D3)) // for C, then embedded assembly
#define  FQSPI2_SPDTR                0xE0D3

#define  QSPI2_SPFIFO                (*(vuint16_t *) (0xE0D4)) // for C, then embedded assembly
#define  FQSPI2_SPFIFO               0xE0D4

#define  QSPI2_SPWAIT                (*(vuint16_t *) (0xE0D5)) // for C, then embedded assembly
#define  FQSPI2_SPWAIT               0xE0D5

#define  QSPI2_SPCTL2                (*(vuint16_t *) (0xE0D6)) // for C, then embedded assembly
#define  FQSPI2_SPCTL2               0xE0D6

#define  SIM_CTRL                    (*(vuint16_t *) (0xE400)) // for C, then embedded assembly
#define  FSIM_CTRL                   0xE400

#define  SIM_RSTAT                   (*(vuint16_t *) (0xE401)) // for C, then embedded assembly
#define  FSIM_RSTAT                  0xE401

#define  SIM_SCR0                    (*(vuint16_t *) (0xE402)) // for C, then embedded assembly
#define  FSIM_SCR0                   0xE402

#define  SIM_SCR1                    (*(vuint16_t *) (0xE403)) // for C, then embedded assembly
#define  FSIM_SCR1                   0xE403

#define  SIM_SCR2                    (*(vuint16_t *) (0xE404)) // for C, then embedded assembly
#define  FSIM_SCR2                   0xE404

#define  SIM_SCR3                    (*(vuint16_t *) (0xE405)) // for C, then embedded assembly
#define  FSIM_SCR3                   0xE405

#define  SIM_MSHID                   (*(vuint16_t *) (0xE406)) // for C, then embedded assembly
#define  FSIM_MSHID                  0xE406

#define  SIM_LSHID                   (*(vuint16_t *) (0xE407)) // for C, then embedded assembly
#define  FSIM_LSHID                  0xE407

#define  SIM_PWR                     (*(vuint16_t *) (0xE408)) // for C, then embedded assembly
#define  FSIM_PWR                    0xE408

#define  SIM_CLKOUT                  (*(vuint16_t *) (0xE40A)) // for C, then embedded assembly
#define  FSIM_CLKOUT                 0xE40A

#define  SIM_PCR                     (*(vuint16_t *) (0xE40B)) // for C, then embedded assembly
#define  FSIM_PCR                    0xE40B

#define  SIM_PCE0                    (*(vuint16_t *) (0xE40C)) // for C, then embedded assembly
#define  FSIM_PCE0                   0xE40C

#define  SIM_PCE1                    (*(vuint16_t *) (0xE40D)) // for C, then embedded assembly
#define  FSIM_PCE1                   0xE40D

#define  SIM_PCE2                    (*(vuint16_t *) (0xE40E)) // for C, then embedded assembly
#define  FSIM_PCE2                   0xE40E

#define  SIM_PCE3                    (*(vuint16_t *) (0xE40F)) // for C, then embedded assembly
#define  FSIM_PCE3                   0xE40F

#define  SIM_SD0                     (*(vuint16_t *) (0xE410)) // for C, then embedded assembly
#define  FSIM_SD0                    0xE410

#define  SIM_SD1                     (*(vuint16_t *) (0xE411)) // for C, then embedded assembly
#define  FSIM_SD1                    0xE411

#define  SIM_SD2                     (*(vuint16_t *) (0xE412)) // for C, then embedded assembly
#define  FSIM_SD2                    0xE412

#define  SIM_SD3                     (*(vuint16_t *) (0xE413)) // for C, then embedded assembly
#define  FSIM_SD3                    0xE413

#define  SIM_IOSAHI                  (*(vuint16_t *) (0xE414)) // for C, then embedded assembly
#define  FSIM_IOSAHI                 0xE414

#define  SIM_IOSALO                  (*(vuint16_t *) (0xE415)) // for C, then embedded assembly
#define  FSIM_IOSALO                 0xE415

#define  SIM_PROT                    (*(vuint16_t *) (0xE416)) // for C, then embedded assembly
#define  FSIM_PROT                   0xE416

#define  SIM_GPSAL                   (*(vuint16_t *) (0xE417)) // for C, then embedded assembly
#define  FSIM_GPSAL                  0xE417

#define  SIM_GPSBH                   (*(vuint16_t *) (0xE418)) // for C, then embedded assembly
#define  FSIM_GPSBH                  0xE418

#define  SIM_GPSCL                   (*(vuint16_t *) (0xE419)) // for C, then embedded assembly
#define  FSIM_GPSCL                  0xE419

#define  SIM_GPSCH                   (*(vuint16_t *) (0xE41A)) // for C, then embedded assembly
#define  FSIM_GPSCH                  0xE41A

#define  SIM_GPSDL                   (*(vuint16_t *) (0xE41B)) // for C, then embedded assembly
#define  FSIM_GPSDL                  0xE41B

#define  SIM_GPSEL                   (*(vuint16_t *) (0xE41C)) // for C, then embedded assembly
#define  FSIM_GPSEL                  0xE41C

#define  SIM_GPSEH                   (*(vuint16_t *) (0xE41D)) // for C, then embedded assembly
#define  FSIM_GPSEH                  0xE41D

#define  SIM_GPSFL                   (*(vuint16_t *) (0xE41E)) // for C, then embedded assembly
#define  FSIM_GPSFL                  0xE41E

#define  SIM_GPSFH                   (*(vuint16_t *) (0xE41F)) // for C, then embedded assembly
#define  FSIM_GPSFH                  0xE41F

#define  SIM_GPSGL                   (*(vuint16_t *) (0xE420)) // for C, then embedded assembly
#define  FSIM_GPSGL                  0xE420

#define  SIM_GPSGH                   (*(vuint16_t *) (0xE421)) // for C, then embedded assembly
#define  FSIM_GPSGH                  0xE421

#define  SIM_IPS0                    (*(vuint16_t *) (0xE422)) // for C, then embedded assembly
#define  FSIM_IPS0                   0xE422

#define  SIM_MISC0                   (*(vuint16_t *) (0xE423)) // for C, then embedded assembly
#define  FSIM_MISC0                  0xE423

#define  SIM_PSWR0                   (*(vuint16_t *) (0xE424)) // for C, then embedded assembly
#define  FSIM_PSWR0                  0xE424

#define  SIM_PSWR1                   (*(vuint16_t *) (0xE425)) // for C, then embedded assembly
#define  FSIM_PSWR1                  0xE425

#define  SIM_PSWR2                   (*(vuint16_t *) (0xE426)) // for C, then embedded assembly
#define  FSIM_PSWR2                  0xE426

#define  SIM_PSWR3                   (*(vuint16_t *) (0xE427)) // for C, then embedded assembly
#define  FSIM_PSWR3                  0xE427

#define  SIM_PWRMODE                 (*(vuint16_t *) (0xE428)) // for C, then embedded assembly
#define  FSIM_PWRMODE                0xE428

#define  SIM_NVMOPT2H                (*(vuint16_t *) (0xE42C)) // for C, then embedded assembly
#define  FSIM_NVMOPT2H               0xE42C

#define  SIM_NVMOPT2L                (*(vuint16_t *) (0xE42D)) // for C, then embedded assembly
#define  FSIM_NVMOPT2L               0xE42D

#define  SIM_NVMOPT3H                (*(vuint16_t *) (0xE42E)) // for C, then embedded assembly
#define  FSIM_NVMOPT3H               0xE42E

#define  TMRA_0_COMP1                (*(vuint16_t *) (0xE140)) // for C, then embedded assembly
#define  FTMRA_0_COMP1               0xE140

#define  TMRA_0_COMP2                (*(vuint16_t *) (0xE141)) // for C, then embedded assembly
#define  FTMRA_0_COMP2               0xE141

#define  TMRA_0_CAPT                 (*(vuint16_t *) (0xE142)) // for C, then embedded assembly
#define  FTMRA_0_CAPT                0xE142

#define  TMRA_0_LOAD                 (*(vuint16_t *) (0xE143)) // for C, then embedded assembly
#define  FTMRA_0_LOAD                0xE143

#define  TMRA_0_HOLD                 (*(vuint16_t *) (0xE144)) // for C, then embedded assembly
#define  FTMRA_0_HOLD                0xE144

#define  TMRA_0_CNTR                 (*(vuint16_t *) (0xE145)) // for C, then embedded assembly
#define  FTMRA_0_CNTR                0xE145

#define  TMRA_0_CTRL                 (*(vuint16_t *) (0xE146)) // for C, then embedded assembly
#define  FTMRA_0_CTRL                0xE146

#define  TMRA_0_SCTRL                (*(vuint16_t *) (0xE147)) // for C, then embedded assembly
#define  FTMRA_0_SCTRL               0xE147

#define  TMRA_0_CMPLD1               (*(vuint16_t *) (0xE148)) // for C, then embedded assembly
#define  FTMRA_0_CMPLD1              0xE148

#define  TMRA_0_CMPLD2               (*(vuint16_t *) (0xE149)) // for C, then embedded assembly
#define  FTMRA_0_CMPLD2              0xE149

#define  TMRA_0_CSCTRL               (*(vuint16_t *) (0xE14A)) // for C, then embedded assembly
#define  FTMRA_0_CSCTRL              0xE14A

#define  TMRA_0_FILT                 (*(vuint16_t *) (0xE14B)) // for C, then embedded assembly
#define  FTMRA_0_FILT                0xE14B

#define  TMRA_0_DMA                  (*(vuint16_t *) (0xE14C)) // for C, then embedded assembly
#define  FTMRA_0_DMA                 0xE14C

#define  TMRA_0_ENBL                 (*(vuint16_t *) (0xE14F)) // for C, then embedded assembly
#define  FTMRA_0_ENBL                0xE14F

#define  TMRA_1_COMP1                (*(vuint16_t *) (0xE150)) // for C, then embedded assembly
#define  FTMRA_1_COMP1               0xE150

#define  TMRA_1_COMP2                (*(vuint16_t *) (0xE151)) // for C, then embedded assembly
#define  FTMRA_1_COMP2               0xE151

#define  TMRA_1_CAPT                 (*(vuint16_t *) (0xE152)) // for C, then embedded assembly
#define  FTMRA_1_CAPT                0xE152

#define  TMRA_1_LOAD                 (*(vuint16_t *) (0xE153)) // for C, then embedded assembly
#define  FTMRA_1_LOAD                0xE153

#define  TMRA_1_HOLD                 (*(vuint16_t *) (0xE154)) // for C, then embedded assembly
#define  FTMRA_1_HOLD                0xE154

#define  TMRA_1_CNTR                 (*(vuint16_t *) (0xE155)) // for C, then embedded assembly
#define  FTMRA_1_CNTR                0xE155

#define  TMRA_1_CTRL                 (*(vuint16_t *) (0xE156)) // for C, then embedded assembly
#define  FTMRA_1_CTRL                0xE156

#define  TMRA_1_SCTRL                (*(vuint16_t *) (0xE157)) // for C, then embedded assembly
#define  FTMRA_1_SCTRL               0xE157

#define  TMRA_1_CMPLD1               (*(vuint16_t *) (0xE158)) // for C, then embedded assembly
#define  FTMRA_1_CMPLD1              0xE158

#define  TMRA_1_CMPLD2               (*(vuint16_t *) (0xE159)) // for C, then embedded assembly
#define  FTMRA_1_CMPLD2              0xE159

#define  TMRA_1_CSCTRL               (*(vuint16_t *) (0xE15A)) // for C, then embedded assembly
#define  FTMRA_1_CSCTRL              0xE15A

#define  TMRA_1_FILT                 (*(vuint16_t *) (0xE15B)) // for C, then embedded assembly
#define  FTMRA_1_FILT                0xE15B

#define  TMRA_1_DMA                  (*(vuint16_t *) (0xE15C)) // for C, then embedded assembly
#define  FTMRA_1_DMA                 0xE15C

#define  TMRA_2_COMP1                (*(vuint16_t *) (0xE160)) // for C, then embedded assembly
#define  FTMRA_2_COMP1               0xE160

#define  TMRA_2_COMP2                (*(vuint16_t *) (0xE161)) // for C, then embedded assembly
#define  FTMRA_2_COMP2               0xE161

#define  TMRA_2_CAPT                 (*(vuint16_t *) (0xE162)) // for C, then embedded assembly
#define  FTMRA_2_CAPT                0xE162

#define  TMRA_2_LOAD                 (*(vuint16_t *) (0xE163)) // for C, then embedded assembly
#define  FTMRA_2_LOAD                0xE163

#define  TMRA_2_HOLD                 (*(vuint16_t *) (0xE164)) // for C, then embedded assembly
#define  FTMRA_2_HOLD                0xE164

#define  TMRA_2_CNTR                 (*(vuint16_t *) (0xE165)) // for C, then embedded assembly
#define  FTMRA_2_CNTR                0xE165

#define  TMRA_2_CTRL                 (*(vuint16_t *) (0xE166)) // for C, then embedded assembly
#define  FTMRA_2_CTRL                0xE166

#define  TMRA_2_SCTRL                (*(vuint16_t *) (0xE167)) // for C, then embedded assembly
#define  FTMRA_2_SCTRL               0xE167

#define  TMRA_2_CMPLD1               (*(vuint16_t *) (0xE168)) // for C, then embedded assembly
#define  FTMRA_2_CMPLD1              0xE168

#define  TMRA_2_CMPLD2               (*(vuint16_t *) (0xE169)) // for C, then embedded assembly
#define  FTMRA_2_CMPLD2              0xE169

#define  TMRA_2_CSCTRL               (*(vuint16_t *) (0xE16A)) // for C, then embedded assembly
#define  FTMRA_2_CSCTRL              0xE16A

#define  TMRA_2_FILT                 (*(vuint16_t *) (0xE16B)) // for C, then embedded assembly
#define  FTMRA_2_FILT                0xE16B

#define  TMRA_2_DMA                  (*(vuint16_t *) (0xE16C)) // for C, then embedded assembly
#define  FTMRA_2_DMA                 0xE16C

#define  TMRA_3_COMP1                (*(vuint16_t *) (0xE170)) // for C, then embedded assembly
#define  FTMRA_3_COMP1               0xE170

#define  TMRA_3_COMP2                (*(vuint16_t *) (0xE171)) // for C, then embedded assembly
#define  FTMRA_3_COMP2               0xE171

#define  TMRA_3_CAPT                 (*(vuint16_t *) (0xE172)) // for C, then embedded assembly
#define  FTMRA_3_CAPT                0xE172

#define  TMRA_3_LOAD                 (*(vuint16_t *) (0xE173)) // for C, then embedded assembly
#define  FTMRA_3_LOAD                0xE173

#define  TMRA_3_HOLD                 (*(vuint16_t *) (0xE174)) // for C, then embedded assembly
#define  FTMRA_3_HOLD                0xE174

#define  TMRA_3_CNTR                 (*(vuint16_t *) (0xE175)) // for C, then embedded assembly
#define  FTMRA_3_CNTR                0xE175

#define  TMRA_3_CTRL                 (*(vuint16_t *) (0xE176)) // for C, then embedded assembly
#define  FTMRA_3_CTRL                0xE176

#define  TMRA_3_SCTRL                (*(vuint16_t *) (0xE177)) // for C, then embedded assembly
#define  FTMRA_3_SCTRL               0xE177

#define  TMRA_3_CMPLD1               (*(vuint16_t *) (0xE178)) // for C, then embedded assembly
#define  FTMRA_3_CMPLD1              0xE178

#define  TMRA_3_CMPLD2               (*(vuint16_t *) (0xE179)) // for C, then embedded assembly
#define  FTMRA_3_CMPLD2              0xE179

#define  TMRA_3_CSCTRL               (*(vuint16_t *) (0xE17A)) // for C, then embedded assembly
#define  FTMRA_3_CSCTRL              0xE17A

#define  TMRA_3_FILT                 (*(vuint16_t *) (0xE17B)) // for C, then embedded assembly
#define  FTMRA_3_FILT                0xE17B

#define  TMRA_3_DMA                  (*(vuint16_t *) (0xE17C)) // for C, then embedded assembly
#define  FTMRA_3_DMA                 0xE17C

#define  TMRB_0_COMP1                (*(vuint16_t *) (0xE180)) // for C, then embedded assembly
#define  FTMRB_0_COMP1               0xE180

#define  TMRB_0_COMP2                (*(vuint16_t *) (0xE181)) // for C, then embedded assembly
#define  FTMRB_0_COMP2               0xE181

#define  TMRB_0_CAPT                 (*(vuint16_t *) (0xE182)) // for C, then embedded assembly
#define  FTMRB_0_CAPT                0xE182

#define  TMRB_0_LOAD                 (*(vuint16_t *) (0xE183)) // for C, then embedded assembly
#define  FTMRB_0_LOAD                0xE183

#define  TMRB_0_HOLD                 (*(vuint16_t *) (0xE184)) // for C, then embedded assembly
#define  FTMRB_0_HOLD                0xE184

#define  TMRB_0_CNTR                 (*(vuint16_t *) (0xE185)) // for C, then embedded assembly
#define  FTMRB_0_CNTR                0xE185

#define  TMRB_0_CTRL                 (*(vuint16_t *) (0xE186)) // for C, then embedded assembly
#define  FTMRB_0_CTRL                0xE186

#define  TMRB_0_SCTRL                (*(vuint16_t *) (0xE187)) // for C, then embedded assembly
#define  FTMRB_0_SCTRL               0xE187

#define  TMRB_0_CMPLD1               (*(vuint16_t *) (0xE188)) // for C, then embedded assembly
#define  FTMRB_0_CMPLD1              0xE188

#define  TMRB_0_CMPLD2               (*(vuint16_t *) (0xE189)) // for C, then embedded assembly
#define  FTMRB_0_CMPLD2              0xE189

#define  TMRB_0_CSCTRL               (*(vuint16_t *) (0xE18A)) // for C, then embedded assembly
#define  FTMRB_0_CSCTRL              0xE18A

#define  TMRB_0_FILT                 (*(vuint16_t *) (0xE18B)) // for C, then embedded assembly
#define  FTMRB_0_FILT                0xE18B

#define  TMRB_0_DMA                  (*(vuint16_t *) (0xE18C)) // for C, then embedded assembly
#define  FTMRB_0_DMA                 0xE18C

#define  TMRB_0_ENBL                 (*(vuint16_t *) (0xE18F)) // for C, then embedded assembly
#define  FTMRB_0_ENBL                0xE18F

#define  TMRB_1_COMP1                (*(vuint16_t *) (0xE190)) // for C, then embedded assembly
#define  FTMRB_1_COMP1               0xE190

#define  TMRB_1_COMP2                (*(vuint16_t *) (0xE191)) // for C, then embedded assembly
#define  FTMRB_1_COMP2               0xE191

#define  TMRB_1_CAPT                 (*(vuint16_t *) (0xE192)) // for C, then embedded assembly
#define  FTMRB_1_CAPT                0xE192

#define  TMRB_1_LOAD                 (*(vuint16_t *) (0xE193)) // for C, then embedded assembly
#define  FTMRB_1_LOAD                0xE193

#define  TMRB_1_HOLD                 (*(vuint16_t *) (0xE194)) // for C, then embedded assembly
#define  FTMRB_1_HOLD                0xE194

#define  TMRB_1_CNTR                 (*(vuint16_t *) (0xE195)) // for C, then embedded assembly
#define  FTMRB_1_CNTR                0xE195

#define  TMRB_1_CTRL                 (*(vuint16_t *) (0xE196)) // for C, then embedded assembly
#define  FTMRB_1_CTRL                0xE196

#define  TMRB_1_SCTRL                (*(vuint16_t *) (0xE197)) // for C, then embedded assembly
#define  FTMRB_1_SCTRL               0xE197

#define  TMRB_1_CMPLD1               (*(vuint16_t *) (0xE198)) // for C, then embedded assembly
#define  FTMRB_1_CMPLD1              0xE198

#define  TMRB_1_CMPLD2               (*(vuint16_t *) (0xE199)) // for C, then embedded assembly
#define  FTMRB_1_CMPLD2              0xE199

#define  TMRB_1_CSCTRL               (*(vuint16_t *) (0xE19A)) // for C, then embedded assembly
#define  FTMRB_1_CSCTRL              0xE19A

#define  TMRB_1_FILT                 (*(vuint16_t *) (0xE19B)) // for C, then embedded assembly
#define  FTMRB_1_FILT                0xE19B

#define  TMRB_1_DMA                  (*(vuint16_t *) (0xE19C)) // for C, then embedded assembly
#define  FTMRB_1_DMA                 0xE19C

#define  TMRB_2_COMP1                (*(vuint16_t *) (0xE1A0)) // for C, then embedded assembly
#define  FTMRB_2_COMP1               0xE1A0

#define  TMRB_2_COMP2                (*(vuint16_t *) (0xE1A1)) // for C, then embedded assembly
#define  FTMRB_2_COMP2               0xE1A1

#define  TMRB_2_CAPT                 (*(vuint16_t *) (0xE1A2)) // for C, then embedded assembly
#define  FTMRB_2_CAPT                0xE1A2

#define  TMRB_2_LOAD                 (*(vuint16_t *) (0xE1A3)) // for C, then embedded assembly
#define  FTMRB_2_LOAD                0xE1A3

#define  TMRB_2_HOLD                 (*(vuint16_t *) (0xE1A4)) // for C, then embedded assembly
#define  FTMRB_2_HOLD                0xE1A4

#define  TMRB_2_CNTR                 (*(vuint16_t *) (0xE1A5)) // for C, then embedded assembly
#define  FTMRB_2_CNTR                0xE1A5

#define  TMRB_2_CTRL                 (*(vuint16_t *) (0xE1A6)) // for C, then embedded assembly
#define  FTMRB_2_CTRL                0xE1A6

#define  TMRB_2_SCTRL                (*(vuint16_t *) (0xE1A7)) // for C, then embedded assembly
#define  FTMRB_2_SCTRL               0xE1A7

#define  TMRB_2_CMPLD1               (*(vuint16_t *) (0xE1A8)) // for C, then embedded assembly
#define  FTMRB_2_CMPLD1              0xE1A8

#define  TMRB_2_CMPLD2               (*(vuint16_t *) (0xE1A9)) // for C, then embedded assembly
#define  FTMRB_2_CMPLD2              0xE1A9

#define  TMRB_2_CSCTRL               (*(vuint16_t *) (0xE1AA)) // for C, then embedded assembly
#define  FTMRB_2_CSCTRL              0xE1AA

#define  TMRB_2_FILT                 (*(vuint16_t *) (0xE1AB)) // for C, then embedded assembly
#define  FTMRB_2_FILT                0xE1AB

#define  TMRB_2_DMA                  (*(vuint16_t *) (0xE1AC)) // for C, then embedded assembly
#define  FTMRB_2_DMA                 0xE1AC

#define  TMRB_3_COMP1                (*(vuint16_t *) (0xE1B0)) // for C, then embedded assembly
#define  FTMRB_3_COMP1               0xE1B0

#define  TMRB_3_COMP2                (*(vuint16_t *) (0xE1B1)) // for C, then embedded assembly
#define  FTMRB_3_COMP2               0xE1B1

#define  TMRB_3_CAPT                 (*(vuint16_t *) (0xE1B2)) // for C, then embedded assembly
#define  FTMRB_3_CAPT                0xE1B2

#define  TMRB_3_LOAD                 (*(vuint16_t *) (0xE1B3)) // for C, then embedded assembly
#define  FTMRB_3_LOAD                0xE1B3

#define  TMRB_3_HOLD                 (*(vuint16_t *) (0xE1B4)) // for C, then embedded assembly
#define  FTMRB_3_HOLD                0xE1B4

#define  TMRB_3_CNTR                 (*(vuint16_t *) (0xE1B5)) // for C, then embedded assembly
#define  FTMRB_3_CNTR                0xE1B5

#define  TMRB_3_CTRL                 (*(vuint16_t *) (0xE1B6)) // for C, then embedded assembly
#define  FTMRB_3_CTRL                0xE1B6

#define  TMRB_3_SCTRL                (*(vuint16_t *) (0xE1B7)) // for C, then embedded assembly
#define  FTMRB_3_SCTRL               0xE1B7

#define  TMRB_3_CMPLD1               (*(vuint16_t *) (0xE1B8)) // for C, then embedded assembly
#define  FTMRB_3_CMPLD1              0xE1B8

#define  TMRB_3_CMPLD2               (*(vuint16_t *) (0xE1B9)) // for C, then embedded assembly
#define  FTMRB_3_CMPLD2              0xE1B9

#define  TMRB_3_CSCTRL               (*(vuint16_t *) (0xE1BA)) // for C, then embedded assembly
#define  FTMRB_3_CSCTRL              0xE1BA

#define  TMRB_3_FILT                 (*(vuint16_t *) (0xE1BB)) // for C, then embedded assembly
#define  FTMRB_3_FILT                0xE1BB

#define  TMRB_3_DMA                  (*(vuint16_t *) (0xE1BC)) // for C, then embedded assembly
#define  FTMRB_3_DMA                 0xE1BC

#define  XBARA_SEL0                  (*(vuint16_t *) (0xE340)) // for C, then embedded assembly
#define  FXBARA_SEL0                 0xE340

#define  XBARA_SEL1                  (*(vuint16_t *) (0xE341)) // for C, then embedded assembly
#define  FXBARA_SEL1                 0xE341

#define  XBARA_SEL2                  (*(vuint16_t *) (0xE342)) // for C, then embedded assembly
#define  FXBARA_SEL2                 0xE342

#define  XBARA_SEL3                  (*(vuint16_t *) (0xE343)) // for C, then embedded assembly
#define  FXBARA_SEL3                 0xE343

#define  XBARA_SEL4                  (*(vuint16_t *) (0xE344)) // for C, then embedded assembly
#define  FXBARA_SEL4                 0xE344

#define  XBARA_SEL5                  (*(vuint16_t *) (0xE345)) // for C, then embedded assembly
#define  FXBARA_SEL5                 0xE345

#define  XBARA_SEL6                  (*(vuint16_t *) (0xE346)) // for C, then embedded assembly
#define  FXBARA_SEL6                 0xE346

#define  XBARA_SEL7                  (*(vuint16_t *) (0xE347)) // for C, then embedded assembly
#define  FXBARA_SEL7                 0xE347

#define  XBARA_SEL8                  (*(vuint16_t *) (0xE348)) // for C, then embedded assembly
#define  FXBARA_SEL8                 0xE348

#define  XBARA_SEL9                  (*(vuint16_t *) (0xE349)) // for C, then embedded assembly
#define  FXBARA_SEL9                 0xE349

#define  XBARA_SEL10                 (*(vuint16_t *) (0xE34A)) // for C, then embedded assembly
#define  FXBARA_SEL10                0xE34A

#define  XBARA_SEL11                 (*(vuint16_t *) (0xE34B)) // for C, then embedded assembly
#define  FXBARA_SEL11                0xE34B

#define  XBARA_SEL12                 (*(vuint16_t *) (0xE34C)) // for C, then embedded assembly
#define  FXBARA_SEL12                0xE34C

#define  XBARA_SEL13                 (*(vuint16_t *) (0xE34D)) // for C, then embedded assembly
#define  FXBARA_SEL13                0xE34D

#define  XBARA_SEL14                 (*(vuint16_t *) (0xE34E)) // for C, then embedded assembly
#define  FXBARA_SEL14                0xE34E

#define  XBARA_SEL15                 (*(vuint16_t *) (0xE34F)) // for C, then embedded assembly
#define  FXBARA_SEL15                0xE34F

#define  XBARA_SEL16                 (*(vuint16_t *) (0xE350)) // for C, then embedded assembly
#define  FXBARA_SEL16                0xE350

#define  XBARA_SEL17                 (*(vuint16_t *) (0xE351)) // for C, then embedded assembly
#define  FXBARA_SEL17                0xE351

#define  XBARA_SEL18                 (*(vuint16_t *) (0xE352)) // for C, then embedded assembly
#define  FXBARA_SEL18                0xE352

#define  XBARA_SEL19                 (*(vuint16_t *) (0xE353)) // for C, then embedded assembly
#define  FXBARA_SEL19                0xE353

#define  XBARA_SEL20                 (*(vuint16_t *) (0xE354)) // for C, then embedded assembly
#define  FXBARA_SEL20                0xE354

#define  XBARA_SEL21                 (*(vuint16_t *) (0xE355)) // for C, then embedded assembly
#define  FXBARA_SEL21                0xE355

#define  XBARA_SEL22                 (*(vuint16_t *) (0xE356)) // for C, then embedded assembly
#define  FXBARA_SEL22                0xE356

#define  XBARA_SEL23                 (*(vuint16_t *) (0xE357)) // for C, then embedded assembly
#define  FXBARA_SEL23                0xE357

#define  XBARA_SEL24                 (*(vuint16_t *) (0xE358)) // for C, then embedded assembly
#define  FXBARA_SEL24                0xE358

#define  XBARA_SEL25                 (*(vuint16_t *) (0xE359)) // for C, then embedded assembly
#define  FXBARA_SEL25                0xE359

#define  XBARA_SEL26                 (*(vuint16_t *) (0xE35A)) // for C, then embedded assembly
#define  FXBARA_SEL26                0xE35A

#define  XBARA_SEL27                 (*(vuint16_t *) (0xE35B)) // for C, then embedded assembly
#define  FXBARA_SEL27                0xE35B

#define  XBARA_SEL28                 (*(vuint16_t *) (0xE35C)) // for C, then embedded assembly
#define  FXBARA_SEL28                0xE35C

#define  XBARA_SEL29                 (*(vuint16_t *) (0xE35D)) // for C, then embedded assembly
#define  FXBARA_SEL29                0xE35D

#define  XBARA_CTRL0                 (*(vuint16_t *) (0xE35E)) // for C, then embedded assembly
#define  FXBARA_CTRL0                0xE35E

#define  XBARA_CTRL1                 (*(vuint16_t *) (0xE35F)) // for C, then embedded assembly
#define  FXBARA_CTRL1                0xE35F

#define  XBARB_SEL0                  (*(vuint16_t *) (0xE360)) // for C, then embedded assembly
#define  FXBARB_SEL0                 0xE360

#define  XBARB_SEL1                  (*(vuint16_t *) (0xE361)) // for C, then embedded assembly
#define  FXBARB_SEL1                 0xE361

#define  XBARB_SEL2                  (*(vuint16_t *) (0xE362)) // for C, then embedded assembly
#define  FXBARB_SEL2                 0xE362

#define  XBARB_SEL3                  (*(vuint16_t *) (0xE363)) // for C, then embedded assembly
#define  FXBARB_SEL3                 0xE363

#define  XBARB_SEL4                  (*(vuint16_t *) (0xE364)) // for C, then embedded assembly
#define  FXBARB_SEL4                 0xE364

#define  XBARB_SEL5                  (*(vuint16_t *) (0xE365)) // for C, then embedded assembly
#define  FXBARB_SEL5                 0xE365

#define  XBARB_SEL6                  (*(vuint16_t *) (0xE366)) // for C, then embedded assembly
#define  FXBARB_SEL6                 0xE366

#define  XBARB_SEL7                  (*(vuint16_t *) (0xE367)) // for C, then embedded assembly
#define  FXBARB_SEL7                 0xE367

//////////////////////////////////////////////////////////////////////////////////////
// The following section defines the IO register bitfield locations and includes some commentary on the meaning of some settings.
//////////////////////////////////////////////////////////////////////////////////////

#define  ADC12_CTRL1_SMODE           (BIT0|BIT1|BIT2)
//   ADC Scan Mode Control
//     0b000 ==> Once (single) sequential
//     0b001 ==> Once parallel
//     0b010 ==> Loop sequential
//     0b011 ==> Loop parallel
//     0b100 ==> Triggered sequential
//     0b101 ==> Triggered parallel (default)
//     0b11x ==> Reserved
#define  ADC12_CTRL1_SMODE_0         BIT0
#define  ADC12_CTRL1_SMODE_1         BIT1
#define  ADC12_CTRL1_SMODE_2         BIT2

#define  ADC12_CTRL1_CHNCFG_L        (BIT4|BIT5|BIT6|BIT7)
//   CHCNF (Channel Configure Low) bits
//     0bxxx1 ==> Inputs = ANA0-ANA1
//     0bxxx0 ==> Inputs = ANA0-ANA1
//     0bxx1x ==> Inputs = ANA2-ANA3
//     0bxx0x ==> Inputs = ANA2-ANA3
//     0bx1xx ==> Inputs = ANB0-ANB1
//     0bx0xx ==> Inputs = ANB0-ANB1
//     0b1xxx ==> Inputs = ANB2-ANB3
#define  ADC12_CTRL1_CHNCFG_L_0      BIT4
#define  ADC12_CTRL1_CHNCFG_L_1      BIT5
#define  ADC12_CTRL1_CHNCFG_L_2      BIT6
#define  ADC12_CTRL1_CHNCFG_L_3      BIT7

#define  ADC12_CTRL1_HLMTIE          BIT8
//   High Limit Interrupt Enable
//     0b0 ==> Interrupt disabled
//     0b1 ==> Interrupt enabled

#define  ADC12_CTRL1_LLMTIE          BIT9
//   Low Limit Interrupt Enable
//     0b0 ==> Interrupt disabled
//     0b1 ==> Interrupt enabled

#define  ADC12_CTRL1_ZCIE            BIT10
//   Zero Crossing Interrupt Enable
//     0b0 ==> Interrupt disabled
//     0b1 ==> Interrupt enabled

#define  ADC12_CTRL1_EOSIE0          BIT11
//   End Of Scan Interrupt Enable
//     0b0 ==> Interrupt disabled
//     0b1 ==> Interrupt enabled

#define  ADC12_CTRL1_SYNC0           BIT12
//   SYNC0 Enable
//     0b0 ==> Scan is initiated by a write to CTRL1[START0] only
//     0b1 ==> Use a SYNC0 input pulse or CTRL1[START0] to initiate a scan

#define  ADC12_CTRL1_START0          BIT13
//   START0 Conversion
//     0b0 ==> No action
//     0b1 ==> Start command is issued

#define  ADC12_CTRL1_STOP0           BIT14
//   Stop
//     0b0 ==> Normal operation
//     0b1 ==> Stop mode

#define  ADC12_CTRL1_DMAEN0          BIT15
//   DMA enable
//     0b0 ==> DMA is not enabled.
//     0b1 ==> DMA is enabled.

#define  ADC12_CTRL2_DIV0            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   Clock Divisor Select
#define  ADC12_CTRL2_DIV0_0          BIT0
#define  ADC12_CTRL2_DIV0_1          BIT1
#define  ADC12_CTRL2_DIV0_2          BIT2
#define  ADC12_CTRL2_DIV0_3          BIT3
#define  ADC12_CTRL2_DIV0_4          BIT4
#define  ADC12_CTRL2_DIV0_5          BIT5

#define  ADC12_CTRL2_SIMULT          BIT6
//   Simultaneous mode
//     0b0 ==> Parallel scans done independently
//     0b1 ==> Parallel scans done simultaneously (default)

#define  ADC12_CTRL2_CHNCFG_H        (BIT7|BIT8|BIT9|BIT10)
//   CHCNF (Channel Configure High) bits
//     0bxxx1 ==> Inputs = ANA4-ANA5
//     0bxxx0 ==> Inputs = ANA4-ANA5
//     0bxx1x ==> Inputs = ANA6-ANA7
//     0bxx0x ==> Inputs = ANA6-ANA7
//     0bx1xx ==> Inputs = ANB4-ANB5
//     0bx0xx ==> Inputs = ANB4-ANB5
//     0b1xxx ==> Inputs = ANB6-ANB7
#define  ADC12_CTRL2_CHNCFG_H_0      BIT7
#define  ADC12_CTRL2_CHNCFG_H_1      BIT8
#define  ADC12_CTRL2_CHNCFG_H_2      BIT9
#define  ADC12_CTRL2_CHNCFG_H_3      BIT10

#define  ADC12_CTRL2_EOSIE1          BIT11
//   End Of Scan Interrupt Enable
//     0b0 ==> Interrupt disabled
//     0b1 ==> Interrupt enabled

#define  ADC12_CTRL2_SYNC1           BIT12
//   SYNC1 Enable
//     0b0 ==> B converter parallel scan is initiated by a write to CTRL2[START1] bit only
//     0b1 ==> Use a SYNC1 input pulse or CTRL2[START1] bit to initiate a B converter parallel scan

#define  ADC12_CTRL2_START1          BIT13
//   START1 Conversion
//     0b0 ==> No action
//     0b1 ==> Start command is issued

#define  ADC12_CTRL2_STOP1           BIT14
//   Stop
//     0b0 ==> Normal operation
//     0b1 ==> Stop mode

#define  ADC12_CTRL2_DMAEN1          BIT15
//   DMA enable
//     0b0 ==> DMA is not enabled.
//     0b1 ==> DMA is enabled.

#define  ADC12_ZXCTRL1_ZCE0          (BIT0|BIT1)
//   Zero crossing enable 0
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL1_ZCE0_0        BIT0
#define  ADC12_ZXCTRL1_ZCE0_1        BIT1

#define  ADC12_ZXCTRL1_ZCE1          (BIT2|BIT3)
//   Zero crossing enable 1
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL1_ZCE1_0        BIT2
#define  ADC12_ZXCTRL1_ZCE1_1        BIT3

#define  ADC12_ZXCTRL1_ZCE2          (BIT4|BIT5)
//   Zero crossing enable 2
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL1_ZCE2_0        BIT4
#define  ADC12_ZXCTRL1_ZCE2_1        BIT5

#define  ADC12_ZXCTRL1_ZCE3          (BIT6|BIT7)
//   Zero crossing enable 3
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL1_ZCE3_0        BIT6
#define  ADC12_ZXCTRL1_ZCE3_1        BIT7

#define  ADC12_ZXCTRL1_ZCE4          (BIT8|BIT9)
//   Zero crossing enable 4
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL1_ZCE4_0        BIT8
#define  ADC12_ZXCTRL1_ZCE4_1        BIT9

#define  ADC12_ZXCTRL1_ZCE5          (BIT10|BIT11)
//   Zero crossing enable 5
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL1_ZCE5_0        BIT10
#define  ADC12_ZXCTRL1_ZCE5_1        BIT11

#define  ADC12_ZXCTRL1_ZCE6          (BIT12|BIT13)
//   Zero crossing enable 6
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL1_ZCE6_0        BIT12
#define  ADC12_ZXCTRL1_ZCE6_1        BIT13

#define  ADC12_ZXCTRL1_ZCE7          (BIT14|BIT15)
//   Zero crossing enable 7
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL1_ZCE7_0        BIT14
#define  ADC12_ZXCTRL1_ZCE7_1        BIT15

#define  ADC12_ZXCTRL2_ZCE8          (BIT0|BIT1)
//   Zero crossing enable 8
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL2_ZCE8_0        BIT0
#define  ADC12_ZXCTRL2_ZCE8_1        BIT1

#define  ADC12_ZXCTRL2_ZCE9          (BIT2|BIT3)
//   Zero crossing enable 9
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL2_ZCE9_0        BIT2
#define  ADC12_ZXCTRL2_ZCE9_1        BIT3

#define  ADC12_ZXCTRL2_ZCE10         (BIT4|BIT5)
//   Zero crossing enable 10
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL2_ZCE10_0       BIT4
#define  ADC12_ZXCTRL2_ZCE10_1       BIT5

#define  ADC12_ZXCTRL2_ZCE11         (BIT6|BIT7)
//   Zero crossing enable 11
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL2_ZCE11_0       BIT6
#define  ADC12_ZXCTRL2_ZCE11_1       BIT7

#define  ADC12_ZXCTRL2_ZCE12         (BIT8|BIT9)
//   Zero crossing enable 12
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL2_ZCE12_0       BIT8
#define  ADC12_ZXCTRL2_ZCE12_1       BIT9

#define  ADC12_ZXCTRL2_ZCE13         (BIT10|BIT11)
//   Zero crossing enable 13
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL2_ZCE13_0       BIT10
#define  ADC12_ZXCTRL2_ZCE13_1       BIT11

#define  ADC12_ZXCTRL2_ZCE14         (BIT12|BIT13)
//   Zero crossing enable 14
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL2_ZCE14_0       BIT12
#define  ADC12_ZXCTRL2_ZCE14_1       BIT13

#define  ADC12_ZXCTRL2_ZCE15         (BIT14|BIT15)
//   Zero crossing enable 15
//     0b00 ==> Zero Crossing disabled
//     0b01 ==> Zero Crossing enabled for positive to negative sign change
//     0b10 ==> Zero Crossing enabled for negative to positive sign change
//     0b11 ==> Zero Crossing enabled for any sign change
#define  ADC12_ZXCTRL2_ZCE15_0       BIT14
#define  ADC12_ZXCTRL2_ZCE15_1       BIT15

#define  ADC12_CLIST1_SAMPLE0        (BIT0|BIT1|BIT2|BIT3)
//   Sample Field 0
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST1_SAMPLE0_0      BIT0
#define  ADC12_CLIST1_SAMPLE0_1      BIT1
#define  ADC12_CLIST1_SAMPLE0_2      BIT2
#define  ADC12_CLIST1_SAMPLE0_3      BIT3

#define  ADC12_CLIST1_SAMPLE1        (BIT4|BIT5|BIT6|BIT7)
//   Sample Field 1
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST1_SAMPLE1_0      BIT4
#define  ADC12_CLIST1_SAMPLE1_1      BIT5
#define  ADC12_CLIST1_SAMPLE1_2      BIT6
#define  ADC12_CLIST1_SAMPLE1_3      BIT7

#define  ADC12_CLIST1_SAMPLE2        (BIT8|BIT9|BIT10|BIT11)
//   Sample Field 2
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST1_SAMPLE2_0      BIT8
#define  ADC12_CLIST1_SAMPLE2_1      BIT9
#define  ADC12_CLIST1_SAMPLE2_2      BIT10
#define  ADC12_CLIST1_SAMPLE2_3      BIT11

#define  ADC12_CLIST1_SAMPLE3        (BIT12|BIT13|BIT14|BIT15)
//   Sample Field 3
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST1_SAMPLE3_0      BIT12
#define  ADC12_CLIST1_SAMPLE3_1      BIT13
#define  ADC12_CLIST1_SAMPLE3_2      BIT14
#define  ADC12_CLIST1_SAMPLE3_3      BIT15

#define  ADC12_CLIST2_SAMPLE4        (BIT0|BIT1|BIT2|BIT3)
//   Sample Field 4
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST2_SAMPLE4_0      BIT0
#define  ADC12_CLIST2_SAMPLE4_1      BIT1
#define  ADC12_CLIST2_SAMPLE4_2      BIT2
#define  ADC12_CLIST2_SAMPLE4_3      BIT3

#define  ADC12_CLIST2_SAMPLE5        (BIT4|BIT5|BIT6|BIT7)
//   Sample Field 5
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST2_SAMPLE5_0      BIT4
#define  ADC12_CLIST2_SAMPLE5_1      BIT5
#define  ADC12_CLIST2_SAMPLE5_2      BIT6
#define  ADC12_CLIST2_SAMPLE5_3      BIT7

#define  ADC12_CLIST2_SAMPLE6        (BIT8|BIT9|BIT10|BIT11)
//   Sample Field 6
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST2_SAMPLE6_0      BIT8
#define  ADC12_CLIST2_SAMPLE6_1      BIT9
#define  ADC12_CLIST2_SAMPLE6_2      BIT10
#define  ADC12_CLIST2_SAMPLE6_3      BIT11

#define  ADC12_CLIST2_SAMPLE7        (BIT12|BIT13|BIT14|BIT15)
//   Sample Field 7
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST2_SAMPLE7_0      BIT12
#define  ADC12_CLIST2_SAMPLE7_1      BIT13
#define  ADC12_CLIST2_SAMPLE7_2      BIT14
#define  ADC12_CLIST2_SAMPLE7_3      BIT15

#define  ADC12_CLIST3_SAMPLE8        (BIT0|BIT1|BIT2|BIT3)
//   Sample Field 8
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST3_SAMPLE8_0      BIT0
#define  ADC12_CLIST3_SAMPLE8_1      BIT1
#define  ADC12_CLIST3_SAMPLE8_2      BIT2
#define  ADC12_CLIST3_SAMPLE8_3      BIT3

#define  ADC12_CLIST3_SAMPLE9        (BIT4|BIT5|BIT6|BIT7)
//   Sample Field 9
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST3_SAMPLE9_0      BIT4
#define  ADC12_CLIST3_SAMPLE9_1      BIT5
#define  ADC12_CLIST3_SAMPLE9_2      BIT6
#define  ADC12_CLIST3_SAMPLE9_3      BIT7

#define  ADC12_CLIST3_SAMPLE10       (BIT8|BIT9|BIT10|BIT11)
//   Sample Field 10
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST3_SAMPLE10_0     BIT8
#define  ADC12_CLIST3_SAMPLE10_1     BIT9
#define  ADC12_CLIST3_SAMPLE10_2     BIT10
#define  ADC12_CLIST3_SAMPLE10_3     BIT11

#define  ADC12_CLIST3_SAMPLE11       (BIT12|BIT13|BIT14|BIT15)
//   Sample Field 11
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST3_SAMPLE11_0     BIT12
#define  ADC12_CLIST3_SAMPLE11_1     BIT13
#define  ADC12_CLIST3_SAMPLE11_2     BIT14
#define  ADC12_CLIST3_SAMPLE11_3     BIT15

#define  ADC12_CLIST4_SAMPLE12       (BIT0|BIT1|BIT2|BIT3)
//   Sample Field 12
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST4_SAMPLE12_0     BIT0
#define  ADC12_CLIST4_SAMPLE12_1     BIT1
#define  ADC12_CLIST4_SAMPLE12_2     BIT2
#define  ADC12_CLIST4_SAMPLE12_3     BIT3

#define  ADC12_CLIST4_SAMPLE13       (BIT4|BIT5|BIT6|BIT7)
//   Sample Field 13
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST4_SAMPLE13_0     BIT4
#define  ADC12_CLIST4_SAMPLE13_1     BIT5
#define  ADC12_CLIST4_SAMPLE13_2     BIT6
#define  ADC12_CLIST4_SAMPLE13_3     BIT7

#define  ADC12_CLIST4_SAMPLE14       (BIT8|BIT9|BIT10|BIT11)
//   Sample Field 14
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST4_SAMPLE14_0     BIT8
#define  ADC12_CLIST4_SAMPLE14_1     BIT9
#define  ADC12_CLIST4_SAMPLE14_2     BIT10
#define  ADC12_CLIST4_SAMPLE14_3     BIT11

#define  ADC12_CLIST4_SAMPLE15       (BIT12|BIT13|BIT14|BIT15)
//   Sample Field 15
//     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
//     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
//     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
//     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
//     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
//     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
//     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
//     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
//     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
//     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
//     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
//     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
//     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
//     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
//     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
//     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
#define  ADC12_CLIST4_SAMPLE15_0     BIT12
#define  ADC12_CLIST4_SAMPLE15_1     BIT13
#define  ADC12_CLIST4_SAMPLE15_2     BIT14
#define  ADC12_CLIST4_SAMPLE15_3     BIT15

#define  ADC12_SDIS_DS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Disable Sample Bits
//     0b0 ==> Enable CLIST*[SAMPLEx].
//     0b1 ==> Disable CLIST*[SAMPLEx] and all subsequent samples. Which samples are actually disabled will depend on the conversion mode, sequential/parallel, and the value of CTRL2[SIMULT].
#define  ADC12_SDIS_DS_0             BIT0
#define  ADC12_SDIS_DS_1             BIT1
#define  ADC12_SDIS_DS_2             BIT2
#define  ADC12_SDIS_DS_3             BIT3
#define  ADC12_SDIS_DS_4             BIT4
#define  ADC12_SDIS_DS_5             BIT5
#define  ADC12_SDIS_DS_6             BIT6
#define  ADC12_SDIS_DS_7             BIT7
#define  ADC12_SDIS_DS_8             BIT8
#define  ADC12_SDIS_DS_9             BIT9
#define  ADC12_SDIS_DS_10            BIT10
#define  ADC12_SDIS_DS_11            BIT11
#define  ADC12_SDIS_DS_12            BIT12
#define  ADC12_SDIS_DS_13            BIT13
#define  ADC12_SDIS_DS_14            BIT14
#define  ADC12_SDIS_DS_15            BIT15

#define  ADC12_STAT_UNDEFINED        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  ADC12_STAT_UNDEFINED_0      BIT0
#define  ADC12_STAT_UNDEFINED_1      BIT1
#define  ADC12_STAT_UNDEFINED_2      BIT2
#define  ADC12_STAT_UNDEFINED_3      BIT3
#define  ADC12_STAT_UNDEFINED_4      BIT4
#define  ADC12_STAT_UNDEFINED_5      BIT5
#define  ADC12_STAT_UNDEFINED_6      BIT6
#define  ADC12_STAT_UNDEFINED_7      BIT7

#define  ADC12_STAT_HLMTI            BIT8
//   High Limit Interrupt
//     0b0 ==> No high limit interrupt request
//     0b1 ==> High limit exceeded, IRQ pending if CTRL1[HLMTIE] is set

#define  ADC12_STAT_LLMTI            BIT9
//   Low Limit Interrupt
//     0b0 ==> No low limit interrupt request
//     0b1 ==> Low limit exceeded, IRQ pending if CTRL1[LLMTIE] is set

#define  ADC12_STAT_ZCI              BIT10
//   Zero Crossing Interrupt
//     0b0 ==> No zero crossing interrupt request
//     0b1 ==> Zero crossing encountered, IRQ pending if CTRL1[ZCIE] is set

#define  ADC12_STAT_EOSI0            BIT11
//   End of Scan Interrupt
//     0b0 ==> A scan cycle has not been completed, no end of scan IRQ pending
//     0b1 ==> A scan cycle has been completed, end of scan IRQ pending

#define  ADC12_STAT_EOSI1            BIT12
//   End of Scan Interrupt
//     0b0 ==> A scan cycle has not been completed, no end of scan IRQ pending
//     0b1 ==> A scan cycle has been completed, end of scan IRQ pending

#define  ADC12_STAT_CIP1             BIT14
//   Conversion in Progress
//     0b0 ==> Idle state
//     0b1 ==> A scan cycle is in progress. The ADC will ignore all sync pulses or start commands

#define  ADC12_STAT_CIP0             BIT15
//   Conversion in Progress
//     0b0 ==> Idle state
//     0b1 ==> A scan cycle is in progress. The ADC will ignore all sync pulses or start commands

#define  ADC12_RDY_RDY               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Ready Sample
//     0b0 ==> Sample not ready or has been read
//     0b1 ==> Sample ready to be read
#define  ADC12_RDY_RDY_0             BIT0
#define  ADC12_RDY_RDY_1             BIT1
#define  ADC12_RDY_RDY_2             BIT2
#define  ADC12_RDY_RDY_3             BIT3
#define  ADC12_RDY_RDY_4             BIT4
#define  ADC12_RDY_RDY_5             BIT5
#define  ADC12_RDY_RDY_6             BIT6
#define  ADC12_RDY_RDY_7             BIT7
#define  ADC12_RDY_RDY_8             BIT8
#define  ADC12_RDY_RDY_9             BIT9
#define  ADC12_RDY_RDY_10            BIT10
#define  ADC12_RDY_RDY_11            BIT11
#define  ADC12_RDY_RDY_12            BIT12
#define  ADC12_RDY_RDY_13            BIT13
#define  ADC12_RDY_RDY_14            BIT14
#define  ADC12_RDY_RDY_15            BIT15

#define  ADC12_LOLIMSTAT_LLS         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Low Limit Status Bits
#define  ADC12_LOLIMSTAT_LLS_0       BIT0
#define  ADC12_LOLIMSTAT_LLS_1       BIT1
#define  ADC12_LOLIMSTAT_LLS_2       BIT2
#define  ADC12_LOLIMSTAT_LLS_3       BIT3
#define  ADC12_LOLIMSTAT_LLS_4       BIT4
#define  ADC12_LOLIMSTAT_LLS_5       BIT5
#define  ADC12_LOLIMSTAT_LLS_6       BIT6
#define  ADC12_LOLIMSTAT_LLS_7       BIT7
#define  ADC12_LOLIMSTAT_LLS_8       BIT8
#define  ADC12_LOLIMSTAT_LLS_9       BIT9
#define  ADC12_LOLIMSTAT_LLS_10      BIT10
#define  ADC12_LOLIMSTAT_LLS_11      BIT11
#define  ADC12_LOLIMSTAT_LLS_12      BIT12
#define  ADC12_LOLIMSTAT_LLS_13      BIT13
#define  ADC12_LOLIMSTAT_LLS_14      BIT14
#define  ADC12_LOLIMSTAT_LLS_15      BIT15

#define  ADC12_HILIMSTAT_HLS         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   High Limit Status Bits
#define  ADC12_HILIMSTAT_HLS_0       BIT0
#define  ADC12_HILIMSTAT_HLS_1       BIT1
#define  ADC12_HILIMSTAT_HLS_2       BIT2
#define  ADC12_HILIMSTAT_HLS_3       BIT3
#define  ADC12_HILIMSTAT_HLS_4       BIT4
#define  ADC12_HILIMSTAT_HLS_5       BIT5
#define  ADC12_HILIMSTAT_HLS_6       BIT6
#define  ADC12_HILIMSTAT_HLS_7       BIT7
#define  ADC12_HILIMSTAT_HLS_8       BIT8
#define  ADC12_HILIMSTAT_HLS_9       BIT9
#define  ADC12_HILIMSTAT_HLS_10      BIT10
#define  ADC12_HILIMSTAT_HLS_11      BIT11
#define  ADC12_HILIMSTAT_HLS_12      BIT12
#define  ADC12_HILIMSTAT_HLS_13      BIT13
#define  ADC12_HILIMSTAT_HLS_14      BIT14
#define  ADC12_HILIMSTAT_HLS_15      BIT15

#define  ADC12_ZXSTAT_ZCS            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Zero Crossing Status
//     0b0 ==> Either: A sign change did not occur in a comparison between the current channelx result and the previous channelx result, or Zero crossing control is disabled for channelx in the zero crossing control register, ZXCTRL
//     0b1 ==> In a comparison between the current channelx result and the previous channelx result, a sign change condition occurred as defined in the zero crossing control register (ZXCTRL)
#define  ADC12_ZXSTAT_ZCS_0          BIT0
#define  ADC12_ZXSTAT_ZCS_1          BIT1
#define  ADC12_ZXSTAT_ZCS_2          BIT2
#define  ADC12_ZXSTAT_ZCS_3          BIT3
#define  ADC12_ZXSTAT_ZCS_4          BIT4
#define  ADC12_ZXSTAT_ZCS_5          BIT5
#define  ADC12_ZXSTAT_ZCS_6          BIT6
#define  ADC12_ZXSTAT_ZCS_7          BIT7
#define  ADC12_ZXSTAT_ZCS_8          BIT8
#define  ADC12_ZXSTAT_ZCS_9          BIT9
#define  ADC12_ZXSTAT_ZCS_10         BIT10
#define  ADC12_ZXSTAT_ZCS_11         BIT11
#define  ADC12_ZXSTAT_ZCS_12         BIT12
#define  ADC12_ZXSTAT_ZCS_13         BIT13
#define  ADC12_ZXSTAT_ZCS_14         BIT14
#define  ADC12_ZXSTAT_ZCS_15         BIT15

#define  ADC12_RSLT0_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT0_RSLT_0          BIT3
#define  ADC12_RSLT0_RSLT_1          BIT4
#define  ADC12_RSLT0_RSLT_2          BIT5
#define  ADC12_RSLT0_RSLT_3          BIT6
#define  ADC12_RSLT0_RSLT_4          BIT7
#define  ADC12_RSLT0_RSLT_5          BIT8
#define  ADC12_RSLT0_RSLT_6          BIT9
#define  ADC12_RSLT0_RSLT_7          BIT10
#define  ADC12_RSLT0_RSLT_8          BIT11
#define  ADC12_RSLT0_RSLT_9          BIT12
#define  ADC12_RSLT0_RSLT_10         BIT13
#define  ADC12_RSLT0_RSLT_11         BIT14

#define  ADC12_RSLT0_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT1_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT1_RSLT_0          BIT3
#define  ADC12_RSLT1_RSLT_1          BIT4
#define  ADC12_RSLT1_RSLT_2          BIT5
#define  ADC12_RSLT1_RSLT_3          BIT6
#define  ADC12_RSLT1_RSLT_4          BIT7
#define  ADC12_RSLT1_RSLT_5          BIT8
#define  ADC12_RSLT1_RSLT_6          BIT9
#define  ADC12_RSLT1_RSLT_7          BIT10
#define  ADC12_RSLT1_RSLT_8          BIT11
#define  ADC12_RSLT1_RSLT_9          BIT12
#define  ADC12_RSLT1_RSLT_10         BIT13
#define  ADC12_RSLT1_RSLT_11         BIT14

#define  ADC12_RSLT1_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT2_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT2_RSLT_0          BIT3
#define  ADC12_RSLT2_RSLT_1          BIT4
#define  ADC12_RSLT2_RSLT_2          BIT5
#define  ADC12_RSLT2_RSLT_3          BIT6
#define  ADC12_RSLT2_RSLT_4          BIT7
#define  ADC12_RSLT2_RSLT_5          BIT8
#define  ADC12_RSLT2_RSLT_6          BIT9
#define  ADC12_RSLT2_RSLT_7          BIT10
#define  ADC12_RSLT2_RSLT_8          BIT11
#define  ADC12_RSLT2_RSLT_9          BIT12
#define  ADC12_RSLT2_RSLT_10         BIT13
#define  ADC12_RSLT2_RSLT_11         BIT14

#define  ADC12_RSLT2_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT3_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT3_RSLT_0          BIT3
#define  ADC12_RSLT3_RSLT_1          BIT4
#define  ADC12_RSLT3_RSLT_2          BIT5
#define  ADC12_RSLT3_RSLT_3          BIT6
#define  ADC12_RSLT3_RSLT_4          BIT7
#define  ADC12_RSLT3_RSLT_5          BIT8
#define  ADC12_RSLT3_RSLT_6          BIT9
#define  ADC12_RSLT3_RSLT_7          BIT10
#define  ADC12_RSLT3_RSLT_8          BIT11
#define  ADC12_RSLT3_RSLT_9          BIT12
#define  ADC12_RSLT3_RSLT_10         BIT13
#define  ADC12_RSLT3_RSLT_11         BIT14

#define  ADC12_RSLT3_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT4_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT4_RSLT_0          BIT3
#define  ADC12_RSLT4_RSLT_1          BIT4
#define  ADC12_RSLT4_RSLT_2          BIT5
#define  ADC12_RSLT4_RSLT_3          BIT6
#define  ADC12_RSLT4_RSLT_4          BIT7
#define  ADC12_RSLT4_RSLT_5          BIT8
#define  ADC12_RSLT4_RSLT_6          BIT9
#define  ADC12_RSLT4_RSLT_7          BIT10
#define  ADC12_RSLT4_RSLT_8          BIT11
#define  ADC12_RSLT4_RSLT_9          BIT12
#define  ADC12_RSLT4_RSLT_10         BIT13
#define  ADC12_RSLT4_RSLT_11         BIT14

#define  ADC12_RSLT4_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT5_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT5_RSLT_0          BIT3
#define  ADC12_RSLT5_RSLT_1          BIT4
#define  ADC12_RSLT5_RSLT_2          BIT5
#define  ADC12_RSLT5_RSLT_3          BIT6
#define  ADC12_RSLT5_RSLT_4          BIT7
#define  ADC12_RSLT5_RSLT_5          BIT8
#define  ADC12_RSLT5_RSLT_6          BIT9
#define  ADC12_RSLT5_RSLT_7          BIT10
#define  ADC12_RSLT5_RSLT_8          BIT11
#define  ADC12_RSLT5_RSLT_9          BIT12
#define  ADC12_RSLT5_RSLT_10         BIT13
#define  ADC12_RSLT5_RSLT_11         BIT14

#define  ADC12_RSLT5_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT6_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT6_RSLT_0          BIT3
#define  ADC12_RSLT6_RSLT_1          BIT4
#define  ADC12_RSLT6_RSLT_2          BIT5
#define  ADC12_RSLT6_RSLT_3          BIT6
#define  ADC12_RSLT6_RSLT_4          BIT7
#define  ADC12_RSLT6_RSLT_5          BIT8
#define  ADC12_RSLT6_RSLT_6          BIT9
#define  ADC12_RSLT6_RSLT_7          BIT10
#define  ADC12_RSLT6_RSLT_8          BIT11
#define  ADC12_RSLT6_RSLT_9          BIT12
#define  ADC12_RSLT6_RSLT_10         BIT13
#define  ADC12_RSLT6_RSLT_11         BIT14

#define  ADC12_RSLT6_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT7_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT7_RSLT_0          BIT3
#define  ADC12_RSLT7_RSLT_1          BIT4
#define  ADC12_RSLT7_RSLT_2          BIT5
#define  ADC12_RSLT7_RSLT_3          BIT6
#define  ADC12_RSLT7_RSLT_4          BIT7
#define  ADC12_RSLT7_RSLT_5          BIT8
#define  ADC12_RSLT7_RSLT_6          BIT9
#define  ADC12_RSLT7_RSLT_7          BIT10
#define  ADC12_RSLT7_RSLT_8          BIT11
#define  ADC12_RSLT7_RSLT_9          BIT12
#define  ADC12_RSLT7_RSLT_10         BIT13
#define  ADC12_RSLT7_RSLT_11         BIT14

#define  ADC12_RSLT7_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT8_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT8_RSLT_0          BIT3
#define  ADC12_RSLT8_RSLT_1          BIT4
#define  ADC12_RSLT8_RSLT_2          BIT5
#define  ADC12_RSLT8_RSLT_3          BIT6
#define  ADC12_RSLT8_RSLT_4          BIT7
#define  ADC12_RSLT8_RSLT_5          BIT8
#define  ADC12_RSLT8_RSLT_6          BIT9
#define  ADC12_RSLT8_RSLT_7          BIT10
#define  ADC12_RSLT8_RSLT_8          BIT11
#define  ADC12_RSLT8_RSLT_9          BIT12
#define  ADC12_RSLT8_RSLT_10         BIT13
#define  ADC12_RSLT8_RSLT_11         BIT14

#define  ADC12_RSLT8_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT9_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT9_RSLT_0          BIT3
#define  ADC12_RSLT9_RSLT_1          BIT4
#define  ADC12_RSLT9_RSLT_2          BIT5
#define  ADC12_RSLT9_RSLT_3          BIT6
#define  ADC12_RSLT9_RSLT_4          BIT7
#define  ADC12_RSLT9_RSLT_5          BIT8
#define  ADC12_RSLT9_RSLT_6          BIT9
#define  ADC12_RSLT9_RSLT_7          BIT10
#define  ADC12_RSLT9_RSLT_8          BIT11
#define  ADC12_RSLT9_RSLT_9          BIT12
#define  ADC12_RSLT9_RSLT_10         BIT13
#define  ADC12_RSLT9_RSLT_11         BIT14

#define  ADC12_RSLT9_SEXT            BIT15
//   Sign Extend

#define  ADC12_RSLT10_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT10_RSLT_0         BIT3
#define  ADC12_RSLT10_RSLT_1         BIT4
#define  ADC12_RSLT10_RSLT_2         BIT5
#define  ADC12_RSLT10_RSLT_3         BIT6
#define  ADC12_RSLT10_RSLT_4         BIT7
#define  ADC12_RSLT10_RSLT_5         BIT8
#define  ADC12_RSLT10_RSLT_6         BIT9
#define  ADC12_RSLT10_RSLT_7         BIT10
#define  ADC12_RSLT10_RSLT_8         BIT11
#define  ADC12_RSLT10_RSLT_9         BIT12
#define  ADC12_RSLT10_RSLT_10        BIT13
#define  ADC12_RSLT10_RSLT_11        BIT14

#define  ADC12_RSLT10_SEXT           BIT15
//   Sign Extend

#define  ADC12_RSLT11_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT11_RSLT_0         BIT3
#define  ADC12_RSLT11_RSLT_1         BIT4
#define  ADC12_RSLT11_RSLT_2         BIT5
#define  ADC12_RSLT11_RSLT_3         BIT6
#define  ADC12_RSLT11_RSLT_4         BIT7
#define  ADC12_RSLT11_RSLT_5         BIT8
#define  ADC12_RSLT11_RSLT_6         BIT9
#define  ADC12_RSLT11_RSLT_7         BIT10
#define  ADC12_RSLT11_RSLT_8         BIT11
#define  ADC12_RSLT11_RSLT_9         BIT12
#define  ADC12_RSLT11_RSLT_10        BIT13
#define  ADC12_RSLT11_RSLT_11        BIT14

#define  ADC12_RSLT11_SEXT           BIT15
//   Sign Extend

#define  ADC12_RSLT12_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT12_RSLT_0         BIT3
#define  ADC12_RSLT12_RSLT_1         BIT4
#define  ADC12_RSLT12_RSLT_2         BIT5
#define  ADC12_RSLT12_RSLT_3         BIT6
#define  ADC12_RSLT12_RSLT_4         BIT7
#define  ADC12_RSLT12_RSLT_5         BIT8
#define  ADC12_RSLT12_RSLT_6         BIT9
#define  ADC12_RSLT12_RSLT_7         BIT10
#define  ADC12_RSLT12_RSLT_8         BIT11
#define  ADC12_RSLT12_RSLT_9         BIT12
#define  ADC12_RSLT12_RSLT_10        BIT13
#define  ADC12_RSLT12_RSLT_11        BIT14

#define  ADC12_RSLT12_SEXT           BIT15
//   Sign Extend

#define  ADC12_RSLT13_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT13_RSLT_0         BIT3
#define  ADC12_RSLT13_RSLT_1         BIT4
#define  ADC12_RSLT13_RSLT_2         BIT5
#define  ADC12_RSLT13_RSLT_3         BIT6
#define  ADC12_RSLT13_RSLT_4         BIT7
#define  ADC12_RSLT13_RSLT_5         BIT8
#define  ADC12_RSLT13_RSLT_6         BIT9
#define  ADC12_RSLT13_RSLT_7         BIT10
#define  ADC12_RSLT13_RSLT_8         BIT11
#define  ADC12_RSLT13_RSLT_9         BIT12
#define  ADC12_RSLT13_RSLT_10        BIT13
#define  ADC12_RSLT13_RSLT_11        BIT14

#define  ADC12_RSLT13_SEXT           BIT15
//   Sign Extend

#define  ADC12_RSLT14_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT14_RSLT_0         BIT3
#define  ADC12_RSLT14_RSLT_1         BIT4
#define  ADC12_RSLT14_RSLT_2         BIT5
#define  ADC12_RSLT14_RSLT_3         BIT6
#define  ADC12_RSLT14_RSLT_4         BIT7
#define  ADC12_RSLT14_RSLT_5         BIT8
#define  ADC12_RSLT14_RSLT_6         BIT9
#define  ADC12_RSLT14_RSLT_7         BIT10
#define  ADC12_RSLT14_RSLT_8         BIT11
#define  ADC12_RSLT14_RSLT_9         BIT12
#define  ADC12_RSLT14_RSLT_10        BIT13
#define  ADC12_RSLT14_RSLT_11        BIT14

#define  ADC12_RSLT14_SEXT           BIT15
//   Sign Extend

#define  ADC12_RSLT15_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Digital Result of the Conversion
#define  ADC12_RSLT15_RSLT_0         BIT3
#define  ADC12_RSLT15_RSLT_1         BIT4
#define  ADC12_RSLT15_RSLT_2         BIT5
#define  ADC12_RSLT15_RSLT_3         BIT6
#define  ADC12_RSLT15_RSLT_4         BIT7
#define  ADC12_RSLT15_RSLT_5         BIT8
#define  ADC12_RSLT15_RSLT_6         BIT9
#define  ADC12_RSLT15_RSLT_7         BIT10
#define  ADC12_RSLT15_RSLT_8         BIT11
#define  ADC12_RSLT15_RSLT_9         BIT12
#define  ADC12_RSLT15_RSLT_10        BIT13
#define  ADC12_RSLT15_RSLT_11        BIT14

#define  ADC12_RSLT15_SEXT           BIT15
//   Sign Extend

#define  ADC12_LOLIM0_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM0_LLMT_0         BIT3
#define  ADC12_LOLIM0_LLMT_1         BIT4
#define  ADC12_LOLIM0_LLMT_2         BIT5
#define  ADC12_LOLIM0_LLMT_3         BIT6
#define  ADC12_LOLIM0_LLMT_4         BIT7
#define  ADC12_LOLIM0_LLMT_5         BIT8
#define  ADC12_LOLIM0_LLMT_6         BIT9
#define  ADC12_LOLIM0_LLMT_7         BIT10
#define  ADC12_LOLIM0_LLMT_8         BIT11
#define  ADC12_LOLIM0_LLMT_9         BIT12
#define  ADC12_LOLIM0_LLMT_10        BIT13
#define  ADC12_LOLIM0_LLMT_11        BIT14

#define  ADC12_LOLIM1_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM1_LLMT_0         BIT3
#define  ADC12_LOLIM1_LLMT_1         BIT4
#define  ADC12_LOLIM1_LLMT_2         BIT5
#define  ADC12_LOLIM1_LLMT_3         BIT6
#define  ADC12_LOLIM1_LLMT_4         BIT7
#define  ADC12_LOLIM1_LLMT_5         BIT8
#define  ADC12_LOLIM1_LLMT_6         BIT9
#define  ADC12_LOLIM1_LLMT_7         BIT10
#define  ADC12_LOLIM1_LLMT_8         BIT11
#define  ADC12_LOLIM1_LLMT_9         BIT12
#define  ADC12_LOLIM1_LLMT_10        BIT13
#define  ADC12_LOLIM1_LLMT_11        BIT14

#define  ADC12_LOLIM2_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM2_LLMT_0         BIT3
#define  ADC12_LOLIM2_LLMT_1         BIT4
#define  ADC12_LOLIM2_LLMT_2         BIT5
#define  ADC12_LOLIM2_LLMT_3         BIT6
#define  ADC12_LOLIM2_LLMT_4         BIT7
#define  ADC12_LOLIM2_LLMT_5         BIT8
#define  ADC12_LOLIM2_LLMT_6         BIT9
#define  ADC12_LOLIM2_LLMT_7         BIT10
#define  ADC12_LOLIM2_LLMT_8         BIT11
#define  ADC12_LOLIM2_LLMT_9         BIT12
#define  ADC12_LOLIM2_LLMT_10        BIT13
#define  ADC12_LOLIM2_LLMT_11        BIT14

#define  ADC12_LOLIM3_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM3_LLMT_0         BIT3
#define  ADC12_LOLIM3_LLMT_1         BIT4
#define  ADC12_LOLIM3_LLMT_2         BIT5
#define  ADC12_LOLIM3_LLMT_3         BIT6
#define  ADC12_LOLIM3_LLMT_4         BIT7
#define  ADC12_LOLIM3_LLMT_5         BIT8
#define  ADC12_LOLIM3_LLMT_6         BIT9
#define  ADC12_LOLIM3_LLMT_7         BIT10
#define  ADC12_LOLIM3_LLMT_8         BIT11
#define  ADC12_LOLIM3_LLMT_9         BIT12
#define  ADC12_LOLIM3_LLMT_10        BIT13
#define  ADC12_LOLIM3_LLMT_11        BIT14

#define  ADC12_LOLIM4_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM4_LLMT_0         BIT3
#define  ADC12_LOLIM4_LLMT_1         BIT4
#define  ADC12_LOLIM4_LLMT_2         BIT5
#define  ADC12_LOLIM4_LLMT_3         BIT6
#define  ADC12_LOLIM4_LLMT_4         BIT7
#define  ADC12_LOLIM4_LLMT_5         BIT8
#define  ADC12_LOLIM4_LLMT_6         BIT9
#define  ADC12_LOLIM4_LLMT_7         BIT10
#define  ADC12_LOLIM4_LLMT_8         BIT11
#define  ADC12_LOLIM4_LLMT_9         BIT12
#define  ADC12_LOLIM4_LLMT_10        BIT13
#define  ADC12_LOLIM4_LLMT_11        BIT14

#define  ADC12_LOLIM5_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM5_LLMT_0         BIT3
#define  ADC12_LOLIM5_LLMT_1         BIT4
#define  ADC12_LOLIM5_LLMT_2         BIT5
#define  ADC12_LOLIM5_LLMT_3         BIT6
#define  ADC12_LOLIM5_LLMT_4         BIT7
#define  ADC12_LOLIM5_LLMT_5         BIT8
#define  ADC12_LOLIM5_LLMT_6         BIT9
#define  ADC12_LOLIM5_LLMT_7         BIT10
#define  ADC12_LOLIM5_LLMT_8         BIT11
#define  ADC12_LOLIM5_LLMT_9         BIT12
#define  ADC12_LOLIM5_LLMT_10        BIT13
#define  ADC12_LOLIM5_LLMT_11        BIT14

#define  ADC12_LOLIM6_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM6_LLMT_0         BIT3
#define  ADC12_LOLIM6_LLMT_1         BIT4
#define  ADC12_LOLIM6_LLMT_2         BIT5
#define  ADC12_LOLIM6_LLMT_3         BIT6
#define  ADC12_LOLIM6_LLMT_4         BIT7
#define  ADC12_LOLIM6_LLMT_5         BIT8
#define  ADC12_LOLIM6_LLMT_6         BIT9
#define  ADC12_LOLIM6_LLMT_7         BIT10
#define  ADC12_LOLIM6_LLMT_8         BIT11
#define  ADC12_LOLIM6_LLMT_9         BIT12
#define  ADC12_LOLIM6_LLMT_10        BIT13
#define  ADC12_LOLIM6_LLMT_11        BIT14

#define  ADC12_LOLIM7_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM7_LLMT_0         BIT3
#define  ADC12_LOLIM7_LLMT_1         BIT4
#define  ADC12_LOLIM7_LLMT_2         BIT5
#define  ADC12_LOLIM7_LLMT_3         BIT6
#define  ADC12_LOLIM7_LLMT_4         BIT7
#define  ADC12_LOLIM7_LLMT_5         BIT8
#define  ADC12_LOLIM7_LLMT_6         BIT9
#define  ADC12_LOLIM7_LLMT_7         BIT10
#define  ADC12_LOLIM7_LLMT_8         BIT11
#define  ADC12_LOLIM7_LLMT_9         BIT12
#define  ADC12_LOLIM7_LLMT_10        BIT13
#define  ADC12_LOLIM7_LLMT_11        BIT14

#define  ADC12_LOLIM8_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM8_LLMT_0         BIT3
#define  ADC12_LOLIM8_LLMT_1         BIT4
#define  ADC12_LOLIM8_LLMT_2         BIT5
#define  ADC12_LOLIM8_LLMT_3         BIT6
#define  ADC12_LOLIM8_LLMT_4         BIT7
#define  ADC12_LOLIM8_LLMT_5         BIT8
#define  ADC12_LOLIM8_LLMT_6         BIT9
#define  ADC12_LOLIM8_LLMT_7         BIT10
#define  ADC12_LOLIM8_LLMT_8         BIT11
#define  ADC12_LOLIM8_LLMT_9         BIT12
#define  ADC12_LOLIM8_LLMT_10        BIT13
#define  ADC12_LOLIM8_LLMT_11        BIT14

#define  ADC12_LOLIM9_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM9_LLMT_0         BIT3
#define  ADC12_LOLIM9_LLMT_1         BIT4
#define  ADC12_LOLIM9_LLMT_2         BIT5
#define  ADC12_LOLIM9_LLMT_3         BIT6
#define  ADC12_LOLIM9_LLMT_4         BIT7
#define  ADC12_LOLIM9_LLMT_5         BIT8
#define  ADC12_LOLIM9_LLMT_6         BIT9
#define  ADC12_LOLIM9_LLMT_7         BIT10
#define  ADC12_LOLIM9_LLMT_8         BIT11
#define  ADC12_LOLIM9_LLMT_9         BIT12
#define  ADC12_LOLIM9_LLMT_10        BIT13
#define  ADC12_LOLIM9_LLMT_11        BIT14

#define  ADC12_LOLIM10_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM10_LLMT_0        BIT3
#define  ADC12_LOLIM10_LLMT_1        BIT4
#define  ADC12_LOLIM10_LLMT_2        BIT5
#define  ADC12_LOLIM10_LLMT_3        BIT6
#define  ADC12_LOLIM10_LLMT_4        BIT7
#define  ADC12_LOLIM10_LLMT_5        BIT8
#define  ADC12_LOLIM10_LLMT_6        BIT9
#define  ADC12_LOLIM10_LLMT_7        BIT10
#define  ADC12_LOLIM10_LLMT_8        BIT11
#define  ADC12_LOLIM10_LLMT_9        BIT12
#define  ADC12_LOLIM10_LLMT_10       BIT13
#define  ADC12_LOLIM10_LLMT_11       BIT14

#define  ADC12_LOLIM11_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM11_LLMT_0        BIT3
#define  ADC12_LOLIM11_LLMT_1        BIT4
#define  ADC12_LOLIM11_LLMT_2        BIT5
#define  ADC12_LOLIM11_LLMT_3        BIT6
#define  ADC12_LOLIM11_LLMT_4        BIT7
#define  ADC12_LOLIM11_LLMT_5        BIT8
#define  ADC12_LOLIM11_LLMT_6        BIT9
#define  ADC12_LOLIM11_LLMT_7        BIT10
#define  ADC12_LOLIM11_LLMT_8        BIT11
#define  ADC12_LOLIM11_LLMT_9        BIT12
#define  ADC12_LOLIM11_LLMT_10       BIT13
#define  ADC12_LOLIM11_LLMT_11       BIT14

#define  ADC12_LOLIM12_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM12_LLMT_0        BIT3
#define  ADC12_LOLIM12_LLMT_1        BIT4
#define  ADC12_LOLIM12_LLMT_2        BIT5
#define  ADC12_LOLIM12_LLMT_3        BIT6
#define  ADC12_LOLIM12_LLMT_4        BIT7
#define  ADC12_LOLIM12_LLMT_5        BIT8
#define  ADC12_LOLIM12_LLMT_6        BIT9
#define  ADC12_LOLIM12_LLMT_7        BIT10
#define  ADC12_LOLIM12_LLMT_8        BIT11
#define  ADC12_LOLIM12_LLMT_9        BIT12
#define  ADC12_LOLIM12_LLMT_10       BIT13
#define  ADC12_LOLIM12_LLMT_11       BIT14

#define  ADC12_LOLIM13_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM13_LLMT_0        BIT3
#define  ADC12_LOLIM13_LLMT_1        BIT4
#define  ADC12_LOLIM13_LLMT_2        BIT5
#define  ADC12_LOLIM13_LLMT_3        BIT6
#define  ADC12_LOLIM13_LLMT_4        BIT7
#define  ADC12_LOLIM13_LLMT_5        BIT8
#define  ADC12_LOLIM13_LLMT_6        BIT9
#define  ADC12_LOLIM13_LLMT_7        BIT10
#define  ADC12_LOLIM13_LLMT_8        BIT11
#define  ADC12_LOLIM13_LLMT_9        BIT12
#define  ADC12_LOLIM13_LLMT_10       BIT13
#define  ADC12_LOLIM13_LLMT_11       BIT14

#define  ADC12_LOLIM14_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM14_LLMT_0        BIT3
#define  ADC12_LOLIM14_LLMT_1        BIT4
#define  ADC12_LOLIM14_LLMT_2        BIT5
#define  ADC12_LOLIM14_LLMT_3        BIT6
#define  ADC12_LOLIM14_LLMT_4        BIT7
#define  ADC12_LOLIM14_LLMT_5        BIT8
#define  ADC12_LOLIM14_LLMT_6        BIT9
#define  ADC12_LOLIM14_LLMT_7        BIT10
#define  ADC12_LOLIM14_LLMT_8        BIT11
#define  ADC12_LOLIM14_LLMT_9        BIT12
#define  ADC12_LOLIM14_LLMT_10       BIT13
#define  ADC12_LOLIM14_LLMT_11       BIT14

#define  ADC12_LOLIM15_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Low Limit Bits
#define  ADC12_LOLIM15_LLMT_0        BIT3
#define  ADC12_LOLIM15_LLMT_1        BIT4
#define  ADC12_LOLIM15_LLMT_2        BIT5
#define  ADC12_LOLIM15_LLMT_3        BIT6
#define  ADC12_LOLIM15_LLMT_4        BIT7
#define  ADC12_LOLIM15_LLMT_5        BIT8
#define  ADC12_LOLIM15_LLMT_6        BIT9
#define  ADC12_LOLIM15_LLMT_7        BIT10
#define  ADC12_LOLIM15_LLMT_8        BIT11
#define  ADC12_LOLIM15_LLMT_9        BIT12
#define  ADC12_LOLIM15_LLMT_10       BIT13
#define  ADC12_LOLIM15_LLMT_11       BIT14

#define  ADC12_HILIM0_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM0_HLMT_0         BIT3
#define  ADC12_HILIM0_HLMT_1         BIT4
#define  ADC12_HILIM0_HLMT_2         BIT5
#define  ADC12_HILIM0_HLMT_3         BIT6
#define  ADC12_HILIM0_HLMT_4         BIT7
#define  ADC12_HILIM0_HLMT_5         BIT8
#define  ADC12_HILIM0_HLMT_6         BIT9
#define  ADC12_HILIM0_HLMT_7         BIT10
#define  ADC12_HILIM0_HLMT_8         BIT11
#define  ADC12_HILIM0_HLMT_9         BIT12
#define  ADC12_HILIM0_HLMT_10        BIT13
#define  ADC12_HILIM0_HLMT_11        BIT14

#define  ADC12_HILIM1_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM1_HLMT_0         BIT3
#define  ADC12_HILIM1_HLMT_1         BIT4
#define  ADC12_HILIM1_HLMT_2         BIT5
#define  ADC12_HILIM1_HLMT_3         BIT6
#define  ADC12_HILIM1_HLMT_4         BIT7
#define  ADC12_HILIM1_HLMT_5         BIT8
#define  ADC12_HILIM1_HLMT_6         BIT9
#define  ADC12_HILIM1_HLMT_7         BIT10
#define  ADC12_HILIM1_HLMT_8         BIT11
#define  ADC12_HILIM1_HLMT_9         BIT12
#define  ADC12_HILIM1_HLMT_10        BIT13
#define  ADC12_HILIM1_HLMT_11        BIT14

#define  ADC12_HILIM2_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM2_HLMT_0         BIT3
#define  ADC12_HILIM2_HLMT_1         BIT4
#define  ADC12_HILIM2_HLMT_2         BIT5
#define  ADC12_HILIM2_HLMT_3         BIT6
#define  ADC12_HILIM2_HLMT_4         BIT7
#define  ADC12_HILIM2_HLMT_5         BIT8
#define  ADC12_HILIM2_HLMT_6         BIT9
#define  ADC12_HILIM2_HLMT_7         BIT10
#define  ADC12_HILIM2_HLMT_8         BIT11
#define  ADC12_HILIM2_HLMT_9         BIT12
#define  ADC12_HILIM2_HLMT_10        BIT13
#define  ADC12_HILIM2_HLMT_11        BIT14

#define  ADC12_HILIM3_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM3_HLMT_0         BIT3
#define  ADC12_HILIM3_HLMT_1         BIT4
#define  ADC12_HILIM3_HLMT_2         BIT5
#define  ADC12_HILIM3_HLMT_3         BIT6
#define  ADC12_HILIM3_HLMT_4         BIT7
#define  ADC12_HILIM3_HLMT_5         BIT8
#define  ADC12_HILIM3_HLMT_6         BIT9
#define  ADC12_HILIM3_HLMT_7         BIT10
#define  ADC12_HILIM3_HLMT_8         BIT11
#define  ADC12_HILIM3_HLMT_9         BIT12
#define  ADC12_HILIM3_HLMT_10        BIT13
#define  ADC12_HILIM3_HLMT_11        BIT14

#define  ADC12_HILIM4_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM4_HLMT_0         BIT3
#define  ADC12_HILIM4_HLMT_1         BIT4
#define  ADC12_HILIM4_HLMT_2         BIT5
#define  ADC12_HILIM4_HLMT_3         BIT6
#define  ADC12_HILIM4_HLMT_4         BIT7
#define  ADC12_HILIM4_HLMT_5         BIT8
#define  ADC12_HILIM4_HLMT_6         BIT9
#define  ADC12_HILIM4_HLMT_7         BIT10
#define  ADC12_HILIM4_HLMT_8         BIT11
#define  ADC12_HILIM4_HLMT_9         BIT12
#define  ADC12_HILIM4_HLMT_10        BIT13
#define  ADC12_HILIM4_HLMT_11        BIT14

#define  ADC12_HILIM5_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM5_HLMT_0         BIT3
#define  ADC12_HILIM5_HLMT_1         BIT4
#define  ADC12_HILIM5_HLMT_2         BIT5
#define  ADC12_HILIM5_HLMT_3         BIT6
#define  ADC12_HILIM5_HLMT_4         BIT7
#define  ADC12_HILIM5_HLMT_5         BIT8
#define  ADC12_HILIM5_HLMT_6         BIT9
#define  ADC12_HILIM5_HLMT_7         BIT10
#define  ADC12_HILIM5_HLMT_8         BIT11
#define  ADC12_HILIM5_HLMT_9         BIT12
#define  ADC12_HILIM5_HLMT_10        BIT13
#define  ADC12_HILIM5_HLMT_11        BIT14

#define  ADC12_HILIM6_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM6_HLMT_0         BIT3
#define  ADC12_HILIM6_HLMT_1         BIT4
#define  ADC12_HILIM6_HLMT_2         BIT5
#define  ADC12_HILIM6_HLMT_3         BIT6
#define  ADC12_HILIM6_HLMT_4         BIT7
#define  ADC12_HILIM6_HLMT_5         BIT8
#define  ADC12_HILIM6_HLMT_6         BIT9
#define  ADC12_HILIM6_HLMT_7         BIT10
#define  ADC12_HILIM6_HLMT_8         BIT11
#define  ADC12_HILIM6_HLMT_9         BIT12
#define  ADC12_HILIM6_HLMT_10        BIT13
#define  ADC12_HILIM6_HLMT_11        BIT14

#define  ADC12_HILIM7_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM7_HLMT_0         BIT3
#define  ADC12_HILIM7_HLMT_1         BIT4
#define  ADC12_HILIM7_HLMT_2         BIT5
#define  ADC12_HILIM7_HLMT_3         BIT6
#define  ADC12_HILIM7_HLMT_4         BIT7
#define  ADC12_HILIM7_HLMT_5         BIT8
#define  ADC12_HILIM7_HLMT_6         BIT9
#define  ADC12_HILIM7_HLMT_7         BIT10
#define  ADC12_HILIM7_HLMT_8         BIT11
#define  ADC12_HILIM7_HLMT_9         BIT12
#define  ADC12_HILIM7_HLMT_10        BIT13
#define  ADC12_HILIM7_HLMT_11        BIT14

#define  ADC12_HILIM8_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM8_HLMT_0         BIT3
#define  ADC12_HILIM8_HLMT_1         BIT4
#define  ADC12_HILIM8_HLMT_2         BIT5
#define  ADC12_HILIM8_HLMT_3         BIT6
#define  ADC12_HILIM8_HLMT_4         BIT7
#define  ADC12_HILIM8_HLMT_5         BIT8
#define  ADC12_HILIM8_HLMT_6         BIT9
#define  ADC12_HILIM8_HLMT_7         BIT10
#define  ADC12_HILIM8_HLMT_8         BIT11
#define  ADC12_HILIM8_HLMT_9         BIT12
#define  ADC12_HILIM8_HLMT_10        BIT13
#define  ADC12_HILIM8_HLMT_11        BIT14

#define  ADC12_HILIM9_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM9_HLMT_0         BIT3
#define  ADC12_HILIM9_HLMT_1         BIT4
#define  ADC12_HILIM9_HLMT_2         BIT5
#define  ADC12_HILIM9_HLMT_3         BIT6
#define  ADC12_HILIM9_HLMT_4         BIT7
#define  ADC12_HILIM9_HLMT_5         BIT8
#define  ADC12_HILIM9_HLMT_6         BIT9
#define  ADC12_HILIM9_HLMT_7         BIT10
#define  ADC12_HILIM9_HLMT_8         BIT11
#define  ADC12_HILIM9_HLMT_9         BIT12
#define  ADC12_HILIM9_HLMT_10        BIT13
#define  ADC12_HILIM9_HLMT_11        BIT14

#define  ADC12_HILIM10_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM10_HLMT_0        BIT3
#define  ADC12_HILIM10_HLMT_1        BIT4
#define  ADC12_HILIM10_HLMT_2        BIT5
#define  ADC12_HILIM10_HLMT_3        BIT6
#define  ADC12_HILIM10_HLMT_4        BIT7
#define  ADC12_HILIM10_HLMT_5        BIT8
#define  ADC12_HILIM10_HLMT_6        BIT9
#define  ADC12_HILIM10_HLMT_7        BIT10
#define  ADC12_HILIM10_HLMT_8        BIT11
#define  ADC12_HILIM10_HLMT_9        BIT12
#define  ADC12_HILIM10_HLMT_10       BIT13
#define  ADC12_HILIM10_HLMT_11       BIT14

#define  ADC12_HILIM11_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM11_HLMT_0        BIT3
#define  ADC12_HILIM11_HLMT_1        BIT4
#define  ADC12_HILIM11_HLMT_2        BIT5
#define  ADC12_HILIM11_HLMT_3        BIT6
#define  ADC12_HILIM11_HLMT_4        BIT7
#define  ADC12_HILIM11_HLMT_5        BIT8
#define  ADC12_HILIM11_HLMT_6        BIT9
#define  ADC12_HILIM11_HLMT_7        BIT10
#define  ADC12_HILIM11_HLMT_8        BIT11
#define  ADC12_HILIM11_HLMT_9        BIT12
#define  ADC12_HILIM11_HLMT_10       BIT13
#define  ADC12_HILIM11_HLMT_11       BIT14

#define  ADC12_HILIM12_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM12_HLMT_0        BIT3
#define  ADC12_HILIM12_HLMT_1        BIT4
#define  ADC12_HILIM12_HLMT_2        BIT5
#define  ADC12_HILIM12_HLMT_3        BIT6
#define  ADC12_HILIM12_HLMT_4        BIT7
#define  ADC12_HILIM12_HLMT_5        BIT8
#define  ADC12_HILIM12_HLMT_6        BIT9
#define  ADC12_HILIM12_HLMT_7        BIT10
#define  ADC12_HILIM12_HLMT_8        BIT11
#define  ADC12_HILIM12_HLMT_9        BIT12
#define  ADC12_HILIM12_HLMT_10       BIT13
#define  ADC12_HILIM12_HLMT_11       BIT14

#define  ADC12_HILIM13_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM13_HLMT_0        BIT3
#define  ADC12_HILIM13_HLMT_1        BIT4
#define  ADC12_HILIM13_HLMT_2        BIT5
#define  ADC12_HILIM13_HLMT_3        BIT6
#define  ADC12_HILIM13_HLMT_4        BIT7
#define  ADC12_HILIM13_HLMT_5        BIT8
#define  ADC12_HILIM13_HLMT_6        BIT9
#define  ADC12_HILIM13_HLMT_7        BIT10
#define  ADC12_HILIM13_HLMT_8        BIT11
#define  ADC12_HILIM13_HLMT_9        BIT12
#define  ADC12_HILIM13_HLMT_10       BIT13
#define  ADC12_HILIM13_HLMT_11       BIT14

#define  ADC12_HILIM14_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM14_HLMT_0        BIT3
#define  ADC12_HILIM14_HLMT_1        BIT4
#define  ADC12_HILIM14_HLMT_2        BIT5
#define  ADC12_HILIM14_HLMT_3        BIT6
#define  ADC12_HILIM14_HLMT_4        BIT7
#define  ADC12_HILIM14_HLMT_5        BIT8
#define  ADC12_HILIM14_HLMT_6        BIT9
#define  ADC12_HILIM14_HLMT_7        BIT10
#define  ADC12_HILIM14_HLMT_8        BIT11
#define  ADC12_HILIM14_HLMT_9        BIT12
#define  ADC12_HILIM14_HLMT_10       BIT13
#define  ADC12_HILIM14_HLMT_11       BIT14

#define  ADC12_HILIM15_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   High Limit Bits
#define  ADC12_HILIM15_HLMT_0        BIT3
#define  ADC12_HILIM15_HLMT_1        BIT4
#define  ADC12_HILIM15_HLMT_2        BIT5
#define  ADC12_HILIM15_HLMT_3        BIT6
#define  ADC12_HILIM15_HLMT_4        BIT7
#define  ADC12_HILIM15_HLMT_5        BIT8
#define  ADC12_HILIM15_HLMT_6        BIT9
#define  ADC12_HILIM15_HLMT_7        BIT10
#define  ADC12_HILIM15_HLMT_8        BIT11
#define  ADC12_HILIM15_HLMT_9        BIT12
#define  ADC12_HILIM15_HLMT_10       BIT13
#define  ADC12_HILIM15_HLMT_11       BIT14

#define  ADC12_OFFST0_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST0_OFFSET_0       BIT3
#define  ADC12_OFFST0_OFFSET_1       BIT4
#define  ADC12_OFFST0_OFFSET_2       BIT5
#define  ADC12_OFFST0_OFFSET_3       BIT6
#define  ADC12_OFFST0_OFFSET_4       BIT7
#define  ADC12_OFFST0_OFFSET_5       BIT8
#define  ADC12_OFFST0_OFFSET_6       BIT9
#define  ADC12_OFFST0_OFFSET_7       BIT10
#define  ADC12_OFFST0_OFFSET_8       BIT11
#define  ADC12_OFFST0_OFFSET_9       BIT12
#define  ADC12_OFFST0_OFFSET_10      BIT13
#define  ADC12_OFFST0_OFFSET_11      BIT14

#define  ADC12_OFFST1_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST1_OFFSET_0       BIT3
#define  ADC12_OFFST1_OFFSET_1       BIT4
#define  ADC12_OFFST1_OFFSET_2       BIT5
#define  ADC12_OFFST1_OFFSET_3       BIT6
#define  ADC12_OFFST1_OFFSET_4       BIT7
#define  ADC12_OFFST1_OFFSET_5       BIT8
#define  ADC12_OFFST1_OFFSET_6       BIT9
#define  ADC12_OFFST1_OFFSET_7       BIT10
#define  ADC12_OFFST1_OFFSET_8       BIT11
#define  ADC12_OFFST1_OFFSET_9       BIT12
#define  ADC12_OFFST1_OFFSET_10      BIT13
#define  ADC12_OFFST1_OFFSET_11      BIT14

#define  ADC12_OFFST2_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST2_OFFSET_0       BIT3
#define  ADC12_OFFST2_OFFSET_1       BIT4
#define  ADC12_OFFST2_OFFSET_2       BIT5
#define  ADC12_OFFST2_OFFSET_3       BIT6
#define  ADC12_OFFST2_OFFSET_4       BIT7
#define  ADC12_OFFST2_OFFSET_5       BIT8
#define  ADC12_OFFST2_OFFSET_6       BIT9
#define  ADC12_OFFST2_OFFSET_7       BIT10
#define  ADC12_OFFST2_OFFSET_8       BIT11
#define  ADC12_OFFST2_OFFSET_9       BIT12
#define  ADC12_OFFST2_OFFSET_10      BIT13
#define  ADC12_OFFST2_OFFSET_11      BIT14

#define  ADC12_OFFST3_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST3_OFFSET_0       BIT3
#define  ADC12_OFFST3_OFFSET_1       BIT4
#define  ADC12_OFFST3_OFFSET_2       BIT5
#define  ADC12_OFFST3_OFFSET_3       BIT6
#define  ADC12_OFFST3_OFFSET_4       BIT7
#define  ADC12_OFFST3_OFFSET_5       BIT8
#define  ADC12_OFFST3_OFFSET_6       BIT9
#define  ADC12_OFFST3_OFFSET_7       BIT10
#define  ADC12_OFFST3_OFFSET_8       BIT11
#define  ADC12_OFFST3_OFFSET_9       BIT12
#define  ADC12_OFFST3_OFFSET_10      BIT13
#define  ADC12_OFFST3_OFFSET_11      BIT14

#define  ADC12_OFFST4_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST4_OFFSET_0       BIT3
#define  ADC12_OFFST4_OFFSET_1       BIT4
#define  ADC12_OFFST4_OFFSET_2       BIT5
#define  ADC12_OFFST4_OFFSET_3       BIT6
#define  ADC12_OFFST4_OFFSET_4       BIT7
#define  ADC12_OFFST4_OFFSET_5       BIT8
#define  ADC12_OFFST4_OFFSET_6       BIT9
#define  ADC12_OFFST4_OFFSET_7       BIT10
#define  ADC12_OFFST4_OFFSET_8       BIT11
#define  ADC12_OFFST4_OFFSET_9       BIT12
#define  ADC12_OFFST4_OFFSET_10      BIT13
#define  ADC12_OFFST4_OFFSET_11      BIT14

#define  ADC12_OFFST5_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST5_OFFSET_0       BIT3
#define  ADC12_OFFST5_OFFSET_1       BIT4
#define  ADC12_OFFST5_OFFSET_2       BIT5
#define  ADC12_OFFST5_OFFSET_3       BIT6
#define  ADC12_OFFST5_OFFSET_4       BIT7
#define  ADC12_OFFST5_OFFSET_5       BIT8
#define  ADC12_OFFST5_OFFSET_6       BIT9
#define  ADC12_OFFST5_OFFSET_7       BIT10
#define  ADC12_OFFST5_OFFSET_8       BIT11
#define  ADC12_OFFST5_OFFSET_9       BIT12
#define  ADC12_OFFST5_OFFSET_10      BIT13
#define  ADC12_OFFST5_OFFSET_11      BIT14

#define  ADC12_OFFST6_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST6_OFFSET_0       BIT3
#define  ADC12_OFFST6_OFFSET_1       BIT4
#define  ADC12_OFFST6_OFFSET_2       BIT5
#define  ADC12_OFFST6_OFFSET_3       BIT6
#define  ADC12_OFFST6_OFFSET_4       BIT7
#define  ADC12_OFFST6_OFFSET_5       BIT8
#define  ADC12_OFFST6_OFFSET_6       BIT9
#define  ADC12_OFFST6_OFFSET_7       BIT10
#define  ADC12_OFFST6_OFFSET_8       BIT11
#define  ADC12_OFFST6_OFFSET_9       BIT12
#define  ADC12_OFFST6_OFFSET_10      BIT13
#define  ADC12_OFFST6_OFFSET_11      BIT14

#define  ADC12_OFFST7_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST7_OFFSET_0       BIT3
#define  ADC12_OFFST7_OFFSET_1       BIT4
#define  ADC12_OFFST7_OFFSET_2       BIT5
#define  ADC12_OFFST7_OFFSET_3       BIT6
#define  ADC12_OFFST7_OFFSET_4       BIT7
#define  ADC12_OFFST7_OFFSET_5       BIT8
#define  ADC12_OFFST7_OFFSET_6       BIT9
#define  ADC12_OFFST7_OFFSET_7       BIT10
#define  ADC12_OFFST7_OFFSET_8       BIT11
#define  ADC12_OFFST7_OFFSET_9       BIT12
#define  ADC12_OFFST7_OFFSET_10      BIT13
#define  ADC12_OFFST7_OFFSET_11      BIT14

#define  ADC12_OFFST8_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST8_OFFSET_0       BIT3
#define  ADC12_OFFST8_OFFSET_1       BIT4
#define  ADC12_OFFST8_OFFSET_2       BIT5
#define  ADC12_OFFST8_OFFSET_3       BIT6
#define  ADC12_OFFST8_OFFSET_4       BIT7
#define  ADC12_OFFST8_OFFSET_5       BIT8
#define  ADC12_OFFST8_OFFSET_6       BIT9
#define  ADC12_OFFST8_OFFSET_7       BIT10
#define  ADC12_OFFST8_OFFSET_8       BIT11
#define  ADC12_OFFST8_OFFSET_9       BIT12
#define  ADC12_OFFST8_OFFSET_10      BIT13
#define  ADC12_OFFST8_OFFSET_11      BIT14

#define  ADC12_OFFST9_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST9_OFFSET_0       BIT3
#define  ADC12_OFFST9_OFFSET_1       BIT4
#define  ADC12_OFFST9_OFFSET_2       BIT5
#define  ADC12_OFFST9_OFFSET_3       BIT6
#define  ADC12_OFFST9_OFFSET_4       BIT7
#define  ADC12_OFFST9_OFFSET_5       BIT8
#define  ADC12_OFFST9_OFFSET_6       BIT9
#define  ADC12_OFFST9_OFFSET_7       BIT10
#define  ADC12_OFFST9_OFFSET_8       BIT11
#define  ADC12_OFFST9_OFFSET_9       BIT12
#define  ADC12_OFFST9_OFFSET_10      BIT13
#define  ADC12_OFFST9_OFFSET_11      BIT14

#define  ADC12_OFFST10_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST10_OFFSET_0      BIT3
#define  ADC12_OFFST10_OFFSET_1      BIT4
#define  ADC12_OFFST10_OFFSET_2      BIT5
#define  ADC12_OFFST10_OFFSET_3      BIT6
#define  ADC12_OFFST10_OFFSET_4      BIT7
#define  ADC12_OFFST10_OFFSET_5      BIT8
#define  ADC12_OFFST10_OFFSET_6      BIT9
#define  ADC12_OFFST10_OFFSET_7      BIT10
#define  ADC12_OFFST10_OFFSET_8      BIT11
#define  ADC12_OFFST10_OFFSET_9      BIT12
#define  ADC12_OFFST10_OFFSET_10     BIT13
#define  ADC12_OFFST10_OFFSET_11     BIT14

#define  ADC12_OFFST11_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST11_OFFSET_0      BIT3
#define  ADC12_OFFST11_OFFSET_1      BIT4
#define  ADC12_OFFST11_OFFSET_2      BIT5
#define  ADC12_OFFST11_OFFSET_3      BIT6
#define  ADC12_OFFST11_OFFSET_4      BIT7
#define  ADC12_OFFST11_OFFSET_5      BIT8
#define  ADC12_OFFST11_OFFSET_6      BIT9
#define  ADC12_OFFST11_OFFSET_7      BIT10
#define  ADC12_OFFST11_OFFSET_8      BIT11
#define  ADC12_OFFST11_OFFSET_9      BIT12
#define  ADC12_OFFST11_OFFSET_10     BIT13
#define  ADC12_OFFST11_OFFSET_11     BIT14

#define  ADC12_OFFST12_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST12_OFFSET_0      BIT3
#define  ADC12_OFFST12_OFFSET_1      BIT4
#define  ADC12_OFFST12_OFFSET_2      BIT5
#define  ADC12_OFFST12_OFFSET_3      BIT6
#define  ADC12_OFFST12_OFFSET_4      BIT7
#define  ADC12_OFFST12_OFFSET_5      BIT8
#define  ADC12_OFFST12_OFFSET_6      BIT9
#define  ADC12_OFFST12_OFFSET_7      BIT10
#define  ADC12_OFFST12_OFFSET_8      BIT11
#define  ADC12_OFFST12_OFFSET_9      BIT12
#define  ADC12_OFFST12_OFFSET_10     BIT13
#define  ADC12_OFFST12_OFFSET_11     BIT14

#define  ADC12_OFFST13_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST13_OFFSET_0      BIT3
#define  ADC12_OFFST13_OFFSET_1      BIT4
#define  ADC12_OFFST13_OFFSET_2      BIT5
#define  ADC12_OFFST13_OFFSET_3      BIT6
#define  ADC12_OFFST13_OFFSET_4      BIT7
#define  ADC12_OFFST13_OFFSET_5      BIT8
#define  ADC12_OFFST13_OFFSET_6      BIT9
#define  ADC12_OFFST13_OFFSET_7      BIT10
#define  ADC12_OFFST13_OFFSET_8      BIT11
#define  ADC12_OFFST13_OFFSET_9      BIT12
#define  ADC12_OFFST13_OFFSET_10     BIT13
#define  ADC12_OFFST13_OFFSET_11     BIT14

#define  ADC12_OFFST14_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST14_OFFSET_0      BIT3
#define  ADC12_OFFST14_OFFSET_1      BIT4
#define  ADC12_OFFST14_OFFSET_2      BIT5
#define  ADC12_OFFST14_OFFSET_3      BIT6
#define  ADC12_OFFST14_OFFSET_4      BIT7
#define  ADC12_OFFST14_OFFSET_5      BIT8
#define  ADC12_OFFST14_OFFSET_6      BIT9
#define  ADC12_OFFST14_OFFSET_7      BIT10
#define  ADC12_OFFST14_OFFSET_8      BIT11
#define  ADC12_OFFST14_OFFSET_9      BIT12
#define  ADC12_OFFST14_OFFSET_10     BIT13
#define  ADC12_OFFST14_OFFSET_11     BIT14

#define  ADC12_OFFST15_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   ADC Offset Bits
#define  ADC12_OFFST15_OFFSET_0      BIT3
#define  ADC12_OFFST15_OFFSET_1      BIT4
#define  ADC12_OFFST15_OFFSET_2      BIT5
#define  ADC12_OFFST15_OFFSET_3      BIT6
#define  ADC12_OFFST15_OFFSET_4      BIT7
#define  ADC12_OFFST15_OFFSET_5      BIT8
#define  ADC12_OFFST15_OFFSET_6      BIT9
#define  ADC12_OFFST15_OFFSET_7      BIT10
#define  ADC12_OFFST15_OFFSET_8      BIT11
#define  ADC12_OFFST15_OFFSET_9      BIT12
#define  ADC12_OFFST15_OFFSET_10     BIT13
#define  ADC12_OFFST15_OFFSET_11     BIT14

#define  ADC12_PWR_PD0               BIT0
//   Manual Power Down for Converter A
//     0b0 ==> Power Up ADC converter A
//     0b1 ==> Power Down ADC converter A

#define  ADC12_PWR_PD1               BIT1
//   Manual Power Down for Converter B
//     0b0 ==> Power Up ADC converter B
//     0b1 ==> Power Down ADC converter B

#define  ADC12_PWR_APD               BIT3
//   Auto Powerdown
//     0b0 ==> Auto Powerdown Mode is not active
//     0b1 ==> Auto Powerdown Mode is active

#define  ADC12_PWR_PUDELAY           (BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
//   Power Up Delay
#define  ADC12_PWR_PUDELAY_0         BIT4
#define  ADC12_PWR_PUDELAY_1         BIT5
#define  ADC12_PWR_PUDELAY_2         BIT6
#define  ADC12_PWR_PUDELAY_3         BIT7
#define  ADC12_PWR_PUDELAY_4         BIT8
#define  ADC12_PWR_PUDELAY_5         BIT9

#define  ADC12_PWR_PSTS0             BIT10
//   ADC Converter A Power Status
//     0b0 ==> ADC Converter A is currently powered up
//     0b1 ==> ADC Converter A is currently powered down

#define  ADC12_PWR_PSTS1             BIT11
//   ADC Converter B Power Status
//     0b0 ==> ADC Converter B is currently powered up
//     0b1 ==> ADC Converter B is currently powered down

#define  ADC12_PWR_ASB               BIT15
//   Auto Standby
//     0b0 ==> Auto standby mode disabled
//     0b1 ==> Auto standby mode enabled

#define  ADC12_CAL_SEL_DAC_A         BIT0
//   Select DAC Alternate Source
//     0b0 ==> Normal operation (ADCA7).
//     0b1 ==> ANA7 input is replaced with DAC output.

#define  ADC12_CAL_SEL_DAC_B         BIT1
//   Select DAC Alternate Source
//     0b0 ==> Normal operation (ADCB7).
//     0b1 ==> ANB7 input is replaced with DAC output.

#define  ADC12_CAL_SEL_VREFLO_A      BIT12
//   Select V REFLO Source
//     0b0 ==> Internal VSSA
//     0b1 ==> ANA3

#define  ADC12_CAL_SEL_VREFH_A       BIT13
//   Select V REFH Source
//     0b0 ==> Internal VDDA
//     0b1 ==> ANA2

#define  ADC12_CAL_SEL_VREFLO_B      BIT14
//   Select V REFLO Source
//     0b0 ==> Internal VSSA
//     0b1 ==> ANB3

#define  ADC12_CAL_SEL_VREFH_B       BIT15
//   Select V REFH Source
//     0b0 ==> Internal VDDA
//     0b1 ==> ANB2

#define  ADC12_GC1_GAIN0             (BIT0|BIT1)
//   Gain Control Bit 0
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC1_GAIN0_0           BIT0
#define  ADC12_GC1_GAIN0_1           BIT1

#define  ADC12_GC1_GAIN1             (BIT2|BIT3)
//   Gain Control Bit 1
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC1_GAIN1_0           BIT2
#define  ADC12_GC1_GAIN1_1           BIT3

#define  ADC12_GC1_GAIN2             (BIT4|BIT5)
//   Gain Control Bit 2
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC1_GAIN2_0           BIT4
#define  ADC12_GC1_GAIN2_1           BIT5

#define  ADC12_GC1_GAIN3             (BIT6|BIT7)
//   Gain Control Bit 3
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC1_GAIN3_0           BIT6
#define  ADC12_GC1_GAIN3_1           BIT7

#define  ADC12_GC1_GAIN4             (BIT8|BIT9)
//   Gain Control Bit 4
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC1_GAIN4_0           BIT8
#define  ADC12_GC1_GAIN4_1           BIT9

#define  ADC12_GC1_GAIN5             (BIT10|BIT11)
//   Gain Control Bit 5
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC1_GAIN5_0           BIT10
#define  ADC12_GC1_GAIN5_1           BIT11

#define  ADC12_GC1_GAIN6             (BIT12|BIT13)
//   Gain Control Bit 6
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC1_GAIN6_0           BIT12
#define  ADC12_GC1_GAIN6_1           BIT13

#define  ADC12_GC1_GAIN7             (BIT14|BIT15)
//   Gain Control Bit 7
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC1_GAIN7_0           BIT14
#define  ADC12_GC1_GAIN7_1           BIT15

#define  ADC12_GC2_GAIN8             (BIT0|BIT1)
//   Gain Control Bit 8
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC2_GAIN8_0           BIT0
#define  ADC12_GC2_GAIN8_1           BIT1

#define  ADC12_GC2_GAIN9             (BIT2|BIT3)
//   Gain Control Bit 9
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC2_GAIN9_0           BIT2
#define  ADC12_GC2_GAIN9_1           BIT3

#define  ADC12_GC2_GAIN10            (BIT4|BIT5)
//   Gain Control Bit 10
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC2_GAIN10_0          BIT4
#define  ADC12_GC2_GAIN10_1          BIT5

#define  ADC12_GC2_GAIN11            (BIT6|BIT7)
//   Gain Control Bit 11
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC2_GAIN11_0          BIT6
#define  ADC12_GC2_GAIN11_1          BIT7

#define  ADC12_GC2_GAIN12            (BIT8|BIT9)
//   Gain Control Bit 12
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC2_GAIN12_0          BIT8
#define  ADC12_GC2_GAIN12_1          BIT9

#define  ADC12_GC2_GAIN13            (BIT10|BIT11)
//   Gain Control Bit 13
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC2_GAIN13_0          BIT10
#define  ADC12_GC2_GAIN13_1          BIT11

#define  ADC12_GC2_GAIN14            (BIT12|BIT13)
//   Gain Control Bit 14
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC2_GAIN14_0          BIT12
#define  ADC12_GC2_GAIN14_1          BIT13

#define  ADC12_GC2_GAIN15            (BIT14|BIT15)
//   Gain Control Bit 15
//     0b00 ==> x1 amplification
//     0b01 ==> x2 amplification
//     0b10 ==> x4 amplification
//     0b11 ==> reserved
#define  ADC12_GC2_GAIN15_0          BIT14
#define  ADC12_GC2_GAIN15_1          BIT15

#define  ADC12_SCTRL_SC              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Scan Control Bits
//     0b0 ==> Perform sample immediately after the completion of the current sample.
//     0b1 ==> Delay sample until a new sync input occurs.
#define  ADC12_SCTRL_SC_0            BIT0
#define  ADC12_SCTRL_SC_1            BIT1
#define  ADC12_SCTRL_SC_2            BIT2
#define  ADC12_SCTRL_SC_3            BIT3
#define  ADC12_SCTRL_SC_4            BIT4
#define  ADC12_SCTRL_SC_5            BIT5
#define  ADC12_SCTRL_SC_6            BIT6
#define  ADC12_SCTRL_SC_7            BIT7
#define  ADC12_SCTRL_SC_8            BIT8
#define  ADC12_SCTRL_SC_9            BIT9
#define  ADC12_SCTRL_SC_10           BIT10
#define  ADC12_SCTRL_SC_11           BIT11
#define  ADC12_SCTRL_SC_12           BIT12
#define  ADC12_SCTRL_SC_13           BIT13
#define  ADC12_SCTRL_SC_14           BIT14
#define  ADC12_SCTRL_SC_15           BIT15

#define  ADC12_PWR2_SPEEDA           (BIT0|BIT1)
//   ADCA Speed Control Bits
//     0b00 ==> Conversion clock frequency <= 5 MHz; current consumption per converter = 5 mA
//     0b01 ==> Conversion clock frequency <= 10 MHz; current consumption per converter = 9 mA
//     0b10 ==> Conversion clock frequency <= 15 MHz; current consumption per converter = 15 mA
//     0b11 ==> Conversion clock frequency <= 20 MHz; current consumption per converter = 21 mA
#define  ADC12_PWR2_SPEEDA_0         BIT0
#define  ADC12_PWR2_SPEEDA_1         BIT1

#define  ADC12_PWR2_SPEEDB           (BIT2|BIT3)
//   ADCB Speed Control Bits
//     0b00 ==> Conversion clock frequency <= 5 MHz; current consumption per converter = 5 mA
//     0b01 ==> Conversion clock frequency <= 10 MHz; current consumption per converter = 9 mA
//     0b10 ==> Conversion clock frequency <= 15 MHz; current consumption per converter = 15 mA
//     0b11 ==> Conversion clock frequency <= 20 MHz; current consumption per converter = 21 mA
#define  ADC12_PWR2_SPEEDB_0         BIT2
#define  ADC12_PWR2_SPEEDB_1         BIT3

#define  ADC12_PWR2_DIV1             (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
//   Clock Divisor Select
#define  ADC12_PWR2_DIV1_0           BIT8
#define  ADC12_PWR2_DIV1_1           BIT9
#define  ADC12_PWR2_DIV1_2           BIT10
#define  ADC12_PWR2_DIV1_3           BIT11
#define  ADC12_PWR2_DIV1_4           BIT12
#define  ADC12_PWR2_DIV1_5           BIT13

#define  ADC12_CTRL3_SCNT0           (BIT0|BIT1|BIT2)
//   Sample Window Count 0
#define  ADC12_CTRL3_SCNT0_0         BIT0
#define  ADC12_CTRL3_SCNT0_1         BIT1
#define  ADC12_CTRL3_SCNT0_2         BIT2

#define  ADC12_CTRL3_SCNT1           (BIT3|BIT4|BIT5)
//   Sample Window Count 1
#define  ADC12_CTRL3_SCNT1_0         BIT3
#define  ADC12_CTRL3_SCNT1_1         BIT4
#define  ADC12_CTRL3_SCNT1_2         BIT5

#define  ADC12_CTRL3_DMASRC          BIT6
//   DMA Trigger Source
//     0b0 ==> DMA trigger source is end of scan interrupt
//     0b1 ==> DMA trigger source is RDY bits

#define  ADC12_SCHLTEN_SCHLTEN       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Scan Halted Interrupt Enable
//     0b0 ==> Scan halted interrupt is enabled for this sample.
//     0b1 ==> Scan halted interrupt is not enabled for this sample.
#define  ADC12_SCHLTEN_SCHLTEN_0     BIT0
#define  ADC12_SCHLTEN_SCHLTEN_1     BIT1
#define  ADC12_SCHLTEN_SCHLTEN_2     BIT2
#define  ADC12_SCHLTEN_SCHLTEN_3     BIT3
#define  ADC12_SCHLTEN_SCHLTEN_4     BIT4
#define  ADC12_SCHLTEN_SCHLTEN_5     BIT5
#define  ADC12_SCHLTEN_SCHLTEN_6     BIT6
#define  ADC12_SCHLTEN_SCHLTEN_7     BIT7
#define  ADC12_SCHLTEN_SCHLTEN_8     BIT8
#define  ADC12_SCHLTEN_SCHLTEN_9     BIT9
#define  ADC12_SCHLTEN_SCHLTEN_10    BIT10
#define  ADC12_SCHLTEN_SCHLTEN_11    BIT11
#define  ADC12_SCHLTEN_SCHLTEN_12    BIT12
#define  ADC12_SCHLTEN_SCHLTEN_13    BIT13
#define  ADC12_SCHLTEN_SCHLTEN_14    BIT14
#define  ADC12_SCHLTEN_SCHLTEN_15    BIT15

#define  ADC16_SC1A_ADCH             (BIT0|BIT1|BIT2|BIT3|BIT4)
//   Input channel select
//     0b00000 ==> When DIFF=0, DADP0 is selected as input; when DIFF=1, DAD0 is selected as input.
//     0b00001 ==> When DIFF=0, DADP1 is selected as input; when DIFF=1, DAD1 is selected as input.
//     0b00010 ==> When DIFF=0, DADP2 is selected as input; when DIFF=1, DAD2 is selected as input.
//     0b00011 ==> When DIFF=0, DADP3 is selected as input; when DIFF=1, DAD3 is selected as input.
//     0b00100 ==> When DIFF=0, AD4 is selected as input; when DIFF=1, it is reserved.
//     0b00101 ==> When DIFF=0, AD5 is selected as input; when DIFF=1, it is reserved.
//     0b00110 ==> When DIFF=0, AD6 is selected as input; when DIFF=1, it is reserved.
//     0b00111 ==> When DIFF=0, AD7 is selected as input; when DIFF=1, it is reserved.
//     0b01000 ==> When DIFF=0, AD8 is selected as input; when DIFF=1, it is reserved.
//     0b01001 ==> When DIFF=0, AD9 is selected as input; when DIFF=1, it is reserved.
//     0b01010 ==> When DIFF=0, AD10 is selected as input; when DIFF=1, it is reserved.
//     0b01011 ==> When DIFF=0, AD11 is selected as input; when DIFF=1, it is reserved.
//     0b01100 ==> When DIFF=0, AD12 is selected as input; when DIFF=1, it is reserved.
//     0b01101 ==> When DIFF=0, AD13 is selected as input; when DIFF=1, it is reserved.
//     0b01110 ==> When DIFF=0, AD14 is selected as input; when DIFF=1, it is reserved.
//     0b01111 ==> When DIFF=0, AD15 is selected as input; when DIFF=1, it is reserved.
//     0b10000 ==> When DIFF=0, AD16 is selected as input; when DIFF=1, it is reserved.
//     0b10001 ==> When DIFF=0, AD17 is selected as input; when DIFF=1, it is reserved.
//     0b10010 ==> When DIFF=0, AD18 is selected as input; when DIFF=1, it is reserved.
//     0b10011 ==> When DIFF=0, AD19 is selected as input; when DIFF=1, it is reserved.
//     0b10100 ==> When DIFF=0, AD20 is selected as input; when DIFF=1, it is reserved.
//     0b10101 ==> When DIFF=0, AD21 is selected as input; when DIFF=1, it is reserved.
//     0b10110 ==> When DIFF=0, AD22 is selected as input; when DIFF=1, it is reserved.
//     0b10111 ==> When DIFF=0, AD23 is selected as input; when DIFF=1, it is reserved.
//     0b11000 ==> Reserved.
//     0b11001 ==> Reserved.
//     0b11010 ==> When DIFF=0, Temp sensor (single-ended) is selected as input; when DIFF=1, Temp sensor (differential) is selected as input.
//     0b11011 ==> When DIFF=0, Bandgap (single-ended) is selected as input; when DIFF=1, Bandgap (differential) is selected as input.
//     0b11100 ==> Reserved.
//     0b11101 ==> When DIFF=0, VREFSH is selected as input; when DIFF=1, -VREFSH (differential) is selected as input. Voltage reference selected is determined by the REFSEL bits in the SC2 register.
//     0b11110 ==> When DIFF=0, VREFSL is selected as input; when DIFF=1, it is reserved. Voltage reference selected is determined by the REFSEL bits in the SC2 register.
//     0b11111 ==> Module disabled.
#define  ADC16_SC1A_ADCH_0           BIT0
#define  ADC16_SC1A_ADCH_1           BIT1
#define  ADC16_SC1A_ADCH_2           BIT2
#define  ADC16_SC1A_ADCH_3           BIT3
#define  ADC16_SC1A_ADCH_4           BIT4

#define  ADC16_SC1A_DIFF             BIT5
//   Differential mode enable
//     0b0 ==> Single-ended conversions and input channels are selected.
//     0b1 ==> Differential conversions and input channels are selected.

#define  ADC16_SC1A_AIEN             BIT6
//   Interrupt enable
//     0b0 ==> Conversion complete interrupt disabled.
//     0b1 ==> Conversion complete interrupt enabled.

#define  ADC16_SC1A_COCO             BIT7
//   Conversion complete flag
//     0b0 ==> Conversion not completed.
//     0b1 ==> Conversion completed.

#define  ADC16_CFG1_ADICLK           (BIT0|BIT1)
//   Input clock select
//     0b00 ==> Bus clock.
//     0b01 ==> Bus clock divided by 2.
//     0b10 ==> Alternate clock (ALTCLK).
//     0b11 ==> Asynchronous clock (ADACK).
#define  ADC16_CFG1_ADICLK_0         BIT0
#define  ADC16_CFG1_ADICLK_1         BIT1

#define  ADC16_CFG1_MODE             (BIT2|BIT3)
//   Conversion mode selection
//     0b00 ==> When DIFF=0: It is single-ended 8-bit conversion; when DIFF=1, it is differential 9-bit conversion with 2's complement output.
//     0b01 ==> When DIFF=0: It is single-ended 12-bit conversion; when DIFF=1, it is differential 13-bit conversion with 2's complement output.
//     0b10 ==> When DIFF=0: It is single-ended 10-bit conversion; when DIFF=1, it is differential 11-bit conversion with 2's complement output.
//     0b11 ==> When DIFF=0: It is single-ended 16-bit conversion; when DIFF=1, it is differential 16-bit conversion with 2's complement output .
#define  ADC16_CFG1_MODE_0           BIT2
#define  ADC16_CFG1_MODE_1           BIT3

#define  ADC16_CFG1_ADLSMP           BIT4
//   Sample time configuration
//     0b0 ==> Short sample time.
//     0b1 ==> Long sample time.

#define  ADC16_CFG1_ADIV             (BIT5|BIT6)
//   Clock divide select
//     0b00 ==> The divide ratio is 1 and the clock rate is input clock.
//     0b01 ==> The divide ratio is 2 and the clock rate is (input clock)/2.
//     0b10 ==> The divide ratio is 4 and the clock rate is (input clock)/4.
//     0b11 ==> The divide ratio is 8 and the clock rate is (input clock)/8.
#define  ADC16_CFG1_ADIV_0           BIT5
#define  ADC16_CFG1_ADIV_1           BIT6

#define  ADC16_CFG1_ADLPC            BIT7
//   Low-power configuration
//     0b0 ==> Normal power configuration.
//     0b1 ==> Low power configuration. The power is reduced at the expense of maximum clock speed.

#define  ADC16_CFG2_ADLSTS           (BIT0|BIT1)
//   Long sample time select
//     0b00 ==> Default longest sample time (20 extra ADCK cycles; 24 ADCK cycles total).
//     0b01 ==> 12 extra ADCK cycles; 16 ADCK cycles total sample time.
//     0b10 ==> 6 extra ADCK cycles; 10 ADCK cycles total sample time.
//     0b11 ==> 2 extra ADCK cycles; 6 ADCK cycles total sample time.
#define  ADC16_CFG2_ADLSTS_0         BIT0
#define  ADC16_CFG2_ADLSTS_1         BIT1

#define  ADC16_CFG2_ADHSC            BIT2
//   High speed configuration
//     0b0 ==> Normal conversion sequence selected.
//     0b1 ==> High speed conversion sequence selected (2 additional ADCK cycles to total conversion time).

#define  ADC16_CFG2_ADACKEN          BIT3
//   Asynchronous clock output enable
//     0b0 ==> Asynchronous clock output disabled; Asynchronous clock only enabled if selected by ADICLK and a conversion is active.
//     0b1 ==> Asynchronous clock and clock output enabled regardless of the state of the ADC.

#define  ADC16_RA_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data result
#define  ADC16_RA_D_0                BIT0
#define  ADC16_RA_D_1                BIT1
#define  ADC16_RA_D_2                BIT2
#define  ADC16_RA_D_3                BIT3
#define  ADC16_RA_D_4                BIT4
#define  ADC16_RA_D_5                BIT5
#define  ADC16_RA_D_6                BIT6
#define  ADC16_RA_D_7                BIT7
#define  ADC16_RA_D_8                BIT8
#define  ADC16_RA_D_9                BIT9
#define  ADC16_RA_D_10               BIT10
#define  ADC16_RA_D_11               BIT11
#define  ADC16_RA_D_12               BIT12
#define  ADC16_RA_D_13               BIT13
#define  ADC16_RA_D_14               BIT14
#define  ADC16_RA_D_15               BIT15

#define  ADC16_CV1_CV                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Compare value
#define  ADC16_CV1_CV_0              BIT0
#define  ADC16_CV1_CV_1              BIT1
#define  ADC16_CV1_CV_2              BIT2
#define  ADC16_CV1_CV_3              BIT3
#define  ADC16_CV1_CV_4              BIT4
#define  ADC16_CV1_CV_5              BIT5
#define  ADC16_CV1_CV_6              BIT6
#define  ADC16_CV1_CV_7              BIT7
#define  ADC16_CV1_CV_8              BIT8
#define  ADC16_CV1_CV_9              BIT9
#define  ADC16_CV1_CV_10             BIT10
#define  ADC16_CV1_CV_11             BIT11
#define  ADC16_CV1_CV_12             BIT12
#define  ADC16_CV1_CV_13             BIT13
#define  ADC16_CV1_CV_14             BIT14
#define  ADC16_CV1_CV_15             BIT15

#define  ADC16_CV2_CV                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Compare value
#define  ADC16_CV2_CV_0              BIT0
#define  ADC16_CV2_CV_1              BIT1
#define  ADC16_CV2_CV_2              BIT2
#define  ADC16_CV2_CV_3              BIT3
#define  ADC16_CV2_CV_4              BIT4
#define  ADC16_CV2_CV_5              BIT5
#define  ADC16_CV2_CV_6              BIT6
#define  ADC16_CV2_CV_7              BIT7
#define  ADC16_CV2_CV_8              BIT8
#define  ADC16_CV2_CV_9              BIT9
#define  ADC16_CV2_CV_10             BIT10
#define  ADC16_CV2_CV_11             BIT11
#define  ADC16_CV2_CV_12             BIT12
#define  ADC16_CV2_CV_13             BIT13
#define  ADC16_CV2_CV_14             BIT14
#define  ADC16_CV2_CV_15             BIT15

#define  ADC16_SC2_REFSEL            (BIT0|BIT1)
//   Voltage reference selection
//     0b00 ==> Default voltage reference pin pair (external pins VREFH and VREFL)
//     0b01 ==> Alternate reference pair (VALTH and VALTL). This pair may be additional external pins or internal sources depending on MCU configuration. Consult the Chip Configuration information for details specific to this MCU.
//     0b10 ==> Internal bandgap reference and associated ground reference (VBGH and VBGL). Consult the Chip Configuration information for details specific to this MCU.
//     0b11 ==> Reserved
#define  ADC16_SC2_REFSEL_0          BIT0
#define  ADC16_SC2_REFSEL_1          BIT1

#define  ADC16_SC2_DMAEN             BIT2
//   DMA enable
//     0b0 ==> DMA is disabled.
//     0b1 ==> DMA is enabled and will assert the ADC DMA request during a ADC conversion complete event noted by the assertion of any of the ADC COCO flags.

#define  ADC16_SC2_ACREN             BIT3
//   Compare function range enable
//     0b0 ==> Range function disabled. Only the compare value 1 register (CV1) is compared.
//     0b1 ==> Range function enabled. Both compare value registers (CV1 and CV2) are compared.

#define  ADC16_SC2_ACFGT             BIT4
//   Compare function greater than enable
//     0b0 ==> Configures less than threshold, outside range not inclusive and inside range not inclusive functionality based on the values placed in the CV1 and CV2 registers.
//     0b1 ==> Configures greater than or equal to threshold, outside range inclusive and inside range inclusive functionality based on the values placed in the CV1 and CV2 registers.

#define  ADC16_SC2_ACFE              BIT5
//   Compare function enable
//     0b0 ==> Compare function disabled.
//     0b1 ==> Compare function enabled.

#define  ADC16_SC2_ADTRG             BIT6
//   Conversion trigger select
//     0b0 ==> Software trigger selected.
//     0b1 ==> Hardware trigger selected.

#define  ADC16_SC2_ADACT             BIT7
//   Conversion active
//     0b0 ==> Conversion not in progress.
//     0b1 ==> Conversion in progress.

#define  ADC16_SC3_AVGS              (BIT0|BIT1)
//   Hardware average select
//     0b00 ==> 4 samples averaged.
//     0b01 ==> 8 samples averaged.
//     0b10 ==> 16 samples averaged.
//     0b11 ==> 32 samples averaged.
#define  ADC16_SC3_AVGS_0            BIT0
#define  ADC16_SC3_AVGS_1            BIT1

#define  ADC16_SC3_AVGE              BIT2
//   Hardware average enable
//     0b0 ==> Hardware average function disabled.
//     0b1 ==> Hardware average function enabled.

#define  ADC16_SC3_ADCO              BIT3
//   Continuous conversion enable
//     0b0 ==> One conversion or one set of conversions if the hardware average function is enabled (AVGE=1) after initiating a conversion.
//     0b1 ==> Continuous conversions or sets of conversions if the hardware average function is enabled (AVGE=1) after initiating a conversion.

#define  ADC16_SC3_ASSITRGEN         BIT4
//   Assist Trigger Enable
//     0b0 ==> Writes to ADCSC1 COCO bit don't have an affect on ADTRG.
//     0b1 ==> Writes to ADCSC1 COCO bit will be reflected into ADTRG register. Note: When ASSITRGEN is set, writes to ADCSC1 are delayed by 1/2 bus cycle to allow ADCSC1 COCO write to be updated in ADTRG register so conversion type can be correctly generated (software if coco write is 1'b0 causing ADTRG to clear or hardware type if coco write is 1'b1.). Note: User must ensure no hardware trigger is generated between the time ADCSC1 COCO bit is written if value of ADTRG will change to
//             guarantee correct conversion type is generated.

#define  ADC16_SC3_CALF              BIT6
//   Calibration failed flag
//     0b0 ==> Calibration completed normally.
//     0b1 ==> Calibration failed. ADC accuracy specifications are not guaranteed.

#define  ADC16_SC3_CAL               BIT7
//   Calibration

#define  ADC16_OFS_OFS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Offset error correction value
#define  ADC16_OFS_OFS_0             BIT0
#define  ADC16_OFS_OFS_1             BIT1
#define  ADC16_OFS_OFS_2             BIT2
#define  ADC16_OFS_OFS_3             BIT3
#define  ADC16_OFS_OFS_4             BIT4
#define  ADC16_OFS_OFS_5             BIT5
#define  ADC16_OFS_OFS_6             BIT6
#define  ADC16_OFS_OFS_7             BIT7
#define  ADC16_OFS_OFS_8             BIT8
#define  ADC16_OFS_OFS_9             BIT9
#define  ADC16_OFS_OFS_10            BIT10
#define  ADC16_OFS_OFS_11            BIT11
#define  ADC16_OFS_OFS_12            BIT12
#define  ADC16_OFS_OFS_13            BIT13
#define  ADC16_OFS_OFS_14            BIT14
#define  ADC16_OFS_OFS_15            BIT15

#define  ADC16_PG_PG                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Plus-side gain
#define  ADC16_PG_PG_0               BIT0
#define  ADC16_PG_PG_1               BIT1
#define  ADC16_PG_PG_2               BIT2
#define  ADC16_PG_PG_3               BIT3
#define  ADC16_PG_PG_4               BIT4
#define  ADC16_PG_PG_5               BIT5
#define  ADC16_PG_PG_6               BIT6
#define  ADC16_PG_PG_7               BIT7
#define  ADC16_PG_PG_8               BIT8
#define  ADC16_PG_PG_9               BIT9
#define  ADC16_PG_PG_10              BIT10
#define  ADC16_PG_PG_11              BIT11
#define  ADC16_PG_PG_12              BIT12
#define  ADC16_PG_PG_13              BIT13
#define  ADC16_PG_PG_14              BIT14
#define  ADC16_PG_PG_15              BIT15

#define  ADC16_MG_MG                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Minus-side gain
#define  ADC16_MG_MG_0               BIT0
#define  ADC16_MG_MG_1               BIT1
#define  ADC16_MG_MG_2               BIT2
#define  ADC16_MG_MG_3               BIT3
#define  ADC16_MG_MG_4               BIT4
#define  ADC16_MG_MG_5               BIT5
#define  ADC16_MG_MG_6               BIT6
#define  ADC16_MG_MG_7               BIT7
#define  ADC16_MG_MG_8               BIT8
#define  ADC16_MG_MG_9               BIT9
#define  ADC16_MG_MG_10              BIT10
#define  ADC16_MG_MG_11              BIT11
#define  ADC16_MG_MG_12              BIT12
#define  ADC16_MG_MG_13              BIT13
#define  ADC16_MG_MG_14              BIT14
#define  ADC16_MG_MG_15              BIT15

#define  ADC16_CLPD_CLPD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
#define  ADC16_CLPD_CLPD_0           BIT0
#define  ADC16_CLPD_CLPD_1           BIT1
#define  ADC16_CLPD_CLPD_2           BIT2
#define  ADC16_CLPD_CLPD_3           BIT3
#define  ADC16_CLPD_CLPD_4           BIT4
#define  ADC16_CLPD_CLPD_5           BIT5

#define  ADC16_CLPS_CLPS             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
#define  ADC16_CLPS_CLPS_0           BIT0
#define  ADC16_CLPS_CLPS_1           BIT1
#define  ADC16_CLPS_CLPS_2           BIT2
#define  ADC16_CLPS_CLPS_3           BIT3
#define  ADC16_CLPS_CLPS_4           BIT4
#define  ADC16_CLPS_CLPS_5           BIT5

#define  ADC16_CLP4_CLP4             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
#define  ADC16_CLP4_CLP4_0           BIT0
#define  ADC16_CLP4_CLP4_1           BIT1
#define  ADC16_CLP4_CLP4_2           BIT2
#define  ADC16_CLP4_CLP4_3           BIT3
#define  ADC16_CLP4_CLP4_4           BIT4
#define  ADC16_CLP4_CLP4_5           BIT5
#define  ADC16_CLP4_CLP4_6           BIT6
#define  ADC16_CLP4_CLP4_7           BIT7
#define  ADC16_CLP4_CLP4_8           BIT8
#define  ADC16_CLP4_CLP4_9           BIT9

#define  ADC16_CLP3_CLP3             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
#define  ADC16_CLP3_CLP3_0           BIT0
#define  ADC16_CLP3_CLP3_1           BIT1
#define  ADC16_CLP3_CLP3_2           BIT2
#define  ADC16_CLP3_CLP3_3           BIT3
#define  ADC16_CLP3_CLP3_4           BIT4
#define  ADC16_CLP3_CLP3_5           BIT5
#define  ADC16_CLP3_CLP3_6           BIT6
#define  ADC16_CLP3_CLP3_7           BIT7
#define  ADC16_CLP3_CLP3_8           BIT8

#define  ADC16_CLP2_CLP2             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  ADC16_CLP2_CLP2_0           BIT0
#define  ADC16_CLP2_CLP2_1           BIT1
#define  ADC16_CLP2_CLP2_2           BIT2
#define  ADC16_CLP2_CLP2_3           BIT3
#define  ADC16_CLP2_CLP2_4           BIT4
#define  ADC16_CLP2_CLP2_5           BIT5
#define  ADC16_CLP2_CLP2_6           BIT6
#define  ADC16_CLP2_CLP2_7           BIT7

#define  ADC16_CLP1_CLP1             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
#define  ADC16_CLP1_CLP1_0           BIT0
#define  ADC16_CLP1_CLP1_1           BIT1
#define  ADC16_CLP1_CLP1_2           BIT2
#define  ADC16_CLP1_CLP1_3           BIT3
#define  ADC16_CLP1_CLP1_4           BIT4
#define  ADC16_CLP1_CLP1_5           BIT5
#define  ADC16_CLP1_CLP1_6           BIT6

#define  ADC16_CLP0_CLP0             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
#define  ADC16_CLP0_CLP0_0           BIT0
#define  ADC16_CLP0_CLP0_1           BIT1
#define  ADC16_CLP0_CLP0_2           BIT2
#define  ADC16_CLP0_CLP0_3           BIT3
#define  ADC16_CLP0_CLP0_4           BIT4
#define  ADC16_CLP0_CLP0_5           BIT5

#define  ADC16_CLMD_CLMD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
#define  ADC16_CLMD_CLMD_0           BIT0
#define  ADC16_CLMD_CLMD_1           BIT1
#define  ADC16_CLMD_CLMD_2           BIT2
#define  ADC16_CLMD_CLMD_3           BIT3
#define  ADC16_CLMD_CLMD_4           BIT4
#define  ADC16_CLMD_CLMD_5           BIT5

#define  ADC16_CLMS_CLMS             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
#define  ADC16_CLMS_CLMS_0           BIT0
#define  ADC16_CLMS_CLMS_1           BIT1
#define  ADC16_CLMS_CLMS_2           BIT2
#define  ADC16_CLMS_CLMS_3           BIT3
#define  ADC16_CLMS_CLMS_4           BIT4
#define  ADC16_CLMS_CLMS_5           BIT5

#define  ADC16_CLM4_CLM4             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
#define  ADC16_CLM4_CLM4_0           BIT0
#define  ADC16_CLM4_CLM4_1           BIT1
#define  ADC16_CLM4_CLM4_2           BIT2
#define  ADC16_CLM4_CLM4_3           BIT3
#define  ADC16_CLM4_CLM4_4           BIT4
#define  ADC16_CLM4_CLM4_5           BIT5
#define  ADC16_CLM4_CLM4_6           BIT6
#define  ADC16_CLM4_CLM4_7           BIT7
#define  ADC16_CLM4_CLM4_8           BIT8
#define  ADC16_CLM4_CLM4_9           BIT9

#define  ADC16_CLM3_CLM3             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
#define  ADC16_CLM3_CLM3_0           BIT0
#define  ADC16_CLM3_CLM3_1           BIT1
#define  ADC16_CLM3_CLM3_2           BIT2
#define  ADC16_CLM3_CLM3_3           BIT3
#define  ADC16_CLM3_CLM3_4           BIT4
#define  ADC16_CLM3_CLM3_5           BIT5
#define  ADC16_CLM3_CLM3_6           BIT6
#define  ADC16_CLM3_CLM3_7           BIT7
#define  ADC16_CLM3_CLM3_8           BIT8

#define  ADC16_CLM2_CLM2             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  ADC16_CLM2_CLM2_0           BIT0
#define  ADC16_CLM2_CLM2_1           BIT1
#define  ADC16_CLM2_CLM2_2           BIT2
#define  ADC16_CLM2_CLM2_3           BIT3
#define  ADC16_CLM2_CLM2_4           BIT4
#define  ADC16_CLM2_CLM2_5           BIT5
#define  ADC16_CLM2_CLM2_6           BIT6
#define  ADC16_CLM2_CLM2_7           BIT7

#define  ADC16_CLM1_CLM1             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
#define  ADC16_CLM1_CLM1_0           BIT0
#define  ADC16_CLM1_CLM1_1           BIT1
#define  ADC16_CLM1_CLM1_2           BIT2
#define  ADC16_CLM1_CLM1_3           BIT3
#define  ADC16_CLM1_CLM1_4           BIT4
#define  ADC16_CLM1_CLM1_5           BIT5
#define  ADC16_CLM1_CLM1_6           BIT6

#define  ADC16_CLM0_CLM0             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
#define  ADC16_CLM0_CLM0_0           BIT0
#define  ADC16_CLM0_CLM0_1           BIT1
#define  ADC16_CLM0_CLM0_2           BIT2
#define  ADC16_CLM0_CLM0_3           BIT3
#define  ADC16_CLM0_CLM0_4           BIT4
#define  ADC16_CLM0_CLM0_5           BIT5

#define  AOI_BFCRT010_PT1_DC         (BIT0|BIT1)
//   Product term 1, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT010_PT1_DC_0       BIT0
#define  AOI_BFCRT010_PT1_DC_1       BIT1

#define  AOI_BFCRT010_PT1_CC         (BIT2|BIT3)
//   Product term 1, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT010_PT1_CC_0       BIT2
#define  AOI_BFCRT010_PT1_CC_1       BIT3

#define  AOI_BFCRT010_PT1_BC         (BIT4|BIT5)
//   Product term 1, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT010_PT1_BC_0       BIT4
#define  AOI_BFCRT010_PT1_BC_1       BIT5

#define  AOI_BFCRT010_PT1_AC         (BIT6|BIT7)
//   Product term 1, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT010_PT1_AC_0       BIT6
#define  AOI_BFCRT010_PT1_AC_1       BIT7

#define  AOI_BFCRT010_PT0_DC         (BIT8|BIT9)
//   Product term 0, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT010_PT0_DC_0       BIT8
#define  AOI_BFCRT010_PT0_DC_1       BIT9

#define  AOI_BFCRT010_PT0_CC         (BIT10|BIT11)
//   Product term 0, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT010_PT0_CC_0       BIT10
#define  AOI_BFCRT010_PT0_CC_1       BIT11

#define  AOI_BFCRT010_PT0_BC         (BIT12|BIT13)
//   Product term 0, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT010_PT0_BC_0       BIT12
#define  AOI_BFCRT010_PT0_BC_1       BIT13

#define  AOI_BFCRT010_PT0_AC         (BIT14|BIT15)
//   Product term 0, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT010_PT0_AC_0       BIT14
#define  AOI_BFCRT010_PT0_AC_1       BIT15

#define  AOI_BFCRT230_PT3_DC         (BIT0|BIT1)
//   Product term 3, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT230_PT3_DC_0       BIT0
#define  AOI_BFCRT230_PT3_DC_1       BIT1

#define  AOI_BFCRT230_PT3_CC         (BIT2|BIT3)
//   Product term 3, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT230_PT3_CC_0       BIT2
#define  AOI_BFCRT230_PT3_CC_1       BIT3

#define  AOI_BFCRT230_PT3_BC         (BIT4|BIT5)
//   Product term 3, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT230_PT3_BC_0       BIT4
#define  AOI_BFCRT230_PT3_BC_1       BIT5

#define  AOI_BFCRT230_PT3_AC         (BIT6|BIT7)
//   Product term 3, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT230_PT3_AC_0       BIT6
#define  AOI_BFCRT230_PT3_AC_1       BIT7

#define  AOI_BFCRT230_PT2_DC         (BIT8|BIT9)
//   Product term 2, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT230_PT2_DC_0       BIT8
#define  AOI_BFCRT230_PT2_DC_1       BIT9

#define  AOI_BFCRT230_PT2_CC         (BIT10|BIT11)
//   Product term 2, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT230_PT2_CC_0       BIT10
#define  AOI_BFCRT230_PT2_CC_1       BIT11

#define  AOI_BFCRT230_PT2_BC         (BIT12|BIT13)
//   Product term 2, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT230_PT2_BC_0       BIT12
#define  AOI_BFCRT230_PT2_BC_1       BIT13

#define  AOI_BFCRT230_PT2_AC         (BIT14|BIT15)
//   Product term 2, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT230_PT2_AC_0       BIT14
#define  AOI_BFCRT230_PT2_AC_1       BIT15

#define  AOI_BFCRT011_PT1_DC         (BIT0|BIT1)
//   Product term 1, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT011_PT1_DC_0       BIT0
#define  AOI_BFCRT011_PT1_DC_1       BIT1

#define  AOI_BFCRT011_PT1_CC         (BIT2|BIT3)
//   Product term 1, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT011_PT1_CC_0       BIT2
#define  AOI_BFCRT011_PT1_CC_1       BIT3

#define  AOI_BFCRT011_PT1_BC         (BIT4|BIT5)
//   Product term 1, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT011_PT1_BC_0       BIT4
#define  AOI_BFCRT011_PT1_BC_1       BIT5

#define  AOI_BFCRT011_PT1_AC         (BIT6|BIT7)
//   Product term 1, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT011_PT1_AC_0       BIT6
#define  AOI_BFCRT011_PT1_AC_1       BIT7

#define  AOI_BFCRT011_PT0_DC         (BIT8|BIT9)
//   Product term 0, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT011_PT0_DC_0       BIT8
#define  AOI_BFCRT011_PT0_DC_1       BIT9

#define  AOI_BFCRT011_PT0_CC         (BIT10|BIT11)
//   Product term 0, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT011_PT0_CC_0       BIT10
#define  AOI_BFCRT011_PT0_CC_1       BIT11

#define  AOI_BFCRT011_PT0_BC         (BIT12|BIT13)
//   Product term 0, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT011_PT0_BC_0       BIT12
#define  AOI_BFCRT011_PT0_BC_1       BIT13

#define  AOI_BFCRT011_PT0_AC         (BIT14|BIT15)
//   Product term 0, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT011_PT0_AC_0       BIT14
#define  AOI_BFCRT011_PT0_AC_1       BIT15

#define  AOI_BFCRT231_PT3_DC         (BIT0|BIT1)
//   Product term 3, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT231_PT3_DC_0       BIT0
#define  AOI_BFCRT231_PT3_DC_1       BIT1

#define  AOI_BFCRT231_PT3_CC         (BIT2|BIT3)
//   Product term 3, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT231_PT3_CC_0       BIT2
#define  AOI_BFCRT231_PT3_CC_1       BIT3

#define  AOI_BFCRT231_PT3_BC         (BIT4|BIT5)
//   Product term 3, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT231_PT3_BC_0       BIT4
#define  AOI_BFCRT231_PT3_BC_1       BIT5

#define  AOI_BFCRT231_PT3_AC         (BIT6|BIT7)
//   Product term 3, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT231_PT3_AC_0       BIT6
#define  AOI_BFCRT231_PT3_AC_1       BIT7

#define  AOI_BFCRT231_PT2_DC         (BIT8|BIT9)
//   Product term 2, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT231_PT2_DC_0       BIT8
#define  AOI_BFCRT231_PT2_DC_1       BIT9

#define  AOI_BFCRT231_PT2_CC         (BIT10|BIT11)
//   Product term 2, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT231_PT2_CC_0       BIT10
#define  AOI_BFCRT231_PT2_CC_1       BIT11

#define  AOI_BFCRT231_PT2_BC         (BIT12|BIT13)
//   Product term 2, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT231_PT2_BC_0       BIT12
#define  AOI_BFCRT231_PT2_BC_1       BIT13

#define  AOI_BFCRT231_PT2_AC         (BIT14|BIT15)
//   Product term 2, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT231_PT2_AC_0       BIT14
#define  AOI_BFCRT231_PT2_AC_1       BIT15

#define  AOI_BFCRT012_PT1_DC         (BIT0|BIT1)
//   Product term 1, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT012_PT1_DC_0       BIT0
#define  AOI_BFCRT012_PT1_DC_1       BIT1

#define  AOI_BFCRT012_PT1_CC         (BIT2|BIT3)
//   Product term 1, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT012_PT1_CC_0       BIT2
#define  AOI_BFCRT012_PT1_CC_1       BIT3

#define  AOI_BFCRT012_PT1_BC         (BIT4|BIT5)
//   Product term 1, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT012_PT1_BC_0       BIT4
#define  AOI_BFCRT012_PT1_BC_1       BIT5

#define  AOI_BFCRT012_PT1_AC         (BIT6|BIT7)
//   Product term 1, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT012_PT1_AC_0       BIT6
#define  AOI_BFCRT012_PT1_AC_1       BIT7

#define  AOI_BFCRT012_PT0_DC         (BIT8|BIT9)
//   Product term 0, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT012_PT0_DC_0       BIT8
#define  AOI_BFCRT012_PT0_DC_1       BIT9

#define  AOI_BFCRT012_PT0_CC         (BIT10|BIT11)
//   Product term 0, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT012_PT0_CC_0       BIT10
#define  AOI_BFCRT012_PT0_CC_1       BIT11

#define  AOI_BFCRT012_PT0_BC         (BIT12|BIT13)
//   Product term 0, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT012_PT0_BC_0       BIT12
#define  AOI_BFCRT012_PT0_BC_1       BIT13

#define  AOI_BFCRT012_PT0_AC         (BIT14|BIT15)
//   Product term 0, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT012_PT0_AC_0       BIT14
#define  AOI_BFCRT012_PT0_AC_1       BIT15

#define  AOI_BFCRT232_PT3_DC         (BIT0|BIT1)
//   Product term 3, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT232_PT3_DC_0       BIT0
#define  AOI_BFCRT232_PT3_DC_1       BIT1

#define  AOI_BFCRT232_PT3_CC         (BIT2|BIT3)
//   Product term 3, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT232_PT3_CC_0       BIT2
#define  AOI_BFCRT232_PT3_CC_1       BIT3

#define  AOI_BFCRT232_PT3_BC         (BIT4|BIT5)
//   Product term 3, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT232_PT3_BC_0       BIT4
#define  AOI_BFCRT232_PT3_BC_1       BIT5

#define  AOI_BFCRT232_PT3_AC         (BIT6|BIT7)
//   Product term 3, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT232_PT3_AC_0       BIT6
#define  AOI_BFCRT232_PT3_AC_1       BIT7

#define  AOI_BFCRT232_PT2_DC         (BIT8|BIT9)
//   Product term 2, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT232_PT2_DC_0       BIT8
#define  AOI_BFCRT232_PT2_DC_1       BIT9

#define  AOI_BFCRT232_PT2_CC         (BIT10|BIT11)
//   Product term 2, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT232_PT2_CC_0       BIT10
#define  AOI_BFCRT232_PT2_CC_1       BIT11

#define  AOI_BFCRT232_PT2_BC         (BIT12|BIT13)
//   Product term 2, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT232_PT2_BC_0       BIT12
#define  AOI_BFCRT232_PT2_BC_1       BIT13

#define  AOI_BFCRT232_PT2_AC         (BIT14|BIT15)
//   Product term 2, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT232_PT2_AC_0       BIT14
#define  AOI_BFCRT232_PT2_AC_1       BIT15

#define  AOI_BFCRT013_PT1_DC         (BIT0|BIT1)
//   Product term 1, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT013_PT1_DC_0       BIT0
#define  AOI_BFCRT013_PT1_DC_1       BIT1

#define  AOI_BFCRT013_PT1_CC         (BIT2|BIT3)
//   Product term 1, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT013_PT1_CC_0       BIT2
#define  AOI_BFCRT013_PT1_CC_1       BIT3

#define  AOI_BFCRT013_PT1_BC         (BIT4|BIT5)
//   Product term 1, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT013_PT1_BC_0       BIT4
#define  AOI_BFCRT013_PT1_BC_1       BIT5

#define  AOI_BFCRT013_PT1_AC         (BIT6|BIT7)
//   Product term 1, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT013_PT1_AC_0       BIT6
#define  AOI_BFCRT013_PT1_AC_1       BIT7

#define  AOI_BFCRT013_PT0_DC         (BIT8|BIT9)
//   Product term 0, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT013_PT0_DC_0       BIT8
#define  AOI_BFCRT013_PT0_DC_1       BIT9

#define  AOI_BFCRT013_PT0_CC         (BIT10|BIT11)
//   Product term 0, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT013_PT0_CC_0       BIT10
#define  AOI_BFCRT013_PT0_CC_1       BIT11

#define  AOI_BFCRT013_PT0_BC         (BIT12|BIT13)
//   Product term 0, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT013_PT0_BC_0       BIT12
#define  AOI_BFCRT013_PT0_BC_1       BIT13

#define  AOI_BFCRT013_PT0_AC         (BIT14|BIT15)
//   Product term 0, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT013_PT0_AC_0       BIT14
#define  AOI_BFCRT013_PT0_AC_1       BIT15

#define  AOI_BFCRT233_PT3_DC         (BIT0|BIT1)
//   Product term 3, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT233_PT3_DC_0       BIT0
#define  AOI_BFCRT233_PT3_DC_1       BIT1

#define  AOI_BFCRT233_PT3_CC         (BIT2|BIT3)
//   Product term 3, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT233_PT3_CC_0       BIT2
#define  AOI_BFCRT233_PT3_CC_1       BIT3

#define  AOI_BFCRT233_PT3_BC         (BIT4|BIT5)
//   Product term 3, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT233_PT3_BC_0       BIT4
#define  AOI_BFCRT233_PT3_BC_1       BIT5

#define  AOI_BFCRT233_PT3_AC         (BIT6|BIT7)
//   Product term 3, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT233_PT3_AC_0       BIT6
#define  AOI_BFCRT233_PT3_AC_1       BIT7

#define  AOI_BFCRT233_PT2_DC         (BIT8|BIT9)
//   Product term 2, D input configuration
//     0b00 ==> Force the D input in this product term to a logical zero
//     0b01 ==> Pass the D input in this product term
//     0b10 ==> Complement the D input in this product term
//     0b11 ==> Force the D input in this product term to a logical one
#define  AOI_BFCRT233_PT2_DC_0       BIT8
#define  AOI_BFCRT233_PT2_DC_1       BIT9

#define  AOI_BFCRT233_PT2_CC         (BIT10|BIT11)
//   Product term 2, C input configuration
//     0b00 ==> Force the C input in this product term to a logical zero
//     0b01 ==> Pass the C input in this product term
//     0b10 ==> Complement the C input in this product term
//     0b11 ==> Force the C input in this product term to a logical one
#define  AOI_BFCRT233_PT2_CC_0       BIT10
#define  AOI_BFCRT233_PT2_CC_1       BIT11

#define  AOI_BFCRT233_PT2_BC         (BIT12|BIT13)
//   Product term 2, B input configuration
//     0b00 ==> Force the B input in this product term to a logical zero
//     0b01 ==> Pass the B input in this product term
//     0b10 ==> Complement the B input in this product term
//     0b11 ==> Force the B input in this product term to a logical one
#define  AOI_BFCRT233_PT2_BC_0       BIT12
#define  AOI_BFCRT233_PT2_BC_1       BIT13

#define  AOI_BFCRT233_PT2_AC         (BIT14|BIT15)
//   Product term 2, A input configuration
//     0b00 ==> Force the A input in this product term to a logical zero
//     0b01 ==> Pass the A input in this product term
//     0b10 ==> Complement the A input in this product term
//     0b11 ==> Force the A input in this product term to a logical one
#define  AOI_BFCRT233_PT2_AC_0       BIT14
#define  AOI_BFCRT233_PT2_AC_1       BIT15

#define  CAN_MCR_MAXMB               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
//   Number of the Last Message Buffer
#define  CAN_MCR_MAXMB_0             BIT0
#define  CAN_MCR_MAXMB_1             BIT1
#define  CAN_MCR_MAXMB_2             BIT2
#define  CAN_MCR_MAXMB_3             BIT3
#define  CAN_MCR_MAXMB_4             BIT4
#define  CAN_MCR_MAXMB_5             BIT5
#define  CAN_MCR_MAXMB_6             BIT6

#define  CAN_MCR_IDAM                (BIT8|BIT9)
//   ID Acceptance Mode
//     0b00 ==> Format A: One full ID (standard and extended) per ID Filter Table element.
//     0b01 ==> Format B: Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID Filter Table element.
//     0b10 ==> Format C: Four partial 8-bit Standard IDs per ID Filter Table element.
//     0b11 ==> Format D: All frames rejected.
#define  CAN_MCR_IDAM_0              BIT8
#define  CAN_MCR_IDAM_1              BIT9

#define  CAN_MCR_AEN                 BIT12
//   Abort Enable
//     0b0 ==> Abort disabled
//     0b1 ==> Abort enabled

#define  CAN_MCR_LPRIOEN             BIT13
//   Local Priority Enable
//     0b0 ==> Local Priority disabled
//     0b1 ==> Local Priority enabled

#define  CAN_MCR_IRMQ                BIT16
//   Individual Rx Masking and Queue Enable
//     0b0 ==> Individual Rx masking and queue feature are disabled. For backward compatibility, the reading of C/S word locks the MB even if it is EMPTY.
//     0b1 ==> Individual Rx masking and queue feature are enabled.

#define  CAN_MCR_SRXDIS              BIT17
//   Self Reception Disable
//     0b0 ==> Self reception enabled
//     0b1 ==> Self reception disabled

#define  CAN_MCR_DOZE                BIT18
//   Doze Mode Enable
//     0b0 ==> FlexCAN is not enabled to enter low power mode when Doze Mode is requested.
//     0b1 ==> FlexCAN is enabled to enter low power mode when Doze Mode is requested.

#define  CAN_MCR_WAKSRC              BIT19
//   Wake Up Source
//     0b0 ==> FlexCAN uses the unfiltered Rx input to detect recessive to dominant edges on the CAN bus.
//     0b1 ==> FlexCAN uses the filtered Rx input to detect recessive to dominant edges on the CAN bus.

#define  CAN_MCR_LPMACK              BIT20
//   Low Power Mode Acknowledge
//     0b0 ==> FlexCAN is not in a low power mode.
//     0b1 ==> FlexCAN is in a low power mode.

#define  CAN_MCR_WRNEN               BIT21
//   Warning Interrupt Enable
//     0b0 ==> TWRNINT and RWRNINT bits are zero, independent of the values in the error counters.
//     0b1 ==> TWRNINT and RWRNINT bits are set when the respective error counter transitions from less than 96 to greater than or equal to 96.

#define  CAN_MCR_SLFWAK              BIT22
//   Self Wake Up
//     0b0 ==> FlexCAN Self Wake Up feature is disabled.
//     0b1 ==> FlexCAN Self Wake Up feature is enabled.

#define  CAN_MCR_SUPV                BIT23
//   Supervisor Mode
//     0b0 ==> FlexCAN is in User Mode. Affected registers allow both Supervisor and Unrestricted accesses.
//     0b1 ==> FlexCAN is in Supervisor Mode. Affected registers allow only Supervisor access. Unrestricted access behaves as though the access was done to an unimplemented register location.

#define  CAN_MCR_FRZACK              BIT24
//   Freeze Mode Acknowledge
//     0b0 ==> FlexCAN not in Freeze Mode, prescaler running
//     0b1 ==> FlexCAN in Freeze Mode, prescaler stopped

#define  CAN_MCR_SOFTRST             BIT25
//   Soft Reset
//     0b0 ==> No reset request
//     0b1 ==> Resets the registers affected by soft reset.

#define  CAN_MCR_WAKMSK              BIT26
//   Wake Up Interrupt Mask
//     0b0 ==> Wake Up Interrupt is disabled.
//     0b1 ==> Wake Up Interrupt is enabled.

#define  CAN_MCR_NOTRDY              BIT27
//   FlexCAN Not Ready
//     0b0 ==> FlexCAN module is either in Normal Mode, Listen-Only Mode or Loop-Back Mode.
//     0b1 ==> FlexCAN module is either in Disable Mode, Doze Mode , Stop Mode or Freeze Mode.

#define  CAN_MCR_HALT                BIT28
//   Halt FlexCAN
//     0b0 ==> No Freeze Mode request.
//     0b1 ==> Enters Freeze Mode if the FRZ bit is asserted.

#define  CAN_MCR_RFEN                BIT29
//   Rx FIFO Enable
//     0b0 ==> Rx FIFO not enabled
//     0b1 ==> Rx FIFO enabled

#define  CAN_MCR_FRZ                 BIT30
//   Freeze Enable
//     0b0 ==> Not enabled to enter Freeze Mode
//     0b1 ==> Enabled to enter Freeze Mode

#define  CAN_MCR_MDIS                BIT31
//   Module Disable
//     0b0 ==> Enable the FlexCAN module.
//     0b1 ==> Disable the FlexCAN module.

#define  CAN_CTRL1_PROPSEG           (BIT0|BIT1|BIT2)
//   Propagation Segment
#define  CAN_CTRL1_PROPSEG_0         BIT0
#define  CAN_CTRL1_PROPSEG_1         BIT1
#define  CAN_CTRL1_PROPSEG_2         BIT2

#define  CAN_CTRL1_LOM               BIT3
//   Listen-Only Mode
//     0b0 ==> Listen-Only Mode is deactivated.
//     0b1 ==> FlexCAN module operates in Listen-Only Mode.

#define  CAN_CTRL1_LBUF              BIT4
//   Lowest Buffer Transmitted First
//     0b0 ==> Buffer with highest priority is transmitted first.
//     0b1 ==> Lowest number buffer is transmitted first.

#define  CAN_CTRL1_TSYN              BIT5
//   Timer Sync
//     0b0 ==> Timer Sync feature disabled
//     0b1 ==> Timer Sync feature enabled

#define  CAN_CTRL1_BOFFREC           BIT6
//   Bus Off Recovery
//     0b0 ==> Automatic recovering from Bus Off state enabled, according to CAN Spec 2.0 part B
//     0b1 ==> Automatic recovering from Bus Off state disabled

#define  CAN_CTRL1_SMP               BIT7
//   CAN Bit Sampling
//     0b0 ==> Just one sample is used to determine the bit value.
//     0b1 ==> Three samples are used to determine the value of the received bit: the regular one (sample point) and 2 preceding samples; a majority rule is used.

#define  CAN_CTRL1_RWRNMSK           BIT10
//   Rx Warning Interrupt Mask
//     0b0 ==> Rx Warning Interrupt disabled
//     0b1 ==> Rx Warning Interrupt enabled

#define  CAN_CTRL1_TWRNMSK           BIT11
//   Tx Warning Interrupt Mask
//     0b0 ==> Tx Warning Interrupt disabled
//     0b1 ==> Tx Warning Interrupt enabled

#define  CAN_CTRL1_LPB               BIT12
//   Loop Back Mode
//     0b0 ==> Loop Back disabled
//     0b1 ==> Loop Back enabled

#define  CAN_CTRL1_CLKSRC            BIT13
//   CAN Engine Clock Source
//     0b0 ==> The CAN engine clock source is the oscillator clock. Under this condition, the oscillator clock frequency must be lower than the bus clock.
//     0b1 ==> The CAN engine clock source is the peripheral clock.

#define  CAN_CTRL1_ERRMSK            BIT14
//   Error Mask
//     0b0 ==> Error interrupt disabled
//     0b1 ==> Error interrupt enabled

#define  CAN_CTRL1_BOFFMSK           BIT15
//   Bus Off Mask
//     0b0 ==> Bus Off interrupt disabled
//     0b1 ==> Bus Off interrupt enabled

#define  CAN_CTRL1_PSEG2             (BIT16|BIT17|BIT18)
//   Phase Segment 2
#define  CAN_CTRL1_PSEG2_0           BIT16
#define  CAN_CTRL1_PSEG2_1           BIT17
#define  CAN_CTRL1_PSEG2_2           BIT18

#define  CAN_CTRL1_PSEG1             (BIT19|BIT20|BIT21)
//   Phase Segment 1
#define  CAN_CTRL1_PSEG1_0           BIT19
#define  CAN_CTRL1_PSEG1_1           BIT20
#define  CAN_CTRL1_PSEG1_2           BIT21

#define  CAN_CTRL1_RJW               (BIT22|BIT23)
//   Resync Jump Width
#define  CAN_CTRL1_RJW_0             BIT22
#define  CAN_CTRL1_RJW_1             BIT23

#define  CAN_CTRL1_PRESDIV           (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Prescaler Division Factor
#define  CAN_CTRL1_PRESDIV_0         BIT24
#define  CAN_CTRL1_PRESDIV_1         BIT25
#define  CAN_CTRL1_PRESDIV_2         BIT26
#define  CAN_CTRL1_PRESDIV_3         BIT27
#define  CAN_CTRL1_PRESDIV_4         BIT28
#define  CAN_CTRL1_PRESDIV_5         BIT29
#define  CAN_CTRL1_PRESDIV_6         BIT30
#define  CAN_CTRL1_PRESDIV_7         BIT31

#define  CAN_TIMER_TIMER             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Timer value
#define  CAN_TIMER_TIMER_0           BIT0
#define  CAN_TIMER_TIMER_1           BIT1
#define  CAN_TIMER_TIMER_2           BIT2
#define  CAN_TIMER_TIMER_3           BIT3
#define  CAN_TIMER_TIMER_4           BIT4
#define  CAN_TIMER_TIMER_5           BIT5
#define  CAN_TIMER_TIMER_6           BIT6
#define  CAN_TIMER_TIMER_7           BIT7
#define  CAN_TIMER_TIMER_8           BIT8
#define  CAN_TIMER_TIMER_9           BIT9
#define  CAN_TIMER_TIMER_10          BIT10
#define  CAN_TIMER_TIMER_11          BIT11
#define  CAN_TIMER_TIMER_12          BIT12
#define  CAN_TIMER_TIMER_13          BIT13
#define  CAN_TIMER_TIMER_14          BIT14
#define  CAN_TIMER_TIMER_15          BIT15

#define  CAN_RXMGMASK_MG             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Rx Mailboxes Global Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXMGMASK_MG_0           BIT0
#define  CAN_RXMGMASK_MG_1           BIT1
#define  CAN_RXMGMASK_MG_2           BIT2
#define  CAN_RXMGMASK_MG_3           BIT3
#define  CAN_RXMGMASK_MG_4           BIT4
#define  CAN_RXMGMASK_MG_5           BIT5
#define  CAN_RXMGMASK_MG_6           BIT6
#define  CAN_RXMGMASK_MG_7           BIT7
#define  CAN_RXMGMASK_MG_8           BIT8
#define  CAN_RXMGMASK_MG_9           BIT9
#define  CAN_RXMGMASK_MG_10          BIT10
#define  CAN_RXMGMASK_MG_11          BIT11
#define  CAN_RXMGMASK_MG_12          BIT12
#define  CAN_RXMGMASK_MG_13          BIT13
#define  CAN_RXMGMASK_MG_14          BIT14
#define  CAN_RXMGMASK_MG_15          BIT15
#define  CAN_RXMGMASK_MG_16          BIT16
#define  CAN_RXMGMASK_MG_17          BIT17
#define  CAN_RXMGMASK_MG_18          BIT18
#define  CAN_RXMGMASK_MG_19          BIT19
#define  CAN_RXMGMASK_MG_20          BIT20
#define  CAN_RXMGMASK_MG_21          BIT21
#define  CAN_RXMGMASK_MG_22          BIT22
#define  CAN_RXMGMASK_MG_23          BIT23
#define  CAN_RXMGMASK_MG_24          BIT24
#define  CAN_RXMGMASK_MG_25          BIT25
#define  CAN_RXMGMASK_MG_26          BIT26
#define  CAN_RXMGMASK_MG_27          BIT27
#define  CAN_RXMGMASK_MG_28          BIT28
#define  CAN_RXMGMASK_MG_29          BIT29
#define  CAN_RXMGMASK_MG_30          BIT30
#define  CAN_RXMGMASK_MG_31          BIT31

#define  CAN_RX14MASK_RX14M          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Rx Buffer 14 Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RX14MASK_RX14M_0        BIT0
#define  CAN_RX14MASK_RX14M_1        BIT1
#define  CAN_RX14MASK_RX14M_2        BIT2
#define  CAN_RX14MASK_RX14M_3        BIT3
#define  CAN_RX14MASK_RX14M_4        BIT4
#define  CAN_RX14MASK_RX14M_5        BIT5
#define  CAN_RX14MASK_RX14M_6        BIT6
#define  CAN_RX14MASK_RX14M_7        BIT7
#define  CAN_RX14MASK_RX14M_8        BIT8
#define  CAN_RX14MASK_RX14M_9        BIT9
#define  CAN_RX14MASK_RX14M_10       BIT10
#define  CAN_RX14MASK_RX14M_11       BIT11
#define  CAN_RX14MASK_RX14M_12       BIT12
#define  CAN_RX14MASK_RX14M_13       BIT13
#define  CAN_RX14MASK_RX14M_14       BIT14
#define  CAN_RX14MASK_RX14M_15       BIT15
#define  CAN_RX14MASK_RX14M_16       BIT16
#define  CAN_RX14MASK_RX14M_17       BIT17
#define  CAN_RX14MASK_RX14M_18       BIT18
#define  CAN_RX14MASK_RX14M_19       BIT19
#define  CAN_RX14MASK_RX14M_20       BIT20
#define  CAN_RX14MASK_RX14M_21       BIT21
#define  CAN_RX14MASK_RX14M_22       BIT22
#define  CAN_RX14MASK_RX14M_23       BIT23
#define  CAN_RX14MASK_RX14M_24       BIT24
#define  CAN_RX14MASK_RX14M_25       BIT25
#define  CAN_RX14MASK_RX14M_26       BIT26
#define  CAN_RX14MASK_RX14M_27       BIT27
#define  CAN_RX14MASK_RX14M_28       BIT28
#define  CAN_RX14MASK_RX14M_29       BIT29
#define  CAN_RX14MASK_RX14M_30       BIT30
#define  CAN_RX14MASK_RX14M_31       BIT31

#define  CAN_RX15MASK_RX15M          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Rx Buffer 15 Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RX15MASK_RX15M_0        BIT0
#define  CAN_RX15MASK_RX15M_1        BIT1
#define  CAN_RX15MASK_RX15M_2        BIT2
#define  CAN_RX15MASK_RX15M_3        BIT3
#define  CAN_RX15MASK_RX15M_4        BIT4
#define  CAN_RX15MASK_RX15M_5        BIT5
#define  CAN_RX15MASK_RX15M_6        BIT6
#define  CAN_RX15MASK_RX15M_7        BIT7
#define  CAN_RX15MASK_RX15M_8        BIT8
#define  CAN_RX15MASK_RX15M_9        BIT9
#define  CAN_RX15MASK_RX15M_10       BIT10
#define  CAN_RX15MASK_RX15M_11       BIT11
#define  CAN_RX15MASK_RX15M_12       BIT12
#define  CAN_RX15MASK_RX15M_13       BIT13
#define  CAN_RX15MASK_RX15M_14       BIT14
#define  CAN_RX15MASK_RX15M_15       BIT15
#define  CAN_RX15MASK_RX15M_16       BIT16
#define  CAN_RX15MASK_RX15M_17       BIT17
#define  CAN_RX15MASK_RX15M_18       BIT18
#define  CAN_RX15MASK_RX15M_19       BIT19
#define  CAN_RX15MASK_RX15M_20       BIT20
#define  CAN_RX15MASK_RX15M_21       BIT21
#define  CAN_RX15MASK_RX15M_22       BIT22
#define  CAN_RX15MASK_RX15M_23       BIT23
#define  CAN_RX15MASK_RX15M_24       BIT24
#define  CAN_RX15MASK_RX15M_25       BIT25
#define  CAN_RX15MASK_RX15M_26       BIT26
#define  CAN_RX15MASK_RX15M_27       BIT27
#define  CAN_RX15MASK_RX15M_28       BIT28
#define  CAN_RX15MASK_RX15M_29       BIT29
#define  CAN_RX15MASK_RX15M_30       BIT30
#define  CAN_RX15MASK_RX15M_31       BIT31

#define  CAN_ECR_TXERRCNT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Transmit Error Counter
#define  CAN_ECR_TXERRCNT_0          BIT0
#define  CAN_ECR_TXERRCNT_1          BIT1
#define  CAN_ECR_TXERRCNT_2          BIT2
#define  CAN_ECR_TXERRCNT_3          BIT3
#define  CAN_ECR_TXERRCNT_4          BIT4
#define  CAN_ECR_TXERRCNT_5          BIT5
#define  CAN_ECR_TXERRCNT_6          BIT6
#define  CAN_ECR_TXERRCNT_7          BIT7

#define  CAN_ECR_RXERRCNT            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Receive Error Counter
#define  CAN_ECR_RXERRCNT_0          BIT8
#define  CAN_ECR_RXERRCNT_1          BIT9
#define  CAN_ECR_RXERRCNT_2          BIT10
#define  CAN_ECR_RXERRCNT_3          BIT11
#define  CAN_ECR_RXERRCNT_4          BIT12
#define  CAN_ECR_RXERRCNT_5          BIT13
#define  CAN_ECR_RXERRCNT_6          BIT14
#define  CAN_ECR_RXERRCNT_7          BIT15

#define  CAN_ESR1_WAKINT             BIT0
//   Wake-Up Interrupt
//     0b0 ==> No such occurrence
//     0b1 ==> Indicates a recessive to dominant transition was received on the CAN bus

#define  CAN_ESR1_ERRINT             BIT1
//   Error Interrupt
//     0b0 ==> No such occurrence
//     0b1 ==> Indicates setting of any Error Bit in the Error and Status Register

#define  CAN_ESR1_BOFFINT            BIT2
//   'Bus Off' Interrupt
//     0b0 ==> No such occurrence
//     0b1 ==> FlexCAN module entered 'Bus Off' state

#define  CAN_ESR1_RX                 BIT3
//   FlexCAN in Reception
//     0b0 ==> FlexCAN is not receiving a message.
//     0b1 ==> FlexCAN is receiving a message.

#define  CAN_ESR1_FLTCONF            (BIT4|BIT5)
//   Fault Confinement State
//     0b00 ==> Error Active
//     0b01 ==> Error Passive
//     0b1x ==> Bus Off
#define  CAN_ESR1_FLTCONF_0          BIT4
#define  CAN_ESR1_FLTCONF_1          BIT5

#define  CAN_ESR1_TX                 BIT6
//   FlexCAN in Transmission
//     0b0 ==> FlexCAN is not transmitting a message.
//     0b1 ==> FlexCAN is transmitting a message.

#define  CAN_ESR1_IDLE               BIT7
//     0b0 ==> No such occurrence
//     0b1 ==> CAN bus is now IDLE.

#define  CAN_ESR1_RXWRN              BIT8
//   Rx Error Warning
//     0b0 ==> No such occurrence
//     0b1 ==> RXERRCNT is greater than or equal to 96.

#define  CAN_ESR1_TXWRN              BIT9
//   TX Error Warning
//     0b0 ==> No such occurrence
//     0b1 ==> TXERRCNT is greater than or equal to 96.

#define  CAN_ESR1_STFERR             BIT10
//   Stuffing Error
//     0b0 ==> No such occurrence
//     0b1 ==> A Stuffing Error occurred since last read of this register.

#define  CAN_ESR1_FRMERR             BIT11
//   Form Error
//     0b0 ==> No such occurrence
//     0b1 ==> A Form Error occurred since last read of this register.

#define  CAN_ESR1_CRCERR             BIT12
//   Cyclic Redundancy Check Error
//     0b0 ==> No such occurrence
//     0b1 ==> A CRC error occurred since last read of this register.

#define  CAN_ESR1_ACKERR             BIT13
//   Acknowledge Error
//     0b0 ==> No such occurrence
//     0b1 ==> An ACK error occurred since last read of this register.

#define  CAN_ESR1_BIT0ERR            BIT14
//   Bit0 Error
//     0b0 ==> No such occurrence
//     0b1 ==> At least one bit sent as dominant is received as recessive.

#define  CAN_ESR1_BIT1ERR            BIT15
//   Bit1 Error
//     0b0 ==> No such occurrence
//     0b1 ==> At least one bit sent as recessive is received as dominant.

#define  CAN_ESR1_RWRNINT            BIT16
//   Rx Warning Interrupt Flag
//     0b0 ==> No such occurrence
//     0b1 ==> The Rx error counter transitioned from less than 96 to greater than or equal to 96.

#define  CAN_ESR1_TWRNINT            BIT17
//   Tx Warning Interrupt Flag
//     0b0 ==> No such occurrence
//     0b1 ==> The Tx error counter transitioned from less than 96 to greater than or equal to 96.

#define  CAN_ESR1_SYNCH              BIT18
//   CAN Synchronization Status
//     0b0 ==> FlexCAN is not synchronized to the CAN bus.
//     0b1 ==> FlexCAN is synchronized to the CAN bus.

#define  CAN_IMASK2_BUFHM            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Buffer MBi Mask
//     0b0 ==> The corresponding buffer Interrupt is disabled.
//     0b1 ==> The corresponding buffer Interrupt is enabled.
#define  CAN_IMASK2_BUFHM_0          BIT0
#define  CAN_IMASK2_BUFHM_1          BIT1
#define  CAN_IMASK2_BUFHM_2          BIT2
#define  CAN_IMASK2_BUFHM_3          BIT3
#define  CAN_IMASK2_BUFHM_4          BIT4
#define  CAN_IMASK2_BUFHM_5          BIT5
#define  CAN_IMASK2_BUFHM_6          BIT6
#define  CAN_IMASK2_BUFHM_7          BIT7
#define  CAN_IMASK2_BUFHM_8          BIT8
#define  CAN_IMASK2_BUFHM_9          BIT9
#define  CAN_IMASK2_BUFHM_10         BIT10
#define  CAN_IMASK2_BUFHM_11         BIT11
#define  CAN_IMASK2_BUFHM_12         BIT12
#define  CAN_IMASK2_BUFHM_13         BIT13
#define  CAN_IMASK2_BUFHM_14         BIT14
#define  CAN_IMASK2_BUFHM_15         BIT15
#define  CAN_IMASK2_BUFHM_16         BIT16
#define  CAN_IMASK2_BUFHM_17         BIT17
#define  CAN_IMASK2_BUFHM_18         BIT18
#define  CAN_IMASK2_BUFHM_19         BIT19
#define  CAN_IMASK2_BUFHM_20         BIT20
#define  CAN_IMASK2_BUFHM_21         BIT21
#define  CAN_IMASK2_BUFHM_22         BIT22
#define  CAN_IMASK2_BUFHM_23         BIT23
#define  CAN_IMASK2_BUFHM_24         BIT24
#define  CAN_IMASK2_BUFHM_25         BIT25
#define  CAN_IMASK2_BUFHM_26         BIT26
#define  CAN_IMASK2_BUFHM_27         BIT27
#define  CAN_IMASK2_BUFHM_28         BIT28
#define  CAN_IMASK2_BUFHM_29         BIT29
#define  CAN_IMASK2_BUFHM_30         BIT30
#define  CAN_IMASK2_BUFHM_31         BIT31

#define  CAN_IMASK1_BUFLM            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Buffer MBi Mask
//     0b0 ==> The corresponding buffer Interrupt is disabled.
//     0b1 ==> The corresponding buffer Interrupt is enabled.
#define  CAN_IMASK1_BUFLM_0          BIT0
#define  CAN_IMASK1_BUFLM_1          BIT1
#define  CAN_IMASK1_BUFLM_2          BIT2
#define  CAN_IMASK1_BUFLM_3          BIT3
#define  CAN_IMASK1_BUFLM_4          BIT4
#define  CAN_IMASK1_BUFLM_5          BIT5
#define  CAN_IMASK1_BUFLM_6          BIT6
#define  CAN_IMASK1_BUFLM_7          BIT7
#define  CAN_IMASK1_BUFLM_8          BIT8
#define  CAN_IMASK1_BUFLM_9          BIT9
#define  CAN_IMASK1_BUFLM_10         BIT10
#define  CAN_IMASK1_BUFLM_11         BIT11
#define  CAN_IMASK1_BUFLM_12         BIT12
#define  CAN_IMASK1_BUFLM_13         BIT13
#define  CAN_IMASK1_BUFLM_14         BIT14
#define  CAN_IMASK1_BUFLM_15         BIT15
#define  CAN_IMASK1_BUFLM_16         BIT16
#define  CAN_IMASK1_BUFLM_17         BIT17
#define  CAN_IMASK1_BUFLM_18         BIT18
#define  CAN_IMASK1_BUFLM_19         BIT19
#define  CAN_IMASK1_BUFLM_20         BIT20
#define  CAN_IMASK1_BUFLM_21         BIT21
#define  CAN_IMASK1_BUFLM_22         BIT22
#define  CAN_IMASK1_BUFLM_23         BIT23
#define  CAN_IMASK1_BUFLM_24         BIT24
#define  CAN_IMASK1_BUFLM_25         BIT25
#define  CAN_IMASK1_BUFLM_26         BIT26
#define  CAN_IMASK1_BUFLM_27         BIT27
#define  CAN_IMASK1_BUFLM_28         BIT28
#define  CAN_IMASK1_BUFLM_29         BIT29
#define  CAN_IMASK1_BUFLM_30         BIT30
#define  CAN_IMASK1_BUFLM_31         BIT31

#define  CAN_IFLAG2_BUFHI            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Buffer MBi Interrupt
//     0b0 ==> The corresponding buffer has no occurrence of successfully completed transmission or reception.
//     0b1 ==> The corresponding buffer has successfully completed transmission or reception.
#define  CAN_IFLAG2_BUFHI_0          BIT0
#define  CAN_IFLAG2_BUFHI_1          BIT1
#define  CAN_IFLAG2_BUFHI_2          BIT2
#define  CAN_IFLAG2_BUFHI_3          BIT3
#define  CAN_IFLAG2_BUFHI_4          BIT4
#define  CAN_IFLAG2_BUFHI_5          BIT5
#define  CAN_IFLAG2_BUFHI_6          BIT6
#define  CAN_IFLAG2_BUFHI_7          BIT7
#define  CAN_IFLAG2_BUFHI_8          BIT8
#define  CAN_IFLAG2_BUFHI_9          BIT9
#define  CAN_IFLAG2_BUFHI_10         BIT10
#define  CAN_IFLAG2_BUFHI_11         BIT11
#define  CAN_IFLAG2_BUFHI_12         BIT12
#define  CAN_IFLAG2_BUFHI_13         BIT13
#define  CAN_IFLAG2_BUFHI_14         BIT14
#define  CAN_IFLAG2_BUFHI_15         BIT15
#define  CAN_IFLAG2_BUFHI_16         BIT16
#define  CAN_IFLAG2_BUFHI_17         BIT17
#define  CAN_IFLAG2_BUFHI_18         BIT18
#define  CAN_IFLAG2_BUFHI_19         BIT19
#define  CAN_IFLAG2_BUFHI_20         BIT20
#define  CAN_IFLAG2_BUFHI_21         BIT21
#define  CAN_IFLAG2_BUFHI_22         BIT22
#define  CAN_IFLAG2_BUFHI_23         BIT23
#define  CAN_IFLAG2_BUFHI_24         BIT24
#define  CAN_IFLAG2_BUFHI_25         BIT25
#define  CAN_IFLAG2_BUFHI_26         BIT26
#define  CAN_IFLAG2_BUFHI_27         BIT27
#define  CAN_IFLAG2_BUFHI_28         BIT28
#define  CAN_IFLAG2_BUFHI_29         BIT29
#define  CAN_IFLAG2_BUFHI_30         BIT30
#define  CAN_IFLAG2_BUFHI_31         BIT31

#define  CAN_IFLAG1_BUF4TO0I         (BIT0|BIT1|BIT2|BIT3|BIT4)
//   Buffer MBi Interrupt or "reserved"
//     0b0 ==> The corresponding buffer has no occurrence of successfully completed transmission or reception (when MCR[RFEN]=0).
//     0b1 ==> The corresponding buffer has successfully completed transmission or reception (when MCR[RFEN]=0).
#define  CAN_IFLAG1_BUF4TO0I_0       BIT0
#define  CAN_IFLAG1_BUF4TO0I_1       BIT1
#define  CAN_IFLAG1_BUF4TO0I_2       BIT2
#define  CAN_IFLAG1_BUF4TO0I_3       BIT3
#define  CAN_IFLAG1_BUF4TO0I_4       BIT4

#define  CAN_IFLAG1_BUF5I            BIT5
//   Buffer MB5 Interrupt or "Frames available in Rx FIFO"
//     0b0 ==> No occurrence of MB5 completing transmission/reception (when MCR[RFEN]=0) or of frame(s) available in the Rx FIFO (when MCR[RFEN]=1)
//     0b1 ==> MB5 completed transmission/reception (when MCR[RFEN]=0) or frame(s) available in the Rx FIFO (when MCR[RFEN]=1)

#define  CAN_IFLAG1_BUF6I            BIT6
//   Buffer MB6 Interrupt or "Rx FIFO Warning"
//     0b0 ==> No occurrence of MB6 completing transmission/reception (when MCR[RFEN]=0) or of Rx FIFO almost full (when MCR[RFEN]=1)
//     0b1 ==> MB6 completed transmission/reception (when MCR[RFEN]=0) or Rx FIFO almost full (when MCR[RFEN]=1)

#define  CAN_IFLAG1_BUF7I            BIT7
//   Buffer MB7 Interrupt or "Rx FIFO Overflow"
//     0b0 ==> No occurrence of MB7 completing transmission/reception (when MCR[RFEN]=0) or of Rx FIFO overflow (when MCR[RFEN]=1)
//     0b1 ==> MB7 completed transmission/reception (when MCR[RFEN]=0) or Rx FIFO overflow (when MCR[RFEN]=1)

#define  CAN_IFLAG1_BUF31TO8I        (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Buffer MBi Interrupt
//     0b0 ==> The corresponding buffer has no occurrence of successfully completed transmission or reception.
//     0b1 ==> The corresponding buffer has successfully completed transmission or reception.
#define  CAN_IFLAG1_BUF31TO8I_0      BIT8
#define  CAN_IFLAG1_BUF31TO8I_1      BIT9
#define  CAN_IFLAG1_BUF31TO8I_2      BIT10
#define  CAN_IFLAG1_BUF31TO8I_3      BIT11
#define  CAN_IFLAG1_BUF31TO8I_4      BIT12
#define  CAN_IFLAG1_BUF31TO8I_5      BIT13
#define  CAN_IFLAG1_BUF31TO8I_6      BIT14
#define  CAN_IFLAG1_BUF31TO8I_7      BIT15
#define  CAN_IFLAG1_BUF31TO8I_8      BIT16
#define  CAN_IFLAG1_BUF31TO8I_9      BIT17
#define  CAN_IFLAG1_BUF31TO8I_10     BIT18
#define  CAN_IFLAG1_BUF31TO8I_11     BIT19
#define  CAN_IFLAG1_BUF31TO8I_12     BIT20
#define  CAN_IFLAG1_BUF31TO8I_13     BIT21
#define  CAN_IFLAG1_BUF31TO8I_14     BIT22
#define  CAN_IFLAG1_BUF31TO8I_15     BIT23
#define  CAN_IFLAG1_BUF31TO8I_16     BIT24
#define  CAN_IFLAG1_BUF31TO8I_17     BIT25
#define  CAN_IFLAG1_BUF31TO8I_18     BIT26
#define  CAN_IFLAG1_BUF31TO8I_19     BIT27
#define  CAN_IFLAG1_BUF31TO8I_20     BIT28
#define  CAN_IFLAG1_BUF31TO8I_21     BIT29
#define  CAN_IFLAG1_BUF31TO8I_22     BIT30
#define  CAN_IFLAG1_BUF31TO8I_23     BIT31

#define  CAN_CTRL2_EACEN             BIT16
//   Entire Frame Arbitration Field Comparison Enable for Rx Mailboxes
//     0b0 ==> Rx Mailbox filter's IDE bit is always compared and RTR is never compared despite mask bits.
//     0b1 ==> Enables the comparison of both Rx Mailbox filter's IDE and RTR bit with their corresponding bits within the incoming frame. Mask bits do apply.

#define  CAN_CTRL2_RRS               BIT17
//   Remote Request Storing
//     0b0 ==> Remote Response Frame is generated.
//     0b1 ==> Remote Request Frame is stored.

#define  CAN_CTRL2_MRP               BIT18
//   Mailboxes Reception Priority
//     0b0 ==> Matching starts from Rx FIFO and continues on Mailboxes.
//     0b1 ==> Matching starts from Mailboxes and continues on Rx FIFO.

#define  CAN_CTRL2_TASD              (BIT19|BIT20|BIT21|BIT22|BIT23)
//   Tx Arbitration Start Delay
#define  CAN_CTRL2_TASD_0            BIT19
#define  CAN_CTRL2_TASD_1            BIT20
#define  CAN_CTRL2_TASD_2            BIT21
#define  CAN_CTRL2_TASD_3            BIT22
#define  CAN_CTRL2_TASD_4            BIT23

#define  CAN_CTRL2_RFFN              (BIT24|BIT25|BIT26|BIT27)
//   Number of Rx FIFO Filters
#define  CAN_CTRL2_RFFN_0            BIT24
#define  CAN_CTRL2_RFFN_1            BIT25
#define  CAN_CTRL2_RFFN_2            BIT26
#define  CAN_CTRL2_RFFN_3            BIT27

#define  CAN_CTRL2_WRMFRZ            BIT28
//   Write-Access to Memory in Freeze mode
//     0b0 ==> Maintain the write access restrictions.
//     0b1 ==> Enable unrestricted write access to FlexCAN memory.

#define  CAN_ESR2_IMB                BIT13
//   Inactive Mailbox
//     0b0 ==> If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive Mailbox.
//     0b1 ==> If ESR2[VPS] is asserted, there is at least one inactive Mailbox. LPTM content is the number of the first one.

#define  CAN_ESR2_VPS                BIT14
//   Valid Priority Status
//     0b0 ==> Contents of IMB and LPTM are invalid.
//     0b1 ==> Contents of IMB and LPTM are valid.

#define  CAN_ESR2_LPTM               (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22)
//   Lowest Priority Tx Mailbox
#define  CAN_ESR2_LPTM_0             BIT16
#define  CAN_ESR2_LPTM_1             BIT17
#define  CAN_ESR2_LPTM_2             BIT18
#define  CAN_ESR2_LPTM_3             BIT19
#define  CAN_ESR2_LPTM_4             BIT20
#define  CAN_ESR2_LPTM_5             BIT21
#define  CAN_ESR2_LPTM_6             BIT22

#define  CAN_CRCR_TXCRC              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   CRC Transmitted
#define  CAN_CRCR_TXCRC_0            BIT0
#define  CAN_CRCR_TXCRC_1            BIT1
#define  CAN_CRCR_TXCRC_2            BIT2
#define  CAN_CRCR_TXCRC_3            BIT3
#define  CAN_CRCR_TXCRC_4            BIT4
#define  CAN_CRCR_TXCRC_5            BIT5
#define  CAN_CRCR_TXCRC_6            BIT6
#define  CAN_CRCR_TXCRC_7            BIT7
#define  CAN_CRCR_TXCRC_8            BIT8
#define  CAN_CRCR_TXCRC_9            BIT9
#define  CAN_CRCR_TXCRC_10           BIT10
#define  CAN_CRCR_TXCRC_11           BIT11
#define  CAN_CRCR_TXCRC_12           BIT12
#define  CAN_CRCR_TXCRC_13           BIT13
#define  CAN_CRCR_TXCRC_14           BIT14

#define  CAN_CRCR_MBCRC              (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22)
//   CRC Mailbox
#define  CAN_CRCR_MBCRC_0            BIT16
#define  CAN_CRCR_MBCRC_1            BIT17
#define  CAN_CRCR_MBCRC_2            BIT18
#define  CAN_CRCR_MBCRC_3            BIT19
#define  CAN_CRCR_MBCRC_4            BIT20
#define  CAN_CRCR_MBCRC_5            BIT21
#define  CAN_CRCR_MBCRC_6            BIT22

#define  CAN_RXFGMASK_FGM            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Rx FIFO Global Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXFGMASK_FGM_0          BIT0
#define  CAN_RXFGMASK_FGM_1          BIT1
#define  CAN_RXFGMASK_FGM_2          BIT2
#define  CAN_RXFGMASK_FGM_3          BIT3
#define  CAN_RXFGMASK_FGM_4          BIT4
#define  CAN_RXFGMASK_FGM_5          BIT5
#define  CAN_RXFGMASK_FGM_6          BIT6
#define  CAN_RXFGMASK_FGM_7          BIT7
#define  CAN_RXFGMASK_FGM_8          BIT8
#define  CAN_RXFGMASK_FGM_9          BIT9
#define  CAN_RXFGMASK_FGM_10         BIT10
#define  CAN_RXFGMASK_FGM_11         BIT11
#define  CAN_RXFGMASK_FGM_12         BIT12
#define  CAN_RXFGMASK_FGM_13         BIT13
#define  CAN_RXFGMASK_FGM_14         BIT14
#define  CAN_RXFGMASK_FGM_15         BIT15
#define  CAN_RXFGMASK_FGM_16         BIT16
#define  CAN_RXFGMASK_FGM_17         BIT17
#define  CAN_RXFGMASK_FGM_18         BIT18
#define  CAN_RXFGMASK_FGM_19         BIT19
#define  CAN_RXFGMASK_FGM_20         BIT20
#define  CAN_RXFGMASK_FGM_21         BIT21
#define  CAN_RXFGMASK_FGM_22         BIT22
#define  CAN_RXFGMASK_FGM_23         BIT23
#define  CAN_RXFGMASK_FGM_24         BIT24
#define  CAN_RXFGMASK_FGM_25         BIT25
#define  CAN_RXFGMASK_FGM_26         BIT26
#define  CAN_RXFGMASK_FGM_27         BIT27
#define  CAN_RXFGMASK_FGM_28         BIT28
#define  CAN_RXFGMASK_FGM_29         BIT29
#define  CAN_RXFGMASK_FGM_30         BIT30
#define  CAN_RXFGMASK_FGM_31         BIT31

#define  CAN_RXFIR_IDHIT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
//   Identifier Acceptance Filter Hit Indicator
#define  CAN_RXFIR_IDHIT_0           BIT0
#define  CAN_RXFIR_IDHIT_1           BIT1
#define  CAN_RXFIR_IDHIT_2           BIT2
#define  CAN_RXFIR_IDHIT_3           BIT3
#define  CAN_RXFIR_IDHIT_4           BIT4
#define  CAN_RXFIR_IDHIT_5           BIT5
#define  CAN_RXFIR_IDHIT_6           BIT6
#define  CAN_RXFIR_IDHIT_7           BIT7
#define  CAN_RXFIR_IDHIT_8           BIT8

#define  CAN_CS0_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS0_TIME_STAMP_0        BIT0
#define  CAN_CS0_TIME_STAMP_1        BIT1
#define  CAN_CS0_TIME_STAMP_2        BIT2
#define  CAN_CS0_TIME_STAMP_3        BIT3
#define  CAN_CS0_TIME_STAMP_4        BIT4
#define  CAN_CS0_TIME_STAMP_5        BIT5
#define  CAN_CS0_TIME_STAMP_6        BIT6
#define  CAN_CS0_TIME_STAMP_7        BIT7
#define  CAN_CS0_TIME_STAMP_8        BIT8
#define  CAN_CS0_TIME_STAMP_9        BIT9
#define  CAN_CS0_TIME_STAMP_10       BIT10
#define  CAN_CS0_TIME_STAMP_11       BIT11
#define  CAN_CS0_TIME_STAMP_12       BIT12
#define  CAN_CS0_TIME_STAMP_13       BIT13
#define  CAN_CS0_TIME_STAMP_14       BIT14
#define  CAN_CS0_TIME_STAMP_15       BIT15

#define  CAN_CS0_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS0_DLC_0               BIT16
#define  CAN_CS0_DLC_1               BIT17
#define  CAN_CS0_DLC_2               BIT18
#define  CAN_CS0_DLC_3               BIT19

#define  CAN_CS0_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS0_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS0_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS0_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS0_CODE_0              BIT24
#define  CAN_CS0_CODE_1              BIT25
#define  CAN_CS0_CODE_2              BIT26
#define  CAN_CS0_CODE_3              BIT27

#define  CAN_ID0_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID0_EXT_0               BIT0
#define  CAN_ID0_EXT_1               BIT1
#define  CAN_ID0_EXT_2               BIT2
#define  CAN_ID0_EXT_3               BIT3
#define  CAN_ID0_EXT_4               BIT4
#define  CAN_ID0_EXT_5               BIT5
#define  CAN_ID0_EXT_6               BIT6
#define  CAN_ID0_EXT_7               BIT7
#define  CAN_ID0_EXT_8               BIT8
#define  CAN_ID0_EXT_9               BIT9
#define  CAN_ID0_EXT_10              BIT10
#define  CAN_ID0_EXT_11              BIT11
#define  CAN_ID0_EXT_12              BIT12
#define  CAN_ID0_EXT_13              BIT13
#define  CAN_ID0_EXT_14              BIT14
#define  CAN_ID0_EXT_15              BIT15
#define  CAN_ID0_EXT_16              BIT16
#define  CAN_ID0_EXT_17              BIT17

#define  CAN_ID0_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID0_STD_0               BIT18
#define  CAN_ID0_STD_1               BIT19
#define  CAN_ID0_STD_2               BIT20
#define  CAN_ID0_STD_3               BIT21
#define  CAN_ID0_STD_4               BIT22
#define  CAN_ID0_STD_5               BIT23
#define  CAN_ID0_STD_6               BIT24
#define  CAN_ID0_STD_7               BIT25
#define  CAN_ID0_STD_8               BIT26
#define  CAN_ID0_STD_9               BIT27
#define  CAN_ID0_STD_10              BIT28

#define  CAN_ID0_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID0_PRIO_0              BIT29
#define  CAN_ID0_PRIO_1              BIT30
#define  CAN_ID0_PRIO_2              BIT31

#define  CAN_WORD00_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD00_DATA_BYTE_3_0    BIT0
#define  CAN_WORD00_DATA_BYTE_3_1    BIT1
#define  CAN_WORD00_DATA_BYTE_3_2    BIT2
#define  CAN_WORD00_DATA_BYTE_3_3    BIT3
#define  CAN_WORD00_DATA_BYTE_3_4    BIT4
#define  CAN_WORD00_DATA_BYTE_3_5    BIT5
#define  CAN_WORD00_DATA_BYTE_3_6    BIT6
#define  CAN_WORD00_DATA_BYTE_3_7    BIT7

#define  CAN_WORD00_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD00_DATA_BYTE_2_0    BIT8
#define  CAN_WORD00_DATA_BYTE_2_1    BIT9
#define  CAN_WORD00_DATA_BYTE_2_2    BIT10
#define  CAN_WORD00_DATA_BYTE_2_3    BIT11
#define  CAN_WORD00_DATA_BYTE_2_4    BIT12
#define  CAN_WORD00_DATA_BYTE_2_5    BIT13
#define  CAN_WORD00_DATA_BYTE_2_6    BIT14
#define  CAN_WORD00_DATA_BYTE_2_7    BIT15

#define  CAN_WORD00_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD00_DATA_BYTE_1_0    BIT16
#define  CAN_WORD00_DATA_BYTE_1_1    BIT17
#define  CAN_WORD00_DATA_BYTE_1_2    BIT18
#define  CAN_WORD00_DATA_BYTE_1_3    BIT19
#define  CAN_WORD00_DATA_BYTE_1_4    BIT20
#define  CAN_WORD00_DATA_BYTE_1_5    BIT21
#define  CAN_WORD00_DATA_BYTE_1_6    BIT22
#define  CAN_WORD00_DATA_BYTE_1_7    BIT23

#define  CAN_WORD00_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD00_DATA_BYTE_0_0    BIT24
#define  CAN_WORD00_DATA_BYTE_0_1    BIT25
#define  CAN_WORD00_DATA_BYTE_0_2    BIT26
#define  CAN_WORD00_DATA_BYTE_0_3    BIT27
#define  CAN_WORD00_DATA_BYTE_0_4    BIT28
#define  CAN_WORD00_DATA_BYTE_0_5    BIT29
#define  CAN_WORD00_DATA_BYTE_0_6    BIT30
#define  CAN_WORD00_DATA_BYTE_0_7    BIT31

#define  CAN_WORD10_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD10_DATA_BYTE_7_0    BIT0
#define  CAN_WORD10_DATA_BYTE_7_1    BIT1
#define  CAN_WORD10_DATA_BYTE_7_2    BIT2
#define  CAN_WORD10_DATA_BYTE_7_3    BIT3
#define  CAN_WORD10_DATA_BYTE_7_4    BIT4
#define  CAN_WORD10_DATA_BYTE_7_5    BIT5
#define  CAN_WORD10_DATA_BYTE_7_6    BIT6
#define  CAN_WORD10_DATA_BYTE_7_7    BIT7

#define  CAN_WORD10_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD10_DATA_BYTE_6_0    BIT8
#define  CAN_WORD10_DATA_BYTE_6_1    BIT9
#define  CAN_WORD10_DATA_BYTE_6_2    BIT10
#define  CAN_WORD10_DATA_BYTE_6_3    BIT11
#define  CAN_WORD10_DATA_BYTE_6_4    BIT12
#define  CAN_WORD10_DATA_BYTE_6_5    BIT13
#define  CAN_WORD10_DATA_BYTE_6_6    BIT14
#define  CAN_WORD10_DATA_BYTE_6_7    BIT15

#define  CAN_WORD10_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD10_DATA_BYTE_5_0    BIT16
#define  CAN_WORD10_DATA_BYTE_5_1    BIT17
#define  CAN_WORD10_DATA_BYTE_5_2    BIT18
#define  CAN_WORD10_DATA_BYTE_5_3    BIT19
#define  CAN_WORD10_DATA_BYTE_5_4    BIT20
#define  CAN_WORD10_DATA_BYTE_5_5    BIT21
#define  CAN_WORD10_DATA_BYTE_5_6    BIT22
#define  CAN_WORD10_DATA_BYTE_5_7    BIT23

#define  CAN_WORD10_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD10_DATA_BYTE_4_0    BIT24
#define  CAN_WORD10_DATA_BYTE_4_1    BIT25
#define  CAN_WORD10_DATA_BYTE_4_2    BIT26
#define  CAN_WORD10_DATA_BYTE_4_3    BIT27
#define  CAN_WORD10_DATA_BYTE_4_4    BIT28
#define  CAN_WORD10_DATA_BYTE_4_5    BIT29
#define  CAN_WORD10_DATA_BYTE_4_6    BIT30
#define  CAN_WORD10_DATA_BYTE_4_7    BIT31

#define  CAN_CS1_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS1_TIME_STAMP_0        BIT0
#define  CAN_CS1_TIME_STAMP_1        BIT1
#define  CAN_CS1_TIME_STAMP_2        BIT2
#define  CAN_CS1_TIME_STAMP_3        BIT3
#define  CAN_CS1_TIME_STAMP_4        BIT4
#define  CAN_CS1_TIME_STAMP_5        BIT5
#define  CAN_CS1_TIME_STAMP_6        BIT6
#define  CAN_CS1_TIME_STAMP_7        BIT7
#define  CAN_CS1_TIME_STAMP_8        BIT8
#define  CAN_CS1_TIME_STAMP_9        BIT9
#define  CAN_CS1_TIME_STAMP_10       BIT10
#define  CAN_CS1_TIME_STAMP_11       BIT11
#define  CAN_CS1_TIME_STAMP_12       BIT12
#define  CAN_CS1_TIME_STAMP_13       BIT13
#define  CAN_CS1_TIME_STAMP_14       BIT14
#define  CAN_CS1_TIME_STAMP_15       BIT15

#define  CAN_CS1_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS1_DLC_0               BIT16
#define  CAN_CS1_DLC_1               BIT17
#define  CAN_CS1_DLC_2               BIT18
#define  CAN_CS1_DLC_3               BIT19

#define  CAN_CS1_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS1_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS1_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS1_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS1_CODE_0              BIT24
#define  CAN_CS1_CODE_1              BIT25
#define  CAN_CS1_CODE_2              BIT26
#define  CAN_CS1_CODE_3              BIT27

#define  CAN_ID1_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID1_EXT_0               BIT0
#define  CAN_ID1_EXT_1               BIT1
#define  CAN_ID1_EXT_2               BIT2
#define  CAN_ID1_EXT_3               BIT3
#define  CAN_ID1_EXT_4               BIT4
#define  CAN_ID1_EXT_5               BIT5
#define  CAN_ID1_EXT_6               BIT6
#define  CAN_ID1_EXT_7               BIT7
#define  CAN_ID1_EXT_8               BIT8
#define  CAN_ID1_EXT_9               BIT9
#define  CAN_ID1_EXT_10              BIT10
#define  CAN_ID1_EXT_11              BIT11
#define  CAN_ID1_EXT_12              BIT12
#define  CAN_ID1_EXT_13              BIT13
#define  CAN_ID1_EXT_14              BIT14
#define  CAN_ID1_EXT_15              BIT15
#define  CAN_ID1_EXT_16              BIT16
#define  CAN_ID1_EXT_17              BIT17

#define  CAN_ID1_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID1_STD_0               BIT18
#define  CAN_ID1_STD_1               BIT19
#define  CAN_ID1_STD_2               BIT20
#define  CAN_ID1_STD_3               BIT21
#define  CAN_ID1_STD_4               BIT22
#define  CAN_ID1_STD_5               BIT23
#define  CAN_ID1_STD_6               BIT24
#define  CAN_ID1_STD_7               BIT25
#define  CAN_ID1_STD_8               BIT26
#define  CAN_ID1_STD_9               BIT27
#define  CAN_ID1_STD_10              BIT28

#define  CAN_ID1_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID1_PRIO_0              BIT29
#define  CAN_ID1_PRIO_1              BIT30
#define  CAN_ID1_PRIO_2              BIT31

#define  CAN_WORD01_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD01_DATA_BYTE_3_0    BIT0
#define  CAN_WORD01_DATA_BYTE_3_1    BIT1
#define  CAN_WORD01_DATA_BYTE_3_2    BIT2
#define  CAN_WORD01_DATA_BYTE_3_3    BIT3
#define  CAN_WORD01_DATA_BYTE_3_4    BIT4
#define  CAN_WORD01_DATA_BYTE_3_5    BIT5
#define  CAN_WORD01_DATA_BYTE_3_6    BIT6
#define  CAN_WORD01_DATA_BYTE_3_7    BIT7

#define  CAN_WORD01_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD01_DATA_BYTE_2_0    BIT8
#define  CAN_WORD01_DATA_BYTE_2_1    BIT9
#define  CAN_WORD01_DATA_BYTE_2_2    BIT10
#define  CAN_WORD01_DATA_BYTE_2_3    BIT11
#define  CAN_WORD01_DATA_BYTE_2_4    BIT12
#define  CAN_WORD01_DATA_BYTE_2_5    BIT13
#define  CAN_WORD01_DATA_BYTE_2_6    BIT14
#define  CAN_WORD01_DATA_BYTE_2_7    BIT15

#define  CAN_WORD01_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD01_DATA_BYTE_1_0    BIT16
#define  CAN_WORD01_DATA_BYTE_1_1    BIT17
#define  CAN_WORD01_DATA_BYTE_1_2    BIT18
#define  CAN_WORD01_DATA_BYTE_1_3    BIT19
#define  CAN_WORD01_DATA_BYTE_1_4    BIT20
#define  CAN_WORD01_DATA_BYTE_1_5    BIT21
#define  CAN_WORD01_DATA_BYTE_1_6    BIT22
#define  CAN_WORD01_DATA_BYTE_1_7    BIT23

#define  CAN_WORD01_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD01_DATA_BYTE_0_0    BIT24
#define  CAN_WORD01_DATA_BYTE_0_1    BIT25
#define  CAN_WORD01_DATA_BYTE_0_2    BIT26
#define  CAN_WORD01_DATA_BYTE_0_3    BIT27
#define  CAN_WORD01_DATA_BYTE_0_4    BIT28
#define  CAN_WORD01_DATA_BYTE_0_5    BIT29
#define  CAN_WORD01_DATA_BYTE_0_6    BIT30
#define  CAN_WORD01_DATA_BYTE_0_7    BIT31

#define  CAN_WORD11_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD11_DATA_BYTE_7_0    BIT0
#define  CAN_WORD11_DATA_BYTE_7_1    BIT1
#define  CAN_WORD11_DATA_BYTE_7_2    BIT2
#define  CAN_WORD11_DATA_BYTE_7_3    BIT3
#define  CAN_WORD11_DATA_BYTE_7_4    BIT4
#define  CAN_WORD11_DATA_BYTE_7_5    BIT5
#define  CAN_WORD11_DATA_BYTE_7_6    BIT6
#define  CAN_WORD11_DATA_BYTE_7_7    BIT7

#define  CAN_WORD11_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD11_DATA_BYTE_6_0    BIT8
#define  CAN_WORD11_DATA_BYTE_6_1    BIT9
#define  CAN_WORD11_DATA_BYTE_6_2    BIT10
#define  CAN_WORD11_DATA_BYTE_6_3    BIT11
#define  CAN_WORD11_DATA_BYTE_6_4    BIT12
#define  CAN_WORD11_DATA_BYTE_6_5    BIT13
#define  CAN_WORD11_DATA_BYTE_6_6    BIT14
#define  CAN_WORD11_DATA_BYTE_6_7    BIT15

#define  CAN_WORD11_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD11_DATA_BYTE_5_0    BIT16
#define  CAN_WORD11_DATA_BYTE_5_1    BIT17
#define  CAN_WORD11_DATA_BYTE_5_2    BIT18
#define  CAN_WORD11_DATA_BYTE_5_3    BIT19
#define  CAN_WORD11_DATA_BYTE_5_4    BIT20
#define  CAN_WORD11_DATA_BYTE_5_5    BIT21
#define  CAN_WORD11_DATA_BYTE_5_6    BIT22
#define  CAN_WORD11_DATA_BYTE_5_7    BIT23

#define  CAN_WORD11_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD11_DATA_BYTE_4_0    BIT24
#define  CAN_WORD11_DATA_BYTE_4_1    BIT25
#define  CAN_WORD11_DATA_BYTE_4_2    BIT26
#define  CAN_WORD11_DATA_BYTE_4_3    BIT27
#define  CAN_WORD11_DATA_BYTE_4_4    BIT28
#define  CAN_WORD11_DATA_BYTE_4_5    BIT29
#define  CAN_WORD11_DATA_BYTE_4_6    BIT30
#define  CAN_WORD11_DATA_BYTE_4_7    BIT31

#define  CAN_CS2_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS2_TIME_STAMP_0        BIT0
#define  CAN_CS2_TIME_STAMP_1        BIT1
#define  CAN_CS2_TIME_STAMP_2        BIT2
#define  CAN_CS2_TIME_STAMP_3        BIT3
#define  CAN_CS2_TIME_STAMP_4        BIT4
#define  CAN_CS2_TIME_STAMP_5        BIT5
#define  CAN_CS2_TIME_STAMP_6        BIT6
#define  CAN_CS2_TIME_STAMP_7        BIT7
#define  CAN_CS2_TIME_STAMP_8        BIT8
#define  CAN_CS2_TIME_STAMP_9        BIT9
#define  CAN_CS2_TIME_STAMP_10       BIT10
#define  CAN_CS2_TIME_STAMP_11       BIT11
#define  CAN_CS2_TIME_STAMP_12       BIT12
#define  CAN_CS2_TIME_STAMP_13       BIT13
#define  CAN_CS2_TIME_STAMP_14       BIT14
#define  CAN_CS2_TIME_STAMP_15       BIT15

#define  CAN_CS2_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS2_DLC_0               BIT16
#define  CAN_CS2_DLC_1               BIT17
#define  CAN_CS2_DLC_2               BIT18
#define  CAN_CS2_DLC_3               BIT19

#define  CAN_CS2_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS2_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS2_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS2_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS2_CODE_0              BIT24
#define  CAN_CS2_CODE_1              BIT25
#define  CAN_CS2_CODE_2              BIT26
#define  CAN_CS2_CODE_3              BIT27

#define  CAN_ID2_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID2_EXT_0               BIT0
#define  CAN_ID2_EXT_1               BIT1
#define  CAN_ID2_EXT_2               BIT2
#define  CAN_ID2_EXT_3               BIT3
#define  CAN_ID2_EXT_4               BIT4
#define  CAN_ID2_EXT_5               BIT5
#define  CAN_ID2_EXT_6               BIT6
#define  CAN_ID2_EXT_7               BIT7
#define  CAN_ID2_EXT_8               BIT8
#define  CAN_ID2_EXT_9               BIT9
#define  CAN_ID2_EXT_10              BIT10
#define  CAN_ID2_EXT_11              BIT11
#define  CAN_ID2_EXT_12              BIT12
#define  CAN_ID2_EXT_13              BIT13
#define  CAN_ID2_EXT_14              BIT14
#define  CAN_ID2_EXT_15              BIT15
#define  CAN_ID2_EXT_16              BIT16
#define  CAN_ID2_EXT_17              BIT17

#define  CAN_ID2_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID2_STD_0               BIT18
#define  CAN_ID2_STD_1               BIT19
#define  CAN_ID2_STD_2               BIT20
#define  CAN_ID2_STD_3               BIT21
#define  CAN_ID2_STD_4               BIT22
#define  CAN_ID2_STD_5               BIT23
#define  CAN_ID2_STD_6               BIT24
#define  CAN_ID2_STD_7               BIT25
#define  CAN_ID2_STD_8               BIT26
#define  CAN_ID2_STD_9               BIT27
#define  CAN_ID2_STD_10              BIT28

#define  CAN_ID2_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID2_PRIO_0              BIT29
#define  CAN_ID2_PRIO_1              BIT30
#define  CAN_ID2_PRIO_2              BIT31

#define  CAN_WORD02_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD02_DATA_BYTE_3_0    BIT0
#define  CAN_WORD02_DATA_BYTE_3_1    BIT1
#define  CAN_WORD02_DATA_BYTE_3_2    BIT2
#define  CAN_WORD02_DATA_BYTE_3_3    BIT3
#define  CAN_WORD02_DATA_BYTE_3_4    BIT4
#define  CAN_WORD02_DATA_BYTE_3_5    BIT5
#define  CAN_WORD02_DATA_BYTE_3_6    BIT6
#define  CAN_WORD02_DATA_BYTE_3_7    BIT7

#define  CAN_WORD02_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD02_DATA_BYTE_2_0    BIT8
#define  CAN_WORD02_DATA_BYTE_2_1    BIT9
#define  CAN_WORD02_DATA_BYTE_2_2    BIT10
#define  CAN_WORD02_DATA_BYTE_2_3    BIT11
#define  CAN_WORD02_DATA_BYTE_2_4    BIT12
#define  CAN_WORD02_DATA_BYTE_2_5    BIT13
#define  CAN_WORD02_DATA_BYTE_2_6    BIT14
#define  CAN_WORD02_DATA_BYTE_2_7    BIT15

#define  CAN_WORD02_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD02_DATA_BYTE_1_0    BIT16
#define  CAN_WORD02_DATA_BYTE_1_1    BIT17
#define  CAN_WORD02_DATA_BYTE_1_2    BIT18
#define  CAN_WORD02_DATA_BYTE_1_3    BIT19
#define  CAN_WORD02_DATA_BYTE_1_4    BIT20
#define  CAN_WORD02_DATA_BYTE_1_5    BIT21
#define  CAN_WORD02_DATA_BYTE_1_6    BIT22
#define  CAN_WORD02_DATA_BYTE_1_7    BIT23

#define  CAN_WORD02_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD02_DATA_BYTE_0_0    BIT24
#define  CAN_WORD02_DATA_BYTE_0_1    BIT25
#define  CAN_WORD02_DATA_BYTE_0_2    BIT26
#define  CAN_WORD02_DATA_BYTE_0_3    BIT27
#define  CAN_WORD02_DATA_BYTE_0_4    BIT28
#define  CAN_WORD02_DATA_BYTE_0_5    BIT29
#define  CAN_WORD02_DATA_BYTE_0_6    BIT30
#define  CAN_WORD02_DATA_BYTE_0_7    BIT31

#define  CAN_WORD12_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD12_DATA_BYTE_7_0    BIT0
#define  CAN_WORD12_DATA_BYTE_7_1    BIT1
#define  CAN_WORD12_DATA_BYTE_7_2    BIT2
#define  CAN_WORD12_DATA_BYTE_7_3    BIT3
#define  CAN_WORD12_DATA_BYTE_7_4    BIT4
#define  CAN_WORD12_DATA_BYTE_7_5    BIT5
#define  CAN_WORD12_DATA_BYTE_7_6    BIT6
#define  CAN_WORD12_DATA_BYTE_7_7    BIT7

#define  CAN_WORD12_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD12_DATA_BYTE_6_0    BIT8
#define  CAN_WORD12_DATA_BYTE_6_1    BIT9
#define  CAN_WORD12_DATA_BYTE_6_2    BIT10
#define  CAN_WORD12_DATA_BYTE_6_3    BIT11
#define  CAN_WORD12_DATA_BYTE_6_4    BIT12
#define  CAN_WORD12_DATA_BYTE_6_5    BIT13
#define  CAN_WORD12_DATA_BYTE_6_6    BIT14
#define  CAN_WORD12_DATA_BYTE_6_7    BIT15

#define  CAN_WORD12_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD12_DATA_BYTE_5_0    BIT16
#define  CAN_WORD12_DATA_BYTE_5_1    BIT17
#define  CAN_WORD12_DATA_BYTE_5_2    BIT18
#define  CAN_WORD12_DATA_BYTE_5_3    BIT19
#define  CAN_WORD12_DATA_BYTE_5_4    BIT20
#define  CAN_WORD12_DATA_BYTE_5_5    BIT21
#define  CAN_WORD12_DATA_BYTE_5_6    BIT22
#define  CAN_WORD12_DATA_BYTE_5_7    BIT23

#define  CAN_WORD12_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD12_DATA_BYTE_4_0    BIT24
#define  CAN_WORD12_DATA_BYTE_4_1    BIT25
#define  CAN_WORD12_DATA_BYTE_4_2    BIT26
#define  CAN_WORD12_DATA_BYTE_4_3    BIT27
#define  CAN_WORD12_DATA_BYTE_4_4    BIT28
#define  CAN_WORD12_DATA_BYTE_4_5    BIT29
#define  CAN_WORD12_DATA_BYTE_4_6    BIT30
#define  CAN_WORD12_DATA_BYTE_4_7    BIT31

#define  CAN_CS3_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS3_TIME_STAMP_0        BIT0
#define  CAN_CS3_TIME_STAMP_1        BIT1
#define  CAN_CS3_TIME_STAMP_2        BIT2
#define  CAN_CS3_TIME_STAMP_3        BIT3
#define  CAN_CS3_TIME_STAMP_4        BIT4
#define  CAN_CS3_TIME_STAMP_5        BIT5
#define  CAN_CS3_TIME_STAMP_6        BIT6
#define  CAN_CS3_TIME_STAMP_7        BIT7
#define  CAN_CS3_TIME_STAMP_8        BIT8
#define  CAN_CS3_TIME_STAMP_9        BIT9
#define  CAN_CS3_TIME_STAMP_10       BIT10
#define  CAN_CS3_TIME_STAMP_11       BIT11
#define  CAN_CS3_TIME_STAMP_12       BIT12
#define  CAN_CS3_TIME_STAMP_13       BIT13
#define  CAN_CS3_TIME_STAMP_14       BIT14
#define  CAN_CS3_TIME_STAMP_15       BIT15

#define  CAN_CS3_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS3_DLC_0               BIT16
#define  CAN_CS3_DLC_1               BIT17
#define  CAN_CS3_DLC_2               BIT18
#define  CAN_CS3_DLC_3               BIT19

#define  CAN_CS3_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS3_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS3_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS3_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS3_CODE_0              BIT24
#define  CAN_CS3_CODE_1              BIT25
#define  CAN_CS3_CODE_2              BIT26
#define  CAN_CS3_CODE_3              BIT27

#define  CAN_ID3_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID3_EXT_0               BIT0
#define  CAN_ID3_EXT_1               BIT1
#define  CAN_ID3_EXT_2               BIT2
#define  CAN_ID3_EXT_3               BIT3
#define  CAN_ID3_EXT_4               BIT4
#define  CAN_ID3_EXT_5               BIT5
#define  CAN_ID3_EXT_6               BIT6
#define  CAN_ID3_EXT_7               BIT7
#define  CAN_ID3_EXT_8               BIT8
#define  CAN_ID3_EXT_9               BIT9
#define  CAN_ID3_EXT_10              BIT10
#define  CAN_ID3_EXT_11              BIT11
#define  CAN_ID3_EXT_12              BIT12
#define  CAN_ID3_EXT_13              BIT13
#define  CAN_ID3_EXT_14              BIT14
#define  CAN_ID3_EXT_15              BIT15
#define  CAN_ID3_EXT_16              BIT16
#define  CAN_ID3_EXT_17              BIT17

#define  CAN_ID3_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID3_STD_0               BIT18
#define  CAN_ID3_STD_1               BIT19
#define  CAN_ID3_STD_2               BIT20
#define  CAN_ID3_STD_3               BIT21
#define  CAN_ID3_STD_4               BIT22
#define  CAN_ID3_STD_5               BIT23
#define  CAN_ID3_STD_6               BIT24
#define  CAN_ID3_STD_7               BIT25
#define  CAN_ID3_STD_8               BIT26
#define  CAN_ID3_STD_9               BIT27
#define  CAN_ID3_STD_10              BIT28

#define  CAN_ID3_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID3_PRIO_0              BIT29
#define  CAN_ID3_PRIO_1              BIT30
#define  CAN_ID3_PRIO_2              BIT31

#define  CAN_WORD03_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD03_DATA_BYTE_3_0    BIT0
#define  CAN_WORD03_DATA_BYTE_3_1    BIT1
#define  CAN_WORD03_DATA_BYTE_3_2    BIT2
#define  CAN_WORD03_DATA_BYTE_3_3    BIT3
#define  CAN_WORD03_DATA_BYTE_3_4    BIT4
#define  CAN_WORD03_DATA_BYTE_3_5    BIT5
#define  CAN_WORD03_DATA_BYTE_3_6    BIT6
#define  CAN_WORD03_DATA_BYTE_3_7    BIT7

#define  CAN_WORD03_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD03_DATA_BYTE_2_0    BIT8
#define  CAN_WORD03_DATA_BYTE_2_1    BIT9
#define  CAN_WORD03_DATA_BYTE_2_2    BIT10
#define  CAN_WORD03_DATA_BYTE_2_3    BIT11
#define  CAN_WORD03_DATA_BYTE_2_4    BIT12
#define  CAN_WORD03_DATA_BYTE_2_5    BIT13
#define  CAN_WORD03_DATA_BYTE_2_6    BIT14
#define  CAN_WORD03_DATA_BYTE_2_7    BIT15

#define  CAN_WORD03_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD03_DATA_BYTE_1_0    BIT16
#define  CAN_WORD03_DATA_BYTE_1_1    BIT17
#define  CAN_WORD03_DATA_BYTE_1_2    BIT18
#define  CAN_WORD03_DATA_BYTE_1_3    BIT19
#define  CAN_WORD03_DATA_BYTE_1_4    BIT20
#define  CAN_WORD03_DATA_BYTE_1_5    BIT21
#define  CAN_WORD03_DATA_BYTE_1_6    BIT22
#define  CAN_WORD03_DATA_BYTE_1_7    BIT23

#define  CAN_WORD03_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD03_DATA_BYTE_0_0    BIT24
#define  CAN_WORD03_DATA_BYTE_0_1    BIT25
#define  CAN_WORD03_DATA_BYTE_0_2    BIT26
#define  CAN_WORD03_DATA_BYTE_0_3    BIT27
#define  CAN_WORD03_DATA_BYTE_0_4    BIT28
#define  CAN_WORD03_DATA_BYTE_0_5    BIT29
#define  CAN_WORD03_DATA_BYTE_0_6    BIT30
#define  CAN_WORD03_DATA_BYTE_0_7    BIT31

#define  CAN_WORD13_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD13_DATA_BYTE_7_0    BIT0
#define  CAN_WORD13_DATA_BYTE_7_1    BIT1
#define  CAN_WORD13_DATA_BYTE_7_2    BIT2
#define  CAN_WORD13_DATA_BYTE_7_3    BIT3
#define  CAN_WORD13_DATA_BYTE_7_4    BIT4
#define  CAN_WORD13_DATA_BYTE_7_5    BIT5
#define  CAN_WORD13_DATA_BYTE_7_6    BIT6
#define  CAN_WORD13_DATA_BYTE_7_7    BIT7

#define  CAN_WORD13_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD13_DATA_BYTE_6_0    BIT8
#define  CAN_WORD13_DATA_BYTE_6_1    BIT9
#define  CAN_WORD13_DATA_BYTE_6_2    BIT10
#define  CAN_WORD13_DATA_BYTE_6_3    BIT11
#define  CAN_WORD13_DATA_BYTE_6_4    BIT12
#define  CAN_WORD13_DATA_BYTE_6_5    BIT13
#define  CAN_WORD13_DATA_BYTE_6_6    BIT14
#define  CAN_WORD13_DATA_BYTE_6_7    BIT15

#define  CAN_WORD13_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD13_DATA_BYTE_5_0    BIT16
#define  CAN_WORD13_DATA_BYTE_5_1    BIT17
#define  CAN_WORD13_DATA_BYTE_5_2    BIT18
#define  CAN_WORD13_DATA_BYTE_5_3    BIT19
#define  CAN_WORD13_DATA_BYTE_5_4    BIT20
#define  CAN_WORD13_DATA_BYTE_5_5    BIT21
#define  CAN_WORD13_DATA_BYTE_5_6    BIT22
#define  CAN_WORD13_DATA_BYTE_5_7    BIT23

#define  CAN_WORD13_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD13_DATA_BYTE_4_0    BIT24
#define  CAN_WORD13_DATA_BYTE_4_1    BIT25
#define  CAN_WORD13_DATA_BYTE_4_2    BIT26
#define  CAN_WORD13_DATA_BYTE_4_3    BIT27
#define  CAN_WORD13_DATA_BYTE_4_4    BIT28
#define  CAN_WORD13_DATA_BYTE_4_5    BIT29
#define  CAN_WORD13_DATA_BYTE_4_6    BIT30
#define  CAN_WORD13_DATA_BYTE_4_7    BIT31

#define  CAN_CS4_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS4_TIME_STAMP_0        BIT0
#define  CAN_CS4_TIME_STAMP_1        BIT1
#define  CAN_CS4_TIME_STAMP_2        BIT2
#define  CAN_CS4_TIME_STAMP_3        BIT3
#define  CAN_CS4_TIME_STAMP_4        BIT4
#define  CAN_CS4_TIME_STAMP_5        BIT5
#define  CAN_CS4_TIME_STAMP_6        BIT6
#define  CAN_CS4_TIME_STAMP_7        BIT7
#define  CAN_CS4_TIME_STAMP_8        BIT8
#define  CAN_CS4_TIME_STAMP_9        BIT9
#define  CAN_CS4_TIME_STAMP_10       BIT10
#define  CAN_CS4_TIME_STAMP_11       BIT11
#define  CAN_CS4_TIME_STAMP_12       BIT12
#define  CAN_CS4_TIME_STAMP_13       BIT13
#define  CAN_CS4_TIME_STAMP_14       BIT14
#define  CAN_CS4_TIME_STAMP_15       BIT15

#define  CAN_CS4_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS4_DLC_0               BIT16
#define  CAN_CS4_DLC_1               BIT17
#define  CAN_CS4_DLC_2               BIT18
#define  CAN_CS4_DLC_3               BIT19

#define  CAN_CS4_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS4_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS4_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS4_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS4_CODE_0              BIT24
#define  CAN_CS4_CODE_1              BIT25
#define  CAN_CS4_CODE_2              BIT26
#define  CAN_CS4_CODE_3              BIT27

#define  CAN_ID4_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID4_EXT_0               BIT0
#define  CAN_ID4_EXT_1               BIT1
#define  CAN_ID4_EXT_2               BIT2
#define  CAN_ID4_EXT_3               BIT3
#define  CAN_ID4_EXT_4               BIT4
#define  CAN_ID4_EXT_5               BIT5
#define  CAN_ID4_EXT_6               BIT6
#define  CAN_ID4_EXT_7               BIT7
#define  CAN_ID4_EXT_8               BIT8
#define  CAN_ID4_EXT_9               BIT9
#define  CAN_ID4_EXT_10              BIT10
#define  CAN_ID4_EXT_11              BIT11
#define  CAN_ID4_EXT_12              BIT12
#define  CAN_ID4_EXT_13              BIT13
#define  CAN_ID4_EXT_14              BIT14
#define  CAN_ID4_EXT_15              BIT15
#define  CAN_ID4_EXT_16              BIT16
#define  CAN_ID4_EXT_17              BIT17

#define  CAN_ID4_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID4_STD_0               BIT18
#define  CAN_ID4_STD_1               BIT19
#define  CAN_ID4_STD_2               BIT20
#define  CAN_ID4_STD_3               BIT21
#define  CAN_ID4_STD_4               BIT22
#define  CAN_ID4_STD_5               BIT23
#define  CAN_ID4_STD_6               BIT24
#define  CAN_ID4_STD_7               BIT25
#define  CAN_ID4_STD_8               BIT26
#define  CAN_ID4_STD_9               BIT27
#define  CAN_ID4_STD_10              BIT28

#define  CAN_ID4_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID4_PRIO_0              BIT29
#define  CAN_ID4_PRIO_1              BIT30
#define  CAN_ID4_PRIO_2              BIT31

#define  CAN_WORD04_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD04_DATA_BYTE_3_0    BIT0
#define  CAN_WORD04_DATA_BYTE_3_1    BIT1
#define  CAN_WORD04_DATA_BYTE_3_2    BIT2
#define  CAN_WORD04_DATA_BYTE_3_3    BIT3
#define  CAN_WORD04_DATA_BYTE_3_4    BIT4
#define  CAN_WORD04_DATA_BYTE_3_5    BIT5
#define  CAN_WORD04_DATA_BYTE_3_6    BIT6
#define  CAN_WORD04_DATA_BYTE_3_7    BIT7

#define  CAN_WORD04_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD04_DATA_BYTE_2_0    BIT8
#define  CAN_WORD04_DATA_BYTE_2_1    BIT9
#define  CAN_WORD04_DATA_BYTE_2_2    BIT10
#define  CAN_WORD04_DATA_BYTE_2_3    BIT11
#define  CAN_WORD04_DATA_BYTE_2_4    BIT12
#define  CAN_WORD04_DATA_BYTE_2_5    BIT13
#define  CAN_WORD04_DATA_BYTE_2_6    BIT14
#define  CAN_WORD04_DATA_BYTE_2_7    BIT15

#define  CAN_WORD04_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD04_DATA_BYTE_1_0    BIT16
#define  CAN_WORD04_DATA_BYTE_1_1    BIT17
#define  CAN_WORD04_DATA_BYTE_1_2    BIT18
#define  CAN_WORD04_DATA_BYTE_1_3    BIT19
#define  CAN_WORD04_DATA_BYTE_1_4    BIT20
#define  CAN_WORD04_DATA_BYTE_1_5    BIT21
#define  CAN_WORD04_DATA_BYTE_1_6    BIT22
#define  CAN_WORD04_DATA_BYTE_1_7    BIT23

#define  CAN_WORD04_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD04_DATA_BYTE_0_0    BIT24
#define  CAN_WORD04_DATA_BYTE_0_1    BIT25
#define  CAN_WORD04_DATA_BYTE_0_2    BIT26
#define  CAN_WORD04_DATA_BYTE_0_3    BIT27
#define  CAN_WORD04_DATA_BYTE_0_4    BIT28
#define  CAN_WORD04_DATA_BYTE_0_5    BIT29
#define  CAN_WORD04_DATA_BYTE_0_6    BIT30
#define  CAN_WORD04_DATA_BYTE_0_7    BIT31

#define  CAN_WORD14_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD14_DATA_BYTE_7_0    BIT0
#define  CAN_WORD14_DATA_BYTE_7_1    BIT1
#define  CAN_WORD14_DATA_BYTE_7_2    BIT2
#define  CAN_WORD14_DATA_BYTE_7_3    BIT3
#define  CAN_WORD14_DATA_BYTE_7_4    BIT4
#define  CAN_WORD14_DATA_BYTE_7_5    BIT5
#define  CAN_WORD14_DATA_BYTE_7_6    BIT6
#define  CAN_WORD14_DATA_BYTE_7_7    BIT7

#define  CAN_WORD14_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD14_DATA_BYTE_6_0    BIT8
#define  CAN_WORD14_DATA_BYTE_6_1    BIT9
#define  CAN_WORD14_DATA_BYTE_6_2    BIT10
#define  CAN_WORD14_DATA_BYTE_6_3    BIT11
#define  CAN_WORD14_DATA_BYTE_6_4    BIT12
#define  CAN_WORD14_DATA_BYTE_6_5    BIT13
#define  CAN_WORD14_DATA_BYTE_6_6    BIT14
#define  CAN_WORD14_DATA_BYTE_6_7    BIT15

#define  CAN_WORD14_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD14_DATA_BYTE_5_0    BIT16
#define  CAN_WORD14_DATA_BYTE_5_1    BIT17
#define  CAN_WORD14_DATA_BYTE_5_2    BIT18
#define  CAN_WORD14_DATA_BYTE_5_3    BIT19
#define  CAN_WORD14_DATA_BYTE_5_4    BIT20
#define  CAN_WORD14_DATA_BYTE_5_5    BIT21
#define  CAN_WORD14_DATA_BYTE_5_6    BIT22
#define  CAN_WORD14_DATA_BYTE_5_7    BIT23

#define  CAN_WORD14_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD14_DATA_BYTE_4_0    BIT24
#define  CAN_WORD14_DATA_BYTE_4_1    BIT25
#define  CAN_WORD14_DATA_BYTE_4_2    BIT26
#define  CAN_WORD14_DATA_BYTE_4_3    BIT27
#define  CAN_WORD14_DATA_BYTE_4_4    BIT28
#define  CAN_WORD14_DATA_BYTE_4_5    BIT29
#define  CAN_WORD14_DATA_BYTE_4_6    BIT30
#define  CAN_WORD14_DATA_BYTE_4_7    BIT31

#define  CAN_CS5_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS5_TIME_STAMP_0        BIT0
#define  CAN_CS5_TIME_STAMP_1        BIT1
#define  CAN_CS5_TIME_STAMP_2        BIT2
#define  CAN_CS5_TIME_STAMP_3        BIT3
#define  CAN_CS5_TIME_STAMP_4        BIT4
#define  CAN_CS5_TIME_STAMP_5        BIT5
#define  CAN_CS5_TIME_STAMP_6        BIT6
#define  CAN_CS5_TIME_STAMP_7        BIT7
#define  CAN_CS5_TIME_STAMP_8        BIT8
#define  CAN_CS5_TIME_STAMP_9        BIT9
#define  CAN_CS5_TIME_STAMP_10       BIT10
#define  CAN_CS5_TIME_STAMP_11       BIT11
#define  CAN_CS5_TIME_STAMP_12       BIT12
#define  CAN_CS5_TIME_STAMP_13       BIT13
#define  CAN_CS5_TIME_STAMP_14       BIT14
#define  CAN_CS5_TIME_STAMP_15       BIT15

#define  CAN_CS5_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS5_DLC_0               BIT16
#define  CAN_CS5_DLC_1               BIT17
#define  CAN_CS5_DLC_2               BIT18
#define  CAN_CS5_DLC_3               BIT19

#define  CAN_CS5_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS5_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS5_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS5_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS5_CODE_0              BIT24
#define  CAN_CS5_CODE_1              BIT25
#define  CAN_CS5_CODE_2              BIT26
#define  CAN_CS5_CODE_3              BIT27

#define  CAN_ID5_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID5_EXT_0               BIT0
#define  CAN_ID5_EXT_1               BIT1
#define  CAN_ID5_EXT_2               BIT2
#define  CAN_ID5_EXT_3               BIT3
#define  CAN_ID5_EXT_4               BIT4
#define  CAN_ID5_EXT_5               BIT5
#define  CAN_ID5_EXT_6               BIT6
#define  CAN_ID5_EXT_7               BIT7
#define  CAN_ID5_EXT_8               BIT8
#define  CAN_ID5_EXT_9               BIT9
#define  CAN_ID5_EXT_10              BIT10
#define  CAN_ID5_EXT_11              BIT11
#define  CAN_ID5_EXT_12              BIT12
#define  CAN_ID5_EXT_13              BIT13
#define  CAN_ID5_EXT_14              BIT14
#define  CAN_ID5_EXT_15              BIT15
#define  CAN_ID5_EXT_16              BIT16
#define  CAN_ID5_EXT_17              BIT17

#define  CAN_ID5_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID5_STD_0               BIT18
#define  CAN_ID5_STD_1               BIT19
#define  CAN_ID5_STD_2               BIT20
#define  CAN_ID5_STD_3               BIT21
#define  CAN_ID5_STD_4               BIT22
#define  CAN_ID5_STD_5               BIT23
#define  CAN_ID5_STD_6               BIT24
#define  CAN_ID5_STD_7               BIT25
#define  CAN_ID5_STD_8               BIT26
#define  CAN_ID5_STD_9               BIT27
#define  CAN_ID5_STD_10              BIT28

#define  CAN_ID5_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID5_PRIO_0              BIT29
#define  CAN_ID5_PRIO_1              BIT30
#define  CAN_ID5_PRIO_2              BIT31

#define  CAN_WORD05_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD05_DATA_BYTE_3_0    BIT0
#define  CAN_WORD05_DATA_BYTE_3_1    BIT1
#define  CAN_WORD05_DATA_BYTE_3_2    BIT2
#define  CAN_WORD05_DATA_BYTE_3_3    BIT3
#define  CAN_WORD05_DATA_BYTE_3_4    BIT4
#define  CAN_WORD05_DATA_BYTE_3_5    BIT5
#define  CAN_WORD05_DATA_BYTE_3_6    BIT6
#define  CAN_WORD05_DATA_BYTE_3_7    BIT7

#define  CAN_WORD05_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD05_DATA_BYTE_2_0    BIT8
#define  CAN_WORD05_DATA_BYTE_2_1    BIT9
#define  CAN_WORD05_DATA_BYTE_2_2    BIT10
#define  CAN_WORD05_DATA_BYTE_2_3    BIT11
#define  CAN_WORD05_DATA_BYTE_2_4    BIT12
#define  CAN_WORD05_DATA_BYTE_2_5    BIT13
#define  CAN_WORD05_DATA_BYTE_2_6    BIT14
#define  CAN_WORD05_DATA_BYTE_2_7    BIT15

#define  CAN_WORD05_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD05_DATA_BYTE_1_0    BIT16
#define  CAN_WORD05_DATA_BYTE_1_1    BIT17
#define  CAN_WORD05_DATA_BYTE_1_2    BIT18
#define  CAN_WORD05_DATA_BYTE_1_3    BIT19
#define  CAN_WORD05_DATA_BYTE_1_4    BIT20
#define  CAN_WORD05_DATA_BYTE_1_5    BIT21
#define  CAN_WORD05_DATA_BYTE_1_6    BIT22
#define  CAN_WORD05_DATA_BYTE_1_7    BIT23

#define  CAN_WORD05_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD05_DATA_BYTE_0_0    BIT24
#define  CAN_WORD05_DATA_BYTE_0_1    BIT25
#define  CAN_WORD05_DATA_BYTE_0_2    BIT26
#define  CAN_WORD05_DATA_BYTE_0_3    BIT27
#define  CAN_WORD05_DATA_BYTE_0_4    BIT28
#define  CAN_WORD05_DATA_BYTE_0_5    BIT29
#define  CAN_WORD05_DATA_BYTE_0_6    BIT30
#define  CAN_WORD05_DATA_BYTE_0_7    BIT31

#define  CAN_WORD15_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD15_DATA_BYTE_7_0    BIT0
#define  CAN_WORD15_DATA_BYTE_7_1    BIT1
#define  CAN_WORD15_DATA_BYTE_7_2    BIT2
#define  CAN_WORD15_DATA_BYTE_7_3    BIT3
#define  CAN_WORD15_DATA_BYTE_7_4    BIT4
#define  CAN_WORD15_DATA_BYTE_7_5    BIT5
#define  CAN_WORD15_DATA_BYTE_7_6    BIT6
#define  CAN_WORD15_DATA_BYTE_7_7    BIT7

#define  CAN_WORD15_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD15_DATA_BYTE_6_0    BIT8
#define  CAN_WORD15_DATA_BYTE_6_1    BIT9
#define  CAN_WORD15_DATA_BYTE_6_2    BIT10
#define  CAN_WORD15_DATA_BYTE_6_3    BIT11
#define  CAN_WORD15_DATA_BYTE_6_4    BIT12
#define  CAN_WORD15_DATA_BYTE_6_5    BIT13
#define  CAN_WORD15_DATA_BYTE_6_6    BIT14
#define  CAN_WORD15_DATA_BYTE_6_7    BIT15

#define  CAN_WORD15_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD15_DATA_BYTE_5_0    BIT16
#define  CAN_WORD15_DATA_BYTE_5_1    BIT17
#define  CAN_WORD15_DATA_BYTE_5_2    BIT18
#define  CAN_WORD15_DATA_BYTE_5_3    BIT19
#define  CAN_WORD15_DATA_BYTE_5_4    BIT20
#define  CAN_WORD15_DATA_BYTE_5_5    BIT21
#define  CAN_WORD15_DATA_BYTE_5_6    BIT22
#define  CAN_WORD15_DATA_BYTE_5_7    BIT23

#define  CAN_WORD15_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD15_DATA_BYTE_4_0    BIT24
#define  CAN_WORD15_DATA_BYTE_4_1    BIT25
#define  CAN_WORD15_DATA_BYTE_4_2    BIT26
#define  CAN_WORD15_DATA_BYTE_4_3    BIT27
#define  CAN_WORD15_DATA_BYTE_4_4    BIT28
#define  CAN_WORD15_DATA_BYTE_4_5    BIT29
#define  CAN_WORD15_DATA_BYTE_4_6    BIT30
#define  CAN_WORD15_DATA_BYTE_4_7    BIT31

#define  CAN_CS6_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS6_TIME_STAMP_0        BIT0
#define  CAN_CS6_TIME_STAMP_1        BIT1
#define  CAN_CS6_TIME_STAMP_2        BIT2
#define  CAN_CS6_TIME_STAMP_3        BIT3
#define  CAN_CS6_TIME_STAMP_4        BIT4
#define  CAN_CS6_TIME_STAMP_5        BIT5
#define  CAN_CS6_TIME_STAMP_6        BIT6
#define  CAN_CS6_TIME_STAMP_7        BIT7
#define  CAN_CS6_TIME_STAMP_8        BIT8
#define  CAN_CS6_TIME_STAMP_9        BIT9
#define  CAN_CS6_TIME_STAMP_10       BIT10
#define  CAN_CS6_TIME_STAMP_11       BIT11
#define  CAN_CS6_TIME_STAMP_12       BIT12
#define  CAN_CS6_TIME_STAMP_13       BIT13
#define  CAN_CS6_TIME_STAMP_14       BIT14
#define  CAN_CS6_TIME_STAMP_15       BIT15

#define  CAN_CS6_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS6_DLC_0               BIT16
#define  CAN_CS6_DLC_1               BIT17
#define  CAN_CS6_DLC_2               BIT18
#define  CAN_CS6_DLC_3               BIT19

#define  CAN_CS6_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS6_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS6_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS6_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS6_CODE_0              BIT24
#define  CAN_CS6_CODE_1              BIT25
#define  CAN_CS6_CODE_2              BIT26
#define  CAN_CS6_CODE_3              BIT27

#define  CAN_ID6_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID6_EXT_0               BIT0
#define  CAN_ID6_EXT_1               BIT1
#define  CAN_ID6_EXT_2               BIT2
#define  CAN_ID6_EXT_3               BIT3
#define  CAN_ID6_EXT_4               BIT4
#define  CAN_ID6_EXT_5               BIT5
#define  CAN_ID6_EXT_6               BIT6
#define  CAN_ID6_EXT_7               BIT7
#define  CAN_ID6_EXT_8               BIT8
#define  CAN_ID6_EXT_9               BIT9
#define  CAN_ID6_EXT_10              BIT10
#define  CAN_ID6_EXT_11              BIT11
#define  CAN_ID6_EXT_12              BIT12
#define  CAN_ID6_EXT_13              BIT13
#define  CAN_ID6_EXT_14              BIT14
#define  CAN_ID6_EXT_15              BIT15
#define  CAN_ID6_EXT_16              BIT16
#define  CAN_ID6_EXT_17              BIT17

#define  CAN_ID6_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID6_STD_0               BIT18
#define  CAN_ID6_STD_1               BIT19
#define  CAN_ID6_STD_2               BIT20
#define  CAN_ID6_STD_3               BIT21
#define  CAN_ID6_STD_4               BIT22
#define  CAN_ID6_STD_5               BIT23
#define  CAN_ID6_STD_6               BIT24
#define  CAN_ID6_STD_7               BIT25
#define  CAN_ID6_STD_8               BIT26
#define  CAN_ID6_STD_9               BIT27
#define  CAN_ID6_STD_10              BIT28

#define  CAN_ID6_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID6_PRIO_0              BIT29
#define  CAN_ID6_PRIO_1              BIT30
#define  CAN_ID6_PRIO_2              BIT31

#define  CAN_WORD06_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD06_DATA_BYTE_3_0    BIT0
#define  CAN_WORD06_DATA_BYTE_3_1    BIT1
#define  CAN_WORD06_DATA_BYTE_3_2    BIT2
#define  CAN_WORD06_DATA_BYTE_3_3    BIT3
#define  CAN_WORD06_DATA_BYTE_3_4    BIT4
#define  CAN_WORD06_DATA_BYTE_3_5    BIT5
#define  CAN_WORD06_DATA_BYTE_3_6    BIT6
#define  CAN_WORD06_DATA_BYTE_3_7    BIT7

#define  CAN_WORD06_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD06_DATA_BYTE_2_0    BIT8
#define  CAN_WORD06_DATA_BYTE_2_1    BIT9
#define  CAN_WORD06_DATA_BYTE_2_2    BIT10
#define  CAN_WORD06_DATA_BYTE_2_3    BIT11
#define  CAN_WORD06_DATA_BYTE_2_4    BIT12
#define  CAN_WORD06_DATA_BYTE_2_5    BIT13
#define  CAN_WORD06_DATA_BYTE_2_6    BIT14
#define  CAN_WORD06_DATA_BYTE_2_7    BIT15

#define  CAN_WORD06_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD06_DATA_BYTE_1_0    BIT16
#define  CAN_WORD06_DATA_BYTE_1_1    BIT17
#define  CAN_WORD06_DATA_BYTE_1_2    BIT18
#define  CAN_WORD06_DATA_BYTE_1_3    BIT19
#define  CAN_WORD06_DATA_BYTE_1_4    BIT20
#define  CAN_WORD06_DATA_BYTE_1_5    BIT21
#define  CAN_WORD06_DATA_BYTE_1_6    BIT22
#define  CAN_WORD06_DATA_BYTE_1_7    BIT23

#define  CAN_WORD06_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD06_DATA_BYTE_0_0    BIT24
#define  CAN_WORD06_DATA_BYTE_0_1    BIT25
#define  CAN_WORD06_DATA_BYTE_0_2    BIT26
#define  CAN_WORD06_DATA_BYTE_0_3    BIT27
#define  CAN_WORD06_DATA_BYTE_0_4    BIT28
#define  CAN_WORD06_DATA_BYTE_0_5    BIT29
#define  CAN_WORD06_DATA_BYTE_0_6    BIT30
#define  CAN_WORD06_DATA_BYTE_0_7    BIT31

#define  CAN_WORD16_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD16_DATA_BYTE_7_0    BIT0
#define  CAN_WORD16_DATA_BYTE_7_1    BIT1
#define  CAN_WORD16_DATA_BYTE_7_2    BIT2
#define  CAN_WORD16_DATA_BYTE_7_3    BIT3
#define  CAN_WORD16_DATA_BYTE_7_4    BIT4
#define  CAN_WORD16_DATA_BYTE_7_5    BIT5
#define  CAN_WORD16_DATA_BYTE_7_6    BIT6
#define  CAN_WORD16_DATA_BYTE_7_7    BIT7

#define  CAN_WORD16_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD16_DATA_BYTE_6_0    BIT8
#define  CAN_WORD16_DATA_BYTE_6_1    BIT9
#define  CAN_WORD16_DATA_BYTE_6_2    BIT10
#define  CAN_WORD16_DATA_BYTE_6_3    BIT11
#define  CAN_WORD16_DATA_BYTE_6_4    BIT12
#define  CAN_WORD16_DATA_BYTE_6_5    BIT13
#define  CAN_WORD16_DATA_BYTE_6_6    BIT14
#define  CAN_WORD16_DATA_BYTE_6_7    BIT15

#define  CAN_WORD16_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD16_DATA_BYTE_5_0    BIT16
#define  CAN_WORD16_DATA_BYTE_5_1    BIT17
#define  CAN_WORD16_DATA_BYTE_5_2    BIT18
#define  CAN_WORD16_DATA_BYTE_5_3    BIT19
#define  CAN_WORD16_DATA_BYTE_5_4    BIT20
#define  CAN_WORD16_DATA_BYTE_5_5    BIT21
#define  CAN_WORD16_DATA_BYTE_5_6    BIT22
#define  CAN_WORD16_DATA_BYTE_5_7    BIT23

#define  CAN_WORD16_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD16_DATA_BYTE_4_0    BIT24
#define  CAN_WORD16_DATA_BYTE_4_1    BIT25
#define  CAN_WORD16_DATA_BYTE_4_2    BIT26
#define  CAN_WORD16_DATA_BYTE_4_3    BIT27
#define  CAN_WORD16_DATA_BYTE_4_4    BIT28
#define  CAN_WORD16_DATA_BYTE_4_5    BIT29
#define  CAN_WORD16_DATA_BYTE_4_6    BIT30
#define  CAN_WORD16_DATA_BYTE_4_7    BIT31

#define  CAN_CS7_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS7_TIME_STAMP_0        BIT0
#define  CAN_CS7_TIME_STAMP_1        BIT1
#define  CAN_CS7_TIME_STAMP_2        BIT2
#define  CAN_CS7_TIME_STAMP_3        BIT3
#define  CAN_CS7_TIME_STAMP_4        BIT4
#define  CAN_CS7_TIME_STAMP_5        BIT5
#define  CAN_CS7_TIME_STAMP_6        BIT6
#define  CAN_CS7_TIME_STAMP_7        BIT7
#define  CAN_CS7_TIME_STAMP_8        BIT8
#define  CAN_CS7_TIME_STAMP_9        BIT9
#define  CAN_CS7_TIME_STAMP_10       BIT10
#define  CAN_CS7_TIME_STAMP_11       BIT11
#define  CAN_CS7_TIME_STAMP_12       BIT12
#define  CAN_CS7_TIME_STAMP_13       BIT13
#define  CAN_CS7_TIME_STAMP_14       BIT14
#define  CAN_CS7_TIME_STAMP_15       BIT15

#define  CAN_CS7_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS7_DLC_0               BIT16
#define  CAN_CS7_DLC_1               BIT17
#define  CAN_CS7_DLC_2               BIT18
#define  CAN_CS7_DLC_3               BIT19

#define  CAN_CS7_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS7_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS7_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS7_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS7_CODE_0              BIT24
#define  CAN_CS7_CODE_1              BIT25
#define  CAN_CS7_CODE_2              BIT26
#define  CAN_CS7_CODE_3              BIT27

#define  CAN_ID7_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID7_EXT_0               BIT0
#define  CAN_ID7_EXT_1               BIT1
#define  CAN_ID7_EXT_2               BIT2
#define  CAN_ID7_EXT_3               BIT3
#define  CAN_ID7_EXT_4               BIT4
#define  CAN_ID7_EXT_5               BIT5
#define  CAN_ID7_EXT_6               BIT6
#define  CAN_ID7_EXT_7               BIT7
#define  CAN_ID7_EXT_8               BIT8
#define  CAN_ID7_EXT_9               BIT9
#define  CAN_ID7_EXT_10              BIT10
#define  CAN_ID7_EXT_11              BIT11
#define  CAN_ID7_EXT_12              BIT12
#define  CAN_ID7_EXT_13              BIT13
#define  CAN_ID7_EXT_14              BIT14
#define  CAN_ID7_EXT_15              BIT15
#define  CAN_ID7_EXT_16              BIT16
#define  CAN_ID7_EXT_17              BIT17

#define  CAN_ID7_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID7_STD_0               BIT18
#define  CAN_ID7_STD_1               BIT19
#define  CAN_ID7_STD_2               BIT20
#define  CAN_ID7_STD_3               BIT21
#define  CAN_ID7_STD_4               BIT22
#define  CAN_ID7_STD_5               BIT23
#define  CAN_ID7_STD_6               BIT24
#define  CAN_ID7_STD_7               BIT25
#define  CAN_ID7_STD_8               BIT26
#define  CAN_ID7_STD_9               BIT27
#define  CAN_ID7_STD_10              BIT28

#define  CAN_ID7_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID7_PRIO_0              BIT29
#define  CAN_ID7_PRIO_1              BIT30
#define  CAN_ID7_PRIO_2              BIT31

#define  CAN_WORD07_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD07_DATA_BYTE_3_0    BIT0
#define  CAN_WORD07_DATA_BYTE_3_1    BIT1
#define  CAN_WORD07_DATA_BYTE_3_2    BIT2
#define  CAN_WORD07_DATA_BYTE_3_3    BIT3
#define  CAN_WORD07_DATA_BYTE_3_4    BIT4
#define  CAN_WORD07_DATA_BYTE_3_5    BIT5
#define  CAN_WORD07_DATA_BYTE_3_6    BIT6
#define  CAN_WORD07_DATA_BYTE_3_7    BIT7

#define  CAN_WORD07_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD07_DATA_BYTE_2_0    BIT8
#define  CAN_WORD07_DATA_BYTE_2_1    BIT9
#define  CAN_WORD07_DATA_BYTE_2_2    BIT10
#define  CAN_WORD07_DATA_BYTE_2_3    BIT11
#define  CAN_WORD07_DATA_BYTE_2_4    BIT12
#define  CAN_WORD07_DATA_BYTE_2_5    BIT13
#define  CAN_WORD07_DATA_BYTE_2_6    BIT14
#define  CAN_WORD07_DATA_BYTE_2_7    BIT15

#define  CAN_WORD07_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD07_DATA_BYTE_1_0    BIT16
#define  CAN_WORD07_DATA_BYTE_1_1    BIT17
#define  CAN_WORD07_DATA_BYTE_1_2    BIT18
#define  CAN_WORD07_DATA_BYTE_1_3    BIT19
#define  CAN_WORD07_DATA_BYTE_1_4    BIT20
#define  CAN_WORD07_DATA_BYTE_1_5    BIT21
#define  CAN_WORD07_DATA_BYTE_1_6    BIT22
#define  CAN_WORD07_DATA_BYTE_1_7    BIT23

#define  CAN_WORD07_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD07_DATA_BYTE_0_0    BIT24
#define  CAN_WORD07_DATA_BYTE_0_1    BIT25
#define  CAN_WORD07_DATA_BYTE_0_2    BIT26
#define  CAN_WORD07_DATA_BYTE_0_3    BIT27
#define  CAN_WORD07_DATA_BYTE_0_4    BIT28
#define  CAN_WORD07_DATA_BYTE_0_5    BIT29
#define  CAN_WORD07_DATA_BYTE_0_6    BIT30
#define  CAN_WORD07_DATA_BYTE_0_7    BIT31

#define  CAN_WORD17_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD17_DATA_BYTE_7_0    BIT0
#define  CAN_WORD17_DATA_BYTE_7_1    BIT1
#define  CAN_WORD17_DATA_BYTE_7_2    BIT2
#define  CAN_WORD17_DATA_BYTE_7_3    BIT3
#define  CAN_WORD17_DATA_BYTE_7_4    BIT4
#define  CAN_WORD17_DATA_BYTE_7_5    BIT5
#define  CAN_WORD17_DATA_BYTE_7_6    BIT6
#define  CAN_WORD17_DATA_BYTE_7_7    BIT7

#define  CAN_WORD17_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD17_DATA_BYTE_6_0    BIT8
#define  CAN_WORD17_DATA_BYTE_6_1    BIT9
#define  CAN_WORD17_DATA_BYTE_6_2    BIT10
#define  CAN_WORD17_DATA_BYTE_6_3    BIT11
#define  CAN_WORD17_DATA_BYTE_6_4    BIT12
#define  CAN_WORD17_DATA_BYTE_6_5    BIT13
#define  CAN_WORD17_DATA_BYTE_6_6    BIT14
#define  CAN_WORD17_DATA_BYTE_6_7    BIT15

#define  CAN_WORD17_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD17_DATA_BYTE_5_0    BIT16
#define  CAN_WORD17_DATA_BYTE_5_1    BIT17
#define  CAN_WORD17_DATA_BYTE_5_2    BIT18
#define  CAN_WORD17_DATA_BYTE_5_3    BIT19
#define  CAN_WORD17_DATA_BYTE_5_4    BIT20
#define  CAN_WORD17_DATA_BYTE_5_5    BIT21
#define  CAN_WORD17_DATA_BYTE_5_6    BIT22
#define  CAN_WORD17_DATA_BYTE_5_7    BIT23

#define  CAN_WORD17_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD17_DATA_BYTE_4_0    BIT24
#define  CAN_WORD17_DATA_BYTE_4_1    BIT25
#define  CAN_WORD17_DATA_BYTE_4_2    BIT26
#define  CAN_WORD17_DATA_BYTE_4_3    BIT27
#define  CAN_WORD17_DATA_BYTE_4_4    BIT28
#define  CAN_WORD17_DATA_BYTE_4_5    BIT29
#define  CAN_WORD17_DATA_BYTE_4_6    BIT30
#define  CAN_WORD17_DATA_BYTE_4_7    BIT31

#define  CAN_CS8_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS8_TIME_STAMP_0        BIT0
#define  CAN_CS8_TIME_STAMP_1        BIT1
#define  CAN_CS8_TIME_STAMP_2        BIT2
#define  CAN_CS8_TIME_STAMP_3        BIT3
#define  CAN_CS8_TIME_STAMP_4        BIT4
#define  CAN_CS8_TIME_STAMP_5        BIT5
#define  CAN_CS8_TIME_STAMP_6        BIT6
#define  CAN_CS8_TIME_STAMP_7        BIT7
#define  CAN_CS8_TIME_STAMP_8        BIT8
#define  CAN_CS8_TIME_STAMP_9        BIT9
#define  CAN_CS8_TIME_STAMP_10       BIT10
#define  CAN_CS8_TIME_STAMP_11       BIT11
#define  CAN_CS8_TIME_STAMP_12       BIT12
#define  CAN_CS8_TIME_STAMP_13       BIT13
#define  CAN_CS8_TIME_STAMP_14       BIT14
#define  CAN_CS8_TIME_STAMP_15       BIT15

#define  CAN_CS8_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS8_DLC_0               BIT16
#define  CAN_CS8_DLC_1               BIT17
#define  CAN_CS8_DLC_2               BIT18
#define  CAN_CS8_DLC_3               BIT19

#define  CAN_CS8_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS8_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS8_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS8_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS8_CODE_0              BIT24
#define  CAN_CS8_CODE_1              BIT25
#define  CAN_CS8_CODE_2              BIT26
#define  CAN_CS8_CODE_3              BIT27

#define  CAN_ID8_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID8_EXT_0               BIT0
#define  CAN_ID8_EXT_1               BIT1
#define  CAN_ID8_EXT_2               BIT2
#define  CAN_ID8_EXT_3               BIT3
#define  CAN_ID8_EXT_4               BIT4
#define  CAN_ID8_EXT_5               BIT5
#define  CAN_ID8_EXT_6               BIT6
#define  CAN_ID8_EXT_7               BIT7
#define  CAN_ID8_EXT_8               BIT8
#define  CAN_ID8_EXT_9               BIT9
#define  CAN_ID8_EXT_10              BIT10
#define  CAN_ID8_EXT_11              BIT11
#define  CAN_ID8_EXT_12              BIT12
#define  CAN_ID8_EXT_13              BIT13
#define  CAN_ID8_EXT_14              BIT14
#define  CAN_ID8_EXT_15              BIT15
#define  CAN_ID8_EXT_16              BIT16
#define  CAN_ID8_EXT_17              BIT17

#define  CAN_ID8_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID8_STD_0               BIT18
#define  CAN_ID8_STD_1               BIT19
#define  CAN_ID8_STD_2               BIT20
#define  CAN_ID8_STD_3               BIT21
#define  CAN_ID8_STD_4               BIT22
#define  CAN_ID8_STD_5               BIT23
#define  CAN_ID8_STD_6               BIT24
#define  CAN_ID8_STD_7               BIT25
#define  CAN_ID8_STD_8               BIT26
#define  CAN_ID8_STD_9               BIT27
#define  CAN_ID8_STD_10              BIT28

#define  CAN_ID8_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID8_PRIO_0              BIT29
#define  CAN_ID8_PRIO_1              BIT30
#define  CAN_ID8_PRIO_2              BIT31

#define  CAN_WORD08_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD08_DATA_BYTE_3_0    BIT0
#define  CAN_WORD08_DATA_BYTE_3_1    BIT1
#define  CAN_WORD08_DATA_BYTE_3_2    BIT2
#define  CAN_WORD08_DATA_BYTE_3_3    BIT3
#define  CAN_WORD08_DATA_BYTE_3_4    BIT4
#define  CAN_WORD08_DATA_BYTE_3_5    BIT5
#define  CAN_WORD08_DATA_BYTE_3_6    BIT6
#define  CAN_WORD08_DATA_BYTE_3_7    BIT7

#define  CAN_WORD08_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD08_DATA_BYTE_2_0    BIT8
#define  CAN_WORD08_DATA_BYTE_2_1    BIT9
#define  CAN_WORD08_DATA_BYTE_2_2    BIT10
#define  CAN_WORD08_DATA_BYTE_2_3    BIT11
#define  CAN_WORD08_DATA_BYTE_2_4    BIT12
#define  CAN_WORD08_DATA_BYTE_2_5    BIT13
#define  CAN_WORD08_DATA_BYTE_2_6    BIT14
#define  CAN_WORD08_DATA_BYTE_2_7    BIT15

#define  CAN_WORD08_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD08_DATA_BYTE_1_0    BIT16
#define  CAN_WORD08_DATA_BYTE_1_1    BIT17
#define  CAN_WORD08_DATA_BYTE_1_2    BIT18
#define  CAN_WORD08_DATA_BYTE_1_3    BIT19
#define  CAN_WORD08_DATA_BYTE_1_4    BIT20
#define  CAN_WORD08_DATA_BYTE_1_5    BIT21
#define  CAN_WORD08_DATA_BYTE_1_6    BIT22
#define  CAN_WORD08_DATA_BYTE_1_7    BIT23

#define  CAN_WORD08_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD08_DATA_BYTE_0_0    BIT24
#define  CAN_WORD08_DATA_BYTE_0_1    BIT25
#define  CAN_WORD08_DATA_BYTE_0_2    BIT26
#define  CAN_WORD08_DATA_BYTE_0_3    BIT27
#define  CAN_WORD08_DATA_BYTE_0_4    BIT28
#define  CAN_WORD08_DATA_BYTE_0_5    BIT29
#define  CAN_WORD08_DATA_BYTE_0_6    BIT30
#define  CAN_WORD08_DATA_BYTE_0_7    BIT31

#define  CAN_WORD18_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD18_DATA_BYTE_7_0    BIT0
#define  CAN_WORD18_DATA_BYTE_7_1    BIT1
#define  CAN_WORD18_DATA_BYTE_7_2    BIT2
#define  CAN_WORD18_DATA_BYTE_7_3    BIT3
#define  CAN_WORD18_DATA_BYTE_7_4    BIT4
#define  CAN_WORD18_DATA_BYTE_7_5    BIT5
#define  CAN_WORD18_DATA_BYTE_7_6    BIT6
#define  CAN_WORD18_DATA_BYTE_7_7    BIT7

#define  CAN_WORD18_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD18_DATA_BYTE_6_0    BIT8
#define  CAN_WORD18_DATA_BYTE_6_1    BIT9
#define  CAN_WORD18_DATA_BYTE_6_2    BIT10
#define  CAN_WORD18_DATA_BYTE_6_3    BIT11
#define  CAN_WORD18_DATA_BYTE_6_4    BIT12
#define  CAN_WORD18_DATA_BYTE_6_5    BIT13
#define  CAN_WORD18_DATA_BYTE_6_6    BIT14
#define  CAN_WORD18_DATA_BYTE_6_7    BIT15

#define  CAN_WORD18_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD18_DATA_BYTE_5_0    BIT16
#define  CAN_WORD18_DATA_BYTE_5_1    BIT17
#define  CAN_WORD18_DATA_BYTE_5_2    BIT18
#define  CAN_WORD18_DATA_BYTE_5_3    BIT19
#define  CAN_WORD18_DATA_BYTE_5_4    BIT20
#define  CAN_WORD18_DATA_BYTE_5_5    BIT21
#define  CAN_WORD18_DATA_BYTE_5_6    BIT22
#define  CAN_WORD18_DATA_BYTE_5_7    BIT23

#define  CAN_WORD18_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD18_DATA_BYTE_4_0    BIT24
#define  CAN_WORD18_DATA_BYTE_4_1    BIT25
#define  CAN_WORD18_DATA_BYTE_4_2    BIT26
#define  CAN_WORD18_DATA_BYTE_4_3    BIT27
#define  CAN_WORD18_DATA_BYTE_4_4    BIT28
#define  CAN_WORD18_DATA_BYTE_4_5    BIT29
#define  CAN_WORD18_DATA_BYTE_4_6    BIT30
#define  CAN_WORD18_DATA_BYTE_4_7    BIT31

#define  CAN_CS9_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS9_TIME_STAMP_0        BIT0
#define  CAN_CS9_TIME_STAMP_1        BIT1
#define  CAN_CS9_TIME_STAMP_2        BIT2
#define  CAN_CS9_TIME_STAMP_3        BIT3
#define  CAN_CS9_TIME_STAMP_4        BIT4
#define  CAN_CS9_TIME_STAMP_5        BIT5
#define  CAN_CS9_TIME_STAMP_6        BIT6
#define  CAN_CS9_TIME_STAMP_7        BIT7
#define  CAN_CS9_TIME_STAMP_8        BIT8
#define  CAN_CS9_TIME_STAMP_9        BIT9
#define  CAN_CS9_TIME_STAMP_10       BIT10
#define  CAN_CS9_TIME_STAMP_11       BIT11
#define  CAN_CS9_TIME_STAMP_12       BIT12
#define  CAN_CS9_TIME_STAMP_13       BIT13
#define  CAN_CS9_TIME_STAMP_14       BIT14
#define  CAN_CS9_TIME_STAMP_15       BIT15

#define  CAN_CS9_DLC                 (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS9_DLC_0               BIT16
#define  CAN_CS9_DLC_1               BIT17
#define  CAN_CS9_DLC_2               BIT18
#define  CAN_CS9_DLC_3               BIT19

#define  CAN_CS9_RTR                 BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS9_IDE                 BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS9_SRR                 BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS9_CODE                (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS9_CODE_0              BIT24
#define  CAN_CS9_CODE_1              BIT25
#define  CAN_CS9_CODE_2              BIT26
#define  CAN_CS9_CODE_3              BIT27

#define  CAN_ID9_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID9_EXT_0               BIT0
#define  CAN_ID9_EXT_1               BIT1
#define  CAN_ID9_EXT_2               BIT2
#define  CAN_ID9_EXT_3               BIT3
#define  CAN_ID9_EXT_4               BIT4
#define  CAN_ID9_EXT_5               BIT5
#define  CAN_ID9_EXT_6               BIT6
#define  CAN_ID9_EXT_7               BIT7
#define  CAN_ID9_EXT_8               BIT8
#define  CAN_ID9_EXT_9               BIT9
#define  CAN_ID9_EXT_10              BIT10
#define  CAN_ID9_EXT_11              BIT11
#define  CAN_ID9_EXT_12              BIT12
#define  CAN_ID9_EXT_13              BIT13
#define  CAN_ID9_EXT_14              BIT14
#define  CAN_ID9_EXT_15              BIT15
#define  CAN_ID9_EXT_16              BIT16
#define  CAN_ID9_EXT_17              BIT17

#define  CAN_ID9_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID9_STD_0               BIT18
#define  CAN_ID9_STD_1               BIT19
#define  CAN_ID9_STD_2               BIT20
#define  CAN_ID9_STD_3               BIT21
#define  CAN_ID9_STD_4               BIT22
#define  CAN_ID9_STD_5               BIT23
#define  CAN_ID9_STD_6               BIT24
#define  CAN_ID9_STD_7               BIT25
#define  CAN_ID9_STD_8               BIT26
#define  CAN_ID9_STD_9               BIT27
#define  CAN_ID9_STD_10              BIT28

#define  CAN_ID9_PRIO                (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID9_PRIO_0              BIT29
#define  CAN_ID9_PRIO_1              BIT30
#define  CAN_ID9_PRIO_2              BIT31

#define  CAN_WORD09_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD09_DATA_BYTE_3_0    BIT0
#define  CAN_WORD09_DATA_BYTE_3_1    BIT1
#define  CAN_WORD09_DATA_BYTE_3_2    BIT2
#define  CAN_WORD09_DATA_BYTE_3_3    BIT3
#define  CAN_WORD09_DATA_BYTE_3_4    BIT4
#define  CAN_WORD09_DATA_BYTE_3_5    BIT5
#define  CAN_WORD09_DATA_BYTE_3_6    BIT6
#define  CAN_WORD09_DATA_BYTE_3_7    BIT7

#define  CAN_WORD09_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD09_DATA_BYTE_2_0    BIT8
#define  CAN_WORD09_DATA_BYTE_2_1    BIT9
#define  CAN_WORD09_DATA_BYTE_2_2    BIT10
#define  CAN_WORD09_DATA_BYTE_2_3    BIT11
#define  CAN_WORD09_DATA_BYTE_2_4    BIT12
#define  CAN_WORD09_DATA_BYTE_2_5    BIT13
#define  CAN_WORD09_DATA_BYTE_2_6    BIT14
#define  CAN_WORD09_DATA_BYTE_2_7    BIT15

#define  CAN_WORD09_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD09_DATA_BYTE_1_0    BIT16
#define  CAN_WORD09_DATA_BYTE_1_1    BIT17
#define  CAN_WORD09_DATA_BYTE_1_2    BIT18
#define  CAN_WORD09_DATA_BYTE_1_3    BIT19
#define  CAN_WORD09_DATA_BYTE_1_4    BIT20
#define  CAN_WORD09_DATA_BYTE_1_5    BIT21
#define  CAN_WORD09_DATA_BYTE_1_6    BIT22
#define  CAN_WORD09_DATA_BYTE_1_7    BIT23

#define  CAN_WORD09_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD09_DATA_BYTE_0_0    BIT24
#define  CAN_WORD09_DATA_BYTE_0_1    BIT25
#define  CAN_WORD09_DATA_BYTE_0_2    BIT26
#define  CAN_WORD09_DATA_BYTE_0_3    BIT27
#define  CAN_WORD09_DATA_BYTE_0_4    BIT28
#define  CAN_WORD09_DATA_BYTE_0_5    BIT29
#define  CAN_WORD09_DATA_BYTE_0_6    BIT30
#define  CAN_WORD09_DATA_BYTE_0_7    BIT31

#define  CAN_WORD19_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD19_DATA_BYTE_7_0    BIT0
#define  CAN_WORD19_DATA_BYTE_7_1    BIT1
#define  CAN_WORD19_DATA_BYTE_7_2    BIT2
#define  CAN_WORD19_DATA_BYTE_7_3    BIT3
#define  CAN_WORD19_DATA_BYTE_7_4    BIT4
#define  CAN_WORD19_DATA_BYTE_7_5    BIT5
#define  CAN_WORD19_DATA_BYTE_7_6    BIT6
#define  CAN_WORD19_DATA_BYTE_7_7    BIT7

#define  CAN_WORD19_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD19_DATA_BYTE_6_0    BIT8
#define  CAN_WORD19_DATA_BYTE_6_1    BIT9
#define  CAN_WORD19_DATA_BYTE_6_2    BIT10
#define  CAN_WORD19_DATA_BYTE_6_3    BIT11
#define  CAN_WORD19_DATA_BYTE_6_4    BIT12
#define  CAN_WORD19_DATA_BYTE_6_5    BIT13
#define  CAN_WORD19_DATA_BYTE_6_6    BIT14
#define  CAN_WORD19_DATA_BYTE_6_7    BIT15

#define  CAN_WORD19_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD19_DATA_BYTE_5_0    BIT16
#define  CAN_WORD19_DATA_BYTE_5_1    BIT17
#define  CAN_WORD19_DATA_BYTE_5_2    BIT18
#define  CAN_WORD19_DATA_BYTE_5_3    BIT19
#define  CAN_WORD19_DATA_BYTE_5_4    BIT20
#define  CAN_WORD19_DATA_BYTE_5_5    BIT21
#define  CAN_WORD19_DATA_BYTE_5_6    BIT22
#define  CAN_WORD19_DATA_BYTE_5_7    BIT23

#define  CAN_WORD19_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD19_DATA_BYTE_4_0    BIT24
#define  CAN_WORD19_DATA_BYTE_4_1    BIT25
#define  CAN_WORD19_DATA_BYTE_4_2    BIT26
#define  CAN_WORD19_DATA_BYTE_4_3    BIT27
#define  CAN_WORD19_DATA_BYTE_4_4    BIT28
#define  CAN_WORD19_DATA_BYTE_4_5    BIT29
#define  CAN_WORD19_DATA_BYTE_4_6    BIT30
#define  CAN_WORD19_DATA_BYTE_4_7    BIT31

#define  CAN_CS10_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS10_TIME_STAMP_0       BIT0
#define  CAN_CS10_TIME_STAMP_1       BIT1
#define  CAN_CS10_TIME_STAMP_2       BIT2
#define  CAN_CS10_TIME_STAMP_3       BIT3
#define  CAN_CS10_TIME_STAMP_4       BIT4
#define  CAN_CS10_TIME_STAMP_5       BIT5
#define  CAN_CS10_TIME_STAMP_6       BIT6
#define  CAN_CS10_TIME_STAMP_7       BIT7
#define  CAN_CS10_TIME_STAMP_8       BIT8
#define  CAN_CS10_TIME_STAMP_9       BIT9
#define  CAN_CS10_TIME_STAMP_10      BIT10
#define  CAN_CS10_TIME_STAMP_11      BIT11
#define  CAN_CS10_TIME_STAMP_12      BIT12
#define  CAN_CS10_TIME_STAMP_13      BIT13
#define  CAN_CS10_TIME_STAMP_14      BIT14
#define  CAN_CS10_TIME_STAMP_15      BIT15

#define  CAN_CS10_DLC                (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS10_DLC_0              BIT16
#define  CAN_CS10_DLC_1              BIT17
#define  CAN_CS10_DLC_2              BIT18
#define  CAN_CS10_DLC_3              BIT19

#define  CAN_CS10_RTR                BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS10_IDE                BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS10_SRR                BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS10_CODE               (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS10_CODE_0             BIT24
#define  CAN_CS10_CODE_1             BIT25
#define  CAN_CS10_CODE_2             BIT26
#define  CAN_CS10_CODE_3             BIT27

#define  CAN_ID10_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID10_EXT_0              BIT0
#define  CAN_ID10_EXT_1              BIT1
#define  CAN_ID10_EXT_2              BIT2
#define  CAN_ID10_EXT_3              BIT3
#define  CAN_ID10_EXT_4              BIT4
#define  CAN_ID10_EXT_5              BIT5
#define  CAN_ID10_EXT_6              BIT6
#define  CAN_ID10_EXT_7              BIT7
#define  CAN_ID10_EXT_8              BIT8
#define  CAN_ID10_EXT_9              BIT9
#define  CAN_ID10_EXT_10             BIT10
#define  CAN_ID10_EXT_11             BIT11
#define  CAN_ID10_EXT_12             BIT12
#define  CAN_ID10_EXT_13             BIT13
#define  CAN_ID10_EXT_14             BIT14
#define  CAN_ID10_EXT_15             BIT15
#define  CAN_ID10_EXT_16             BIT16
#define  CAN_ID10_EXT_17             BIT17

#define  CAN_ID10_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID10_STD_0              BIT18
#define  CAN_ID10_STD_1              BIT19
#define  CAN_ID10_STD_2              BIT20
#define  CAN_ID10_STD_3              BIT21
#define  CAN_ID10_STD_4              BIT22
#define  CAN_ID10_STD_5              BIT23
#define  CAN_ID10_STD_6              BIT24
#define  CAN_ID10_STD_7              BIT25
#define  CAN_ID10_STD_8              BIT26
#define  CAN_ID10_STD_9              BIT27
#define  CAN_ID10_STD_10             BIT28

#define  CAN_ID10_PRIO               (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID10_PRIO_0             BIT29
#define  CAN_ID10_PRIO_1             BIT30
#define  CAN_ID10_PRIO_2             BIT31

#define  CAN_WORD010_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD010_DATA_BYTE_3_0   BIT0
#define  CAN_WORD010_DATA_BYTE_3_1   BIT1
#define  CAN_WORD010_DATA_BYTE_3_2   BIT2
#define  CAN_WORD010_DATA_BYTE_3_3   BIT3
#define  CAN_WORD010_DATA_BYTE_3_4   BIT4
#define  CAN_WORD010_DATA_BYTE_3_5   BIT5
#define  CAN_WORD010_DATA_BYTE_3_6   BIT6
#define  CAN_WORD010_DATA_BYTE_3_7   BIT7

#define  CAN_WORD010_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD010_DATA_BYTE_2_0   BIT8
#define  CAN_WORD010_DATA_BYTE_2_1   BIT9
#define  CAN_WORD010_DATA_BYTE_2_2   BIT10
#define  CAN_WORD010_DATA_BYTE_2_3   BIT11
#define  CAN_WORD010_DATA_BYTE_2_4   BIT12
#define  CAN_WORD010_DATA_BYTE_2_5   BIT13
#define  CAN_WORD010_DATA_BYTE_2_6   BIT14
#define  CAN_WORD010_DATA_BYTE_2_7   BIT15

#define  CAN_WORD010_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD010_DATA_BYTE_1_0   BIT16
#define  CAN_WORD010_DATA_BYTE_1_1   BIT17
#define  CAN_WORD010_DATA_BYTE_1_2   BIT18
#define  CAN_WORD010_DATA_BYTE_1_3   BIT19
#define  CAN_WORD010_DATA_BYTE_1_4   BIT20
#define  CAN_WORD010_DATA_BYTE_1_5   BIT21
#define  CAN_WORD010_DATA_BYTE_1_6   BIT22
#define  CAN_WORD010_DATA_BYTE_1_7   BIT23

#define  CAN_WORD010_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD010_DATA_BYTE_0_0   BIT24
#define  CAN_WORD010_DATA_BYTE_0_1   BIT25
#define  CAN_WORD010_DATA_BYTE_0_2   BIT26
#define  CAN_WORD010_DATA_BYTE_0_3   BIT27
#define  CAN_WORD010_DATA_BYTE_0_4   BIT28
#define  CAN_WORD010_DATA_BYTE_0_5   BIT29
#define  CAN_WORD010_DATA_BYTE_0_6   BIT30
#define  CAN_WORD010_DATA_BYTE_0_7   BIT31

#define  CAN_WORD110_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD110_DATA_BYTE_7_0   BIT0
#define  CAN_WORD110_DATA_BYTE_7_1   BIT1
#define  CAN_WORD110_DATA_BYTE_7_2   BIT2
#define  CAN_WORD110_DATA_BYTE_7_3   BIT3
#define  CAN_WORD110_DATA_BYTE_7_4   BIT4
#define  CAN_WORD110_DATA_BYTE_7_5   BIT5
#define  CAN_WORD110_DATA_BYTE_7_6   BIT6
#define  CAN_WORD110_DATA_BYTE_7_7   BIT7

#define  CAN_WORD110_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD110_DATA_BYTE_6_0   BIT8
#define  CAN_WORD110_DATA_BYTE_6_1   BIT9
#define  CAN_WORD110_DATA_BYTE_6_2   BIT10
#define  CAN_WORD110_DATA_BYTE_6_3   BIT11
#define  CAN_WORD110_DATA_BYTE_6_4   BIT12
#define  CAN_WORD110_DATA_BYTE_6_5   BIT13
#define  CAN_WORD110_DATA_BYTE_6_6   BIT14
#define  CAN_WORD110_DATA_BYTE_6_7   BIT15

#define  CAN_WORD110_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD110_DATA_BYTE_5_0   BIT16
#define  CAN_WORD110_DATA_BYTE_5_1   BIT17
#define  CAN_WORD110_DATA_BYTE_5_2   BIT18
#define  CAN_WORD110_DATA_BYTE_5_3   BIT19
#define  CAN_WORD110_DATA_BYTE_5_4   BIT20
#define  CAN_WORD110_DATA_BYTE_5_5   BIT21
#define  CAN_WORD110_DATA_BYTE_5_6   BIT22
#define  CAN_WORD110_DATA_BYTE_5_7   BIT23

#define  CAN_WORD110_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD110_DATA_BYTE_4_0   BIT24
#define  CAN_WORD110_DATA_BYTE_4_1   BIT25
#define  CAN_WORD110_DATA_BYTE_4_2   BIT26
#define  CAN_WORD110_DATA_BYTE_4_3   BIT27
#define  CAN_WORD110_DATA_BYTE_4_4   BIT28
#define  CAN_WORD110_DATA_BYTE_4_5   BIT29
#define  CAN_WORD110_DATA_BYTE_4_6   BIT30
#define  CAN_WORD110_DATA_BYTE_4_7   BIT31

#define  CAN_CS11_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS11_TIME_STAMP_0       BIT0
#define  CAN_CS11_TIME_STAMP_1       BIT1
#define  CAN_CS11_TIME_STAMP_2       BIT2
#define  CAN_CS11_TIME_STAMP_3       BIT3
#define  CAN_CS11_TIME_STAMP_4       BIT4
#define  CAN_CS11_TIME_STAMP_5       BIT5
#define  CAN_CS11_TIME_STAMP_6       BIT6
#define  CAN_CS11_TIME_STAMP_7       BIT7
#define  CAN_CS11_TIME_STAMP_8       BIT8
#define  CAN_CS11_TIME_STAMP_9       BIT9
#define  CAN_CS11_TIME_STAMP_10      BIT10
#define  CAN_CS11_TIME_STAMP_11      BIT11
#define  CAN_CS11_TIME_STAMP_12      BIT12
#define  CAN_CS11_TIME_STAMP_13      BIT13
#define  CAN_CS11_TIME_STAMP_14      BIT14
#define  CAN_CS11_TIME_STAMP_15      BIT15

#define  CAN_CS11_DLC                (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS11_DLC_0              BIT16
#define  CAN_CS11_DLC_1              BIT17
#define  CAN_CS11_DLC_2              BIT18
#define  CAN_CS11_DLC_3              BIT19

#define  CAN_CS11_RTR                BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS11_IDE                BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS11_SRR                BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS11_CODE               (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS11_CODE_0             BIT24
#define  CAN_CS11_CODE_1             BIT25
#define  CAN_CS11_CODE_2             BIT26
#define  CAN_CS11_CODE_3             BIT27

#define  CAN_ID11_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID11_EXT_0              BIT0
#define  CAN_ID11_EXT_1              BIT1
#define  CAN_ID11_EXT_2              BIT2
#define  CAN_ID11_EXT_3              BIT3
#define  CAN_ID11_EXT_4              BIT4
#define  CAN_ID11_EXT_5              BIT5
#define  CAN_ID11_EXT_6              BIT6
#define  CAN_ID11_EXT_7              BIT7
#define  CAN_ID11_EXT_8              BIT8
#define  CAN_ID11_EXT_9              BIT9
#define  CAN_ID11_EXT_10             BIT10
#define  CAN_ID11_EXT_11             BIT11
#define  CAN_ID11_EXT_12             BIT12
#define  CAN_ID11_EXT_13             BIT13
#define  CAN_ID11_EXT_14             BIT14
#define  CAN_ID11_EXT_15             BIT15
#define  CAN_ID11_EXT_16             BIT16
#define  CAN_ID11_EXT_17             BIT17

#define  CAN_ID11_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID11_STD_0              BIT18
#define  CAN_ID11_STD_1              BIT19
#define  CAN_ID11_STD_2              BIT20
#define  CAN_ID11_STD_3              BIT21
#define  CAN_ID11_STD_4              BIT22
#define  CAN_ID11_STD_5              BIT23
#define  CAN_ID11_STD_6              BIT24
#define  CAN_ID11_STD_7              BIT25
#define  CAN_ID11_STD_8              BIT26
#define  CAN_ID11_STD_9              BIT27
#define  CAN_ID11_STD_10             BIT28

#define  CAN_ID11_PRIO               (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID11_PRIO_0             BIT29
#define  CAN_ID11_PRIO_1             BIT30
#define  CAN_ID11_PRIO_2             BIT31

#define  CAN_WORD011_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD011_DATA_BYTE_3_0   BIT0
#define  CAN_WORD011_DATA_BYTE_3_1   BIT1
#define  CAN_WORD011_DATA_BYTE_3_2   BIT2
#define  CAN_WORD011_DATA_BYTE_3_3   BIT3
#define  CAN_WORD011_DATA_BYTE_3_4   BIT4
#define  CAN_WORD011_DATA_BYTE_3_5   BIT5
#define  CAN_WORD011_DATA_BYTE_3_6   BIT6
#define  CAN_WORD011_DATA_BYTE_3_7   BIT7

#define  CAN_WORD011_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD011_DATA_BYTE_2_0   BIT8
#define  CAN_WORD011_DATA_BYTE_2_1   BIT9
#define  CAN_WORD011_DATA_BYTE_2_2   BIT10
#define  CAN_WORD011_DATA_BYTE_2_3   BIT11
#define  CAN_WORD011_DATA_BYTE_2_4   BIT12
#define  CAN_WORD011_DATA_BYTE_2_5   BIT13
#define  CAN_WORD011_DATA_BYTE_2_6   BIT14
#define  CAN_WORD011_DATA_BYTE_2_7   BIT15

#define  CAN_WORD011_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD011_DATA_BYTE_1_0   BIT16
#define  CAN_WORD011_DATA_BYTE_1_1   BIT17
#define  CAN_WORD011_DATA_BYTE_1_2   BIT18
#define  CAN_WORD011_DATA_BYTE_1_3   BIT19
#define  CAN_WORD011_DATA_BYTE_1_4   BIT20
#define  CAN_WORD011_DATA_BYTE_1_5   BIT21
#define  CAN_WORD011_DATA_BYTE_1_6   BIT22
#define  CAN_WORD011_DATA_BYTE_1_7   BIT23

#define  CAN_WORD011_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD011_DATA_BYTE_0_0   BIT24
#define  CAN_WORD011_DATA_BYTE_0_1   BIT25
#define  CAN_WORD011_DATA_BYTE_0_2   BIT26
#define  CAN_WORD011_DATA_BYTE_0_3   BIT27
#define  CAN_WORD011_DATA_BYTE_0_4   BIT28
#define  CAN_WORD011_DATA_BYTE_0_5   BIT29
#define  CAN_WORD011_DATA_BYTE_0_6   BIT30
#define  CAN_WORD011_DATA_BYTE_0_7   BIT31

#define  CAN_WORD111_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD111_DATA_BYTE_7_0   BIT0
#define  CAN_WORD111_DATA_BYTE_7_1   BIT1
#define  CAN_WORD111_DATA_BYTE_7_2   BIT2
#define  CAN_WORD111_DATA_BYTE_7_3   BIT3
#define  CAN_WORD111_DATA_BYTE_7_4   BIT4
#define  CAN_WORD111_DATA_BYTE_7_5   BIT5
#define  CAN_WORD111_DATA_BYTE_7_6   BIT6
#define  CAN_WORD111_DATA_BYTE_7_7   BIT7

#define  CAN_WORD111_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD111_DATA_BYTE_6_0   BIT8
#define  CAN_WORD111_DATA_BYTE_6_1   BIT9
#define  CAN_WORD111_DATA_BYTE_6_2   BIT10
#define  CAN_WORD111_DATA_BYTE_6_3   BIT11
#define  CAN_WORD111_DATA_BYTE_6_4   BIT12
#define  CAN_WORD111_DATA_BYTE_6_5   BIT13
#define  CAN_WORD111_DATA_BYTE_6_6   BIT14
#define  CAN_WORD111_DATA_BYTE_6_7   BIT15

#define  CAN_WORD111_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD111_DATA_BYTE_5_0   BIT16
#define  CAN_WORD111_DATA_BYTE_5_1   BIT17
#define  CAN_WORD111_DATA_BYTE_5_2   BIT18
#define  CAN_WORD111_DATA_BYTE_5_3   BIT19
#define  CAN_WORD111_DATA_BYTE_5_4   BIT20
#define  CAN_WORD111_DATA_BYTE_5_5   BIT21
#define  CAN_WORD111_DATA_BYTE_5_6   BIT22
#define  CAN_WORD111_DATA_BYTE_5_7   BIT23

#define  CAN_WORD111_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD111_DATA_BYTE_4_0   BIT24
#define  CAN_WORD111_DATA_BYTE_4_1   BIT25
#define  CAN_WORD111_DATA_BYTE_4_2   BIT26
#define  CAN_WORD111_DATA_BYTE_4_3   BIT27
#define  CAN_WORD111_DATA_BYTE_4_4   BIT28
#define  CAN_WORD111_DATA_BYTE_4_5   BIT29
#define  CAN_WORD111_DATA_BYTE_4_6   BIT30
#define  CAN_WORD111_DATA_BYTE_4_7   BIT31

#define  CAN_CS12_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS12_TIME_STAMP_0       BIT0
#define  CAN_CS12_TIME_STAMP_1       BIT1
#define  CAN_CS12_TIME_STAMP_2       BIT2
#define  CAN_CS12_TIME_STAMP_3       BIT3
#define  CAN_CS12_TIME_STAMP_4       BIT4
#define  CAN_CS12_TIME_STAMP_5       BIT5
#define  CAN_CS12_TIME_STAMP_6       BIT6
#define  CAN_CS12_TIME_STAMP_7       BIT7
#define  CAN_CS12_TIME_STAMP_8       BIT8
#define  CAN_CS12_TIME_STAMP_9       BIT9
#define  CAN_CS12_TIME_STAMP_10      BIT10
#define  CAN_CS12_TIME_STAMP_11      BIT11
#define  CAN_CS12_TIME_STAMP_12      BIT12
#define  CAN_CS12_TIME_STAMP_13      BIT13
#define  CAN_CS12_TIME_STAMP_14      BIT14
#define  CAN_CS12_TIME_STAMP_15      BIT15

#define  CAN_CS12_DLC                (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS12_DLC_0              BIT16
#define  CAN_CS12_DLC_1              BIT17
#define  CAN_CS12_DLC_2              BIT18
#define  CAN_CS12_DLC_3              BIT19

#define  CAN_CS12_RTR                BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS12_IDE                BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS12_SRR                BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS12_CODE               (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS12_CODE_0             BIT24
#define  CAN_CS12_CODE_1             BIT25
#define  CAN_CS12_CODE_2             BIT26
#define  CAN_CS12_CODE_3             BIT27

#define  CAN_ID12_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID12_EXT_0              BIT0
#define  CAN_ID12_EXT_1              BIT1
#define  CAN_ID12_EXT_2              BIT2
#define  CAN_ID12_EXT_3              BIT3
#define  CAN_ID12_EXT_4              BIT4
#define  CAN_ID12_EXT_5              BIT5
#define  CAN_ID12_EXT_6              BIT6
#define  CAN_ID12_EXT_7              BIT7
#define  CAN_ID12_EXT_8              BIT8
#define  CAN_ID12_EXT_9              BIT9
#define  CAN_ID12_EXT_10             BIT10
#define  CAN_ID12_EXT_11             BIT11
#define  CAN_ID12_EXT_12             BIT12
#define  CAN_ID12_EXT_13             BIT13
#define  CAN_ID12_EXT_14             BIT14
#define  CAN_ID12_EXT_15             BIT15
#define  CAN_ID12_EXT_16             BIT16
#define  CAN_ID12_EXT_17             BIT17

#define  CAN_ID12_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID12_STD_0              BIT18
#define  CAN_ID12_STD_1              BIT19
#define  CAN_ID12_STD_2              BIT20
#define  CAN_ID12_STD_3              BIT21
#define  CAN_ID12_STD_4              BIT22
#define  CAN_ID12_STD_5              BIT23
#define  CAN_ID12_STD_6              BIT24
#define  CAN_ID12_STD_7              BIT25
#define  CAN_ID12_STD_8              BIT26
#define  CAN_ID12_STD_9              BIT27
#define  CAN_ID12_STD_10             BIT28

#define  CAN_ID12_PRIO               (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID12_PRIO_0             BIT29
#define  CAN_ID12_PRIO_1             BIT30
#define  CAN_ID12_PRIO_2             BIT31

#define  CAN_WORD012_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD012_DATA_BYTE_3_0   BIT0
#define  CAN_WORD012_DATA_BYTE_3_1   BIT1
#define  CAN_WORD012_DATA_BYTE_3_2   BIT2
#define  CAN_WORD012_DATA_BYTE_3_3   BIT3
#define  CAN_WORD012_DATA_BYTE_3_4   BIT4
#define  CAN_WORD012_DATA_BYTE_3_5   BIT5
#define  CAN_WORD012_DATA_BYTE_3_6   BIT6
#define  CAN_WORD012_DATA_BYTE_3_7   BIT7

#define  CAN_WORD012_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD012_DATA_BYTE_2_0   BIT8
#define  CAN_WORD012_DATA_BYTE_2_1   BIT9
#define  CAN_WORD012_DATA_BYTE_2_2   BIT10
#define  CAN_WORD012_DATA_BYTE_2_3   BIT11
#define  CAN_WORD012_DATA_BYTE_2_4   BIT12
#define  CAN_WORD012_DATA_BYTE_2_5   BIT13
#define  CAN_WORD012_DATA_BYTE_2_6   BIT14
#define  CAN_WORD012_DATA_BYTE_2_7   BIT15

#define  CAN_WORD012_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD012_DATA_BYTE_1_0   BIT16
#define  CAN_WORD012_DATA_BYTE_1_1   BIT17
#define  CAN_WORD012_DATA_BYTE_1_2   BIT18
#define  CAN_WORD012_DATA_BYTE_1_3   BIT19
#define  CAN_WORD012_DATA_BYTE_1_4   BIT20
#define  CAN_WORD012_DATA_BYTE_1_5   BIT21
#define  CAN_WORD012_DATA_BYTE_1_6   BIT22
#define  CAN_WORD012_DATA_BYTE_1_7   BIT23

#define  CAN_WORD012_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD012_DATA_BYTE_0_0   BIT24
#define  CAN_WORD012_DATA_BYTE_0_1   BIT25
#define  CAN_WORD012_DATA_BYTE_0_2   BIT26
#define  CAN_WORD012_DATA_BYTE_0_3   BIT27
#define  CAN_WORD012_DATA_BYTE_0_4   BIT28
#define  CAN_WORD012_DATA_BYTE_0_5   BIT29
#define  CAN_WORD012_DATA_BYTE_0_6   BIT30
#define  CAN_WORD012_DATA_BYTE_0_7   BIT31

#define  CAN_WORD112_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD112_DATA_BYTE_7_0   BIT0
#define  CAN_WORD112_DATA_BYTE_7_1   BIT1
#define  CAN_WORD112_DATA_BYTE_7_2   BIT2
#define  CAN_WORD112_DATA_BYTE_7_3   BIT3
#define  CAN_WORD112_DATA_BYTE_7_4   BIT4
#define  CAN_WORD112_DATA_BYTE_7_5   BIT5
#define  CAN_WORD112_DATA_BYTE_7_6   BIT6
#define  CAN_WORD112_DATA_BYTE_7_7   BIT7

#define  CAN_WORD112_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD112_DATA_BYTE_6_0   BIT8
#define  CAN_WORD112_DATA_BYTE_6_1   BIT9
#define  CAN_WORD112_DATA_BYTE_6_2   BIT10
#define  CAN_WORD112_DATA_BYTE_6_3   BIT11
#define  CAN_WORD112_DATA_BYTE_6_4   BIT12
#define  CAN_WORD112_DATA_BYTE_6_5   BIT13
#define  CAN_WORD112_DATA_BYTE_6_6   BIT14
#define  CAN_WORD112_DATA_BYTE_6_7   BIT15

#define  CAN_WORD112_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD112_DATA_BYTE_5_0   BIT16
#define  CAN_WORD112_DATA_BYTE_5_1   BIT17
#define  CAN_WORD112_DATA_BYTE_5_2   BIT18
#define  CAN_WORD112_DATA_BYTE_5_3   BIT19
#define  CAN_WORD112_DATA_BYTE_5_4   BIT20
#define  CAN_WORD112_DATA_BYTE_5_5   BIT21
#define  CAN_WORD112_DATA_BYTE_5_6   BIT22
#define  CAN_WORD112_DATA_BYTE_5_7   BIT23

#define  CAN_WORD112_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD112_DATA_BYTE_4_0   BIT24
#define  CAN_WORD112_DATA_BYTE_4_1   BIT25
#define  CAN_WORD112_DATA_BYTE_4_2   BIT26
#define  CAN_WORD112_DATA_BYTE_4_3   BIT27
#define  CAN_WORD112_DATA_BYTE_4_4   BIT28
#define  CAN_WORD112_DATA_BYTE_4_5   BIT29
#define  CAN_WORD112_DATA_BYTE_4_6   BIT30
#define  CAN_WORD112_DATA_BYTE_4_7   BIT31

#define  CAN_CS13_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS13_TIME_STAMP_0       BIT0
#define  CAN_CS13_TIME_STAMP_1       BIT1
#define  CAN_CS13_TIME_STAMP_2       BIT2
#define  CAN_CS13_TIME_STAMP_3       BIT3
#define  CAN_CS13_TIME_STAMP_4       BIT4
#define  CAN_CS13_TIME_STAMP_5       BIT5
#define  CAN_CS13_TIME_STAMP_6       BIT6
#define  CAN_CS13_TIME_STAMP_7       BIT7
#define  CAN_CS13_TIME_STAMP_8       BIT8
#define  CAN_CS13_TIME_STAMP_9       BIT9
#define  CAN_CS13_TIME_STAMP_10      BIT10
#define  CAN_CS13_TIME_STAMP_11      BIT11
#define  CAN_CS13_TIME_STAMP_12      BIT12
#define  CAN_CS13_TIME_STAMP_13      BIT13
#define  CAN_CS13_TIME_STAMP_14      BIT14
#define  CAN_CS13_TIME_STAMP_15      BIT15

#define  CAN_CS13_DLC                (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS13_DLC_0              BIT16
#define  CAN_CS13_DLC_1              BIT17
#define  CAN_CS13_DLC_2              BIT18
#define  CAN_CS13_DLC_3              BIT19

#define  CAN_CS13_RTR                BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS13_IDE                BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS13_SRR                BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS13_CODE               (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS13_CODE_0             BIT24
#define  CAN_CS13_CODE_1             BIT25
#define  CAN_CS13_CODE_2             BIT26
#define  CAN_CS13_CODE_3             BIT27

#define  CAN_ID13_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID13_EXT_0              BIT0
#define  CAN_ID13_EXT_1              BIT1
#define  CAN_ID13_EXT_2              BIT2
#define  CAN_ID13_EXT_3              BIT3
#define  CAN_ID13_EXT_4              BIT4
#define  CAN_ID13_EXT_5              BIT5
#define  CAN_ID13_EXT_6              BIT6
#define  CAN_ID13_EXT_7              BIT7
#define  CAN_ID13_EXT_8              BIT8
#define  CAN_ID13_EXT_9              BIT9
#define  CAN_ID13_EXT_10             BIT10
#define  CAN_ID13_EXT_11             BIT11
#define  CAN_ID13_EXT_12             BIT12
#define  CAN_ID13_EXT_13             BIT13
#define  CAN_ID13_EXT_14             BIT14
#define  CAN_ID13_EXT_15             BIT15
#define  CAN_ID13_EXT_16             BIT16
#define  CAN_ID13_EXT_17             BIT17

#define  CAN_ID13_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID13_STD_0              BIT18
#define  CAN_ID13_STD_1              BIT19
#define  CAN_ID13_STD_2              BIT20
#define  CAN_ID13_STD_3              BIT21
#define  CAN_ID13_STD_4              BIT22
#define  CAN_ID13_STD_5              BIT23
#define  CAN_ID13_STD_6              BIT24
#define  CAN_ID13_STD_7              BIT25
#define  CAN_ID13_STD_8              BIT26
#define  CAN_ID13_STD_9              BIT27
#define  CAN_ID13_STD_10             BIT28

#define  CAN_ID13_PRIO               (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID13_PRIO_0             BIT29
#define  CAN_ID13_PRIO_1             BIT30
#define  CAN_ID13_PRIO_2             BIT31

#define  CAN_WORD013_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD013_DATA_BYTE_3_0   BIT0
#define  CAN_WORD013_DATA_BYTE_3_1   BIT1
#define  CAN_WORD013_DATA_BYTE_3_2   BIT2
#define  CAN_WORD013_DATA_BYTE_3_3   BIT3
#define  CAN_WORD013_DATA_BYTE_3_4   BIT4
#define  CAN_WORD013_DATA_BYTE_3_5   BIT5
#define  CAN_WORD013_DATA_BYTE_3_6   BIT6
#define  CAN_WORD013_DATA_BYTE_3_7   BIT7

#define  CAN_WORD013_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD013_DATA_BYTE_2_0   BIT8
#define  CAN_WORD013_DATA_BYTE_2_1   BIT9
#define  CAN_WORD013_DATA_BYTE_2_2   BIT10
#define  CAN_WORD013_DATA_BYTE_2_3   BIT11
#define  CAN_WORD013_DATA_BYTE_2_4   BIT12
#define  CAN_WORD013_DATA_BYTE_2_5   BIT13
#define  CAN_WORD013_DATA_BYTE_2_6   BIT14
#define  CAN_WORD013_DATA_BYTE_2_7   BIT15

#define  CAN_WORD013_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD013_DATA_BYTE_1_0   BIT16
#define  CAN_WORD013_DATA_BYTE_1_1   BIT17
#define  CAN_WORD013_DATA_BYTE_1_2   BIT18
#define  CAN_WORD013_DATA_BYTE_1_3   BIT19
#define  CAN_WORD013_DATA_BYTE_1_4   BIT20
#define  CAN_WORD013_DATA_BYTE_1_5   BIT21
#define  CAN_WORD013_DATA_BYTE_1_6   BIT22
#define  CAN_WORD013_DATA_BYTE_1_7   BIT23

#define  CAN_WORD013_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD013_DATA_BYTE_0_0   BIT24
#define  CAN_WORD013_DATA_BYTE_0_1   BIT25
#define  CAN_WORD013_DATA_BYTE_0_2   BIT26
#define  CAN_WORD013_DATA_BYTE_0_3   BIT27
#define  CAN_WORD013_DATA_BYTE_0_4   BIT28
#define  CAN_WORD013_DATA_BYTE_0_5   BIT29
#define  CAN_WORD013_DATA_BYTE_0_6   BIT30
#define  CAN_WORD013_DATA_BYTE_0_7   BIT31

#define  CAN_WORD113_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD113_DATA_BYTE_7_0   BIT0
#define  CAN_WORD113_DATA_BYTE_7_1   BIT1
#define  CAN_WORD113_DATA_BYTE_7_2   BIT2
#define  CAN_WORD113_DATA_BYTE_7_3   BIT3
#define  CAN_WORD113_DATA_BYTE_7_4   BIT4
#define  CAN_WORD113_DATA_BYTE_7_5   BIT5
#define  CAN_WORD113_DATA_BYTE_7_6   BIT6
#define  CAN_WORD113_DATA_BYTE_7_7   BIT7

#define  CAN_WORD113_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD113_DATA_BYTE_6_0   BIT8
#define  CAN_WORD113_DATA_BYTE_6_1   BIT9
#define  CAN_WORD113_DATA_BYTE_6_2   BIT10
#define  CAN_WORD113_DATA_BYTE_6_3   BIT11
#define  CAN_WORD113_DATA_BYTE_6_4   BIT12
#define  CAN_WORD113_DATA_BYTE_6_5   BIT13
#define  CAN_WORD113_DATA_BYTE_6_6   BIT14
#define  CAN_WORD113_DATA_BYTE_6_7   BIT15

#define  CAN_WORD113_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD113_DATA_BYTE_5_0   BIT16
#define  CAN_WORD113_DATA_BYTE_5_1   BIT17
#define  CAN_WORD113_DATA_BYTE_5_2   BIT18
#define  CAN_WORD113_DATA_BYTE_5_3   BIT19
#define  CAN_WORD113_DATA_BYTE_5_4   BIT20
#define  CAN_WORD113_DATA_BYTE_5_5   BIT21
#define  CAN_WORD113_DATA_BYTE_5_6   BIT22
#define  CAN_WORD113_DATA_BYTE_5_7   BIT23

#define  CAN_WORD113_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD113_DATA_BYTE_4_0   BIT24
#define  CAN_WORD113_DATA_BYTE_4_1   BIT25
#define  CAN_WORD113_DATA_BYTE_4_2   BIT26
#define  CAN_WORD113_DATA_BYTE_4_3   BIT27
#define  CAN_WORD113_DATA_BYTE_4_4   BIT28
#define  CAN_WORD113_DATA_BYTE_4_5   BIT29
#define  CAN_WORD113_DATA_BYTE_4_6   BIT30
#define  CAN_WORD113_DATA_BYTE_4_7   BIT31

#define  CAN_CS14_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS14_TIME_STAMP_0       BIT0
#define  CAN_CS14_TIME_STAMP_1       BIT1
#define  CAN_CS14_TIME_STAMP_2       BIT2
#define  CAN_CS14_TIME_STAMP_3       BIT3
#define  CAN_CS14_TIME_STAMP_4       BIT4
#define  CAN_CS14_TIME_STAMP_5       BIT5
#define  CAN_CS14_TIME_STAMP_6       BIT6
#define  CAN_CS14_TIME_STAMP_7       BIT7
#define  CAN_CS14_TIME_STAMP_8       BIT8
#define  CAN_CS14_TIME_STAMP_9       BIT9
#define  CAN_CS14_TIME_STAMP_10      BIT10
#define  CAN_CS14_TIME_STAMP_11      BIT11
#define  CAN_CS14_TIME_STAMP_12      BIT12
#define  CAN_CS14_TIME_STAMP_13      BIT13
#define  CAN_CS14_TIME_STAMP_14      BIT14
#define  CAN_CS14_TIME_STAMP_15      BIT15

#define  CAN_CS14_DLC                (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS14_DLC_0              BIT16
#define  CAN_CS14_DLC_1              BIT17
#define  CAN_CS14_DLC_2              BIT18
#define  CAN_CS14_DLC_3              BIT19

#define  CAN_CS14_RTR                BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS14_IDE                BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS14_SRR                BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS14_CODE               (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS14_CODE_0             BIT24
#define  CAN_CS14_CODE_1             BIT25
#define  CAN_CS14_CODE_2             BIT26
#define  CAN_CS14_CODE_3             BIT27

#define  CAN_ID14_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID14_EXT_0              BIT0
#define  CAN_ID14_EXT_1              BIT1
#define  CAN_ID14_EXT_2              BIT2
#define  CAN_ID14_EXT_3              BIT3
#define  CAN_ID14_EXT_4              BIT4
#define  CAN_ID14_EXT_5              BIT5
#define  CAN_ID14_EXT_6              BIT6
#define  CAN_ID14_EXT_7              BIT7
#define  CAN_ID14_EXT_8              BIT8
#define  CAN_ID14_EXT_9              BIT9
#define  CAN_ID14_EXT_10             BIT10
#define  CAN_ID14_EXT_11             BIT11
#define  CAN_ID14_EXT_12             BIT12
#define  CAN_ID14_EXT_13             BIT13
#define  CAN_ID14_EXT_14             BIT14
#define  CAN_ID14_EXT_15             BIT15
#define  CAN_ID14_EXT_16             BIT16
#define  CAN_ID14_EXT_17             BIT17

#define  CAN_ID14_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID14_STD_0              BIT18
#define  CAN_ID14_STD_1              BIT19
#define  CAN_ID14_STD_2              BIT20
#define  CAN_ID14_STD_3              BIT21
#define  CAN_ID14_STD_4              BIT22
#define  CAN_ID14_STD_5              BIT23
#define  CAN_ID14_STD_6              BIT24
#define  CAN_ID14_STD_7              BIT25
#define  CAN_ID14_STD_8              BIT26
#define  CAN_ID14_STD_9              BIT27
#define  CAN_ID14_STD_10             BIT28

#define  CAN_ID14_PRIO               (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID14_PRIO_0             BIT29
#define  CAN_ID14_PRIO_1             BIT30
#define  CAN_ID14_PRIO_2             BIT31

#define  CAN_WORD014_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD014_DATA_BYTE_3_0   BIT0
#define  CAN_WORD014_DATA_BYTE_3_1   BIT1
#define  CAN_WORD014_DATA_BYTE_3_2   BIT2
#define  CAN_WORD014_DATA_BYTE_3_3   BIT3
#define  CAN_WORD014_DATA_BYTE_3_4   BIT4
#define  CAN_WORD014_DATA_BYTE_3_5   BIT5
#define  CAN_WORD014_DATA_BYTE_3_6   BIT6
#define  CAN_WORD014_DATA_BYTE_3_7   BIT7

#define  CAN_WORD014_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD014_DATA_BYTE_2_0   BIT8
#define  CAN_WORD014_DATA_BYTE_2_1   BIT9
#define  CAN_WORD014_DATA_BYTE_2_2   BIT10
#define  CAN_WORD014_DATA_BYTE_2_3   BIT11
#define  CAN_WORD014_DATA_BYTE_2_4   BIT12
#define  CAN_WORD014_DATA_BYTE_2_5   BIT13
#define  CAN_WORD014_DATA_BYTE_2_6   BIT14
#define  CAN_WORD014_DATA_BYTE_2_7   BIT15

#define  CAN_WORD014_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD014_DATA_BYTE_1_0   BIT16
#define  CAN_WORD014_DATA_BYTE_1_1   BIT17
#define  CAN_WORD014_DATA_BYTE_1_2   BIT18
#define  CAN_WORD014_DATA_BYTE_1_3   BIT19
#define  CAN_WORD014_DATA_BYTE_1_4   BIT20
#define  CAN_WORD014_DATA_BYTE_1_5   BIT21
#define  CAN_WORD014_DATA_BYTE_1_6   BIT22
#define  CAN_WORD014_DATA_BYTE_1_7   BIT23

#define  CAN_WORD014_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD014_DATA_BYTE_0_0   BIT24
#define  CAN_WORD014_DATA_BYTE_0_1   BIT25
#define  CAN_WORD014_DATA_BYTE_0_2   BIT26
#define  CAN_WORD014_DATA_BYTE_0_3   BIT27
#define  CAN_WORD014_DATA_BYTE_0_4   BIT28
#define  CAN_WORD014_DATA_BYTE_0_5   BIT29
#define  CAN_WORD014_DATA_BYTE_0_6   BIT30
#define  CAN_WORD014_DATA_BYTE_0_7   BIT31

#define  CAN_WORD114_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD114_DATA_BYTE_7_0   BIT0
#define  CAN_WORD114_DATA_BYTE_7_1   BIT1
#define  CAN_WORD114_DATA_BYTE_7_2   BIT2
#define  CAN_WORD114_DATA_BYTE_7_3   BIT3
#define  CAN_WORD114_DATA_BYTE_7_4   BIT4
#define  CAN_WORD114_DATA_BYTE_7_5   BIT5
#define  CAN_WORD114_DATA_BYTE_7_6   BIT6
#define  CAN_WORD114_DATA_BYTE_7_7   BIT7

#define  CAN_WORD114_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD114_DATA_BYTE_6_0   BIT8
#define  CAN_WORD114_DATA_BYTE_6_1   BIT9
#define  CAN_WORD114_DATA_BYTE_6_2   BIT10
#define  CAN_WORD114_DATA_BYTE_6_3   BIT11
#define  CAN_WORD114_DATA_BYTE_6_4   BIT12
#define  CAN_WORD114_DATA_BYTE_6_5   BIT13
#define  CAN_WORD114_DATA_BYTE_6_6   BIT14
#define  CAN_WORD114_DATA_BYTE_6_7   BIT15

#define  CAN_WORD114_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD114_DATA_BYTE_5_0   BIT16
#define  CAN_WORD114_DATA_BYTE_5_1   BIT17
#define  CAN_WORD114_DATA_BYTE_5_2   BIT18
#define  CAN_WORD114_DATA_BYTE_5_3   BIT19
#define  CAN_WORD114_DATA_BYTE_5_4   BIT20
#define  CAN_WORD114_DATA_BYTE_5_5   BIT21
#define  CAN_WORD114_DATA_BYTE_5_6   BIT22
#define  CAN_WORD114_DATA_BYTE_5_7   BIT23

#define  CAN_WORD114_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD114_DATA_BYTE_4_0   BIT24
#define  CAN_WORD114_DATA_BYTE_4_1   BIT25
#define  CAN_WORD114_DATA_BYTE_4_2   BIT26
#define  CAN_WORD114_DATA_BYTE_4_3   BIT27
#define  CAN_WORD114_DATA_BYTE_4_4   BIT28
#define  CAN_WORD114_DATA_BYTE_4_5   BIT29
#define  CAN_WORD114_DATA_BYTE_4_6   BIT30
#define  CAN_WORD114_DATA_BYTE_4_7   BIT31

#define  CAN_CS15_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
#define  CAN_CS15_TIME_STAMP_0       BIT0
#define  CAN_CS15_TIME_STAMP_1       BIT1
#define  CAN_CS15_TIME_STAMP_2       BIT2
#define  CAN_CS15_TIME_STAMP_3       BIT3
#define  CAN_CS15_TIME_STAMP_4       BIT4
#define  CAN_CS15_TIME_STAMP_5       BIT5
#define  CAN_CS15_TIME_STAMP_6       BIT6
#define  CAN_CS15_TIME_STAMP_7       BIT7
#define  CAN_CS15_TIME_STAMP_8       BIT8
#define  CAN_CS15_TIME_STAMP_9       BIT9
#define  CAN_CS15_TIME_STAMP_10      BIT10
#define  CAN_CS15_TIME_STAMP_11      BIT11
#define  CAN_CS15_TIME_STAMP_12      BIT12
#define  CAN_CS15_TIME_STAMP_13      BIT13
#define  CAN_CS15_TIME_STAMP_14      BIT14
#define  CAN_CS15_TIME_STAMP_15      BIT15

#define  CAN_CS15_DLC                (BIT16|BIT17|BIT18|BIT19)
//   Length of the data to be stored/transmitted.
#define  CAN_CS15_DLC_0              BIT16
#define  CAN_CS15_DLC_1              BIT17
#define  CAN_CS15_DLC_2              BIT18
#define  CAN_CS15_DLC_3              BIT19

#define  CAN_CS15_RTR                BIT20
//   Remote Transmission Request. One/zero for remote/data frame.

#define  CAN_CS15_IDE                BIT21
//   ID Extended. One/zero for extended/standard format frame.

#define  CAN_CS15_SRR                BIT22
//   Substitute Remote Request. Contains a fixed recessive bit.

#define  CAN_CS15_CODE               (BIT24|BIT25|BIT26|BIT27)
//   Reserved
#define  CAN_CS15_CODE_0             BIT24
#define  CAN_CS15_CODE_1             BIT25
#define  CAN_CS15_CODE_2             BIT26
#define  CAN_CS15_CODE_3             BIT27

#define  CAN_ID15_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Contains extended (LOW word) identifier of message buffer.
#define  CAN_ID15_EXT_0              BIT0
#define  CAN_ID15_EXT_1              BIT1
#define  CAN_ID15_EXT_2              BIT2
#define  CAN_ID15_EXT_3              BIT3
#define  CAN_ID15_EXT_4              BIT4
#define  CAN_ID15_EXT_5              BIT5
#define  CAN_ID15_EXT_6              BIT6
#define  CAN_ID15_EXT_7              BIT7
#define  CAN_ID15_EXT_8              BIT8
#define  CAN_ID15_EXT_9              BIT9
#define  CAN_ID15_EXT_10             BIT10
#define  CAN_ID15_EXT_11             BIT11
#define  CAN_ID15_EXT_12             BIT12
#define  CAN_ID15_EXT_13             BIT13
#define  CAN_ID15_EXT_14             BIT14
#define  CAN_ID15_EXT_15             BIT15
#define  CAN_ID15_EXT_16             BIT16
#define  CAN_ID15_EXT_17             BIT17

#define  CAN_ID15_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
//   Contains standard/extended (HIGH word) identifier of message buffer.
#define  CAN_ID15_STD_0              BIT18
#define  CAN_ID15_STD_1              BIT19
#define  CAN_ID15_STD_2              BIT20
#define  CAN_ID15_STD_3              BIT21
#define  CAN_ID15_STD_4              BIT22
#define  CAN_ID15_STD_5              BIT23
#define  CAN_ID15_STD_6              BIT24
#define  CAN_ID15_STD_7              BIT25
#define  CAN_ID15_STD_8              BIT26
#define  CAN_ID15_STD_9              BIT27
#define  CAN_ID15_STD_10             BIT28

#define  CAN_ID15_PRIO               (BIT29|BIT30|BIT31)
//   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
#define  CAN_ID15_PRIO_0             BIT29
#define  CAN_ID15_PRIO_1             BIT30
#define  CAN_ID15_PRIO_2             BIT31

#define  CAN_WORD015_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 3 of Rx/Tx frame.
#define  CAN_WORD015_DATA_BYTE_3_0   BIT0
#define  CAN_WORD015_DATA_BYTE_3_1   BIT1
#define  CAN_WORD015_DATA_BYTE_3_2   BIT2
#define  CAN_WORD015_DATA_BYTE_3_3   BIT3
#define  CAN_WORD015_DATA_BYTE_3_4   BIT4
#define  CAN_WORD015_DATA_BYTE_3_5   BIT5
#define  CAN_WORD015_DATA_BYTE_3_6   BIT6
#define  CAN_WORD015_DATA_BYTE_3_7   BIT7

#define  CAN_WORD015_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 2 of Rx/Tx frame.
#define  CAN_WORD015_DATA_BYTE_2_0   BIT8
#define  CAN_WORD015_DATA_BYTE_2_1   BIT9
#define  CAN_WORD015_DATA_BYTE_2_2   BIT10
#define  CAN_WORD015_DATA_BYTE_2_3   BIT11
#define  CAN_WORD015_DATA_BYTE_2_4   BIT12
#define  CAN_WORD015_DATA_BYTE_2_5   BIT13
#define  CAN_WORD015_DATA_BYTE_2_6   BIT14
#define  CAN_WORD015_DATA_BYTE_2_7   BIT15

#define  CAN_WORD015_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 1 of Rx/Tx frame.
#define  CAN_WORD015_DATA_BYTE_1_0   BIT16
#define  CAN_WORD015_DATA_BYTE_1_1   BIT17
#define  CAN_WORD015_DATA_BYTE_1_2   BIT18
#define  CAN_WORD015_DATA_BYTE_1_3   BIT19
#define  CAN_WORD015_DATA_BYTE_1_4   BIT20
#define  CAN_WORD015_DATA_BYTE_1_5   BIT21
#define  CAN_WORD015_DATA_BYTE_1_6   BIT22
#define  CAN_WORD015_DATA_BYTE_1_7   BIT23

#define  CAN_WORD015_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 0 of Rx/Tx frame.
#define  CAN_WORD015_DATA_BYTE_0_0   BIT24
#define  CAN_WORD015_DATA_BYTE_0_1   BIT25
#define  CAN_WORD015_DATA_BYTE_0_2   BIT26
#define  CAN_WORD015_DATA_BYTE_0_3   BIT27
#define  CAN_WORD015_DATA_BYTE_0_4   BIT28
#define  CAN_WORD015_DATA_BYTE_0_5   BIT29
#define  CAN_WORD015_DATA_BYTE_0_6   BIT30
#define  CAN_WORD015_DATA_BYTE_0_7   BIT31

#define  CAN_WORD115_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data byte 7 of Rx/Tx frame.
#define  CAN_WORD115_DATA_BYTE_7_0   BIT0
#define  CAN_WORD115_DATA_BYTE_7_1   BIT1
#define  CAN_WORD115_DATA_BYTE_7_2   BIT2
#define  CAN_WORD115_DATA_BYTE_7_3   BIT3
#define  CAN_WORD115_DATA_BYTE_7_4   BIT4
#define  CAN_WORD115_DATA_BYTE_7_5   BIT5
#define  CAN_WORD115_DATA_BYTE_7_6   BIT6
#define  CAN_WORD115_DATA_BYTE_7_7   BIT7

#define  CAN_WORD115_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data byte 6 of Rx/Tx frame.
#define  CAN_WORD115_DATA_BYTE_6_0   BIT8
#define  CAN_WORD115_DATA_BYTE_6_1   BIT9
#define  CAN_WORD115_DATA_BYTE_6_2   BIT10
#define  CAN_WORD115_DATA_BYTE_6_3   BIT11
#define  CAN_WORD115_DATA_BYTE_6_4   BIT12
#define  CAN_WORD115_DATA_BYTE_6_5   BIT13
#define  CAN_WORD115_DATA_BYTE_6_6   BIT14
#define  CAN_WORD115_DATA_BYTE_6_7   BIT15

#define  CAN_WORD115_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Data byte 5 of Rx/Tx frame.
#define  CAN_WORD115_DATA_BYTE_5_0   BIT16
#define  CAN_WORD115_DATA_BYTE_5_1   BIT17
#define  CAN_WORD115_DATA_BYTE_5_2   BIT18
#define  CAN_WORD115_DATA_BYTE_5_3   BIT19
#define  CAN_WORD115_DATA_BYTE_5_4   BIT20
#define  CAN_WORD115_DATA_BYTE_5_5   BIT21
#define  CAN_WORD115_DATA_BYTE_5_6   BIT22
#define  CAN_WORD115_DATA_BYTE_5_7   BIT23

#define  CAN_WORD115_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Data byte 4 of Rx/Tx frame.
#define  CAN_WORD115_DATA_BYTE_4_0   BIT24
#define  CAN_WORD115_DATA_BYTE_4_1   BIT25
#define  CAN_WORD115_DATA_BYTE_4_2   BIT26
#define  CAN_WORD115_DATA_BYTE_4_3   BIT27
#define  CAN_WORD115_DATA_BYTE_4_4   BIT28
#define  CAN_WORD115_DATA_BYTE_4_5   BIT29
#define  CAN_WORD115_DATA_BYTE_4_6   BIT30
#define  CAN_WORD115_DATA_BYTE_4_7   BIT31

#define  CAN_RXIMR0_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR0_MI_0             BIT0
#define  CAN_RXIMR0_MI_1             BIT1
#define  CAN_RXIMR0_MI_2             BIT2
#define  CAN_RXIMR0_MI_3             BIT3
#define  CAN_RXIMR0_MI_4             BIT4
#define  CAN_RXIMR0_MI_5             BIT5
#define  CAN_RXIMR0_MI_6             BIT6
#define  CAN_RXIMR0_MI_7             BIT7
#define  CAN_RXIMR0_MI_8             BIT8
#define  CAN_RXIMR0_MI_9             BIT9
#define  CAN_RXIMR0_MI_10            BIT10
#define  CAN_RXIMR0_MI_11            BIT11
#define  CAN_RXIMR0_MI_12            BIT12
#define  CAN_RXIMR0_MI_13            BIT13
#define  CAN_RXIMR0_MI_14            BIT14
#define  CAN_RXIMR0_MI_15            BIT15
#define  CAN_RXIMR0_MI_16            BIT16
#define  CAN_RXIMR0_MI_17            BIT17
#define  CAN_RXIMR0_MI_18            BIT18
#define  CAN_RXIMR0_MI_19            BIT19
#define  CAN_RXIMR0_MI_20            BIT20
#define  CAN_RXIMR0_MI_21            BIT21
#define  CAN_RXIMR0_MI_22            BIT22
#define  CAN_RXIMR0_MI_23            BIT23
#define  CAN_RXIMR0_MI_24            BIT24
#define  CAN_RXIMR0_MI_25            BIT25
#define  CAN_RXIMR0_MI_26            BIT26
#define  CAN_RXIMR0_MI_27            BIT27
#define  CAN_RXIMR0_MI_28            BIT28
#define  CAN_RXIMR0_MI_29            BIT29
#define  CAN_RXIMR0_MI_30            BIT30
#define  CAN_RXIMR0_MI_31            BIT31

#define  CAN_RXIMR1_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR1_MI_0             BIT0
#define  CAN_RXIMR1_MI_1             BIT1
#define  CAN_RXIMR1_MI_2             BIT2
#define  CAN_RXIMR1_MI_3             BIT3
#define  CAN_RXIMR1_MI_4             BIT4
#define  CAN_RXIMR1_MI_5             BIT5
#define  CAN_RXIMR1_MI_6             BIT6
#define  CAN_RXIMR1_MI_7             BIT7
#define  CAN_RXIMR1_MI_8             BIT8
#define  CAN_RXIMR1_MI_9             BIT9
#define  CAN_RXIMR1_MI_10            BIT10
#define  CAN_RXIMR1_MI_11            BIT11
#define  CAN_RXIMR1_MI_12            BIT12
#define  CAN_RXIMR1_MI_13            BIT13
#define  CAN_RXIMR1_MI_14            BIT14
#define  CAN_RXIMR1_MI_15            BIT15
#define  CAN_RXIMR1_MI_16            BIT16
#define  CAN_RXIMR1_MI_17            BIT17
#define  CAN_RXIMR1_MI_18            BIT18
#define  CAN_RXIMR1_MI_19            BIT19
#define  CAN_RXIMR1_MI_20            BIT20
#define  CAN_RXIMR1_MI_21            BIT21
#define  CAN_RXIMR1_MI_22            BIT22
#define  CAN_RXIMR1_MI_23            BIT23
#define  CAN_RXIMR1_MI_24            BIT24
#define  CAN_RXIMR1_MI_25            BIT25
#define  CAN_RXIMR1_MI_26            BIT26
#define  CAN_RXIMR1_MI_27            BIT27
#define  CAN_RXIMR1_MI_28            BIT28
#define  CAN_RXIMR1_MI_29            BIT29
#define  CAN_RXIMR1_MI_30            BIT30
#define  CAN_RXIMR1_MI_31            BIT31

#define  CAN_RXIMR2_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR2_MI_0             BIT0
#define  CAN_RXIMR2_MI_1             BIT1
#define  CAN_RXIMR2_MI_2             BIT2
#define  CAN_RXIMR2_MI_3             BIT3
#define  CAN_RXIMR2_MI_4             BIT4
#define  CAN_RXIMR2_MI_5             BIT5
#define  CAN_RXIMR2_MI_6             BIT6
#define  CAN_RXIMR2_MI_7             BIT7
#define  CAN_RXIMR2_MI_8             BIT8
#define  CAN_RXIMR2_MI_9             BIT9
#define  CAN_RXIMR2_MI_10            BIT10
#define  CAN_RXIMR2_MI_11            BIT11
#define  CAN_RXIMR2_MI_12            BIT12
#define  CAN_RXIMR2_MI_13            BIT13
#define  CAN_RXIMR2_MI_14            BIT14
#define  CAN_RXIMR2_MI_15            BIT15
#define  CAN_RXIMR2_MI_16            BIT16
#define  CAN_RXIMR2_MI_17            BIT17
#define  CAN_RXIMR2_MI_18            BIT18
#define  CAN_RXIMR2_MI_19            BIT19
#define  CAN_RXIMR2_MI_20            BIT20
#define  CAN_RXIMR2_MI_21            BIT21
#define  CAN_RXIMR2_MI_22            BIT22
#define  CAN_RXIMR2_MI_23            BIT23
#define  CAN_RXIMR2_MI_24            BIT24
#define  CAN_RXIMR2_MI_25            BIT25
#define  CAN_RXIMR2_MI_26            BIT26
#define  CAN_RXIMR2_MI_27            BIT27
#define  CAN_RXIMR2_MI_28            BIT28
#define  CAN_RXIMR2_MI_29            BIT29
#define  CAN_RXIMR2_MI_30            BIT30
#define  CAN_RXIMR2_MI_31            BIT31

#define  CAN_RXIMR3_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR3_MI_0             BIT0
#define  CAN_RXIMR3_MI_1             BIT1
#define  CAN_RXIMR3_MI_2             BIT2
#define  CAN_RXIMR3_MI_3             BIT3
#define  CAN_RXIMR3_MI_4             BIT4
#define  CAN_RXIMR3_MI_5             BIT5
#define  CAN_RXIMR3_MI_6             BIT6
#define  CAN_RXIMR3_MI_7             BIT7
#define  CAN_RXIMR3_MI_8             BIT8
#define  CAN_RXIMR3_MI_9             BIT9
#define  CAN_RXIMR3_MI_10            BIT10
#define  CAN_RXIMR3_MI_11            BIT11
#define  CAN_RXIMR3_MI_12            BIT12
#define  CAN_RXIMR3_MI_13            BIT13
#define  CAN_RXIMR3_MI_14            BIT14
#define  CAN_RXIMR3_MI_15            BIT15
#define  CAN_RXIMR3_MI_16            BIT16
#define  CAN_RXIMR3_MI_17            BIT17
#define  CAN_RXIMR3_MI_18            BIT18
#define  CAN_RXIMR3_MI_19            BIT19
#define  CAN_RXIMR3_MI_20            BIT20
#define  CAN_RXIMR3_MI_21            BIT21
#define  CAN_RXIMR3_MI_22            BIT22
#define  CAN_RXIMR3_MI_23            BIT23
#define  CAN_RXIMR3_MI_24            BIT24
#define  CAN_RXIMR3_MI_25            BIT25
#define  CAN_RXIMR3_MI_26            BIT26
#define  CAN_RXIMR3_MI_27            BIT27
#define  CAN_RXIMR3_MI_28            BIT28
#define  CAN_RXIMR3_MI_29            BIT29
#define  CAN_RXIMR3_MI_30            BIT30
#define  CAN_RXIMR3_MI_31            BIT31

#define  CAN_RXIMR4_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR4_MI_0             BIT0
#define  CAN_RXIMR4_MI_1             BIT1
#define  CAN_RXIMR4_MI_2             BIT2
#define  CAN_RXIMR4_MI_3             BIT3
#define  CAN_RXIMR4_MI_4             BIT4
#define  CAN_RXIMR4_MI_5             BIT5
#define  CAN_RXIMR4_MI_6             BIT6
#define  CAN_RXIMR4_MI_7             BIT7
#define  CAN_RXIMR4_MI_8             BIT8
#define  CAN_RXIMR4_MI_9             BIT9
#define  CAN_RXIMR4_MI_10            BIT10
#define  CAN_RXIMR4_MI_11            BIT11
#define  CAN_RXIMR4_MI_12            BIT12
#define  CAN_RXIMR4_MI_13            BIT13
#define  CAN_RXIMR4_MI_14            BIT14
#define  CAN_RXIMR4_MI_15            BIT15
#define  CAN_RXIMR4_MI_16            BIT16
#define  CAN_RXIMR4_MI_17            BIT17
#define  CAN_RXIMR4_MI_18            BIT18
#define  CAN_RXIMR4_MI_19            BIT19
#define  CAN_RXIMR4_MI_20            BIT20
#define  CAN_RXIMR4_MI_21            BIT21
#define  CAN_RXIMR4_MI_22            BIT22
#define  CAN_RXIMR4_MI_23            BIT23
#define  CAN_RXIMR4_MI_24            BIT24
#define  CAN_RXIMR4_MI_25            BIT25
#define  CAN_RXIMR4_MI_26            BIT26
#define  CAN_RXIMR4_MI_27            BIT27
#define  CAN_RXIMR4_MI_28            BIT28
#define  CAN_RXIMR4_MI_29            BIT29
#define  CAN_RXIMR4_MI_30            BIT30
#define  CAN_RXIMR4_MI_31            BIT31

#define  CAN_RXIMR5_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR5_MI_0             BIT0
#define  CAN_RXIMR5_MI_1             BIT1
#define  CAN_RXIMR5_MI_2             BIT2
#define  CAN_RXIMR5_MI_3             BIT3
#define  CAN_RXIMR5_MI_4             BIT4
#define  CAN_RXIMR5_MI_5             BIT5
#define  CAN_RXIMR5_MI_6             BIT6
#define  CAN_RXIMR5_MI_7             BIT7
#define  CAN_RXIMR5_MI_8             BIT8
#define  CAN_RXIMR5_MI_9             BIT9
#define  CAN_RXIMR5_MI_10            BIT10
#define  CAN_RXIMR5_MI_11            BIT11
#define  CAN_RXIMR5_MI_12            BIT12
#define  CAN_RXIMR5_MI_13            BIT13
#define  CAN_RXIMR5_MI_14            BIT14
#define  CAN_RXIMR5_MI_15            BIT15
#define  CAN_RXIMR5_MI_16            BIT16
#define  CAN_RXIMR5_MI_17            BIT17
#define  CAN_RXIMR5_MI_18            BIT18
#define  CAN_RXIMR5_MI_19            BIT19
#define  CAN_RXIMR5_MI_20            BIT20
#define  CAN_RXIMR5_MI_21            BIT21
#define  CAN_RXIMR5_MI_22            BIT22
#define  CAN_RXIMR5_MI_23            BIT23
#define  CAN_RXIMR5_MI_24            BIT24
#define  CAN_RXIMR5_MI_25            BIT25
#define  CAN_RXIMR5_MI_26            BIT26
#define  CAN_RXIMR5_MI_27            BIT27
#define  CAN_RXIMR5_MI_28            BIT28
#define  CAN_RXIMR5_MI_29            BIT29
#define  CAN_RXIMR5_MI_30            BIT30
#define  CAN_RXIMR5_MI_31            BIT31

#define  CAN_RXIMR6_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR6_MI_0             BIT0
#define  CAN_RXIMR6_MI_1             BIT1
#define  CAN_RXIMR6_MI_2             BIT2
#define  CAN_RXIMR6_MI_3             BIT3
#define  CAN_RXIMR6_MI_4             BIT4
#define  CAN_RXIMR6_MI_5             BIT5
#define  CAN_RXIMR6_MI_6             BIT6
#define  CAN_RXIMR6_MI_7             BIT7
#define  CAN_RXIMR6_MI_8             BIT8
#define  CAN_RXIMR6_MI_9             BIT9
#define  CAN_RXIMR6_MI_10            BIT10
#define  CAN_RXIMR6_MI_11            BIT11
#define  CAN_RXIMR6_MI_12            BIT12
#define  CAN_RXIMR6_MI_13            BIT13
#define  CAN_RXIMR6_MI_14            BIT14
#define  CAN_RXIMR6_MI_15            BIT15
#define  CAN_RXIMR6_MI_16            BIT16
#define  CAN_RXIMR6_MI_17            BIT17
#define  CAN_RXIMR6_MI_18            BIT18
#define  CAN_RXIMR6_MI_19            BIT19
#define  CAN_RXIMR6_MI_20            BIT20
#define  CAN_RXIMR6_MI_21            BIT21
#define  CAN_RXIMR6_MI_22            BIT22
#define  CAN_RXIMR6_MI_23            BIT23
#define  CAN_RXIMR6_MI_24            BIT24
#define  CAN_RXIMR6_MI_25            BIT25
#define  CAN_RXIMR6_MI_26            BIT26
#define  CAN_RXIMR6_MI_27            BIT27
#define  CAN_RXIMR6_MI_28            BIT28
#define  CAN_RXIMR6_MI_29            BIT29
#define  CAN_RXIMR6_MI_30            BIT30
#define  CAN_RXIMR6_MI_31            BIT31

#define  CAN_RXIMR7_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR7_MI_0             BIT0
#define  CAN_RXIMR7_MI_1             BIT1
#define  CAN_RXIMR7_MI_2             BIT2
#define  CAN_RXIMR7_MI_3             BIT3
#define  CAN_RXIMR7_MI_4             BIT4
#define  CAN_RXIMR7_MI_5             BIT5
#define  CAN_RXIMR7_MI_6             BIT6
#define  CAN_RXIMR7_MI_7             BIT7
#define  CAN_RXIMR7_MI_8             BIT8
#define  CAN_RXIMR7_MI_9             BIT9
#define  CAN_RXIMR7_MI_10            BIT10
#define  CAN_RXIMR7_MI_11            BIT11
#define  CAN_RXIMR7_MI_12            BIT12
#define  CAN_RXIMR7_MI_13            BIT13
#define  CAN_RXIMR7_MI_14            BIT14
#define  CAN_RXIMR7_MI_15            BIT15
#define  CAN_RXIMR7_MI_16            BIT16
#define  CAN_RXIMR7_MI_17            BIT17
#define  CAN_RXIMR7_MI_18            BIT18
#define  CAN_RXIMR7_MI_19            BIT19
#define  CAN_RXIMR7_MI_20            BIT20
#define  CAN_RXIMR7_MI_21            BIT21
#define  CAN_RXIMR7_MI_22            BIT22
#define  CAN_RXIMR7_MI_23            BIT23
#define  CAN_RXIMR7_MI_24            BIT24
#define  CAN_RXIMR7_MI_25            BIT25
#define  CAN_RXIMR7_MI_26            BIT26
#define  CAN_RXIMR7_MI_27            BIT27
#define  CAN_RXIMR7_MI_28            BIT28
#define  CAN_RXIMR7_MI_29            BIT29
#define  CAN_RXIMR7_MI_30            BIT30
#define  CAN_RXIMR7_MI_31            BIT31

#define  CAN_RXIMR8_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR8_MI_0             BIT0
#define  CAN_RXIMR8_MI_1             BIT1
#define  CAN_RXIMR8_MI_2             BIT2
#define  CAN_RXIMR8_MI_3             BIT3
#define  CAN_RXIMR8_MI_4             BIT4
#define  CAN_RXIMR8_MI_5             BIT5
#define  CAN_RXIMR8_MI_6             BIT6
#define  CAN_RXIMR8_MI_7             BIT7
#define  CAN_RXIMR8_MI_8             BIT8
#define  CAN_RXIMR8_MI_9             BIT9
#define  CAN_RXIMR8_MI_10            BIT10
#define  CAN_RXIMR8_MI_11            BIT11
#define  CAN_RXIMR8_MI_12            BIT12
#define  CAN_RXIMR8_MI_13            BIT13
#define  CAN_RXIMR8_MI_14            BIT14
#define  CAN_RXIMR8_MI_15            BIT15
#define  CAN_RXIMR8_MI_16            BIT16
#define  CAN_RXIMR8_MI_17            BIT17
#define  CAN_RXIMR8_MI_18            BIT18
#define  CAN_RXIMR8_MI_19            BIT19
#define  CAN_RXIMR8_MI_20            BIT20
#define  CAN_RXIMR8_MI_21            BIT21
#define  CAN_RXIMR8_MI_22            BIT22
#define  CAN_RXIMR8_MI_23            BIT23
#define  CAN_RXIMR8_MI_24            BIT24
#define  CAN_RXIMR8_MI_25            BIT25
#define  CAN_RXIMR8_MI_26            BIT26
#define  CAN_RXIMR8_MI_27            BIT27
#define  CAN_RXIMR8_MI_28            BIT28
#define  CAN_RXIMR8_MI_29            BIT29
#define  CAN_RXIMR8_MI_30            BIT30
#define  CAN_RXIMR8_MI_31            BIT31

#define  CAN_RXIMR9_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR9_MI_0             BIT0
#define  CAN_RXIMR9_MI_1             BIT1
#define  CAN_RXIMR9_MI_2             BIT2
#define  CAN_RXIMR9_MI_3             BIT3
#define  CAN_RXIMR9_MI_4             BIT4
#define  CAN_RXIMR9_MI_5             BIT5
#define  CAN_RXIMR9_MI_6             BIT6
#define  CAN_RXIMR9_MI_7             BIT7
#define  CAN_RXIMR9_MI_8             BIT8
#define  CAN_RXIMR9_MI_9             BIT9
#define  CAN_RXIMR9_MI_10            BIT10
#define  CAN_RXIMR9_MI_11            BIT11
#define  CAN_RXIMR9_MI_12            BIT12
#define  CAN_RXIMR9_MI_13            BIT13
#define  CAN_RXIMR9_MI_14            BIT14
#define  CAN_RXIMR9_MI_15            BIT15
#define  CAN_RXIMR9_MI_16            BIT16
#define  CAN_RXIMR9_MI_17            BIT17
#define  CAN_RXIMR9_MI_18            BIT18
#define  CAN_RXIMR9_MI_19            BIT19
#define  CAN_RXIMR9_MI_20            BIT20
#define  CAN_RXIMR9_MI_21            BIT21
#define  CAN_RXIMR9_MI_22            BIT22
#define  CAN_RXIMR9_MI_23            BIT23
#define  CAN_RXIMR9_MI_24            BIT24
#define  CAN_RXIMR9_MI_25            BIT25
#define  CAN_RXIMR9_MI_26            BIT26
#define  CAN_RXIMR9_MI_27            BIT27
#define  CAN_RXIMR9_MI_28            BIT28
#define  CAN_RXIMR9_MI_29            BIT29
#define  CAN_RXIMR9_MI_30            BIT30
#define  CAN_RXIMR9_MI_31            BIT31

#define  CAN_RXIMR10_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR10_MI_0            BIT0
#define  CAN_RXIMR10_MI_1            BIT1
#define  CAN_RXIMR10_MI_2            BIT2
#define  CAN_RXIMR10_MI_3            BIT3
#define  CAN_RXIMR10_MI_4            BIT4
#define  CAN_RXIMR10_MI_5            BIT5
#define  CAN_RXIMR10_MI_6            BIT6
#define  CAN_RXIMR10_MI_7            BIT7
#define  CAN_RXIMR10_MI_8            BIT8
#define  CAN_RXIMR10_MI_9            BIT9
#define  CAN_RXIMR10_MI_10           BIT10
#define  CAN_RXIMR10_MI_11           BIT11
#define  CAN_RXIMR10_MI_12           BIT12
#define  CAN_RXIMR10_MI_13           BIT13
#define  CAN_RXIMR10_MI_14           BIT14
#define  CAN_RXIMR10_MI_15           BIT15
#define  CAN_RXIMR10_MI_16           BIT16
#define  CAN_RXIMR10_MI_17           BIT17
#define  CAN_RXIMR10_MI_18           BIT18
#define  CAN_RXIMR10_MI_19           BIT19
#define  CAN_RXIMR10_MI_20           BIT20
#define  CAN_RXIMR10_MI_21           BIT21
#define  CAN_RXIMR10_MI_22           BIT22
#define  CAN_RXIMR10_MI_23           BIT23
#define  CAN_RXIMR10_MI_24           BIT24
#define  CAN_RXIMR10_MI_25           BIT25
#define  CAN_RXIMR10_MI_26           BIT26
#define  CAN_RXIMR10_MI_27           BIT27
#define  CAN_RXIMR10_MI_28           BIT28
#define  CAN_RXIMR10_MI_29           BIT29
#define  CAN_RXIMR10_MI_30           BIT30
#define  CAN_RXIMR10_MI_31           BIT31

#define  CAN_RXIMR11_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR11_MI_0            BIT0
#define  CAN_RXIMR11_MI_1            BIT1
#define  CAN_RXIMR11_MI_2            BIT2
#define  CAN_RXIMR11_MI_3            BIT3
#define  CAN_RXIMR11_MI_4            BIT4
#define  CAN_RXIMR11_MI_5            BIT5
#define  CAN_RXIMR11_MI_6            BIT6
#define  CAN_RXIMR11_MI_7            BIT7
#define  CAN_RXIMR11_MI_8            BIT8
#define  CAN_RXIMR11_MI_9            BIT9
#define  CAN_RXIMR11_MI_10           BIT10
#define  CAN_RXIMR11_MI_11           BIT11
#define  CAN_RXIMR11_MI_12           BIT12
#define  CAN_RXIMR11_MI_13           BIT13
#define  CAN_RXIMR11_MI_14           BIT14
#define  CAN_RXIMR11_MI_15           BIT15
#define  CAN_RXIMR11_MI_16           BIT16
#define  CAN_RXIMR11_MI_17           BIT17
#define  CAN_RXIMR11_MI_18           BIT18
#define  CAN_RXIMR11_MI_19           BIT19
#define  CAN_RXIMR11_MI_20           BIT20
#define  CAN_RXIMR11_MI_21           BIT21
#define  CAN_RXIMR11_MI_22           BIT22
#define  CAN_RXIMR11_MI_23           BIT23
#define  CAN_RXIMR11_MI_24           BIT24
#define  CAN_RXIMR11_MI_25           BIT25
#define  CAN_RXIMR11_MI_26           BIT26
#define  CAN_RXIMR11_MI_27           BIT27
#define  CAN_RXIMR11_MI_28           BIT28
#define  CAN_RXIMR11_MI_29           BIT29
#define  CAN_RXIMR11_MI_30           BIT30
#define  CAN_RXIMR11_MI_31           BIT31

#define  CAN_RXIMR12_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR12_MI_0            BIT0
#define  CAN_RXIMR12_MI_1            BIT1
#define  CAN_RXIMR12_MI_2            BIT2
#define  CAN_RXIMR12_MI_3            BIT3
#define  CAN_RXIMR12_MI_4            BIT4
#define  CAN_RXIMR12_MI_5            BIT5
#define  CAN_RXIMR12_MI_6            BIT6
#define  CAN_RXIMR12_MI_7            BIT7
#define  CAN_RXIMR12_MI_8            BIT8
#define  CAN_RXIMR12_MI_9            BIT9
#define  CAN_RXIMR12_MI_10           BIT10
#define  CAN_RXIMR12_MI_11           BIT11
#define  CAN_RXIMR12_MI_12           BIT12
#define  CAN_RXIMR12_MI_13           BIT13
#define  CAN_RXIMR12_MI_14           BIT14
#define  CAN_RXIMR12_MI_15           BIT15
#define  CAN_RXIMR12_MI_16           BIT16
#define  CAN_RXIMR12_MI_17           BIT17
#define  CAN_RXIMR12_MI_18           BIT18
#define  CAN_RXIMR12_MI_19           BIT19
#define  CAN_RXIMR12_MI_20           BIT20
#define  CAN_RXIMR12_MI_21           BIT21
#define  CAN_RXIMR12_MI_22           BIT22
#define  CAN_RXIMR12_MI_23           BIT23
#define  CAN_RXIMR12_MI_24           BIT24
#define  CAN_RXIMR12_MI_25           BIT25
#define  CAN_RXIMR12_MI_26           BIT26
#define  CAN_RXIMR12_MI_27           BIT27
#define  CAN_RXIMR12_MI_28           BIT28
#define  CAN_RXIMR12_MI_29           BIT29
#define  CAN_RXIMR12_MI_30           BIT30
#define  CAN_RXIMR12_MI_31           BIT31

#define  CAN_RXIMR13_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR13_MI_0            BIT0
#define  CAN_RXIMR13_MI_1            BIT1
#define  CAN_RXIMR13_MI_2            BIT2
#define  CAN_RXIMR13_MI_3            BIT3
#define  CAN_RXIMR13_MI_4            BIT4
#define  CAN_RXIMR13_MI_5            BIT5
#define  CAN_RXIMR13_MI_6            BIT6
#define  CAN_RXIMR13_MI_7            BIT7
#define  CAN_RXIMR13_MI_8            BIT8
#define  CAN_RXIMR13_MI_9            BIT9
#define  CAN_RXIMR13_MI_10           BIT10
#define  CAN_RXIMR13_MI_11           BIT11
#define  CAN_RXIMR13_MI_12           BIT12
#define  CAN_RXIMR13_MI_13           BIT13
#define  CAN_RXIMR13_MI_14           BIT14
#define  CAN_RXIMR13_MI_15           BIT15
#define  CAN_RXIMR13_MI_16           BIT16
#define  CAN_RXIMR13_MI_17           BIT17
#define  CAN_RXIMR13_MI_18           BIT18
#define  CAN_RXIMR13_MI_19           BIT19
#define  CAN_RXIMR13_MI_20           BIT20
#define  CAN_RXIMR13_MI_21           BIT21
#define  CAN_RXIMR13_MI_22           BIT22
#define  CAN_RXIMR13_MI_23           BIT23
#define  CAN_RXIMR13_MI_24           BIT24
#define  CAN_RXIMR13_MI_25           BIT25
#define  CAN_RXIMR13_MI_26           BIT26
#define  CAN_RXIMR13_MI_27           BIT27
#define  CAN_RXIMR13_MI_28           BIT28
#define  CAN_RXIMR13_MI_29           BIT29
#define  CAN_RXIMR13_MI_30           BIT30
#define  CAN_RXIMR13_MI_31           BIT31

#define  CAN_RXIMR14_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR14_MI_0            BIT0
#define  CAN_RXIMR14_MI_1            BIT1
#define  CAN_RXIMR14_MI_2            BIT2
#define  CAN_RXIMR14_MI_3            BIT3
#define  CAN_RXIMR14_MI_4            BIT4
#define  CAN_RXIMR14_MI_5            BIT5
#define  CAN_RXIMR14_MI_6            BIT6
#define  CAN_RXIMR14_MI_7            BIT7
#define  CAN_RXIMR14_MI_8            BIT8
#define  CAN_RXIMR14_MI_9            BIT9
#define  CAN_RXIMR14_MI_10           BIT10
#define  CAN_RXIMR14_MI_11           BIT11
#define  CAN_RXIMR14_MI_12           BIT12
#define  CAN_RXIMR14_MI_13           BIT13
#define  CAN_RXIMR14_MI_14           BIT14
#define  CAN_RXIMR14_MI_15           BIT15
#define  CAN_RXIMR14_MI_16           BIT16
#define  CAN_RXIMR14_MI_17           BIT17
#define  CAN_RXIMR14_MI_18           BIT18
#define  CAN_RXIMR14_MI_19           BIT19
#define  CAN_RXIMR14_MI_20           BIT20
#define  CAN_RXIMR14_MI_21           BIT21
#define  CAN_RXIMR14_MI_22           BIT22
#define  CAN_RXIMR14_MI_23           BIT23
#define  CAN_RXIMR14_MI_24           BIT24
#define  CAN_RXIMR14_MI_25           BIT25
#define  CAN_RXIMR14_MI_26           BIT26
#define  CAN_RXIMR14_MI_27           BIT27
#define  CAN_RXIMR14_MI_28           BIT28
#define  CAN_RXIMR14_MI_29           BIT29
#define  CAN_RXIMR14_MI_30           BIT30
#define  CAN_RXIMR14_MI_31           BIT31

#define  CAN_RXIMR15_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Individual Mask Bits
//     0b0 ==> The corresponding bit in the filter is "don't care."
//     0b1 ==> The corresponding bit in the filter is checked.
#define  CAN_RXIMR15_MI_0            BIT0
#define  CAN_RXIMR15_MI_1            BIT1
#define  CAN_RXIMR15_MI_2            BIT2
#define  CAN_RXIMR15_MI_3            BIT3
#define  CAN_RXIMR15_MI_4            BIT4
#define  CAN_RXIMR15_MI_5            BIT5
#define  CAN_RXIMR15_MI_6            BIT6
#define  CAN_RXIMR15_MI_7            BIT7
#define  CAN_RXIMR15_MI_8            BIT8
#define  CAN_RXIMR15_MI_9            BIT9
#define  CAN_RXIMR15_MI_10           BIT10
#define  CAN_RXIMR15_MI_11           BIT11
#define  CAN_RXIMR15_MI_12           BIT12
#define  CAN_RXIMR15_MI_13           BIT13
#define  CAN_RXIMR15_MI_14           BIT14
#define  CAN_RXIMR15_MI_15           BIT15
#define  CAN_RXIMR15_MI_16           BIT16
#define  CAN_RXIMR15_MI_17           BIT17
#define  CAN_RXIMR15_MI_18           BIT18
#define  CAN_RXIMR15_MI_19           BIT19
#define  CAN_RXIMR15_MI_20           BIT20
#define  CAN_RXIMR15_MI_21           BIT21
#define  CAN_RXIMR15_MI_22           BIT22
#define  CAN_RXIMR15_MI_23           BIT23
#define  CAN_RXIMR15_MI_24           BIT24
#define  CAN_RXIMR15_MI_25           BIT25
#define  CAN_RXIMR15_MI_26           BIT26
#define  CAN_RXIMR15_MI_27           BIT27
#define  CAN_RXIMR15_MI_28           BIT28
#define  CAN_RXIMR15_MI_29           BIT29
#define  CAN_RXIMR15_MI_30           BIT30
#define  CAN_RXIMR15_MI_31           BIT31

#define  CMPA_CR0_HYSTCTR            (BIT0|BIT1)
//   Comparator hard block hysteresis control
//     0b00 ==> Level 0
//     0b01 ==> Level 1
//     0b10 ==> Level 2
//     0b11 ==> Level 3
#define  CMPA_CR0_HYSTCTR_0          BIT0
#define  CMPA_CR0_HYSTCTR_1          BIT1

#define  CMPA_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
//   Filter Sample Count
//     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
//     0b001 ==> 1 consecutive sample must agree (comparator output is simply sampled).
//     0b010 ==> 2 consecutive samples must agree.
//     0b011 ==> 3 consecutive samples must agree.
//     0b100 ==> 4 consecutive samples must agree.
//     0b101 ==> 5 consecutive samples must agree.
//     0b110 ==> 6 consecutive samples must agree.
//     0b111 ==> 7 consecutive samples must agree.
#define  CMPA_CR0_FILTER_CNT_0       BIT4
#define  CMPA_CR0_FILTER_CNT_1       BIT5
#define  CMPA_CR0_FILTER_CNT_2       BIT6

#define  CMPA_CR1_EN                 BIT0
//   Comparator Module Enable
//     0b0 ==> Analog Comparator disabled.
//     0b1 ==> Analog Comparator enabled.

#define  CMPA_CR1_OPE                BIT1
//   Comparator Output Pin Enable
//     0b0 ==> The comparator output (CMPO) is not available on the associated CMPO output pin. Instead, the INV bit is driven if the comparator owns the pin (usually a result of properly setting pin mux controls at the SoC level). If the comparator does not own the pin, this bit has no effect.
//     0b1 ==> The comparator output (CMPO) is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the pin, this bit has no effect.

#define  CMPA_CR1_COS                BIT2
//   Comparator Output Select
//     0b0 ==> Set CMPO to equal COUT (filtered comparator output).
//     0b1 ==> Set CMPO to equal COUTA (unfiltered comparator output).

#define  CMPA_CR1_INV                BIT3
//   Comparator INVERT
//     0b0 ==> Does not invert the comparator output.
//     0b1 ==> Inverts the comparator output.

#define  CMPA_CR1_PMODE              BIT4
//   Power Mode Select
//     0b0 ==> Low Speed (LS) comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
//     0b1 ==> High Speed (HS) comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

#define  CMPA_CR1_WE                 BIT6
//   Windowing Enable
//     0b0 ==> Windowing mode not selected.
//     0b1 ==> Windowing mode selected.

#define  CMPA_CR1_SE                 BIT7
//   Sample Enable
//     0b0 ==> Sampling mode not selected.
//     0b1 ==> Sampling mode selected.

#define  CMPA_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Filter Sample Period
#define  CMPA_FPR_FILT_PER_0         BIT0
#define  CMPA_FPR_FILT_PER_1         BIT1
#define  CMPA_FPR_FILT_PER_2         BIT2
#define  CMPA_FPR_FILT_PER_3         BIT3
#define  CMPA_FPR_FILT_PER_4         BIT4
#define  CMPA_FPR_FILT_PER_5         BIT5
#define  CMPA_FPR_FILT_PER_6         BIT6
#define  CMPA_FPR_FILT_PER_7         BIT7

#define  CMPA_SCR_COUT               BIT0
//   Analog Comparator Output

#define  CMPA_SCR_CFF                BIT1
//   Analog Comparator Flag Falling
//     0b0 ==> Falling edge on COUT has not been detected.
//     0b1 ==> Falling edge on COUT has occurred.

#define  CMPA_SCR_CFR                BIT2
//   Analog Comparator Flag Rising
//     0b0 ==> Rising edge on COUT has not been detected.
//     0b1 ==> Rising edge on COUT has occurred.

#define  CMPA_SCR_IEF                BIT3
//   Comparator Interrupt Enable Falling
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  CMPA_SCR_IER                BIT4
//   Comparator Interrupt Enable Rising
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  CMPA_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   DAC Output Voltage Select
#define  CMPA_DACCR_VOSEL_0          BIT0
#define  CMPA_DACCR_VOSEL_1          BIT1
#define  CMPA_DACCR_VOSEL_2          BIT2
#define  CMPA_DACCR_VOSEL_3          BIT3
#define  CMPA_DACCR_VOSEL_4          BIT4
#define  CMPA_DACCR_VOSEL_5          BIT5

#define  CMPA_DACCR_VRSEL            BIT6
//   Supply Voltage Reference Source Select
//     0b0 ==> Vin1 is selected as resistor ladder network supply reference Vin.
//     0b1 ==> Vin2 is selected as resistor ladder network supply reference Vin.

#define  CMPA_DACCR_DACEN            BIT7
//   DAC Enable
//     0b0 ==> DAC is disabled.
//     0b1 ==> DAC is enabled.

#define  CMPA_MUXCR_MSEL             (BIT0|BIT1|BIT2)
//   Minus Input MUX Control
//     0b000 ==> IN0
//     0b001 ==> IN1
//     0b010 ==> IN2
//     0b011 ==> IN3
//     0b100 ==> IN4
//     0b101 ==> IN5
//     0b110 ==> IN6
//     0b111 ==> IN7
#define  CMPA_MUXCR_MSEL_0           BIT0
#define  CMPA_MUXCR_MSEL_1           BIT1
#define  CMPA_MUXCR_MSEL_2           BIT2

#define  CMPA_MUXCR_PSEL             (BIT3|BIT4|BIT5)
//   Plus Input MUX Control
//     0b000 ==> IN0
//     0b001 ==> IN1
//     0b010 ==> IN2
//     0b011 ==> IN3
//     0b100 ==> IN4
//     0b101 ==> IN5
//     0b110 ==> IN6
//     0b111 ==> IN7
#define  CMPA_MUXCR_PSEL_0           BIT3
#define  CMPA_MUXCR_PSEL_1           BIT4
#define  CMPA_MUXCR_PSEL_2           BIT5

#define  CMPB_CR0_HYSTCTR            (BIT0|BIT1)
//   Comparator hard block hysteresis control
//     0b00 ==> Level 0
//     0b01 ==> Level 1
//     0b10 ==> Level 2
//     0b11 ==> Level 3
#define  CMPB_CR0_HYSTCTR_0          BIT0
#define  CMPB_CR0_HYSTCTR_1          BIT1

#define  CMPB_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
//   Filter Sample Count
//     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
//     0b001 ==> 1 consecutive sample must agree (comparator output is simply sampled).
//     0b010 ==> 2 consecutive samples must agree.
//     0b011 ==> 3 consecutive samples must agree.
//     0b100 ==> 4 consecutive samples must agree.
//     0b101 ==> 5 consecutive samples must agree.
//     0b110 ==> 6 consecutive samples must agree.
//     0b111 ==> 7 consecutive samples must agree.
#define  CMPB_CR0_FILTER_CNT_0       BIT4
#define  CMPB_CR0_FILTER_CNT_1       BIT5
#define  CMPB_CR0_FILTER_CNT_2       BIT6

#define  CMPB_CR1_EN                 BIT0
//   Comparator Module Enable
//     0b0 ==> Analog Comparator disabled.
//     0b1 ==> Analog Comparator enabled.

#define  CMPB_CR1_OPE                BIT1
//   Comparator Output Pin Enable
//     0b0 ==> The comparator output (CMPO) is not available on the associated CMPO output pin. Instead, the INV bit is driven if the comparator owns the pin (usually a result of properly setting pin mux controls at the SoC level). If the comparator does not own the pin, this bit has no effect.
//     0b1 ==> The comparator output (CMPO) is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the pin, this bit has no effect.

#define  CMPB_CR1_COS                BIT2
//   Comparator Output Select
//     0b0 ==> Set CMPO to equal COUT (filtered comparator output).
//     0b1 ==> Set CMPO to equal COUTA (unfiltered comparator output).

#define  CMPB_CR1_INV                BIT3
//   Comparator INVERT
//     0b0 ==> Does not invert the comparator output.
//     0b1 ==> Inverts the comparator output.

#define  CMPB_CR1_PMODE              BIT4
//   Power Mode Select
//     0b0 ==> Low Speed (LS) comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
//     0b1 ==> High Speed (HS) comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

#define  CMPB_CR1_WE                 BIT6
//   Windowing Enable
//     0b0 ==> Windowing mode not selected.
//     0b1 ==> Windowing mode selected.

#define  CMPB_CR1_SE                 BIT7
//   Sample Enable
//     0b0 ==> Sampling mode not selected.
//     0b1 ==> Sampling mode selected.

#define  CMPB_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Filter Sample Period
#define  CMPB_FPR_FILT_PER_0         BIT0
#define  CMPB_FPR_FILT_PER_1         BIT1
#define  CMPB_FPR_FILT_PER_2         BIT2
#define  CMPB_FPR_FILT_PER_3         BIT3
#define  CMPB_FPR_FILT_PER_4         BIT4
#define  CMPB_FPR_FILT_PER_5         BIT5
#define  CMPB_FPR_FILT_PER_6         BIT6
#define  CMPB_FPR_FILT_PER_7         BIT7

#define  CMPB_SCR_COUT               BIT0
//   Analog Comparator Output

#define  CMPB_SCR_CFF                BIT1
//   Analog Comparator Flag Falling
//     0b0 ==> Falling edge on COUT has not been detected.
//     0b1 ==> Falling edge on COUT has occurred.

#define  CMPB_SCR_CFR                BIT2
//   Analog Comparator Flag Rising
//     0b0 ==> Rising edge on COUT has not been detected.
//     0b1 ==> Rising edge on COUT has occurred.

#define  CMPB_SCR_IEF                BIT3
//   Comparator Interrupt Enable Falling
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  CMPB_SCR_IER                BIT4
//   Comparator Interrupt Enable Rising
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  CMPB_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   DAC Output Voltage Select
#define  CMPB_DACCR_VOSEL_0          BIT0
#define  CMPB_DACCR_VOSEL_1          BIT1
#define  CMPB_DACCR_VOSEL_2          BIT2
#define  CMPB_DACCR_VOSEL_3          BIT3
#define  CMPB_DACCR_VOSEL_4          BIT4
#define  CMPB_DACCR_VOSEL_5          BIT5

#define  CMPB_DACCR_VRSEL            BIT6
//   Supply Voltage Reference Source Select
//     0b0 ==> Vin1 is selected as resistor ladder network supply reference Vin.
//     0b1 ==> Vin2 is selected as resistor ladder network supply reference Vin.

#define  CMPB_DACCR_DACEN            BIT7
//   DAC Enable
//     0b0 ==> DAC is disabled.
//     0b1 ==> DAC is enabled.

#define  CMPB_MUXCR_MSEL             (BIT0|BIT1|BIT2)
//   Minus Input MUX Control
//     0b000 ==> IN0
//     0b001 ==> IN1
//     0b010 ==> IN2
//     0b011 ==> IN3
//     0b100 ==> IN4
//     0b101 ==> IN5
//     0b110 ==> IN6
//     0b111 ==> IN7
#define  CMPB_MUXCR_MSEL_0           BIT0
#define  CMPB_MUXCR_MSEL_1           BIT1
#define  CMPB_MUXCR_MSEL_2           BIT2

#define  CMPB_MUXCR_PSEL             (BIT3|BIT4|BIT5)
//   Plus Input MUX Control
//     0b000 ==> IN0
//     0b001 ==> IN1
//     0b010 ==> IN2
//     0b011 ==> IN3
//     0b100 ==> IN4
//     0b101 ==> IN5
//     0b110 ==> IN6
//     0b111 ==> IN7
#define  CMPB_MUXCR_PSEL_0           BIT3
#define  CMPB_MUXCR_PSEL_1           BIT4
#define  CMPB_MUXCR_PSEL_2           BIT5

#define  CMPC_CR0_HYSTCTR            (BIT0|BIT1)
//   Comparator hard block hysteresis control
//     0b00 ==> Level 0
//     0b01 ==> Level 1
//     0b10 ==> Level 2
//     0b11 ==> Level 3
#define  CMPC_CR0_HYSTCTR_0          BIT0
#define  CMPC_CR0_HYSTCTR_1          BIT1

#define  CMPC_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
//   Filter Sample Count
//     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
//     0b001 ==> 1 consecutive sample must agree (comparator output is simply sampled).
//     0b010 ==> 2 consecutive samples must agree.
//     0b011 ==> 3 consecutive samples must agree.
//     0b100 ==> 4 consecutive samples must agree.
//     0b101 ==> 5 consecutive samples must agree.
//     0b110 ==> 6 consecutive samples must agree.
//     0b111 ==> 7 consecutive samples must agree.
#define  CMPC_CR0_FILTER_CNT_0       BIT4
#define  CMPC_CR0_FILTER_CNT_1       BIT5
#define  CMPC_CR0_FILTER_CNT_2       BIT6

#define  CMPC_CR1_EN                 BIT0
//   Comparator Module Enable
//     0b0 ==> Analog Comparator disabled.
//     0b1 ==> Analog Comparator enabled.

#define  CMPC_CR1_OPE                BIT1
//   Comparator Output Pin Enable
//     0b0 ==> The comparator output (CMPO) is not available on the associated CMPO output pin. Instead, the INV bit is driven if the comparator owns the pin (usually a result of properly setting pin mux controls at the SoC level). If the comparator does not own the pin, this bit has no effect.
//     0b1 ==> The comparator output (CMPO) is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the pin, this bit has no effect.

#define  CMPC_CR1_COS                BIT2
//   Comparator Output Select
//     0b0 ==> Set CMPO to equal COUT (filtered comparator output).
//     0b1 ==> Set CMPO to equal COUTA (unfiltered comparator output).

#define  CMPC_CR1_INV                BIT3
//   Comparator INVERT
//     0b0 ==> Does not invert the comparator output.
//     0b1 ==> Inverts the comparator output.

#define  CMPC_CR1_PMODE              BIT4
//   Power Mode Select
//     0b0 ==> Low Speed (LS) comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
//     0b1 ==> High Speed (HS) comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

#define  CMPC_CR1_WE                 BIT6
//   Windowing Enable
//     0b0 ==> Windowing mode not selected.
//     0b1 ==> Windowing mode selected.

#define  CMPC_CR1_SE                 BIT7
//   Sample Enable
//     0b0 ==> Sampling mode not selected.
//     0b1 ==> Sampling mode selected.

#define  CMPC_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Filter Sample Period
#define  CMPC_FPR_FILT_PER_0         BIT0
#define  CMPC_FPR_FILT_PER_1         BIT1
#define  CMPC_FPR_FILT_PER_2         BIT2
#define  CMPC_FPR_FILT_PER_3         BIT3
#define  CMPC_FPR_FILT_PER_4         BIT4
#define  CMPC_FPR_FILT_PER_5         BIT5
#define  CMPC_FPR_FILT_PER_6         BIT6
#define  CMPC_FPR_FILT_PER_7         BIT7

#define  CMPC_SCR_COUT               BIT0
//   Analog Comparator Output

#define  CMPC_SCR_CFF                BIT1
//   Analog Comparator Flag Falling
//     0b0 ==> Falling edge on COUT has not been detected.
//     0b1 ==> Falling edge on COUT has occurred.

#define  CMPC_SCR_CFR                BIT2
//   Analog Comparator Flag Rising
//     0b0 ==> Rising edge on COUT has not been detected.
//     0b1 ==> Rising edge on COUT has occurred.

#define  CMPC_SCR_IEF                BIT3
//   Comparator Interrupt Enable Falling
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  CMPC_SCR_IER                BIT4
//   Comparator Interrupt Enable Rising
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  CMPC_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   DAC Output Voltage Select
#define  CMPC_DACCR_VOSEL_0          BIT0
#define  CMPC_DACCR_VOSEL_1          BIT1
#define  CMPC_DACCR_VOSEL_2          BIT2
#define  CMPC_DACCR_VOSEL_3          BIT3
#define  CMPC_DACCR_VOSEL_4          BIT4
#define  CMPC_DACCR_VOSEL_5          BIT5

#define  CMPC_DACCR_VRSEL            BIT6
//   Supply Voltage Reference Source Select
//     0b0 ==> Vin1 is selected as resistor ladder network supply reference Vin.
//     0b1 ==> Vin2 is selected as resistor ladder network supply reference Vin.

#define  CMPC_DACCR_DACEN            BIT7
//   DAC Enable
//     0b0 ==> DAC is disabled.
//     0b1 ==> DAC is enabled.

#define  CMPC_MUXCR_MSEL             (BIT0|BIT1|BIT2)
//   Minus Input MUX Control
//     0b000 ==> IN0
//     0b001 ==> IN1
//     0b010 ==> IN2
//     0b011 ==> IN3
//     0b100 ==> IN4
//     0b101 ==> IN5
//     0b110 ==> IN6
//     0b111 ==> IN7
#define  CMPC_MUXCR_MSEL_0           BIT0
#define  CMPC_MUXCR_MSEL_1           BIT1
#define  CMPC_MUXCR_MSEL_2           BIT2

#define  CMPC_MUXCR_PSEL             (BIT3|BIT4|BIT5)
//   Plus Input MUX Control
//     0b000 ==> IN0
//     0b001 ==> IN1
//     0b010 ==> IN2
//     0b011 ==> IN3
//     0b100 ==> IN4
//     0b101 ==> IN5
//     0b110 ==> IN6
//     0b111 ==> IN7
#define  CMPC_MUXCR_PSEL_0           BIT3
#define  CMPC_MUXCR_PSEL_1           BIT4
#define  CMPC_MUXCR_PSEL_2           BIT5

#define  CMPD_CR0_HYSTCTR            (BIT0|BIT1)
//   Comparator hard block hysteresis control
//     0b00 ==> Level 0
//     0b01 ==> Level 1
//     0b10 ==> Level 2
//     0b11 ==> Level 3
#define  CMPD_CR0_HYSTCTR_0          BIT0
#define  CMPD_CR0_HYSTCTR_1          BIT1

#define  CMPD_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
//   Filter Sample Count
//     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
//     0b001 ==> 1 consecutive sample must agree (comparator output is simply sampled).
//     0b010 ==> 2 consecutive samples must agree.
//     0b011 ==> 3 consecutive samples must agree.
//     0b100 ==> 4 consecutive samples must agree.
//     0b101 ==> 5 consecutive samples must agree.
//     0b110 ==> 6 consecutive samples must agree.
//     0b111 ==> 7 consecutive samples must agree.
#define  CMPD_CR0_FILTER_CNT_0       BIT4
#define  CMPD_CR0_FILTER_CNT_1       BIT5
#define  CMPD_CR0_FILTER_CNT_2       BIT6

#define  CMPD_CR1_EN                 BIT0
//   Comparator Module Enable
//     0b0 ==> Analog Comparator disabled.
//     0b1 ==> Analog Comparator enabled.

#define  CMPD_CR1_OPE                BIT1
//   Comparator Output Pin Enable
//     0b0 ==> The comparator output (CMPO) is not available on the associated CMPO output pin. Instead, the INV bit is driven if the comparator owns the pin (usually a result of properly setting pin mux controls at the SoC level). If the comparator does not own the pin, this bit has no effect.
//     0b1 ==> The comparator output (CMPO) is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the pin, this bit has no effect.

#define  CMPD_CR1_COS                BIT2
//   Comparator Output Select
//     0b0 ==> Set CMPO to equal COUT (filtered comparator output).
//     0b1 ==> Set CMPO to equal COUTA (unfiltered comparator output).

#define  CMPD_CR1_INV                BIT3
//   Comparator INVERT
//     0b0 ==> Does not invert the comparator output.
//     0b1 ==> Inverts the comparator output.

#define  CMPD_CR1_PMODE              BIT4
//   Power Mode Select
//     0b0 ==> Low Speed (LS) comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
//     0b1 ==> High Speed (HS) comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

#define  CMPD_CR1_WE                 BIT6
//   Windowing Enable
//     0b0 ==> Windowing mode not selected.
//     0b1 ==> Windowing mode selected.

#define  CMPD_CR1_SE                 BIT7
//   Sample Enable
//     0b0 ==> Sampling mode not selected.
//     0b1 ==> Sampling mode selected.

#define  CMPD_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Filter Sample Period
#define  CMPD_FPR_FILT_PER_0         BIT0
#define  CMPD_FPR_FILT_PER_1         BIT1
#define  CMPD_FPR_FILT_PER_2         BIT2
#define  CMPD_FPR_FILT_PER_3         BIT3
#define  CMPD_FPR_FILT_PER_4         BIT4
#define  CMPD_FPR_FILT_PER_5         BIT5
#define  CMPD_FPR_FILT_PER_6         BIT6
#define  CMPD_FPR_FILT_PER_7         BIT7

#define  CMPD_SCR_COUT               BIT0
//   Analog Comparator Output

#define  CMPD_SCR_CFF                BIT1
//   Analog Comparator Flag Falling
//     0b0 ==> Falling edge on COUT has not been detected.
//     0b1 ==> Falling edge on COUT has occurred.

#define  CMPD_SCR_CFR                BIT2
//   Analog Comparator Flag Rising
//     0b0 ==> Rising edge on COUT has not been detected.
//     0b1 ==> Rising edge on COUT has occurred.

#define  CMPD_SCR_IEF                BIT3
//   Comparator Interrupt Enable Falling
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  CMPD_SCR_IER                BIT4
//   Comparator Interrupt Enable Rising
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  CMPD_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   DAC Output Voltage Select
#define  CMPD_DACCR_VOSEL_0          BIT0
#define  CMPD_DACCR_VOSEL_1          BIT1
#define  CMPD_DACCR_VOSEL_2          BIT2
#define  CMPD_DACCR_VOSEL_3          BIT3
#define  CMPD_DACCR_VOSEL_4          BIT4
#define  CMPD_DACCR_VOSEL_5          BIT5

#define  CMPD_DACCR_VRSEL            BIT6
//   Supply Voltage Reference Source Select
//     0b0 ==> Vin1 is selected as resistor ladder network supply reference Vin.
//     0b1 ==> Vin2 is selected as resistor ladder network supply reference Vin.

#define  CMPD_DACCR_DACEN            BIT7
//   DAC Enable
//     0b0 ==> DAC is disabled.
//     0b1 ==> DAC is enabled.

#define  CMPD_MUXCR_MSEL             (BIT0|BIT1|BIT2)
//   Minus Input MUX Control
//     0b000 ==> IN0
//     0b001 ==> IN1
//     0b010 ==> IN2
//     0b011 ==> IN3
//     0b100 ==> IN4
//     0b101 ==> IN5
//     0b110 ==> IN6
//     0b111 ==> IN7
#define  CMPD_MUXCR_MSEL_0           BIT0
#define  CMPD_MUXCR_MSEL_1           BIT1
#define  CMPD_MUXCR_MSEL_2           BIT2

#define  CMPD_MUXCR_PSEL             (BIT3|BIT4|BIT5)
//   Plus Input MUX Control
//     0b000 ==> IN0
//     0b001 ==> IN1
//     0b010 ==> IN2
//     0b011 ==> IN3
//     0b100 ==> IN4
//     0b101 ==> IN5
//     0b110 ==> IN6
//     0b111 ==> IN7
#define  CMPD_MUXCR_PSEL_0           BIT3
#define  CMPD_MUXCR_PSEL_1           BIT4
#define  CMPD_MUXCR_PSEL_2           BIT5

#define  COP_CTRL_CWP                BIT0
//   COP Write Protect
//     0b0 ==> The CTRL, INTVAL and TOUT registers are readable and writable. (default)
//     0b1 ==> The CTRL, INTVAL and TOUT registers are read-only.

#define  COP_CTRL_CEN                BIT1
//   COP Enable
//     0b0 ==> COP counter is disabled.
//     0b1 ==> COP counter is enabled. (default)

#define  COP_CTRL_CWEN               BIT2
//   COP Wait Mode Enable
//     0b0 ==> COP counter stops in wait mode. (default)
//     0b1 ==> COP counter runs in wait mode if CEN is set to one.

#define  COP_CTRL_CSEN               BIT3
//   COP Stop Mode Enable
//     0b0 ==> COP counter stops in stop mode. (default)
//     0b1 ==> COP counter runs in stop mode if CEN is set to one.

#define  COP_CTRL_CLOREN             BIT4
//   COP Loss of Reference Enable
//     0b0 ==> COP loss of reference counter is disabled. (default)
//     0b1 ==> COP loss of reference counter is enabled.

#define  COP_CTRL_CLKSEL             (BIT5|BIT6)
//   Clock Source Select
//     0b00 ==> Relaxation oscillator output (ROSC) is used to clock the counter (default)
//     0b01 ==> Crystal oscillator output (COSC) is used to clock the counter
//     0b10 ==> IP bus clock is used to clock the counter Do not select the IP bus clock to clock the counter if the application requires the COP to wake the device from stop mode.
//     0b11 ==> Low speed oscillator is used to clock the counter
#define  COP_CTRL_CLKSEL_0           BIT5
#define  COP_CTRL_CLKSEL_1           BIT6

#define  COP_CTRL_INTEN              BIT7
//   Interrupt Enable
//     0b0 ==> COP interrupt is disabled. (default)
//     0b1 ==> COP interrupt is enabled.

#define  COP_CTRL_PSS                (BIT8|BIT9)
//   Prescaler Select
//     0b00 ==> No division
//     0b01 ==> Divide by 16
//     0b10 ==> Divide by 256
//     0b11 ==> Divide by 1024
#define  COP_CTRL_PSS_0              BIT8
#define  COP_CTRL_PSS_1              BIT9

#define  COP_TOUT_TIMEOUT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   COP Timeout Period
#define  COP_TOUT_TIMEOUT_0          BIT0
#define  COP_TOUT_TIMEOUT_1          BIT1
#define  COP_TOUT_TIMEOUT_2          BIT2
#define  COP_TOUT_TIMEOUT_3          BIT3
#define  COP_TOUT_TIMEOUT_4          BIT4
#define  COP_TOUT_TIMEOUT_5          BIT5
#define  COP_TOUT_TIMEOUT_6          BIT6
#define  COP_TOUT_TIMEOUT_7          BIT7
#define  COP_TOUT_TIMEOUT_8          BIT8
#define  COP_TOUT_TIMEOUT_9          BIT9
#define  COP_TOUT_TIMEOUT_10         BIT10
#define  COP_TOUT_TIMEOUT_11         BIT11
#define  COP_TOUT_TIMEOUT_12         BIT12
#define  COP_TOUT_TIMEOUT_13         BIT13
#define  COP_TOUT_TIMEOUT_14         BIT14
#define  COP_TOUT_TIMEOUT_15         BIT15

#define  COP_CNTR_COUNT_SERVICE      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   COP Count/Service
#define  COP_CNTR_COUNT_SERVICE_0    BIT0
#define  COP_CNTR_COUNT_SERVICE_1    BIT1
#define  COP_CNTR_COUNT_SERVICE_2    BIT2
#define  COP_CNTR_COUNT_SERVICE_3    BIT3
#define  COP_CNTR_COUNT_SERVICE_4    BIT4
#define  COP_CNTR_COUNT_SERVICE_5    BIT5
#define  COP_CNTR_COUNT_SERVICE_6    BIT6
#define  COP_CNTR_COUNT_SERVICE_7    BIT7
#define  COP_CNTR_COUNT_SERVICE_8    BIT8
#define  COP_CNTR_COUNT_SERVICE_9    BIT9
#define  COP_CNTR_COUNT_SERVICE_10   BIT10
#define  COP_CNTR_COUNT_SERVICE_11   BIT11
#define  COP_CNTR_COUNT_SERVICE_12   BIT12
#define  COP_CNTR_COUNT_SERVICE_13   BIT13
#define  COP_CNTR_COUNT_SERVICE_14   BIT14
#define  COP_CNTR_COUNT_SERVICE_15   BIT15

#define  COP_INTVAL_INTERRUPT_VALUE  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   COP Interrupt Value
#define  COP_INTVAL_INTERRUPT_VALUE_0 BIT0
#define  COP_INTVAL_INTERRUPT_VALUE_1 BIT1
#define  COP_INTVAL_INTERRUPT_VALUE_2 BIT2
#define  COP_INTVAL_INTERRUPT_VALUE_3 BIT3
#define  COP_INTVAL_INTERRUPT_VALUE_4 BIT4
#define  COP_INTVAL_INTERRUPT_VALUE_5 BIT5
#define  COP_INTVAL_INTERRUPT_VALUE_6 BIT6
#define  COP_INTVAL_INTERRUPT_VALUE_7 BIT7
#define  COP_INTVAL_INTERRUPT_VALUE_8 BIT8
#define  COP_INTVAL_INTERRUPT_VALUE_9 BIT9
#define  COP_INTVAL_INTERRUPT_VALUE_10 BIT10
#define  COP_INTVAL_INTERRUPT_VALUE_11 BIT11
#define  COP_INTVAL_INTERRUPT_VALUE_12 BIT12
#define  COP_INTVAL_INTERRUPT_VALUE_13 BIT13
#define  COP_INTVAL_INTERRUPT_VALUE_14 BIT14
#define  COP_INTVAL_INTERRUPT_VALUE_15 BIT15

#define  CRC_CRC_LL                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   CRC Low Lower Byte
#define  CRC_CRC_LL_0                BIT0
#define  CRC_CRC_LL_1                BIT1
#define  CRC_CRC_LL_2                BIT2
#define  CRC_CRC_LL_3                BIT3
#define  CRC_CRC_LL_4                BIT4
#define  CRC_CRC_LL_5                BIT5
#define  CRC_CRC_LL_6                BIT6
#define  CRC_CRC_LL_7                BIT7

#define  CRC_CRC_LU                  (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   CRC Low Upper Byte
#define  CRC_CRC_LU_0                BIT8
#define  CRC_CRC_LU_1                BIT9
#define  CRC_CRC_LU_2                BIT10
#define  CRC_CRC_LU_3                BIT11
#define  CRC_CRC_LU_4                BIT12
#define  CRC_CRC_LU_5                BIT13
#define  CRC_CRC_LU_6                BIT14
#define  CRC_CRC_LU_7                BIT15

#define  CRC_CRC_HL                  (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   CRC High Lower Byte
#define  CRC_CRC_HL_0                BIT16
#define  CRC_CRC_HL_1                BIT17
#define  CRC_CRC_HL_2                BIT18
#define  CRC_CRC_HL_3                BIT19
#define  CRC_CRC_HL_4                BIT20
#define  CRC_CRC_HL_5                BIT21
#define  CRC_CRC_HL_6                BIT22
#define  CRC_CRC_HL_7                BIT23

#define  CRC_CRC_HU                  (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   CRC High Upper Byte
#define  CRC_CRC_HU_0                BIT24
#define  CRC_CRC_HU_1                BIT25
#define  CRC_CRC_HU_2                BIT26
#define  CRC_CRC_HU_3                BIT27
#define  CRC_CRC_HU_4                BIT28
#define  CRC_CRC_HU_5                BIT29
#define  CRC_CRC_HU_6                BIT30
#define  CRC_CRC_HU_7                BIT31

#define  CRC_GPOLY_LOW               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Low polynominal half-word
#define  CRC_GPOLY_LOW_0             BIT0
#define  CRC_GPOLY_LOW_1             BIT1
#define  CRC_GPOLY_LOW_2             BIT2
#define  CRC_GPOLY_LOW_3             BIT3
#define  CRC_GPOLY_LOW_4             BIT4
#define  CRC_GPOLY_LOW_5             BIT5
#define  CRC_GPOLY_LOW_6             BIT6
#define  CRC_GPOLY_LOW_7             BIT7
#define  CRC_GPOLY_LOW_8             BIT8
#define  CRC_GPOLY_LOW_9             BIT9
#define  CRC_GPOLY_LOW_10            BIT10
#define  CRC_GPOLY_LOW_11            BIT11
#define  CRC_GPOLY_LOW_12            BIT12
#define  CRC_GPOLY_LOW_13            BIT13
#define  CRC_GPOLY_LOW_14            BIT14
#define  CRC_GPOLY_LOW_15            BIT15

#define  CRC_GPOLY_HIGH              (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   High polynominal half-word
#define  CRC_GPOLY_HIGH_0            BIT16
#define  CRC_GPOLY_HIGH_1            BIT17
#define  CRC_GPOLY_HIGH_2            BIT18
#define  CRC_GPOLY_HIGH_3            BIT19
#define  CRC_GPOLY_HIGH_4            BIT20
#define  CRC_GPOLY_HIGH_5            BIT21
#define  CRC_GPOLY_HIGH_6            BIT22
#define  CRC_GPOLY_HIGH_7            BIT23
#define  CRC_GPOLY_HIGH_8            BIT24
#define  CRC_GPOLY_HIGH_9            BIT25
#define  CRC_GPOLY_HIGH_10           BIT26
#define  CRC_GPOLY_HIGH_11           BIT27
#define  CRC_GPOLY_HIGH_12           BIT28
#define  CRC_GPOLY_HIGH_13           BIT29
#define  CRC_GPOLY_HIGH_14           BIT30
#define  CRC_GPOLY_HIGH_15           BIT31

#define  CRC_CTRL_TCRC               BIT24
//     0b0 ==> 16-bit CRC protocol.
//     0b1 ==> 32-bit CRC protocol.

#define  CRC_CTRL_WAS                BIT25
//   Write CRC data register as seed
//     0b0 ==> Writes to the CRC data register are data values.
//     0b1 ==> Writes to the CRC data register are seed values.

#define  CRC_CTRL_FXOR               BIT26
//   Complement Read of CRC data register
//     0b0 ==> No XOR on reading.
//     0b1 ==> Invert or complement the read value of the CRC data register.

#define  CRC_CTRL_TOTR               (BIT28|BIT29)
//   Type of Transpose for Read
//     0b00 ==> No transposition.
//     0b01 ==> Bits in bytes are transposed; bytes are not transposed.
//     0b10 ==> Both bits in bytes and bytes are transposed.
//     0b11 ==> Only bytes are transposed; no bits in a byte are transposed.
#define  CRC_CTRL_TOTR_0             BIT28
#define  CRC_CTRL_TOTR_1             BIT29

#define  CRC_CTRL_TOT                (BIT30|BIT31)
//   Type of Transpose for Writes
//     0b00 ==> No transposition.
//     0b01 ==> Bits in bytes are transposed; bytes are not transposed.
//     0b10 ==> Both bits in bytes and bytes are transposed.
//     0b11 ==> Only bytes are transposed; no bits in a byte are transposed.
#define  CRC_CTRL_TOT_0              BIT30
#define  CRC_CTRL_TOT_1              BIT31

#define  DAC_CTRL0_PDN               BIT0
//   Power Down
//     0b0 ==> DAC is operational.
//     0b1 ==> DAC is powered down. (default)

#define  DAC_CTRL0_FORMAT            BIT1
//   Data Format
//     0b0 ==> Data words are right justified. (default)
//     0b1 ==> Data words are left justified.

#define  DAC_CTRL0_SYNC_EN           BIT2
//   Sync Enable
//     0b0 ==> Asynchronous mode. Data written to the buffered data register is presented to DAC inputs on the next clock cycle.
//     0b1 ==> Synchronous mode. Rising edge of SYNC_IN updates data in the buffered data register presented to the DAC input.

#define  DAC_CTRL0_AUTO              BIT3
//   Automatic Mode
//     0b0 ==> Normal mode. Automatic waveform generation disabled.
//     0b1 ==> Automatic waveform generation enabled.

#define  DAC_CTRL0_DOWN              BIT4
//   Enable Down Counting
//     0b0 ==> Down counting disabled.
//     0b1 ==> Down counting enabled.

#define  DAC_CTRL0_UP                BIT5
//   Enable Up Counting
//     0b0 ==> Up counting disabled.
//     0b1 ==> Up counting enabled.

#define  DAC_CTRL0_HSLS              BIT6
//   High/Low Speed
//     0b0 ==> High speed mode (default)
//     0b1 ==> Low speed mode

#define  DAC_CTRL0_DMA_EN            BIT7
//   Enable DMA Support
//     0b0 ==> DMA support disabled (default)
//     0b1 ==> DMA support enabled

#define  DAC_CTRL0_WTMK_LVL          (BIT8|BIT9)
//   Watermark Level
//     0b00 ==> Watermark value is 0
//     0b01 ==> Watermark value is 2 (default)
//     0b10 ==> Watermark value is 4
//     0b11 ==> Watermark value is 6
#define  DAC_CTRL0_WTMK_LVL_0        BIT8
#define  DAC_CTRL0_WTMK_LVL_1        BIT9

#define  DAC_CTRL0_FILT_EN           BIT12
//   Glitch Filter Enable
//     0b0 ==> Filter disabled.
//     0b1 ==> Filter enabled.

#define  DAC_DATAREG_DATA            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
//   DAC data (right justified)
#define  DAC_DATAREG_DATA_0          BIT0
#define  DAC_DATAREG_DATA_1          BIT1
#define  DAC_DATAREG_DATA_2          BIT2
#define  DAC_DATAREG_DATA_3          BIT3
#define  DAC_DATAREG_DATA_4          BIT4
#define  DAC_DATAREG_DATA_5          BIT5
#define  DAC_DATAREG_DATA_6          BIT6
#define  DAC_DATAREG_DATA_7          BIT7
#define  DAC_DATAREG_DATA_8          BIT8
#define  DAC_DATAREG_DATA_9          BIT9
#define  DAC_DATAREG_DATA_10         BIT10
#define  DAC_DATAREG_DATA_11         BIT11

#define  DAC_STEPVAL_STEP            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
//   STEP size (right justified)
#define  DAC_STEPVAL_STEP_0          BIT0
#define  DAC_STEPVAL_STEP_1          BIT1
#define  DAC_STEPVAL_STEP_2          BIT2
#define  DAC_STEPVAL_STEP_3          BIT3
#define  DAC_STEPVAL_STEP_4          BIT4
#define  DAC_STEPVAL_STEP_5          BIT5
#define  DAC_STEPVAL_STEP_6          BIT6
#define  DAC_STEPVAL_STEP_7          BIT7
#define  DAC_STEPVAL_STEP_8          BIT8
#define  DAC_STEPVAL_STEP_9          BIT9
#define  DAC_STEPVAL_STEP_10         BIT10
#define  DAC_STEPVAL_STEP_11         BIT11

#define  DAC_MINVAL_MINVAL           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
//   Minimum value (right justified)
#define  DAC_MINVAL_MINVAL_0         BIT0
#define  DAC_MINVAL_MINVAL_1         BIT1
#define  DAC_MINVAL_MINVAL_2         BIT2
#define  DAC_MINVAL_MINVAL_3         BIT3
#define  DAC_MINVAL_MINVAL_4         BIT4
#define  DAC_MINVAL_MINVAL_5         BIT5
#define  DAC_MINVAL_MINVAL_6         BIT6
#define  DAC_MINVAL_MINVAL_7         BIT7
#define  DAC_MINVAL_MINVAL_8         BIT8
#define  DAC_MINVAL_MINVAL_9         BIT9
#define  DAC_MINVAL_MINVAL_10        BIT10
#define  DAC_MINVAL_MINVAL_11        BIT11

#define  DAC_MAXVAL_MAXVAL           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
//   Maximum value (right justified)
#define  DAC_MAXVAL_MAXVAL_0         BIT0
#define  DAC_MAXVAL_MAXVAL_1         BIT1
#define  DAC_MAXVAL_MAXVAL_2         BIT2
#define  DAC_MAXVAL_MAXVAL_3         BIT3
#define  DAC_MAXVAL_MAXVAL_4         BIT4
#define  DAC_MAXVAL_MAXVAL_5         BIT5
#define  DAC_MAXVAL_MAXVAL_6         BIT6
#define  DAC_MAXVAL_MAXVAL_7         BIT7
#define  DAC_MAXVAL_MAXVAL_8         BIT8
#define  DAC_MAXVAL_MAXVAL_9         BIT9
#define  DAC_MAXVAL_MAXVAL_10        BIT10
#define  DAC_MAXVAL_MAXVAL_11        BIT11

#define  DAC_STATUS_EMPTY            BIT0
//   Indicates empty status of FIFO
//     0b0 ==> FIFO is not empty.
//     0b1 ==> FIFO is empty (on reset).

#define  DAC_STATUS_FULL             BIT1
//   Indicates full status of FIFO
//     0b0 ==> FIFO is not full (on reset).
//     0b1 ==> FIFO is full.

#define  DAC_CTRL1_FILT_CNT          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   Glitch Filter Count
#define  DAC_CTRL1_FILT_CNT_0        BIT0
#define  DAC_CTRL1_FILT_CNT_1        BIT1
#define  DAC_CTRL1_FILT_CNT_2        BIT2
#define  DAC_CTRL1_FILT_CNT_3        BIT3
#define  DAC_CTRL1_FILT_CNT_4        BIT4
#define  DAC_CTRL1_FILT_CNT_5        BIT5

#define  DMA_REQC_DMAC3              (BIT0|BIT1|BIT2|BIT3)
//   DMA channel 3
//     0b0000 ==> Select request 0 as the source
//     0b0001 ==> Select request 1 as the source
//     0b0010 ==> Select request 2 as the source
//     0b0011 ==> Select request 3 as the source
//     0b0100 ==> Select request 4 as the source
//     0b0101 ==> Select request 5 as the source
//     0b0110 ==> Select request 6 as the source
//     0b0111 ==> Select request 7 as the source
//     0b1000 ==> Select request 8 as the source
//     0b1001 ==> Select request 9 as the source
//     0b1010 ==> Select request 10 as the source
//     0b1011 ==> Select request 11 as the source
//     0b1100 ==> Select request 12 as the source
//     0b1101 ==> Select request 13 as the source
//     0b1110 ==> Select request 14 as the source
//     0b1111 ==> Select request 15 as the source
#define  DMA_REQC_DMAC3_0            BIT0
#define  DMA_REQC_DMAC3_1            BIT1
#define  DMA_REQC_DMAC3_2            BIT2
#define  DMA_REQC_DMAC3_3            BIT3

#define  DMA_REQC_CFSM3              BIT7
//   Clear state machine control 3
//     0b0 ==> No effect
//     0b1 ==> Clear state machine for DMA channel 3

#define  DMA_REQC_DMAC2              (BIT8|BIT9|BIT10|BIT11)
//   DMA channel 2
//     0b0000 ==> Select request 0 as the source
//     0b0001 ==> Select request 1 as the source
//     0b0010 ==> Select request 2 as the source
//     0b0011 ==> Select request 3 as the source
//     0b0100 ==> Select request 4 as the source
//     0b0101 ==> Select request 5 as the source
//     0b0110 ==> Select request 6 as the source
//     0b0111 ==> Select request 7 as the source
//     0b1000 ==> Select request 8 as the source
//     0b1001 ==> Select request 9 as the source
//     0b1010 ==> Select request 10 as the source
//     0b1011 ==> Select request 11 as the source
//     0b1100 ==> Select request 12 as the source
//     0b1101 ==> Select request 13 as the source
//     0b1110 ==> Select request 14 as the source
//     0b1111 ==> Select request 15 as the source
#define  DMA_REQC_DMAC2_0            BIT8
#define  DMA_REQC_DMAC2_1            BIT9
#define  DMA_REQC_DMAC2_2            BIT10
#define  DMA_REQC_DMAC2_3            BIT11

#define  DMA_REQC_CFSM2              BIT15
//   Clear state machine control 2
//     0b0 ==> No effect
//     0b1 ==> Clear state machine for DMA channel 2

#define  DMA_REQC_DMAC1              (BIT16|BIT17|BIT18|BIT19)
//   DMA channel 1
//     0b0000 ==> Select request 0 as the source
//     0b0001 ==> Select request 1 as the source
//     0b0010 ==> Select request 2 as the source
//     0b0011 ==> Select request 3 as the source
//     0b0100 ==> Select request 4 as the source
//     0b0101 ==> Select request 5 as the source
//     0b0110 ==> Select request 6 as the source
//     0b0111 ==> Select request 7 as the source
//     0b1000 ==> Select request 8 as the source
//     0b1001 ==> Select request 9 as the source
//     0b1010 ==> Select request 10 as the source
//     0b1011 ==> Select request 11 as the source
//     0b1100 ==> Select request 12 as the source
//     0b1101 ==> Select request 13 as the source
//     0b1110 ==> Select request 14 as the source
//     0b1111 ==> Select request 15 as the source
#define  DMA_REQC_DMAC1_0            BIT16
#define  DMA_REQC_DMAC1_1            BIT17
#define  DMA_REQC_DMAC1_2            BIT18
#define  DMA_REQC_DMAC1_3            BIT19

#define  DMA_REQC_CFSM1              BIT23
//   Clear state machine control 1
//     0b0 ==> No effect
//     0b1 ==> Clear state machine for DMA channel 1

#define  DMA_REQC_DMAC0              (BIT24|BIT25|BIT26|BIT27)
//   DMA channel 0
//     0b0000 ==> Select request 0 as the source
//     0b0001 ==> Select request 1 as the source
//     0b0010 ==> Select request 2 as the source
//     0b0011 ==> Select request 3 as the source
//     0b0100 ==> Select request 4 as the source
//     0b0101 ==> Select request 5 as the source
//     0b0110 ==> Select request 6 as the source
//     0b0111 ==> Select request 7 as the source
//     0b1000 ==> Select request 8 as the source
//     0b1001 ==> Select request 9 as the source
//     0b1010 ==> Select request 10 as the source
//     0b1011 ==> Select request 11 as the source
//     0b1100 ==> Select request 12 as the source
//     0b1101 ==> Select request 13 as the source
//     0b1110 ==> Select request 14 as the source
//     0b1111 ==> Select request 15 as the source
#define  DMA_REQC_DMAC0_0            BIT24
#define  DMA_REQC_DMAC0_1            BIT25
#define  DMA_REQC_DMAC0_2            BIT26
#define  DMA_REQC_DMAC0_3            BIT27

#define  DMA_REQC_CFSM0              BIT31
//   Clear state machine control 0
//     0b0 ==> No effect
//     0b1 ==> Clear state machine for DMA channel 0

#define  DMA_SAR0_SAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
#define  DMA_SAR0_SAR_0              BIT0
#define  DMA_SAR0_SAR_1              BIT1
#define  DMA_SAR0_SAR_2              BIT2
#define  DMA_SAR0_SAR_3              BIT3
#define  DMA_SAR0_SAR_4              BIT4
#define  DMA_SAR0_SAR_5              BIT5
#define  DMA_SAR0_SAR_6              BIT6
#define  DMA_SAR0_SAR_7              BIT7
#define  DMA_SAR0_SAR_8              BIT8
#define  DMA_SAR0_SAR_9              BIT9
#define  DMA_SAR0_SAR_10             BIT10
#define  DMA_SAR0_SAR_11             BIT11
#define  DMA_SAR0_SAR_12             BIT12
#define  DMA_SAR0_SAR_13             BIT13
#define  DMA_SAR0_SAR_14             BIT14
#define  DMA_SAR0_SAR_15             BIT15
#define  DMA_SAR0_SAR_16             BIT16
#define  DMA_SAR0_SAR_17             BIT17
#define  DMA_SAR0_SAR_18             BIT18
#define  DMA_SAR0_SAR_19             BIT19
#define  DMA_SAR0_SAR_20             BIT20
#define  DMA_SAR0_SAR_21             BIT21
#define  DMA_SAR0_SAR_22             BIT22
#define  DMA_SAR0_SAR_23             BIT23
#define  DMA_SAR0_SAR_24             BIT24
#define  DMA_SAR0_SAR_25             BIT25
#define  DMA_SAR0_SAR_26             BIT26
#define  DMA_SAR0_SAR_27             BIT27
#define  DMA_SAR0_SAR_28             BIT28
#define  DMA_SAR0_SAR_29             BIT29
#define  DMA_SAR0_SAR_30             BIT30
#define  DMA_SAR0_SAR_31             BIT31

#define  DMA_DAR0_DAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
#define  DMA_DAR0_DAR_0              BIT0
#define  DMA_DAR0_DAR_1              BIT1
#define  DMA_DAR0_DAR_2              BIT2
#define  DMA_DAR0_DAR_3              BIT3
#define  DMA_DAR0_DAR_4              BIT4
#define  DMA_DAR0_DAR_5              BIT5
#define  DMA_DAR0_DAR_6              BIT6
#define  DMA_DAR0_DAR_7              BIT7
#define  DMA_DAR0_DAR_8              BIT8
#define  DMA_DAR0_DAR_9              BIT9
#define  DMA_DAR0_DAR_10             BIT10
#define  DMA_DAR0_DAR_11             BIT11
#define  DMA_DAR0_DAR_12             BIT12
#define  DMA_DAR0_DAR_13             BIT13
#define  DMA_DAR0_DAR_14             BIT14
#define  DMA_DAR0_DAR_15             BIT15
#define  DMA_DAR0_DAR_16             BIT16
#define  DMA_DAR0_DAR_17             BIT17
#define  DMA_DAR0_DAR_18             BIT18
#define  DMA_DAR0_DAR_19             BIT19
#define  DMA_DAR0_DAR_20             BIT20
#define  DMA_DAR0_DAR_21             BIT21
#define  DMA_DAR0_DAR_22             BIT22
#define  DMA_DAR0_DAR_23             BIT23
#define  DMA_DAR0_DAR_24             BIT24
#define  DMA_DAR0_DAR_25             BIT25
#define  DMA_DAR0_DAR_26             BIT26
#define  DMA_DAR0_DAR_27             BIT27
#define  DMA_DAR0_DAR_28             BIT28
#define  DMA_DAR0_DAR_29             BIT29
#define  DMA_DAR0_DAR_30             BIT30
#define  DMA_DAR0_DAR_31             BIT31

#define  DMA_DSR_BCR0_BCR            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
#define  DMA_DSR_BCR0_BCR_0          BIT0
#define  DMA_DSR_BCR0_BCR_1          BIT1
#define  DMA_DSR_BCR0_BCR_2          BIT2
#define  DMA_DSR_BCR0_BCR_3          BIT3
#define  DMA_DSR_BCR0_BCR_4          BIT4
#define  DMA_DSR_BCR0_BCR_5          BIT5
#define  DMA_DSR_BCR0_BCR_6          BIT6
#define  DMA_DSR_BCR0_BCR_7          BIT7
#define  DMA_DSR_BCR0_BCR_8          BIT8
#define  DMA_DSR_BCR0_BCR_9          BIT9
#define  DMA_DSR_BCR0_BCR_10         BIT10
#define  DMA_DSR_BCR0_BCR_11         BIT11
#define  DMA_DSR_BCR0_BCR_12         BIT12
#define  DMA_DSR_BCR0_BCR_13         BIT13
#define  DMA_DSR_BCR0_BCR_14         BIT14
#define  DMA_DSR_BCR0_BCR_15         BIT15
#define  DMA_DSR_BCR0_BCR_16         BIT16
#define  DMA_DSR_BCR0_BCR_17         BIT17
#define  DMA_DSR_BCR0_BCR_18         BIT18
#define  DMA_DSR_BCR0_BCR_19         BIT19
#define  DMA_DSR_BCR0_BCR_20         BIT20
#define  DMA_DSR_BCR0_BCR_21         BIT21
#define  DMA_DSR_BCR0_BCR_22         BIT22
#define  DMA_DSR_BCR0_BCR_23         BIT23

#define  DMA_DSR_BCR0_DONE           BIT24
//   Transactions done
//     0b0 ==> DMA transfer is not yet complete. Writing a 0 has no effect.
//     0b1 ==> DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.

#define  DMA_DSR_BCR0_BSY            BIT25
//   Busy
//     0b0 ==> DMA channel is inactive. Cleared when the DMA has finished the last transaction.
//     0b1 ==> BSY is set the first time the channel is enabled after a transfer is initiated.

#define  DMA_DSR_BCR0_REQ            BIT26
//   Request
//     0b0 ==> No request is pending or the channel is currently active. Cleared when the channel is selected.
//     0b1 ==> The DMA channel has a transfer remaining and the channel is not selected.

#define  DMA_DSR_BCR0_BED            BIT28
//   Bus error on destination
//     0b0 ==> No bus error occurred.
//     0b1 ==> The DMA channel terminated with a bus error during the write portion of a transfer.

#define  DMA_DSR_BCR0_BES            BIT29
//   Bus error on source
//     0b0 ==> No bus error occurred.
//     0b1 ==> The DMA channel terminated with a bus error during the read portion of a transfer.

#define  DMA_DSR_BCR0_CE             BIT30
//   Configuration error
//     0b0 ==> No configuration error exists.
//     0b1 ==> A configuration error has occurred.

#define  DMA_DCR0_LCH2               (BIT0|BIT1)
//   Link channel 2
//     0b00 ==> DMA Channel 0
//     0b01 ==> DMA Channel 1
//     0b10 ==> DMA Channel 2
//     0b11 ==> DMA Channel 3
#define  DMA_DCR0_LCH2_0             BIT0
#define  DMA_DCR0_LCH2_1             BIT1

#define  DMA_DCR0_LCH1               (BIT2|BIT3)
//   Link channel 1
//     0b00 ==> DMA Channel 0
//     0b01 ==> DMA Channel 1
//     0b10 ==> DMA Channel 2
//     0b11 ==> DMA Channel 3
#define  DMA_DCR0_LCH1_0             BIT2
#define  DMA_DCR0_LCH1_1             BIT3

#define  DMA_DCR0_LINKCC             (BIT4|BIT5)
//   Link channel control
//     0b00 ==> No channel-to-channel linking
//     0b01 ==> Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to zero
//     0b10 ==> Perform a link to channel LCH1 after each cycle-steal transfer
//     0b11 ==> Perform a link to channel LCH1 after the BCR decrements to zero
#define  DMA_DCR0_LINKCC_0           BIT4
#define  DMA_DCR0_LINKCC_1           BIT5

#define  DMA_DCR0_D_REQ              BIT7
//   Disable request
//     0b0 ==> ERQ bit is not affected.
//     0b1 ==> ERQ bit is cleared when the BCR is exhausted.

#define  DMA_DCR0_DMOD               (BIT8|BIT9|BIT10|BIT11)
//   Destination address modulo
//     0b0000 ==> Buffer disabled
//     0b0001 ==> Circular buffer size is 16 bytes
//     0b0010 ==> Circular buffer size is 32 bytes
//     0b0011 ==> Circular buffer size is 64 bytes
//     0b0100 ==> Circular buffer size is 128 bytes
//     0b0101 ==> Circular buffer size is 256 bytes
//     0b0110 ==> Circular buffer size is 512 bytes
//     0b0111 ==> Circular buffer size is 1 KB
//     0b1000 ==> Circular buffer size is 2 KB
//     0b1001 ==> Circular buffer size is 4 KB
//     0b1010 ==> Circular buffer size is 8 KB
//     0b1011 ==> Circular buffer size is 16 KB
//     0b1100 ==> Circular buffer size is 32 KB
//     0b1101 ==> Circular buffer size is 64 KB
//     0b1110 ==> Circular buffer size is 128 KB
//     0b1111 ==> Circular buffer size is 256 KB
#define  DMA_DCR0_DMOD_0             BIT8
#define  DMA_DCR0_DMOD_1             BIT9
#define  DMA_DCR0_DMOD_2             BIT10
#define  DMA_DCR0_DMOD_3             BIT11

#define  DMA_DCR0_SMOD               (BIT12|BIT13|BIT14|BIT15)
//   Source address modulo
//     0b0000 ==> Buffer disabled
//     0b0001 ==> Circular buffer size is 16 bytes
//     0b0010 ==> Circular buffer size is 32 bytes
//     0b0011 ==> Circular buffer size is 64 bytes
//     0b0100 ==> Circular buffer size is 128 bytes
//     0b0101 ==> Circular buffer size is 256 bytes
//     0b0110 ==> Circular buffer size is 512 bytes
//     0b0111 ==> Circular buffer size is 1 KB
//     0b1000 ==> Circular buffer size is 2 KB
//     0b1001 ==> Circular buffer size is 4 KB
//     0b1010 ==> Circular buffer size is 8 KB
//     0b1011 ==> Circular buffer size is 16 KB
//     0b1100 ==> Circular buffer size is 32 KB
//     0b1101 ==> Circular buffer size is 64 KB
//     0b1110 ==> Circular buffer size is 128 KB
//     0b1111 ==> Circular buffer size is 256 KB
#define  DMA_DCR0_SMOD_0             BIT12
#define  DMA_DCR0_SMOD_1             BIT13
#define  DMA_DCR0_SMOD_2             BIT14
#define  DMA_DCR0_SMOD_3             BIT15

#define  DMA_DCR0_START              BIT16
//   Start transfer
//     0b0 ==> DMA inactive
//     0b1 ==> The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.

#define  DMA_DCR0_DSIZE              (BIT17|BIT18)
//   Destination size
//     0b00 ==> Longword
//     0b01 ==> Byte
//     0b10 ==> Word
//     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
#define  DMA_DCR0_DSIZE_0            BIT17
#define  DMA_DCR0_DSIZE_1            BIT18

#define  DMA_DCR0_DINC               BIT19
//   Destination increment
//     0b0 ==> No change to the DAR after a successful transfer.
//     0b1 ==> The DAR increments by 1, 2, 4 depending upon the size of the transfer.

#define  DMA_DCR0_SSIZE              (BIT20|BIT21)
//   Source size
//     0b00 ==> Longword
//     0b01 ==> Byte
//     0b10 ==> Word
//     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
#define  DMA_DCR0_SSIZE_0            BIT20
#define  DMA_DCR0_SSIZE_1            BIT21

#define  DMA_DCR0_SINC               BIT22
//   Source increment
//     0b0 ==> No change to SAR after a successful transfer.
//     0b1 ==> The SAR increments by 1, 2, 4 as determined by the transfer size.

#define  DMA_DCR0_AA                 BIT28
//   Auto-align
//     0b0 ==> Auto-align disabled
//     0b1 ==> If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.

#define  DMA_DCR0_CS                 BIT29
//   Cycle steal
//     0b0 ==> DMA continuously makes read/write transfers until the BCR decrements to 0.
//     0b1 ==> Forces a single read/write transfer per request.

#define  DMA_DCR0_ERQ                BIT30
//   Enable peripheral request
//     0b0 ==> Peripheral request is ignored.
//     0b1 ==> Enables peripheral request, defined by the appropriate REQC[DMACn] field, to initiate transfer. A software-initiated request (setting the START bit) is always enabled.

#define  DMA_DCR0_EINT               BIT31
//   Enable interrupt on completion of transfer
//     0b0 ==> No interrupt is generated.
//     0b1 ==> Interrupt signal is enabled.

#define  DMA_SAR1_SAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
#define  DMA_SAR1_SAR_0              BIT0
#define  DMA_SAR1_SAR_1              BIT1
#define  DMA_SAR1_SAR_2              BIT2
#define  DMA_SAR1_SAR_3              BIT3
#define  DMA_SAR1_SAR_4              BIT4
#define  DMA_SAR1_SAR_5              BIT5
#define  DMA_SAR1_SAR_6              BIT6
#define  DMA_SAR1_SAR_7              BIT7
#define  DMA_SAR1_SAR_8              BIT8
#define  DMA_SAR1_SAR_9              BIT9
#define  DMA_SAR1_SAR_10             BIT10
#define  DMA_SAR1_SAR_11             BIT11
#define  DMA_SAR1_SAR_12             BIT12
#define  DMA_SAR1_SAR_13             BIT13
#define  DMA_SAR1_SAR_14             BIT14
#define  DMA_SAR1_SAR_15             BIT15
#define  DMA_SAR1_SAR_16             BIT16
#define  DMA_SAR1_SAR_17             BIT17
#define  DMA_SAR1_SAR_18             BIT18
#define  DMA_SAR1_SAR_19             BIT19
#define  DMA_SAR1_SAR_20             BIT20
#define  DMA_SAR1_SAR_21             BIT21
#define  DMA_SAR1_SAR_22             BIT22
#define  DMA_SAR1_SAR_23             BIT23
#define  DMA_SAR1_SAR_24             BIT24
#define  DMA_SAR1_SAR_25             BIT25
#define  DMA_SAR1_SAR_26             BIT26
#define  DMA_SAR1_SAR_27             BIT27
#define  DMA_SAR1_SAR_28             BIT28
#define  DMA_SAR1_SAR_29             BIT29
#define  DMA_SAR1_SAR_30             BIT30
#define  DMA_SAR1_SAR_31             BIT31

#define  DMA_DAR1_DAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
#define  DMA_DAR1_DAR_0              BIT0
#define  DMA_DAR1_DAR_1              BIT1
#define  DMA_DAR1_DAR_2              BIT2
#define  DMA_DAR1_DAR_3              BIT3
#define  DMA_DAR1_DAR_4              BIT4
#define  DMA_DAR1_DAR_5              BIT5
#define  DMA_DAR1_DAR_6              BIT6
#define  DMA_DAR1_DAR_7              BIT7
#define  DMA_DAR1_DAR_8              BIT8
#define  DMA_DAR1_DAR_9              BIT9
#define  DMA_DAR1_DAR_10             BIT10
#define  DMA_DAR1_DAR_11             BIT11
#define  DMA_DAR1_DAR_12             BIT12
#define  DMA_DAR1_DAR_13             BIT13
#define  DMA_DAR1_DAR_14             BIT14
#define  DMA_DAR1_DAR_15             BIT15
#define  DMA_DAR1_DAR_16             BIT16
#define  DMA_DAR1_DAR_17             BIT17
#define  DMA_DAR1_DAR_18             BIT18
#define  DMA_DAR1_DAR_19             BIT19
#define  DMA_DAR1_DAR_20             BIT20
#define  DMA_DAR1_DAR_21             BIT21
#define  DMA_DAR1_DAR_22             BIT22
#define  DMA_DAR1_DAR_23             BIT23
#define  DMA_DAR1_DAR_24             BIT24
#define  DMA_DAR1_DAR_25             BIT25
#define  DMA_DAR1_DAR_26             BIT26
#define  DMA_DAR1_DAR_27             BIT27
#define  DMA_DAR1_DAR_28             BIT28
#define  DMA_DAR1_DAR_29             BIT29
#define  DMA_DAR1_DAR_30             BIT30
#define  DMA_DAR1_DAR_31             BIT31

#define  DMA_DSR_BCR1_BCR            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
#define  DMA_DSR_BCR1_BCR_0          BIT0
#define  DMA_DSR_BCR1_BCR_1          BIT1
#define  DMA_DSR_BCR1_BCR_2          BIT2
#define  DMA_DSR_BCR1_BCR_3          BIT3
#define  DMA_DSR_BCR1_BCR_4          BIT4
#define  DMA_DSR_BCR1_BCR_5          BIT5
#define  DMA_DSR_BCR1_BCR_6          BIT6
#define  DMA_DSR_BCR1_BCR_7          BIT7
#define  DMA_DSR_BCR1_BCR_8          BIT8
#define  DMA_DSR_BCR1_BCR_9          BIT9
#define  DMA_DSR_BCR1_BCR_10         BIT10
#define  DMA_DSR_BCR1_BCR_11         BIT11
#define  DMA_DSR_BCR1_BCR_12         BIT12
#define  DMA_DSR_BCR1_BCR_13         BIT13
#define  DMA_DSR_BCR1_BCR_14         BIT14
#define  DMA_DSR_BCR1_BCR_15         BIT15
#define  DMA_DSR_BCR1_BCR_16         BIT16
#define  DMA_DSR_BCR1_BCR_17         BIT17
#define  DMA_DSR_BCR1_BCR_18         BIT18
#define  DMA_DSR_BCR1_BCR_19         BIT19
#define  DMA_DSR_BCR1_BCR_20         BIT20
#define  DMA_DSR_BCR1_BCR_21         BIT21
#define  DMA_DSR_BCR1_BCR_22         BIT22
#define  DMA_DSR_BCR1_BCR_23         BIT23

#define  DMA_DSR_BCR1_DONE           BIT24
//   Transactions done
//     0b0 ==> DMA transfer is not yet complete. Writing a 0 has no effect.
//     0b1 ==> DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.

#define  DMA_DSR_BCR1_BSY            BIT25
//   Busy
//     0b0 ==> DMA channel is inactive. Cleared when the DMA has finished the last transaction.
//     0b1 ==> BSY is set the first time the channel is enabled after a transfer is initiated.

#define  DMA_DSR_BCR1_REQ            BIT26
//   Request
//     0b0 ==> No request is pending or the channel is currently active. Cleared when the channel is selected.
//     0b1 ==> The DMA channel has a transfer remaining and the channel is not selected.

#define  DMA_DSR_BCR1_BED            BIT28
//   Bus error on destination
//     0b0 ==> No bus error occurred.
//     0b1 ==> The DMA channel terminated with a bus error during the write portion of a transfer.

#define  DMA_DSR_BCR1_BES            BIT29
//   Bus error on source
//     0b0 ==> No bus error occurred.
//     0b1 ==> The DMA channel terminated with a bus error during the read portion of a transfer.

#define  DMA_DSR_BCR1_CE             BIT30
//   Configuration error
//     0b0 ==> No configuration error exists.
//     0b1 ==> A configuration error has occurred.

#define  DMA_DCR1_LCH2               (BIT0|BIT1)
//   Link channel 2
//     0b00 ==> DMA Channel 0
//     0b01 ==> DMA Channel 1
//     0b10 ==> DMA Channel 2
//     0b11 ==> DMA Channel 3
#define  DMA_DCR1_LCH2_0             BIT0
#define  DMA_DCR1_LCH2_1             BIT1

#define  DMA_DCR1_LCH1               (BIT2|BIT3)
//   Link channel 1
//     0b00 ==> DMA Channel 0
//     0b01 ==> DMA Channel 1
//     0b10 ==> DMA Channel 2
//     0b11 ==> DMA Channel 3
#define  DMA_DCR1_LCH1_0             BIT2
#define  DMA_DCR1_LCH1_1             BIT3

#define  DMA_DCR1_LINKCC             (BIT4|BIT5)
//   Link channel control
//     0b00 ==> No channel-to-channel linking
//     0b01 ==> Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to zero
//     0b10 ==> Perform a link to channel LCH1 after each cycle-steal transfer
//     0b11 ==> Perform a link to channel LCH1 after the BCR decrements to zero
#define  DMA_DCR1_LINKCC_0           BIT4
#define  DMA_DCR1_LINKCC_1           BIT5

#define  DMA_DCR1_D_REQ              BIT7
//   Disable request
//     0b0 ==> ERQ bit is not affected.
//     0b1 ==> ERQ bit is cleared when the BCR is exhausted.

#define  DMA_DCR1_DMOD               (BIT8|BIT9|BIT10|BIT11)
//   Destination address modulo
//     0b0000 ==> Buffer disabled
//     0b0001 ==> Circular buffer size is 16 bytes
//     0b0010 ==> Circular buffer size is 32 bytes
//     0b0011 ==> Circular buffer size is 64 bytes
//     0b0100 ==> Circular buffer size is 128 bytes
//     0b0101 ==> Circular buffer size is 256 bytes
//     0b0110 ==> Circular buffer size is 512 bytes
//     0b0111 ==> Circular buffer size is 1 KB
//     0b1000 ==> Circular buffer size is 2 KB
//     0b1001 ==> Circular buffer size is 4 KB
//     0b1010 ==> Circular buffer size is 8 KB
//     0b1011 ==> Circular buffer size is 16 KB
//     0b1100 ==> Circular buffer size is 32 KB
//     0b1101 ==> Circular buffer size is 64 KB
//     0b1110 ==> Circular buffer size is 128 KB
//     0b1111 ==> Circular buffer size is 256 KB
#define  DMA_DCR1_DMOD_0             BIT8
#define  DMA_DCR1_DMOD_1             BIT9
#define  DMA_DCR1_DMOD_2             BIT10
#define  DMA_DCR1_DMOD_3             BIT11

#define  DMA_DCR1_SMOD               (BIT12|BIT13|BIT14|BIT15)
//   Source address modulo
//     0b0000 ==> Buffer disabled
//     0b0001 ==> Circular buffer size is 16 bytes
//     0b0010 ==> Circular buffer size is 32 bytes
//     0b0011 ==> Circular buffer size is 64 bytes
//     0b0100 ==> Circular buffer size is 128 bytes
//     0b0101 ==> Circular buffer size is 256 bytes
//     0b0110 ==> Circular buffer size is 512 bytes
//     0b0111 ==> Circular buffer size is 1 KB
//     0b1000 ==> Circular buffer size is 2 KB
//     0b1001 ==> Circular buffer size is 4 KB
//     0b1010 ==> Circular buffer size is 8 KB
//     0b1011 ==> Circular buffer size is 16 KB
//     0b1100 ==> Circular buffer size is 32 KB
//     0b1101 ==> Circular buffer size is 64 KB
//     0b1110 ==> Circular buffer size is 128 KB
//     0b1111 ==> Circular buffer size is 256 KB
#define  DMA_DCR1_SMOD_0             BIT12
#define  DMA_DCR1_SMOD_1             BIT13
#define  DMA_DCR1_SMOD_2             BIT14
#define  DMA_DCR1_SMOD_3             BIT15

#define  DMA_DCR1_START              BIT16
//   Start transfer
//     0b0 ==> DMA inactive
//     0b1 ==> The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.

#define  DMA_DCR1_DSIZE              (BIT17|BIT18)
//   Destination size
//     0b00 ==> Longword
//     0b01 ==> Byte
//     0b10 ==> Word
//     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
#define  DMA_DCR1_DSIZE_0            BIT17
#define  DMA_DCR1_DSIZE_1            BIT18

#define  DMA_DCR1_DINC               BIT19
//   Destination increment
//     0b0 ==> No change to the DAR after a successful transfer.
//     0b1 ==> The DAR increments by 1, 2, 4 depending upon the size of the transfer.

#define  DMA_DCR1_SSIZE              (BIT20|BIT21)
//   Source size
//     0b00 ==> Longword
//     0b01 ==> Byte
//     0b10 ==> Word
//     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
#define  DMA_DCR1_SSIZE_0            BIT20
#define  DMA_DCR1_SSIZE_1            BIT21

#define  DMA_DCR1_SINC               BIT22
//   Source increment
//     0b0 ==> No change to SAR after a successful transfer.
//     0b1 ==> The SAR increments by 1, 2, 4 as determined by the transfer size.

#define  DMA_DCR1_AA                 BIT28
//   Auto-align
//     0b0 ==> Auto-align disabled
//     0b1 ==> If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.

#define  DMA_DCR1_CS                 BIT29
//   Cycle steal
//     0b0 ==> DMA continuously makes read/write transfers until the BCR decrements to 0.
//     0b1 ==> Forces a single read/write transfer per request.

#define  DMA_DCR1_ERQ                BIT30
//   Enable peripheral request
//     0b0 ==> Peripheral request is ignored.
//     0b1 ==> Enables peripheral request, defined by the appropriate REQC[DMACn] field, to initiate transfer. A software-initiated request (setting the START bit) is always enabled.

#define  DMA_DCR1_EINT               BIT31
//   Enable interrupt on completion of transfer
//     0b0 ==> No interrupt is generated.
//     0b1 ==> Interrupt signal is enabled.

#define  DMA_SAR2_SAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
#define  DMA_SAR2_SAR_0              BIT0
#define  DMA_SAR2_SAR_1              BIT1
#define  DMA_SAR2_SAR_2              BIT2
#define  DMA_SAR2_SAR_3              BIT3
#define  DMA_SAR2_SAR_4              BIT4
#define  DMA_SAR2_SAR_5              BIT5
#define  DMA_SAR2_SAR_6              BIT6
#define  DMA_SAR2_SAR_7              BIT7
#define  DMA_SAR2_SAR_8              BIT8
#define  DMA_SAR2_SAR_9              BIT9
#define  DMA_SAR2_SAR_10             BIT10
#define  DMA_SAR2_SAR_11             BIT11
#define  DMA_SAR2_SAR_12             BIT12
#define  DMA_SAR2_SAR_13             BIT13
#define  DMA_SAR2_SAR_14             BIT14
#define  DMA_SAR2_SAR_15             BIT15
#define  DMA_SAR2_SAR_16             BIT16
#define  DMA_SAR2_SAR_17             BIT17
#define  DMA_SAR2_SAR_18             BIT18
#define  DMA_SAR2_SAR_19             BIT19
#define  DMA_SAR2_SAR_20             BIT20
#define  DMA_SAR2_SAR_21             BIT21
#define  DMA_SAR2_SAR_22             BIT22
#define  DMA_SAR2_SAR_23             BIT23
#define  DMA_SAR2_SAR_24             BIT24
#define  DMA_SAR2_SAR_25             BIT25
#define  DMA_SAR2_SAR_26             BIT26
#define  DMA_SAR2_SAR_27             BIT27
#define  DMA_SAR2_SAR_28             BIT28
#define  DMA_SAR2_SAR_29             BIT29
#define  DMA_SAR2_SAR_30             BIT30
#define  DMA_SAR2_SAR_31             BIT31

#define  DMA_DAR2_DAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
#define  DMA_DAR2_DAR_0              BIT0
#define  DMA_DAR2_DAR_1              BIT1
#define  DMA_DAR2_DAR_2              BIT2
#define  DMA_DAR2_DAR_3              BIT3
#define  DMA_DAR2_DAR_4              BIT4
#define  DMA_DAR2_DAR_5              BIT5
#define  DMA_DAR2_DAR_6              BIT6
#define  DMA_DAR2_DAR_7              BIT7
#define  DMA_DAR2_DAR_8              BIT8
#define  DMA_DAR2_DAR_9              BIT9
#define  DMA_DAR2_DAR_10             BIT10
#define  DMA_DAR2_DAR_11             BIT11
#define  DMA_DAR2_DAR_12             BIT12
#define  DMA_DAR2_DAR_13             BIT13
#define  DMA_DAR2_DAR_14             BIT14
#define  DMA_DAR2_DAR_15             BIT15
#define  DMA_DAR2_DAR_16             BIT16
#define  DMA_DAR2_DAR_17             BIT17
#define  DMA_DAR2_DAR_18             BIT18
#define  DMA_DAR2_DAR_19             BIT19
#define  DMA_DAR2_DAR_20             BIT20
#define  DMA_DAR2_DAR_21             BIT21
#define  DMA_DAR2_DAR_22             BIT22
#define  DMA_DAR2_DAR_23             BIT23
#define  DMA_DAR2_DAR_24             BIT24
#define  DMA_DAR2_DAR_25             BIT25
#define  DMA_DAR2_DAR_26             BIT26
#define  DMA_DAR2_DAR_27             BIT27
#define  DMA_DAR2_DAR_28             BIT28
#define  DMA_DAR2_DAR_29             BIT29
#define  DMA_DAR2_DAR_30             BIT30
#define  DMA_DAR2_DAR_31             BIT31

#define  DMA_DSR_BCR2_BCR            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
#define  DMA_DSR_BCR2_BCR_0          BIT0
#define  DMA_DSR_BCR2_BCR_1          BIT1
#define  DMA_DSR_BCR2_BCR_2          BIT2
#define  DMA_DSR_BCR2_BCR_3          BIT3
#define  DMA_DSR_BCR2_BCR_4          BIT4
#define  DMA_DSR_BCR2_BCR_5          BIT5
#define  DMA_DSR_BCR2_BCR_6          BIT6
#define  DMA_DSR_BCR2_BCR_7          BIT7
#define  DMA_DSR_BCR2_BCR_8          BIT8
#define  DMA_DSR_BCR2_BCR_9          BIT9
#define  DMA_DSR_BCR2_BCR_10         BIT10
#define  DMA_DSR_BCR2_BCR_11         BIT11
#define  DMA_DSR_BCR2_BCR_12         BIT12
#define  DMA_DSR_BCR2_BCR_13         BIT13
#define  DMA_DSR_BCR2_BCR_14         BIT14
#define  DMA_DSR_BCR2_BCR_15         BIT15
#define  DMA_DSR_BCR2_BCR_16         BIT16
#define  DMA_DSR_BCR2_BCR_17         BIT17
#define  DMA_DSR_BCR2_BCR_18         BIT18
#define  DMA_DSR_BCR2_BCR_19         BIT19
#define  DMA_DSR_BCR2_BCR_20         BIT20
#define  DMA_DSR_BCR2_BCR_21         BIT21
#define  DMA_DSR_BCR2_BCR_22         BIT22
#define  DMA_DSR_BCR2_BCR_23         BIT23

#define  DMA_DSR_BCR2_DONE           BIT24
//   Transactions done
//     0b0 ==> DMA transfer is not yet complete. Writing a 0 has no effect.
//     0b1 ==> DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.

#define  DMA_DSR_BCR2_BSY            BIT25
//   Busy
//     0b0 ==> DMA channel is inactive. Cleared when the DMA has finished the last transaction.
//     0b1 ==> BSY is set the first time the channel is enabled after a transfer is initiated.

#define  DMA_DSR_BCR2_REQ            BIT26
//   Request
//     0b0 ==> No request is pending or the channel is currently active. Cleared when the channel is selected.
//     0b1 ==> The DMA channel has a transfer remaining and the channel is not selected.

#define  DMA_DSR_BCR2_BED            BIT28
//   Bus error on destination
//     0b0 ==> No bus error occurred.
//     0b1 ==> The DMA channel terminated with a bus error during the write portion of a transfer.

#define  DMA_DSR_BCR2_BES            BIT29
//   Bus error on source
//     0b0 ==> No bus error occurred.
//     0b1 ==> The DMA channel terminated with a bus error during the read portion of a transfer.

#define  DMA_DSR_BCR2_CE             BIT30
//   Configuration error
//     0b0 ==> No configuration error exists.
//     0b1 ==> A configuration error has occurred.

#define  DMA_DCR2_LCH2               (BIT0|BIT1)
//   Link channel 2
//     0b00 ==> DMA Channel 0
//     0b01 ==> DMA Channel 1
//     0b10 ==> DMA Channel 2
//     0b11 ==> DMA Channel 3
#define  DMA_DCR2_LCH2_0             BIT0
#define  DMA_DCR2_LCH2_1             BIT1

#define  DMA_DCR2_LCH1               (BIT2|BIT3)
//   Link channel 1
//     0b00 ==> DMA Channel 0
//     0b01 ==> DMA Channel 1
//     0b10 ==> DMA Channel 2
//     0b11 ==> DMA Channel 3
#define  DMA_DCR2_LCH1_0             BIT2
#define  DMA_DCR2_LCH1_1             BIT3

#define  DMA_DCR2_LINKCC             (BIT4|BIT5)
//   Link channel control
//     0b00 ==> No channel-to-channel linking
//     0b01 ==> Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to zero
//     0b10 ==> Perform a link to channel LCH1 after each cycle-steal transfer
//     0b11 ==> Perform a link to channel LCH1 after the BCR decrements to zero
#define  DMA_DCR2_LINKCC_0           BIT4
#define  DMA_DCR2_LINKCC_1           BIT5

#define  DMA_DCR2_D_REQ              BIT7
//   Disable request
//     0b0 ==> ERQ bit is not affected.
//     0b1 ==> ERQ bit is cleared when the BCR is exhausted.

#define  DMA_DCR2_DMOD               (BIT8|BIT9|BIT10|BIT11)
//   Destination address modulo
//     0b0000 ==> Buffer disabled
//     0b0001 ==> Circular buffer size is 16 bytes
//     0b0010 ==> Circular buffer size is 32 bytes
//     0b0011 ==> Circular buffer size is 64 bytes
//     0b0100 ==> Circular buffer size is 128 bytes
//     0b0101 ==> Circular buffer size is 256 bytes
//     0b0110 ==> Circular buffer size is 512 bytes
//     0b0111 ==> Circular buffer size is 1 KB
//     0b1000 ==> Circular buffer size is 2 KB
//     0b1001 ==> Circular buffer size is 4 KB
//     0b1010 ==> Circular buffer size is 8 KB
//     0b1011 ==> Circular buffer size is 16 KB
//     0b1100 ==> Circular buffer size is 32 KB
//     0b1101 ==> Circular buffer size is 64 KB
//     0b1110 ==> Circular buffer size is 128 KB
//     0b1111 ==> Circular buffer size is 256 KB
#define  DMA_DCR2_DMOD_0             BIT8
#define  DMA_DCR2_DMOD_1             BIT9
#define  DMA_DCR2_DMOD_2             BIT10
#define  DMA_DCR2_DMOD_3             BIT11

#define  DMA_DCR2_SMOD               (BIT12|BIT13|BIT14|BIT15)
//   Source address modulo
//     0b0000 ==> Buffer disabled
//     0b0001 ==> Circular buffer size is 16 bytes
//     0b0010 ==> Circular buffer size is 32 bytes
//     0b0011 ==> Circular buffer size is 64 bytes
//     0b0100 ==> Circular buffer size is 128 bytes
//     0b0101 ==> Circular buffer size is 256 bytes
//     0b0110 ==> Circular buffer size is 512 bytes
//     0b0111 ==> Circular buffer size is 1 KB
//     0b1000 ==> Circular buffer size is 2 KB
//     0b1001 ==> Circular buffer size is 4 KB
//     0b1010 ==> Circular buffer size is 8 KB
//     0b1011 ==> Circular buffer size is 16 KB
//     0b1100 ==> Circular buffer size is 32 KB
//     0b1101 ==> Circular buffer size is 64 KB
//     0b1110 ==> Circular buffer size is 128 KB
//     0b1111 ==> Circular buffer size is 256 KB
#define  DMA_DCR2_SMOD_0             BIT12
#define  DMA_DCR2_SMOD_1             BIT13
#define  DMA_DCR2_SMOD_2             BIT14
#define  DMA_DCR2_SMOD_3             BIT15

#define  DMA_DCR2_START              BIT16
//   Start transfer
//     0b0 ==> DMA inactive
//     0b1 ==> The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.

#define  DMA_DCR2_DSIZE              (BIT17|BIT18)
//   Destination size
//     0b00 ==> Longword
//     0b01 ==> Byte
//     0b10 ==> Word
//     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
#define  DMA_DCR2_DSIZE_0            BIT17
#define  DMA_DCR2_DSIZE_1            BIT18

#define  DMA_DCR2_DINC               BIT19
//   Destination increment
//     0b0 ==> No change to the DAR after a successful transfer.
//     0b1 ==> The DAR increments by 1, 2, 4 depending upon the size of the transfer.

#define  DMA_DCR2_SSIZE              (BIT20|BIT21)
//   Source size
//     0b00 ==> Longword
//     0b01 ==> Byte
//     0b10 ==> Word
//     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
#define  DMA_DCR2_SSIZE_0            BIT20
#define  DMA_DCR2_SSIZE_1            BIT21

#define  DMA_DCR2_SINC               BIT22
//   Source increment
//     0b0 ==> No change to SAR after a successful transfer.
//     0b1 ==> The SAR increments by 1, 2, 4 as determined by the transfer size.

#define  DMA_DCR2_AA                 BIT28
//   Auto-align
//     0b0 ==> Auto-align disabled
//     0b1 ==> If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.

#define  DMA_DCR2_CS                 BIT29
//   Cycle steal
//     0b0 ==> DMA continuously makes read/write transfers until the BCR decrements to 0.
//     0b1 ==> Forces a single read/write transfer per request.

#define  DMA_DCR2_ERQ                BIT30
//   Enable peripheral request
//     0b0 ==> Peripheral request is ignored.
//     0b1 ==> Enables peripheral request, defined by the appropriate REQC[DMACn] field, to initiate transfer. A software-initiated request (setting the START bit) is always enabled.

#define  DMA_DCR2_EINT               BIT31
//   Enable interrupt on completion of transfer
//     0b0 ==> No interrupt is generated.
//     0b1 ==> Interrupt signal is enabled.

#define  DMA_SAR3_SAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
#define  DMA_SAR3_SAR_0              BIT0
#define  DMA_SAR3_SAR_1              BIT1
#define  DMA_SAR3_SAR_2              BIT2
#define  DMA_SAR3_SAR_3              BIT3
#define  DMA_SAR3_SAR_4              BIT4
#define  DMA_SAR3_SAR_5              BIT5
#define  DMA_SAR3_SAR_6              BIT6
#define  DMA_SAR3_SAR_7              BIT7
#define  DMA_SAR3_SAR_8              BIT8
#define  DMA_SAR3_SAR_9              BIT9
#define  DMA_SAR3_SAR_10             BIT10
#define  DMA_SAR3_SAR_11             BIT11
#define  DMA_SAR3_SAR_12             BIT12
#define  DMA_SAR3_SAR_13             BIT13
#define  DMA_SAR3_SAR_14             BIT14
#define  DMA_SAR3_SAR_15             BIT15
#define  DMA_SAR3_SAR_16             BIT16
#define  DMA_SAR3_SAR_17             BIT17
#define  DMA_SAR3_SAR_18             BIT18
#define  DMA_SAR3_SAR_19             BIT19
#define  DMA_SAR3_SAR_20             BIT20
#define  DMA_SAR3_SAR_21             BIT21
#define  DMA_SAR3_SAR_22             BIT22
#define  DMA_SAR3_SAR_23             BIT23
#define  DMA_SAR3_SAR_24             BIT24
#define  DMA_SAR3_SAR_25             BIT25
#define  DMA_SAR3_SAR_26             BIT26
#define  DMA_SAR3_SAR_27             BIT27
#define  DMA_SAR3_SAR_28             BIT28
#define  DMA_SAR3_SAR_29             BIT29
#define  DMA_SAR3_SAR_30             BIT30
#define  DMA_SAR3_SAR_31             BIT31

#define  DMA_DAR3_DAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
#define  DMA_DAR3_DAR_0              BIT0
#define  DMA_DAR3_DAR_1              BIT1
#define  DMA_DAR3_DAR_2              BIT2
#define  DMA_DAR3_DAR_3              BIT3
#define  DMA_DAR3_DAR_4              BIT4
#define  DMA_DAR3_DAR_5              BIT5
#define  DMA_DAR3_DAR_6              BIT6
#define  DMA_DAR3_DAR_7              BIT7
#define  DMA_DAR3_DAR_8              BIT8
#define  DMA_DAR3_DAR_9              BIT9
#define  DMA_DAR3_DAR_10             BIT10
#define  DMA_DAR3_DAR_11             BIT11
#define  DMA_DAR3_DAR_12             BIT12
#define  DMA_DAR3_DAR_13             BIT13
#define  DMA_DAR3_DAR_14             BIT14
#define  DMA_DAR3_DAR_15             BIT15
#define  DMA_DAR3_DAR_16             BIT16
#define  DMA_DAR3_DAR_17             BIT17
#define  DMA_DAR3_DAR_18             BIT18
#define  DMA_DAR3_DAR_19             BIT19
#define  DMA_DAR3_DAR_20             BIT20
#define  DMA_DAR3_DAR_21             BIT21
#define  DMA_DAR3_DAR_22             BIT22
#define  DMA_DAR3_DAR_23             BIT23
#define  DMA_DAR3_DAR_24             BIT24
#define  DMA_DAR3_DAR_25             BIT25
#define  DMA_DAR3_DAR_26             BIT26
#define  DMA_DAR3_DAR_27             BIT27
#define  DMA_DAR3_DAR_28             BIT28
#define  DMA_DAR3_DAR_29             BIT29
#define  DMA_DAR3_DAR_30             BIT30
#define  DMA_DAR3_DAR_31             BIT31

#define  DMA_DSR_BCR3_BCR            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
#define  DMA_DSR_BCR3_BCR_0          BIT0
#define  DMA_DSR_BCR3_BCR_1          BIT1
#define  DMA_DSR_BCR3_BCR_2          BIT2
#define  DMA_DSR_BCR3_BCR_3          BIT3
#define  DMA_DSR_BCR3_BCR_4          BIT4
#define  DMA_DSR_BCR3_BCR_5          BIT5
#define  DMA_DSR_BCR3_BCR_6          BIT6
#define  DMA_DSR_BCR3_BCR_7          BIT7
#define  DMA_DSR_BCR3_BCR_8          BIT8
#define  DMA_DSR_BCR3_BCR_9          BIT9
#define  DMA_DSR_BCR3_BCR_10         BIT10
#define  DMA_DSR_BCR3_BCR_11         BIT11
#define  DMA_DSR_BCR3_BCR_12         BIT12
#define  DMA_DSR_BCR3_BCR_13         BIT13
#define  DMA_DSR_BCR3_BCR_14         BIT14
#define  DMA_DSR_BCR3_BCR_15         BIT15
#define  DMA_DSR_BCR3_BCR_16         BIT16
#define  DMA_DSR_BCR3_BCR_17         BIT17
#define  DMA_DSR_BCR3_BCR_18         BIT18
#define  DMA_DSR_BCR3_BCR_19         BIT19
#define  DMA_DSR_BCR3_BCR_20         BIT20
#define  DMA_DSR_BCR3_BCR_21         BIT21
#define  DMA_DSR_BCR3_BCR_22         BIT22
#define  DMA_DSR_BCR3_BCR_23         BIT23

#define  DMA_DSR_BCR3_DONE           BIT24
//   Transactions done
//     0b0 ==> DMA transfer is not yet complete. Writing a 0 has no effect.
//     0b1 ==> DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.

#define  DMA_DSR_BCR3_BSY            BIT25
//   Busy
//     0b0 ==> DMA channel is inactive. Cleared when the DMA has finished the last transaction.
//     0b1 ==> BSY is set the first time the channel is enabled after a transfer is initiated.

#define  DMA_DSR_BCR3_REQ            BIT26
//   Request
//     0b0 ==> No request is pending or the channel is currently active. Cleared when the channel is selected.
//     0b1 ==> The DMA channel has a transfer remaining and the channel is not selected.

#define  DMA_DSR_BCR3_BED            BIT28
//   Bus error on destination
//     0b0 ==> No bus error occurred.
//     0b1 ==> The DMA channel terminated with a bus error during the write portion of a transfer.

#define  DMA_DSR_BCR3_BES            BIT29
//   Bus error on source
//     0b0 ==> No bus error occurred.
//     0b1 ==> The DMA channel terminated with a bus error during the read portion of a transfer.

#define  DMA_DSR_BCR3_CE             BIT30
//   Configuration error
//     0b0 ==> No configuration error exists.
//     0b1 ==> A configuration error has occurred.

#define  DMA_DCR3_LCH2               (BIT0|BIT1)
//   Link channel 2
//     0b00 ==> DMA Channel 0
//     0b01 ==> DMA Channel 1
//     0b10 ==> DMA Channel 2
//     0b11 ==> DMA Channel 3
#define  DMA_DCR3_LCH2_0             BIT0
#define  DMA_DCR3_LCH2_1             BIT1

#define  DMA_DCR3_LCH1               (BIT2|BIT3)
//   Link channel 1
//     0b00 ==> DMA Channel 0
//     0b01 ==> DMA Channel 1
//     0b10 ==> DMA Channel 2
//     0b11 ==> DMA Channel 3
#define  DMA_DCR3_LCH1_0             BIT2
#define  DMA_DCR3_LCH1_1             BIT3

#define  DMA_DCR3_LINKCC             (BIT4|BIT5)
//   Link channel control
//     0b00 ==> No channel-to-channel linking
//     0b01 ==> Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to zero
//     0b10 ==> Perform a link to channel LCH1 after each cycle-steal transfer
//     0b11 ==> Perform a link to channel LCH1 after the BCR decrements to zero
#define  DMA_DCR3_LINKCC_0           BIT4
#define  DMA_DCR3_LINKCC_1           BIT5

#define  DMA_DCR3_D_REQ              BIT7
//   Disable request
//     0b0 ==> ERQ bit is not affected.
//     0b1 ==> ERQ bit is cleared when the BCR is exhausted.

#define  DMA_DCR3_DMOD               (BIT8|BIT9|BIT10|BIT11)
//   Destination address modulo
//     0b0000 ==> Buffer disabled
//     0b0001 ==> Circular buffer size is 16 bytes
//     0b0010 ==> Circular buffer size is 32 bytes
//     0b0011 ==> Circular buffer size is 64 bytes
//     0b0100 ==> Circular buffer size is 128 bytes
//     0b0101 ==> Circular buffer size is 256 bytes
//     0b0110 ==> Circular buffer size is 512 bytes
//     0b0111 ==> Circular buffer size is 1 KB
//     0b1000 ==> Circular buffer size is 2 KB
//     0b1001 ==> Circular buffer size is 4 KB
//     0b1010 ==> Circular buffer size is 8 KB
//     0b1011 ==> Circular buffer size is 16 KB
//     0b1100 ==> Circular buffer size is 32 KB
//     0b1101 ==> Circular buffer size is 64 KB
//     0b1110 ==> Circular buffer size is 128 KB
//     0b1111 ==> Circular buffer size is 256 KB
#define  DMA_DCR3_DMOD_0             BIT8
#define  DMA_DCR3_DMOD_1             BIT9
#define  DMA_DCR3_DMOD_2             BIT10
#define  DMA_DCR3_DMOD_3             BIT11

#define  DMA_DCR3_SMOD               (BIT12|BIT13|BIT14|BIT15)
//   Source address modulo
//     0b0000 ==> Buffer disabled
//     0b0001 ==> Circular buffer size is 16 bytes
//     0b0010 ==> Circular buffer size is 32 bytes
//     0b0011 ==> Circular buffer size is 64 bytes
//     0b0100 ==> Circular buffer size is 128 bytes
//     0b0101 ==> Circular buffer size is 256 bytes
//     0b0110 ==> Circular buffer size is 512 bytes
//     0b0111 ==> Circular buffer size is 1 KB
//     0b1000 ==> Circular buffer size is 2 KB
//     0b1001 ==> Circular buffer size is 4 KB
//     0b1010 ==> Circular buffer size is 8 KB
//     0b1011 ==> Circular buffer size is 16 KB
//     0b1100 ==> Circular buffer size is 32 KB
//     0b1101 ==> Circular buffer size is 64 KB
//     0b1110 ==> Circular buffer size is 128 KB
//     0b1111 ==> Circular buffer size is 256 KB
#define  DMA_DCR3_SMOD_0             BIT12
#define  DMA_DCR3_SMOD_1             BIT13
#define  DMA_DCR3_SMOD_2             BIT14
#define  DMA_DCR3_SMOD_3             BIT15

#define  DMA_DCR3_START              BIT16
//   Start transfer
//     0b0 ==> DMA inactive
//     0b1 ==> The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.

#define  DMA_DCR3_DSIZE              (BIT17|BIT18)
//   Destination size
//     0b00 ==> Longword
//     0b01 ==> Byte
//     0b10 ==> Word
//     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
#define  DMA_DCR3_DSIZE_0            BIT17
#define  DMA_DCR3_DSIZE_1            BIT18

#define  DMA_DCR3_DINC               BIT19
//   Destination increment
//     0b0 ==> No change to the DAR after a successful transfer.
//     0b1 ==> The DAR increments by 1, 2, 4 depending upon the size of the transfer.

#define  DMA_DCR3_SSIZE              (BIT20|BIT21)
//   Source size
//     0b00 ==> Longword
//     0b01 ==> Byte
//     0b10 ==> Word
//     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
#define  DMA_DCR3_SSIZE_0            BIT20
#define  DMA_DCR3_SSIZE_1            BIT21

#define  DMA_DCR3_SINC               BIT22
//   Source increment
//     0b0 ==> No change to SAR after a successful transfer.
//     0b1 ==> The SAR increments by 1, 2, 4 as determined by the transfer size.

#define  DMA_DCR3_AA                 BIT28
//   Auto-align
//     0b0 ==> Auto-align disabled
//     0b1 ==> If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.

#define  DMA_DCR3_CS                 BIT29
//   Cycle steal
//     0b0 ==> DMA continuously makes read/write transfers until the BCR decrements to 0.
//     0b1 ==> Forces a single read/write transfer per request.

#define  DMA_DCR3_ERQ                BIT30
//   Enable peripheral request
//     0b0 ==> Peripheral request is ignored.
//     0b1 ==> Enables peripheral request, defined by the appropriate REQC[DMACn] field, to initiate transfer. A software-initiated request (setting the START bit) is always enabled.

#define  DMA_DCR3_EINT               BIT31
//   Enable interrupt on completion of transfer
//     0b0 ==> No interrupt is generated.
//     0b1 ==> Interrupt signal is enabled.

#define  ENC_CTRL_CMPIE              BIT0
//   Compare Interrupt Enable
//     0b0 ==> Compare interrupt is disabled
//     0b1 ==> Compare interrupt is enabled

#define  ENC_CTRL_CMPIRQ             BIT1
//   Compare Interrupt Request
//     0b0 ==> No match has occurred
//     0b1 ==> COMP match has occurred

#define  ENC_CTRL_WDE                BIT2
//   Watchdog Enable
//     0b0 ==> Watchdog timer is disabled
//     0b1 ==> Watchdog timer is enabled

#define  ENC_CTRL_DIE                BIT3
//   Watchdog Timeout Interrupt Enable
//     0b0 ==> Watchdog timer interrupt is disabled
//     0b1 ==> Watchdog timer interrupt is enabled

#define  ENC_CTRL_DIRQ               BIT4
//   Watchdog Timeout Interrupt Request
//     0b0 ==> No interrupt has occurred
//     0b1 ==> Watchdog timeout interrupt has occurred

#define  ENC_CTRL_XNE                BIT5
//   Use Negative Edge of INDEX Pulse
//     0b0 ==> Use positive transition edge of INDEX pulse
//     0b1 ==> Use negative transition edge of INDEX pulse

#define  ENC_CTRL_XIP                BIT6
//   INDEX Triggered Initialization of Position Counters UPOS and LPOS
//     0b0 ==> No action
//     0b1 ==> INDEX pulse initializes the position counter

#define  ENC_CTRL_XIE                BIT7
//   INDEX Pulse Interrupt Enable
//     0b0 ==> INDEX pulse interrupt is disabled
//     0b1 ==> INDEX pulse interrupt is enabled

#define  ENC_CTRL_XIRQ               BIT8
//   INDEX Pulse Interrupt Request
//     0b0 ==> No interrupt has occurred
//     0b1 ==> INDEX pulse interrupt has occurred

#define  ENC_CTRL_PH1                BIT9
//   Enable Signal Phase Count Mode
//     0b0 ==> Use standard quadrature decoder where PHASEA and PHASEB represent a two phase quadrature signal.
//     0b1 ==> Bypass the quadrature decoder. A positive transition of the PHASEA input generates a count signal. The PHASEB input and the REV bit control the counter direction. If CTRL[REV] = 0, PHASEB = 0, then count up If CTRL[REV] = 0, PHASEB = 1, then count down If CTRL[REV] = 1, PHASEB = 0, then count down If CTRL[REV] = 1, PHASEB = 1, then count up

#define  ENC_CTRL_REV                BIT10
//   Enable Reverse Direction Counting
//     0b0 ==> Count normally
//     0b1 ==> Count in the reverse direction

#define  ENC_CTRL_SWIP               BIT11
//   Software Triggered Initialization of Position Counters UPOS and LPOS
//     0b0 ==> No action
//     0b1 ==> Initialize position counter

#define  ENC_CTRL_HNE                BIT12
//   Use Negative Edge of HOME Input
//     0b0 ==> Use positive going edge-to-trigger initialization of position counters UPOS and LPOS
//     0b1 ==> Use negative going edge-to-trigger initialization of position counters UPOS and LPOS

#define  ENC_CTRL_HIP                BIT13
//   Enable HOME to Initialize Position Counters UPOS and LPOS
//     0b0 ==> No action
//     0b1 ==> HOME signal initializes the position counter

#define  ENC_CTRL_HIE                BIT14
//   HOME Interrupt Enable
//     0b0 ==> Disable HOME interrupts
//     0b1 ==> Enable HOME interrupts

#define  ENC_CTRL_HIRQ               BIT15
//   HOME Signal Transition Interrupt Request
//     0b0 ==> No interrupt
//     0b1 ==> HOME signal transition interrupt request

#define  ENC_FILT_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Input Filter Sample Period
#define  ENC_FILT_FILT_PER_0         BIT0
#define  ENC_FILT_FILT_PER_1         BIT1
#define  ENC_FILT_FILT_PER_2         BIT2
#define  ENC_FILT_FILT_PER_3         BIT3
#define  ENC_FILT_FILT_PER_4         BIT4
#define  ENC_FILT_FILT_PER_5         BIT5
#define  ENC_FILT_FILT_PER_6         BIT6
#define  ENC_FILT_FILT_PER_7         BIT7

#define  ENC_FILT_FILT_CNT           (BIT8|BIT9|BIT10)
//   Input Filter Sample Count
#define  ENC_FILT_FILT_CNT_0         BIT8
#define  ENC_FILT_FILT_CNT_1         BIT9
#define  ENC_FILT_FILT_CNT_2         BIT10

#define  ENC_WTR_WDOG                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_WTR_WDOG_0              BIT0
#define  ENC_WTR_WDOG_1              BIT1
#define  ENC_WTR_WDOG_2              BIT2
#define  ENC_WTR_WDOG_3              BIT3
#define  ENC_WTR_WDOG_4              BIT4
#define  ENC_WTR_WDOG_5              BIT5
#define  ENC_WTR_WDOG_6              BIT6
#define  ENC_WTR_WDOG_7              BIT7
#define  ENC_WTR_WDOG_8              BIT8
#define  ENC_WTR_WDOG_9              BIT9
#define  ENC_WTR_WDOG_10             BIT10
#define  ENC_WTR_WDOG_11             BIT11
#define  ENC_WTR_WDOG_12             BIT12
#define  ENC_WTR_WDOG_13             BIT13
#define  ENC_WTR_WDOG_14             BIT14
#define  ENC_WTR_WDOG_15             BIT15

#define  ENC_POSD_POSD               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_POSD_POSD_0             BIT0
#define  ENC_POSD_POSD_1             BIT1
#define  ENC_POSD_POSD_2             BIT2
#define  ENC_POSD_POSD_3             BIT3
#define  ENC_POSD_POSD_4             BIT4
#define  ENC_POSD_POSD_5             BIT5
#define  ENC_POSD_POSD_6             BIT6
#define  ENC_POSD_POSD_7             BIT7
#define  ENC_POSD_POSD_8             BIT8
#define  ENC_POSD_POSD_9             BIT9
#define  ENC_POSD_POSD_10            BIT10
#define  ENC_POSD_POSD_11            BIT11
#define  ENC_POSD_POSD_12            BIT12
#define  ENC_POSD_POSD_13            BIT13
#define  ENC_POSD_POSD_14            BIT14
#define  ENC_POSD_POSD_15            BIT15

#define  ENC_POSDH_POSDH             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_POSDH_POSDH_0           BIT0
#define  ENC_POSDH_POSDH_1           BIT1
#define  ENC_POSDH_POSDH_2           BIT2
#define  ENC_POSDH_POSDH_3           BIT3
#define  ENC_POSDH_POSDH_4           BIT4
#define  ENC_POSDH_POSDH_5           BIT5
#define  ENC_POSDH_POSDH_6           BIT6
#define  ENC_POSDH_POSDH_7           BIT7
#define  ENC_POSDH_POSDH_8           BIT8
#define  ENC_POSDH_POSDH_9           BIT9
#define  ENC_POSDH_POSDH_10          BIT10
#define  ENC_POSDH_POSDH_11          BIT11
#define  ENC_POSDH_POSDH_12          BIT12
#define  ENC_POSDH_POSDH_13          BIT13
#define  ENC_POSDH_POSDH_14          BIT14
#define  ENC_POSDH_POSDH_15          BIT15

#define  ENC_REV_REV                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_REV_REV_0               BIT0
#define  ENC_REV_REV_1               BIT1
#define  ENC_REV_REV_2               BIT2
#define  ENC_REV_REV_3               BIT3
#define  ENC_REV_REV_4               BIT4
#define  ENC_REV_REV_5               BIT5
#define  ENC_REV_REV_6               BIT6
#define  ENC_REV_REV_7               BIT7
#define  ENC_REV_REV_8               BIT8
#define  ENC_REV_REV_9               BIT9
#define  ENC_REV_REV_10              BIT10
#define  ENC_REV_REV_11              BIT11
#define  ENC_REV_REV_12              BIT12
#define  ENC_REV_REV_13              BIT13
#define  ENC_REV_REV_14              BIT14
#define  ENC_REV_REV_15              BIT15

#define  ENC_REVH_REVH               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_REVH_REVH_0             BIT0
#define  ENC_REVH_REVH_1             BIT1
#define  ENC_REVH_REVH_2             BIT2
#define  ENC_REVH_REVH_3             BIT3
#define  ENC_REVH_REVH_4             BIT4
#define  ENC_REVH_REVH_5             BIT5
#define  ENC_REVH_REVH_6             BIT6
#define  ENC_REVH_REVH_7             BIT7
#define  ENC_REVH_REVH_8             BIT8
#define  ENC_REVH_REVH_9             BIT9
#define  ENC_REVH_REVH_10            BIT10
#define  ENC_REVH_REVH_11            BIT11
#define  ENC_REVH_REVH_12            BIT12
#define  ENC_REVH_REVH_13            BIT13
#define  ENC_REVH_REVH_14            BIT14
#define  ENC_REVH_REVH_15            BIT15

#define  ENC_UPOS_POS                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_UPOS_POS_0              BIT0
#define  ENC_UPOS_POS_1              BIT1
#define  ENC_UPOS_POS_2              BIT2
#define  ENC_UPOS_POS_3              BIT3
#define  ENC_UPOS_POS_4              BIT4
#define  ENC_UPOS_POS_5              BIT5
#define  ENC_UPOS_POS_6              BIT6
#define  ENC_UPOS_POS_7              BIT7
#define  ENC_UPOS_POS_8              BIT8
#define  ENC_UPOS_POS_9              BIT9
#define  ENC_UPOS_POS_10             BIT10
#define  ENC_UPOS_POS_11             BIT11
#define  ENC_UPOS_POS_12             BIT12
#define  ENC_UPOS_POS_13             BIT13
#define  ENC_UPOS_POS_14             BIT14
#define  ENC_UPOS_POS_15             BIT15

#define  ENC_LPOS_POS                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_LPOS_POS_0              BIT0
#define  ENC_LPOS_POS_1              BIT1
#define  ENC_LPOS_POS_2              BIT2
#define  ENC_LPOS_POS_3              BIT3
#define  ENC_LPOS_POS_4              BIT4
#define  ENC_LPOS_POS_5              BIT5
#define  ENC_LPOS_POS_6              BIT6
#define  ENC_LPOS_POS_7              BIT7
#define  ENC_LPOS_POS_8              BIT8
#define  ENC_LPOS_POS_9              BIT9
#define  ENC_LPOS_POS_10             BIT10
#define  ENC_LPOS_POS_11             BIT11
#define  ENC_LPOS_POS_12             BIT12
#define  ENC_LPOS_POS_13             BIT13
#define  ENC_LPOS_POS_14             BIT14
#define  ENC_LPOS_POS_15             BIT15

#define  ENC_UPOSH_POSH              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_UPOSH_POSH_0            BIT0
#define  ENC_UPOSH_POSH_1            BIT1
#define  ENC_UPOSH_POSH_2            BIT2
#define  ENC_UPOSH_POSH_3            BIT3
#define  ENC_UPOSH_POSH_4            BIT4
#define  ENC_UPOSH_POSH_5            BIT5
#define  ENC_UPOSH_POSH_6            BIT6
#define  ENC_UPOSH_POSH_7            BIT7
#define  ENC_UPOSH_POSH_8            BIT8
#define  ENC_UPOSH_POSH_9            BIT9
#define  ENC_UPOSH_POSH_10           BIT10
#define  ENC_UPOSH_POSH_11           BIT11
#define  ENC_UPOSH_POSH_12           BIT12
#define  ENC_UPOSH_POSH_13           BIT13
#define  ENC_UPOSH_POSH_14           BIT14
#define  ENC_UPOSH_POSH_15           BIT15

#define  ENC_LPOSH_POSH              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_LPOSH_POSH_0            BIT0
#define  ENC_LPOSH_POSH_1            BIT1
#define  ENC_LPOSH_POSH_2            BIT2
#define  ENC_LPOSH_POSH_3            BIT3
#define  ENC_LPOSH_POSH_4            BIT4
#define  ENC_LPOSH_POSH_5            BIT5
#define  ENC_LPOSH_POSH_6            BIT6
#define  ENC_LPOSH_POSH_7            BIT7
#define  ENC_LPOSH_POSH_8            BIT8
#define  ENC_LPOSH_POSH_9            BIT9
#define  ENC_LPOSH_POSH_10           BIT10
#define  ENC_LPOSH_POSH_11           BIT11
#define  ENC_LPOSH_POSH_12           BIT12
#define  ENC_LPOSH_POSH_13           BIT13
#define  ENC_LPOSH_POSH_14           BIT14
#define  ENC_LPOSH_POSH_15           BIT15

#define  ENC_UINIT_INIT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_UINIT_INIT_0            BIT0
#define  ENC_UINIT_INIT_1            BIT1
#define  ENC_UINIT_INIT_2            BIT2
#define  ENC_UINIT_INIT_3            BIT3
#define  ENC_UINIT_INIT_4            BIT4
#define  ENC_UINIT_INIT_5            BIT5
#define  ENC_UINIT_INIT_6            BIT6
#define  ENC_UINIT_INIT_7            BIT7
#define  ENC_UINIT_INIT_8            BIT8
#define  ENC_UINIT_INIT_9            BIT9
#define  ENC_UINIT_INIT_10           BIT10
#define  ENC_UINIT_INIT_11           BIT11
#define  ENC_UINIT_INIT_12           BIT12
#define  ENC_UINIT_INIT_13           BIT13
#define  ENC_UINIT_INIT_14           BIT14
#define  ENC_UINIT_INIT_15           BIT15

#define  ENC_LINIT_INIT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_LINIT_INIT_0            BIT0
#define  ENC_LINIT_INIT_1            BIT1
#define  ENC_LINIT_INIT_2            BIT2
#define  ENC_LINIT_INIT_3            BIT3
#define  ENC_LINIT_INIT_4            BIT4
#define  ENC_LINIT_INIT_5            BIT5
#define  ENC_LINIT_INIT_6            BIT6
#define  ENC_LINIT_INIT_7            BIT7
#define  ENC_LINIT_INIT_8            BIT8
#define  ENC_LINIT_INIT_9            BIT9
#define  ENC_LINIT_INIT_10           BIT10
#define  ENC_LINIT_INIT_11           BIT11
#define  ENC_LINIT_INIT_12           BIT12
#define  ENC_LINIT_INIT_13           BIT13
#define  ENC_LINIT_INIT_14           BIT14
#define  ENC_LINIT_INIT_15           BIT15

#define  ENC_IMR_HOME                BIT0

#define  ENC_IMR_INDEX               BIT1

#define  ENC_IMR_PHB                 BIT2

#define  ENC_IMR_PHA                 BIT3

#define  ENC_IMR_FHOM                BIT4

#define  ENC_IMR_FIND                BIT5

#define  ENC_IMR_FPHB                BIT6

#define  ENC_IMR_FPHA                BIT7

#define  ENC_TST_TEST_COUNT          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  ENC_TST_TEST_COUNT_0        BIT0
#define  ENC_TST_TEST_COUNT_1        BIT1
#define  ENC_TST_TEST_COUNT_2        BIT2
#define  ENC_TST_TEST_COUNT_3        BIT3
#define  ENC_TST_TEST_COUNT_4        BIT4
#define  ENC_TST_TEST_COUNT_5        BIT5
#define  ENC_TST_TEST_COUNT_6        BIT6
#define  ENC_TST_TEST_COUNT_7        BIT7

#define  ENC_TST_TEST_PERIOD         (BIT8|BIT9|BIT10|BIT11|BIT12)
#define  ENC_TST_TEST_PERIOD_0       BIT8
#define  ENC_TST_TEST_PERIOD_1       BIT9
#define  ENC_TST_TEST_PERIOD_2       BIT10
#define  ENC_TST_TEST_PERIOD_3       BIT11
#define  ENC_TST_TEST_PERIOD_4       BIT12

#define  ENC_TST_QDN                 BIT13
//   Quadrature Decoder Negative Signal
//     0b0 ==> Leaves quadrature decoder signal in a positive direction
//     0b1 ==> Generates a negative quadrature decoder signal

#define  ENC_TST_TCE                 BIT14
//   Test Counter Enable
//     0b0 ==> Test count is not enabled
//     0b1 ==> Test count is enabled

#define  ENC_TST_TEN                 BIT15
//   Test Mode Enable
//     0b0 ==> Test module is not enabled
//     0b1 ==> Test module is enabled

#define  ENC_CTRL2_UPDHLD            BIT0
//   Update Hold Registers
//     0b0 ==> Disable updates of hold registers on rising edge of TRIGGER
//     0b1 ==> Enable updates of hold registers on rising edge of TRIGGER

#define  ENC_CTRL2_UPDPOS            BIT1
//   Update Position Registers
//     0b0 ==> No action for POSD, REV, UPOS and LPOS on rising edge of TRIGGER
//     0b1 ==> Clear POSD, REV, UPOS and LPOS on rising edge of TRIGGER

#define  ENC_CTRL2_MOD               BIT2
//   Enable Modulo Counting
//     0b0 ==> Disable modulo counting
//     0b1 ==> Enable modulo counting

#define  ENC_CTRL2_DIR               BIT3
//   Count Direction Flag
//     0b0 ==> Last count was in the down direction
//     0b1 ==> Last count was in the up direction

#define  ENC_CTRL2_RUIE              BIT4
//   Roll-under Interrupt Enable
//     0b0 ==> Roll-under interrupt is disabled
//     0b1 ==> Roll-under interrupt is enabled

#define  ENC_CTRL2_RUIRQ             BIT5
//   Roll-under Interrupt Request
//     0b0 ==> No roll-under has occurred
//     0b1 ==> Roll-under has occurred

#define  ENC_CTRL2_ROIE              BIT6
//   Roll-over Interrupt Enable
//     0b0 ==> Roll-over interrupt is disabled
//     0b1 ==> Roll-over interrupt is enabled

#define  ENC_CTRL2_ROIRQ             BIT7
//   Roll-over Interrupt Request
//     0b0 ==> No roll-over has occurred
//     0b1 ==> Roll-over has occurred

#define  ENC_CTRL2_REVMOD            BIT8
//   Revolution Counter Modulus Enable
//     0b0 ==> Use INDEX pulse to increment/decrement revolution counter (REV).
//     0b1 ==> Use modulus counting roll-over/under to increment/decrement revolution counter (REV).

#define  ENC_CTRL2_OUTCTL            BIT9
//   Output Control
//     0b0 ==> POSMATCH pulses when a match occurs between the position counters (POS) and the compare value (COMP).
//     0b1 ==> POSMATCH pulses when the UPOS, LPOS, REV, or POSD registers are read.

#define  ENC_UMOD_MOD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_UMOD_MOD_0              BIT0
#define  ENC_UMOD_MOD_1              BIT1
#define  ENC_UMOD_MOD_2              BIT2
#define  ENC_UMOD_MOD_3              BIT3
#define  ENC_UMOD_MOD_4              BIT4
#define  ENC_UMOD_MOD_5              BIT5
#define  ENC_UMOD_MOD_6              BIT6
#define  ENC_UMOD_MOD_7              BIT7
#define  ENC_UMOD_MOD_8              BIT8
#define  ENC_UMOD_MOD_9              BIT9
#define  ENC_UMOD_MOD_10             BIT10
#define  ENC_UMOD_MOD_11             BIT11
#define  ENC_UMOD_MOD_12             BIT12
#define  ENC_UMOD_MOD_13             BIT13
#define  ENC_UMOD_MOD_14             BIT14
#define  ENC_UMOD_MOD_15             BIT15

#define  ENC_LMOD_MOD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_LMOD_MOD_0              BIT0
#define  ENC_LMOD_MOD_1              BIT1
#define  ENC_LMOD_MOD_2              BIT2
#define  ENC_LMOD_MOD_3              BIT3
#define  ENC_LMOD_MOD_4              BIT4
#define  ENC_LMOD_MOD_5              BIT5
#define  ENC_LMOD_MOD_6              BIT6
#define  ENC_LMOD_MOD_7              BIT7
#define  ENC_LMOD_MOD_8              BIT8
#define  ENC_LMOD_MOD_9              BIT9
#define  ENC_LMOD_MOD_10             BIT10
#define  ENC_LMOD_MOD_11             BIT11
#define  ENC_LMOD_MOD_12             BIT12
#define  ENC_LMOD_MOD_13             BIT13
#define  ENC_LMOD_MOD_14             BIT14
#define  ENC_LMOD_MOD_15             BIT15

#define  ENC_UCOMP_COMP              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_UCOMP_COMP_0            BIT0
#define  ENC_UCOMP_COMP_1            BIT1
#define  ENC_UCOMP_COMP_2            BIT2
#define  ENC_UCOMP_COMP_3            BIT3
#define  ENC_UCOMP_COMP_4            BIT4
#define  ENC_UCOMP_COMP_5            BIT5
#define  ENC_UCOMP_COMP_6            BIT6
#define  ENC_UCOMP_COMP_7            BIT7
#define  ENC_UCOMP_COMP_8            BIT8
#define  ENC_UCOMP_COMP_9            BIT9
#define  ENC_UCOMP_COMP_10           BIT10
#define  ENC_UCOMP_COMP_11           BIT11
#define  ENC_UCOMP_COMP_12           BIT12
#define  ENC_UCOMP_COMP_13           BIT13
#define  ENC_UCOMP_COMP_14           BIT14
#define  ENC_UCOMP_COMP_15           BIT15

#define  ENC_LCOMP_COMP              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  ENC_LCOMP_COMP_0            BIT0
#define  ENC_LCOMP_COMP_1            BIT1
#define  ENC_LCOMP_COMP_2            BIT2
#define  ENC_LCOMP_COMP_3            BIT3
#define  ENC_LCOMP_COMP_4            BIT4
#define  ENC_LCOMP_COMP_5            BIT5
#define  ENC_LCOMP_COMP_6            BIT6
#define  ENC_LCOMP_COMP_7            BIT7
#define  ENC_LCOMP_COMP_8            BIT8
#define  ENC_LCOMP_COMP_9            BIT9
#define  ENC_LCOMP_COMP_10           BIT10
#define  ENC_LCOMP_COMP_11           BIT11
#define  ENC_LCOMP_COMP_12           BIT12
#define  ENC_LCOMP_COMP_13           BIT13
#define  ENC_LCOMP_COMP_14           BIT14
#define  ENC_LCOMP_COMP_15           BIT15

#define  EWM_CTRL_EWMEN              BIT0
//   EWM enable.

#define  EWM_CTRL_ASSIN              BIT1
//   EWM_in's Assertion State Select.

#define  EWM_CTRL_INEN               BIT2
//   Input Enable.

#define  EWM_CTRL_INTEN              BIT3
//   Interrupt Enable.

#define  EWM_SERV_SERVICE            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  EWM_SERV_SERVICE_0          BIT0
#define  EWM_SERV_SERVICE_1          BIT1
#define  EWM_SERV_SERVICE_2          BIT2
#define  EWM_SERV_SERVICE_3          BIT3
#define  EWM_SERV_SERVICE_4          BIT4
#define  EWM_SERV_SERVICE_5          BIT5
#define  EWM_SERV_SERVICE_6          BIT6
#define  EWM_SERV_SERVICE_7          BIT7

#define  EWM_CMPL_COMPAREL           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  EWM_CMPL_COMPAREL_0         BIT0
#define  EWM_CMPL_COMPAREL_1         BIT1
#define  EWM_CMPL_COMPAREL_2         BIT2
#define  EWM_CMPL_COMPAREL_3         BIT3
#define  EWM_CMPL_COMPAREL_4         BIT4
#define  EWM_CMPL_COMPAREL_5         BIT5
#define  EWM_CMPL_COMPAREL_6         BIT6
#define  EWM_CMPL_COMPAREL_7         BIT7

#define  EWM_CMPH_COMPAREH           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  EWM_CMPH_COMPAREH_0         BIT0
#define  EWM_CMPH_COMPAREH_1         BIT1
#define  EWM_CMPH_COMPAREH_2         BIT2
#define  EWM_CMPH_COMPAREH_3         BIT3
#define  EWM_CMPH_COMPAREH_4         BIT4
#define  EWM_CMPH_COMPAREH_5         BIT5
#define  EWM_CMPH_COMPAREH_6         BIT6
#define  EWM_CMPH_COMPAREH_7         BIT7

#define  EWM_CLKCTRL_CLKSEL          (BIT0|BIT1)
#define  EWM_CLKCTRL_CLKSEL_0        BIT0
#define  EWM_CLKCTRL_CLKSEL_1        BIT1

#define  EWM_CLKPRESCALER_CLK_DIV    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  EWM_CLKPRESCALER_CLK_DIV_0  BIT0
#define  EWM_CLKPRESCALER_CLK_DIV_1  BIT1
#define  EWM_CLKPRESCALER_CLK_DIV_2  BIT2
#define  EWM_CLKPRESCALER_CLK_DIV_3  BIT3
#define  EWM_CLKPRESCALER_CLK_DIV_4  BIT4
#define  EWM_CLKPRESCALER_CLK_DIV_5  BIT5
#define  EWM_CLKPRESCALER_CLK_DIV_6  BIT6
#define  EWM_CLKPRESCALER_CLK_DIV_7  BIT7

#define  FMC_PFAPR_M0AP              (BIT0|BIT1)
//   Master 0 Access Protection
//     0b00 ==> No access may be performed by this master
//     0b01 ==> Only read accesses may be performed by this master
//     0b10 ==> Only write accesses may be performed by this master
//     0b11 ==> Both read and write accesses may be performed by this master
#define  FMC_PFAPR_M0AP_0            BIT0
#define  FMC_PFAPR_M0AP_1            BIT1

#define  FMC_PFAPR_M1AP              (BIT2|BIT3)
//   Master 1 Access Protection
//     0b00 ==> No access may be performed by this master
//     0b01 ==> Only read accesses may be performed by this master
//     0b10 ==> Only write accesses may be performed by this master
//     0b11 ==> Both read and write accesses may be performed by this master
#define  FMC_PFAPR_M1AP_0            BIT2
#define  FMC_PFAPR_M1AP_1            BIT3

#define  FMC_PFAPR_M2AP              (BIT4|BIT5)
//   Master 2 Access Protection
//     0b00 ==> No access may be performed by this master
//     0b01 ==> Only read accesses may be performed by this master
//     0b10 ==> Only write accesses may be performed by this master
//     0b11 ==> Both read and write accesses may be performed by this master
#define  FMC_PFAPR_M2AP_0            BIT4
#define  FMC_PFAPR_M2AP_1            BIT5

#define  FMC_PFAPR_M3AP              (BIT6|BIT7)
//   Master 3 Access Protection
//     0b00 ==> No access may be performed by this master
//     0b01 ==> Only read accesses may be performed by this master
//     0b10 ==> Only write accesses may be performed by this master
//     0b11 ==> Both read and write accesses may be performed by this master
#define  FMC_PFAPR_M3AP_0            BIT6
#define  FMC_PFAPR_M3AP_1            BIT7

#define  FMC_PFAPR_M0PFD             BIT16
//   Master 0 Prefetch Disable
//     0b0 ==> Prefetching for this master is enabled.
//     0b1 ==> Prefetching for this master is disabled.

#define  FMC_PFAPR_M1PFD             BIT17
//   Master 1 Prefetch Disable
//     0b0 ==> Prefetching for this master is enabled.
//     0b1 ==> Prefetching for this master is disabled.

#define  FMC_PFAPR_M2PFD             BIT18
//   Master 2 Prefetch Disable
//     0b0 ==> Prefetching for this master is enabled.
//     0b1 ==> Prefetching for this master is disabled.

#define  FMC_PFAPR_M3PFD             BIT19
//   Master 3 Prefetch Disable
//     0b0 ==> Prefetching for this master is enabled.
//     0b1 ==> Prefetching for this master is disabled.

#define  FMC_PFB0CR_B0SEBE           BIT0
//   Bank 0 Single Entry Buffer Enable
//     0b0 ==> Single entry buffer is disabled.
//     0b1 ==> Single entry buffer is enabled.

#define  FMC_PFB0CR_B0IPE            BIT1
//   Bank 0 Instruction Prefetch Enable
//     0b0 ==> Do not prefetch in response to instruction fetches.
//     0b1 ==> Enable prefetches in response to instruction fetches.

#define  FMC_PFB0CR_B0DPE            BIT2
//   Bank 0 Data Prefetch Enable
//     0b0 ==> Do not prefetch in response to data references.
//     0b1 ==> Enable prefetches in response to data references.

#define  FMC_PFB0CR_B0ICE            BIT3
//   Bank 0 Instruction Cache Enable
//     0b0 ==> Do not cache instruction fetches.
//     0b1 ==> Cache instruction fetches.

#define  FMC_PFB0CR_B0DCE            BIT4
//   Bank 0 Data Cache Enable
//     0b0 ==> Do not cache data references.
//     0b1 ==> Cache data references.

#define  FMC_PFB0CR_CRC              (BIT5|BIT6|BIT7)
//   Cache Replacement Control
//     0b000 ==> LRU replacement algorithm per set across all four ways
//     0b001 ==> Reserved
//     0b010 ==> Independent LRU with ways [0-1] for ifetches, [2-3] for data
//     0b011 ==> Independent LRU with ways [0-2] for ifetches, [3] for data
//     0b1xx ==> Reserved
#define  FMC_PFB0CR_CRC_0            BIT5
#define  FMC_PFB0CR_CRC_1            BIT6
#define  FMC_PFB0CR_CRC_2            BIT7

#define  FMC_PFB0CR_B0MW             (BIT17|BIT18)
//   Bank 0 Memory Width
//     0b00 ==> 32 bits
//     0b01 ==> 64 bits
//     0b1x ==> Reserved
#define  FMC_PFB0CR_B0MW_0           BIT17
#define  FMC_PFB0CR_B0MW_1           BIT18

#define  FMC_PFB0CR_S_B_INV          BIT19
//   Invalidate Prefetch Speculation Buffer
//     0b0 ==> Speculation buffer and single entry buffer are not affected.
//     0b1 ==> Invalidate (clear) speculation buffer and single entry buffer.

#define  FMC_PFB0CR_CINV_WAY         (BIT20|BIT21|BIT22|BIT23)
//   Cache Invalidate Way x
//     0b0 ==> No cache way invalidation for the corresponding cache
//     0b1 ==> Invalidate cache way for the corresponding cache: clear the tag, data, and vld bits of ways selected
#define  FMC_PFB0CR_CINV_WAY_0       BIT20
#define  FMC_PFB0CR_CINV_WAY_1       BIT21
#define  FMC_PFB0CR_CINV_WAY_2       BIT22
#define  FMC_PFB0CR_CINV_WAY_3       BIT23

#define  FMC_PFB0CR_CLCK_WAY         (BIT24|BIT25|BIT26|BIT27)
//   Cache Lock Way x
//     0b0 ==> Cache way is unlocked and may be displaced
//     0b1 ==> Cache way is locked and its contents are not displaced
#define  FMC_PFB0CR_CLCK_WAY_0       BIT24
#define  FMC_PFB0CR_CLCK_WAY_1       BIT25
#define  FMC_PFB0CR_CLCK_WAY_2       BIT26
#define  FMC_PFB0CR_CLCK_WAY_3       BIT27

#define  FMC_PFB0CR_B0RWSC           (BIT28|BIT29|BIT30|BIT31)
//   Bank 0 Read Wait State Control
#define  FMC_PFB0CR_B0RWSC_0         BIT28
#define  FMC_PFB0CR_B0RWSC_1         BIT29
#define  FMC_PFB0CR_B0RWSC_2         BIT30
#define  FMC_PFB0CR_B0RWSC_3         BIT31

#define  FMC_PFB1CR_B1MW             (BIT17|BIT18)
//   Bank 1 Memory Width
//     0b00 ==> 32 bits
//     0b01 ==> 64 bits
//     0b10 ==> Reserved
//     0b11 ==> Reserved
#define  FMC_PFB1CR_B1MW_0           BIT17
#define  FMC_PFB1CR_B1MW_1           BIT18

#define  FMC_PFB1CR_B1RWSC           (BIT28|BIT29|BIT30|BIT31)
//   Bank 1 Read Wait State Control
#define  FMC_PFB1CR_B1RWSC_0         BIT28
#define  FMC_PFB1CR_B1RWSC_1         BIT29
#define  FMC_PFB1CR_B1RWSC_2         BIT30
#define  FMC_PFB1CR_B1RWSC_3         BIT31

#define  FMC_TAGVDW0S0_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW0S0_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW0S0_tag_0         BIT6
#define  FMC_TAGVDW0S0_tag_1         BIT7
#define  FMC_TAGVDW0S0_tag_2         BIT8
#define  FMC_TAGVDW0S0_tag_3         BIT9
#define  FMC_TAGVDW0S0_tag_4         BIT10
#define  FMC_TAGVDW0S0_tag_5         BIT11
#define  FMC_TAGVDW0S0_tag_6         BIT12
#define  FMC_TAGVDW0S0_tag_7         BIT13
#define  FMC_TAGVDW0S0_tag_8         BIT14
#define  FMC_TAGVDW0S0_tag_9         BIT15
#define  FMC_TAGVDW0S0_tag_10        BIT16
#define  FMC_TAGVDW0S0_tag_11        BIT17
#define  FMC_TAGVDW0S0_tag_12        BIT18

#define  FMC_TAGVDW0S1_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW0S1_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW0S1_tag_0         BIT6
#define  FMC_TAGVDW0S1_tag_1         BIT7
#define  FMC_TAGVDW0S1_tag_2         BIT8
#define  FMC_TAGVDW0S1_tag_3         BIT9
#define  FMC_TAGVDW0S1_tag_4         BIT10
#define  FMC_TAGVDW0S1_tag_5         BIT11
#define  FMC_TAGVDW0S1_tag_6         BIT12
#define  FMC_TAGVDW0S1_tag_7         BIT13
#define  FMC_TAGVDW0S1_tag_8         BIT14
#define  FMC_TAGVDW0S1_tag_9         BIT15
#define  FMC_TAGVDW0S1_tag_10        BIT16
#define  FMC_TAGVDW0S1_tag_11        BIT17
#define  FMC_TAGVDW0S1_tag_12        BIT18

#define  FMC_TAGVDW0S2_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW0S2_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW0S2_tag_0         BIT6
#define  FMC_TAGVDW0S2_tag_1         BIT7
#define  FMC_TAGVDW0S2_tag_2         BIT8
#define  FMC_TAGVDW0S2_tag_3         BIT9
#define  FMC_TAGVDW0S2_tag_4         BIT10
#define  FMC_TAGVDW0S2_tag_5         BIT11
#define  FMC_TAGVDW0S2_tag_6         BIT12
#define  FMC_TAGVDW0S2_tag_7         BIT13
#define  FMC_TAGVDW0S2_tag_8         BIT14
#define  FMC_TAGVDW0S2_tag_9         BIT15
#define  FMC_TAGVDW0S2_tag_10        BIT16
#define  FMC_TAGVDW0S2_tag_11        BIT17
#define  FMC_TAGVDW0S2_tag_12        BIT18

#define  FMC_TAGVDW0S3_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW0S3_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW0S3_tag_0         BIT6
#define  FMC_TAGVDW0S3_tag_1         BIT7
#define  FMC_TAGVDW0S3_tag_2         BIT8
#define  FMC_TAGVDW0S3_tag_3         BIT9
#define  FMC_TAGVDW0S3_tag_4         BIT10
#define  FMC_TAGVDW0S3_tag_5         BIT11
#define  FMC_TAGVDW0S3_tag_6         BIT12
#define  FMC_TAGVDW0S3_tag_7         BIT13
#define  FMC_TAGVDW0S3_tag_8         BIT14
#define  FMC_TAGVDW0S3_tag_9         BIT15
#define  FMC_TAGVDW0S3_tag_10        BIT16
#define  FMC_TAGVDW0S3_tag_11        BIT17
#define  FMC_TAGVDW0S3_tag_12        BIT18

#define  FMC_TAGVDW0S4_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW0S4_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW0S4_tag_0         BIT6
#define  FMC_TAGVDW0S4_tag_1         BIT7
#define  FMC_TAGVDW0S4_tag_2         BIT8
#define  FMC_TAGVDW0S4_tag_3         BIT9
#define  FMC_TAGVDW0S4_tag_4         BIT10
#define  FMC_TAGVDW0S4_tag_5         BIT11
#define  FMC_TAGVDW0S4_tag_6         BIT12
#define  FMC_TAGVDW0S4_tag_7         BIT13
#define  FMC_TAGVDW0S4_tag_8         BIT14
#define  FMC_TAGVDW0S4_tag_9         BIT15
#define  FMC_TAGVDW0S4_tag_10        BIT16
#define  FMC_TAGVDW0S4_tag_11        BIT17
#define  FMC_TAGVDW0S4_tag_12        BIT18

#define  FMC_TAGVDW0S5_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW0S5_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW0S5_tag_0         BIT6
#define  FMC_TAGVDW0S5_tag_1         BIT7
#define  FMC_TAGVDW0S5_tag_2         BIT8
#define  FMC_TAGVDW0S5_tag_3         BIT9
#define  FMC_TAGVDW0S5_tag_4         BIT10
#define  FMC_TAGVDW0S5_tag_5         BIT11
#define  FMC_TAGVDW0S5_tag_6         BIT12
#define  FMC_TAGVDW0S5_tag_7         BIT13
#define  FMC_TAGVDW0S5_tag_8         BIT14
#define  FMC_TAGVDW0S5_tag_9         BIT15
#define  FMC_TAGVDW0S5_tag_10        BIT16
#define  FMC_TAGVDW0S5_tag_11        BIT17
#define  FMC_TAGVDW0S5_tag_12        BIT18

#define  FMC_TAGVDW0S6_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW0S6_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW0S6_tag_0         BIT6
#define  FMC_TAGVDW0S6_tag_1         BIT7
#define  FMC_TAGVDW0S6_tag_2         BIT8
#define  FMC_TAGVDW0S6_tag_3         BIT9
#define  FMC_TAGVDW0S6_tag_4         BIT10
#define  FMC_TAGVDW0S6_tag_5         BIT11
#define  FMC_TAGVDW0S6_tag_6         BIT12
#define  FMC_TAGVDW0S6_tag_7         BIT13
#define  FMC_TAGVDW0S6_tag_8         BIT14
#define  FMC_TAGVDW0S6_tag_9         BIT15
#define  FMC_TAGVDW0S6_tag_10        BIT16
#define  FMC_TAGVDW0S6_tag_11        BIT17
#define  FMC_TAGVDW0S6_tag_12        BIT18

#define  FMC_TAGVDW0S7_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW0S7_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW0S7_tag_0         BIT6
#define  FMC_TAGVDW0S7_tag_1         BIT7
#define  FMC_TAGVDW0S7_tag_2         BIT8
#define  FMC_TAGVDW0S7_tag_3         BIT9
#define  FMC_TAGVDW0S7_tag_4         BIT10
#define  FMC_TAGVDW0S7_tag_5         BIT11
#define  FMC_TAGVDW0S7_tag_6         BIT12
#define  FMC_TAGVDW0S7_tag_7         BIT13
#define  FMC_TAGVDW0S7_tag_8         BIT14
#define  FMC_TAGVDW0S7_tag_9         BIT15
#define  FMC_TAGVDW0S7_tag_10        BIT16
#define  FMC_TAGVDW0S7_tag_11        BIT17
#define  FMC_TAGVDW0S7_tag_12        BIT18

#define  FMC_TAGVDW1S0_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW1S0_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW1S0_tag_0         BIT6
#define  FMC_TAGVDW1S0_tag_1         BIT7
#define  FMC_TAGVDW1S0_tag_2         BIT8
#define  FMC_TAGVDW1S0_tag_3         BIT9
#define  FMC_TAGVDW1S0_tag_4         BIT10
#define  FMC_TAGVDW1S0_tag_5         BIT11
#define  FMC_TAGVDW1S0_tag_6         BIT12
#define  FMC_TAGVDW1S0_tag_7         BIT13
#define  FMC_TAGVDW1S0_tag_8         BIT14
#define  FMC_TAGVDW1S0_tag_9         BIT15
#define  FMC_TAGVDW1S0_tag_10        BIT16
#define  FMC_TAGVDW1S0_tag_11        BIT17
#define  FMC_TAGVDW1S0_tag_12        BIT18

#define  FMC_TAGVDW1S1_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW1S1_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW1S1_tag_0         BIT6
#define  FMC_TAGVDW1S1_tag_1         BIT7
#define  FMC_TAGVDW1S1_tag_2         BIT8
#define  FMC_TAGVDW1S1_tag_3         BIT9
#define  FMC_TAGVDW1S1_tag_4         BIT10
#define  FMC_TAGVDW1S1_tag_5         BIT11
#define  FMC_TAGVDW1S1_tag_6         BIT12
#define  FMC_TAGVDW1S1_tag_7         BIT13
#define  FMC_TAGVDW1S1_tag_8         BIT14
#define  FMC_TAGVDW1S1_tag_9         BIT15
#define  FMC_TAGVDW1S1_tag_10        BIT16
#define  FMC_TAGVDW1S1_tag_11        BIT17
#define  FMC_TAGVDW1S1_tag_12        BIT18

#define  FMC_TAGVDW1S2_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW1S2_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW1S2_tag_0         BIT6
#define  FMC_TAGVDW1S2_tag_1         BIT7
#define  FMC_TAGVDW1S2_tag_2         BIT8
#define  FMC_TAGVDW1S2_tag_3         BIT9
#define  FMC_TAGVDW1S2_tag_4         BIT10
#define  FMC_TAGVDW1S2_tag_5         BIT11
#define  FMC_TAGVDW1S2_tag_6         BIT12
#define  FMC_TAGVDW1S2_tag_7         BIT13
#define  FMC_TAGVDW1S2_tag_8         BIT14
#define  FMC_TAGVDW1S2_tag_9         BIT15
#define  FMC_TAGVDW1S2_tag_10        BIT16
#define  FMC_TAGVDW1S2_tag_11        BIT17
#define  FMC_TAGVDW1S2_tag_12        BIT18

#define  FMC_TAGVDW1S3_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW1S3_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW1S3_tag_0         BIT6
#define  FMC_TAGVDW1S3_tag_1         BIT7
#define  FMC_TAGVDW1S3_tag_2         BIT8
#define  FMC_TAGVDW1S3_tag_3         BIT9
#define  FMC_TAGVDW1S3_tag_4         BIT10
#define  FMC_TAGVDW1S3_tag_5         BIT11
#define  FMC_TAGVDW1S3_tag_6         BIT12
#define  FMC_TAGVDW1S3_tag_7         BIT13
#define  FMC_TAGVDW1S3_tag_8         BIT14
#define  FMC_TAGVDW1S3_tag_9         BIT15
#define  FMC_TAGVDW1S3_tag_10        BIT16
#define  FMC_TAGVDW1S3_tag_11        BIT17
#define  FMC_TAGVDW1S3_tag_12        BIT18

#define  FMC_TAGVDW1S4_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW1S4_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW1S4_tag_0         BIT6
#define  FMC_TAGVDW1S4_tag_1         BIT7
#define  FMC_TAGVDW1S4_tag_2         BIT8
#define  FMC_TAGVDW1S4_tag_3         BIT9
#define  FMC_TAGVDW1S4_tag_4         BIT10
#define  FMC_TAGVDW1S4_tag_5         BIT11
#define  FMC_TAGVDW1S4_tag_6         BIT12
#define  FMC_TAGVDW1S4_tag_7         BIT13
#define  FMC_TAGVDW1S4_tag_8         BIT14
#define  FMC_TAGVDW1S4_tag_9         BIT15
#define  FMC_TAGVDW1S4_tag_10        BIT16
#define  FMC_TAGVDW1S4_tag_11        BIT17
#define  FMC_TAGVDW1S4_tag_12        BIT18

#define  FMC_TAGVDW1S5_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW1S5_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW1S5_tag_0         BIT6
#define  FMC_TAGVDW1S5_tag_1         BIT7
#define  FMC_TAGVDW1S5_tag_2         BIT8
#define  FMC_TAGVDW1S5_tag_3         BIT9
#define  FMC_TAGVDW1S5_tag_4         BIT10
#define  FMC_TAGVDW1S5_tag_5         BIT11
#define  FMC_TAGVDW1S5_tag_6         BIT12
#define  FMC_TAGVDW1S5_tag_7         BIT13
#define  FMC_TAGVDW1S5_tag_8         BIT14
#define  FMC_TAGVDW1S5_tag_9         BIT15
#define  FMC_TAGVDW1S5_tag_10        BIT16
#define  FMC_TAGVDW1S5_tag_11        BIT17
#define  FMC_TAGVDW1S5_tag_12        BIT18

#define  FMC_TAGVDW1S6_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW1S6_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW1S6_tag_0         BIT6
#define  FMC_TAGVDW1S6_tag_1         BIT7
#define  FMC_TAGVDW1S6_tag_2         BIT8
#define  FMC_TAGVDW1S6_tag_3         BIT9
#define  FMC_TAGVDW1S6_tag_4         BIT10
#define  FMC_TAGVDW1S6_tag_5         BIT11
#define  FMC_TAGVDW1S6_tag_6         BIT12
#define  FMC_TAGVDW1S6_tag_7         BIT13
#define  FMC_TAGVDW1S6_tag_8         BIT14
#define  FMC_TAGVDW1S6_tag_9         BIT15
#define  FMC_TAGVDW1S6_tag_10        BIT16
#define  FMC_TAGVDW1S6_tag_11        BIT17
#define  FMC_TAGVDW1S6_tag_12        BIT18

#define  FMC_TAGVDW1S7_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW1S7_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW1S7_tag_0         BIT6
#define  FMC_TAGVDW1S7_tag_1         BIT7
#define  FMC_TAGVDW1S7_tag_2         BIT8
#define  FMC_TAGVDW1S7_tag_3         BIT9
#define  FMC_TAGVDW1S7_tag_4         BIT10
#define  FMC_TAGVDW1S7_tag_5         BIT11
#define  FMC_TAGVDW1S7_tag_6         BIT12
#define  FMC_TAGVDW1S7_tag_7         BIT13
#define  FMC_TAGVDW1S7_tag_8         BIT14
#define  FMC_TAGVDW1S7_tag_9         BIT15
#define  FMC_TAGVDW1S7_tag_10        BIT16
#define  FMC_TAGVDW1S7_tag_11        BIT17
#define  FMC_TAGVDW1S7_tag_12        BIT18

#define  FMC_TAGVDW2S0_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW2S0_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW2S0_tag_0         BIT6
#define  FMC_TAGVDW2S0_tag_1         BIT7
#define  FMC_TAGVDW2S0_tag_2         BIT8
#define  FMC_TAGVDW2S0_tag_3         BIT9
#define  FMC_TAGVDW2S0_tag_4         BIT10
#define  FMC_TAGVDW2S0_tag_5         BIT11
#define  FMC_TAGVDW2S0_tag_6         BIT12
#define  FMC_TAGVDW2S0_tag_7         BIT13
#define  FMC_TAGVDW2S0_tag_8         BIT14
#define  FMC_TAGVDW2S0_tag_9         BIT15
#define  FMC_TAGVDW2S0_tag_10        BIT16
#define  FMC_TAGVDW2S0_tag_11        BIT17
#define  FMC_TAGVDW2S0_tag_12        BIT18

#define  FMC_TAGVDW2S1_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW2S1_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW2S1_tag_0         BIT6
#define  FMC_TAGVDW2S1_tag_1         BIT7
#define  FMC_TAGVDW2S1_tag_2         BIT8
#define  FMC_TAGVDW2S1_tag_3         BIT9
#define  FMC_TAGVDW2S1_tag_4         BIT10
#define  FMC_TAGVDW2S1_tag_5         BIT11
#define  FMC_TAGVDW2S1_tag_6         BIT12
#define  FMC_TAGVDW2S1_tag_7         BIT13
#define  FMC_TAGVDW2S1_tag_8         BIT14
#define  FMC_TAGVDW2S1_tag_9         BIT15
#define  FMC_TAGVDW2S1_tag_10        BIT16
#define  FMC_TAGVDW2S1_tag_11        BIT17
#define  FMC_TAGVDW2S1_tag_12        BIT18

#define  FMC_TAGVDW2S2_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW2S2_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW2S2_tag_0         BIT6
#define  FMC_TAGVDW2S2_tag_1         BIT7
#define  FMC_TAGVDW2S2_tag_2         BIT8
#define  FMC_TAGVDW2S2_tag_3         BIT9
#define  FMC_TAGVDW2S2_tag_4         BIT10
#define  FMC_TAGVDW2S2_tag_5         BIT11
#define  FMC_TAGVDW2S2_tag_6         BIT12
#define  FMC_TAGVDW2S2_tag_7         BIT13
#define  FMC_TAGVDW2S2_tag_8         BIT14
#define  FMC_TAGVDW2S2_tag_9         BIT15
#define  FMC_TAGVDW2S2_tag_10        BIT16
#define  FMC_TAGVDW2S2_tag_11        BIT17
#define  FMC_TAGVDW2S2_tag_12        BIT18

#define  FMC_TAGVDW2S3_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW2S3_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW2S3_tag_0         BIT6
#define  FMC_TAGVDW2S3_tag_1         BIT7
#define  FMC_TAGVDW2S3_tag_2         BIT8
#define  FMC_TAGVDW2S3_tag_3         BIT9
#define  FMC_TAGVDW2S3_tag_4         BIT10
#define  FMC_TAGVDW2S3_tag_5         BIT11
#define  FMC_TAGVDW2S3_tag_6         BIT12
#define  FMC_TAGVDW2S3_tag_7         BIT13
#define  FMC_TAGVDW2S3_tag_8         BIT14
#define  FMC_TAGVDW2S3_tag_9         BIT15
#define  FMC_TAGVDW2S3_tag_10        BIT16
#define  FMC_TAGVDW2S3_tag_11        BIT17
#define  FMC_TAGVDW2S3_tag_12        BIT18

#define  FMC_TAGVDW2S4_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW2S4_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW2S4_tag_0         BIT6
#define  FMC_TAGVDW2S4_tag_1         BIT7
#define  FMC_TAGVDW2S4_tag_2         BIT8
#define  FMC_TAGVDW2S4_tag_3         BIT9
#define  FMC_TAGVDW2S4_tag_4         BIT10
#define  FMC_TAGVDW2S4_tag_5         BIT11
#define  FMC_TAGVDW2S4_tag_6         BIT12
#define  FMC_TAGVDW2S4_tag_7         BIT13
#define  FMC_TAGVDW2S4_tag_8         BIT14
#define  FMC_TAGVDW2S4_tag_9         BIT15
#define  FMC_TAGVDW2S4_tag_10        BIT16
#define  FMC_TAGVDW2S4_tag_11        BIT17
#define  FMC_TAGVDW2S4_tag_12        BIT18

#define  FMC_TAGVDW2S5_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW2S5_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW2S5_tag_0         BIT6
#define  FMC_TAGVDW2S5_tag_1         BIT7
#define  FMC_TAGVDW2S5_tag_2         BIT8
#define  FMC_TAGVDW2S5_tag_3         BIT9
#define  FMC_TAGVDW2S5_tag_4         BIT10
#define  FMC_TAGVDW2S5_tag_5         BIT11
#define  FMC_TAGVDW2S5_tag_6         BIT12
#define  FMC_TAGVDW2S5_tag_7         BIT13
#define  FMC_TAGVDW2S5_tag_8         BIT14
#define  FMC_TAGVDW2S5_tag_9         BIT15
#define  FMC_TAGVDW2S5_tag_10        BIT16
#define  FMC_TAGVDW2S5_tag_11        BIT17
#define  FMC_TAGVDW2S5_tag_12        BIT18

#define  FMC_TAGVDW2S6_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW2S6_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW2S6_tag_0         BIT6
#define  FMC_TAGVDW2S6_tag_1         BIT7
#define  FMC_TAGVDW2S6_tag_2         BIT8
#define  FMC_TAGVDW2S6_tag_3         BIT9
#define  FMC_TAGVDW2S6_tag_4         BIT10
#define  FMC_TAGVDW2S6_tag_5         BIT11
#define  FMC_TAGVDW2S6_tag_6         BIT12
#define  FMC_TAGVDW2S6_tag_7         BIT13
#define  FMC_TAGVDW2S6_tag_8         BIT14
#define  FMC_TAGVDW2S6_tag_9         BIT15
#define  FMC_TAGVDW2S6_tag_10        BIT16
#define  FMC_TAGVDW2S6_tag_11        BIT17
#define  FMC_TAGVDW2S6_tag_12        BIT18

#define  FMC_TAGVDW2S7_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW2S7_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW2S7_tag_0         BIT6
#define  FMC_TAGVDW2S7_tag_1         BIT7
#define  FMC_TAGVDW2S7_tag_2         BIT8
#define  FMC_TAGVDW2S7_tag_3         BIT9
#define  FMC_TAGVDW2S7_tag_4         BIT10
#define  FMC_TAGVDW2S7_tag_5         BIT11
#define  FMC_TAGVDW2S7_tag_6         BIT12
#define  FMC_TAGVDW2S7_tag_7         BIT13
#define  FMC_TAGVDW2S7_tag_8         BIT14
#define  FMC_TAGVDW2S7_tag_9         BIT15
#define  FMC_TAGVDW2S7_tag_10        BIT16
#define  FMC_TAGVDW2S7_tag_11        BIT17
#define  FMC_TAGVDW2S7_tag_12        BIT18

#define  FMC_TAGVDW3S0_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW3S0_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW3S0_tag_0         BIT6
#define  FMC_TAGVDW3S0_tag_1         BIT7
#define  FMC_TAGVDW3S0_tag_2         BIT8
#define  FMC_TAGVDW3S0_tag_3         BIT9
#define  FMC_TAGVDW3S0_tag_4         BIT10
#define  FMC_TAGVDW3S0_tag_5         BIT11
#define  FMC_TAGVDW3S0_tag_6         BIT12
#define  FMC_TAGVDW3S0_tag_7         BIT13
#define  FMC_TAGVDW3S0_tag_8         BIT14
#define  FMC_TAGVDW3S0_tag_9         BIT15
#define  FMC_TAGVDW3S0_tag_10        BIT16
#define  FMC_TAGVDW3S0_tag_11        BIT17
#define  FMC_TAGVDW3S0_tag_12        BIT18

#define  FMC_TAGVDW3S1_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW3S1_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW3S1_tag_0         BIT6
#define  FMC_TAGVDW3S1_tag_1         BIT7
#define  FMC_TAGVDW3S1_tag_2         BIT8
#define  FMC_TAGVDW3S1_tag_3         BIT9
#define  FMC_TAGVDW3S1_tag_4         BIT10
#define  FMC_TAGVDW3S1_tag_5         BIT11
#define  FMC_TAGVDW3S1_tag_6         BIT12
#define  FMC_TAGVDW3S1_tag_7         BIT13
#define  FMC_TAGVDW3S1_tag_8         BIT14
#define  FMC_TAGVDW3S1_tag_9         BIT15
#define  FMC_TAGVDW3S1_tag_10        BIT16
#define  FMC_TAGVDW3S1_tag_11        BIT17
#define  FMC_TAGVDW3S1_tag_12        BIT18

#define  FMC_TAGVDW3S2_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW3S2_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW3S2_tag_0         BIT6
#define  FMC_TAGVDW3S2_tag_1         BIT7
#define  FMC_TAGVDW3S2_tag_2         BIT8
#define  FMC_TAGVDW3S2_tag_3         BIT9
#define  FMC_TAGVDW3S2_tag_4         BIT10
#define  FMC_TAGVDW3S2_tag_5         BIT11
#define  FMC_TAGVDW3S2_tag_6         BIT12
#define  FMC_TAGVDW3S2_tag_7         BIT13
#define  FMC_TAGVDW3S2_tag_8         BIT14
#define  FMC_TAGVDW3S2_tag_9         BIT15
#define  FMC_TAGVDW3S2_tag_10        BIT16
#define  FMC_TAGVDW3S2_tag_11        BIT17
#define  FMC_TAGVDW3S2_tag_12        BIT18

#define  FMC_TAGVDW3S3_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW3S3_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW3S3_tag_0         BIT6
#define  FMC_TAGVDW3S3_tag_1         BIT7
#define  FMC_TAGVDW3S3_tag_2         BIT8
#define  FMC_TAGVDW3S3_tag_3         BIT9
#define  FMC_TAGVDW3S3_tag_4         BIT10
#define  FMC_TAGVDW3S3_tag_5         BIT11
#define  FMC_TAGVDW3S3_tag_6         BIT12
#define  FMC_TAGVDW3S3_tag_7         BIT13
#define  FMC_TAGVDW3S3_tag_8         BIT14
#define  FMC_TAGVDW3S3_tag_9         BIT15
#define  FMC_TAGVDW3S3_tag_10        BIT16
#define  FMC_TAGVDW3S3_tag_11        BIT17
#define  FMC_TAGVDW3S3_tag_12        BIT18

#define  FMC_TAGVDW3S4_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW3S4_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW3S4_tag_0         BIT6
#define  FMC_TAGVDW3S4_tag_1         BIT7
#define  FMC_TAGVDW3S4_tag_2         BIT8
#define  FMC_TAGVDW3S4_tag_3         BIT9
#define  FMC_TAGVDW3S4_tag_4         BIT10
#define  FMC_TAGVDW3S4_tag_5         BIT11
#define  FMC_TAGVDW3S4_tag_6         BIT12
#define  FMC_TAGVDW3S4_tag_7         BIT13
#define  FMC_TAGVDW3S4_tag_8         BIT14
#define  FMC_TAGVDW3S4_tag_9         BIT15
#define  FMC_TAGVDW3S4_tag_10        BIT16
#define  FMC_TAGVDW3S4_tag_11        BIT17
#define  FMC_TAGVDW3S4_tag_12        BIT18

#define  FMC_TAGVDW3S5_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW3S5_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW3S5_tag_0         BIT6
#define  FMC_TAGVDW3S5_tag_1         BIT7
#define  FMC_TAGVDW3S5_tag_2         BIT8
#define  FMC_TAGVDW3S5_tag_3         BIT9
#define  FMC_TAGVDW3S5_tag_4         BIT10
#define  FMC_TAGVDW3S5_tag_5         BIT11
#define  FMC_TAGVDW3S5_tag_6         BIT12
#define  FMC_TAGVDW3S5_tag_7         BIT13
#define  FMC_TAGVDW3S5_tag_8         BIT14
#define  FMC_TAGVDW3S5_tag_9         BIT15
#define  FMC_TAGVDW3S5_tag_10        BIT16
#define  FMC_TAGVDW3S5_tag_11        BIT17
#define  FMC_TAGVDW3S5_tag_12        BIT18

#define  FMC_TAGVDW3S6_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW3S6_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW3S6_tag_0         BIT6
#define  FMC_TAGVDW3S6_tag_1         BIT7
#define  FMC_TAGVDW3S6_tag_2         BIT8
#define  FMC_TAGVDW3S6_tag_3         BIT9
#define  FMC_TAGVDW3S6_tag_4         BIT10
#define  FMC_TAGVDW3S6_tag_5         BIT11
#define  FMC_TAGVDW3S6_tag_6         BIT12
#define  FMC_TAGVDW3S6_tag_7         BIT13
#define  FMC_TAGVDW3S6_tag_8         BIT14
#define  FMC_TAGVDW3S6_tag_9         BIT15
#define  FMC_TAGVDW3S6_tag_10        BIT16
#define  FMC_TAGVDW3S6_tag_11        BIT17
#define  FMC_TAGVDW3S6_tag_12        BIT18

#define  FMC_TAGVDW3S7_valid         BIT0
//   1-bit valid for cache entry

#define  FMC_TAGVDW3S7_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
//   13-bit tag for cache entry
#define  FMC_TAGVDW3S7_tag_0         BIT6
#define  FMC_TAGVDW3S7_tag_1         BIT7
#define  FMC_TAGVDW3S7_tag_2         BIT8
#define  FMC_TAGVDW3S7_tag_3         BIT9
#define  FMC_TAGVDW3S7_tag_4         BIT10
#define  FMC_TAGVDW3S7_tag_5         BIT11
#define  FMC_TAGVDW3S7_tag_6         BIT12
#define  FMC_TAGVDW3S7_tag_7         BIT13
#define  FMC_TAGVDW3S7_tag_8         BIT14
#define  FMC_TAGVDW3S7_tag_9         BIT15
#define  FMC_TAGVDW3S7_tag_10        BIT16
#define  FMC_TAGVDW3S7_tag_11        BIT17
#define  FMC_TAGVDW3S7_tag_12        BIT18

#define  FMC_DATAW0S0U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW0S0U_data_0        BIT0
#define  FMC_DATAW0S0U_data_1        BIT1
#define  FMC_DATAW0S0U_data_2        BIT2
#define  FMC_DATAW0S0U_data_3        BIT3
#define  FMC_DATAW0S0U_data_4        BIT4
#define  FMC_DATAW0S0U_data_5        BIT5
#define  FMC_DATAW0S0U_data_6        BIT6
#define  FMC_DATAW0S0U_data_7        BIT7
#define  FMC_DATAW0S0U_data_8        BIT8
#define  FMC_DATAW0S0U_data_9        BIT9
#define  FMC_DATAW0S0U_data_10       BIT10
#define  FMC_DATAW0S0U_data_11       BIT11
#define  FMC_DATAW0S0U_data_12       BIT12
#define  FMC_DATAW0S0U_data_13       BIT13
#define  FMC_DATAW0S0U_data_14       BIT14
#define  FMC_DATAW0S0U_data_15       BIT15
#define  FMC_DATAW0S0U_data_16       BIT16
#define  FMC_DATAW0S0U_data_17       BIT17
#define  FMC_DATAW0S0U_data_18       BIT18
#define  FMC_DATAW0S0U_data_19       BIT19
#define  FMC_DATAW0S0U_data_20       BIT20
#define  FMC_DATAW0S0U_data_21       BIT21
#define  FMC_DATAW0S0U_data_22       BIT22
#define  FMC_DATAW0S0U_data_23       BIT23
#define  FMC_DATAW0S0U_data_24       BIT24
#define  FMC_DATAW0S0U_data_25       BIT25
#define  FMC_DATAW0S0U_data_26       BIT26
#define  FMC_DATAW0S0U_data_27       BIT27
#define  FMC_DATAW0S0U_data_28       BIT28
#define  FMC_DATAW0S0U_data_29       BIT29
#define  FMC_DATAW0S0U_data_30       BIT30
#define  FMC_DATAW0S0U_data_31       BIT31

#define  FMC_DATAW0S0L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW0S0L_data_0        BIT0
#define  FMC_DATAW0S0L_data_1        BIT1
#define  FMC_DATAW0S0L_data_2        BIT2
#define  FMC_DATAW0S0L_data_3        BIT3
#define  FMC_DATAW0S0L_data_4        BIT4
#define  FMC_DATAW0S0L_data_5        BIT5
#define  FMC_DATAW0S0L_data_6        BIT6
#define  FMC_DATAW0S0L_data_7        BIT7
#define  FMC_DATAW0S0L_data_8        BIT8
#define  FMC_DATAW0S0L_data_9        BIT9
#define  FMC_DATAW0S0L_data_10       BIT10
#define  FMC_DATAW0S0L_data_11       BIT11
#define  FMC_DATAW0S0L_data_12       BIT12
#define  FMC_DATAW0S0L_data_13       BIT13
#define  FMC_DATAW0S0L_data_14       BIT14
#define  FMC_DATAW0S0L_data_15       BIT15
#define  FMC_DATAW0S0L_data_16       BIT16
#define  FMC_DATAW0S0L_data_17       BIT17
#define  FMC_DATAW0S0L_data_18       BIT18
#define  FMC_DATAW0S0L_data_19       BIT19
#define  FMC_DATAW0S0L_data_20       BIT20
#define  FMC_DATAW0S0L_data_21       BIT21
#define  FMC_DATAW0S0L_data_22       BIT22
#define  FMC_DATAW0S0L_data_23       BIT23
#define  FMC_DATAW0S0L_data_24       BIT24
#define  FMC_DATAW0S0L_data_25       BIT25
#define  FMC_DATAW0S0L_data_26       BIT26
#define  FMC_DATAW0S0L_data_27       BIT27
#define  FMC_DATAW0S0L_data_28       BIT28
#define  FMC_DATAW0S0L_data_29       BIT29
#define  FMC_DATAW0S0L_data_30       BIT30
#define  FMC_DATAW0S0L_data_31       BIT31

#define  FMC_DATAW0S1U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW0S1U_data_0        BIT0
#define  FMC_DATAW0S1U_data_1        BIT1
#define  FMC_DATAW0S1U_data_2        BIT2
#define  FMC_DATAW0S1U_data_3        BIT3
#define  FMC_DATAW0S1U_data_4        BIT4
#define  FMC_DATAW0S1U_data_5        BIT5
#define  FMC_DATAW0S1U_data_6        BIT6
#define  FMC_DATAW0S1U_data_7        BIT7
#define  FMC_DATAW0S1U_data_8        BIT8
#define  FMC_DATAW0S1U_data_9        BIT9
#define  FMC_DATAW0S1U_data_10       BIT10
#define  FMC_DATAW0S1U_data_11       BIT11
#define  FMC_DATAW0S1U_data_12       BIT12
#define  FMC_DATAW0S1U_data_13       BIT13
#define  FMC_DATAW0S1U_data_14       BIT14
#define  FMC_DATAW0S1U_data_15       BIT15
#define  FMC_DATAW0S1U_data_16       BIT16
#define  FMC_DATAW0S1U_data_17       BIT17
#define  FMC_DATAW0S1U_data_18       BIT18
#define  FMC_DATAW0S1U_data_19       BIT19
#define  FMC_DATAW0S1U_data_20       BIT20
#define  FMC_DATAW0S1U_data_21       BIT21
#define  FMC_DATAW0S1U_data_22       BIT22
#define  FMC_DATAW0S1U_data_23       BIT23
#define  FMC_DATAW0S1U_data_24       BIT24
#define  FMC_DATAW0S1U_data_25       BIT25
#define  FMC_DATAW0S1U_data_26       BIT26
#define  FMC_DATAW0S1U_data_27       BIT27
#define  FMC_DATAW0S1U_data_28       BIT28
#define  FMC_DATAW0S1U_data_29       BIT29
#define  FMC_DATAW0S1U_data_30       BIT30
#define  FMC_DATAW0S1U_data_31       BIT31

#define  FMC_DATAW0S1L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW0S1L_data_0        BIT0
#define  FMC_DATAW0S1L_data_1        BIT1
#define  FMC_DATAW0S1L_data_2        BIT2
#define  FMC_DATAW0S1L_data_3        BIT3
#define  FMC_DATAW0S1L_data_4        BIT4
#define  FMC_DATAW0S1L_data_5        BIT5
#define  FMC_DATAW0S1L_data_6        BIT6
#define  FMC_DATAW0S1L_data_7        BIT7
#define  FMC_DATAW0S1L_data_8        BIT8
#define  FMC_DATAW0S1L_data_9        BIT9
#define  FMC_DATAW0S1L_data_10       BIT10
#define  FMC_DATAW0S1L_data_11       BIT11
#define  FMC_DATAW0S1L_data_12       BIT12
#define  FMC_DATAW0S1L_data_13       BIT13
#define  FMC_DATAW0S1L_data_14       BIT14
#define  FMC_DATAW0S1L_data_15       BIT15
#define  FMC_DATAW0S1L_data_16       BIT16
#define  FMC_DATAW0S1L_data_17       BIT17
#define  FMC_DATAW0S1L_data_18       BIT18
#define  FMC_DATAW0S1L_data_19       BIT19
#define  FMC_DATAW0S1L_data_20       BIT20
#define  FMC_DATAW0S1L_data_21       BIT21
#define  FMC_DATAW0S1L_data_22       BIT22
#define  FMC_DATAW0S1L_data_23       BIT23
#define  FMC_DATAW0S1L_data_24       BIT24
#define  FMC_DATAW0S1L_data_25       BIT25
#define  FMC_DATAW0S1L_data_26       BIT26
#define  FMC_DATAW0S1L_data_27       BIT27
#define  FMC_DATAW0S1L_data_28       BIT28
#define  FMC_DATAW0S1L_data_29       BIT29
#define  FMC_DATAW0S1L_data_30       BIT30
#define  FMC_DATAW0S1L_data_31       BIT31

#define  FMC_DATAW0S2U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW0S2U_data_0        BIT0
#define  FMC_DATAW0S2U_data_1        BIT1
#define  FMC_DATAW0S2U_data_2        BIT2
#define  FMC_DATAW0S2U_data_3        BIT3
#define  FMC_DATAW0S2U_data_4        BIT4
#define  FMC_DATAW0S2U_data_5        BIT5
#define  FMC_DATAW0S2U_data_6        BIT6
#define  FMC_DATAW0S2U_data_7        BIT7
#define  FMC_DATAW0S2U_data_8        BIT8
#define  FMC_DATAW0S2U_data_9        BIT9
#define  FMC_DATAW0S2U_data_10       BIT10
#define  FMC_DATAW0S2U_data_11       BIT11
#define  FMC_DATAW0S2U_data_12       BIT12
#define  FMC_DATAW0S2U_data_13       BIT13
#define  FMC_DATAW0S2U_data_14       BIT14
#define  FMC_DATAW0S2U_data_15       BIT15
#define  FMC_DATAW0S2U_data_16       BIT16
#define  FMC_DATAW0S2U_data_17       BIT17
#define  FMC_DATAW0S2U_data_18       BIT18
#define  FMC_DATAW0S2U_data_19       BIT19
#define  FMC_DATAW0S2U_data_20       BIT20
#define  FMC_DATAW0S2U_data_21       BIT21
#define  FMC_DATAW0S2U_data_22       BIT22
#define  FMC_DATAW0S2U_data_23       BIT23
#define  FMC_DATAW0S2U_data_24       BIT24
#define  FMC_DATAW0S2U_data_25       BIT25
#define  FMC_DATAW0S2U_data_26       BIT26
#define  FMC_DATAW0S2U_data_27       BIT27
#define  FMC_DATAW0S2U_data_28       BIT28
#define  FMC_DATAW0S2U_data_29       BIT29
#define  FMC_DATAW0S2U_data_30       BIT30
#define  FMC_DATAW0S2U_data_31       BIT31

#define  FMC_DATAW0S2L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW0S2L_data_0        BIT0
#define  FMC_DATAW0S2L_data_1        BIT1
#define  FMC_DATAW0S2L_data_2        BIT2
#define  FMC_DATAW0S2L_data_3        BIT3
#define  FMC_DATAW0S2L_data_4        BIT4
#define  FMC_DATAW0S2L_data_5        BIT5
#define  FMC_DATAW0S2L_data_6        BIT6
#define  FMC_DATAW0S2L_data_7        BIT7
#define  FMC_DATAW0S2L_data_8        BIT8
#define  FMC_DATAW0S2L_data_9        BIT9
#define  FMC_DATAW0S2L_data_10       BIT10
#define  FMC_DATAW0S2L_data_11       BIT11
#define  FMC_DATAW0S2L_data_12       BIT12
#define  FMC_DATAW0S2L_data_13       BIT13
#define  FMC_DATAW0S2L_data_14       BIT14
#define  FMC_DATAW0S2L_data_15       BIT15
#define  FMC_DATAW0S2L_data_16       BIT16
#define  FMC_DATAW0S2L_data_17       BIT17
#define  FMC_DATAW0S2L_data_18       BIT18
#define  FMC_DATAW0S2L_data_19       BIT19
#define  FMC_DATAW0S2L_data_20       BIT20
#define  FMC_DATAW0S2L_data_21       BIT21
#define  FMC_DATAW0S2L_data_22       BIT22
#define  FMC_DATAW0S2L_data_23       BIT23
#define  FMC_DATAW0S2L_data_24       BIT24
#define  FMC_DATAW0S2L_data_25       BIT25
#define  FMC_DATAW0S2L_data_26       BIT26
#define  FMC_DATAW0S2L_data_27       BIT27
#define  FMC_DATAW0S2L_data_28       BIT28
#define  FMC_DATAW0S2L_data_29       BIT29
#define  FMC_DATAW0S2L_data_30       BIT30
#define  FMC_DATAW0S2L_data_31       BIT31

#define  FMC_DATAW0S3U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW0S3U_data_0        BIT0
#define  FMC_DATAW0S3U_data_1        BIT1
#define  FMC_DATAW0S3U_data_2        BIT2
#define  FMC_DATAW0S3U_data_3        BIT3
#define  FMC_DATAW0S3U_data_4        BIT4
#define  FMC_DATAW0S3U_data_5        BIT5
#define  FMC_DATAW0S3U_data_6        BIT6
#define  FMC_DATAW0S3U_data_7        BIT7
#define  FMC_DATAW0S3U_data_8        BIT8
#define  FMC_DATAW0S3U_data_9        BIT9
#define  FMC_DATAW0S3U_data_10       BIT10
#define  FMC_DATAW0S3U_data_11       BIT11
#define  FMC_DATAW0S3U_data_12       BIT12
#define  FMC_DATAW0S3U_data_13       BIT13
#define  FMC_DATAW0S3U_data_14       BIT14
#define  FMC_DATAW0S3U_data_15       BIT15
#define  FMC_DATAW0S3U_data_16       BIT16
#define  FMC_DATAW0S3U_data_17       BIT17
#define  FMC_DATAW0S3U_data_18       BIT18
#define  FMC_DATAW0S3U_data_19       BIT19
#define  FMC_DATAW0S3U_data_20       BIT20
#define  FMC_DATAW0S3U_data_21       BIT21
#define  FMC_DATAW0S3U_data_22       BIT22
#define  FMC_DATAW0S3U_data_23       BIT23
#define  FMC_DATAW0S3U_data_24       BIT24
#define  FMC_DATAW0S3U_data_25       BIT25
#define  FMC_DATAW0S3U_data_26       BIT26
#define  FMC_DATAW0S3U_data_27       BIT27
#define  FMC_DATAW0S3U_data_28       BIT28
#define  FMC_DATAW0S3U_data_29       BIT29
#define  FMC_DATAW0S3U_data_30       BIT30
#define  FMC_DATAW0S3U_data_31       BIT31

#define  FMC_DATAW0S3L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW0S3L_data_0        BIT0
#define  FMC_DATAW0S3L_data_1        BIT1
#define  FMC_DATAW0S3L_data_2        BIT2
#define  FMC_DATAW0S3L_data_3        BIT3
#define  FMC_DATAW0S3L_data_4        BIT4
#define  FMC_DATAW0S3L_data_5        BIT5
#define  FMC_DATAW0S3L_data_6        BIT6
#define  FMC_DATAW0S3L_data_7        BIT7
#define  FMC_DATAW0S3L_data_8        BIT8
#define  FMC_DATAW0S3L_data_9        BIT9
#define  FMC_DATAW0S3L_data_10       BIT10
#define  FMC_DATAW0S3L_data_11       BIT11
#define  FMC_DATAW0S3L_data_12       BIT12
#define  FMC_DATAW0S3L_data_13       BIT13
#define  FMC_DATAW0S3L_data_14       BIT14
#define  FMC_DATAW0S3L_data_15       BIT15
#define  FMC_DATAW0S3L_data_16       BIT16
#define  FMC_DATAW0S3L_data_17       BIT17
#define  FMC_DATAW0S3L_data_18       BIT18
#define  FMC_DATAW0S3L_data_19       BIT19
#define  FMC_DATAW0S3L_data_20       BIT20
#define  FMC_DATAW0S3L_data_21       BIT21
#define  FMC_DATAW0S3L_data_22       BIT22
#define  FMC_DATAW0S3L_data_23       BIT23
#define  FMC_DATAW0S3L_data_24       BIT24
#define  FMC_DATAW0S3L_data_25       BIT25
#define  FMC_DATAW0S3L_data_26       BIT26
#define  FMC_DATAW0S3L_data_27       BIT27
#define  FMC_DATAW0S3L_data_28       BIT28
#define  FMC_DATAW0S3L_data_29       BIT29
#define  FMC_DATAW0S3L_data_30       BIT30
#define  FMC_DATAW0S3L_data_31       BIT31

#define  FMC_DATAW0S4U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW0S4U_data_0        BIT0
#define  FMC_DATAW0S4U_data_1        BIT1
#define  FMC_DATAW0S4U_data_2        BIT2
#define  FMC_DATAW0S4U_data_3        BIT3
#define  FMC_DATAW0S4U_data_4        BIT4
#define  FMC_DATAW0S4U_data_5        BIT5
#define  FMC_DATAW0S4U_data_6        BIT6
#define  FMC_DATAW0S4U_data_7        BIT7
#define  FMC_DATAW0S4U_data_8        BIT8
#define  FMC_DATAW0S4U_data_9        BIT9
#define  FMC_DATAW0S4U_data_10       BIT10
#define  FMC_DATAW0S4U_data_11       BIT11
#define  FMC_DATAW0S4U_data_12       BIT12
#define  FMC_DATAW0S4U_data_13       BIT13
#define  FMC_DATAW0S4U_data_14       BIT14
#define  FMC_DATAW0S4U_data_15       BIT15
#define  FMC_DATAW0S4U_data_16       BIT16
#define  FMC_DATAW0S4U_data_17       BIT17
#define  FMC_DATAW0S4U_data_18       BIT18
#define  FMC_DATAW0S4U_data_19       BIT19
#define  FMC_DATAW0S4U_data_20       BIT20
#define  FMC_DATAW0S4U_data_21       BIT21
#define  FMC_DATAW0S4U_data_22       BIT22
#define  FMC_DATAW0S4U_data_23       BIT23
#define  FMC_DATAW0S4U_data_24       BIT24
#define  FMC_DATAW0S4U_data_25       BIT25
#define  FMC_DATAW0S4U_data_26       BIT26
#define  FMC_DATAW0S4U_data_27       BIT27
#define  FMC_DATAW0S4U_data_28       BIT28
#define  FMC_DATAW0S4U_data_29       BIT29
#define  FMC_DATAW0S4U_data_30       BIT30
#define  FMC_DATAW0S4U_data_31       BIT31

#define  FMC_DATAW0S4L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW0S4L_data_0        BIT0
#define  FMC_DATAW0S4L_data_1        BIT1
#define  FMC_DATAW0S4L_data_2        BIT2
#define  FMC_DATAW0S4L_data_3        BIT3
#define  FMC_DATAW0S4L_data_4        BIT4
#define  FMC_DATAW0S4L_data_5        BIT5
#define  FMC_DATAW0S4L_data_6        BIT6
#define  FMC_DATAW0S4L_data_7        BIT7
#define  FMC_DATAW0S4L_data_8        BIT8
#define  FMC_DATAW0S4L_data_9        BIT9
#define  FMC_DATAW0S4L_data_10       BIT10
#define  FMC_DATAW0S4L_data_11       BIT11
#define  FMC_DATAW0S4L_data_12       BIT12
#define  FMC_DATAW0S4L_data_13       BIT13
#define  FMC_DATAW0S4L_data_14       BIT14
#define  FMC_DATAW0S4L_data_15       BIT15
#define  FMC_DATAW0S4L_data_16       BIT16
#define  FMC_DATAW0S4L_data_17       BIT17
#define  FMC_DATAW0S4L_data_18       BIT18
#define  FMC_DATAW0S4L_data_19       BIT19
#define  FMC_DATAW0S4L_data_20       BIT20
#define  FMC_DATAW0S4L_data_21       BIT21
#define  FMC_DATAW0S4L_data_22       BIT22
#define  FMC_DATAW0S4L_data_23       BIT23
#define  FMC_DATAW0S4L_data_24       BIT24
#define  FMC_DATAW0S4L_data_25       BIT25
#define  FMC_DATAW0S4L_data_26       BIT26
#define  FMC_DATAW0S4L_data_27       BIT27
#define  FMC_DATAW0S4L_data_28       BIT28
#define  FMC_DATAW0S4L_data_29       BIT29
#define  FMC_DATAW0S4L_data_30       BIT30
#define  FMC_DATAW0S4L_data_31       BIT31

#define  FMC_DATAW0S5U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW0S5U_data_0        BIT0
#define  FMC_DATAW0S5U_data_1        BIT1
#define  FMC_DATAW0S5U_data_2        BIT2
#define  FMC_DATAW0S5U_data_3        BIT3
#define  FMC_DATAW0S5U_data_4        BIT4
#define  FMC_DATAW0S5U_data_5        BIT5
#define  FMC_DATAW0S5U_data_6        BIT6
#define  FMC_DATAW0S5U_data_7        BIT7
#define  FMC_DATAW0S5U_data_8        BIT8
#define  FMC_DATAW0S5U_data_9        BIT9
#define  FMC_DATAW0S5U_data_10       BIT10
#define  FMC_DATAW0S5U_data_11       BIT11
#define  FMC_DATAW0S5U_data_12       BIT12
#define  FMC_DATAW0S5U_data_13       BIT13
#define  FMC_DATAW0S5U_data_14       BIT14
#define  FMC_DATAW0S5U_data_15       BIT15
#define  FMC_DATAW0S5U_data_16       BIT16
#define  FMC_DATAW0S5U_data_17       BIT17
#define  FMC_DATAW0S5U_data_18       BIT18
#define  FMC_DATAW0S5U_data_19       BIT19
#define  FMC_DATAW0S5U_data_20       BIT20
#define  FMC_DATAW0S5U_data_21       BIT21
#define  FMC_DATAW0S5U_data_22       BIT22
#define  FMC_DATAW0S5U_data_23       BIT23
#define  FMC_DATAW0S5U_data_24       BIT24
#define  FMC_DATAW0S5U_data_25       BIT25
#define  FMC_DATAW0S5U_data_26       BIT26
#define  FMC_DATAW0S5U_data_27       BIT27
#define  FMC_DATAW0S5U_data_28       BIT28
#define  FMC_DATAW0S5U_data_29       BIT29
#define  FMC_DATAW0S5U_data_30       BIT30
#define  FMC_DATAW0S5U_data_31       BIT31

#define  FMC_DATAW0S5L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW0S5L_data_0        BIT0
#define  FMC_DATAW0S5L_data_1        BIT1
#define  FMC_DATAW0S5L_data_2        BIT2
#define  FMC_DATAW0S5L_data_3        BIT3
#define  FMC_DATAW0S5L_data_4        BIT4
#define  FMC_DATAW0S5L_data_5        BIT5
#define  FMC_DATAW0S5L_data_6        BIT6
#define  FMC_DATAW0S5L_data_7        BIT7
#define  FMC_DATAW0S5L_data_8        BIT8
#define  FMC_DATAW0S5L_data_9        BIT9
#define  FMC_DATAW0S5L_data_10       BIT10
#define  FMC_DATAW0S5L_data_11       BIT11
#define  FMC_DATAW0S5L_data_12       BIT12
#define  FMC_DATAW0S5L_data_13       BIT13
#define  FMC_DATAW0S5L_data_14       BIT14
#define  FMC_DATAW0S5L_data_15       BIT15
#define  FMC_DATAW0S5L_data_16       BIT16
#define  FMC_DATAW0S5L_data_17       BIT17
#define  FMC_DATAW0S5L_data_18       BIT18
#define  FMC_DATAW0S5L_data_19       BIT19
#define  FMC_DATAW0S5L_data_20       BIT20
#define  FMC_DATAW0S5L_data_21       BIT21
#define  FMC_DATAW0S5L_data_22       BIT22
#define  FMC_DATAW0S5L_data_23       BIT23
#define  FMC_DATAW0S5L_data_24       BIT24
#define  FMC_DATAW0S5L_data_25       BIT25
#define  FMC_DATAW0S5L_data_26       BIT26
#define  FMC_DATAW0S5L_data_27       BIT27
#define  FMC_DATAW0S5L_data_28       BIT28
#define  FMC_DATAW0S5L_data_29       BIT29
#define  FMC_DATAW0S5L_data_30       BIT30
#define  FMC_DATAW0S5L_data_31       BIT31

#define  FMC_DATAW0S6U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW0S6U_data_0        BIT0
#define  FMC_DATAW0S6U_data_1        BIT1
#define  FMC_DATAW0S6U_data_2        BIT2
#define  FMC_DATAW0S6U_data_3        BIT3
#define  FMC_DATAW0S6U_data_4        BIT4
#define  FMC_DATAW0S6U_data_5        BIT5
#define  FMC_DATAW0S6U_data_6        BIT6
#define  FMC_DATAW0S6U_data_7        BIT7
#define  FMC_DATAW0S6U_data_8        BIT8
#define  FMC_DATAW0S6U_data_9        BIT9
#define  FMC_DATAW0S6U_data_10       BIT10
#define  FMC_DATAW0S6U_data_11       BIT11
#define  FMC_DATAW0S6U_data_12       BIT12
#define  FMC_DATAW0S6U_data_13       BIT13
#define  FMC_DATAW0S6U_data_14       BIT14
#define  FMC_DATAW0S6U_data_15       BIT15
#define  FMC_DATAW0S6U_data_16       BIT16
#define  FMC_DATAW0S6U_data_17       BIT17
#define  FMC_DATAW0S6U_data_18       BIT18
#define  FMC_DATAW0S6U_data_19       BIT19
#define  FMC_DATAW0S6U_data_20       BIT20
#define  FMC_DATAW0S6U_data_21       BIT21
#define  FMC_DATAW0S6U_data_22       BIT22
#define  FMC_DATAW0S6U_data_23       BIT23
#define  FMC_DATAW0S6U_data_24       BIT24
#define  FMC_DATAW0S6U_data_25       BIT25
#define  FMC_DATAW0S6U_data_26       BIT26
#define  FMC_DATAW0S6U_data_27       BIT27
#define  FMC_DATAW0S6U_data_28       BIT28
#define  FMC_DATAW0S6U_data_29       BIT29
#define  FMC_DATAW0S6U_data_30       BIT30
#define  FMC_DATAW0S6U_data_31       BIT31

#define  FMC_DATAW0S6L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW0S6L_data_0        BIT0
#define  FMC_DATAW0S6L_data_1        BIT1
#define  FMC_DATAW0S6L_data_2        BIT2
#define  FMC_DATAW0S6L_data_3        BIT3
#define  FMC_DATAW0S6L_data_4        BIT4
#define  FMC_DATAW0S6L_data_5        BIT5
#define  FMC_DATAW0S6L_data_6        BIT6
#define  FMC_DATAW0S6L_data_7        BIT7
#define  FMC_DATAW0S6L_data_8        BIT8
#define  FMC_DATAW0S6L_data_9        BIT9
#define  FMC_DATAW0S6L_data_10       BIT10
#define  FMC_DATAW0S6L_data_11       BIT11
#define  FMC_DATAW0S6L_data_12       BIT12
#define  FMC_DATAW0S6L_data_13       BIT13
#define  FMC_DATAW0S6L_data_14       BIT14
#define  FMC_DATAW0S6L_data_15       BIT15
#define  FMC_DATAW0S6L_data_16       BIT16
#define  FMC_DATAW0S6L_data_17       BIT17
#define  FMC_DATAW0S6L_data_18       BIT18
#define  FMC_DATAW0S6L_data_19       BIT19
#define  FMC_DATAW0S6L_data_20       BIT20
#define  FMC_DATAW0S6L_data_21       BIT21
#define  FMC_DATAW0S6L_data_22       BIT22
#define  FMC_DATAW0S6L_data_23       BIT23
#define  FMC_DATAW0S6L_data_24       BIT24
#define  FMC_DATAW0S6L_data_25       BIT25
#define  FMC_DATAW0S6L_data_26       BIT26
#define  FMC_DATAW0S6L_data_27       BIT27
#define  FMC_DATAW0S6L_data_28       BIT28
#define  FMC_DATAW0S6L_data_29       BIT29
#define  FMC_DATAW0S6L_data_30       BIT30
#define  FMC_DATAW0S6L_data_31       BIT31

#define  FMC_DATAW0S7U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW0S7U_data_0        BIT0
#define  FMC_DATAW0S7U_data_1        BIT1
#define  FMC_DATAW0S7U_data_2        BIT2
#define  FMC_DATAW0S7U_data_3        BIT3
#define  FMC_DATAW0S7U_data_4        BIT4
#define  FMC_DATAW0S7U_data_5        BIT5
#define  FMC_DATAW0S7U_data_6        BIT6
#define  FMC_DATAW0S7U_data_7        BIT7
#define  FMC_DATAW0S7U_data_8        BIT8
#define  FMC_DATAW0S7U_data_9        BIT9
#define  FMC_DATAW0S7U_data_10       BIT10
#define  FMC_DATAW0S7U_data_11       BIT11
#define  FMC_DATAW0S7U_data_12       BIT12
#define  FMC_DATAW0S7U_data_13       BIT13
#define  FMC_DATAW0S7U_data_14       BIT14
#define  FMC_DATAW0S7U_data_15       BIT15
#define  FMC_DATAW0S7U_data_16       BIT16
#define  FMC_DATAW0S7U_data_17       BIT17
#define  FMC_DATAW0S7U_data_18       BIT18
#define  FMC_DATAW0S7U_data_19       BIT19
#define  FMC_DATAW0S7U_data_20       BIT20
#define  FMC_DATAW0S7U_data_21       BIT21
#define  FMC_DATAW0S7U_data_22       BIT22
#define  FMC_DATAW0S7U_data_23       BIT23
#define  FMC_DATAW0S7U_data_24       BIT24
#define  FMC_DATAW0S7U_data_25       BIT25
#define  FMC_DATAW0S7U_data_26       BIT26
#define  FMC_DATAW0S7U_data_27       BIT27
#define  FMC_DATAW0S7U_data_28       BIT28
#define  FMC_DATAW0S7U_data_29       BIT29
#define  FMC_DATAW0S7U_data_30       BIT30
#define  FMC_DATAW0S7U_data_31       BIT31

#define  FMC_DATAW0S7L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW0S7L_data_0        BIT0
#define  FMC_DATAW0S7L_data_1        BIT1
#define  FMC_DATAW0S7L_data_2        BIT2
#define  FMC_DATAW0S7L_data_3        BIT3
#define  FMC_DATAW0S7L_data_4        BIT4
#define  FMC_DATAW0S7L_data_5        BIT5
#define  FMC_DATAW0S7L_data_6        BIT6
#define  FMC_DATAW0S7L_data_7        BIT7
#define  FMC_DATAW0S7L_data_8        BIT8
#define  FMC_DATAW0S7L_data_9        BIT9
#define  FMC_DATAW0S7L_data_10       BIT10
#define  FMC_DATAW0S7L_data_11       BIT11
#define  FMC_DATAW0S7L_data_12       BIT12
#define  FMC_DATAW0S7L_data_13       BIT13
#define  FMC_DATAW0S7L_data_14       BIT14
#define  FMC_DATAW0S7L_data_15       BIT15
#define  FMC_DATAW0S7L_data_16       BIT16
#define  FMC_DATAW0S7L_data_17       BIT17
#define  FMC_DATAW0S7L_data_18       BIT18
#define  FMC_DATAW0S7L_data_19       BIT19
#define  FMC_DATAW0S7L_data_20       BIT20
#define  FMC_DATAW0S7L_data_21       BIT21
#define  FMC_DATAW0S7L_data_22       BIT22
#define  FMC_DATAW0S7L_data_23       BIT23
#define  FMC_DATAW0S7L_data_24       BIT24
#define  FMC_DATAW0S7L_data_25       BIT25
#define  FMC_DATAW0S7L_data_26       BIT26
#define  FMC_DATAW0S7L_data_27       BIT27
#define  FMC_DATAW0S7L_data_28       BIT28
#define  FMC_DATAW0S7L_data_29       BIT29
#define  FMC_DATAW0S7L_data_30       BIT30
#define  FMC_DATAW0S7L_data_31       BIT31

#define  FMC_DATAW1S0U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW1S0U_data_0        BIT0
#define  FMC_DATAW1S0U_data_1        BIT1
#define  FMC_DATAW1S0U_data_2        BIT2
#define  FMC_DATAW1S0U_data_3        BIT3
#define  FMC_DATAW1S0U_data_4        BIT4
#define  FMC_DATAW1S0U_data_5        BIT5
#define  FMC_DATAW1S0U_data_6        BIT6
#define  FMC_DATAW1S0U_data_7        BIT7
#define  FMC_DATAW1S0U_data_8        BIT8
#define  FMC_DATAW1S0U_data_9        BIT9
#define  FMC_DATAW1S0U_data_10       BIT10
#define  FMC_DATAW1S0U_data_11       BIT11
#define  FMC_DATAW1S0U_data_12       BIT12
#define  FMC_DATAW1S0U_data_13       BIT13
#define  FMC_DATAW1S0U_data_14       BIT14
#define  FMC_DATAW1S0U_data_15       BIT15
#define  FMC_DATAW1S0U_data_16       BIT16
#define  FMC_DATAW1S0U_data_17       BIT17
#define  FMC_DATAW1S0U_data_18       BIT18
#define  FMC_DATAW1S0U_data_19       BIT19
#define  FMC_DATAW1S0U_data_20       BIT20
#define  FMC_DATAW1S0U_data_21       BIT21
#define  FMC_DATAW1S0U_data_22       BIT22
#define  FMC_DATAW1S0U_data_23       BIT23
#define  FMC_DATAW1S0U_data_24       BIT24
#define  FMC_DATAW1S0U_data_25       BIT25
#define  FMC_DATAW1S0U_data_26       BIT26
#define  FMC_DATAW1S0U_data_27       BIT27
#define  FMC_DATAW1S0U_data_28       BIT28
#define  FMC_DATAW1S0U_data_29       BIT29
#define  FMC_DATAW1S0U_data_30       BIT30
#define  FMC_DATAW1S0U_data_31       BIT31

#define  FMC_DATAW1S0L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW1S0L_data_0        BIT0
#define  FMC_DATAW1S0L_data_1        BIT1
#define  FMC_DATAW1S0L_data_2        BIT2
#define  FMC_DATAW1S0L_data_3        BIT3
#define  FMC_DATAW1S0L_data_4        BIT4
#define  FMC_DATAW1S0L_data_5        BIT5
#define  FMC_DATAW1S0L_data_6        BIT6
#define  FMC_DATAW1S0L_data_7        BIT7
#define  FMC_DATAW1S0L_data_8        BIT8
#define  FMC_DATAW1S0L_data_9        BIT9
#define  FMC_DATAW1S0L_data_10       BIT10
#define  FMC_DATAW1S0L_data_11       BIT11
#define  FMC_DATAW1S0L_data_12       BIT12
#define  FMC_DATAW1S0L_data_13       BIT13
#define  FMC_DATAW1S0L_data_14       BIT14
#define  FMC_DATAW1S0L_data_15       BIT15
#define  FMC_DATAW1S0L_data_16       BIT16
#define  FMC_DATAW1S0L_data_17       BIT17
#define  FMC_DATAW1S0L_data_18       BIT18
#define  FMC_DATAW1S0L_data_19       BIT19
#define  FMC_DATAW1S0L_data_20       BIT20
#define  FMC_DATAW1S0L_data_21       BIT21
#define  FMC_DATAW1S0L_data_22       BIT22
#define  FMC_DATAW1S0L_data_23       BIT23
#define  FMC_DATAW1S0L_data_24       BIT24
#define  FMC_DATAW1S0L_data_25       BIT25
#define  FMC_DATAW1S0L_data_26       BIT26
#define  FMC_DATAW1S0L_data_27       BIT27
#define  FMC_DATAW1S0L_data_28       BIT28
#define  FMC_DATAW1S0L_data_29       BIT29
#define  FMC_DATAW1S0L_data_30       BIT30
#define  FMC_DATAW1S0L_data_31       BIT31

#define  FMC_DATAW1S1U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW1S1U_data_0        BIT0
#define  FMC_DATAW1S1U_data_1        BIT1
#define  FMC_DATAW1S1U_data_2        BIT2
#define  FMC_DATAW1S1U_data_3        BIT3
#define  FMC_DATAW1S1U_data_4        BIT4
#define  FMC_DATAW1S1U_data_5        BIT5
#define  FMC_DATAW1S1U_data_6        BIT6
#define  FMC_DATAW1S1U_data_7        BIT7
#define  FMC_DATAW1S1U_data_8        BIT8
#define  FMC_DATAW1S1U_data_9        BIT9
#define  FMC_DATAW1S1U_data_10       BIT10
#define  FMC_DATAW1S1U_data_11       BIT11
#define  FMC_DATAW1S1U_data_12       BIT12
#define  FMC_DATAW1S1U_data_13       BIT13
#define  FMC_DATAW1S1U_data_14       BIT14
#define  FMC_DATAW1S1U_data_15       BIT15
#define  FMC_DATAW1S1U_data_16       BIT16
#define  FMC_DATAW1S1U_data_17       BIT17
#define  FMC_DATAW1S1U_data_18       BIT18
#define  FMC_DATAW1S1U_data_19       BIT19
#define  FMC_DATAW1S1U_data_20       BIT20
#define  FMC_DATAW1S1U_data_21       BIT21
#define  FMC_DATAW1S1U_data_22       BIT22
#define  FMC_DATAW1S1U_data_23       BIT23
#define  FMC_DATAW1S1U_data_24       BIT24
#define  FMC_DATAW1S1U_data_25       BIT25
#define  FMC_DATAW1S1U_data_26       BIT26
#define  FMC_DATAW1S1U_data_27       BIT27
#define  FMC_DATAW1S1U_data_28       BIT28
#define  FMC_DATAW1S1U_data_29       BIT29
#define  FMC_DATAW1S1U_data_30       BIT30
#define  FMC_DATAW1S1U_data_31       BIT31

#define  FMC_DATAW1S1L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW1S1L_data_0        BIT0
#define  FMC_DATAW1S1L_data_1        BIT1
#define  FMC_DATAW1S1L_data_2        BIT2
#define  FMC_DATAW1S1L_data_3        BIT3
#define  FMC_DATAW1S1L_data_4        BIT4
#define  FMC_DATAW1S1L_data_5        BIT5
#define  FMC_DATAW1S1L_data_6        BIT6
#define  FMC_DATAW1S1L_data_7        BIT7
#define  FMC_DATAW1S1L_data_8        BIT8
#define  FMC_DATAW1S1L_data_9        BIT9
#define  FMC_DATAW1S1L_data_10       BIT10
#define  FMC_DATAW1S1L_data_11       BIT11
#define  FMC_DATAW1S1L_data_12       BIT12
#define  FMC_DATAW1S1L_data_13       BIT13
#define  FMC_DATAW1S1L_data_14       BIT14
#define  FMC_DATAW1S1L_data_15       BIT15
#define  FMC_DATAW1S1L_data_16       BIT16
#define  FMC_DATAW1S1L_data_17       BIT17
#define  FMC_DATAW1S1L_data_18       BIT18
#define  FMC_DATAW1S1L_data_19       BIT19
#define  FMC_DATAW1S1L_data_20       BIT20
#define  FMC_DATAW1S1L_data_21       BIT21
#define  FMC_DATAW1S1L_data_22       BIT22
#define  FMC_DATAW1S1L_data_23       BIT23
#define  FMC_DATAW1S1L_data_24       BIT24
#define  FMC_DATAW1S1L_data_25       BIT25
#define  FMC_DATAW1S1L_data_26       BIT26
#define  FMC_DATAW1S1L_data_27       BIT27
#define  FMC_DATAW1S1L_data_28       BIT28
#define  FMC_DATAW1S1L_data_29       BIT29
#define  FMC_DATAW1S1L_data_30       BIT30
#define  FMC_DATAW1S1L_data_31       BIT31

#define  FMC_DATAW1S2U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW1S2U_data_0        BIT0
#define  FMC_DATAW1S2U_data_1        BIT1
#define  FMC_DATAW1S2U_data_2        BIT2
#define  FMC_DATAW1S2U_data_3        BIT3
#define  FMC_DATAW1S2U_data_4        BIT4
#define  FMC_DATAW1S2U_data_5        BIT5
#define  FMC_DATAW1S2U_data_6        BIT6
#define  FMC_DATAW1S2U_data_7        BIT7
#define  FMC_DATAW1S2U_data_8        BIT8
#define  FMC_DATAW1S2U_data_9        BIT9
#define  FMC_DATAW1S2U_data_10       BIT10
#define  FMC_DATAW1S2U_data_11       BIT11
#define  FMC_DATAW1S2U_data_12       BIT12
#define  FMC_DATAW1S2U_data_13       BIT13
#define  FMC_DATAW1S2U_data_14       BIT14
#define  FMC_DATAW1S2U_data_15       BIT15
#define  FMC_DATAW1S2U_data_16       BIT16
#define  FMC_DATAW1S2U_data_17       BIT17
#define  FMC_DATAW1S2U_data_18       BIT18
#define  FMC_DATAW1S2U_data_19       BIT19
#define  FMC_DATAW1S2U_data_20       BIT20
#define  FMC_DATAW1S2U_data_21       BIT21
#define  FMC_DATAW1S2U_data_22       BIT22
#define  FMC_DATAW1S2U_data_23       BIT23
#define  FMC_DATAW1S2U_data_24       BIT24
#define  FMC_DATAW1S2U_data_25       BIT25
#define  FMC_DATAW1S2U_data_26       BIT26
#define  FMC_DATAW1S2U_data_27       BIT27
#define  FMC_DATAW1S2U_data_28       BIT28
#define  FMC_DATAW1S2U_data_29       BIT29
#define  FMC_DATAW1S2U_data_30       BIT30
#define  FMC_DATAW1S2U_data_31       BIT31

#define  FMC_DATAW1S2L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW1S2L_data_0        BIT0
#define  FMC_DATAW1S2L_data_1        BIT1
#define  FMC_DATAW1S2L_data_2        BIT2
#define  FMC_DATAW1S2L_data_3        BIT3
#define  FMC_DATAW1S2L_data_4        BIT4
#define  FMC_DATAW1S2L_data_5        BIT5
#define  FMC_DATAW1S2L_data_6        BIT6
#define  FMC_DATAW1S2L_data_7        BIT7
#define  FMC_DATAW1S2L_data_8        BIT8
#define  FMC_DATAW1S2L_data_9        BIT9
#define  FMC_DATAW1S2L_data_10       BIT10
#define  FMC_DATAW1S2L_data_11       BIT11
#define  FMC_DATAW1S2L_data_12       BIT12
#define  FMC_DATAW1S2L_data_13       BIT13
#define  FMC_DATAW1S2L_data_14       BIT14
#define  FMC_DATAW1S2L_data_15       BIT15
#define  FMC_DATAW1S2L_data_16       BIT16
#define  FMC_DATAW1S2L_data_17       BIT17
#define  FMC_DATAW1S2L_data_18       BIT18
#define  FMC_DATAW1S2L_data_19       BIT19
#define  FMC_DATAW1S2L_data_20       BIT20
#define  FMC_DATAW1S2L_data_21       BIT21
#define  FMC_DATAW1S2L_data_22       BIT22
#define  FMC_DATAW1S2L_data_23       BIT23
#define  FMC_DATAW1S2L_data_24       BIT24
#define  FMC_DATAW1S2L_data_25       BIT25
#define  FMC_DATAW1S2L_data_26       BIT26
#define  FMC_DATAW1S2L_data_27       BIT27
#define  FMC_DATAW1S2L_data_28       BIT28
#define  FMC_DATAW1S2L_data_29       BIT29
#define  FMC_DATAW1S2L_data_30       BIT30
#define  FMC_DATAW1S2L_data_31       BIT31

#define  FMC_DATAW1S3U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW1S3U_data_0        BIT0
#define  FMC_DATAW1S3U_data_1        BIT1
#define  FMC_DATAW1S3U_data_2        BIT2
#define  FMC_DATAW1S3U_data_3        BIT3
#define  FMC_DATAW1S3U_data_4        BIT4
#define  FMC_DATAW1S3U_data_5        BIT5
#define  FMC_DATAW1S3U_data_6        BIT6
#define  FMC_DATAW1S3U_data_7        BIT7
#define  FMC_DATAW1S3U_data_8        BIT8
#define  FMC_DATAW1S3U_data_9        BIT9
#define  FMC_DATAW1S3U_data_10       BIT10
#define  FMC_DATAW1S3U_data_11       BIT11
#define  FMC_DATAW1S3U_data_12       BIT12
#define  FMC_DATAW1S3U_data_13       BIT13
#define  FMC_DATAW1S3U_data_14       BIT14
#define  FMC_DATAW1S3U_data_15       BIT15
#define  FMC_DATAW1S3U_data_16       BIT16
#define  FMC_DATAW1S3U_data_17       BIT17
#define  FMC_DATAW1S3U_data_18       BIT18
#define  FMC_DATAW1S3U_data_19       BIT19
#define  FMC_DATAW1S3U_data_20       BIT20
#define  FMC_DATAW1S3U_data_21       BIT21
#define  FMC_DATAW1S3U_data_22       BIT22
#define  FMC_DATAW1S3U_data_23       BIT23
#define  FMC_DATAW1S3U_data_24       BIT24
#define  FMC_DATAW1S3U_data_25       BIT25
#define  FMC_DATAW1S3U_data_26       BIT26
#define  FMC_DATAW1S3U_data_27       BIT27
#define  FMC_DATAW1S3U_data_28       BIT28
#define  FMC_DATAW1S3U_data_29       BIT29
#define  FMC_DATAW1S3U_data_30       BIT30
#define  FMC_DATAW1S3U_data_31       BIT31

#define  FMC_DATAW1S3L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW1S3L_data_0        BIT0
#define  FMC_DATAW1S3L_data_1        BIT1
#define  FMC_DATAW1S3L_data_2        BIT2
#define  FMC_DATAW1S3L_data_3        BIT3
#define  FMC_DATAW1S3L_data_4        BIT4
#define  FMC_DATAW1S3L_data_5        BIT5
#define  FMC_DATAW1S3L_data_6        BIT6
#define  FMC_DATAW1S3L_data_7        BIT7
#define  FMC_DATAW1S3L_data_8        BIT8
#define  FMC_DATAW1S3L_data_9        BIT9
#define  FMC_DATAW1S3L_data_10       BIT10
#define  FMC_DATAW1S3L_data_11       BIT11
#define  FMC_DATAW1S3L_data_12       BIT12
#define  FMC_DATAW1S3L_data_13       BIT13
#define  FMC_DATAW1S3L_data_14       BIT14
#define  FMC_DATAW1S3L_data_15       BIT15
#define  FMC_DATAW1S3L_data_16       BIT16
#define  FMC_DATAW1S3L_data_17       BIT17
#define  FMC_DATAW1S3L_data_18       BIT18
#define  FMC_DATAW1S3L_data_19       BIT19
#define  FMC_DATAW1S3L_data_20       BIT20
#define  FMC_DATAW1S3L_data_21       BIT21
#define  FMC_DATAW1S3L_data_22       BIT22
#define  FMC_DATAW1S3L_data_23       BIT23
#define  FMC_DATAW1S3L_data_24       BIT24
#define  FMC_DATAW1S3L_data_25       BIT25
#define  FMC_DATAW1S3L_data_26       BIT26
#define  FMC_DATAW1S3L_data_27       BIT27
#define  FMC_DATAW1S3L_data_28       BIT28
#define  FMC_DATAW1S3L_data_29       BIT29
#define  FMC_DATAW1S3L_data_30       BIT30
#define  FMC_DATAW1S3L_data_31       BIT31

#define  FMC_DATAW1S4U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW1S4U_data_0        BIT0
#define  FMC_DATAW1S4U_data_1        BIT1
#define  FMC_DATAW1S4U_data_2        BIT2
#define  FMC_DATAW1S4U_data_3        BIT3
#define  FMC_DATAW1S4U_data_4        BIT4
#define  FMC_DATAW1S4U_data_5        BIT5
#define  FMC_DATAW1S4U_data_6        BIT6
#define  FMC_DATAW1S4U_data_7        BIT7
#define  FMC_DATAW1S4U_data_8        BIT8
#define  FMC_DATAW1S4U_data_9        BIT9
#define  FMC_DATAW1S4U_data_10       BIT10
#define  FMC_DATAW1S4U_data_11       BIT11
#define  FMC_DATAW1S4U_data_12       BIT12
#define  FMC_DATAW1S4U_data_13       BIT13
#define  FMC_DATAW1S4U_data_14       BIT14
#define  FMC_DATAW1S4U_data_15       BIT15
#define  FMC_DATAW1S4U_data_16       BIT16
#define  FMC_DATAW1S4U_data_17       BIT17
#define  FMC_DATAW1S4U_data_18       BIT18
#define  FMC_DATAW1S4U_data_19       BIT19
#define  FMC_DATAW1S4U_data_20       BIT20
#define  FMC_DATAW1S4U_data_21       BIT21
#define  FMC_DATAW1S4U_data_22       BIT22
#define  FMC_DATAW1S4U_data_23       BIT23
#define  FMC_DATAW1S4U_data_24       BIT24
#define  FMC_DATAW1S4U_data_25       BIT25
#define  FMC_DATAW1S4U_data_26       BIT26
#define  FMC_DATAW1S4U_data_27       BIT27
#define  FMC_DATAW1S4U_data_28       BIT28
#define  FMC_DATAW1S4U_data_29       BIT29
#define  FMC_DATAW1S4U_data_30       BIT30
#define  FMC_DATAW1S4U_data_31       BIT31

#define  FMC_DATAW1S4L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW1S4L_data_0        BIT0
#define  FMC_DATAW1S4L_data_1        BIT1
#define  FMC_DATAW1S4L_data_2        BIT2
#define  FMC_DATAW1S4L_data_3        BIT3
#define  FMC_DATAW1S4L_data_4        BIT4
#define  FMC_DATAW1S4L_data_5        BIT5
#define  FMC_DATAW1S4L_data_6        BIT6
#define  FMC_DATAW1S4L_data_7        BIT7
#define  FMC_DATAW1S4L_data_8        BIT8
#define  FMC_DATAW1S4L_data_9        BIT9
#define  FMC_DATAW1S4L_data_10       BIT10
#define  FMC_DATAW1S4L_data_11       BIT11
#define  FMC_DATAW1S4L_data_12       BIT12
#define  FMC_DATAW1S4L_data_13       BIT13
#define  FMC_DATAW1S4L_data_14       BIT14
#define  FMC_DATAW1S4L_data_15       BIT15
#define  FMC_DATAW1S4L_data_16       BIT16
#define  FMC_DATAW1S4L_data_17       BIT17
#define  FMC_DATAW1S4L_data_18       BIT18
#define  FMC_DATAW1S4L_data_19       BIT19
#define  FMC_DATAW1S4L_data_20       BIT20
#define  FMC_DATAW1S4L_data_21       BIT21
#define  FMC_DATAW1S4L_data_22       BIT22
#define  FMC_DATAW1S4L_data_23       BIT23
#define  FMC_DATAW1S4L_data_24       BIT24
#define  FMC_DATAW1S4L_data_25       BIT25
#define  FMC_DATAW1S4L_data_26       BIT26
#define  FMC_DATAW1S4L_data_27       BIT27
#define  FMC_DATAW1S4L_data_28       BIT28
#define  FMC_DATAW1S4L_data_29       BIT29
#define  FMC_DATAW1S4L_data_30       BIT30
#define  FMC_DATAW1S4L_data_31       BIT31

#define  FMC_DATAW1S5U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW1S5U_data_0        BIT0
#define  FMC_DATAW1S5U_data_1        BIT1
#define  FMC_DATAW1S5U_data_2        BIT2
#define  FMC_DATAW1S5U_data_3        BIT3
#define  FMC_DATAW1S5U_data_4        BIT4
#define  FMC_DATAW1S5U_data_5        BIT5
#define  FMC_DATAW1S5U_data_6        BIT6
#define  FMC_DATAW1S5U_data_7        BIT7
#define  FMC_DATAW1S5U_data_8        BIT8
#define  FMC_DATAW1S5U_data_9        BIT9
#define  FMC_DATAW1S5U_data_10       BIT10
#define  FMC_DATAW1S5U_data_11       BIT11
#define  FMC_DATAW1S5U_data_12       BIT12
#define  FMC_DATAW1S5U_data_13       BIT13
#define  FMC_DATAW1S5U_data_14       BIT14
#define  FMC_DATAW1S5U_data_15       BIT15
#define  FMC_DATAW1S5U_data_16       BIT16
#define  FMC_DATAW1S5U_data_17       BIT17
#define  FMC_DATAW1S5U_data_18       BIT18
#define  FMC_DATAW1S5U_data_19       BIT19
#define  FMC_DATAW1S5U_data_20       BIT20
#define  FMC_DATAW1S5U_data_21       BIT21
#define  FMC_DATAW1S5U_data_22       BIT22
#define  FMC_DATAW1S5U_data_23       BIT23
#define  FMC_DATAW1S5U_data_24       BIT24
#define  FMC_DATAW1S5U_data_25       BIT25
#define  FMC_DATAW1S5U_data_26       BIT26
#define  FMC_DATAW1S5U_data_27       BIT27
#define  FMC_DATAW1S5U_data_28       BIT28
#define  FMC_DATAW1S5U_data_29       BIT29
#define  FMC_DATAW1S5U_data_30       BIT30
#define  FMC_DATAW1S5U_data_31       BIT31

#define  FMC_DATAW1S5L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW1S5L_data_0        BIT0
#define  FMC_DATAW1S5L_data_1        BIT1
#define  FMC_DATAW1S5L_data_2        BIT2
#define  FMC_DATAW1S5L_data_3        BIT3
#define  FMC_DATAW1S5L_data_4        BIT4
#define  FMC_DATAW1S5L_data_5        BIT5
#define  FMC_DATAW1S5L_data_6        BIT6
#define  FMC_DATAW1S5L_data_7        BIT7
#define  FMC_DATAW1S5L_data_8        BIT8
#define  FMC_DATAW1S5L_data_9        BIT9
#define  FMC_DATAW1S5L_data_10       BIT10
#define  FMC_DATAW1S5L_data_11       BIT11
#define  FMC_DATAW1S5L_data_12       BIT12
#define  FMC_DATAW1S5L_data_13       BIT13
#define  FMC_DATAW1S5L_data_14       BIT14
#define  FMC_DATAW1S5L_data_15       BIT15
#define  FMC_DATAW1S5L_data_16       BIT16
#define  FMC_DATAW1S5L_data_17       BIT17
#define  FMC_DATAW1S5L_data_18       BIT18
#define  FMC_DATAW1S5L_data_19       BIT19
#define  FMC_DATAW1S5L_data_20       BIT20
#define  FMC_DATAW1S5L_data_21       BIT21
#define  FMC_DATAW1S5L_data_22       BIT22
#define  FMC_DATAW1S5L_data_23       BIT23
#define  FMC_DATAW1S5L_data_24       BIT24
#define  FMC_DATAW1S5L_data_25       BIT25
#define  FMC_DATAW1S5L_data_26       BIT26
#define  FMC_DATAW1S5L_data_27       BIT27
#define  FMC_DATAW1S5L_data_28       BIT28
#define  FMC_DATAW1S5L_data_29       BIT29
#define  FMC_DATAW1S5L_data_30       BIT30
#define  FMC_DATAW1S5L_data_31       BIT31

#define  FMC_DATAW1S6U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW1S6U_data_0        BIT0
#define  FMC_DATAW1S6U_data_1        BIT1
#define  FMC_DATAW1S6U_data_2        BIT2
#define  FMC_DATAW1S6U_data_3        BIT3
#define  FMC_DATAW1S6U_data_4        BIT4
#define  FMC_DATAW1S6U_data_5        BIT5
#define  FMC_DATAW1S6U_data_6        BIT6
#define  FMC_DATAW1S6U_data_7        BIT7
#define  FMC_DATAW1S6U_data_8        BIT8
#define  FMC_DATAW1S6U_data_9        BIT9
#define  FMC_DATAW1S6U_data_10       BIT10
#define  FMC_DATAW1S6U_data_11       BIT11
#define  FMC_DATAW1S6U_data_12       BIT12
#define  FMC_DATAW1S6U_data_13       BIT13
#define  FMC_DATAW1S6U_data_14       BIT14
#define  FMC_DATAW1S6U_data_15       BIT15
#define  FMC_DATAW1S6U_data_16       BIT16
#define  FMC_DATAW1S6U_data_17       BIT17
#define  FMC_DATAW1S6U_data_18       BIT18
#define  FMC_DATAW1S6U_data_19       BIT19
#define  FMC_DATAW1S6U_data_20       BIT20
#define  FMC_DATAW1S6U_data_21       BIT21
#define  FMC_DATAW1S6U_data_22       BIT22
#define  FMC_DATAW1S6U_data_23       BIT23
#define  FMC_DATAW1S6U_data_24       BIT24
#define  FMC_DATAW1S6U_data_25       BIT25
#define  FMC_DATAW1S6U_data_26       BIT26
#define  FMC_DATAW1S6U_data_27       BIT27
#define  FMC_DATAW1S6U_data_28       BIT28
#define  FMC_DATAW1S6U_data_29       BIT29
#define  FMC_DATAW1S6U_data_30       BIT30
#define  FMC_DATAW1S6U_data_31       BIT31

#define  FMC_DATAW1S6L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW1S6L_data_0        BIT0
#define  FMC_DATAW1S6L_data_1        BIT1
#define  FMC_DATAW1S6L_data_2        BIT2
#define  FMC_DATAW1S6L_data_3        BIT3
#define  FMC_DATAW1S6L_data_4        BIT4
#define  FMC_DATAW1S6L_data_5        BIT5
#define  FMC_DATAW1S6L_data_6        BIT6
#define  FMC_DATAW1S6L_data_7        BIT7
#define  FMC_DATAW1S6L_data_8        BIT8
#define  FMC_DATAW1S6L_data_9        BIT9
#define  FMC_DATAW1S6L_data_10       BIT10
#define  FMC_DATAW1S6L_data_11       BIT11
#define  FMC_DATAW1S6L_data_12       BIT12
#define  FMC_DATAW1S6L_data_13       BIT13
#define  FMC_DATAW1S6L_data_14       BIT14
#define  FMC_DATAW1S6L_data_15       BIT15
#define  FMC_DATAW1S6L_data_16       BIT16
#define  FMC_DATAW1S6L_data_17       BIT17
#define  FMC_DATAW1S6L_data_18       BIT18
#define  FMC_DATAW1S6L_data_19       BIT19
#define  FMC_DATAW1S6L_data_20       BIT20
#define  FMC_DATAW1S6L_data_21       BIT21
#define  FMC_DATAW1S6L_data_22       BIT22
#define  FMC_DATAW1S6L_data_23       BIT23
#define  FMC_DATAW1S6L_data_24       BIT24
#define  FMC_DATAW1S6L_data_25       BIT25
#define  FMC_DATAW1S6L_data_26       BIT26
#define  FMC_DATAW1S6L_data_27       BIT27
#define  FMC_DATAW1S6L_data_28       BIT28
#define  FMC_DATAW1S6L_data_29       BIT29
#define  FMC_DATAW1S6L_data_30       BIT30
#define  FMC_DATAW1S6L_data_31       BIT31

#define  FMC_DATAW1S7U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW1S7U_data_0        BIT0
#define  FMC_DATAW1S7U_data_1        BIT1
#define  FMC_DATAW1S7U_data_2        BIT2
#define  FMC_DATAW1S7U_data_3        BIT3
#define  FMC_DATAW1S7U_data_4        BIT4
#define  FMC_DATAW1S7U_data_5        BIT5
#define  FMC_DATAW1S7U_data_6        BIT6
#define  FMC_DATAW1S7U_data_7        BIT7
#define  FMC_DATAW1S7U_data_8        BIT8
#define  FMC_DATAW1S7U_data_9        BIT9
#define  FMC_DATAW1S7U_data_10       BIT10
#define  FMC_DATAW1S7U_data_11       BIT11
#define  FMC_DATAW1S7U_data_12       BIT12
#define  FMC_DATAW1S7U_data_13       BIT13
#define  FMC_DATAW1S7U_data_14       BIT14
#define  FMC_DATAW1S7U_data_15       BIT15
#define  FMC_DATAW1S7U_data_16       BIT16
#define  FMC_DATAW1S7U_data_17       BIT17
#define  FMC_DATAW1S7U_data_18       BIT18
#define  FMC_DATAW1S7U_data_19       BIT19
#define  FMC_DATAW1S7U_data_20       BIT20
#define  FMC_DATAW1S7U_data_21       BIT21
#define  FMC_DATAW1S7U_data_22       BIT22
#define  FMC_DATAW1S7U_data_23       BIT23
#define  FMC_DATAW1S7U_data_24       BIT24
#define  FMC_DATAW1S7U_data_25       BIT25
#define  FMC_DATAW1S7U_data_26       BIT26
#define  FMC_DATAW1S7U_data_27       BIT27
#define  FMC_DATAW1S7U_data_28       BIT28
#define  FMC_DATAW1S7U_data_29       BIT29
#define  FMC_DATAW1S7U_data_30       BIT30
#define  FMC_DATAW1S7U_data_31       BIT31

#define  FMC_DATAW1S7L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW1S7L_data_0        BIT0
#define  FMC_DATAW1S7L_data_1        BIT1
#define  FMC_DATAW1S7L_data_2        BIT2
#define  FMC_DATAW1S7L_data_3        BIT3
#define  FMC_DATAW1S7L_data_4        BIT4
#define  FMC_DATAW1S7L_data_5        BIT5
#define  FMC_DATAW1S7L_data_6        BIT6
#define  FMC_DATAW1S7L_data_7        BIT7
#define  FMC_DATAW1S7L_data_8        BIT8
#define  FMC_DATAW1S7L_data_9        BIT9
#define  FMC_DATAW1S7L_data_10       BIT10
#define  FMC_DATAW1S7L_data_11       BIT11
#define  FMC_DATAW1S7L_data_12       BIT12
#define  FMC_DATAW1S7L_data_13       BIT13
#define  FMC_DATAW1S7L_data_14       BIT14
#define  FMC_DATAW1S7L_data_15       BIT15
#define  FMC_DATAW1S7L_data_16       BIT16
#define  FMC_DATAW1S7L_data_17       BIT17
#define  FMC_DATAW1S7L_data_18       BIT18
#define  FMC_DATAW1S7L_data_19       BIT19
#define  FMC_DATAW1S7L_data_20       BIT20
#define  FMC_DATAW1S7L_data_21       BIT21
#define  FMC_DATAW1S7L_data_22       BIT22
#define  FMC_DATAW1S7L_data_23       BIT23
#define  FMC_DATAW1S7L_data_24       BIT24
#define  FMC_DATAW1S7L_data_25       BIT25
#define  FMC_DATAW1S7L_data_26       BIT26
#define  FMC_DATAW1S7L_data_27       BIT27
#define  FMC_DATAW1S7L_data_28       BIT28
#define  FMC_DATAW1S7L_data_29       BIT29
#define  FMC_DATAW1S7L_data_30       BIT30
#define  FMC_DATAW1S7L_data_31       BIT31

#define  FMC_DATAW2S0U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW2S0U_data_0        BIT0
#define  FMC_DATAW2S0U_data_1        BIT1
#define  FMC_DATAW2S0U_data_2        BIT2
#define  FMC_DATAW2S0U_data_3        BIT3
#define  FMC_DATAW2S0U_data_4        BIT4
#define  FMC_DATAW2S0U_data_5        BIT5
#define  FMC_DATAW2S0U_data_6        BIT6
#define  FMC_DATAW2S0U_data_7        BIT7
#define  FMC_DATAW2S0U_data_8        BIT8
#define  FMC_DATAW2S0U_data_9        BIT9
#define  FMC_DATAW2S0U_data_10       BIT10
#define  FMC_DATAW2S0U_data_11       BIT11
#define  FMC_DATAW2S0U_data_12       BIT12
#define  FMC_DATAW2S0U_data_13       BIT13
#define  FMC_DATAW2S0U_data_14       BIT14
#define  FMC_DATAW2S0U_data_15       BIT15
#define  FMC_DATAW2S0U_data_16       BIT16
#define  FMC_DATAW2S0U_data_17       BIT17
#define  FMC_DATAW2S0U_data_18       BIT18
#define  FMC_DATAW2S0U_data_19       BIT19
#define  FMC_DATAW2S0U_data_20       BIT20
#define  FMC_DATAW2S0U_data_21       BIT21
#define  FMC_DATAW2S0U_data_22       BIT22
#define  FMC_DATAW2S0U_data_23       BIT23
#define  FMC_DATAW2S0U_data_24       BIT24
#define  FMC_DATAW2S0U_data_25       BIT25
#define  FMC_DATAW2S0U_data_26       BIT26
#define  FMC_DATAW2S0U_data_27       BIT27
#define  FMC_DATAW2S0U_data_28       BIT28
#define  FMC_DATAW2S0U_data_29       BIT29
#define  FMC_DATAW2S0U_data_30       BIT30
#define  FMC_DATAW2S0U_data_31       BIT31

#define  FMC_DATAW2S0L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW2S0L_data_0        BIT0
#define  FMC_DATAW2S0L_data_1        BIT1
#define  FMC_DATAW2S0L_data_2        BIT2
#define  FMC_DATAW2S0L_data_3        BIT3
#define  FMC_DATAW2S0L_data_4        BIT4
#define  FMC_DATAW2S0L_data_5        BIT5
#define  FMC_DATAW2S0L_data_6        BIT6
#define  FMC_DATAW2S0L_data_7        BIT7
#define  FMC_DATAW2S0L_data_8        BIT8
#define  FMC_DATAW2S0L_data_9        BIT9
#define  FMC_DATAW2S0L_data_10       BIT10
#define  FMC_DATAW2S0L_data_11       BIT11
#define  FMC_DATAW2S0L_data_12       BIT12
#define  FMC_DATAW2S0L_data_13       BIT13
#define  FMC_DATAW2S0L_data_14       BIT14
#define  FMC_DATAW2S0L_data_15       BIT15
#define  FMC_DATAW2S0L_data_16       BIT16
#define  FMC_DATAW2S0L_data_17       BIT17
#define  FMC_DATAW2S0L_data_18       BIT18
#define  FMC_DATAW2S0L_data_19       BIT19
#define  FMC_DATAW2S0L_data_20       BIT20
#define  FMC_DATAW2S0L_data_21       BIT21
#define  FMC_DATAW2S0L_data_22       BIT22
#define  FMC_DATAW2S0L_data_23       BIT23
#define  FMC_DATAW2S0L_data_24       BIT24
#define  FMC_DATAW2S0L_data_25       BIT25
#define  FMC_DATAW2S0L_data_26       BIT26
#define  FMC_DATAW2S0L_data_27       BIT27
#define  FMC_DATAW2S0L_data_28       BIT28
#define  FMC_DATAW2S0L_data_29       BIT29
#define  FMC_DATAW2S0L_data_30       BIT30
#define  FMC_DATAW2S0L_data_31       BIT31

#define  FMC_DATAW2S1U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW2S1U_data_0        BIT0
#define  FMC_DATAW2S1U_data_1        BIT1
#define  FMC_DATAW2S1U_data_2        BIT2
#define  FMC_DATAW2S1U_data_3        BIT3
#define  FMC_DATAW2S1U_data_4        BIT4
#define  FMC_DATAW2S1U_data_5        BIT5
#define  FMC_DATAW2S1U_data_6        BIT6
#define  FMC_DATAW2S1U_data_7        BIT7
#define  FMC_DATAW2S1U_data_8        BIT8
#define  FMC_DATAW2S1U_data_9        BIT9
#define  FMC_DATAW2S1U_data_10       BIT10
#define  FMC_DATAW2S1U_data_11       BIT11
#define  FMC_DATAW2S1U_data_12       BIT12
#define  FMC_DATAW2S1U_data_13       BIT13
#define  FMC_DATAW2S1U_data_14       BIT14
#define  FMC_DATAW2S1U_data_15       BIT15
#define  FMC_DATAW2S1U_data_16       BIT16
#define  FMC_DATAW2S1U_data_17       BIT17
#define  FMC_DATAW2S1U_data_18       BIT18
#define  FMC_DATAW2S1U_data_19       BIT19
#define  FMC_DATAW2S1U_data_20       BIT20
#define  FMC_DATAW2S1U_data_21       BIT21
#define  FMC_DATAW2S1U_data_22       BIT22
#define  FMC_DATAW2S1U_data_23       BIT23
#define  FMC_DATAW2S1U_data_24       BIT24
#define  FMC_DATAW2S1U_data_25       BIT25
#define  FMC_DATAW2S1U_data_26       BIT26
#define  FMC_DATAW2S1U_data_27       BIT27
#define  FMC_DATAW2S1U_data_28       BIT28
#define  FMC_DATAW2S1U_data_29       BIT29
#define  FMC_DATAW2S1U_data_30       BIT30
#define  FMC_DATAW2S1U_data_31       BIT31

#define  FMC_DATAW2S1L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW2S1L_data_0        BIT0
#define  FMC_DATAW2S1L_data_1        BIT1
#define  FMC_DATAW2S1L_data_2        BIT2
#define  FMC_DATAW2S1L_data_3        BIT3
#define  FMC_DATAW2S1L_data_4        BIT4
#define  FMC_DATAW2S1L_data_5        BIT5
#define  FMC_DATAW2S1L_data_6        BIT6
#define  FMC_DATAW2S1L_data_7        BIT7
#define  FMC_DATAW2S1L_data_8        BIT8
#define  FMC_DATAW2S1L_data_9        BIT9
#define  FMC_DATAW2S1L_data_10       BIT10
#define  FMC_DATAW2S1L_data_11       BIT11
#define  FMC_DATAW2S1L_data_12       BIT12
#define  FMC_DATAW2S1L_data_13       BIT13
#define  FMC_DATAW2S1L_data_14       BIT14
#define  FMC_DATAW2S1L_data_15       BIT15
#define  FMC_DATAW2S1L_data_16       BIT16
#define  FMC_DATAW2S1L_data_17       BIT17
#define  FMC_DATAW2S1L_data_18       BIT18
#define  FMC_DATAW2S1L_data_19       BIT19
#define  FMC_DATAW2S1L_data_20       BIT20
#define  FMC_DATAW2S1L_data_21       BIT21
#define  FMC_DATAW2S1L_data_22       BIT22
#define  FMC_DATAW2S1L_data_23       BIT23
#define  FMC_DATAW2S1L_data_24       BIT24
#define  FMC_DATAW2S1L_data_25       BIT25
#define  FMC_DATAW2S1L_data_26       BIT26
#define  FMC_DATAW2S1L_data_27       BIT27
#define  FMC_DATAW2S1L_data_28       BIT28
#define  FMC_DATAW2S1L_data_29       BIT29
#define  FMC_DATAW2S1L_data_30       BIT30
#define  FMC_DATAW2S1L_data_31       BIT31

#define  FMC_DATAW2S2U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW2S2U_data_0        BIT0
#define  FMC_DATAW2S2U_data_1        BIT1
#define  FMC_DATAW2S2U_data_2        BIT2
#define  FMC_DATAW2S2U_data_3        BIT3
#define  FMC_DATAW2S2U_data_4        BIT4
#define  FMC_DATAW2S2U_data_5        BIT5
#define  FMC_DATAW2S2U_data_6        BIT6
#define  FMC_DATAW2S2U_data_7        BIT7
#define  FMC_DATAW2S2U_data_8        BIT8
#define  FMC_DATAW2S2U_data_9        BIT9
#define  FMC_DATAW2S2U_data_10       BIT10
#define  FMC_DATAW2S2U_data_11       BIT11
#define  FMC_DATAW2S2U_data_12       BIT12
#define  FMC_DATAW2S2U_data_13       BIT13
#define  FMC_DATAW2S2U_data_14       BIT14
#define  FMC_DATAW2S2U_data_15       BIT15
#define  FMC_DATAW2S2U_data_16       BIT16
#define  FMC_DATAW2S2U_data_17       BIT17
#define  FMC_DATAW2S2U_data_18       BIT18
#define  FMC_DATAW2S2U_data_19       BIT19
#define  FMC_DATAW2S2U_data_20       BIT20
#define  FMC_DATAW2S2U_data_21       BIT21
#define  FMC_DATAW2S2U_data_22       BIT22
#define  FMC_DATAW2S2U_data_23       BIT23
#define  FMC_DATAW2S2U_data_24       BIT24
#define  FMC_DATAW2S2U_data_25       BIT25
#define  FMC_DATAW2S2U_data_26       BIT26
#define  FMC_DATAW2S2U_data_27       BIT27
#define  FMC_DATAW2S2U_data_28       BIT28
#define  FMC_DATAW2S2U_data_29       BIT29
#define  FMC_DATAW2S2U_data_30       BIT30
#define  FMC_DATAW2S2U_data_31       BIT31

#define  FMC_DATAW2S2L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW2S2L_data_0        BIT0
#define  FMC_DATAW2S2L_data_1        BIT1
#define  FMC_DATAW2S2L_data_2        BIT2
#define  FMC_DATAW2S2L_data_3        BIT3
#define  FMC_DATAW2S2L_data_4        BIT4
#define  FMC_DATAW2S2L_data_5        BIT5
#define  FMC_DATAW2S2L_data_6        BIT6
#define  FMC_DATAW2S2L_data_7        BIT7
#define  FMC_DATAW2S2L_data_8        BIT8
#define  FMC_DATAW2S2L_data_9        BIT9
#define  FMC_DATAW2S2L_data_10       BIT10
#define  FMC_DATAW2S2L_data_11       BIT11
#define  FMC_DATAW2S2L_data_12       BIT12
#define  FMC_DATAW2S2L_data_13       BIT13
#define  FMC_DATAW2S2L_data_14       BIT14
#define  FMC_DATAW2S2L_data_15       BIT15
#define  FMC_DATAW2S2L_data_16       BIT16
#define  FMC_DATAW2S2L_data_17       BIT17
#define  FMC_DATAW2S2L_data_18       BIT18
#define  FMC_DATAW2S2L_data_19       BIT19
#define  FMC_DATAW2S2L_data_20       BIT20
#define  FMC_DATAW2S2L_data_21       BIT21
#define  FMC_DATAW2S2L_data_22       BIT22
#define  FMC_DATAW2S2L_data_23       BIT23
#define  FMC_DATAW2S2L_data_24       BIT24
#define  FMC_DATAW2S2L_data_25       BIT25
#define  FMC_DATAW2S2L_data_26       BIT26
#define  FMC_DATAW2S2L_data_27       BIT27
#define  FMC_DATAW2S2L_data_28       BIT28
#define  FMC_DATAW2S2L_data_29       BIT29
#define  FMC_DATAW2S2L_data_30       BIT30
#define  FMC_DATAW2S2L_data_31       BIT31

#define  FMC_DATAW2S3U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW2S3U_data_0        BIT0
#define  FMC_DATAW2S3U_data_1        BIT1
#define  FMC_DATAW2S3U_data_2        BIT2
#define  FMC_DATAW2S3U_data_3        BIT3
#define  FMC_DATAW2S3U_data_4        BIT4
#define  FMC_DATAW2S3U_data_5        BIT5
#define  FMC_DATAW2S3U_data_6        BIT6
#define  FMC_DATAW2S3U_data_7        BIT7
#define  FMC_DATAW2S3U_data_8        BIT8
#define  FMC_DATAW2S3U_data_9        BIT9
#define  FMC_DATAW2S3U_data_10       BIT10
#define  FMC_DATAW2S3U_data_11       BIT11
#define  FMC_DATAW2S3U_data_12       BIT12
#define  FMC_DATAW2S3U_data_13       BIT13
#define  FMC_DATAW2S3U_data_14       BIT14
#define  FMC_DATAW2S3U_data_15       BIT15
#define  FMC_DATAW2S3U_data_16       BIT16
#define  FMC_DATAW2S3U_data_17       BIT17
#define  FMC_DATAW2S3U_data_18       BIT18
#define  FMC_DATAW2S3U_data_19       BIT19
#define  FMC_DATAW2S3U_data_20       BIT20
#define  FMC_DATAW2S3U_data_21       BIT21
#define  FMC_DATAW2S3U_data_22       BIT22
#define  FMC_DATAW2S3U_data_23       BIT23
#define  FMC_DATAW2S3U_data_24       BIT24
#define  FMC_DATAW2S3U_data_25       BIT25
#define  FMC_DATAW2S3U_data_26       BIT26
#define  FMC_DATAW2S3U_data_27       BIT27
#define  FMC_DATAW2S3U_data_28       BIT28
#define  FMC_DATAW2S3U_data_29       BIT29
#define  FMC_DATAW2S3U_data_30       BIT30
#define  FMC_DATAW2S3U_data_31       BIT31

#define  FMC_DATAW2S3L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW2S3L_data_0        BIT0
#define  FMC_DATAW2S3L_data_1        BIT1
#define  FMC_DATAW2S3L_data_2        BIT2
#define  FMC_DATAW2S3L_data_3        BIT3
#define  FMC_DATAW2S3L_data_4        BIT4
#define  FMC_DATAW2S3L_data_5        BIT5
#define  FMC_DATAW2S3L_data_6        BIT6
#define  FMC_DATAW2S3L_data_7        BIT7
#define  FMC_DATAW2S3L_data_8        BIT8
#define  FMC_DATAW2S3L_data_9        BIT9
#define  FMC_DATAW2S3L_data_10       BIT10
#define  FMC_DATAW2S3L_data_11       BIT11
#define  FMC_DATAW2S3L_data_12       BIT12
#define  FMC_DATAW2S3L_data_13       BIT13
#define  FMC_DATAW2S3L_data_14       BIT14
#define  FMC_DATAW2S3L_data_15       BIT15
#define  FMC_DATAW2S3L_data_16       BIT16
#define  FMC_DATAW2S3L_data_17       BIT17
#define  FMC_DATAW2S3L_data_18       BIT18
#define  FMC_DATAW2S3L_data_19       BIT19
#define  FMC_DATAW2S3L_data_20       BIT20
#define  FMC_DATAW2S3L_data_21       BIT21
#define  FMC_DATAW2S3L_data_22       BIT22
#define  FMC_DATAW2S3L_data_23       BIT23
#define  FMC_DATAW2S3L_data_24       BIT24
#define  FMC_DATAW2S3L_data_25       BIT25
#define  FMC_DATAW2S3L_data_26       BIT26
#define  FMC_DATAW2S3L_data_27       BIT27
#define  FMC_DATAW2S3L_data_28       BIT28
#define  FMC_DATAW2S3L_data_29       BIT29
#define  FMC_DATAW2S3L_data_30       BIT30
#define  FMC_DATAW2S3L_data_31       BIT31

#define  FMC_DATAW2S4U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW2S4U_data_0        BIT0
#define  FMC_DATAW2S4U_data_1        BIT1
#define  FMC_DATAW2S4U_data_2        BIT2
#define  FMC_DATAW2S4U_data_3        BIT3
#define  FMC_DATAW2S4U_data_4        BIT4
#define  FMC_DATAW2S4U_data_5        BIT5
#define  FMC_DATAW2S4U_data_6        BIT6
#define  FMC_DATAW2S4U_data_7        BIT7
#define  FMC_DATAW2S4U_data_8        BIT8
#define  FMC_DATAW2S4U_data_9        BIT9
#define  FMC_DATAW2S4U_data_10       BIT10
#define  FMC_DATAW2S4U_data_11       BIT11
#define  FMC_DATAW2S4U_data_12       BIT12
#define  FMC_DATAW2S4U_data_13       BIT13
#define  FMC_DATAW2S4U_data_14       BIT14
#define  FMC_DATAW2S4U_data_15       BIT15
#define  FMC_DATAW2S4U_data_16       BIT16
#define  FMC_DATAW2S4U_data_17       BIT17
#define  FMC_DATAW2S4U_data_18       BIT18
#define  FMC_DATAW2S4U_data_19       BIT19
#define  FMC_DATAW2S4U_data_20       BIT20
#define  FMC_DATAW2S4U_data_21       BIT21
#define  FMC_DATAW2S4U_data_22       BIT22
#define  FMC_DATAW2S4U_data_23       BIT23
#define  FMC_DATAW2S4U_data_24       BIT24
#define  FMC_DATAW2S4U_data_25       BIT25
#define  FMC_DATAW2S4U_data_26       BIT26
#define  FMC_DATAW2S4U_data_27       BIT27
#define  FMC_DATAW2S4U_data_28       BIT28
#define  FMC_DATAW2S4U_data_29       BIT29
#define  FMC_DATAW2S4U_data_30       BIT30
#define  FMC_DATAW2S4U_data_31       BIT31

#define  FMC_DATAW2S4L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW2S4L_data_0        BIT0
#define  FMC_DATAW2S4L_data_1        BIT1
#define  FMC_DATAW2S4L_data_2        BIT2
#define  FMC_DATAW2S4L_data_3        BIT3
#define  FMC_DATAW2S4L_data_4        BIT4
#define  FMC_DATAW2S4L_data_5        BIT5
#define  FMC_DATAW2S4L_data_6        BIT6
#define  FMC_DATAW2S4L_data_7        BIT7
#define  FMC_DATAW2S4L_data_8        BIT8
#define  FMC_DATAW2S4L_data_9        BIT9
#define  FMC_DATAW2S4L_data_10       BIT10
#define  FMC_DATAW2S4L_data_11       BIT11
#define  FMC_DATAW2S4L_data_12       BIT12
#define  FMC_DATAW2S4L_data_13       BIT13
#define  FMC_DATAW2S4L_data_14       BIT14
#define  FMC_DATAW2S4L_data_15       BIT15
#define  FMC_DATAW2S4L_data_16       BIT16
#define  FMC_DATAW2S4L_data_17       BIT17
#define  FMC_DATAW2S4L_data_18       BIT18
#define  FMC_DATAW2S4L_data_19       BIT19
#define  FMC_DATAW2S4L_data_20       BIT20
#define  FMC_DATAW2S4L_data_21       BIT21
#define  FMC_DATAW2S4L_data_22       BIT22
#define  FMC_DATAW2S4L_data_23       BIT23
#define  FMC_DATAW2S4L_data_24       BIT24
#define  FMC_DATAW2S4L_data_25       BIT25
#define  FMC_DATAW2S4L_data_26       BIT26
#define  FMC_DATAW2S4L_data_27       BIT27
#define  FMC_DATAW2S4L_data_28       BIT28
#define  FMC_DATAW2S4L_data_29       BIT29
#define  FMC_DATAW2S4L_data_30       BIT30
#define  FMC_DATAW2S4L_data_31       BIT31

#define  FMC_DATAW2S5U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW2S5U_data_0        BIT0
#define  FMC_DATAW2S5U_data_1        BIT1
#define  FMC_DATAW2S5U_data_2        BIT2
#define  FMC_DATAW2S5U_data_3        BIT3
#define  FMC_DATAW2S5U_data_4        BIT4
#define  FMC_DATAW2S5U_data_5        BIT5
#define  FMC_DATAW2S5U_data_6        BIT6
#define  FMC_DATAW2S5U_data_7        BIT7
#define  FMC_DATAW2S5U_data_8        BIT8
#define  FMC_DATAW2S5U_data_9        BIT9
#define  FMC_DATAW2S5U_data_10       BIT10
#define  FMC_DATAW2S5U_data_11       BIT11
#define  FMC_DATAW2S5U_data_12       BIT12
#define  FMC_DATAW2S5U_data_13       BIT13
#define  FMC_DATAW2S5U_data_14       BIT14
#define  FMC_DATAW2S5U_data_15       BIT15
#define  FMC_DATAW2S5U_data_16       BIT16
#define  FMC_DATAW2S5U_data_17       BIT17
#define  FMC_DATAW2S5U_data_18       BIT18
#define  FMC_DATAW2S5U_data_19       BIT19
#define  FMC_DATAW2S5U_data_20       BIT20
#define  FMC_DATAW2S5U_data_21       BIT21
#define  FMC_DATAW2S5U_data_22       BIT22
#define  FMC_DATAW2S5U_data_23       BIT23
#define  FMC_DATAW2S5U_data_24       BIT24
#define  FMC_DATAW2S5U_data_25       BIT25
#define  FMC_DATAW2S5U_data_26       BIT26
#define  FMC_DATAW2S5U_data_27       BIT27
#define  FMC_DATAW2S5U_data_28       BIT28
#define  FMC_DATAW2S5U_data_29       BIT29
#define  FMC_DATAW2S5U_data_30       BIT30
#define  FMC_DATAW2S5U_data_31       BIT31

#define  FMC_DATAW2S5L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW2S5L_data_0        BIT0
#define  FMC_DATAW2S5L_data_1        BIT1
#define  FMC_DATAW2S5L_data_2        BIT2
#define  FMC_DATAW2S5L_data_3        BIT3
#define  FMC_DATAW2S5L_data_4        BIT4
#define  FMC_DATAW2S5L_data_5        BIT5
#define  FMC_DATAW2S5L_data_6        BIT6
#define  FMC_DATAW2S5L_data_7        BIT7
#define  FMC_DATAW2S5L_data_8        BIT8
#define  FMC_DATAW2S5L_data_9        BIT9
#define  FMC_DATAW2S5L_data_10       BIT10
#define  FMC_DATAW2S5L_data_11       BIT11
#define  FMC_DATAW2S5L_data_12       BIT12
#define  FMC_DATAW2S5L_data_13       BIT13
#define  FMC_DATAW2S5L_data_14       BIT14
#define  FMC_DATAW2S5L_data_15       BIT15
#define  FMC_DATAW2S5L_data_16       BIT16
#define  FMC_DATAW2S5L_data_17       BIT17
#define  FMC_DATAW2S5L_data_18       BIT18
#define  FMC_DATAW2S5L_data_19       BIT19
#define  FMC_DATAW2S5L_data_20       BIT20
#define  FMC_DATAW2S5L_data_21       BIT21
#define  FMC_DATAW2S5L_data_22       BIT22
#define  FMC_DATAW2S5L_data_23       BIT23
#define  FMC_DATAW2S5L_data_24       BIT24
#define  FMC_DATAW2S5L_data_25       BIT25
#define  FMC_DATAW2S5L_data_26       BIT26
#define  FMC_DATAW2S5L_data_27       BIT27
#define  FMC_DATAW2S5L_data_28       BIT28
#define  FMC_DATAW2S5L_data_29       BIT29
#define  FMC_DATAW2S5L_data_30       BIT30
#define  FMC_DATAW2S5L_data_31       BIT31

#define  FMC_DATAW2S6U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW2S6U_data_0        BIT0
#define  FMC_DATAW2S6U_data_1        BIT1
#define  FMC_DATAW2S6U_data_2        BIT2
#define  FMC_DATAW2S6U_data_3        BIT3
#define  FMC_DATAW2S6U_data_4        BIT4
#define  FMC_DATAW2S6U_data_5        BIT5
#define  FMC_DATAW2S6U_data_6        BIT6
#define  FMC_DATAW2S6U_data_7        BIT7
#define  FMC_DATAW2S6U_data_8        BIT8
#define  FMC_DATAW2S6U_data_9        BIT9
#define  FMC_DATAW2S6U_data_10       BIT10
#define  FMC_DATAW2S6U_data_11       BIT11
#define  FMC_DATAW2S6U_data_12       BIT12
#define  FMC_DATAW2S6U_data_13       BIT13
#define  FMC_DATAW2S6U_data_14       BIT14
#define  FMC_DATAW2S6U_data_15       BIT15
#define  FMC_DATAW2S6U_data_16       BIT16
#define  FMC_DATAW2S6U_data_17       BIT17
#define  FMC_DATAW2S6U_data_18       BIT18
#define  FMC_DATAW2S6U_data_19       BIT19
#define  FMC_DATAW2S6U_data_20       BIT20
#define  FMC_DATAW2S6U_data_21       BIT21
#define  FMC_DATAW2S6U_data_22       BIT22
#define  FMC_DATAW2S6U_data_23       BIT23
#define  FMC_DATAW2S6U_data_24       BIT24
#define  FMC_DATAW2S6U_data_25       BIT25
#define  FMC_DATAW2S6U_data_26       BIT26
#define  FMC_DATAW2S6U_data_27       BIT27
#define  FMC_DATAW2S6U_data_28       BIT28
#define  FMC_DATAW2S6U_data_29       BIT29
#define  FMC_DATAW2S6U_data_30       BIT30
#define  FMC_DATAW2S6U_data_31       BIT31

#define  FMC_DATAW2S6L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW2S6L_data_0        BIT0
#define  FMC_DATAW2S6L_data_1        BIT1
#define  FMC_DATAW2S6L_data_2        BIT2
#define  FMC_DATAW2S6L_data_3        BIT3
#define  FMC_DATAW2S6L_data_4        BIT4
#define  FMC_DATAW2S6L_data_5        BIT5
#define  FMC_DATAW2S6L_data_6        BIT6
#define  FMC_DATAW2S6L_data_7        BIT7
#define  FMC_DATAW2S6L_data_8        BIT8
#define  FMC_DATAW2S6L_data_9        BIT9
#define  FMC_DATAW2S6L_data_10       BIT10
#define  FMC_DATAW2S6L_data_11       BIT11
#define  FMC_DATAW2S6L_data_12       BIT12
#define  FMC_DATAW2S6L_data_13       BIT13
#define  FMC_DATAW2S6L_data_14       BIT14
#define  FMC_DATAW2S6L_data_15       BIT15
#define  FMC_DATAW2S6L_data_16       BIT16
#define  FMC_DATAW2S6L_data_17       BIT17
#define  FMC_DATAW2S6L_data_18       BIT18
#define  FMC_DATAW2S6L_data_19       BIT19
#define  FMC_DATAW2S6L_data_20       BIT20
#define  FMC_DATAW2S6L_data_21       BIT21
#define  FMC_DATAW2S6L_data_22       BIT22
#define  FMC_DATAW2S6L_data_23       BIT23
#define  FMC_DATAW2S6L_data_24       BIT24
#define  FMC_DATAW2S6L_data_25       BIT25
#define  FMC_DATAW2S6L_data_26       BIT26
#define  FMC_DATAW2S6L_data_27       BIT27
#define  FMC_DATAW2S6L_data_28       BIT28
#define  FMC_DATAW2S6L_data_29       BIT29
#define  FMC_DATAW2S6L_data_30       BIT30
#define  FMC_DATAW2S6L_data_31       BIT31

#define  FMC_DATAW2S7U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW2S7U_data_0        BIT0
#define  FMC_DATAW2S7U_data_1        BIT1
#define  FMC_DATAW2S7U_data_2        BIT2
#define  FMC_DATAW2S7U_data_3        BIT3
#define  FMC_DATAW2S7U_data_4        BIT4
#define  FMC_DATAW2S7U_data_5        BIT5
#define  FMC_DATAW2S7U_data_6        BIT6
#define  FMC_DATAW2S7U_data_7        BIT7
#define  FMC_DATAW2S7U_data_8        BIT8
#define  FMC_DATAW2S7U_data_9        BIT9
#define  FMC_DATAW2S7U_data_10       BIT10
#define  FMC_DATAW2S7U_data_11       BIT11
#define  FMC_DATAW2S7U_data_12       BIT12
#define  FMC_DATAW2S7U_data_13       BIT13
#define  FMC_DATAW2S7U_data_14       BIT14
#define  FMC_DATAW2S7U_data_15       BIT15
#define  FMC_DATAW2S7U_data_16       BIT16
#define  FMC_DATAW2S7U_data_17       BIT17
#define  FMC_DATAW2S7U_data_18       BIT18
#define  FMC_DATAW2S7U_data_19       BIT19
#define  FMC_DATAW2S7U_data_20       BIT20
#define  FMC_DATAW2S7U_data_21       BIT21
#define  FMC_DATAW2S7U_data_22       BIT22
#define  FMC_DATAW2S7U_data_23       BIT23
#define  FMC_DATAW2S7U_data_24       BIT24
#define  FMC_DATAW2S7U_data_25       BIT25
#define  FMC_DATAW2S7U_data_26       BIT26
#define  FMC_DATAW2S7U_data_27       BIT27
#define  FMC_DATAW2S7U_data_28       BIT28
#define  FMC_DATAW2S7U_data_29       BIT29
#define  FMC_DATAW2S7U_data_30       BIT30
#define  FMC_DATAW2S7U_data_31       BIT31

#define  FMC_DATAW2S7L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW2S7L_data_0        BIT0
#define  FMC_DATAW2S7L_data_1        BIT1
#define  FMC_DATAW2S7L_data_2        BIT2
#define  FMC_DATAW2S7L_data_3        BIT3
#define  FMC_DATAW2S7L_data_4        BIT4
#define  FMC_DATAW2S7L_data_5        BIT5
#define  FMC_DATAW2S7L_data_6        BIT6
#define  FMC_DATAW2S7L_data_7        BIT7
#define  FMC_DATAW2S7L_data_8        BIT8
#define  FMC_DATAW2S7L_data_9        BIT9
#define  FMC_DATAW2S7L_data_10       BIT10
#define  FMC_DATAW2S7L_data_11       BIT11
#define  FMC_DATAW2S7L_data_12       BIT12
#define  FMC_DATAW2S7L_data_13       BIT13
#define  FMC_DATAW2S7L_data_14       BIT14
#define  FMC_DATAW2S7L_data_15       BIT15
#define  FMC_DATAW2S7L_data_16       BIT16
#define  FMC_DATAW2S7L_data_17       BIT17
#define  FMC_DATAW2S7L_data_18       BIT18
#define  FMC_DATAW2S7L_data_19       BIT19
#define  FMC_DATAW2S7L_data_20       BIT20
#define  FMC_DATAW2S7L_data_21       BIT21
#define  FMC_DATAW2S7L_data_22       BIT22
#define  FMC_DATAW2S7L_data_23       BIT23
#define  FMC_DATAW2S7L_data_24       BIT24
#define  FMC_DATAW2S7L_data_25       BIT25
#define  FMC_DATAW2S7L_data_26       BIT26
#define  FMC_DATAW2S7L_data_27       BIT27
#define  FMC_DATAW2S7L_data_28       BIT28
#define  FMC_DATAW2S7L_data_29       BIT29
#define  FMC_DATAW2S7L_data_30       BIT30
#define  FMC_DATAW2S7L_data_31       BIT31

#define  FMC_DATAW3S0U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW3S0U_data_0        BIT0
#define  FMC_DATAW3S0U_data_1        BIT1
#define  FMC_DATAW3S0U_data_2        BIT2
#define  FMC_DATAW3S0U_data_3        BIT3
#define  FMC_DATAW3S0U_data_4        BIT4
#define  FMC_DATAW3S0U_data_5        BIT5
#define  FMC_DATAW3S0U_data_6        BIT6
#define  FMC_DATAW3S0U_data_7        BIT7
#define  FMC_DATAW3S0U_data_8        BIT8
#define  FMC_DATAW3S0U_data_9        BIT9
#define  FMC_DATAW3S0U_data_10       BIT10
#define  FMC_DATAW3S0U_data_11       BIT11
#define  FMC_DATAW3S0U_data_12       BIT12
#define  FMC_DATAW3S0U_data_13       BIT13
#define  FMC_DATAW3S0U_data_14       BIT14
#define  FMC_DATAW3S0U_data_15       BIT15
#define  FMC_DATAW3S0U_data_16       BIT16
#define  FMC_DATAW3S0U_data_17       BIT17
#define  FMC_DATAW3S0U_data_18       BIT18
#define  FMC_DATAW3S0U_data_19       BIT19
#define  FMC_DATAW3S0U_data_20       BIT20
#define  FMC_DATAW3S0U_data_21       BIT21
#define  FMC_DATAW3S0U_data_22       BIT22
#define  FMC_DATAW3S0U_data_23       BIT23
#define  FMC_DATAW3S0U_data_24       BIT24
#define  FMC_DATAW3S0U_data_25       BIT25
#define  FMC_DATAW3S0U_data_26       BIT26
#define  FMC_DATAW3S0U_data_27       BIT27
#define  FMC_DATAW3S0U_data_28       BIT28
#define  FMC_DATAW3S0U_data_29       BIT29
#define  FMC_DATAW3S0U_data_30       BIT30
#define  FMC_DATAW3S0U_data_31       BIT31

#define  FMC_DATAW3S0L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW3S0L_data_0        BIT0
#define  FMC_DATAW3S0L_data_1        BIT1
#define  FMC_DATAW3S0L_data_2        BIT2
#define  FMC_DATAW3S0L_data_3        BIT3
#define  FMC_DATAW3S0L_data_4        BIT4
#define  FMC_DATAW3S0L_data_5        BIT5
#define  FMC_DATAW3S0L_data_6        BIT6
#define  FMC_DATAW3S0L_data_7        BIT7
#define  FMC_DATAW3S0L_data_8        BIT8
#define  FMC_DATAW3S0L_data_9        BIT9
#define  FMC_DATAW3S0L_data_10       BIT10
#define  FMC_DATAW3S0L_data_11       BIT11
#define  FMC_DATAW3S0L_data_12       BIT12
#define  FMC_DATAW3S0L_data_13       BIT13
#define  FMC_DATAW3S0L_data_14       BIT14
#define  FMC_DATAW3S0L_data_15       BIT15
#define  FMC_DATAW3S0L_data_16       BIT16
#define  FMC_DATAW3S0L_data_17       BIT17
#define  FMC_DATAW3S0L_data_18       BIT18
#define  FMC_DATAW3S0L_data_19       BIT19
#define  FMC_DATAW3S0L_data_20       BIT20
#define  FMC_DATAW3S0L_data_21       BIT21
#define  FMC_DATAW3S0L_data_22       BIT22
#define  FMC_DATAW3S0L_data_23       BIT23
#define  FMC_DATAW3S0L_data_24       BIT24
#define  FMC_DATAW3S0L_data_25       BIT25
#define  FMC_DATAW3S0L_data_26       BIT26
#define  FMC_DATAW3S0L_data_27       BIT27
#define  FMC_DATAW3S0L_data_28       BIT28
#define  FMC_DATAW3S0L_data_29       BIT29
#define  FMC_DATAW3S0L_data_30       BIT30
#define  FMC_DATAW3S0L_data_31       BIT31

#define  FMC_DATAW3S1U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW3S1U_data_0        BIT0
#define  FMC_DATAW3S1U_data_1        BIT1
#define  FMC_DATAW3S1U_data_2        BIT2
#define  FMC_DATAW3S1U_data_3        BIT3
#define  FMC_DATAW3S1U_data_4        BIT4
#define  FMC_DATAW3S1U_data_5        BIT5
#define  FMC_DATAW3S1U_data_6        BIT6
#define  FMC_DATAW3S1U_data_7        BIT7
#define  FMC_DATAW3S1U_data_8        BIT8
#define  FMC_DATAW3S1U_data_9        BIT9
#define  FMC_DATAW3S1U_data_10       BIT10
#define  FMC_DATAW3S1U_data_11       BIT11
#define  FMC_DATAW3S1U_data_12       BIT12
#define  FMC_DATAW3S1U_data_13       BIT13
#define  FMC_DATAW3S1U_data_14       BIT14
#define  FMC_DATAW3S1U_data_15       BIT15
#define  FMC_DATAW3S1U_data_16       BIT16
#define  FMC_DATAW3S1U_data_17       BIT17
#define  FMC_DATAW3S1U_data_18       BIT18
#define  FMC_DATAW3S1U_data_19       BIT19
#define  FMC_DATAW3S1U_data_20       BIT20
#define  FMC_DATAW3S1U_data_21       BIT21
#define  FMC_DATAW3S1U_data_22       BIT22
#define  FMC_DATAW3S1U_data_23       BIT23
#define  FMC_DATAW3S1U_data_24       BIT24
#define  FMC_DATAW3S1U_data_25       BIT25
#define  FMC_DATAW3S1U_data_26       BIT26
#define  FMC_DATAW3S1U_data_27       BIT27
#define  FMC_DATAW3S1U_data_28       BIT28
#define  FMC_DATAW3S1U_data_29       BIT29
#define  FMC_DATAW3S1U_data_30       BIT30
#define  FMC_DATAW3S1U_data_31       BIT31

#define  FMC_DATAW3S1L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW3S1L_data_0        BIT0
#define  FMC_DATAW3S1L_data_1        BIT1
#define  FMC_DATAW3S1L_data_2        BIT2
#define  FMC_DATAW3S1L_data_3        BIT3
#define  FMC_DATAW3S1L_data_4        BIT4
#define  FMC_DATAW3S1L_data_5        BIT5
#define  FMC_DATAW3S1L_data_6        BIT6
#define  FMC_DATAW3S1L_data_7        BIT7
#define  FMC_DATAW3S1L_data_8        BIT8
#define  FMC_DATAW3S1L_data_9        BIT9
#define  FMC_DATAW3S1L_data_10       BIT10
#define  FMC_DATAW3S1L_data_11       BIT11
#define  FMC_DATAW3S1L_data_12       BIT12
#define  FMC_DATAW3S1L_data_13       BIT13
#define  FMC_DATAW3S1L_data_14       BIT14
#define  FMC_DATAW3S1L_data_15       BIT15
#define  FMC_DATAW3S1L_data_16       BIT16
#define  FMC_DATAW3S1L_data_17       BIT17
#define  FMC_DATAW3S1L_data_18       BIT18
#define  FMC_DATAW3S1L_data_19       BIT19
#define  FMC_DATAW3S1L_data_20       BIT20
#define  FMC_DATAW3S1L_data_21       BIT21
#define  FMC_DATAW3S1L_data_22       BIT22
#define  FMC_DATAW3S1L_data_23       BIT23
#define  FMC_DATAW3S1L_data_24       BIT24
#define  FMC_DATAW3S1L_data_25       BIT25
#define  FMC_DATAW3S1L_data_26       BIT26
#define  FMC_DATAW3S1L_data_27       BIT27
#define  FMC_DATAW3S1L_data_28       BIT28
#define  FMC_DATAW3S1L_data_29       BIT29
#define  FMC_DATAW3S1L_data_30       BIT30
#define  FMC_DATAW3S1L_data_31       BIT31

#define  FMC_DATAW3S2U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW3S2U_data_0        BIT0
#define  FMC_DATAW3S2U_data_1        BIT1
#define  FMC_DATAW3S2U_data_2        BIT2
#define  FMC_DATAW3S2U_data_3        BIT3
#define  FMC_DATAW3S2U_data_4        BIT4
#define  FMC_DATAW3S2U_data_5        BIT5
#define  FMC_DATAW3S2U_data_6        BIT6
#define  FMC_DATAW3S2U_data_7        BIT7
#define  FMC_DATAW3S2U_data_8        BIT8
#define  FMC_DATAW3S2U_data_9        BIT9
#define  FMC_DATAW3S2U_data_10       BIT10
#define  FMC_DATAW3S2U_data_11       BIT11
#define  FMC_DATAW3S2U_data_12       BIT12
#define  FMC_DATAW3S2U_data_13       BIT13
#define  FMC_DATAW3S2U_data_14       BIT14
#define  FMC_DATAW3S2U_data_15       BIT15
#define  FMC_DATAW3S2U_data_16       BIT16
#define  FMC_DATAW3S2U_data_17       BIT17
#define  FMC_DATAW3S2U_data_18       BIT18
#define  FMC_DATAW3S2U_data_19       BIT19
#define  FMC_DATAW3S2U_data_20       BIT20
#define  FMC_DATAW3S2U_data_21       BIT21
#define  FMC_DATAW3S2U_data_22       BIT22
#define  FMC_DATAW3S2U_data_23       BIT23
#define  FMC_DATAW3S2U_data_24       BIT24
#define  FMC_DATAW3S2U_data_25       BIT25
#define  FMC_DATAW3S2U_data_26       BIT26
#define  FMC_DATAW3S2U_data_27       BIT27
#define  FMC_DATAW3S2U_data_28       BIT28
#define  FMC_DATAW3S2U_data_29       BIT29
#define  FMC_DATAW3S2U_data_30       BIT30
#define  FMC_DATAW3S2U_data_31       BIT31

#define  FMC_DATAW3S2L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW3S2L_data_0        BIT0
#define  FMC_DATAW3S2L_data_1        BIT1
#define  FMC_DATAW3S2L_data_2        BIT2
#define  FMC_DATAW3S2L_data_3        BIT3
#define  FMC_DATAW3S2L_data_4        BIT4
#define  FMC_DATAW3S2L_data_5        BIT5
#define  FMC_DATAW3S2L_data_6        BIT6
#define  FMC_DATAW3S2L_data_7        BIT7
#define  FMC_DATAW3S2L_data_8        BIT8
#define  FMC_DATAW3S2L_data_9        BIT9
#define  FMC_DATAW3S2L_data_10       BIT10
#define  FMC_DATAW3S2L_data_11       BIT11
#define  FMC_DATAW3S2L_data_12       BIT12
#define  FMC_DATAW3S2L_data_13       BIT13
#define  FMC_DATAW3S2L_data_14       BIT14
#define  FMC_DATAW3S2L_data_15       BIT15
#define  FMC_DATAW3S2L_data_16       BIT16
#define  FMC_DATAW3S2L_data_17       BIT17
#define  FMC_DATAW3S2L_data_18       BIT18
#define  FMC_DATAW3S2L_data_19       BIT19
#define  FMC_DATAW3S2L_data_20       BIT20
#define  FMC_DATAW3S2L_data_21       BIT21
#define  FMC_DATAW3S2L_data_22       BIT22
#define  FMC_DATAW3S2L_data_23       BIT23
#define  FMC_DATAW3S2L_data_24       BIT24
#define  FMC_DATAW3S2L_data_25       BIT25
#define  FMC_DATAW3S2L_data_26       BIT26
#define  FMC_DATAW3S2L_data_27       BIT27
#define  FMC_DATAW3S2L_data_28       BIT28
#define  FMC_DATAW3S2L_data_29       BIT29
#define  FMC_DATAW3S2L_data_30       BIT30
#define  FMC_DATAW3S2L_data_31       BIT31

#define  FMC_DATAW3S3U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW3S3U_data_0        BIT0
#define  FMC_DATAW3S3U_data_1        BIT1
#define  FMC_DATAW3S3U_data_2        BIT2
#define  FMC_DATAW3S3U_data_3        BIT3
#define  FMC_DATAW3S3U_data_4        BIT4
#define  FMC_DATAW3S3U_data_5        BIT5
#define  FMC_DATAW3S3U_data_6        BIT6
#define  FMC_DATAW3S3U_data_7        BIT7
#define  FMC_DATAW3S3U_data_8        BIT8
#define  FMC_DATAW3S3U_data_9        BIT9
#define  FMC_DATAW3S3U_data_10       BIT10
#define  FMC_DATAW3S3U_data_11       BIT11
#define  FMC_DATAW3S3U_data_12       BIT12
#define  FMC_DATAW3S3U_data_13       BIT13
#define  FMC_DATAW3S3U_data_14       BIT14
#define  FMC_DATAW3S3U_data_15       BIT15
#define  FMC_DATAW3S3U_data_16       BIT16
#define  FMC_DATAW3S3U_data_17       BIT17
#define  FMC_DATAW3S3U_data_18       BIT18
#define  FMC_DATAW3S3U_data_19       BIT19
#define  FMC_DATAW3S3U_data_20       BIT20
#define  FMC_DATAW3S3U_data_21       BIT21
#define  FMC_DATAW3S3U_data_22       BIT22
#define  FMC_DATAW3S3U_data_23       BIT23
#define  FMC_DATAW3S3U_data_24       BIT24
#define  FMC_DATAW3S3U_data_25       BIT25
#define  FMC_DATAW3S3U_data_26       BIT26
#define  FMC_DATAW3S3U_data_27       BIT27
#define  FMC_DATAW3S3U_data_28       BIT28
#define  FMC_DATAW3S3U_data_29       BIT29
#define  FMC_DATAW3S3U_data_30       BIT30
#define  FMC_DATAW3S3U_data_31       BIT31

#define  FMC_DATAW3S3L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW3S3L_data_0        BIT0
#define  FMC_DATAW3S3L_data_1        BIT1
#define  FMC_DATAW3S3L_data_2        BIT2
#define  FMC_DATAW3S3L_data_3        BIT3
#define  FMC_DATAW3S3L_data_4        BIT4
#define  FMC_DATAW3S3L_data_5        BIT5
#define  FMC_DATAW3S3L_data_6        BIT6
#define  FMC_DATAW3S3L_data_7        BIT7
#define  FMC_DATAW3S3L_data_8        BIT8
#define  FMC_DATAW3S3L_data_9        BIT9
#define  FMC_DATAW3S3L_data_10       BIT10
#define  FMC_DATAW3S3L_data_11       BIT11
#define  FMC_DATAW3S3L_data_12       BIT12
#define  FMC_DATAW3S3L_data_13       BIT13
#define  FMC_DATAW3S3L_data_14       BIT14
#define  FMC_DATAW3S3L_data_15       BIT15
#define  FMC_DATAW3S3L_data_16       BIT16
#define  FMC_DATAW3S3L_data_17       BIT17
#define  FMC_DATAW3S3L_data_18       BIT18
#define  FMC_DATAW3S3L_data_19       BIT19
#define  FMC_DATAW3S3L_data_20       BIT20
#define  FMC_DATAW3S3L_data_21       BIT21
#define  FMC_DATAW3S3L_data_22       BIT22
#define  FMC_DATAW3S3L_data_23       BIT23
#define  FMC_DATAW3S3L_data_24       BIT24
#define  FMC_DATAW3S3L_data_25       BIT25
#define  FMC_DATAW3S3L_data_26       BIT26
#define  FMC_DATAW3S3L_data_27       BIT27
#define  FMC_DATAW3S3L_data_28       BIT28
#define  FMC_DATAW3S3L_data_29       BIT29
#define  FMC_DATAW3S3L_data_30       BIT30
#define  FMC_DATAW3S3L_data_31       BIT31

#define  FMC_DATAW3S4U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW3S4U_data_0        BIT0
#define  FMC_DATAW3S4U_data_1        BIT1
#define  FMC_DATAW3S4U_data_2        BIT2
#define  FMC_DATAW3S4U_data_3        BIT3
#define  FMC_DATAW3S4U_data_4        BIT4
#define  FMC_DATAW3S4U_data_5        BIT5
#define  FMC_DATAW3S4U_data_6        BIT6
#define  FMC_DATAW3S4U_data_7        BIT7
#define  FMC_DATAW3S4U_data_8        BIT8
#define  FMC_DATAW3S4U_data_9        BIT9
#define  FMC_DATAW3S4U_data_10       BIT10
#define  FMC_DATAW3S4U_data_11       BIT11
#define  FMC_DATAW3S4U_data_12       BIT12
#define  FMC_DATAW3S4U_data_13       BIT13
#define  FMC_DATAW3S4U_data_14       BIT14
#define  FMC_DATAW3S4U_data_15       BIT15
#define  FMC_DATAW3S4U_data_16       BIT16
#define  FMC_DATAW3S4U_data_17       BIT17
#define  FMC_DATAW3S4U_data_18       BIT18
#define  FMC_DATAW3S4U_data_19       BIT19
#define  FMC_DATAW3S4U_data_20       BIT20
#define  FMC_DATAW3S4U_data_21       BIT21
#define  FMC_DATAW3S4U_data_22       BIT22
#define  FMC_DATAW3S4U_data_23       BIT23
#define  FMC_DATAW3S4U_data_24       BIT24
#define  FMC_DATAW3S4U_data_25       BIT25
#define  FMC_DATAW3S4U_data_26       BIT26
#define  FMC_DATAW3S4U_data_27       BIT27
#define  FMC_DATAW3S4U_data_28       BIT28
#define  FMC_DATAW3S4U_data_29       BIT29
#define  FMC_DATAW3S4U_data_30       BIT30
#define  FMC_DATAW3S4U_data_31       BIT31

#define  FMC_DATAW3S4L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW3S4L_data_0        BIT0
#define  FMC_DATAW3S4L_data_1        BIT1
#define  FMC_DATAW3S4L_data_2        BIT2
#define  FMC_DATAW3S4L_data_3        BIT3
#define  FMC_DATAW3S4L_data_4        BIT4
#define  FMC_DATAW3S4L_data_5        BIT5
#define  FMC_DATAW3S4L_data_6        BIT6
#define  FMC_DATAW3S4L_data_7        BIT7
#define  FMC_DATAW3S4L_data_8        BIT8
#define  FMC_DATAW3S4L_data_9        BIT9
#define  FMC_DATAW3S4L_data_10       BIT10
#define  FMC_DATAW3S4L_data_11       BIT11
#define  FMC_DATAW3S4L_data_12       BIT12
#define  FMC_DATAW3S4L_data_13       BIT13
#define  FMC_DATAW3S4L_data_14       BIT14
#define  FMC_DATAW3S4L_data_15       BIT15
#define  FMC_DATAW3S4L_data_16       BIT16
#define  FMC_DATAW3S4L_data_17       BIT17
#define  FMC_DATAW3S4L_data_18       BIT18
#define  FMC_DATAW3S4L_data_19       BIT19
#define  FMC_DATAW3S4L_data_20       BIT20
#define  FMC_DATAW3S4L_data_21       BIT21
#define  FMC_DATAW3S4L_data_22       BIT22
#define  FMC_DATAW3S4L_data_23       BIT23
#define  FMC_DATAW3S4L_data_24       BIT24
#define  FMC_DATAW3S4L_data_25       BIT25
#define  FMC_DATAW3S4L_data_26       BIT26
#define  FMC_DATAW3S4L_data_27       BIT27
#define  FMC_DATAW3S4L_data_28       BIT28
#define  FMC_DATAW3S4L_data_29       BIT29
#define  FMC_DATAW3S4L_data_30       BIT30
#define  FMC_DATAW3S4L_data_31       BIT31

#define  FMC_DATAW3S5U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW3S5U_data_0        BIT0
#define  FMC_DATAW3S5U_data_1        BIT1
#define  FMC_DATAW3S5U_data_2        BIT2
#define  FMC_DATAW3S5U_data_3        BIT3
#define  FMC_DATAW3S5U_data_4        BIT4
#define  FMC_DATAW3S5U_data_5        BIT5
#define  FMC_DATAW3S5U_data_6        BIT6
#define  FMC_DATAW3S5U_data_7        BIT7
#define  FMC_DATAW3S5U_data_8        BIT8
#define  FMC_DATAW3S5U_data_9        BIT9
#define  FMC_DATAW3S5U_data_10       BIT10
#define  FMC_DATAW3S5U_data_11       BIT11
#define  FMC_DATAW3S5U_data_12       BIT12
#define  FMC_DATAW3S5U_data_13       BIT13
#define  FMC_DATAW3S5U_data_14       BIT14
#define  FMC_DATAW3S5U_data_15       BIT15
#define  FMC_DATAW3S5U_data_16       BIT16
#define  FMC_DATAW3S5U_data_17       BIT17
#define  FMC_DATAW3S5U_data_18       BIT18
#define  FMC_DATAW3S5U_data_19       BIT19
#define  FMC_DATAW3S5U_data_20       BIT20
#define  FMC_DATAW3S5U_data_21       BIT21
#define  FMC_DATAW3S5U_data_22       BIT22
#define  FMC_DATAW3S5U_data_23       BIT23
#define  FMC_DATAW3S5U_data_24       BIT24
#define  FMC_DATAW3S5U_data_25       BIT25
#define  FMC_DATAW3S5U_data_26       BIT26
#define  FMC_DATAW3S5U_data_27       BIT27
#define  FMC_DATAW3S5U_data_28       BIT28
#define  FMC_DATAW3S5U_data_29       BIT29
#define  FMC_DATAW3S5U_data_30       BIT30
#define  FMC_DATAW3S5U_data_31       BIT31

#define  FMC_DATAW3S5L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW3S5L_data_0        BIT0
#define  FMC_DATAW3S5L_data_1        BIT1
#define  FMC_DATAW3S5L_data_2        BIT2
#define  FMC_DATAW3S5L_data_3        BIT3
#define  FMC_DATAW3S5L_data_4        BIT4
#define  FMC_DATAW3S5L_data_5        BIT5
#define  FMC_DATAW3S5L_data_6        BIT6
#define  FMC_DATAW3S5L_data_7        BIT7
#define  FMC_DATAW3S5L_data_8        BIT8
#define  FMC_DATAW3S5L_data_9        BIT9
#define  FMC_DATAW3S5L_data_10       BIT10
#define  FMC_DATAW3S5L_data_11       BIT11
#define  FMC_DATAW3S5L_data_12       BIT12
#define  FMC_DATAW3S5L_data_13       BIT13
#define  FMC_DATAW3S5L_data_14       BIT14
#define  FMC_DATAW3S5L_data_15       BIT15
#define  FMC_DATAW3S5L_data_16       BIT16
#define  FMC_DATAW3S5L_data_17       BIT17
#define  FMC_DATAW3S5L_data_18       BIT18
#define  FMC_DATAW3S5L_data_19       BIT19
#define  FMC_DATAW3S5L_data_20       BIT20
#define  FMC_DATAW3S5L_data_21       BIT21
#define  FMC_DATAW3S5L_data_22       BIT22
#define  FMC_DATAW3S5L_data_23       BIT23
#define  FMC_DATAW3S5L_data_24       BIT24
#define  FMC_DATAW3S5L_data_25       BIT25
#define  FMC_DATAW3S5L_data_26       BIT26
#define  FMC_DATAW3S5L_data_27       BIT27
#define  FMC_DATAW3S5L_data_28       BIT28
#define  FMC_DATAW3S5L_data_29       BIT29
#define  FMC_DATAW3S5L_data_30       BIT30
#define  FMC_DATAW3S5L_data_31       BIT31

#define  FMC_DATAW3S6U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW3S6U_data_0        BIT0
#define  FMC_DATAW3S6U_data_1        BIT1
#define  FMC_DATAW3S6U_data_2        BIT2
#define  FMC_DATAW3S6U_data_3        BIT3
#define  FMC_DATAW3S6U_data_4        BIT4
#define  FMC_DATAW3S6U_data_5        BIT5
#define  FMC_DATAW3S6U_data_6        BIT6
#define  FMC_DATAW3S6U_data_7        BIT7
#define  FMC_DATAW3S6U_data_8        BIT8
#define  FMC_DATAW3S6U_data_9        BIT9
#define  FMC_DATAW3S6U_data_10       BIT10
#define  FMC_DATAW3S6U_data_11       BIT11
#define  FMC_DATAW3S6U_data_12       BIT12
#define  FMC_DATAW3S6U_data_13       BIT13
#define  FMC_DATAW3S6U_data_14       BIT14
#define  FMC_DATAW3S6U_data_15       BIT15
#define  FMC_DATAW3S6U_data_16       BIT16
#define  FMC_DATAW3S6U_data_17       BIT17
#define  FMC_DATAW3S6U_data_18       BIT18
#define  FMC_DATAW3S6U_data_19       BIT19
#define  FMC_DATAW3S6U_data_20       BIT20
#define  FMC_DATAW3S6U_data_21       BIT21
#define  FMC_DATAW3S6U_data_22       BIT22
#define  FMC_DATAW3S6U_data_23       BIT23
#define  FMC_DATAW3S6U_data_24       BIT24
#define  FMC_DATAW3S6U_data_25       BIT25
#define  FMC_DATAW3S6U_data_26       BIT26
#define  FMC_DATAW3S6U_data_27       BIT27
#define  FMC_DATAW3S6U_data_28       BIT28
#define  FMC_DATAW3S6U_data_29       BIT29
#define  FMC_DATAW3S6U_data_30       BIT30
#define  FMC_DATAW3S6U_data_31       BIT31

#define  FMC_DATAW3S6L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW3S6L_data_0        BIT0
#define  FMC_DATAW3S6L_data_1        BIT1
#define  FMC_DATAW3S6L_data_2        BIT2
#define  FMC_DATAW3S6L_data_3        BIT3
#define  FMC_DATAW3S6L_data_4        BIT4
#define  FMC_DATAW3S6L_data_5        BIT5
#define  FMC_DATAW3S6L_data_6        BIT6
#define  FMC_DATAW3S6L_data_7        BIT7
#define  FMC_DATAW3S6L_data_8        BIT8
#define  FMC_DATAW3S6L_data_9        BIT9
#define  FMC_DATAW3S6L_data_10       BIT10
#define  FMC_DATAW3S6L_data_11       BIT11
#define  FMC_DATAW3S6L_data_12       BIT12
#define  FMC_DATAW3S6L_data_13       BIT13
#define  FMC_DATAW3S6L_data_14       BIT14
#define  FMC_DATAW3S6L_data_15       BIT15
#define  FMC_DATAW3S6L_data_16       BIT16
#define  FMC_DATAW3S6L_data_17       BIT17
#define  FMC_DATAW3S6L_data_18       BIT18
#define  FMC_DATAW3S6L_data_19       BIT19
#define  FMC_DATAW3S6L_data_20       BIT20
#define  FMC_DATAW3S6L_data_21       BIT21
#define  FMC_DATAW3S6L_data_22       BIT22
#define  FMC_DATAW3S6L_data_23       BIT23
#define  FMC_DATAW3S6L_data_24       BIT24
#define  FMC_DATAW3S6L_data_25       BIT25
#define  FMC_DATAW3S6L_data_26       BIT26
#define  FMC_DATAW3S6L_data_27       BIT27
#define  FMC_DATAW3S6L_data_28       BIT28
#define  FMC_DATAW3S6L_data_29       BIT29
#define  FMC_DATAW3S6L_data_30       BIT30
#define  FMC_DATAW3S6L_data_31       BIT31

#define  FMC_DATAW3S7U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [63:32] of data entry
#define  FMC_DATAW3S7U_data_0        BIT0
#define  FMC_DATAW3S7U_data_1        BIT1
#define  FMC_DATAW3S7U_data_2        BIT2
#define  FMC_DATAW3S7U_data_3        BIT3
#define  FMC_DATAW3S7U_data_4        BIT4
#define  FMC_DATAW3S7U_data_5        BIT5
#define  FMC_DATAW3S7U_data_6        BIT6
#define  FMC_DATAW3S7U_data_7        BIT7
#define  FMC_DATAW3S7U_data_8        BIT8
#define  FMC_DATAW3S7U_data_9        BIT9
#define  FMC_DATAW3S7U_data_10       BIT10
#define  FMC_DATAW3S7U_data_11       BIT11
#define  FMC_DATAW3S7U_data_12       BIT12
#define  FMC_DATAW3S7U_data_13       BIT13
#define  FMC_DATAW3S7U_data_14       BIT14
#define  FMC_DATAW3S7U_data_15       BIT15
#define  FMC_DATAW3S7U_data_16       BIT16
#define  FMC_DATAW3S7U_data_17       BIT17
#define  FMC_DATAW3S7U_data_18       BIT18
#define  FMC_DATAW3S7U_data_19       BIT19
#define  FMC_DATAW3S7U_data_20       BIT20
#define  FMC_DATAW3S7U_data_21       BIT21
#define  FMC_DATAW3S7U_data_22       BIT22
#define  FMC_DATAW3S7U_data_23       BIT23
#define  FMC_DATAW3S7U_data_24       BIT24
#define  FMC_DATAW3S7U_data_25       BIT25
#define  FMC_DATAW3S7U_data_26       BIT26
#define  FMC_DATAW3S7U_data_27       BIT27
#define  FMC_DATAW3S7U_data_28       BIT28
#define  FMC_DATAW3S7U_data_29       BIT29
#define  FMC_DATAW3S7U_data_30       BIT30
#define  FMC_DATAW3S7U_data_31       BIT31

#define  FMC_DATAW3S7L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Bits [31:0] of data entry
#define  FMC_DATAW3S7L_data_0        BIT0
#define  FMC_DATAW3S7L_data_1        BIT1
#define  FMC_DATAW3S7L_data_2        BIT2
#define  FMC_DATAW3S7L_data_3        BIT3
#define  FMC_DATAW3S7L_data_4        BIT4
#define  FMC_DATAW3S7L_data_5        BIT5
#define  FMC_DATAW3S7L_data_6        BIT6
#define  FMC_DATAW3S7L_data_7        BIT7
#define  FMC_DATAW3S7L_data_8        BIT8
#define  FMC_DATAW3S7L_data_9        BIT9
#define  FMC_DATAW3S7L_data_10       BIT10
#define  FMC_DATAW3S7L_data_11       BIT11
#define  FMC_DATAW3S7L_data_12       BIT12
#define  FMC_DATAW3S7L_data_13       BIT13
#define  FMC_DATAW3S7L_data_14       BIT14
#define  FMC_DATAW3S7L_data_15       BIT15
#define  FMC_DATAW3S7L_data_16       BIT16
#define  FMC_DATAW3S7L_data_17       BIT17
#define  FMC_DATAW3S7L_data_18       BIT18
#define  FMC_DATAW3S7L_data_19       BIT19
#define  FMC_DATAW3S7L_data_20       BIT20
#define  FMC_DATAW3S7L_data_21       BIT21
#define  FMC_DATAW3S7L_data_22       BIT22
#define  FMC_DATAW3S7L_data_23       BIT23
#define  FMC_DATAW3S7L_data_24       BIT24
#define  FMC_DATAW3S7L_data_25       BIT25
#define  FMC_DATAW3S7L_data_26       BIT26
#define  FMC_DATAW3S7L_data_27       BIT27
#define  FMC_DATAW3S7L_data_28       BIT28
#define  FMC_DATAW3S7L_data_29       BIT29
#define  FMC_DATAW3S7L_data_30       BIT30
#define  FMC_DATAW3S7L_data_31       BIT31

#define  FTFL_FSTAT_MGSTAT0          BIT0
//   Memory Controller Command Completion Status Flag

#define  FTFL_FSTAT_FPVIOL           BIT4
//   Flash Protection Violation Flag
//     0b0 ==> No protection violation detected
//     0b1 ==> Protection violation detected

#define  FTFL_FSTAT_ACCERR           BIT5
//   Flash Access Error Flag
//     0b0 ==> No access error detected
//     0b1 ==> Access error detected

#define  FTFL_FSTAT_RDCOLERR         BIT6
//   FTFL Read Collision Error Flag
//     0b0 ==> No collision error detected
//     0b1 ==> Collision error detected

#define  FTFL_FSTAT_CCIF             BIT7
//   Command Complete Interrupt Flag
//     0b0 ==> FTFL command or EEPROM file system operation in progress
//     0b1 ==> FTFL command or EEPROM file system operation has completed

#define  FTFL_FCNFG_EEERDY           BIT0
//     0b0 ==> FlexRAM is not available for EEPROM operation.
//     0b1 ==> FlexRAM is available for EEPROM operations where: reads from the FlexRAM return data previously written to the FlexRAM in EEPROM mode and writes to the FlexRAM clear EEERDY and launch an EEPROM operation to store the written data in the FlexRAM and EEPROM backup.

#define  FTFL_FCNFG_RAMRDY           BIT1
//   RAM Ready
//     0b0 ==> FlexRAM is not available for traditional RAM access.
//     0b1 ==> FlexRAM is available as traditional RAM only; writes to the FlexRAM do not trigger EEPROM operations.

#define  FTFL_FCNFG_PFLSH            BIT2
//   FTFL configuration
//     0b0 ==> FTFL configured for FlexMemory that supports data flash and/or EEPROM
//     0b1 ==> Reserved

#define  FTFL_FCNFG_ERSSUSP          BIT4
//   Erase Suspend
//     0b0 ==> No suspend requested
//     0b1 ==> Suspend the current Erase Flash Sector command execution.

#define  FTFL_FCNFG_ERSAREQ          BIT5
//   Erase All Request
//     0b0 ==> No request or request complete
//     0b1 ==> Request to: run the Erase All Blocks command, verify the erased state, program the security byte in the Flash Configuration Field to the unsecure state, and release MCU security by setting the FSEC[SEC] field to the unsecure state.

#define  FTFL_FCNFG_RDCOLLIE         BIT6
//   Read Collision Error Interrupt Enable
//     0b0 ==> Read collision error interrupt disabled
//     0b1 ==> Read collision error interrupt enabled. An interrupt request is generated whenever an FTFL read collision error is detected (see the description of FSTAT[RDCOLERR]).

#define  FTFL_FCNFG_CCIE             BIT7
//   Command Complete Interrupt Enable
//     0b0 ==> Command complete interrupt disabled
//     0b1 ==> Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.

#define  FTFL_FSEC_SEC               (BIT0|BIT1)
//   Flash Security
//     0b00 ==> MCU security status is secure
//     0b01 ==> MCU security status is secure
//     0b10 ==> MCU security status is unsecure (The standard shipping condition of the FTFL is unsecure.)
//     0b11 ==> MCU security status is secure
#define  FTFL_FSEC_SEC_0             BIT0
#define  FTFL_FSEC_SEC_1             BIT1

#define  FTFL_FSEC_FSLACC            (BIT2|BIT3)
//   Freescale Failure Analysis Access Code
//     0b00 ==> Freescale factory access granted
//     0b01 ==> Freescale factory access denied
//     0b10 ==> Freescale factory access denied
//     0b11 ==> Freescale factory access granted
#define  FTFL_FSEC_FSLACC_0          BIT2
#define  FTFL_FSEC_FSLACC_1          BIT3

#define  FTFL_FSEC_MEEN              (BIT4|BIT5)
//   Mass Erase Enable Bits
//     0b00 ==> Mass erase is enabled
//     0b01 ==> Mass erase is enabled
//     0b10 ==> Mass erase is disabled
//     0b11 ==> Mass erase is enabled
#define  FTFL_FSEC_MEEN_0            BIT4
#define  FTFL_FSEC_MEEN_1            BIT5

#define  FTFL_FSEC_KEYEN             (BIT6|BIT7)
//   Backdoor Key Security Enable
//     0b00 ==> Backdoor key access disabled
//     0b01 ==> Backdoor key access disabled (preferred KEYEN state to disable backdoor key access)
//     0b10 ==> Backdoor key access enabled
//     0b11 ==> Backdoor key access disabled
#define  FTFL_FSEC_KEYEN_0           BIT6
#define  FTFL_FSEC_KEYEN_1           BIT7

#define  FTFL_FOPT_OPT               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Nonvolatile Option
#define  FTFL_FOPT_OPT_0             BIT0
#define  FTFL_FOPT_OPT_1             BIT1
#define  FTFL_FOPT_OPT_2             BIT2
#define  FTFL_FOPT_OPT_3             BIT3
#define  FTFL_FOPT_OPT_4             BIT4
#define  FTFL_FOPT_OPT_5             BIT5
#define  FTFL_FOPT_OPT_6             BIT6
#define  FTFL_FOPT_OPT_7             BIT7

#define  FTFL_FCCOB3_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB3_CCOBn_0         BIT0
#define  FTFL_FCCOB3_CCOBn_1         BIT1
#define  FTFL_FCCOB3_CCOBn_2         BIT2
#define  FTFL_FCCOB3_CCOBn_3         BIT3
#define  FTFL_FCCOB3_CCOBn_4         BIT4
#define  FTFL_FCCOB3_CCOBn_5         BIT5
#define  FTFL_FCCOB3_CCOBn_6         BIT6
#define  FTFL_FCCOB3_CCOBn_7         BIT7

#define  FTFL_FCCOB2_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB2_CCOBn_0         BIT0
#define  FTFL_FCCOB2_CCOBn_1         BIT1
#define  FTFL_FCCOB2_CCOBn_2         BIT2
#define  FTFL_FCCOB2_CCOBn_3         BIT3
#define  FTFL_FCCOB2_CCOBn_4         BIT4
#define  FTFL_FCCOB2_CCOBn_5         BIT5
#define  FTFL_FCCOB2_CCOBn_6         BIT6
#define  FTFL_FCCOB2_CCOBn_7         BIT7

#define  FTFL_FCCOB1_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB1_CCOBn_0         BIT0
#define  FTFL_FCCOB1_CCOBn_1         BIT1
#define  FTFL_FCCOB1_CCOBn_2         BIT2
#define  FTFL_FCCOB1_CCOBn_3         BIT3
#define  FTFL_FCCOB1_CCOBn_4         BIT4
#define  FTFL_FCCOB1_CCOBn_5         BIT5
#define  FTFL_FCCOB1_CCOBn_6         BIT6
#define  FTFL_FCCOB1_CCOBn_7         BIT7

#define  FTFL_FCCOB0_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB0_CCOBn_0         BIT0
#define  FTFL_FCCOB0_CCOBn_1         BIT1
#define  FTFL_FCCOB0_CCOBn_2         BIT2
#define  FTFL_FCCOB0_CCOBn_3         BIT3
#define  FTFL_FCCOB0_CCOBn_4         BIT4
#define  FTFL_FCCOB0_CCOBn_5         BIT5
#define  FTFL_FCCOB0_CCOBn_6         BIT6
#define  FTFL_FCCOB0_CCOBn_7         BIT7

#define  FTFL_FCCOB7_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB7_CCOBn_0         BIT0
#define  FTFL_FCCOB7_CCOBn_1         BIT1
#define  FTFL_FCCOB7_CCOBn_2         BIT2
#define  FTFL_FCCOB7_CCOBn_3         BIT3
#define  FTFL_FCCOB7_CCOBn_4         BIT4
#define  FTFL_FCCOB7_CCOBn_5         BIT5
#define  FTFL_FCCOB7_CCOBn_6         BIT6
#define  FTFL_FCCOB7_CCOBn_7         BIT7

#define  FTFL_FCCOB6_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB6_CCOBn_0         BIT0
#define  FTFL_FCCOB6_CCOBn_1         BIT1
#define  FTFL_FCCOB6_CCOBn_2         BIT2
#define  FTFL_FCCOB6_CCOBn_3         BIT3
#define  FTFL_FCCOB6_CCOBn_4         BIT4
#define  FTFL_FCCOB6_CCOBn_5         BIT5
#define  FTFL_FCCOB6_CCOBn_6         BIT6
#define  FTFL_FCCOB6_CCOBn_7         BIT7

#define  FTFL_FCCOB5_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB5_CCOBn_0         BIT0
#define  FTFL_FCCOB5_CCOBn_1         BIT1
#define  FTFL_FCCOB5_CCOBn_2         BIT2
#define  FTFL_FCCOB5_CCOBn_3         BIT3
#define  FTFL_FCCOB5_CCOBn_4         BIT4
#define  FTFL_FCCOB5_CCOBn_5         BIT5
#define  FTFL_FCCOB5_CCOBn_6         BIT6
#define  FTFL_FCCOB5_CCOBn_7         BIT7

#define  FTFL_FCCOB4_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB4_CCOBn_0         BIT0
#define  FTFL_FCCOB4_CCOBn_1         BIT1
#define  FTFL_FCCOB4_CCOBn_2         BIT2
#define  FTFL_FCCOB4_CCOBn_3         BIT3
#define  FTFL_FCCOB4_CCOBn_4         BIT4
#define  FTFL_FCCOB4_CCOBn_5         BIT5
#define  FTFL_FCCOB4_CCOBn_6         BIT6
#define  FTFL_FCCOB4_CCOBn_7         BIT7

#define  FTFL_FCCOBB_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOBB_CCOBn_0         BIT0
#define  FTFL_FCCOBB_CCOBn_1         BIT1
#define  FTFL_FCCOBB_CCOBn_2         BIT2
#define  FTFL_FCCOBB_CCOBn_3         BIT3
#define  FTFL_FCCOBB_CCOBn_4         BIT4
#define  FTFL_FCCOBB_CCOBn_5         BIT5
#define  FTFL_FCCOBB_CCOBn_6         BIT6
#define  FTFL_FCCOBB_CCOBn_7         BIT7

#define  FTFL_FCCOBA_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOBA_CCOBn_0         BIT0
#define  FTFL_FCCOBA_CCOBn_1         BIT1
#define  FTFL_FCCOBA_CCOBn_2         BIT2
#define  FTFL_FCCOBA_CCOBn_3         BIT3
#define  FTFL_FCCOBA_CCOBn_4         BIT4
#define  FTFL_FCCOBA_CCOBn_5         BIT5
#define  FTFL_FCCOBA_CCOBn_6         BIT6
#define  FTFL_FCCOBA_CCOBn_7         BIT7

#define  FTFL_FCCOB9_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB9_CCOBn_0         BIT0
#define  FTFL_FCCOB9_CCOBn_1         BIT1
#define  FTFL_FCCOB9_CCOBn_2         BIT2
#define  FTFL_FCCOB9_CCOBn_3         BIT3
#define  FTFL_FCCOB9_CCOBn_4         BIT4
#define  FTFL_FCCOB9_CCOBn_5         BIT5
#define  FTFL_FCCOB9_CCOBn_6         BIT6
#define  FTFL_FCCOB9_CCOBn_7         BIT7

#define  FTFL_FCCOB8_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  FTFL_FCCOB8_CCOBn_0         BIT0
#define  FTFL_FCCOB8_CCOBn_1         BIT1
#define  FTFL_FCCOB8_CCOBn_2         BIT2
#define  FTFL_FCCOB8_CCOBn_3         BIT3
#define  FTFL_FCCOB8_CCOBn_4         BIT4
#define  FTFL_FCCOB8_CCOBn_5         BIT5
#define  FTFL_FCCOB8_CCOBn_6         BIT6
#define  FTFL_FCCOB8_CCOBn_7         BIT7

#define  FTFL_FPROT3_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Program Flash Region Protect
//     0b0 ==> Program flash region is protected.
//     0b1 ==> Program flash region is not protected
#define  FTFL_FPROT3_PROT_0          BIT0
#define  FTFL_FPROT3_PROT_1          BIT1
#define  FTFL_FPROT3_PROT_2          BIT2
#define  FTFL_FPROT3_PROT_3          BIT3
#define  FTFL_FPROT3_PROT_4          BIT4
#define  FTFL_FPROT3_PROT_5          BIT5
#define  FTFL_FPROT3_PROT_6          BIT6
#define  FTFL_FPROT3_PROT_7          BIT7

#define  FTFL_FPROT2_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Program Flash Region Protect
//     0b0 ==> Program flash region is protected.
//     0b1 ==> Program flash region is not protected
#define  FTFL_FPROT2_PROT_0          BIT0
#define  FTFL_FPROT2_PROT_1          BIT1
#define  FTFL_FPROT2_PROT_2          BIT2
#define  FTFL_FPROT2_PROT_3          BIT3
#define  FTFL_FPROT2_PROT_4          BIT4
#define  FTFL_FPROT2_PROT_5          BIT5
#define  FTFL_FPROT2_PROT_6          BIT6
#define  FTFL_FPROT2_PROT_7          BIT7

#define  FTFL_FPROT1_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Program Flash Region Protect
//     0b0 ==> Program flash region is protected.
//     0b1 ==> Program flash region is not protected
#define  FTFL_FPROT1_PROT_0          BIT0
#define  FTFL_FPROT1_PROT_1          BIT1
#define  FTFL_FPROT1_PROT_2          BIT2
#define  FTFL_FPROT1_PROT_3          BIT3
#define  FTFL_FPROT1_PROT_4          BIT4
#define  FTFL_FPROT1_PROT_5          BIT5
#define  FTFL_FPROT1_PROT_6          BIT6
#define  FTFL_FPROT1_PROT_7          BIT7

#define  FTFL_FPROT0_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Program Flash Region Protect
//     0b0 ==> Program flash region is protected.
//     0b1 ==> Program flash region is not protected
#define  FTFL_FPROT0_PROT_0          BIT0
#define  FTFL_FPROT0_PROT_1          BIT1
#define  FTFL_FPROT0_PROT_2          BIT2
#define  FTFL_FPROT0_PROT_3          BIT3
#define  FTFL_FPROT0_PROT_4          BIT4
#define  FTFL_FPROT0_PROT_5          BIT5
#define  FTFL_FPROT0_PROT_6          BIT6
#define  FTFL_FPROT0_PROT_7          BIT7

#define  FTFL_FEPROT_EPROT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   EEPROM Region Protect
//     0b0 ==> EEPROM region is protected
//     0b1 ==> EEPROM region is not protected
#define  FTFL_FEPROT_EPROT_0         BIT0
#define  FTFL_FEPROT_EPROT_1         BIT1
#define  FTFL_FEPROT_EPROT_2         BIT2
#define  FTFL_FEPROT_EPROT_3         BIT3
#define  FTFL_FEPROT_EPROT_4         BIT4
#define  FTFL_FEPROT_EPROT_5         BIT5
#define  FTFL_FEPROT_EPROT_6         BIT6
#define  FTFL_FEPROT_EPROT_7         BIT7

#define  FTFL_FDPROT_DPROT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data Flash Region Protect
//     0b0 ==> Data Flash region is protected
//     0b1 ==> Data Flash region is not protected
#define  FTFL_FDPROT_DPROT_0         BIT0
#define  FTFL_FDPROT_DPROT_1         BIT1
#define  FTFL_FDPROT_DPROT_2         BIT2
#define  FTFL_FDPROT_DPROT_3         BIT3
#define  FTFL_FDPROT_DPROT_4         BIT4
#define  FTFL_FDPROT_DPROT_5         BIT5
#define  FTFL_FDPROT_DPROT_6         BIT6
#define  FTFL_FDPROT_DPROT_7         BIT7

#define  GPIOA_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Enable Bits
//     0b0 ==> Pull resistor is disabled
//     0b1 ==> Pull resistor is enabled
#define  GPIOA_PUR_PU_0              BIT0
#define  GPIOA_PUR_PU_1              BIT1
#define  GPIOA_PUR_PU_2              BIT2
#define  GPIOA_PUR_PU_3              BIT3
#define  GPIOA_PUR_PU_4              BIT4
#define  GPIOA_PUR_PU_5              BIT5
#define  GPIOA_PUR_PU_6              BIT6
#define  GPIOA_PUR_PU_7              BIT7
#define  GPIOA_PUR_PU_8              BIT8
#define  GPIOA_PUR_PU_9              BIT9
#define  GPIOA_PUR_PU_10             BIT10
#define  GPIOA_PUR_PU_11             BIT11
#define  GPIOA_PUR_PU_12             BIT12
#define  GPIOA_PUR_PU_13             BIT13
#define  GPIOA_PUR_PU_14             BIT14
#define  GPIOA_PUR_PU_15             BIT15

#define  GPIOA_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Bits
#define  GPIOA_DR_D_0                BIT0
#define  GPIOA_DR_D_1                BIT1
#define  GPIOA_DR_D_2                BIT2
#define  GPIOA_DR_D_3                BIT3
#define  GPIOA_DR_D_4                BIT4
#define  GPIOA_DR_D_5                BIT5
#define  GPIOA_DR_D_6                BIT6
#define  GPIOA_DR_D_7                BIT7
#define  GPIOA_DR_D_8                BIT8
#define  GPIOA_DR_D_9                BIT9
#define  GPIOA_DR_D_10               BIT10
#define  GPIOA_DR_D_11               BIT11
#define  GPIOA_DR_D_12               BIT12
#define  GPIOA_DR_D_13               BIT13
#define  GPIOA_DR_D_14               BIT14
#define  GPIOA_DR_D_15               BIT15

#define  GPIOA_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Direction Bits
//     0b0 ==> Pin is an input
//     0b1 ==> Pin is an output
#define  GPIOA_DDR_DD_0              BIT0
#define  GPIOA_DDR_DD_1              BIT1
#define  GPIOA_DDR_DD_2              BIT2
#define  GPIOA_DDR_DD_3              BIT3
#define  GPIOA_DDR_DD_4              BIT4
#define  GPIOA_DDR_DD_5              BIT5
#define  GPIOA_DDR_DD_6              BIT6
#define  GPIOA_DDR_DD_7              BIT7
#define  GPIOA_DDR_DD_8              BIT8
#define  GPIOA_DDR_DD_9              BIT9
#define  GPIOA_DDR_DD_10             BIT10
#define  GPIOA_DDR_DD_11             BIT11
#define  GPIOA_DDR_DD_12             BIT12
#define  GPIOA_DDR_DD_13             BIT13
#define  GPIOA_DDR_DD_14             BIT14
#define  GPIOA_DDR_DD_15             BIT15

#define  GPIOA_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Peripheral Enable Bits
//     0b0 ==> Pin is for GPIO (GPIO mode)
//     0b1 ==> Pin is for peripheral (peripheral mode)
#define  GPIOA_PER_PE_0              BIT0
#define  GPIOA_PER_PE_1              BIT1
#define  GPIOA_PER_PE_2              BIT2
#define  GPIOA_PER_PE_3              BIT3
#define  GPIOA_PER_PE_4              BIT4
#define  GPIOA_PER_PE_5              BIT5
#define  GPIOA_PER_PE_6              BIT6
#define  GPIOA_PER_PE_7              BIT7
#define  GPIOA_PER_PE_8              BIT8
#define  GPIOA_PER_PE_9              BIT9
#define  GPIOA_PER_PE_10             BIT10
#define  GPIOA_PER_PE_11             BIT11
#define  GPIOA_PER_PE_12             BIT12
#define  GPIOA_PER_PE_13             BIT13
#define  GPIOA_PER_PE_14             BIT14
#define  GPIOA_PER_PE_15             BIT15

#define  GPIOA_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Assert Bits
//     0b0 ==> Deassert software interrupt
//     0b1 ==> Assert software interrupt
#define  GPIOA_IAR_IA_0              BIT0
#define  GPIOA_IAR_IA_1              BIT1
#define  GPIOA_IAR_IA_2              BIT2
#define  GPIOA_IAR_IA_3              BIT3
#define  GPIOA_IAR_IA_4              BIT4
#define  GPIOA_IAR_IA_5              BIT5
#define  GPIOA_IAR_IA_6              BIT6
#define  GPIOA_IAR_IA_7              BIT7
#define  GPIOA_IAR_IA_8              BIT8
#define  GPIOA_IAR_IA_9              BIT9
#define  GPIOA_IAR_IA_10             BIT10
#define  GPIOA_IAR_IA_11             BIT11
#define  GPIOA_IAR_IA_12             BIT12
#define  GPIOA_IAR_IA_13             BIT13
#define  GPIOA_IAR_IA_14             BIT14
#define  GPIOA_IAR_IA_15             BIT15

#define  GPIOA_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Enable Bits
//     0b0 ==> External Interrupt is disabled
//     0b1 ==> External Interrupt is enabled
#define  GPIOA_IENR_IEN_0            BIT0
#define  GPIOA_IENR_IEN_1            BIT1
#define  GPIOA_IENR_IEN_2            BIT2
#define  GPIOA_IENR_IEN_3            BIT3
#define  GPIOA_IENR_IEN_4            BIT4
#define  GPIOA_IENR_IEN_5            BIT5
#define  GPIOA_IENR_IEN_6            BIT6
#define  GPIOA_IENR_IEN_7            BIT7
#define  GPIOA_IENR_IEN_8            BIT8
#define  GPIOA_IENR_IEN_9            BIT9
#define  GPIOA_IENR_IEN_10           BIT10
#define  GPIOA_IENR_IEN_11           BIT11
#define  GPIOA_IENR_IEN_12           BIT12
#define  GPIOA_IENR_IEN_13           BIT13
#define  GPIOA_IENR_IEN_14           BIT14
#define  GPIOA_IENR_IEN_15           BIT15

#define  GPIOA_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Polarity Bits
//     0b0 ==> Interrupt occurred on rising edge
//     0b1 ==> Interrupt occurred on falling edge
#define  GPIOA_IPOLR_IPOL_0          BIT0
#define  GPIOA_IPOLR_IPOL_1          BIT1
#define  GPIOA_IPOLR_IPOL_2          BIT2
#define  GPIOA_IPOLR_IPOL_3          BIT3
#define  GPIOA_IPOLR_IPOL_4          BIT4
#define  GPIOA_IPOLR_IPOL_5          BIT5
#define  GPIOA_IPOLR_IPOL_6          BIT6
#define  GPIOA_IPOLR_IPOL_7          BIT7
#define  GPIOA_IPOLR_IPOL_8          BIT8
#define  GPIOA_IPOLR_IPOL_9          BIT9
#define  GPIOA_IPOLR_IPOL_10         BIT10
#define  GPIOA_IPOLR_IPOL_11         BIT11
#define  GPIOA_IPOLR_IPOL_12         BIT12
#define  GPIOA_IPOLR_IPOL_13         BIT13
#define  GPIOA_IPOLR_IPOL_14         BIT14
#define  GPIOA_IPOLR_IPOL_15         BIT15

#define  GPIOA_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Pending Bits
//     0b0 ==> No Interrupt
//     0b1 ==> Interrupt occurred
#define  GPIOA_IPR_IP_0              BIT0
#define  GPIOA_IPR_IP_1              BIT1
#define  GPIOA_IPR_IP_2              BIT2
#define  GPIOA_IPR_IP_3              BIT3
#define  GPIOA_IPR_IP_4              BIT4
#define  GPIOA_IPR_IP_5              BIT5
#define  GPIOA_IPR_IP_6              BIT6
#define  GPIOA_IPR_IP_7              BIT7
#define  GPIOA_IPR_IP_8              BIT8
#define  GPIOA_IPR_IP_9              BIT9
#define  GPIOA_IPR_IP_10             BIT10
#define  GPIOA_IPR_IP_11             BIT11
#define  GPIOA_IPR_IP_12             BIT12
#define  GPIOA_IPR_IP_13             BIT13
#define  GPIOA_IPR_IP_14             BIT14
#define  GPIOA_IPR_IP_15             BIT15

#define  GPIOA_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Edge-Sensitive Bits
//     0b0 ==> No edge detected if read; no effect if writing
//     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
#define  GPIOA_IESR_IES_0            BIT0
#define  GPIOA_IESR_IES_1            BIT1
#define  GPIOA_IESR_IES_2            BIT2
#define  GPIOA_IESR_IES_3            BIT3
#define  GPIOA_IESR_IES_4            BIT4
#define  GPIOA_IESR_IES_5            BIT5
#define  GPIOA_IESR_IES_6            BIT6
#define  GPIOA_IESR_IES_7            BIT7
#define  GPIOA_IESR_IES_8            BIT8
#define  GPIOA_IESR_IES_9            BIT9
#define  GPIOA_IESR_IES_10           BIT10
#define  GPIOA_IESR_IES_11           BIT11
#define  GPIOA_IESR_IES_12           BIT12
#define  GPIOA_IESR_IES_13           BIT13
#define  GPIOA_IESR_IES_14           BIT14
#define  GPIOA_IESR_IES_15           BIT15

#define  GPIOA_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Push-Pull Mode Bits
//     0b0 ==> Open Drain Mode
//     0b1 ==> Push-Pull Mode
#define  GPIOA_PPMODE_PPMODE_0       BIT0
#define  GPIOA_PPMODE_PPMODE_1       BIT1
#define  GPIOA_PPMODE_PPMODE_2       BIT2
#define  GPIOA_PPMODE_PPMODE_3       BIT3
#define  GPIOA_PPMODE_PPMODE_4       BIT4
#define  GPIOA_PPMODE_PPMODE_5       BIT5
#define  GPIOA_PPMODE_PPMODE_6       BIT6
#define  GPIOA_PPMODE_PPMODE_7       BIT7
#define  GPIOA_PPMODE_PPMODE_8       BIT8
#define  GPIOA_PPMODE_PPMODE_9       BIT9
#define  GPIOA_PPMODE_PPMODE_10      BIT10
#define  GPIOA_PPMODE_PPMODE_11      BIT11
#define  GPIOA_PPMODE_PPMODE_12      BIT12
#define  GPIOA_PPMODE_PPMODE_13      BIT13
#define  GPIOA_PPMODE_PPMODE_14      BIT14
#define  GPIOA_PPMODE_PPMODE_15      BIT15

#define  GPIOA_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Raw Data Bits
#define  GPIOA_RAWDATA_RAW_DATA_0    BIT0
#define  GPIOA_RAWDATA_RAW_DATA_1    BIT1
#define  GPIOA_RAWDATA_RAW_DATA_2    BIT2
#define  GPIOA_RAWDATA_RAW_DATA_3    BIT3
#define  GPIOA_RAWDATA_RAW_DATA_4    BIT4
#define  GPIOA_RAWDATA_RAW_DATA_5    BIT5
#define  GPIOA_RAWDATA_RAW_DATA_6    BIT6
#define  GPIOA_RAWDATA_RAW_DATA_7    BIT7
#define  GPIOA_RAWDATA_RAW_DATA_8    BIT8
#define  GPIOA_RAWDATA_RAW_DATA_9    BIT9
#define  GPIOA_RAWDATA_RAW_DATA_10   BIT10
#define  GPIOA_RAWDATA_RAW_DATA_11   BIT11
#define  GPIOA_RAWDATA_RAW_DATA_12   BIT12
#define  GPIOA_RAWDATA_RAW_DATA_13   BIT13
#define  GPIOA_RAWDATA_RAW_DATA_14   BIT14
#define  GPIOA_RAWDATA_RAW_DATA_15   BIT15

#define  GPIOA_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Drive Strength Selector Bits
//     0b0 ==> Low drive strength
//     0b1 ==> High drive strength
#define  GPIOA_DRIVE_DRIVE_0         BIT0
#define  GPIOA_DRIVE_DRIVE_1         BIT1
#define  GPIOA_DRIVE_DRIVE_2         BIT2
#define  GPIOA_DRIVE_DRIVE_3         BIT3
#define  GPIOA_DRIVE_DRIVE_4         BIT4
#define  GPIOA_DRIVE_DRIVE_5         BIT5
#define  GPIOA_DRIVE_DRIVE_6         BIT6
#define  GPIOA_DRIVE_DRIVE_7         BIT7
#define  GPIOA_DRIVE_DRIVE_8         BIT8
#define  GPIOA_DRIVE_DRIVE_9         BIT9
#define  GPIOA_DRIVE_DRIVE_10        BIT10
#define  GPIOA_DRIVE_DRIVE_11        BIT11
#define  GPIOA_DRIVE_DRIVE_12        BIT12
#define  GPIOA_DRIVE_DRIVE_13        BIT13
#define  GPIOA_DRIVE_DRIVE_14        BIT14
#define  GPIOA_DRIVE_DRIVE_15        BIT15

#define  GPIOA_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Type Select Bits
//     0b0 ==> Pulldown resistor
//     0b1 ==> Pullup resistor
#define  GPIOA_PUS_PUS_0             BIT0
#define  GPIOA_PUS_PUS_1             BIT1
#define  GPIOA_PUS_PUS_2             BIT2
#define  GPIOA_PUS_PUS_3             BIT3
#define  GPIOA_PUS_PUS_4             BIT4
#define  GPIOA_PUS_PUS_5             BIT5
#define  GPIOA_PUS_PUS_6             BIT6
#define  GPIOA_PUS_PUS_7             BIT7
#define  GPIOA_PUS_PUS_8             BIT8
#define  GPIOA_PUS_PUS_9             BIT9
#define  GPIOA_PUS_PUS_10            BIT10
#define  GPIOA_PUS_PUS_11            BIT11
#define  GPIOA_PUS_PUS_12            BIT12
#define  GPIOA_PUS_PUS_13            BIT13
#define  GPIOA_PUS_PUS_14            BIT14
#define  GPIOA_PUS_PUS_15            BIT15

#define  GPIOA_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Slew Rate Enable
//     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
//     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
#define  GPIOA_SRE_SRE_0             BIT0
#define  GPIOA_SRE_SRE_1             BIT1
#define  GPIOA_SRE_SRE_2             BIT2
#define  GPIOA_SRE_SRE_3             BIT3
#define  GPIOA_SRE_SRE_4             BIT4
#define  GPIOA_SRE_SRE_5             BIT5
#define  GPIOA_SRE_SRE_6             BIT6
#define  GPIOA_SRE_SRE_7             BIT7
#define  GPIOA_SRE_SRE_8             BIT8
#define  GPIOA_SRE_SRE_9             BIT9
#define  GPIOA_SRE_SRE_10            BIT10
#define  GPIOA_SRE_SRE_11            BIT11
#define  GPIOA_SRE_SRE_12            BIT12
#define  GPIOA_SRE_SRE_13            BIT13
#define  GPIOA_SRE_SRE_14            BIT14
#define  GPIOA_SRE_SRE_15            BIT15

#define  GPIOB_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Enable Bits
//     0b0 ==> Pull resistor is disabled
//     0b1 ==> Pull resistor is enabled
#define  GPIOB_PUR_PU_0              BIT0
#define  GPIOB_PUR_PU_1              BIT1
#define  GPIOB_PUR_PU_2              BIT2
#define  GPIOB_PUR_PU_3              BIT3
#define  GPIOB_PUR_PU_4              BIT4
#define  GPIOB_PUR_PU_5              BIT5
#define  GPIOB_PUR_PU_6              BIT6
#define  GPIOB_PUR_PU_7              BIT7
#define  GPIOB_PUR_PU_8              BIT8
#define  GPIOB_PUR_PU_9              BIT9
#define  GPIOB_PUR_PU_10             BIT10
#define  GPIOB_PUR_PU_11             BIT11
#define  GPIOB_PUR_PU_12             BIT12
#define  GPIOB_PUR_PU_13             BIT13
#define  GPIOB_PUR_PU_14             BIT14
#define  GPIOB_PUR_PU_15             BIT15

#define  GPIOB_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Bits
#define  GPIOB_DR_D_0                BIT0
#define  GPIOB_DR_D_1                BIT1
#define  GPIOB_DR_D_2                BIT2
#define  GPIOB_DR_D_3                BIT3
#define  GPIOB_DR_D_4                BIT4
#define  GPIOB_DR_D_5                BIT5
#define  GPIOB_DR_D_6                BIT6
#define  GPIOB_DR_D_7                BIT7
#define  GPIOB_DR_D_8                BIT8
#define  GPIOB_DR_D_9                BIT9
#define  GPIOB_DR_D_10               BIT10
#define  GPIOB_DR_D_11               BIT11
#define  GPIOB_DR_D_12               BIT12
#define  GPIOB_DR_D_13               BIT13
#define  GPIOB_DR_D_14               BIT14
#define  GPIOB_DR_D_15               BIT15

#define  GPIOB_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Direction Bits
//     0b0 ==> Pin is an input
//     0b1 ==> Pin is an output
#define  GPIOB_DDR_DD_0              BIT0
#define  GPIOB_DDR_DD_1              BIT1
#define  GPIOB_DDR_DD_2              BIT2
#define  GPIOB_DDR_DD_3              BIT3
#define  GPIOB_DDR_DD_4              BIT4
#define  GPIOB_DDR_DD_5              BIT5
#define  GPIOB_DDR_DD_6              BIT6
#define  GPIOB_DDR_DD_7              BIT7
#define  GPIOB_DDR_DD_8              BIT8
#define  GPIOB_DDR_DD_9              BIT9
#define  GPIOB_DDR_DD_10             BIT10
#define  GPIOB_DDR_DD_11             BIT11
#define  GPIOB_DDR_DD_12             BIT12
#define  GPIOB_DDR_DD_13             BIT13
#define  GPIOB_DDR_DD_14             BIT14
#define  GPIOB_DDR_DD_15             BIT15

#define  GPIOB_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Peripheral Enable Bits
//     0b0 ==> Pin is for GPIO (GPIO mode)
//     0b1 ==> Pin is for peripheral (peripheral mode)
#define  GPIOB_PER_PE_0              BIT0
#define  GPIOB_PER_PE_1              BIT1
#define  GPIOB_PER_PE_2              BIT2
#define  GPIOB_PER_PE_3              BIT3
#define  GPIOB_PER_PE_4              BIT4
#define  GPIOB_PER_PE_5              BIT5
#define  GPIOB_PER_PE_6              BIT6
#define  GPIOB_PER_PE_7              BIT7
#define  GPIOB_PER_PE_8              BIT8
#define  GPIOB_PER_PE_9              BIT9
#define  GPIOB_PER_PE_10             BIT10
#define  GPIOB_PER_PE_11             BIT11
#define  GPIOB_PER_PE_12             BIT12
#define  GPIOB_PER_PE_13             BIT13
#define  GPIOB_PER_PE_14             BIT14
#define  GPIOB_PER_PE_15             BIT15

#define  GPIOB_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Assert Bits
//     0b0 ==> Deassert software interrupt
//     0b1 ==> Assert software interrupt
#define  GPIOB_IAR_IA_0              BIT0
#define  GPIOB_IAR_IA_1              BIT1
#define  GPIOB_IAR_IA_2              BIT2
#define  GPIOB_IAR_IA_3              BIT3
#define  GPIOB_IAR_IA_4              BIT4
#define  GPIOB_IAR_IA_5              BIT5
#define  GPIOB_IAR_IA_6              BIT6
#define  GPIOB_IAR_IA_7              BIT7
#define  GPIOB_IAR_IA_8              BIT8
#define  GPIOB_IAR_IA_9              BIT9
#define  GPIOB_IAR_IA_10             BIT10
#define  GPIOB_IAR_IA_11             BIT11
#define  GPIOB_IAR_IA_12             BIT12
#define  GPIOB_IAR_IA_13             BIT13
#define  GPIOB_IAR_IA_14             BIT14
#define  GPIOB_IAR_IA_15             BIT15

#define  GPIOB_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Enable Bits
//     0b0 ==> External Interrupt is disabled
//     0b1 ==> External Interrupt is enabled
#define  GPIOB_IENR_IEN_0            BIT0
#define  GPIOB_IENR_IEN_1            BIT1
#define  GPIOB_IENR_IEN_2            BIT2
#define  GPIOB_IENR_IEN_3            BIT3
#define  GPIOB_IENR_IEN_4            BIT4
#define  GPIOB_IENR_IEN_5            BIT5
#define  GPIOB_IENR_IEN_6            BIT6
#define  GPIOB_IENR_IEN_7            BIT7
#define  GPIOB_IENR_IEN_8            BIT8
#define  GPIOB_IENR_IEN_9            BIT9
#define  GPIOB_IENR_IEN_10           BIT10
#define  GPIOB_IENR_IEN_11           BIT11
#define  GPIOB_IENR_IEN_12           BIT12
#define  GPIOB_IENR_IEN_13           BIT13
#define  GPIOB_IENR_IEN_14           BIT14
#define  GPIOB_IENR_IEN_15           BIT15

#define  GPIOB_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Polarity Bits
//     0b0 ==> Interrupt occurred on rising edge
//     0b1 ==> Interrupt occurred on falling edge
#define  GPIOB_IPOLR_IPOL_0          BIT0
#define  GPIOB_IPOLR_IPOL_1          BIT1
#define  GPIOB_IPOLR_IPOL_2          BIT2
#define  GPIOB_IPOLR_IPOL_3          BIT3
#define  GPIOB_IPOLR_IPOL_4          BIT4
#define  GPIOB_IPOLR_IPOL_5          BIT5
#define  GPIOB_IPOLR_IPOL_6          BIT6
#define  GPIOB_IPOLR_IPOL_7          BIT7
#define  GPIOB_IPOLR_IPOL_8          BIT8
#define  GPIOB_IPOLR_IPOL_9          BIT9
#define  GPIOB_IPOLR_IPOL_10         BIT10
#define  GPIOB_IPOLR_IPOL_11         BIT11
#define  GPIOB_IPOLR_IPOL_12         BIT12
#define  GPIOB_IPOLR_IPOL_13         BIT13
#define  GPIOB_IPOLR_IPOL_14         BIT14
#define  GPIOB_IPOLR_IPOL_15         BIT15

#define  GPIOB_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Pending Bits
//     0b0 ==> No Interrupt
//     0b1 ==> Interrupt occurred
#define  GPIOB_IPR_IP_0              BIT0
#define  GPIOB_IPR_IP_1              BIT1
#define  GPIOB_IPR_IP_2              BIT2
#define  GPIOB_IPR_IP_3              BIT3
#define  GPIOB_IPR_IP_4              BIT4
#define  GPIOB_IPR_IP_5              BIT5
#define  GPIOB_IPR_IP_6              BIT6
#define  GPIOB_IPR_IP_7              BIT7
#define  GPIOB_IPR_IP_8              BIT8
#define  GPIOB_IPR_IP_9              BIT9
#define  GPIOB_IPR_IP_10             BIT10
#define  GPIOB_IPR_IP_11             BIT11
#define  GPIOB_IPR_IP_12             BIT12
#define  GPIOB_IPR_IP_13             BIT13
#define  GPIOB_IPR_IP_14             BIT14
#define  GPIOB_IPR_IP_15             BIT15

#define  GPIOB_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Edge-Sensitive Bits
//     0b0 ==> No edge detected if read; no effect if writing
//     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
#define  GPIOB_IESR_IES_0            BIT0
#define  GPIOB_IESR_IES_1            BIT1
#define  GPIOB_IESR_IES_2            BIT2
#define  GPIOB_IESR_IES_3            BIT3
#define  GPIOB_IESR_IES_4            BIT4
#define  GPIOB_IESR_IES_5            BIT5
#define  GPIOB_IESR_IES_6            BIT6
#define  GPIOB_IESR_IES_7            BIT7
#define  GPIOB_IESR_IES_8            BIT8
#define  GPIOB_IESR_IES_9            BIT9
#define  GPIOB_IESR_IES_10           BIT10
#define  GPIOB_IESR_IES_11           BIT11
#define  GPIOB_IESR_IES_12           BIT12
#define  GPIOB_IESR_IES_13           BIT13
#define  GPIOB_IESR_IES_14           BIT14
#define  GPIOB_IESR_IES_15           BIT15

#define  GPIOB_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Push-Pull Mode Bits
//     0b0 ==> Open Drain Mode
//     0b1 ==> Push-Pull Mode
#define  GPIOB_PPMODE_PPMODE_0       BIT0
#define  GPIOB_PPMODE_PPMODE_1       BIT1
#define  GPIOB_PPMODE_PPMODE_2       BIT2
#define  GPIOB_PPMODE_PPMODE_3       BIT3
#define  GPIOB_PPMODE_PPMODE_4       BIT4
#define  GPIOB_PPMODE_PPMODE_5       BIT5
#define  GPIOB_PPMODE_PPMODE_6       BIT6
#define  GPIOB_PPMODE_PPMODE_7       BIT7
#define  GPIOB_PPMODE_PPMODE_8       BIT8
#define  GPIOB_PPMODE_PPMODE_9       BIT9
#define  GPIOB_PPMODE_PPMODE_10      BIT10
#define  GPIOB_PPMODE_PPMODE_11      BIT11
#define  GPIOB_PPMODE_PPMODE_12      BIT12
#define  GPIOB_PPMODE_PPMODE_13      BIT13
#define  GPIOB_PPMODE_PPMODE_14      BIT14
#define  GPIOB_PPMODE_PPMODE_15      BIT15

#define  GPIOB_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Raw Data Bits
#define  GPIOB_RAWDATA_RAW_DATA_0    BIT0
#define  GPIOB_RAWDATA_RAW_DATA_1    BIT1
#define  GPIOB_RAWDATA_RAW_DATA_2    BIT2
#define  GPIOB_RAWDATA_RAW_DATA_3    BIT3
#define  GPIOB_RAWDATA_RAW_DATA_4    BIT4
#define  GPIOB_RAWDATA_RAW_DATA_5    BIT5
#define  GPIOB_RAWDATA_RAW_DATA_6    BIT6
#define  GPIOB_RAWDATA_RAW_DATA_7    BIT7
#define  GPIOB_RAWDATA_RAW_DATA_8    BIT8
#define  GPIOB_RAWDATA_RAW_DATA_9    BIT9
#define  GPIOB_RAWDATA_RAW_DATA_10   BIT10
#define  GPIOB_RAWDATA_RAW_DATA_11   BIT11
#define  GPIOB_RAWDATA_RAW_DATA_12   BIT12
#define  GPIOB_RAWDATA_RAW_DATA_13   BIT13
#define  GPIOB_RAWDATA_RAW_DATA_14   BIT14
#define  GPIOB_RAWDATA_RAW_DATA_15   BIT15

#define  GPIOB_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Drive Strength Selector Bits
//     0b0 ==> Low drive strength
//     0b1 ==> High drive strength
#define  GPIOB_DRIVE_DRIVE_0         BIT0
#define  GPIOB_DRIVE_DRIVE_1         BIT1
#define  GPIOB_DRIVE_DRIVE_2         BIT2
#define  GPIOB_DRIVE_DRIVE_3         BIT3
#define  GPIOB_DRIVE_DRIVE_4         BIT4
#define  GPIOB_DRIVE_DRIVE_5         BIT5
#define  GPIOB_DRIVE_DRIVE_6         BIT6
#define  GPIOB_DRIVE_DRIVE_7         BIT7
#define  GPIOB_DRIVE_DRIVE_8         BIT8
#define  GPIOB_DRIVE_DRIVE_9         BIT9
#define  GPIOB_DRIVE_DRIVE_10        BIT10
#define  GPIOB_DRIVE_DRIVE_11        BIT11
#define  GPIOB_DRIVE_DRIVE_12        BIT12
#define  GPIOB_DRIVE_DRIVE_13        BIT13
#define  GPIOB_DRIVE_DRIVE_14        BIT14
#define  GPIOB_DRIVE_DRIVE_15        BIT15

#define  GPIOB_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Type Select Bits
//     0b0 ==> Pulldown resistor
//     0b1 ==> Pullup resistor
#define  GPIOB_PUS_PUS_0             BIT0
#define  GPIOB_PUS_PUS_1             BIT1
#define  GPIOB_PUS_PUS_2             BIT2
#define  GPIOB_PUS_PUS_3             BIT3
#define  GPIOB_PUS_PUS_4             BIT4
#define  GPIOB_PUS_PUS_5             BIT5
#define  GPIOB_PUS_PUS_6             BIT6
#define  GPIOB_PUS_PUS_7             BIT7
#define  GPIOB_PUS_PUS_8             BIT8
#define  GPIOB_PUS_PUS_9             BIT9
#define  GPIOB_PUS_PUS_10            BIT10
#define  GPIOB_PUS_PUS_11            BIT11
#define  GPIOB_PUS_PUS_12            BIT12
#define  GPIOB_PUS_PUS_13            BIT13
#define  GPIOB_PUS_PUS_14            BIT14
#define  GPIOB_PUS_PUS_15            BIT15

#define  GPIOB_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Slew Rate Enable
//     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
//     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
#define  GPIOB_SRE_SRE_0             BIT0
#define  GPIOB_SRE_SRE_1             BIT1
#define  GPIOB_SRE_SRE_2             BIT2
#define  GPIOB_SRE_SRE_3             BIT3
#define  GPIOB_SRE_SRE_4             BIT4
#define  GPIOB_SRE_SRE_5             BIT5
#define  GPIOB_SRE_SRE_6             BIT6
#define  GPIOB_SRE_SRE_7             BIT7
#define  GPIOB_SRE_SRE_8             BIT8
#define  GPIOB_SRE_SRE_9             BIT9
#define  GPIOB_SRE_SRE_10            BIT10
#define  GPIOB_SRE_SRE_11            BIT11
#define  GPIOB_SRE_SRE_12            BIT12
#define  GPIOB_SRE_SRE_13            BIT13
#define  GPIOB_SRE_SRE_14            BIT14
#define  GPIOB_SRE_SRE_15            BIT15

#define  GPIOC_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Enable Bits
//     0b0 ==> Pull resistor is disabled
//     0b1 ==> Pull resistor is enabled
#define  GPIOC_PUR_PU_0              BIT0
#define  GPIOC_PUR_PU_1              BIT1
#define  GPIOC_PUR_PU_2              BIT2
#define  GPIOC_PUR_PU_3              BIT3
#define  GPIOC_PUR_PU_4              BIT4
#define  GPIOC_PUR_PU_5              BIT5
#define  GPIOC_PUR_PU_6              BIT6
#define  GPIOC_PUR_PU_7              BIT7
#define  GPIOC_PUR_PU_8              BIT8
#define  GPIOC_PUR_PU_9              BIT9
#define  GPIOC_PUR_PU_10             BIT10
#define  GPIOC_PUR_PU_11             BIT11
#define  GPIOC_PUR_PU_12             BIT12
#define  GPIOC_PUR_PU_13             BIT13
#define  GPIOC_PUR_PU_14             BIT14
#define  GPIOC_PUR_PU_15             BIT15

#define  GPIOC_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Bits
#define  GPIOC_DR_D_0                BIT0
#define  GPIOC_DR_D_1                BIT1
#define  GPIOC_DR_D_2                BIT2
#define  GPIOC_DR_D_3                BIT3
#define  GPIOC_DR_D_4                BIT4
#define  GPIOC_DR_D_5                BIT5
#define  GPIOC_DR_D_6                BIT6
#define  GPIOC_DR_D_7                BIT7
#define  GPIOC_DR_D_8                BIT8
#define  GPIOC_DR_D_9                BIT9
#define  GPIOC_DR_D_10               BIT10
#define  GPIOC_DR_D_11               BIT11
#define  GPIOC_DR_D_12               BIT12
#define  GPIOC_DR_D_13               BIT13
#define  GPIOC_DR_D_14               BIT14
#define  GPIOC_DR_D_15               BIT15

#define  GPIOC_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Direction Bits
//     0b0 ==> Pin is an input
//     0b1 ==> Pin is an output
#define  GPIOC_DDR_DD_0              BIT0
#define  GPIOC_DDR_DD_1              BIT1
#define  GPIOC_DDR_DD_2              BIT2
#define  GPIOC_DDR_DD_3              BIT3
#define  GPIOC_DDR_DD_4              BIT4
#define  GPIOC_DDR_DD_5              BIT5
#define  GPIOC_DDR_DD_6              BIT6
#define  GPIOC_DDR_DD_7              BIT7
#define  GPIOC_DDR_DD_8              BIT8
#define  GPIOC_DDR_DD_9              BIT9
#define  GPIOC_DDR_DD_10             BIT10
#define  GPIOC_DDR_DD_11             BIT11
#define  GPIOC_DDR_DD_12             BIT12
#define  GPIOC_DDR_DD_13             BIT13
#define  GPIOC_DDR_DD_14             BIT14
#define  GPIOC_DDR_DD_15             BIT15

#define  GPIOC_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Peripheral Enable Bits
//     0b0 ==> Pin is for GPIO (GPIO mode)
//     0b1 ==> Pin is for peripheral (peripheral mode)
#define  GPIOC_PER_PE_0              BIT0
#define  GPIOC_PER_PE_1              BIT1
#define  GPIOC_PER_PE_2              BIT2
#define  GPIOC_PER_PE_3              BIT3
#define  GPIOC_PER_PE_4              BIT4
#define  GPIOC_PER_PE_5              BIT5
#define  GPIOC_PER_PE_6              BIT6
#define  GPIOC_PER_PE_7              BIT7
#define  GPIOC_PER_PE_8              BIT8
#define  GPIOC_PER_PE_9              BIT9
#define  GPIOC_PER_PE_10             BIT10
#define  GPIOC_PER_PE_11             BIT11
#define  GPIOC_PER_PE_12             BIT12
#define  GPIOC_PER_PE_13             BIT13
#define  GPIOC_PER_PE_14             BIT14
#define  GPIOC_PER_PE_15             BIT15

#define  GPIOC_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Assert Bits
//     0b0 ==> Deassert software interrupt
//     0b1 ==> Assert software interrupt
#define  GPIOC_IAR_IA_0              BIT0
#define  GPIOC_IAR_IA_1              BIT1
#define  GPIOC_IAR_IA_2              BIT2
#define  GPIOC_IAR_IA_3              BIT3
#define  GPIOC_IAR_IA_4              BIT4
#define  GPIOC_IAR_IA_5              BIT5
#define  GPIOC_IAR_IA_6              BIT6
#define  GPIOC_IAR_IA_7              BIT7
#define  GPIOC_IAR_IA_8              BIT8
#define  GPIOC_IAR_IA_9              BIT9
#define  GPIOC_IAR_IA_10             BIT10
#define  GPIOC_IAR_IA_11             BIT11
#define  GPIOC_IAR_IA_12             BIT12
#define  GPIOC_IAR_IA_13             BIT13
#define  GPIOC_IAR_IA_14             BIT14
#define  GPIOC_IAR_IA_15             BIT15

#define  GPIOC_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Enable Bits
//     0b0 ==> External Interrupt is disabled
//     0b1 ==> External Interrupt is enabled
#define  GPIOC_IENR_IEN_0            BIT0
#define  GPIOC_IENR_IEN_1            BIT1
#define  GPIOC_IENR_IEN_2            BIT2
#define  GPIOC_IENR_IEN_3            BIT3
#define  GPIOC_IENR_IEN_4            BIT4
#define  GPIOC_IENR_IEN_5            BIT5
#define  GPIOC_IENR_IEN_6            BIT6
#define  GPIOC_IENR_IEN_7            BIT7
#define  GPIOC_IENR_IEN_8            BIT8
#define  GPIOC_IENR_IEN_9            BIT9
#define  GPIOC_IENR_IEN_10           BIT10
#define  GPIOC_IENR_IEN_11           BIT11
#define  GPIOC_IENR_IEN_12           BIT12
#define  GPIOC_IENR_IEN_13           BIT13
#define  GPIOC_IENR_IEN_14           BIT14
#define  GPIOC_IENR_IEN_15           BIT15

#define  GPIOC_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Polarity Bits
//     0b0 ==> Interrupt occurred on rising edge
//     0b1 ==> Interrupt occurred on falling edge
#define  GPIOC_IPOLR_IPOL_0          BIT0
#define  GPIOC_IPOLR_IPOL_1          BIT1
#define  GPIOC_IPOLR_IPOL_2          BIT2
#define  GPIOC_IPOLR_IPOL_3          BIT3
#define  GPIOC_IPOLR_IPOL_4          BIT4
#define  GPIOC_IPOLR_IPOL_5          BIT5
#define  GPIOC_IPOLR_IPOL_6          BIT6
#define  GPIOC_IPOLR_IPOL_7          BIT7
#define  GPIOC_IPOLR_IPOL_8          BIT8
#define  GPIOC_IPOLR_IPOL_9          BIT9
#define  GPIOC_IPOLR_IPOL_10         BIT10
#define  GPIOC_IPOLR_IPOL_11         BIT11
#define  GPIOC_IPOLR_IPOL_12         BIT12
#define  GPIOC_IPOLR_IPOL_13         BIT13
#define  GPIOC_IPOLR_IPOL_14         BIT14
#define  GPIOC_IPOLR_IPOL_15         BIT15

#define  GPIOC_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Pending Bits
//     0b0 ==> No Interrupt
//     0b1 ==> Interrupt occurred
#define  GPIOC_IPR_IP_0              BIT0
#define  GPIOC_IPR_IP_1              BIT1
#define  GPIOC_IPR_IP_2              BIT2
#define  GPIOC_IPR_IP_3              BIT3
#define  GPIOC_IPR_IP_4              BIT4
#define  GPIOC_IPR_IP_5              BIT5
#define  GPIOC_IPR_IP_6              BIT6
#define  GPIOC_IPR_IP_7              BIT7
#define  GPIOC_IPR_IP_8              BIT8
#define  GPIOC_IPR_IP_9              BIT9
#define  GPIOC_IPR_IP_10             BIT10
#define  GPIOC_IPR_IP_11             BIT11
#define  GPIOC_IPR_IP_12             BIT12
#define  GPIOC_IPR_IP_13             BIT13
#define  GPIOC_IPR_IP_14             BIT14
#define  GPIOC_IPR_IP_15             BIT15

#define  GPIOC_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Edge-Sensitive Bits
//     0b0 ==> No edge detected if read; no effect if writing
//     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
#define  GPIOC_IESR_IES_0            BIT0
#define  GPIOC_IESR_IES_1            BIT1
#define  GPIOC_IESR_IES_2            BIT2
#define  GPIOC_IESR_IES_3            BIT3
#define  GPIOC_IESR_IES_4            BIT4
#define  GPIOC_IESR_IES_5            BIT5
#define  GPIOC_IESR_IES_6            BIT6
#define  GPIOC_IESR_IES_7            BIT7
#define  GPIOC_IESR_IES_8            BIT8
#define  GPIOC_IESR_IES_9            BIT9
#define  GPIOC_IESR_IES_10           BIT10
#define  GPIOC_IESR_IES_11           BIT11
#define  GPIOC_IESR_IES_12           BIT12
#define  GPIOC_IESR_IES_13           BIT13
#define  GPIOC_IESR_IES_14           BIT14
#define  GPIOC_IESR_IES_15           BIT15

#define  GPIOC_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Push-Pull Mode Bits
//     0b0 ==> Open Drain Mode
//     0b1 ==> Push-Pull Mode
#define  GPIOC_PPMODE_PPMODE_0       BIT0
#define  GPIOC_PPMODE_PPMODE_1       BIT1
#define  GPIOC_PPMODE_PPMODE_2       BIT2
#define  GPIOC_PPMODE_PPMODE_3       BIT3
#define  GPIOC_PPMODE_PPMODE_4       BIT4
#define  GPIOC_PPMODE_PPMODE_5       BIT5
#define  GPIOC_PPMODE_PPMODE_6       BIT6
#define  GPIOC_PPMODE_PPMODE_7       BIT7
#define  GPIOC_PPMODE_PPMODE_8       BIT8
#define  GPIOC_PPMODE_PPMODE_9       BIT9
#define  GPIOC_PPMODE_PPMODE_10      BIT10
#define  GPIOC_PPMODE_PPMODE_11      BIT11
#define  GPIOC_PPMODE_PPMODE_12      BIT12
#define  GPIOC_PPMODE_PPMODE_13      BIT13
#define  GPIOC_PPMODE_PPMODE_14      BIT14
#define  GPIOC_PPMODE_PPMODE_15      BIT15

#define  GPIOC_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Raw Data Bits
#define  GPIOC_RAWDATA_RAW_DATA_0    BIT0
#define  GPIOC_RAWDATA_RAW_DATA_1    BIT1
#define  GPIOC_RAWDATA_RAW_DATA_2    BIT2
#define  GPIOC_RAWDATA_RAW_DATA_3    BIT3
#define  GPIOC_RAWDATA_RAW_DATA_4    BIT4
#define  GPIOC_RAWDATA_RAW_DATA_5    BIT5
#define  GPIOC_RAWDATA_RAW_DATA_6    BIT6
#define  GPIOC_RAWDATA_RAW_DATA_7    BIT7
#define  GPIOC_RAWDATA_RAW_DATA_8    BIT8
#define  GPIOC_RAWDATA_RAW_DATA_9    BIT9
#define  GPIOC_RAWDATA_RAW_DATA_10   BIT10
#define  GPIOC_RAWDATA_RAW_DATA_11   BIT11
#define  GPIOC_RAWDATA_RAW_DATA_12   BIT12
#define  GPIOC_RAWDATA_RAW_DATA_13   BIT13
#define  GPIOC_RAWDATA_RAW_DATA_14   BIT14
#define  GPIOC_RAWDATA_RAW_DATA_15   BIT15

#define  GPIOC_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Drive Strength Selector Bits
//     0b0 ==> Low drive strength
//     0b1 ==> High drive strength
#define  GPIOC_DRIVE_DRIVE_0         BIT0
#define  GPIOC_DRIVE_DRIVE_1         BIT1
#define  GPIOC_DRIVE_DRIVE_2         BIT2
#define  GPIOC_DRIVE_DRIVE_3         BIT3
#define  GPIOC_DRIVE_DRIVE_4         BIT4
#define  GPIOC_DRIVE_DRIVE_5         BIT5
#define  GPIOC_DRIVE_DRIVE_6         BIT6
#define  GPIOC_DRIVE_DRIVE_7         BIT7
#define  GPIOC_DRIVE_DRIVE_8         BIT8
#define  GPIOC_DRIVE_DRIVE_9         BIT9
#define  GPIOC_DRIVE_DRIVE_10        BIT10
#define  GPIOC_DRIVE_DRIVE_11        BIT11
#define  GPIOC_DRIVE_DRIVE_12        BIT12
#define  GPIOC_DRIVE_DRIVE_13        BIT13
#define  GPIOC_DRIVE_DRIVE_14        BIT14
#define  GPIOC_DRIVE_DRIVE_15        BIT15

#define  GPIOC_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Type Select Bits
//     0b0 ==> Pulldown resistor
//     0b1 ==> Pullup resistor
#define  GPIOC_PUS_PUS_0             BIT0
#define  GPIOC_PUS_PUS_1             BIT1
#define  GPIOC_PUS_PUS_2             BIT2
#define  GPIOC_PUS_PUS_3             BIT3
#define  GPIOC_PUS_PUS_4             BIT4
#define  GPIOC_PUS_PUS_5             BIT5
#define  GPIOC_PUS_PUS_6             BIT6
#define  GPIOC_PUS_PUS_7             BIT7
#define  GPIOC_PUS_PUS_8             BIT8
#define  GPIOC_PUS_PUS_9             BIT9
#define  GPIOC_PUS_PUS_10            BIT10
#define  GPIOC_PUS_PUS_11            BIT11
#define  GPIOC_PUS_PUS_12            BIT12
#define  GPIOC_PUS_PUS_13            BIT13
#define  GPIOC_PUS_PUS_14            BIT14
#define  GPIOC_PUS_PUS_15            BIT15

#define  GPIOC_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Slew Rate Enable
//     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
//     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
#define  GPIOC_SRE_SRE_0             BIT0
#define  GPIOC_SRE_SRE_1             BIT1
#define  GPIOC_SRE_SRE_2             BIT2
#define  GPIOC_SRE_SRE_3             BIT3
#define  GPIOC_SRE_SRE_4             BIT4
#define  GPIOC_SRE_SRE_5             BIT5
#define  GPIOC_SRE_SRE_6             BIT6
#define  GPIOC_SRE_SRE_7             BIT7
#define  GPIOC_SRE_SRE_8             BIT8
#define  GPIOC_SRE_SRE_9             BIT9
#define  GPIOC_SRE_SRE_10            BIT10
#define  GPIOC_SRE_SRE_11            BIT11
#define  GPIOC_SRE_SRE_12            BIT12
#define  GPIOC_SRE_SRE_13            BIT13
#define  GPIOC_SRE_SRE_14            BIT14
#define  GPIOC_SRE_SRE_15            BIT15

#define  GPIOD_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Enable Bits
//     0b0 ==> Pull resistor is disabled
//     0b1 ==> Pull resistor is enabled
#define  GPIOD_PUR_PU_0              BIT0
#define  GPIOD_PUR_PU_1              BIT1
#define  GPIOD_PUR_PU_2              BIT2
#define  GPIOD_PUR_PU_3              BIT3
#define  GPIOD_PUR_PU_4              BIT4
#define  GPIOD_PUR_PU_5              BIT5
#define  GPIOD_PUR_PU_6              BIT6
#define  GPIOD_PUR_PU_7              BIT7
#define  GPIOD_PUR_PU_8              BIT8
#define  GPIOD_PUR_PU_9              BIT9
#define  GPIOD_PUR_PU_10             BIT10
#define  GPIOD_PUR_PU_11             BIT11
#define  GPIOD_PUR_PU_12             BIT12
#define  GPIOD_PUR_PU_13             BIT13
#define  GPIOD_PUR_PU_14             BIT14
#define  GPIOD_PUR_PU_15             BIT15

#define  GPIOD_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Bits
#define  GPIOD_DR_D_0                BIT0
#define  GPIOD_DR_D_1                BIT1
#define  GPIOD_DR_D_2                BIT2
#define  GPIOD_DR_D_3                BIT3
#define  GPIOD_DR_D_4                BIT4
#define  GPIOD_DR_D_5                BIT5
#define  GPIOD_DR_D_6                BIT6
#define  GPIOD_DR_D_7                BIT7
#define  GPIOD_DR_D_8                BIT8
#define  GPIOD_DR_D_9                BIT9
#define  GPIOD_DR_D_10               BIT10
#define  GPIOD_DR_D_11               BIT11
#define  GPIOD_DR_D_12               BIT12
#define  GPIOD_DR_D_13               BIT13
#define  GPIOD_DR_D_14               BIT14
#define  GPIOD_DR_D_15               BIT15

#define  GPIOD_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Direction Bits
//     0b0 ==> Pin is an input
//     0b1 ==> Pin is an output
#define  GPIOD_DDR_DD_0              BIT0
#define  GPIOD_DDR_DD_1              BIT1
#define  GPIOD_DDR_DD_2              BIT2
#define  GPIOD_DDR_DD_3              BIT3
#define  GPIOD_DDR_DD_4              BIT4
#define  GPIOD_DDR_DD_5              BIT5
#define  GPIOD_DDR_DD_6              BIT6
#define  GPIOD_DDR_DD_7              BIT7
#define  GPIOD_DDR_DD_8              BIT8
#define  GPIOD_DDR_DD_9              BIT9
#define  GPIOD_DDR_DD_10             BIT10
#define  GPIOD_DDR_DD_11             BIT11
#define  GPIOD_DDR_DD_12             BIT12
#define  GPIOD_DDR_DD_13             BIT13
#define  GPIOD_DDR_DD_14             BIT14
#define  GPIOD_DDR_DD_15             BIT15

#define  GPIOD_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Peripheral Enable Bits
//     0b0 ==> Pin is for GPIO (GPIO mode)
//     0b1 ==> Pin is for peripheral (peripheral mode)
#define  GPIOD_PER_PE_0              BIT0
#define  GPIOD_PER_PE_1              BIT1
#define  GPIOD_PER_PE_2              BIT2
#define  GPIOD_PER_PE_3              BIT3
#define  GPIOD_PER_PE_4              BIT4
#define  GPIOD_PER_PE_5              BIT5
#define  GPIOD_PER_PE_6              BIT6
#define  GPIOD_PER_PE_7              BIT7
#define  GPIOD_PER_PE_8              BIT8
#define  GPIOD_PER_PE_9              BIT9
#define  GPIOD_PER_PE_10             BIT10
#define  GPIOD_PER_PE_11             BIT11
#define  GPIOD_PER_PE_12             BIT12
#define  GPIOD_PER_PE_13             BIT13
#define  GPIOD_PER_PE_14             BIT14
#define  GPIOD_PER_PE_15             BIT15

#define  GPIOD_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Assert Bits
//     0b0 ==> Deassert software interrupt
//     0b1 ==> Assert software interrupt
#define  GPIOD_IAR_IA_0              BIT0
#define  GPIOD_IAR_IA_1              BIT1
#define  GPIOD_IAR_IA_2              BIT2
#define  GPIOD_IAR_IA_3              BIT3
#define  GPIOD_IAR_IA_4              BIT4
#define  GPIOD_IAR_IA_5              BIT5
#define  GPIOD_IAR_IA_6              BIT6
#define  GPIOD_IAR_IA_7              BIT7
#define  GPIOD_IAR_IA_8              BIT8
#define  GPIOD_IAR_IA_9              BIT9
#define  GPIOD_IAR_IA_10             BIT10
#define  GPIOD_IAR_IA_11             BIT11
#define  GPIOD_IAR_IA_12             BIT12
#define  GPIOD_IAR_IA_13             BIT13
#define  GPIOD_IAR_IA_14             BIT14
#define  GPIOD_IAR_IA_15             BIT15

#define  GPIOD_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Enable Bits
//     0b0 ==> External Interrupt is disabled
//     0b1 ==> External Interrupt is enabled
#define  GPIOD_IENR_IEN_0            BIT0
#define  GPIOD_IENR_IEN_1            BIT1
#define  GPIOD_IENR_IEN_2            BIT2
#define  GPIOD_IENR_IEN_3            BIT3
#define  GPIOD_IENR_IEN_4            BIT4
#define  GPIOD_IENR_IEN_5            BIT5
#define  GPIOD_IENR_IEN_6            BIT6
#define  GPIOD_IENR_IEN_7            BIT7
#define  GPIOD_IENR_IEN_8            BIT8
#define  GPIOD_IENR_IEN_9            BIT9
#define  GPIOD_IENR_IEN_10           BIT10
#define  GPIOD_IENR_IEN_11           BIT11
#define  GPIOD_IENR_IEN_12           BIT12
#define  GPIOD_IENR_IEN_13           BIT13
#define  GPIOD_IENR_IEN_14           BIT14
#define  GPIOD_IENR_IEN_15           BIT15

#define  GPIOD_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Polarity Bits
//     0b0 ==> Interrupt occurred on rising edge
//     0b1 ==> Interrupt occurred on falling edge
#define  GPIOD_IPOLR_IPOL_0          BIT0
#define  GPIOD_IPOLR_IPOL_1          BIT1
#define  GPIOD_IPOLR_IPOL_2          BIT2
#define  GPIOD_IPOLR_IPOL_3          BIT3
#define  GPIOD_IPOLR_IPOL_4          BIT4
#define  GPIOD_IPOLR_IPOL_5          BIT5
#define  GPIOD_IPOLR_IPOL_6          BIT6
#define  GPIOD_IPOLR_IPOL_7          BIT7
#define  GPIOD_IPOLR_IPOL_8          BIT8
#define  GPIOD_IPOLR_IPOL_9          BIT9
#define  GPIOD_IPOLR_IPOL_10         BIT10
#define  GPIOD_IPOLR_IPOL_11         BIT11
#define  GPIOD_IPOLR_IPOL_12         BIT12
#define  GPIOD_IPOLR_IPOL_13         BIT13
#define  GPIOD_IPOLR_IPOL_14         BIT14
#define  GPIOD_IPOLR_IPOL_15         BIT15

#define  GPIOD_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Pending Bits
//     0b0 ==> No Interrupt
//     0b1 ==> Interrupt occurred
#define  GPIOD_IPR_IP_0              BIT0
#define  GPIOD_IPR_IP_1              BIT1
#define  GPIOD_IPR_IP_2              BIT2
#define  GPIOD_IPR_IP_3              BIT3
#define  GPIOD_IPR_IP_4              BIT4
#define  GPIOD_IPR_IP_5              BIT5
#define  GPIOD_IPR_IP_6              BIT6
#define  GPIOD_IPR_IP_7              BIT7
#define  GPIOD_IPR_IP_8              BIT8
#define  GPIOD_IPR_IP_9              BIT9
#define  GPIOD_IPR_IP_10             BIT10
#define  GPIOD_IPR_IP_11             BIT11
#define  GPIOD_IPR_IP_12             BIT12
#define  GPIOD_IPR_IP_13             BIT13
#define  GPIOD_IPR_IP_14             BIT14
#define  GPIOD_IPR_IP_15             BIT15

#define  GPIOD_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Edge-Sensitive Bits
//     0b0 ==> No edge detected if read; no effect if writing
//     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
#define  GPIOD_IESR_IES_0            BIT0
#define  GPIOD_IESR_IES_1            BIT1
#define  GPIOD_IESR_IES_2            BIT2
#define  GPIOD_IESR_IES_3            BIT3
#define  GPIOD_IESR_IES_4            BIT4
#define  GPIOD_IESR_IES_5            BIT5
#define  GPIOD_IESR_IES_6            BIT6
#define  GPIOD_IESR_IES_7            BIT7
#define  GPIOD_IESR_IES_8            BIT8
#define  GPIOD_IESR_IES_9            BIT9
#define  GPIOD_IESR_IES_10           BIT10
#define  GPIOD_IESR_IES_11           BIT11
#define  GPIOD_IESR_IES_12           BIT12
#define  GPIOD_IESR_IES_13           BIT13
#define  GPIOD_IESR_IES_14           BIT14
#define  GPIOD_IESR_IES_15           BIT15

#define  GPIOD_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Push-Pull Mode Bits
//     0b0 ==> Open Drain Mode
//     0b1 ==> Push-Pull Mode
#define  GPIOD_PPMODE_PPMODE_0       BIT0
#define  GPIOD_PPMODE_PPMODE_1       BIT1
#define  GPIOD_PPMODE_PPMODE_2       BIT2
#define  GPIOD_PPMODE_PPMODE_3       BIT3
#define  GPIOD_PPMODE_PPMODE_4       BIT4
#define  GPIOD_PPMODE_PPMODE_5       BIT5
#define  GPIOD_PPMODE_PPMODE_6       BIT6
#define  GPIOD_PPMODE_PPMODE_7       BIT7
#define  GPIOD_PPMODE_PPMODE_8       BIT8
#define  GPIOD_PPMODE_PPMODE_9       BIT9
#define  GPIOD_PPMODE_PPMODE_10      BIT10
#define  GPIOD_PPMODE_PPMODE_11      BIT11
#define  GPIOD_PPMODE_PPMODE_12      BIT12
#define  GPIOD_PPMODE_PPMODE_13      BIT13
#define  GPIOD_PPMODE_PPMODE_14      BIT14
#define  GPIOD_PPMODE_PPMODE_15      BIT15

#define  GPIOD_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Raw Data Bits
#define  GPIOD_RAWDATA_RAW_DATA_0    BIT0
#define  GPIOD_RAWDATA_RAW_DATA_1    BIT1
#define  GPIOD_RAWDATA_RAW_DATA_2    BIT2
#define  GPIOD_RAWDATA_RAW_DATA_3    BIT3
#define  GPIOD_RAWDATA_RAW_DATA_4    BIT4
#define  GPIOD_RAWDATA_RAW_DATA_5    BIT5
#define  GPIOD_RAWDATA_RAW_DATA_6    BIT6
#define  GPIOD_RAWDATA_RAW_DATA_7    BIT7
#define  GPIOD_RAWDATA_RAW_DATA_8    BIT8
#define  GPIOD_RAWDATA_RAW_DATA_9    BIT9
#define  GPIOD_RAWDATA_RAW_DATA_10   BIT10
#define  GPIOD_RAWDATA_RAW_DATA_11   BIT11
#define  GPIOD_RAWDATA_RAW_DATA_12   BIT12
#define  GPIOD_RAWDATA_RAW_DATA_13   BIT13
#define  GPIOD_RAWDATA_RAW_DATA_14   BIT14
#define  GPIOD_RAWDATA_RAW_DATA_15   BIT15

#define  GPIOD_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Drive Strength Selector Bits
//     0b0 ==> Low drive strength
//     0b1 ==> High drive strength
#define  GPIOD_DRIVE_DRIVE_0         BIT0
#define  GPIOD_DRIVE_DRIVE_1         BIT1
#define  GPIOD_DRIVE_DRIVE_2         BIT2
#define  GPIOD_DRIVE_DRIVE_3         BIT3
#define  GPIOD_DRIVE_DRIVE_4         BIT4
#define  GPIOD_DRIVE_DRIVE_5         BIT5
#define  GPIOD_DRIVE_DRIVE_6         BIT6
#define  GPIOD_DRIVE_DRIVE_7         BIT7
#define  GPIOD_DRIVE_DRIVE_8         BIT8
#define  GPIOD_DRIVE_DRIVE_9         BIT9
#define  GPIOD_DRIVE_DRIVE_10        BIT10
#define  GPIOD_DRIVE_DRIVE_11        BIT11
#define  GPIOD_DRIVE_DRIVE_12        BIT12
#define  GPIOD_DRIVE_DRIVE_13        BIT13
#define  GPIOD_DRIVE_DRIVE_14        BIT14
#define  GPIOD_DRIVE_DRIVE_15        BIT15

#define  GPIOD_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Type Select Bits
//     0b0 ==> Pulldown resistor
//     0b1 ==> Pullup resistor
#define  GPIOD_PUS_PUS_0             BIT0
#define  GPIOD_PUS_PUS_1             BIT1
#define  GPIOD_PUS_PUS_2             BIT2
#define  GPIOD_PUS_PUS_3             BIT3
#define  GPIOD_PUS_PUS_4             BIT4
#define  GPIOD_PUS_PUS_5             BIT5
#define  GPIOD_PUS_PUS_6             BIT6
#define  GPIOD_PUS_PUS_7             BIT7
#define  GPIOD_PUS_PUS_8             BIT8
#define  GPIOD_PUS_PUS_9             BIT9
#define  GPIOD_PUS_PUS_10            BIT10
#define  GPIOD_PUS_PUS_11            BIT11
#define  GPIOD_PUS_PUS_12            BIT12
#define  GPIOD_PUS_PUS_13            BIT13
#define  GPIOD_PUS_PUS_14            BIT14
#define  GPIOD_PUS_PUS_15            BIT15

#define  GPIOD_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Slew Rate Enable
//     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
//     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
#define  GPIOD_SRE_SRE_0             BIT0
#define  GPIOD_SRE_SRE_1             BIT1
#define  GPIOD_SRE_SRE_2             BIT2
#define  GPIOD_SRE_SRE_3             BIT3
#define  GPIOD_SRE_SRE_4             BIT4
#define  GPIOD_SRE_SRE_5             BIT5
#define  GPIOD_SRE_SRE_6             BIT6
#define  GPIOD_SRE_SRE_7             BIT7
#define  GPIOD_SRE_SRE_8             BIT8
#define  GPIOD_SRE_SRE_9             BIT9
#define  GPIOD_SRE_SRE_10            BIT10
#define  GPIOD_SRE_SRE_11            BIT11
#define  GPIOD_SRE_SRE_12            BIT12
#define  GPIOD_SRE_SRE_13            BIT13
#define  GPIOD_SRE_SRE_14            BIT14
#define  GPIOD_SRE_SRE_15            BIT15

#define  GPIOE_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Enable Bits
//     0b0 ==> Pull resistor is disabled
//     0b1 ==> Pull resistor is enabled
#define  GPIOE_PUR_PU_0              BIT0
#define  GPIOE_PUR_PU_1              BIT1
#define  GPIOE_PUR_PU_2              BIT2
#define  GPIOE_PUR_PU_3              BIT3
#define  GPIOE_PUR_PU_4              BIT4
#define  GPIOE_PUR_PU_5              BIT5
#define  GPIOE_PUR_PU_6              BIT6
#define  GPIOE_PUR_PU_7              BIT7
#define  GPIOE_PUR_PU_8              BIT8
#define  GPIOE_PUR_PU_9              BIT9
#define  GPIOE_PUR_PU_10             BIT10
#define  GPIOE_PUR_PU_11             BIT11
#define  GPIOE_PUR_PU_12             BIT12
#define  GPIOE_PUR_PU_13             BIT13
#define  GPIOE_PUR_PU_14             BIT14
#define  GPIOE_PUR_PU_15             BIT15

#define  GPIOE_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Bits
#define  GPIOE_DR_D_0                BIT0
#define  GPIOE_DR_D_1                BIT1
#define  GPIOE_DR_D_2                BIT2
#define  GPIOE_DR_D_3                BIT3
#define  GPIOE_DR_D_4                BIT4
#define  GPIOE_DR_D_5                BIT5
#define  GPIOE_DR_D_6                BIT6
#define  GPIOE_DR_D_7                BIT7
#define  GPIOE_DR_D_8                BIT8
#define  GPIOE_DR_D_9                BIT9
#define  GPIOE_DR_D_10               BIT10
#define  GPIOE_DR_D_11               BIT11
#define  GPIOE_DR_D_12               BIT12
#define  GPIOE_DR_D_13               BIT13
#define  GPIOE_DR_D_14               BIT14
#define  GPIOE_DR_D_15               BIT15

#define  GPIOE_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Direction Bits
//     0b0 ==> Pin is an input
//     0b1 ==> Pin is an output
#define  GPIOE_DDR_DD_0              BIT0
#define  GPIOE_DDR_DD_1              BIT1
#define  GPIOE_DDR_DD_2              BIT2
#define  GPIOE_DDR_DD_3              BIT3
#define  GPIOE_DDR_DD_4              BIT4
#define  GPIOE_DDR_DD_5              BIT5
#define  GPIOE_DDR_DD_6              BIT6
#define  GPIOE_DDR_DD_7              BIT7
#define  GPIOE_DDR_DD_8              BIT8
#define  GPIOE_DDR_DD_9              BIT9
#define  GPIOE_DDR_DD_10             BIT10
#define  GPIOE_DDR_DD_11             BIT11
#define  GPIOE_DDR_DD_12             BIT12
#define  GPIOE_DDR_DD_13             BIT13
#define  GPIOE_DDR_DD_14             BIT14
#define  GPIOE_DDR_DD_15             BIT15

#define  GPIOE_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Peripheral Enable Bits
//     0b0 ==> Pin is for GPIO (GPIO mode)
//     0b1 ==> Pin is for peripheral (peripheral mode)
#define  GPIOE_PER_PE_0              BIT0
#define  GPIOE_PER_PE_1              BIT1
#define  GPIOE_PER_PE_2              BIT2
#define  GPIOE_PER_PE_3              BIT3
#define  GPIOE_PER_PE_4              BIT4
#define  GPIOE_PER_PE_5              BIT5
#define  GPIOE_PER_PE_6              BIT6
#define  GPIOE_PER_PE_7              BIT7
#define  GPIOE_PER_PE_8              BIT8
#define  GPIOE_PER_PE_9              BIT9
#define  GPIOE_PER_PE_10             BIT10
#define  GPIOE_PER_PE_11             BIT11
#define  GPIOE_PER_PE_12             BIT12
#define  GPIOE_PER_PE_13             BIT13
#define  GPIOE_PER_PE_14             BIT14
#define  GPIOE_PER_PE_15             BIT15

#define  GPIOE_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Assert Bits
//     0b0 ==> Deassert software interrupt
//     0b1 ==> Assert software interrupt
#define  GPIOE_IAR_IA_0              BIT0
#define  GPIOE_IAR_IA_1              BIT1
#define  GPIOE_IAR_IA_2              BIT2
#define  GPIOE_IAR_IA_3              BIT3
#define  GPIOE_IAR_IA_4              BIT4
#define  GPIOE_IAR_IA_5              BIT5
#define  GPIOE_IAR_IA_6              BIT6
#define  GPIOE_IAR_IA_7              BIT7
#define  GPIOE_IAR_IA_8              BIT8
#define  GPIOE_IAR_IA_9              BIT9
#define  GPIOE_IAR_IA_10             BIT10
#define  GPIOE_IAR_IA_11             BIT11
#define  GPIOE_IAR_IA_12             BIT12
#define  GPIOE_IAR_IA_13             BIT13
#define  GPIOE_IAR_IA_14             BIT14
#define  GPIOE_IAR_IA_15             BIT15

#define  GPIOE_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Enable Bits
//     0b0 ==> External Interrupt is disabled
//     0b1 ==> External Interrupt is enabled
#define  GPIOE_IENR_IEN_0            BIT0
#define  GPIOE_IENR_IEN_1            BIT1
#define  GPIOE_IENR_IEN_2            BIT2
#define  GPIOE_IENR_IEN_3            BIT3
#define  GPIOE_IENR_IEN_4            BIT4
#define  GPIOE_IENR_IEN_5            BIT5
#define  GPIOE_IENR_IEN_6            BIT6
#define  GPIOE_IENR_IEN_7            BIT7
#define  GPIOE_IENR_IEN_8            BIT8
#define  GPIOE_IENR_IEN_9            BIT9
#define  GPIOE_IENR_IEN_10           BIT10
#define  GPIOE_IENR_IEN_11           BIT11
#define  GPIOE_IENR_IEN_12           BIT12
#define  GPIOE_IENR_IEN_13           BIT13
#define  GPIOE_IENR_IEN_14           BIT14
#define  GPIOE_IENR_IEN_15           BIT15

#define  GPIOE_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Polarity Bits
//     0b0 ==> Interrupt occurred on rising edge
//     0b1 ==> Interrupt occurred on falling edge
#define  GPIOE_IPOLR_IPOL_0          BIT0
#define  GPIOE_IPOLR_IPOL_1          BIT1
#define  GPIOE_IPOLR_IPOL_2          BIT2
#define  GPIOE_IPOLR_IPOL_3          BIT3
#define  GPIOE_IPOLR_IPOL_4          BIT4
#define  GPIOE_IPOLR_IPOL_5          BIT5
#define  GPIOE_IPOLR_IPOL_6          BIT6
#define  GPIOE_IPOLR_IPOL_7          BIT7
#define  GPIOE_IPOLR_IPOL_8          BIT8
#define  GPIOE_IPOLR_IPOL_9          BIT9
#define  GPIOE_IPOLR_IPOL_10         BIT10
#define  GPIOE_IPOLR_IPOL_11         BIT11
#define  GPIOE_IPOLR_IPOL_12         BIT12
#define  GPIOE_IPOLR_IPOL_13         BIT13
#define  GPIOE_IPOLR_IPOL_14         BIT14
#define  GPIOE_IPOLR_IPOL_15         BIT15

#define  GPIOE_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Pending Bits
//     0b0 ==> No Interrupt
//     0b1 ==> Interrupt occurred
#define  GPIOE_IPR_IP_0              BIT0
#define  GPIOE_IPR_IP_1              BIT1
#define  GPIOE_IPR_IP_2              BIT2
#define  GPIOE_IPR_IP_3              BIT3
#define  GPIOE_IPR_IP_4              BIT4
#define  GPIOE_IPR_IP_5              BIT5
#define  GPIOE_IPR_IP_6              BIT6
#define  GPIOE_IPR_IP_7              BIT7
#define  GPIOE_IPR_IP_8              BIT8
#define  GPIOE_IPR_IP_9              BIT9
#define  GPIOE_IPR_IP_10             BIT10
#define  GPIOE_IPR_IP_11             BIT11
#define  GPIOE_IPR_IP_12             BIT12
#define  GPIOE_IPR_IP_13             BIT13
#define  GPIOE_IPR_IP_14             BIT14
#define  GPIOE_IPR_IP_15             BIT15

#define  GPIOE_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Edge-Sensitive Bits
//     0b0 ==> No edge detected if read; no effect if writing
//     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
#define  GPIOE_IESR_IES_0            BIT0
#define  GPIOE_IESR_IES_1            BIT1
#define  GPIOE_IESR_IES_2            BIT2
#define  GPIOE_IESR_IES_3            BIT3
#define  GPIOE_IESR_IES_4            BIT4
#define  GPIOE_IESR_IES_5            BIT5
#define  GPIOE_IESR_IES_6            BIT6
#define  GPIOE_IESR_IES_7            BIT7
#define  GPIOE_IESR_IES_8            BIT8
#define  GPIOE_IESR_IES_9            BIT9
#define  GPIOE_IESR_IES_10           BIT10
#define  GPIOE_IESR_IES_11           BIT11
#define  GPIOE_IESR_IES_12           BIT12
#define  GPIOE_IESR_IES_13           BIT13
#define  GPIOE_IESR_IES_14           BIT14
#define  GPIOE_IESR_IES_15           BIT15

#define  GPIOE_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Push-Pull Mode Bits
//     0b0 ==> Open Drain Mode
//     0b1 ==> Push-Pull Mode
#define  GPIOE_PPMODE_PPMODE_0       BIT0
#define  GPIOE_PPMODE_PPMODE_1       BIT1
#define  GPIOE_PPMODE_PPMODE_2       BIT2
#define  GPIOE_PPMODE_PPMODE_3       BIT3
#define  GPIOE_PPMODE_PPMODE_4       BIT4
#define  GPIOE_PPMODE_PPMODE_5       BIT5
#define  GPIOE_PPMODE_PPMODE_6       BIT6
#define  GPIOE_PPMODE_PPMODE_7       BIT7
#define  GPIOE_PPMODE_PPMODE_8       BIT8
#define  GPIOE_PPMODE_PPMODE_9       BIT9
#define  GPIOE_PPMODE_PPMODE_10      BIT10
#define  GPIOE_PPMODE_PPMODE_11      BIT11
#define  GPIOE_PPMODE_PPMODE_12      BIT12
#define  GPIOE_PPMODE_PPMODE_13      BIT13
#define  GPIOE_PPMODE_PPMODE_14      BIT14
#define  GPIOE_PPMODE_PPMODE_15      BIT15

#define  GPIOE_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Raw Data Bits
#define  GPIOE_RAWDATA_RAW_DATA_0    BIT0
#define  GPIOE_RAWDATA_RAW_DATA_1    BIT1
#define  GPIOE_RAWDATA_RAW_DATA_2    BIT2
#define  GPIOE_RAWDATA_RAW_DATA_3    BIT3
#define  GPIOE_RAWDATA_RAW_DATA_4    BIT4
#define  GPIOE_RAWDATA_RAW_DATA_5    BIT5
#define  GPIOE_RAWDATA_RAW_DATA_6    BIT6
#define  GPIOE_RAWDATA_RAW_DATA_7    BIT7
#define  GPIOE_RAWDATA_RAW_DATA_8    BIT8
#define  GPIOE_RAWDATA_RAW_DATA_9    BIT9
#define  GPIOE_RAWDATA_RAW_DATA_10   BIT10
#define  GPIOE_RAWDATA_RAW_DATA_11   BIT11
#define  GPIOE_RAWDATA_RAW_DATA_12   BIT12
#define  GPIOE_RAWDATA_RAW_DATA_13   BIT13
#define  GPIOE_RAWDATA_RAW_DATA_14   BIT14
#define  GPIOE_RAWDATA_RAW_DATA_15   BIT15

#define  GPIOE_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Drive Strength Selector Bits
//     0b0 ==> Low drive strength
//     0b1 ==> High drive strength
#define  GPIOE_DRIVE_DRIVE_0         BIT0
#define  GPIOE_DRIVE_DRIVE_1         BIT1
#define  GPIOE_DRIVE_DRIVE_2         BIT2
#define  GPIOE_DRIVE_DRIVE_3         BIT3
#define  GPIOE_DRIVE_DRIVE_4         BIT4
#define  GPIOE_DRIVE_DRIVE_5         BIT5
#define  GPIOE_DRIVE_DRIVE_6         BIT6
#define  GPIOE_DRIVE_DRIVE_7         BIT7
#define  GPIOE_DRIVE_DRIVE_8         BIT8
#define  GPIOE_DRIVE_DRIVE_9         BIT9
#define  GPIOE_DRIVE_DRIVE_10        BIT10
#define  GPIOE_DRIVE_DRIVE_11        BIT11
#define  GPIOE_DRIVE_DRIVE_12        BIT12
#define  GPIOE_DRIVE_DRIVE_13        BIT13
#define  GPIOE_DRIVE_DRIVE_14        BIT14
#define  GPIOE_DRIVE_DRIVE_15        BIT15

#define  GPIOE_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Type Select Bits
//     0b0 ==> Pulldown resistor
//     0b1 ==> Pullup resistor
#define  GPIOE_PUS_PUS_0             BIT0
#define  GPIOE_PUS_PUS_1             BIT1
#define  GPIOE_PUS_PUS_2             BIT2
#define  GPIOE_PUS_PUS_3             BIT3
#define  GPIOE_PUS_PUS_4             BIT4
#define  GPIOE_PUS_PUS_5             BIT5
#define  GPIOE_PUS_PUS_6             BIT6
#define  GPIOE_PUS_PUS_7             BIT7
#define  GPIOE_PUS_PUS_8             BIT8
#define  GPIOE_PUS_PUS_9             BIT9
#define  GPIOE_PUS_PUS_10            BIT10
#define  GPIOE_PUS_PUS_11            BIT11
#define  GPIOE_PUS_PUS_12            BIT12
#define  GPIOE_PUS_PUS_13            BIT13
#define  GPIOE_PUS_PUS_14            BIT14
#define  GPIOE_PUS_PUS_15            BIT15

#define  GPIOE_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Slew Rate Enable
//     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
//     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
#define  GPIOE_SRE_SRE_0             BIT0
#define  GPIOE_SRE_SRE_1             BIT1
#define  GPIOE_SRE_SRE_2             BIT2
#define  GPIOE_SRE_SRE_3             BIT3
#define  GPIOE_SRE_SRE_4             BIT4
#define  GPIOE_SRE_SRE_5             BIT5
#define  GPIOE_SRE_SRE_6             BIT6
#define  GPIOE_SRE_SRE_7             BIT7
#define  GPIOE_SRE_SRE_8             BIT8
#define  GPIOE_SRE_SRE_9             BIT9
#define  GPIOE_SRE_SRE_10            BIT10
#define  GPIOE_SRE_SRE_11            BIT11
#define  GPIOE_SRE_SRE_12            BIT12
#define  GPIOE_SRE_SRE_13            BIT13
#define  GPIOE_SRE_SRE_14            BIT14
#define  GPIOE_SRE_SRE_15            BIT15

#define  GPIOF_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Enable Bits
//     0b0 ==> Pull resistor is disabled
//     0b1 ==> Pull resistor is enabled
#define  GPIOF_PUR_PU_0              BIT0
#define  GPIOF_PUR_PU_1              BIT1
#define  GPIOF_PUR_PU_2              BIT2
#define  GPIOF_PUR_PU_3              BIT3
#define  GPIOF_PUR_PU_4              BIT4
#define  GPIOF_PUR_PU_5              BIT5
#define  GPIOF_PUR_PU_6              BIT6
#define  GPIOF_PUR_PU_7              BIT7
#define  GPIOF_PUR_PU_8              BIT8
#define  GPIOF_PUR_PU_9              BIT9
#define  GPIOF_PUR_PU_10             BIT10
#define  GPIOF_PUR_PU_11             BIT11
#define  GPIOF_PUR_PU_12             BIT12
#define  GPIOF_PUR_PU_13             BIT13
#define  GPIOF_PUR_PU_14             BIT14
#define  GPIOF_PUR_PU_15             BIT15

#define  GPIOF_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Bits
#define  GPIOF_DR_D_0                BIT0
#define  GPIOF_DR_D_1                BIT1
#define  GPIOF_DR_D_2                BIT2
#define  GPIOF_DR_D_3                BIT3
#define  GPIOF_DR_D_4                BIT4
#define  GPIOF_DR_D_5                BIT5
#define  GPIOF_DR_D_6                BIT6
#define  GPIOF_DR_D_7                BIT7
#define  GPIOF_DR_D_8                BIT8
#define  GPIOF_DR_D_9                BIT9
#define  GPIOF_DR_D_10               BIT10
#define  GPIOF_DR_D_11               BIT11
#define  GPIOF_DR_D_12               BIT12
#define  GPIOF_DR_D_13               BIT13
#define  GPIOF_DR_D_14               BIT14
#define  GPIOF_DR_D_15               BIT15

#define  GPIOF_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Direction Bits
//     0b0 ==> Pin is an input
//     0b1 ==> Pin is an output
#define  GPIOF_DDR_DD_0              BIT0
#define  GPIOF_DDR_DD_1              BIT1
#define  GPIOF_DDR_DD_2              BIT2
#define  GPIOF_DDR_DD_3              BIT3
#define  GPIOF_DDR_DD_4              BIT4
#define  GPIOF_DDR_DD_5              BIT5
#define  GPIOF_DDR_DD_6              BIT6
#define  GPIOF_DDR_DD_7              BIT7
#define  GPIOF_DDR_DD_8              BIT8
#define  GPIOF_DDR_DD_9              BIT9
#define  GPIOF_DDR_DD_10             BIT10
#define  GPIOF_DDR_DD_11             BIT11
#define  GPIOF_DDR_DD_12             BIT12
#define  GPIOF_DDR_DD_13             BIT13
#define  GPIOF_DDR_DD_14             BIT14
#define  GPIOF_DDR_DD_15             BIT15

#define  GPIOF_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Peripheral Enable Bits
//     0b0 ==> Pin is for GPIO (GPIO mode)
//     0b1 ==> Pin is for peripheral (peripheral mode)
#define  GPIOF_PER_PE_0              BIT0
#define  GPIOF_PER_PE_1              BIT1
#define  GPIOF_PER_PE_2              BIT2
#define  GPIOF_PER_PE_3              BIT3
#define  GPIOF_PER_PE_4              BIT4
#define  GPIOF_PER_PE_5              BIT5
#define  GPIOF_PER_PE_6              BIT6
#define  GPIOF_PER_PE_7              BIT7
#define  GPIOF_PER_PE_8              BIT8
#define  GPIOF_PER_PE_9              BIT9
#define  GPIOF_PER_PE_10             BIT10
#define  GPIOF_PER_PE_11             BIT11
#define  GPIOF_PER_PE_12             BIT12
#define  GPIOF_PER_PE_13             BIT13
#define  GPIOF_PER_PE_14             BIT14
#define  GPIOF_PER_PE_15             BIT15

#define  GPIOF_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Assert Bits
//     0b0 ==> Deassert software interrupt
//     0b1 ==> Assert software interrupt
#define  GPIOF_IAR_IA_0              BIT0
#define  GPIOF_IAR_IA_1              BIT1
#define  GPIOF_IAR_IA_2              BIT2
#define  GPIOF_IAR_IA_3              BIT3
#define  GPIOF_IAR_IA_4              BIT4
#define  GPIOF_IAR_IA_5              BIT5
#define  GPIOF_IAR_IA_6              BIT6
#define  GPIOF_IAR_IA_7              BIT7
#define  GPIOF_IAR_IA_8              BIT8
#define  GPIOF_IAR_IA_9              BIT9
#define  GPIOF_IAR_IA_10             BIT10
#define  GPIOF_IAR_IA_11             BIT11
#define  GPIOF_IAR_IA_12             BIT12
#define  GPIOF_IAR_IA_13             BIT13
#define  GPIOF_IAR_IA_14             BIT14
#define  GPIOF_IAR_IA_15             BIT15

#define  GPIOF_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Enable Bits
//     0b0 ==> External Interrupt is disabled
//     0b1 ==> External Interrupt is enabled
#define  GPIOF_IENR_IEN_0            BIT0
#define  GPIOF_IENR_IEN_1            BIT1
#define  GPIOF_IENR_IEN_2            BIT2
#define  GPIOF_IENR_IEN_3            BIT3
#define  GPIOF_IENR_IEN_4            BIT4
#define  GPIOF_IENR_IEN_5            BIT5
#define  GPIOF_IENR_IEN_6            BIT6
#define  GPIOF_IENR_IEN_7            BIT7
#define  GPIOF_IENR_IEN_8            BIT8
#define  GPIOF_IENR_IEN_9            BIT9
#define  GPIOF_IENR_IEN_10           BIT10
#define  GPIOF_IENR_IEN_11           BIT11
#define  GPIOF_IENR_IEN_12           BIT12
#define  GPIOF_IENR_IEN_13           BIT13
#define  GPIOF_IENR_IEN_14           BIT14
#define  GPIOF_IENR_IEN_15           BIT15

#define  GPIOF_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Polarity Bits
//     0b0 ==> Interrupt occurred on rising edge
//     0b1 ==> Interrupt occurred on falling edge
#define  GPIOF_IPOLR_IPOL_0          BIT0
#define  GPIOF_IPOLR_IPOL_1          BIT1
#define  GPIOF_IPOLR_IPOL_2          BIT2
#define  GPIOF_IPOLR_IPOL_3          BIT3
#define  GPIOF_IPOLR_IPOL_4          BIT4
#define  GPIOF_IPOLR_IPOL_5          BIT5
#define  GPIOF_IPOLR_IPOL_6          BIT6
#define  GPIOF_IPOLR_IPOL_7          BIT7
#define  GPIOF_IPOLR_IPOL_8          BIT8
#define  GPIOF_IPOLR_IPOL_9          BIT9
#define  GPIOF_IPOLR_IPOL_10         BIT10
#define  GPIOF_IPOLR_IPOL_11         BIT11
#define  GPIOF_IPOLR_IPOL_12         BIT12
#define  GPIOF_IPOLR_IPOL_13         BIT13
#define  GPIOF_IPOLR_IPOL_14         BIT14
#define  GPIOF_IPOLR_IPOL_15         BIT15

#define  GPIOF_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Pending Bits
//     0b0 ==> No Interrupt
//     0b1 ==> Interrupt occurred
#define  GPIOF_IPR_IP_0              BIT0
#define  GPIOF_IPR_IP_1              BIT1
#define  GPIOF_IPR_IP_2              BIT2
#define  GPIOF_IPR_IP_3              BIT3
#define  GPIOF_IPR_IP_4              BIT4
#define  GPIOF_IPR_IP_5              BIT5
#define  GPIOF_IPR_IP_6              BIT6
#define  GPIOF_IPR_IP_7              BIT7
#define  GPIOF_IPR_IP_8              BIT8
#define  GPIOF_IPR_IP_9              BIT9
#define  GPIOF_IPR_IP_10             BIT10
#define  GPIOF_IPR_IP_11             BIT11
#define  GPIOF_IPR_IP_12             BIT12
#define  GPIOF_IPR_IP_13             BIT13
#define  GPIOF_IPR_IP_14             BIT14
#define  GPIOF_IPR_IP_15             BIT15

#define  GPIOF_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Edge-Sensitive Bits
//     0b0 ==> No edge detected if read; no effect if writing
//     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
#define  GPIOF_IESR_IES_0            BIT0
#define  GPIOF_IESR_IES_1            BIT1
#define  GPIOF_IESR_IES_2            BIT2
#define  GPIOF_IESR_IES_3            BIT3
#define  GPIOF_IESR_IES_4            BIT4
#define  GPIOF_IESR_IES_5            BIT5
#define  GPIOF_IESR_IES_6            BIT6
#define  GPIOF_IESR_IES_7            BIT7
#define  GPIOF_IESR_IES_8            BIT8
#define  GPIOF_IESR_IES_9            BIT9
#define  GPIOF_IESR_IES_10           BIT10
#define  GPIOF_IESR_IES_11           BIT11
#define  GPIOF_IESR_IES_12           BIT12
#define  GPIOF_IESR_IES_13           BIT13
#define  GPIOF_IESR_IES_14           BIT14
#define  GPIOF_IESR_IES_15           BIT15

#define  GPIOF_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Push-Pull Mode Bits
//     0b0 ==> Open Drain Mode
//     0b1 ==> Push-Pull Mode
#define  GPIOF_PPMODE_PPMODE_0       BIT0
#define  GPIOF_PPMODE_PPMODE_1       BIT1
#define  GPIOF_PPMODE_PPMODE_2       BIT2
#define  GPIOF_PPMODE_PPMODE_3       BIT3
#define  GPIOF_PPMODE_PPMODE_4       BIT4
#define  GPIOF_PPMODE_PPMODE_5       BIT5
#define  GPIOF_PPMODE_PPMODE_6       BIT6
#define  GPIOF_PPMODE_PPMODE_7       BIT7
#define  GPIOF_PPMODE_PPMODE_8       BIT8
#define  GPIOF_PPMODE_PPMODE_9       BIT9
#define  GPIOF_PPMODE_PPMODE_10      BIT10
#define  GPIOF_PPMODE_PPMODE_11      BIT11
#define  GPIOF_PPMODE_PPMODE_12      BIT12
#define  GPIOF_PPMODE_PPMODE_13      BIT13
#define  GPIOF_PPMODE_PPMODE_14      BIT14
#define  GPIOF_PPMODE_PPMODE_15      BIT15

#define  GPIOF_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Raw Data Bits
#define  GPIOF_RAWDATA_RAW_DATA_0    BIT0
#define  GPIOF_RAWDATA_RAW_DATA_1    BIT1
#define  GPIOF_RAWDATA_RAW_DATA_2    BIT2
#define  GPIOF_RAWDATA_RAW_DATA_3    BIT3
#define  GPIOF_RAWDATA_RAW_DATA_4    BIT4
#define  GPIOF_RAWDATA_RAW_DATA_5    BIT5
#define  GPIOF_RAWDATA_RAW_DATA_6    BIT6
#define  GPIOF_RAWDATA_RAW_DATA_7    BIT7
#define  GPIOF_RAWDATA_RAW_DATA_8    BIT8
#define  GPIOF_RAWDATA_RAW_DATA_9    BIT9
#define  GPIOF_RAWDATA_RAW_DATA_10   BIT10
#define  GPIOF_RAWDATA_RAW_DATA_11   BIT11
#define  GPIOF_RAWDATA_RAW_DATA_12   BIT12
#define  GPIOF_RAWDATA_RAW_DATA_13   BIT13
#define  GPIOF_RAWDATA_RAW_DATA_14   BIT14
#define  GPIOF_RAWDATA_RAW_DATA_15   BIT15

#define  GPIOF_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Drive Strength Selector Bits
//     0b0 ==> Low drive strength
//     0b1 ==> High drive strength
#define  GPIOF_DRIVE_DRIVE_0         BIT0
#define  GPIOF_DRIVE_DRIVE_1         BIT1
#define  GPIOF_DRIVE_DRIVE_2         BIT2
#define  GPIOF_DRIVE_DRIVE_3         BIT3
#define  GPIOF_DRIVE_DRIVE_4         BIT4
#define  GPIOF_DRIVE_DRIVE_5         BIT5
#define  GPIOF_DRIVE_DRIVE_6         BIT6
#define  GPIOF_DRIVE_DRIVE_7         BIT7
#define  GPIOF_DRIVE_DRIVE_8         BIT8
#define  GPIOF_DRIVE_DRIVE_9         BIT9
#define  GPIOF_DRIVE_DRIVE_10        BIT10
#define  GPIOF_DRIVE_DRIVE_11        BIT11
#define  GPIOF_DRIVE_DRIVE_12        BIT12
#define  GPIOF_DRIVE_DRIVE_13        BIT13
#define  GPIOF_DRIVE_DRIVE_14        BIT14
#define  GPIOF_DRIVE_DRIVE_15        BIT15

#define  GPIOF_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Type Select Bits
//     0b0 ==> Pulldown resistor
//     0b1 ==> Pullup resistor
#define  GPIOF_PUS_PUS_0             BIT0
#define  GPIOF_PUS_PUS_1             BIT1
#define  GPIOF_PUS_PUS_2             BIT2
#define  GPIOF_PUS_PUS_3             BIT3
#define  GPIOF_PUS_PUS_4             BIT4
#define  GPIOF_PUS_PUS_5             BIT5
#define  GPIOF_PUS_PUS_6             BIT6
#define  GPIOF_PUS_PUS_7             BIT7
#define  GPIOF_PUS_PUS_8             BIT8
#define  GPIOF_PUS_PUS_9             BIT9
#define  GPIOF_PUS_PUS_10            BIT10
#define  GPIOF_PUS_PUS_11            BIT11
#define  GPIOF_PUS_PUS_12            BIT12
#define  GPIOF_PUS_PUS_13            BIT13
#define  GPIOF_PUS_PUS_14            BIT14
#define  GPIOF_PUS_PUS_15            BIT15

#define  GPIOF_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Slew Rate Enable
//     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
//     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
#define  GPIOF_SRE_SRE_0             BIT0
#define  GPIOF_SRE_SRE_1             BIT1
#define  GPIOF_SRE_SRE_2             BIT2
#define  GPIOF_SRE_SRE_3             BIT3
#define  GPIOF_SRE_SRE_4             BIT4
#define  GPIOF_SRE_SRE_5             BIT5
#define  GPIOF_SRE_SRE_6             BIT6
#define  GPIOF_SRE_SRE_7             BIT7
#define  GPIOF_SRE_SRE_8             BIT8
#define  GPIOF_SRE_SRE_9             BIT9
#define  GPIOF_SRE_SRE_10            BIT10
#define  GPIOF_SRE_SRE_11            BIT11
#define  GPIOF_SRE_SRE_12            BIT12
#define  GPIOF_SRE_SRE_13            BIT13
#define  GPIOF_SRE_SRE_14            BIT14
#define  GPIOF_SRE_SRE_15            BIT15

#define  GPIOG_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Enable Bits
//     0b0 ==> Pull resistor is disabled
//     0b1 ==> Pull resistor is enabled
#define  GPIOG_PUR_PU_0              BIT0
#define  GPIOG_PUR_PU_1              BIT1
#define  GPIOG_PUR_PU_2              BIT2
#define  GPIOG_PUR_PU_3              BIT3
#define  GPIOG_PUR_PU_4              BIT4
#define  GPIOG_PUR_PU_5              BIT5
#define  GPIOG_PUR_PU_6              BIT6
#define  GPIOG_PUR_PU_7              BIT7
#define  GPIOG_PUR_PU_8              BIT8
#define  GPIOG_PUR_PU_9              BIT9
#define  GPIOG_PUR_PU_10             BIT10
#define  GPIOG_PUR_PU_11             BIT11
#define  GPIOG_PUR_PU_12             BIT12
#define  GPIOG_PUR_PU_13             BIT13
#define  GPIOG_PUR_PU_14             BIT14
#define  GPIOG_PUR_PU_15             BIT15

#define  GPIOG_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Bits
#define  GPIOG_DR_D_0                BIT0
#define  GPIOG_DR_D_1                BIT1
#define  GPIOG_DR_D_2                BIT2
#define  GPIOG_DR_D_3                BIT3
#define  GPIOG_DR_D_4                BIT4
#define  GPIOG_DR_D_5                BIT5
#define  GPIOG_DR_D_6                BIT6
#define  GPIOG_DR_D_7                BIT7
#define  GPIOG_DR_D_8                BIT8
#define  GPIOG_DR_D_9                BIT9
#define  GPIOG_DR_D_10               BIT10
#define  GPIOG_DR_D_11               BIT11
#define  GPIOG_DR_D_12               BIT12
#define  GPIOG_DR_D_13               BIT13
#define  GPIOG_DR_D_14               BIT14
#define  GPIOG_DR_D_15               BIT15

#define  GPIOG_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Data Direction Bits
//     0b0 ==> Pin is an input
//     0b1 ==> Pin is an output
#define  GPIOG_DDR_DD_0              BIT0
#define  GPIOG_DDR_DD_1              BIT1
#define  GPIOG_DDR_DD_2              BIT2
#define  GPIOG_DDR_DD_3              BIT3
#define  GPIOG_DDR_DD_4              BIT4
#define  GPIOG_DDR_DD_5              BIT5
#define  GPIOG_DDR_DD_6              BIT6
#define  GPIOG_DDR_DD_7              BIT7
#define  GPIOG_DDR_DD_8              BIT8
#define  GPIOG_DDR_DD_9              BIT9
#define  GPIOG_DDR_DD_10             BIT10
#define  GPIOG_DDR_DD_11             BIT11
#define  GPIOG_DDR_DD_12             BIT12
#define  GPIOG_DDR_DD_13             BIT13
#define  GPIOG_DDR_DD_14             BIT14
#define  GPIOG_DDR_DD_15             BIT15

#define  GPIOG_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Peripheral Enable Bits
//     0b0 ==> Pin is for GPIO (GPIO mode)
//     0b1 ==> Pin is for peripheral (peripheral mode)
#define  GPIOG_PER_PE_0              BIT0
#define  GPIOG_PER_PE_1              BIT1
#define  GPIOG_PER_PE_2              BIT2
#define  GPIOG_PER_PE_3              BIT3
#define  GPIOG_PER_PE_4              BIT4
#define  GPIOG_PER_PE_5              BIT5
#define  GPIOG_PER_PE_6              BIT6
#define  GPIOG_PER_PE_7              BIT7
#define  GPIOG_PER_PE_8              BIT8
#define  GPIOG_PER_PE_9              BIT9
#define  GPIOG_PER_PE_10             BIT10
#define  GPIOG_PER_PE_11             BIT11
#define  GPIOG_PER_PE_12             BIT12
#define  GPIOG_PER_PE_13             BIT13
#define  GPIOG_PER_PE_14             BIT14
#define  GPIOG_PER_PE_15             BIT15

#define  GPIOG_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Assert Bits
//     0b0 ==> Deassert software interrupt
//     0b1 ==> Assert software interrupt
#define  GPIOG_IAR_IA_0              BIT0
#define  GPIOG_IAR_IA_1              BIT1
#define  GPIOG_IAR_IA_2              BIT2
#define  GPIOG_IAR_IA_3              BIT3
#define  GPIOG_IAR_IA_4              BIT4
#define  GPIOG_IAR_IA_5              BIT5
#define  GPIOG_IAR_IA_6              BIT6
#define  GPIOG_IAR_IA_7              BIT7
#define  GPIOG_IAR_IA_8              BIT8
#define  GPIOG_IAR_IA_9              BIT9
#define  GPIOG_IAR_IA_10             BIT10
#define  GPIOG_IAR_IA_11             BIT11
#define  GPIOG_IAR_IA_12             BIT12
#define  GPIOG_IAR_IA_13             BIT13
#define  GPIOG_IAR_IA_14             BIT14
#define  GPIOG_IAR_IA_15             BIT15

#define  GPIOG_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Enable Bits
//     0b0 ==> External Interrupt is disabled
//     0b1 ==> External Interrupt is enabled
#define  GPIOG_IENR_IEN_0            BIT0
#define  GPIOG_IENR_IEN_1            BIT1
#define  GPIOG_IENR_IEN_2            BIT2
#define  GPIOG_IENR_IEN_3            BIT3
#define  GPIOG_IENR_IEN_4            BIT4
#define  GPIOG_IENR_IEN_5            BIT5
#define  GPIOG_IENR_IEN_6            BIT6
#define  GPIOG_IENR_IEN_7            BIT7
#define  GPIOG_IENR_IEN_8            BIT8
#define  GPIOG_IENR_IEN_9            BIT9
#define  GPIOG_IENR_IEN_10           BIT10
#define  GPIOG_IENR_IEN_11           BIT11
#define  GPIOG_IENR_IEN_12           BIT12
#define  GPIOG_IENR_IEN_13           BIT13
#define  GPIOG_IENR_IEN_14           BIT14
#define  GPIOG_IENR_IEN_15           BIT15

#define  GPIOG_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Polarity Bits
//     0b0 ==> Interrupt occurred on rising edge
//     0b1 ==> Interrupt occurred on falling edge
#define  GPIOG_IPOLR_IPOL_0          BIT0
#define  GPIOG_IPOLR_IPOL_1          BIT1
#define  GPIOG_IPOLR_IPOL_2          BIT2
#define  GPIOG_IPOLR_IPOL_3          BIT3
#define  GPIOG_IPOLR_IPOL_4          BIT4
#define  GPIOG_IPOLR_IPOL_5          BIT5
#define  GPIOG_IPOLR_IPOL_6          BIT6
#define  GPIOG_IPOLR_IPOL_7          BIT7
#define  GPIOG_IPOLR_IPOL_8          BIT8
#define  GPIOG_IPOLR_IPOL_9          BIT9
#define  GPIOG_IPOLR_IPOL_10         BIT10
#define  GPIOG_IPOLR_IPOL_11         BIT11
#define  GPIOG_IPOLR_IPOL_12         BIT12
#define  GPIOG_IPOLR_IPOL_13         BIT13
#define  GPIOG_IPOLR_IPOL_14         BIT14
#define  GPIOG_IPOLR_IPOL_15         BIT15

#define  GPIOG_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Pending Bits
//     0b0 ==> No Interrupt
//     0b1 ==> Interrupt occurred
#define  GPIOG_IPR_IP_0              BIT0
#define  GPIOG_IPR_IP_1              BIT1
#define  GPIOG_IPR_IP_2              BIT2
#define  GPIOG_IPR_IP_3              BIT3
#define  GPIOG_IPR_IP_4              BIT4
#define  GPIOG_IPR_IP_5              BIT5
#define  GPIOG_IPR_IP_6              BIT6
#define  GPIOG_IPR_IP_7              BIT7
#define  GPIOG_IPR_IP_8              BIT8
#define  GPIOG_IPR_IP_9              BIT9
#define  GPIOG_IPR_IP_10             BIT10
#define  GPIOG_IPR_IP_11             BIT11
#define  GPIOG_IPR_IP_12             BIT12
#define  GPIOG_IPR_IP_13             BIT13
#define  GPIOG_IPR_IP_14             BIT14
#define  GPIOG_IPR_IP_15             BIT15

#define  GPIOG_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Interrupt Edge-Sensitive Bits
//     0b0 ==> No edge detected if read; no effect if writing
//     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
#define  GPIOG_IESR_IES_0            BIT0
#define  GPIOG_IESR_IES_1            BIT1
#define  GPIOG_IESR_IES_2            BIT2
#define  GPIOG_IESR_IES_3            BIT3
#define  GPIOG_IESR_IES_4            BIT4
#define  GPIOG_IESR_IES_5            BIT5
#define  GPIOG_IESR_IES_6            BIT6
#define  GPIOG_IESR_IES_7            BIT7
#define  GPIOG_IESR_IES_8            BIT8
#define  GPIOG_IESR_IES_9            BIT9
#define  GPIOG_IESR_IES_10           BIT10
#define  GPIOG_IESR_IES_11           BIT11
#define  GPIOG_IESR_IES_12           BIT12
#define  GPIOG_IESR_IES_13           BIT13
#define  GPIOG_IESR_IES_14           BIT14
#define  GPIOG_IESR_IES_15           BIT15

#define  GPIOG_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Push-Pull Mode Bits
//     0b0 ==> Open Drain Mode
//     0b1 ==> Push-Pull Mode
#define  GPIOG_PPMODE_PPMODE_0       BIT0
#define  GPIOG_PPMODE_PPMODE_1       BIT1
#define  GPIOG_PPMODE_PPMODE_2       BIT2
#define  GPIOG_PPMODE_PPMODE_3       BIT3
#define  GPIOG_PPMODE_PPMODE_4       BIT4
#define  GPIOG_PPMODE_PPMODE_5       BIT5
#define  GPIOG_PPMODE_PPMODE_6       BIT6
#define  GPIOG_PPMODE_PPMODE_7       BIT7
#define  GPIOG_PPMODE_PPMODE_8       BIT8
#define  GPIOG_PPMODE_PPMODE_9       BIT9
#define  GPIOG_PPMODE_PPMODE_10      BIT10
#define  GPIOG_PPMODE_PPMODE_11      BIT11
#define  GPIOG_PPMODE_PPMODE_12      BIT12
#define  GPIOG_PPMODE_PPMODE_13      BIT13
#define  GPIOG_PPMODE_PPMODE_14      BIT14
#define  GPIOG_PPMODE_PPMODE_15      BIT15

#define  GPIOG_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Raw Data Bits
#define  GPIOG_RAWDATA_RAW_DATA_0    BIT0
#define  GPIOG_RAWDATA_RAW_DATA_1    BIT1
#define  GPIOG_RAWDATA_RAW_DATA_2    BIT2
#define  GPIOG_RAWDATA_RAW_DATA_3    BIT3
#define  GPIOG_RAWDATA_RAW_DATA_4    BIT4
#define  GPIOG_RAWDATA_RAW_DATA_5    BIT5
#define  GPIOG_RAWDATA_RAW_DATA_6    BIT6
#define  GPIOG_RAWDATA_RAW_DATA_7    BIT7
#define  GPIOG_RAWDATA_RAW_DATA_8    BIT8
#define  GPIOG_RAWDATA_RAW_DATA_9    BIT9
#define  GPIOG_RAWDATA_RAW_DATA_10   BIT10
#define  GPIOG_RAWDATA_RAW_DATA_11   BIT11
#define  GPIOG_RAWDATA_RAW_DATA_12   BIT12
#define  GPIOG_RAWDATA_RAW_DATA_13   BIT13
#define  GPIOG_RAWDATA_RAW_DATA_14   BIT14
#define  GPIOG_RAWDATA_RAW_DATA_15   BIT15

#define  GPIOG_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Drive Strength Selector Bits
//     0b0 ==> Low drive strength
//     0b1 ==> High drive strength
#define  GPIOG_DRIVE_DRIVE_0         BIT0
#define  GPIOG_DRIVE_DRIVE_1         BIT1
#define  GPIOG_DRIVE_DRIVE_2         BIT2
#define  GPIOG_DRIVE_DRIVE_3         BIT3
#define  GPIOG_DRIVE_DRIVE_4         BIT4
#define  GPIOG_DRIVE_DRIVE_5         BIT5
#define  GPIOG_DRIVE_DRIVE_6         BIT6
#define  GPIOG_DRIVE_DRIVE_7         BIT7
#define  GPIOG_DRIVE_DRIVE_8         BIT8
#define  GPIOG_DRIVE_DRIVE_9         BIT9
#define  GPIOG_DRIVE_DRIVE_10        BIT10
#define  GPIOG_DRIVE_DRIVE_11        BIT11
#define  GPIOG_DRIVE_DRIVE_12        BIT12
#define  GPIOG_DRIVE_DRIVE_13        BIT13
#define  GPIOG_DRIVE_DRIVE_14        BIT14
#define  GPIOG_DRIVE_DRIVE_15        BIT15

#define  GPIOG_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pull Resistor Type Select Bits
//     0b0 ==> Pulldown resistor
//     0b1 ==> Pullup resistor
#define  GPIOG_PUS_PUS_0             BIT0
#define  GPIOG_PUS_PUS_1             BIT1
#define  GPIOG_PUS_PUS_2             BIT2
#define  GPIOG_PUS_PUS_3             BIT3
#define  GPIOG_PUS_PUS_4             BIT4
#define  GPIOG_PUS_PUS_5             BIT5
#define  GPIOG_PUS_PUS_6             BIT6
#define  GPIOG_PUS_PUS_7             BIT7
#define  GPIOG_PUS_PUS_8             BIT8
#define  GPIOG_PUS_PUS_9             BIT9
#define  GPIOG_PUS_PUS_10            BIT10
#define  GPIOG_PUS_PUS_11            BIT11
#define  GPIOG_PUS_PUS_12            BIT12
#define  GPIOG_PUS_PUS_13            BIT13
#define  GPIOG_PUS_PUS_14            BIT14
#define  GPIOG_PUS_PUS_15            BIT15

#define  GPIOG_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Slew Rate Enable
//     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
//     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
#define  GPIOG_SRE_SRE_0             BIT0
#define  GPIOG_SRE_SRE_1             BIT1
#define  GPIOG_SRE_SRE_2             BIT2
#define  GPIOG_SRE_SRE_3             BIT3
#define  GPIOG_SRE_SRE_4             BIT4
#define  GPIOG_SRE_SRE_5             BIT5
#define  GPIOG_SRE_SRE_6             BIT6
#define  GPIOG_SRE_SRE_7             BIT7
#define  GPIOG_SRE_SRE_8             BIT8
#define  GPIOG_SRE_SRE_9             BIT9
#define  GPIOG_SRE_SRE_10            BIT10
#define  GPIOG_SRE_SRE_11            BIT11
#define  GPIOG_SRE_SRE_12            BIT12
#define  GPIOG_SRE_SRE_13            BIT13
#define  GPIOG_SRE_SRE_14            BIT14
#define  GPIOG_SRE_SRE_15            BIT15

#define  I2C0_A1_AD                  (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Address
#define  I2C0_A1_AD_0                BIT1
#define  I2C0_A1_AD_1                BIT2
#define  I2C0_A1_AD_2                BIT3
#define  I2C0_A1_AD_3                BIT4
#define  I2C0_A1_AD_4                BIT5
#define  I2C0_A1_AD_5                BIT6
#define  I2C0_A1_AD_6                BIT7

#define  I2C0_F_ICR                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   Clock rate
#define  I2C0_F_ICR_0                BIT0
#define  I2C0_F_ICR_1                BIT1
#define  I2C0_F_ICR_2                BIT2
#define  I2C0_F_ICR_3                BIT3
#define  I2C0_F_ICR_4                BIT4
#define  I2C0_F_ICR_5                BIT5

#define  I2C0_F_MULT                 (BIT6|BIT7)
//     0b00 ==> mul = 1
//     0b01 ==> mul = 2
//     0b10 ==> mul = 4
//     0b11 ==> Reserved
#define  I2C0_F_MULT_0               BIT6
#define  I2C0_F_MULT_1               BIT7

#define  I2C0_C1_DMAEN               BIT0
//   DMA enable
//     0b0 ==> All DMA signalling disabled.
//     0b1 ==> DMA transfer is enabled and the following conditions trigger the DMA request: While FACK = 0, a data byte is received, either address or data is transmitted. (ACK/NACK automatic) While FACK = 0, the first byte received matches the A1 register or is general call address. If any address matching occurs, IAAS and TCF are set. If the direction of transfer is known from master to slave, then it is not required to check the SRW. With this assumption, DMA can also be used in this
//             case. In other cases, if the master reads data from the slave, then it is required to rewrite the C1 register operation. With this assumption, DMA cannot be used. When FACK = 1, an address or a data byte is transmitted.

#define  I2C0_C1_WUEN                BIT1
//   Wakeup enable
//     0b0 ==> Normal operation. No interrupt generated when address matching in low power mode.
//     0b1 ==> Enables the wakeup function in low power mode.

#define  I2C0_C1_RSTA                BIT2
//   Repeat START

#define  I2C0_C1_TXAK                BIT3
//   Transmit acknowledge enable
//     0b0 ==> An acknowledge signal is sent to the bus on the following (if FACK is cleared) or current (if FACK is set) receiving byte.
//     0b1 ==> No acknowledge signal is sent to the bus on the following (if FACK is cleared) or current (if FACK is set) receiving data byte.SCL is held low until TXAK is written.

#define  I2C0_C1_TX                  BIT4
//   Transmit mode select
//     0b0 ==> Receive
//     0b1 ==> Transmit

#define  I2C0_C1_MST                 BIT5
//   Master mode select
//     0b0 ==> Slave mode
//     0b1 ==> Master mode

#define  I2C0_C1_IICIE               BIT6
//   I2C interrupt enable
//     0b0 ==> Disabled
//     0b1 ==> Enabled

#define  I2C0_C1_IICEN               BIT7
//   I2C enable
//     0b0 ==> Disabled
//     0b1 ==> Enabled

#define  I2C0_S_RXAK                 BIT0
//   Receive acknowledge
//     0b0 ==> Acknowledge signal was received after the completion of one byte of data transmission on the bus
//     0b1 ==> No acknowledge signal detected

#define  I2C0_S_IICIF                BIT1
//   Interrupt flag
//     0b0 ==> No interrupt pending
//     0b1 ==> Interrupt pending

#define  I2C0_S_SRW                  BIT2
//   Slave read/write
//     0b0 ==> Slave receive, master writing to slave
//     0b1 ==> Slave transmit, master reading from slave

#define  I2C0_S_RAM                  BIT3
//   Range address match
//     0b0 ==> Not addressed
//     0b1 ==> Addressed as a slave

#define  I2C0_S_ARBL                 BIT4
//   Arbitration lost
//     0b0 ==> Standard bus operation.
//     0b1 ==> Loss of arbitration.

#define  I2C0_S_BUSY                 BIT5
//   Bus busy
//     0b0 ==> Bus is idle
//     0b1 ==> Bus is busy

#define  I2C0_S_IAAS                 BIT6
//   Addressed as a slave
//     0b0 ==> Not addressed
//     0b1 ==> Addressed as a slave

#define  I2C0_S_TCF                  BIT7
//   Transfer complete flag
//     0b0 ==> Transfer in progress
//     0b1 ==> Transfer complete

#define  I2C0_D_DATA                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data
#define  I2C0_D_DATA_0               BIT0
#define  I2C0_D_DATA_1               BIT1
#define  I2C0_D_DATA_2               BIT2
#define  I2C0_D_DATA_3               BIT3
#define  I2C0_D_DATA_4               BIT4
#define  I2C0_D_DATA_5               BIT5
#define  I2C0_D_DATA_6               BIT6
#define  I2C0_D_DATA_7               BIT7

#define  I2C0_C2_AD                  (BIT0|BIT1|BIT2)
//   Slave address
#define  I2C0_C2_AD_0                BIT0
#define  I2C0_C2_AD_1                BIT1
#define  I2C0_C2_AD_2                BIT2

#define  I2C0_C2_RMEN                BIT3
//   Range address matching enable
//     0b0 ==> Range mode disabled. No address match occurs for an address within the range of values of the A1 and RA registers.
//     0b1 ==> Range mode enabled. Address matching occurs when a slave receives an address within the range of values of the A1 and RA registers.

#define  I2C0_C2_SBRC                BIT4
//   Slave baud rate control
//     0b0 ==> The slave baud rate follows the master baud rate and clock stretching may occur
//     0b1 ==> Slave baud rate is independent of the master baud rate

#define  I2C0_C2_HDRS                BIT5
//   High drive select
//     0b0 ==> Normal drive mode
//     0b1 ==> High drive mode

#define  I2C0_C2_ADEXT               BIT6
//   Address extension
//     0b0 ==> 7-bit address scheme
//     0b1 ==> 10-bit address scheme

#define  I2C0_C2_GCAEN               BIT7
//   General call address enable
//     0b0 ==> Disabled
//     0b1 ==> Enabled

#define  I2C0_FLT_FLT                (BIT0|BIT1|BIT2|BIT3|BIT4)
//   I2C programmable filter factor
//     0b0 ==> No filter/bypass
#define  I2C0_FLT_FLT_0              BIT0
#define  I2C0_FLT_FLT_1              BIT1
#define  I2C0_FLT_FLT_2              BIT2
#define  I2C0_FLT_FLT_3              BIT3
#define  I2C0_FLT_FLT_4              BIT4

#define  I2C0_FLT_SHEN               BIT7
//   Stop hold enable
//     0b0 ==> Stop holdoff is disabled. The MCU's entry to stop mode is not gated.
//     0b1 ==> Stop holdoff is enabled.

#define  I2C0_RA_RAD                 (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Range slave address
#define  I2C0_RA_RAD_0               BIT1
#define  I2C0_RA_RAD_1               BIT2
#define  I2C0_RA_RAD_2               BIT3
#define  I2C0_RA_RAD_3               BIT4
#define  I2C0_RA_RAD_4               BIT5
#define  I2C0_RA_RAD_5               BIT6
#define  I2C0_RA_RAD_6               BIT7

#define  I2C0_SMB_SHTF2IE            BIT0
//   SHTF2 interrupt enable
//     0b0 ==> SHTF2 interrupt is disabled
//     0b1 ==> SHTF2 interrupt is enabled

#define  I2C0_SMB_SHTF2              BIT1
//   SCL high timeout flag 2
//     0b0 ==> No SCL high and SDA low timeout occurs
//     0b1 ==> SCL high and SDA low timeout occurs

#define  I2C0_SMB_SHTF1              BIT2
//   SCL high timeout flag 1
//     0b0 ==> No SCL high and SDA high timeout occurs
//     0b1 ==> SCL high and SDA high timeout occurs

#define  I2C0_SMB_SLTF               BIT3
//   SCL low timeout flag
//     0b0 ==> No low timeout occurs
//     0b1 ==> Low timeout occurs

#define  I2C0_SMB_TCKSEL             BIT4
//   Timeout counter clock select
//     0b0 ==> Timeout counter counts at the frequency of the bus clock / 64
//     0b1 ==> Timeout counter counts at the frequency of the bus clock

#define  I2C0_SMB_SIICAEN            BIT5
//   Second I2C address enable
//     0b0 ==> I2C address register 2 matching is disabled
//     0b1 ==> I2C address register 2 matching is enabled

#define  I2C0_SMB_ALERTEN            BIT6
//   SMBus alert response address enable
//     0b0 ==> SMBus alert response address matching is disabled
//     0b1 ==> SMBus alert response address matching is enabled

#define  I2C0_SMB_FACK               BIT7
//   Fast NACK/ACK enable
//     0b0 ==> An ACK or NACK is sent on the following receiving data byte
//     0b1 ==> Writing 0 to TXAK after receiving a data byte generates an ACK. Writing 1 to TXAK after receiving a data byte generates a NACK.

#define  I2C0_A2_SAD                 (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   SMBus address
#define  I2C0_A2_SAD_0               BIT1
#define  I2C0_A2_SAD_1               BIT2
#define  I2C0_A2_SAD_2               BIT3
#define  I2C0_A2_SAD_3               BIT4
#define  I2C0_A2_SAD_4               BIT5
#define  I2C0_A2_SAD_5               BIT6
#define  I2C0_A2_SAD_6               BIT7

#define  I2C0_SLTH_SSLT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  I2C0_SLTH_SSLT_0            BIT0
#define  I2C0_SLTH_SSLT_1            BIT1
#define  I2C0_SLTH_SSLT_2            BIT2
#define  I2C0_SLTH_SSLT_3            BIT3
#define  I2C0_SLTH_SSLT_4            BIT4
#define  I2C0_SLTH_SSLT_5            BIT5
#define  I2C0_SLTH_SSLT_6            BIT6
#define  I2C0_SLTH_SSLT_7            BIT7

#define  I2C0_SLTL_SSLT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  I2C0_SLTL_SSLT_0            BIT0
#define  I2C0_SLTL_SSLT_1            BIT1
#define  I2C0_SLTL_SSLT_2            BIT2
#define  I2C0_SLTL_SSLT_3            BIT3
#define  I2C0_SLTL_SSLT_4            BIT4
#define  I2C0_SLTL_SSLT_5            BIT5
#define  I2C0_SLTL_SSLT_6            BIT6
#define  I2C0_SLTL_SSLT_7            BIT7

#define  I2C1_A1_AD                  (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Address
#define  I2C1_A1_AD_0                BIT1
#define  I2C1_A1_AD_1                BIT2
#define  I2C1_A1_AD_2                BIT3
#define  I2C1_A1_AD_3                BIT4
#define  I2C1_A1_AD_4                BIT5
#define  I2C1_A1_AD_5                BIT6
#define  I2C1_A1_AD_6                BIT7

#define  I2C1_F_ICR                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   Clock rate
#define  I2C1_F_ICR_0                BIT0
#define  I2C1_F_ICR_1                BIT1
#define  I2C1_F_ICR_2                BIT2
#define  I2C1_F_ICR_3                BIT3
#define  I2C1_F_ICR_4                BIT4
#define  I2C1_F_ICR_5                BIT5

#define  I2C1_F_MULT                 (BIT6|BIT7)
//     0b00 ==> mul = 1
//     0b01 ==> mul = 2
//     0b10 ==> mul = 4
//     0b11 ==> Reserved
#define  I2C1_F_MULT_0               BIT6
#define  I2C1_F_MULT_1               BIT7

#define  I2C1_C1_DMAEN               BIT0
//   DMA enable
//     0b0 ==> All DMA signalling disabled.
//     0b1 ==> DMA transfer is enabled and the following conditions trigger the DMA request: While FACK = 0, a data byte is received, either address or data is transmitted. (ACK/NACK automatic) While FACK = 0, the first byte received matches the A1 register or is general call address. If any address matching occurs, IAAS and TCF are set. If the direction of transfer is known from master to slave, then it is not required to check the SRW. With this assumption, DMA can also be used in this
//             case. In other cases, if the master reads data from the slave, then it is required to rewrite the C1 register operation. With this assumption, DMA cannot be used. When FACK = 1, an address or a data byte is transmitted.

#define  I2C1_C1_WUEN                BIT1
//   Wakeup enable
//     0b0 ==> Normal operation. No interrupt generated when address matching in low power mode.
//     0b1 ==> Enables the wakeup function in low power mode.

#define  I2C1_C1_RSTA                BIT2
//   Repeat START

#define  I2C1_C1_TXAK                BIT3
//   Transmit acknowledge enable
//     0b0 ==> An acknowledge signal is sent to the bus on the following (if FACK is cleared) or current (if FACK is set) receiving byte.
//     0b1 ==> No acknowledge signal is sent to the bus on the following (if FACK is cleared) or current (if FACK is set) receiving data byte.SCL is held low until TXAK is written.

#define  I2C1_C1_TX                  BIT4
//   Transmit mode select
//     0b0 ==> Receive
//     0b1 ==> Transmit

#define  I2C1_C1_MST                 BIT5
//   Master mode select
//     0b0 ==> Slave mode
//     0b1 ==> Master mode

#define  I2C1_C1_IICIE               BIT6
//   I2C interrupt enable
//     0b0 ==> Disabled
//     0b1 ==> Enabled

#define  I2C1_C1_IICEN               BIT7
//   I2C enable
//     0b0 ==> Disabled
//     0b1 ==> Enabled

#define  I2C1_S_RXAK                 BIT0
//   Receive acknowledge
//     0b0 ==> Acknowledge signal was received after the completion of one byte of data transmission on the bus
//     0b1 ==> No acknowledge signal detected

#define  I2C1_S_IICIF                BIT1
//   Interrupt flag
//     0b0 ==> No interrupt pending
//     0b1 ==> Interrupt pending

#define  I2C1_S_SRW                  BIT2
//   Slave read/write
//     0b0 ==> Slave receive, master writing to slave
//     0b1 ==> Slave transmit, master reading from slave

#define  I2C1_S_RAM                  BIT3
//   Range address match
//     0b0 ==> Not addressed
//     0b1 ==> Addressed as a slave

#define  I2C1_S_ARBL                 BIT4
//   Arbitration lost
//     0b0 ==> Standard bus operation.
//     0b1 ==> Loss of arbitration.

#define  I2C1_S_BUSY                 BIT5
//   Bus busy
//     0b0 ==> Bus is idle
//     0b1 ==> Bus is busy

#define  I2C1_S_IAAS                 BIT6
//   Addressed as a slave
//     0b0 ==> Not addressed
//     0b1 ==> Addressed as a slave

#define  I2C1_S_TCF                  BIT7
//   Transfer complete flag
//     0b0 ==> Transfer in progress
//     0b1 ==> Transfer complete

#define  I2C1_D_DATA                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Data
#define  I2C1_D_DATA_0               BIT0
#define  I2C1_D_DATA_1               BIT1
#define  I2C1_D_DATA_2               BIT2
#define  I2C1_D_DATA_3               BIT3
#define  I2C1_D_DATA_4               BIT4
#define  I2C1_D_DATA_5               BIT5
#define  I2C1_D_DATA_6               BIT6
#define  I2C1_D_DATA_7               BIT7

#define  I2C1_C2_AD                  (BIT0|BIT1|BIT2)
//   Slave address
#define  I2C1_C2_AD_0                BIT0
#define  I2C1_C2_AD_1                BIT1
#define  I2C1_C2_AD_2                BIT2

#define  I2C1_C2_RMEN                BIT3
//   Range address matching enable
//     0b0 ==> Range mode disabled. No address match occurs for an address within the range of values of the A1 and RA registers.
//     0b1 ==> Range mode enabled. Address matching occurs when a slave receives an address within the range of values of the A1 and RA registers.

#define  I2C1_C2_SBRC                BIT4
//   Slave baud rate control
//     0b0 ==> The slave baud rate follows the master baud rate and clock stretching may occur
//     0b1 ==> Slave baud rate is independent of the master baud rate

#define  I2C1_C2_HDRS                BIT5
//   High drive select
//     0b0 ==> Normal drive mode
//     0b1 ==> High drive mode

#define  I2C1_C2_ADEXT               BIT6
//   Address extension
//     0b0 ==> 7-bit address scheme
//     0b1 ==> 10-bit address scheme

#define  I2C1_C2_GCAEN               BIT7
//   General call address enable
//     0b0 ==> Disabled
//     0b1 ==> Enabled

#define  I2C1_FLT_FLT                (BIT0|BIT1|BIT2|BIT3|BIT4)
//   I2C programmable filter factor
//     0b0 ==> No filter/bypass
#define  I2C1_FLT_FLT_0              BIT0
#define  I2C1_FLT_FLT_1              BIT1
#define  I2C1_FLT_FLT_2              BIT2
#define  I2C1_FLT_FLT_3              BIT3
#define  I2C1_FLT_FLT_4              BIT4

#define  I2C1_FLT_SHEN               BIT7
//   Stop hold enable
//     0b0 ==> Stop holdoff is disabled. The MCU's entry to stop mode is not gated.
//     0b1 ==> Stop holdoff is enabled.

#define  I2C1_RA_RAD                 (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Range slave address
#define  I2C1_RA_RAD_0               BIT1
#define  I2C1_RA_RAD_1               BIT2
#define  I2C1_RA_RAD_2               BIT3
#define  I2C1_RA_RAD_3               BIT4
#define  I2C1_RA_RAD_4               BIT5
#define  I2C1_RA_RAD_5               BIT6
#define  I2C1_RA_RAD_6               BIT7

#define  I2C1_SMB_SHTF2IE            BIT0
//   SHTF2 interrupt enable
//     0b0 ==> SHTF2 interrupt is disabled
//     0b1 ==> SHTF2 interrupt is enabled

#define  I2C1_SMB_SHTF2              BIT1
//   SCL high timeout flag 2
//     0b0 ==> No SCL high and SDA low timeout occurs
//     0b1 ==> SCL high and SDA low timeout occurs

#define  I2C1_SMB_SHTF1              BIT2
//   SCL high timeout flag 1
//     0b0 ==> No SCL high and SDA high timeout occurs
//     0b1 ==> SCL high and SDA high timeout occurs

#define  I2C1_SMB_SLTF               BIT3
//   SCL low timeout flag
//     0b0 ==> No low timeout occurs
//     0b1 ==> Low timeout occurs

#define  I2C1_SMB_TCKSEL             BIT4
//   Timeout counter clock select
//     0b0 ==> Timeout counter counts at the frequency of the bus clock / 64
//     0b1 ==> Timeout counter counts at the frequency of the bus clock

#define  I2C1_SMB_SIICAEN            BIT5
//   Second I2C address enable
//     0b0 ==> I2C address register 2 matching is disabled
//     0b1 ==> I2C address register 2 matching is enabled

#define  I2C1_SMB_ALERTEN            BIT6
//   SMBus alert response address enable
//     0b0 ==> SMBus alert response address matching is disabled
//     0b1 ==> SMBus alert response address matching is enabled

#define  I2C1_SMB_FACK               BIT7
//   Fast NACK/ACK enable
//     0b0 ==> An ACK or NACK is sent on the following receiving data byte
//     0b1 ==> Writing 0 to TXAK after receiving a data byte generates an ACK. Writing 1 to TXAK after receiving a data byte generates a NACK.

#define  I2C1_A2_SAD                 (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   SMBus address
#define  I2C1_A2_SAD_0               BIT1
#define  I2C1_A2_SAD_1               BIT2
#define  I2C1_A2_SAD_2               BIT3
#define  I2C1_A2_SAD_3               BIT4
#define  I2C1_A2_SAD_4               BIT5
#define  I2C1_A2_SAD_5               BIT6
#define  I2C1_A2_SAD_6               BIT7

#define  I2C1_SLTH_SSLT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  I2C1_SLTH_SSLT_0            BIT0
#define  I2C1_SLTH_SSLT_1            BIT1
#define  I2C1_SLTH_SSLT_2            BIT2
#define  I2C1_SLTH_SSLT_3            BIT3
#define  I2C1_SLTH_SSLT_4            BIT4
#define  I2C1_SLTH_SSLT_5            BIT5
#define  I2C1_SLTH_SSLT_6            BIT6
#define  I2C1_SLTH_SSLT_7            BIT7

#define  I2C1_SLTL_SSLT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
#define  I2C1_SLTL_SSLT_0            BIT0
#define  I2C1_SLTL_SSLT_1            BIT1
#define  I2C1_SLTL_SSLT_2            BIT2
#define  I2C1_SLTL_SSLT_3            BIT3
#define  I2C1_SLTL_SSLT_4            BIT4
#define  I2C1_SLTL_SSLT_5            BIT5
#define  I2C1_SLTL_SSLT_6            BIT6
#define  I2C1_SLTL_SSLT_7            BIT7

#define  INTC_IPR0_STPCNT            (BIT0|BIT1)
//   EOnCE Step Counter Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR0_STPCNT_0          BIT0
#define  INTC_IPR0_STPCNT_1          BIT1

#define  INTC_IPR0_BKPT              (BIT2|BIT3)
//   EOnCE Breakpoint Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR0_BKPT_0            BIT2
#define  INTC_IPR0_BKPT_1            BIT3

#define  INTC_IPR0_TRBUF             (BIT4|BIT5)
//   EOnCE Trace Buffer Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR0_TRBUF_0           BIT4
#define  INTC_IPR0_TRBUF_1           BIT5

#define  INTC_IPR0_TX_REG            (BIT6|BIT7)
//   EOnCE Transmit Register Empty Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR0_TX_REG_0          BIT6
#define  INTC_IPR0_TX_REG_1          BIT7

#define  INTC_IPR0_RX_REG            (BIT8|BIT9)
//   EOnCE Receive Register Full Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR0_RX_REG_0          BIT8
#define  INTC_IPR0_RX_REG_1          BIT9

#define  INTC_IPR0_BUS_ERR           (BIT10|BIT11)
//   Bus Error Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR0_BUS_ERR_0         BIT10
#define  INTC_IPR0_BUS_ERR_1         BIT11

#define  INTC_IPR1_XBARA             (BIT2|BIT3)
//   Inter-Peripheral Crossbar Switch A (XBARA) Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR1_XBARA_0           BIT2
#define  INTC_IPR1_XBARA_1           BIT3

#define  INTC_IPR1_LVI1              (BIT4|BIT5)
//   Low Voltage Detector Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR1_LVI1_0            BIT4
#define  INTC_IPR1_LVI1_1            BIT5

#define  INTC_IPR1_OCCS              (BIT6|BIT7)
//   PLL Loss of Reference or Change in Lock Status Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 1
//     0b10 ==> IRQ Priority Level 2
//     0b11 ==> IRQ Priority Level 3
#define  INTC_IPR1_OCCS_0            BIT6
#define  INTC_IPR1_OCCS_1            BIT7

#define  INTC_IPR1_TMRB_3            (BIT8|BIT9)
//   Timer B Channel 3 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR1_TMRB_3_0          BIT8
#define  INTC_IPR1_TMRB_3_1          BIT9

#define  INTC_IPR1_TMRB_2            (BIT10|BIT11)
//   Timer B Channel 2 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR1_TMRB_2_0          BIT10
#define  INTC_IPR1_TMRB_2_1          BIT11

#define  INTC_IPR1_TMRB_1            (BIT12|BIT13)
//   Timer B Channel 1 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR1_TMRB_1_0          BIT12
#define  INTC_IPR1_TMRB_1_1          BIT13

#define  INTC_IPR1_TMRB_0            (BIT14|BIT15)
//   Timer B Channel 0 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR1_TMRB_0_0          BIT14
#define  INTC_IPR1_TMRB_0_1          BIT15

#define  INTC_IPR2_TMRA_3            (BIT0|BIT1)
//   Timer A Channel 3 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR2_TMRA_3_0          BIT0
#define  INTC_IPR2_TMRA_3_1          BIT1

#define  INTC_IPR2_TMRA_2            (BIT2|BIT3)
//   Timer A Channel 2 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR2_TMRA_2_0          BIT2
#define  INTC_IPR2_TMRA_2_1          BIT3

#define  INTC_IPR2_TMRA_1            (BIT4|BIT5)
//   Timer A Channel 1 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR2_TMRA_1_0          BIT4
#define  INTC_IPR2_TMRA_1_1          BIT5

#define  INTC_IPR2_TMRA_0            (BIT6|BIT7)
//   Timer A Channel 0 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR2_TMRA_0_0          BIT6
#define  INTC_IPR2_TMRA_0_1          BIT7

#define  INTC_IPR2_ADC_CC1           (BIT8|BIT9)
//   ADC_CYC Conversion Complete Interrupt Priority Level (converter B in non-simultaneous parallel scan mode)
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR2_ADC_CC1_0         BIT8
#define  INTC_IPR2_ADC_CC1_1         BIT9

#define  INTC_IPR2_ADC_CC0           (BIT10|BIT11)
//   ADC_CYC Conversion Complete Interrupt Priority Level (any scan type except converter B in non-simultaneous parallel scan mode)
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR2_ADC_CC0_0         BIT10
#define  INTC_IPR2_ADC_CC0_1         BIT11

#define  INTC_IPR2_ADC_ERR           (BIT12|BIT13)
//   ADC_CYC Zero Crossing, High Limit, or Low Limit Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR2_ADC_ERR_0         BIT12
#define  INTC_IPR2_ADC_ERR_1         BIT13

#define  INTC_IPR2_ADC_COCO          (BIT14|BIT15)
//   ADC_SAR Conversion Complete Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR2_ADC_COCO_0        BIT14
#define  INTC_IPR2_ADC_COCO_1        BIT15

#define  INTC_IPR3_DMACH3            (BIT0|BIT1)
//   DMA Channel 3 Service Request Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR3_DMACH3_0          BIT0
#define  INTC_IPR3_DMACH3_1          BIT1

#define  INTC_IPR3_DMACH2            (BIT2|BIT3)
//   DMA Channel 2 Service Request Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR3_DMACH2_0          BIT2
#define  INTC_IPR3_DMACH2_1          BIT3

#define  INTC_IPR3_DMACH1            (BIT4|BIT5)
//   DMA Channel 1 Service Request Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR3_DMACH1_0          BIT4
#define  INTC_IPR3_DMACH1_1          BIT5

#define  INTC_IPR3_DMACH0            (BIT6|BIT7)
//   DMA Channel 0 Service Request Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR3_DMACH0_0          BIT6
#define  INTC_IPR3_DMACH0_1          BIT7

#define  INTC_IPR3_CAN_MB_OR         (BIT8|BIT9)
//   CAN Message Buffer Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR3_CAN_MB_OR_0       BIT8
#define  INTC_IPR3_CAN_MB_OR_1       BIT9

#define  INTC_IPR3_CAN_BUS_OFF       (BIT10|BIT11)
//   CAN Bus Off Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR3_CAN_BUS_OFF_0     BIT10
#define  INTC_IPR3_CAN_BUS_OFF_1     BIT11

#define  INTC_IPR3_CAN_ERROR         (BIT12|BIT13)
//   CAN Error Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR3_CAN_ERROR_0       BIT12
#define  INTC_IPR3_CAN_ERROR_1       BIT13

#define  INTC_IPR3_CAN_TX_WARN       (BIT14|BIT15)
//   CAN Transmit Warning Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR3_CAN_TX_WARN_0     BIT14
#define  INTC_IPR3_CAN_TX_WARN_1     BIT15

#define  INTC_IPR4_CAN_RX_WARN       (BIT0|BIT1)
//   CAN Receive Warning Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR4_CAN_RX_WARN_0     BIT0
#define  INTC_IPR4_CAN_RX_WARN_1     BIT1

#define  INTC_IPR4_CAN_WAKEUP        (BIT2|BIT3)
//   CAN Wakeup Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR4_CAN_WAKEUP_0      BIT2
#define  INTC_IPR4_CAN_WAKEUP_1      BIT3

#define  INTC_IPR4_QSCI2_RERR        (BIT4|BIT5)
//   QSCI 2 Receiver Error Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR4_QSCI2_RERR_0      BIT4
#define  INTC_IPR4_QSCI2_RERR_1      BIT5

#define  INTC_IPR4_QSCI2_RCV         (BIT6|BIT7)
//   QSCI 2 Receive Data Register Full Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR4_QSCI2_RCV_0       BIT6
#define  INTC_IPR4_QSCI2_RCV_1       BIT7

#define  INTC_IPR4_QSCI2_TIDLE       (BIT8|BIT9)
//   QSCI 2 Transmitter Idle Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR4_QSCI2_TIDLE_0     BIT8
#define  INTC_IPR4_QSCI2_TIDLE_1     BIT9

#define  INTC_IPR4_QSCI2_TDRE        (BIT10|BIT11)
//   QSCI 2 Transmit Data Register Empty Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR4_QSCI2_TDRE_0      BIT10
#define  INTC_IPR4_QSCI2_TDRE_1      BIT11

#define  INTC_IPR4_QSCI1_RERR        (BIT12|BIT13)
//   QSCI 1 Receiver Error Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR4_QSCI1_RERR_0      BIT12
#define  INTC_IPR4_QSCI1_RERR_1      BIT13

#define  INTC_IPR4_QSCI1_RCV         (BIT14|BIT15)
//   QSCI 1 Receive Data Register Full Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR4_QSCI1_RCV_0       BIT14
#define  INTC_IPR4_QSCI1_RCV_1       BIT15

#define  INTC_IPR5_QSCI1_TIDLE       (BIT0|BIT1)
//   QSCI 1 Transmitter Idle Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR5_QSCI1_TIDLE_0     BIT0
#define  INTC_IPR5_QSCI1_TIDLE_1     BIT1

#define  INTC_IPR5_QSCI1_TDRE        (BIT2|BIT3)
//   QSCI 1 Transmit Data Register Empty Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR5_QSCI1_TDRE_0      BIT2
#define  INTC_IPR5_QSCI1_TDRE_1      BIT3

#define  INTC_IPR5_QSCI0_RERR        (BIT4|BIT5)
//   QSCI0 Receiver Error Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR5_QSCI0_RERR_0      BIT4
#define  INTC_IPR5_QSCI0_RERR_1      BIT5

#define  INTC_IPR5_QSCI0_RCV         (BIT6|BIT7)
//   QSCI 0 Receive Data Register Full Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR5_QSCI0_RCV_0       BIT6
#define  INTC_IPR5_QSCI0_RCV_1       BIT7

#define  INTC_IPR5_QSCI0_TIDLE       (BIT8|BIT9)
//   QSCI 0 Transmitter Idle Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR5_QSCI0_TIDLE_0     BIT8
#define  INTC_IPR5_QSCI0_TIDLE_1     BIT9

#define  INTC_IPR5_QSCI0_TDRE        (BIT10|BIT11)
//   QSCI 0 Transmit Data Register Empty Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR5_QSCI0_TDRE_0      BIT10
#define  INTC_IPR5_QSCI0_TDRE_1      BIT11

#define  INTC_IPR5_QSPI2_XMIT        (BIT12|BIT13)
//   QSPI2 Transmitter Empty Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR5_QSPI2_XMIT_0      BIT12
#define  INTC_IPR5_QSPI2_XMIT_1      BIT13

#define  INTC_IPR5_QSPI2_RCV         (BIT14|BIT15)
//   QSPI2 Receiver Full Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR5_QSPI2_RCV_0       BIT14
#define  INTC_IPR5_QSPI2_RCV_1       BIT15

#define  INTC_IPR6_QSPI1_XMIT        (BIT0|BIT1)
//   QSPI1 Transmitter Empty Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR6_QSPI1_XMIT_0      BIT0
#define  INTC_IPR6_QSPI1_XMIT_1      BIT1

#define  INTC_IPR6_QSPI1_RCV         (BIT2|BIT3)
//   QSPI1 Receiver Full Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR6_QSPI1_RCV_0       BIT2
#define  INTC_IPR6_QSPI1_RCV_1       BIT3

#define  INTC_IPR6_QSPI0_XMIT        (BIT4|BIT5)
//   QSPI0 Transmitter Empty Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR6_QSPI0_XMIT_0      BIT4
#define  INTC_IPR6_QSPI0_XMIT_1      BIT5

#define  INTC_IPR6_QSPI0_RCV         (BIT6|BIT7)
//   QSPI0 Receiver Full Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR6_QSPI0_RCV_0       BIT6
#define  INTC_IPR6_QSPI0_RCV_1       BIT7

#define  INTC_IPR6_IIC1              (BIT8|BIT9)
//   IIC1 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR6_IIC1_0            BIT8
#define  INTC_IPR6_IIC1_1            BIT9

#define  INTC_IPR6_IIC0              (BIT10|BIT11)
//   IIC0 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR6_IIC0_0            BIT10
#define  INTC_IPR6_IIC0_1            BIT11

#define  INTC_IPR6_PWMB_FAULT        (BIT12|BIT13)
//   PWMB Fault Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR6_PWMB_FAULT_0      BIT12
#define  INTC_IPR6_PWMB_FAULT_1      BIT13

#define  INTC_IPR6_PWMB_RERR         (BIT14|BIT15)
//   PWMB Reload Error Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR6_PWMB_RERR_0       BIT14
#define  INTC_IPR6_PWMB_RERR_1       BIT15

#define  INTC_IPR7_PWMB_RELOAD3      (BIT0|BIT1)
//   PWMB Submodule 3 Reload Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR7_PWMB_RELOAD3_0    BIT0
#define  INTC_IPR7_PWMB_RELOAD3_1    BIT1

#define  INTC_IPR7_PWMB_CAP3         (BIT2|BIT3)
//   PWMB Submodule 3 Capture Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR7_PWMB_CAP3_0       BIT2
#define  INTC_IPR7_PWMB_CAP3_1       BIT3

#define  INTC_IPR7_PWMB_CMP3         (BIT4|BIT5)
//   PWMB Submodule 3 Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR7_PWMB_CMP3_0       BIT4
#define  INTC_IPR7_PWMB_CMP3_1       BIT5

#define  INTC_IPR7_PWMB_RELOAD2      (BIT6|BIT7)
//   PWMB Submodule 2 Reload Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR7_PWMB_RELOAD2_0    BIT6
#define  INTC_IPR7_PWMB_RELOAD2_1    BIT7

#define  INTC_IPR7_PWMB_CAP2         (BIT8|BIT9)
//   PWMB Submodule 2 Capture Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR7_PWMB_CAP2_0       BIT8
#define  INTC_IPR7_PWMB_CAP2_1       BIT9

#define  INTC_IPR7_PWMB_CMP2         (BIT10|BIT11)
//   PWMB Submodule 2 Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR7_PWMB_CMP2_0       BIT10
#define  INTC_IPR7_PWMB_CMP2_1       BIT11

#define  INTC_IPR7_PWMB_RELOAD1      (BIT12|BIT13)
//   PWMB Submodule 1 Reload Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR7_PWMB_RELOAD1_0    BIT12
#define  INTC_IPR7_PWMB_RELOAD1_1    BIT13

#define  INTC_IPR7_PWMB_CAP1         (BIT14|BIT15)
//   PWMB Submodule 1 Capture Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR7_PWMB_CAP1_0       BIT14
#define  INTC_IPR7_PWMB_CAP1_1       BIT15

#define  INTC_IPR8_PWMB_CMP1         (BIT0|BIT1)
//   PWMB Submodule 1 Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR8_PWMB_CMP1_0       BIT0
#define  INTC_IPR8_PWMB_CMP1_1       BIT1

#define  INTC_IPR8_PWMB_RELOAD0      (BIT2|BIT3)
//   PWMB Submodule 0 Reload Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR8_PWMB_RELOAD0_0    BIT2
#define  INTC_IPR8_PWMB_RELOAD0_1    BIT3

#define  INTC_IPR8_PWMB_CAP0         (BIT4|BIT5)
//   PWMB Submodule 0 Capture Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR8_PWMB_CAP0_0       BIT4
#define  INTC_IPR8_PWMB_CAP0_1       BIT5

#define  INTC_IPR8_PWMB_CMP0         (BIT6|BIT7)
//   PWMB Submodule 0 Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR8_PWMB_CMP0_0       BIT6
#define  INTC_IPR8_PWMB_CMP0_1       BIT7

#define  INTC_IPR8_PWMA_FAULT        (BIT8|BIT9)
//   PWMA Fault Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR8_PWMA_FAULT_0      BIT8
#define  INTC_IPR8_PWMA_FAULT_1      BIT9

#define  INTC_IPR8_PWMA_RERR         (BIT10|BIT11)
//   PWMA Reload Error Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR8_PWMA_RERR_0       BIT10
#define  INTC_IPR8_PWMA_RERR_1       BIT11

#define  INTC_IPR8_PWMA_RELOAD3      (BIT12|BIT13)
//   PWMA Submodule 3 Reload Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR8_PWMA_RELOAD3_0    BIT12
#define  INTC_IPR8_PWMA_RELOAD3_1    BIT13

#define  INTC_IPR8_PWMA_CAP          (BIT14|BIT15)
//   PWMA Submodule Capture Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR8_PWMA_CAP_0        BIT14
#define  INTC_IPR8_PWMA_CAP_1        BIT15

#define  INTC_IPR9_PWMA_CMP3         (BIT0|BIT1)
//   PWMA Submodule 3 Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR9_PWMA_CMP3_0       BIT0
#define  INTC_IPR9_PWMA_CMP3_1       BIT1

#define  INTC_IPR9_PWMA_RELOAD2      (BIT2|BIT3)
//   PWMA Submodule 2 Reload Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR9_PWMA_RELOAD2_0    BIT2
#define  INTC_IPR9_PWMA_RELOAD2_1    BIT3

#define  INTC_IPR9_PWMA_CMP2         (BIT4|BIT5)
//   PWMA Submodule 2 Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR9_PWMA_CMP2_0       BIT4
#define  INTC_IPR9_PWMA_CMP2_1       BIT5

#define  INTC_IPR9_PWMA_RELOAD1      (BIT6|BIT7)
//   PWMA Submodule 1 Reload Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR9_PWMA_RELOAD1_0    BIT6
#define  INTC_IPR9_PWMA_RELOAD1_1    BIT7

#define  INTC_IPR9_PWMA_CMP1         (BIT8|BIT9)
//   PWMA Submodule 1 Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR9_PWMA_CMP1_0       BIT8
#define  INTC_IPR9_PWMA_CMP1_1       BIT9

#define  INTC_IPR9_PWMA_RELOAD0      (BIT10|BIT11)
//   PWMA Submodule 0 Reload Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR9_PWMA_RELOAD0_0    BIT10
#define  INTC_IPR9_PWMA_RELOAD0_1    BIT11

#define  INTC_IPR9_PWMA_CMP0         (BIT12|BIT13)
//   PWMA Submodule 0 Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR9_PWMA_CMP0_0       BIT12
#define  INTC_IPR9_PWMA_CMP0_1       BIT13

#define  INTC_IPR9_FTFL_RDCOL        (BIT14|BIT15)
//   FTFL Access Error Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR9_FTFL_RDCOL_0      BIT14
#define  INTC_IPR9_FTFL_RDCOL_1      BIT15

#define  INTC_IPR10_FTFL_CC          (BIT0|BIT1)
//   FTFL Command Complete Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR10_FTFL_CC_0        BIT0
#define  INTC_IPR10_FTFL_CC_1        BIT1

#define  INTC_IPR10_CMPD             (BIT2|BIT3)
//   Comparator D Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR10_CMPD_0           BIT2
#define  INTC_IPR10_CMPD_1           BIT3

#define  INTC_IPR10_CMPC             (BIT4|BIT5)
//   Comparator C Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR10_CMPC_0           BIT4
#define  INTC_IPR10_CMPC_1           BIT5

#define  INTC_IPR10_CMPB             (BIT6|BIT7)
//   Comparator B Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR10_CMPB_0           BIT6
#define  INTC_IPR10_CMPB_1           BIT7

#define  INTC_IPR10_CMPA             (BIT8|BIT9)
//   Comparator A Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR10_CMPA_0           BIT8
#define  INTC_IPR10_CMPA_1           BIT9

#define  INTC_IPR10_PIT1_ROLLOVR     (BIT10|BIT11)
//   PIT1 Roll Over Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR10_PIT1_ROLLOVR_0   BIT10
#define  INTC_IPR10_PIT1_ROLLOVR_1   BIT11

#define  INTC_IPR10_PIT0_ROLLOVR     (BIT12|BIT13)
//   PIT0 Roll Over Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR10_PIT0_ROLLOVR_0   BIT12
#define  INTC_IPR10_PIT0_ROLLOVR_1   BIT13

#define  INTC_IPR10_PDB1             (BIT14|BIT15)
//   PDB1 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR10_PDB1_0           BIT14
#define  INTC_IPR10_PDB1_1           BIT15

#define  INTC_IPR11_PDB0             (BIT0|BIT1)
//   PDB0 Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR11_PDB0_0           BIT0
#define  INTC_IPR11_PDB0_1           BIT1

#define  INTC_IPR11_ENC_INDEX        (BIT2|BIT3)
//   Quad Decoder Index Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR11_ENC_INDEX_0      BIT2
#define  INTC_IPR11_ENC_INDEX_1      BIT3

#define  INTC_IPR11_ENC_HOME_DOG     (BIT4|BIT5)
//   Quad Decoder Home/Watchdog Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR11_ENC_HOME_DOG_0   BIT4
#define  INTC_IPR11_ENC_HOME_DOG_1   BIT5

#define  INTC_IPR11_ENC_COMPARE      (BIT6|BIT7)
//   Quad Decoder Compare Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR11_ENC_COMPARE_0    BIT6
#define  INTC_IPR11_ENC_COMPARE_1    BIT7

#define  INTC_IPR11_GPIOG            (BIT8|BIT9)
//   GPIO G Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR11_GPIOG_0          BIT8
#define  INTC_IPR11_GPIOG_1          BIT9

#define  INTC_IPR11_GPIOF            (BIT10|BIT11)
//   GPIO F Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR11_GPIOF_0          BIT10
#define  INTC_IPR11_GPIOF_1          BIT11

#define  INTC_IPR11_GPIOE            (BIT12|BIT13)
//   GPIO E Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR11_GPIOE_0          BIT12
#define  INTC_IPR11_GPIOE_1          BIT13

#define  INTC_IPR11_GPIOD            (BIT14|BIT15)
//   GPIO D Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR11_GPIOD_0          BIT14
#define  INTC_IPR11_GPIOD_1          BIT15

#define  INTC_IPR12_GPIOC            (BIT0|BIT1)
//   GPIO C Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR12_GPIOC_0          BIT0
#define  INTC_IPR12_GPIOC_1          BIT1

#define  INTC_IPR12_GPIOB            (BIT2|BIT3)
//   GPIO B Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR12_GPIOB_0          BIT2
#define  INTC_IPR12_GPIOB_1          BIT3

#define  INTC_IPR12_GPIOA            (BIT4|BIT5)
//   GPIO A Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR12_GPIOA_0          BIT4
#define  INTC_IPR12_GPIOA_1          BIT5

#define  INTC_IPR12_COP_INT          (BIT6|BIT7)
//   COP Watchdog Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR12_COP_INT_0        BIT6
#define  INTC_IPR12_COP_INT_1        BIT7

#define  INTC_IPR12_EWM_INT          (BIT8|BIT9)
//   External Watchdog Monitor Interrupt Priority Level
//     0b00 ==> IRQ disabled (default)
//     0b01 ==> IRQ Priority Level 0
//     0b10 ==> IRQ Priority Level 1
//     0b11 ==> IRQ Priority Level 2
#define  INTC_IPR12_EWM_INT_0        BIT8
#define  INTC_IPR12_EWM_INT_1        BIT9

#define  INTC_VBA_VECTOR_BASE_ADDRESS (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12)
//   Interrupt Vector Base Address
#define  INTC_VBA_VECTOR_BASE_ADDRESS_0 BIT0
#define  INTC_VBA_VECTOR_BASE_ADDRESS_1 BIT1
#define  INTC_VBA_VECTOR_BASE_ADDRESS_2 BIT2
#define  INTC_VBA_VECTOR_BASE_ADDRESS_3 BIT3
#define  INTC_VBA_VECTOR_BASE_ADDRESS_4 BIT4
#define  INTC_VBA_VECTOR_BASE_ADDRESS_5 BIT5
#define  INTC_VBA_VECTOR_BASE_ADDRESS_6 BIT6
#define  INTC_VBA_VECTOR_BASE_ADDRESS_7 BIT7
#define  INTC_VBA_VECTOR_BASE_ADDRESS_8 BIT8
#define  INTC_VBA_VECTOR_BASE_ADDRESS_9 BIT9
#define  INTC_VBA_VECTOR_BASE_ADDRESS_10 BIT10
#define  INTC_VBA_VECTOR_BASE_ADDRESS_11 BIT11
#define  INTC_VBA_VECTOR_BASE_ADDRESS_12 BIT12

#define  INTC_FIM0_FAST_INTERRUPT_0  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
//   Fast Interrupt 0 Vector Number
#define  INTC_FIM0_FAST_INTERRUPT_0_0 BIT0
#define  INTC_FIM0_FAST_INTERRUPT_0_1 BIT1
#define  INTC_FIM0_FAST_INTERRUPT_0_2 BIT2
#define  INTC_FIM0_FAST_INTERRUPT_0_3 BIT3
#define  INTC_FIM0_FAST_INTERRUPT_0_4 BIT4
#define  INTC_FIM0_FAST_INTERRUPT_0_5 BIT5
#define  INTC_FIM0_FAST_INTERRUPT_0_6 BIT6

#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_0 BIT0
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_1 BIT1
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_2 BIT2
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_3 BIT3
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_4 BIT4
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_5 BIT5
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_6 BIT6
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_7 BIT7
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_8 BIT8
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_9 BIT9
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_10 BIT10
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_11 BIT11
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_12 BIT12
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_13 BIT13
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_14 BIT14
#define  INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_15 BIT15

#define  INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH (BIT0|BIT1|BIT2|BIT3|BIT4)
//   Upper 5 bits of vector address for fast interrupt 0
#define  INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_0 BIT0
#define  INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_1 BIT1
#define  INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_2 BIT2
#define  INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_3 BIT3
#define  INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_4 BIT4

#define  INTC_FIM1_FAST_INTERRUPT_1  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
//   Fast Interrupt 1 Vector Number
#define  INTC_FIM1_FAST_INTERRUPT_1_0 BIT0
#define  INTC_FIM1_FAST_INTERRUPT_1_1 BIT1
#define  INTC_FIM1_FAST_INTERRUPT_1_2 BIT2
#define  INTC_FIM1_FAST_INTERRUPT_1_3 BIT3
#define  INTC_FIM1_FAST_INTERRUPT_1_4 BIT4
#define  INTC_FIM1_FAST_INTERRUPT_1_5 BIT5
#define  INTC_FIM1_FAST_INTERRUPT_1_6 BIT6

#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Lower 16 bits of vector address for fast interrupt 1
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_0 BIT0
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_1 BIT1
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_2 BIT2
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_3 BIT3
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_4 BIT4
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_5 BIT5
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_6 BIT6
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_7 BIT7
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_8 BIT8
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_9 BIT9
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_10 BIT10
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_11 BIT11
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_12 BIT12
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_13 BIT13
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_14 BIT14
#define  INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_15 BIT15

#define  INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH (BIT0|BIT1|BIT2|BIT3|BIT4)
#define  INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_0 BIT0
#define  INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_1 BIT1
#define  INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_2 BIT2
#define  INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_3 BIT3
#define  INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_4 BIT4

#define  INTC_IRQP0_PENDING          (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pending IRQs
//     0b0 ==> IRQ pending for this vector number
//     0b1 ==> No IRQ pending for this vector number
#define  INTC_IRQP0_PENDING_0        BIT1
#define  INTC_IRQP0_PENDING_1        BIT2
#define  INTC_IRQP0_PENDING_2        BIT3
#define  INTC_IRQP0_PENDING_3        BIT4
#define  INTC_IRQP0_PENDING_4        BIT5
#define  INTC_IRQP0_PENDING_5        BIT6
#define  INTC_IRQP0_PENDING_6        BIT7
#define  INTC_IRQP0_PENDING_7        BIT8
#define  INTC_IRQP0_PENDING_8        BIT9
#define  INTC_IRQP0_PENDING_9        BIT10
#define  INTC_IRQP0_PENDING_10       BIT11
#define  INTC_IRQP0_PENDING_11       BIT12
#define  INTC_IRQP0_PENDING_12       BIT13
#define  INTC_IRQP0_PENDING_13       BIT14
#define  INTC_IRQP0_PENDING_14       BIT15

#define  INTC_IRQP1_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pending IRQs
//     0b0 ==> IRQ pending for this vector number
//     0b1 ==> No IRQ pending for this vector number
#define  INTC_IRQP1_PENDING_0        BIT0
#define  INTC_IRQP1_PENDING_1        BIT1
#define  INTC_IRQP1_PENDING_2        BIT2
#define  INTC_IRQP1_PENDING_3        BIT3
#define  INTC_IRQP1_PENDING_4        BIT4
#define  INTC_IRQP1_PENDING_5        BIT5
#define  INTC_IRQP1_PENDING_6        BIT6
#define  INTC_IRQP1_PENDING_7        BIT7
#define  INTC_IRQP1_PENDING_8        BIT8
#define  INTC_IRQP1_PENDING_9        BIT9
#define  INTC_IRQP1_PENDING_10       BIT10
#define  INTC_IRQP1_PENDING_11       BIT11
#define  INTC_IRQP1_PENDING_12       BIT12
#define  INTC_IRQP1_PENDING_13       BIT13
#define  INTC_IRQP1_PENDING_14       BIT14
#define  INTC_IRQP1_PENDING_15       BIT15

#define  INTC_IRQP2_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pending IRQs
//     0b0 ==> IRQ pending for this vector number
//     0b1 ==> No IRQ pending for this vector number
#define  INTC_IRQP2_PENDING_0        BIT0
#define  INTC_IRQP2_PENDING_1        BIT1
#define  INTC_IRQP2_PENDING_2        BIT2
#define  INTC_IRQP2_PENDING_3        BIT3
#define  INTC_IRQP2_PENDING_4        BIT4
#define  INTC_IRQP2_PENDING_5        BIT5
#define  INTC_IRQP2_PENDING_6        BIT6
#define  INTC_IRQP2_PENDING_7        BIT7
#define  INTC_IRQP2_PENDING_8        BIT8
#define  INTC_IRQP2_PENDING_9        BIT9
#define  INTC_IRQP2_PENDING_10       BIT10
#define  INTC_IRQP2_PENDING_11       BIT11
#define  INTC_IRQP2_PENDING_12       BIT12
#define  INTC_IRQP2_PENDING_13       BIT13
#define  INTC_IRQP2_PENDING_14       BIT14
#define  INTC_IRQP2_PENDING_15       BIT15

#define  INTC_IRQP3_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pending IRQs
//     0b0 ==> IRQ pending for this vector number
//     0b1 ==> No IRQ pending for this vector number
#define  INTC_IRQP3_PENDING_0        BIT0
#define  INTC_IRQP3_PENDING_1        BIT1
#define  INTC_IRQP3_PENDING_2        BIT2
#define  INTC_IRQP3_PENDING_3        BIT3
#define  INTC_IRQP3_PENDING_4        BIT4
#define  INTC_IRQP3_PENDING_5        BIT5
#define  INTC_IRQP3_PENDING_6        BIT6
#define  INTC_IRQP3_PENDING_7        BIT7
#define  INTC_IRQP3_PENDING_8        BIT8
#define  INTC_IRQP3_PENDING_9        BIT9
#define  INTC_IRQP3_PENDING_10       BIT10
#define  INTC_IRQP3_PENDING_11       BIT11
#define  INTC_IRQP3_PENDING_12       BIT12
#define  INTC_IRQP3_PENDING_13       BIT13
#define  INTC_IRQP3_PENDING_14       BIT14
#define  INTC_IRQP3_PENDING_15       BIT15

#define  INTC_IRQP4_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pending IRQs
//     0b0 ==> IRQ pending for this vector number
//     0b1 ==> No IRQ pending for this vector number
#define  INTC_IRQP4_PENDING_0        BIT0
#define  INTC_IRQP4_PENDING_1        BIT1
#define  INTC_IRQP4_PENDING_2        BIT2
#define  INTC_IRQP4_PENDING_3        BIT3
#define  INTC_IRQP4_PENDING_4        BIT4
#define  INTC_IRQP4_PENDING_5        BIT5
#define  INTC_IRQP4_PENDING_6        BIT6
#define  INTC_IRQP4_PENDING_7        BIT7
#define  INTC_IRQP4_PENDING_8        BIT8
#define  INTC_IRQP4_PENDING_9        BIT9
#define  INTC_IRQP4_PENDING_10       BIT10
#define  INTC_IRQP4_PENDING_11       BIT11
#define  INTC_IRQP4_PENDING_12       BIT12
#define  INTC_IRQP4_PENDING_13       BIT13
#define  INTC_IRQP4_PENDING_14       BIT14
#define  INTC_IRQP4_PENDING_15       BIT15

#define  INTC_IRQP5_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Pending IRQs
//     0b0 ==> IRQ pending for this vector number
//     0b1 ==> No IRQ pending for this vector number
#define  INTC_IRQP5_PENDING_0        BIT0
#define  INTC_IRQP5_PENDING_1        BIT1
#define  INTC_IRQP5_PENDING_2        BIT2
#define  INTC_IRQP5_PENDING_3        BIT3
#define  INTC_IRQP5_PENDING_4        BIT4
#define  INTC_IRQP5_PENDING_5        BIT5
#define  INTC_IRQP5_PENDING_6        BIT6
#define  INTC_IRQP5_PENDING_7        BIT7
#define  INTC_IRQP5_PENDING_8        BIT8
#define  INTC_IRQP5_PENDING_9        BIT9
#define  INTC_IRQP5_PENDING_10       BIT10
#define  INTC_IRQP5_PENDING_11       BIT11
#define  INTC_IRQP5_PENDING_12       BIT12
#define  INTC_IRQP5_PENDING_13       BIT13
#define  INTC_IRQP5_PENDING_14       BIT14
#define  INTC_IRQP5_PENDING_15       BIT15

#define  INTC_IRQP6_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
//   Pending IRQs
//     0b0 ==> IRQ pending for this vector number
//     0b1 ==> No IRQ pending for this vector number
#define  INTC_IRQP6_PENDING_0        BIT0
#define  INTC_IRQP6_PENDING_1        BIT1
#define  INTC_IRQP6_PENDING_2        BIT2
#define  INTC_IRQP6_PENDING_3        BIT3
#define  INTC_IRQP6_PENDING_4        BIT4
#define  INTC_IRQP6_PENDING_5        BIT5
#define  INTC_IRQP6_PENDING_6        BIT6
#define  INTC_IRQP6_PENDING_7        BIT7
#define  INTC_IRQP6_PENDING_8        BIT8
#define  INTC_IRQP6_PENDING_9        BIT9
#define  INTC_IRQP6_PENDING_10       BIT10
#define  INTC_IRQP6_PENDING_11       BIT11
#define  INTC_IRQP6_PENDING_12       BIT12
#define  INTC_IRQP6_PENDING_13       BIT13

#define  INTC_CTRL_INT_DIS           BIT5
//   Interrupt disable
//     0b0 ==> Normal operation. (default)
//     0b1 ==> All interrupts disabled.

#define  INTC_CTRL_VAB               (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12)
//   Vector number
#define  INTC_CTRL_VAB_0             BIT6
#define  INTC_CTRL_VAB_1             BIT7
#define  INTC_CTRL_VAB_2             BIT8
#define  INTC_CTRL_VAB_3             BIT9
#define  INTC_CTRL_VAB_4             BIT10
#define  INTC_CTRL_VAB_5             BIT11
#define  INTC_CTRL_VAB_6             BIT12

#define  INTC_CTRL_IPIC              (BIT13|BIT14)
//   Interrupt Priority Level
//     0b00 ==> Required nested exception priority levels are 0, 1, 2, or 3.
//     0b01 ==> Required nested exception priority levels are 1, 2, or 3.
//     0b10 ==> Required nested exception priority levels are 2 or3.
//     0b11 ==> Required nested exception priority level is 3.
#define  INTC_CTRL_IPIC_0            BIT13
#define  INTC_CTRL_IPIC_1            BIT14

#define  INTC_CTRL_INT               BIT15
//   Interrupt
//     0b0 ==> No interrupt is being sent to the core.
//     0b1 ==> An interrupt is being sent to the core.

#define  MCM_PLASC_ASC               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Each bit in the ASC field indicates if there is a corresponding connection to the AXBS slave input port. For this device, this field always read 0x0F.
//     0b0 ==> A bus slave connection to AXBS input port n is absent
//     0b1 ==> A bus slave connection to AXBS input port n is present
#define  MCM_PLASC_ASC_0             BIT0
#define  MCM_PLASC_ASC_1             BIT1
#define  MCM_PLASC_ASC_2             BIT2
#define  MCM_PLASC_ASC_3             BIT3
#define  MCM_PLASC_ASC_4             BIT4
#define  MCM_PLASC_ASC_5             BIT5
#define  MCM_PLASC_ASC_6             BIT6
#define  MCM_PLASC_ASC_7             BIT7

#define  MCM_PLASC_DP64              BIT15
//   Indicates if the datapath is 32 or 64 bits wide
//     0b0 ==> Datapath width is 32 bits
//     0b1 ==> Datapath width is 64 bits

#define  MCM_PLAMC_AMC               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Each bit in the AMC field indicates if there is a corresponding connection to the AXBS master input port. For this device, this field always reads 0x0F.
//     0b0 ==> A bus master connection to AXBS input port n is absent
//     0b1 ==> A bus master connection to AXBS input port n is present
#define  MCM_PLAMC_AMC_0             BIT0
#define  MCM_PLAMC_AMC_1             BIT1
#define  MCM_PLAMC_AMC_2             BIT2
#define  MCM_PLAMC_AMC_3             BIT3
#define  MCM_PLAMC_AMC_4             BIT4
#define  MCM_PLAMC_AMC_5             BIT5
#define  MCM_PLAMC_AMC_6             BIT6
#define  MCM_PLAMC_AMC_7             BIT7

#define  MCM_CPCR_SOCCR              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   SoC control fields
//     0b0 ==> Control associated with this bit is disabled
//     0b1 ==> Control associated with this bit is enabled
#define  MCM_CPCR_SOCCR_0            BIT0
#define  MCM_CPCR_SOCCR_1            BIT1
#define  MCM_CPCR_SOCCR_2            BIT2
#define  MCM_CPCR_SOCCR_3            BIT3
#define  MCM_CPCR_SOCCR_4            BIT4
#define  MCM_CPCR_SOCCR_5            BIT5
#define  MCM_CPCR_SOCCR_6            BIT6
#define  MCM_CPCR_SOCCR_7            BIT7
#define  MCM_CPCR_SOCCR_8            BIT8
#define  MCM_CPCR_SOCCR_9            BIT9
#define  MCM_CPCR_SOCCR_10           BIT10
#define  MCM_CPCR_SOCCR_11           BIT11
#define  MCM_CPCR_SOCCR_12           BIT12
#define  MCM_CPCR_SOCCR_13           BIT13
#define  MCM_CPCR_SOCCR_14           BIT14
#define  MCM_CPCR_SOCCR_15           BIT15

#define  MCM_CPCR_INSDIS             BIT16
//   Disable instructions supported only by DSP56800EX core
//     0b0 ==> BFSC and 32-bit multiply and MAC instructions enabled
//     0b1 ==> BFSC and 32-bit multiply and MAC instructions disabled

#define  MCM_CPCR_RCDIS              BIT17
//   Disable core reverse carry
//     0b0 ==> Core reverse carry enabled
//     0b1 ==> Core reverse carry disabled

#define  MCM_CPCR_SRDIS              BIT18
//   Disable core new shadow region
//     0b0 ==> Core new shadow region enabled
//     0b1 ==> Core new shadow region disabled

#define  MCM_CPCR_IBDIS              BIT19
//   Disable core instruction buffer
//     0b0 ==> Core longword instruction buffer enabled
//     0b1 ==> Core longword instruction buffer disabled

#define  MCM_CPCR_XBARARB            BIT31
//   Select AXBS crossbar switch arbitration scheme
//     0b0 ==> Fixed-priority arbitration selected
//     0b1 ==> Round-robin priority arbitration selected

#define  MCM_CFADR_ADDR              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Indicates the faulting address of the last core access terminated with an error response.
#define  MCM_CFADR_ADDR_0            BIT0
#define  MCM_CFADR_ADDR_1            BIT1
#define  MCM_CFADR_ADDR_2            BIT2
#define  MCM_CFADR_ADDR_3            BIT3
#define  MCM_CFADR_ADDR_4            BIT4
#define  MCM_CFADR_ADDR_5            BIT5
#define  MCM_CFADR_ADDR_6            BIT6
#define  MCM_CFADR_ADDR_7            BIT7
#define  MCM_CFADR_ADDR_8            BIT8
#define  MCM_CFADR_ADDR_9            BIT9
#define  MCM_CFADR_ADDR_10           BIT10
#define  MCM_CFADR_ADDR_11           BIT11
#define  MCM_CFADR_ADDR_12           BIT12
#define  MCM_CFADR_ADDR_13           BIT13
#define  MCM_CFADR_ADDR_14           BIT14
#define  MCM_CFADR_ADDR_15           BIT15
#define  MCM_CFADR_ADDR_16           BIT16
#define  MCM_CFADR_ADDR_17           BIT17
#define  MCM_CFADR_ADDR_18           BIT18
#define  MCM_CFADR_ADDR_19           BIT19
#define  MCM_CFADR_ADDR_20           BIT20
#define  MCM_CFADR_ADDR_21           BIT21
#define  MCM_CFADR_ADDR_22           BIT22
#define  MCM_CFADR_ADDR_23           BIT23
#define  MCM_CFADR_ADDR_24           BIT24
#define  MCM_CFADR_ADDR_25           BIT25
#define  MCM_CFADR_ADDR_26           BIT26
#define  MCM_CFADR_ADDR_27           BIT27
#define  MCM_CFADR_ADDR_28           BIT28
#define  MCM_CFADR_ADDR_29           BIT29
#define  MCM_CFADR_ADDR_30           BIT30
#define  MCM_CFADR_ADDR_31           BIT31

#define  MCM_CFATR_TYPE              BIT0
//   Type of last faulted core access
//     0b0 ==> Instruction
//     0b1 ==> Data

#define  MCM_CFATR_BUFFER            BIT2
//   Indicates if last faulted core access was bufferable
//     0b0 ==> Non-bufferable
//     0b1 ==> Bufferable

#define  MCM_CFATR_SIZE              (BIT4|BIT5|BIT6)
//   Size of last faulted core access
//     0b000 ==> 8-bit
//     0b001 ==> 16-bit
//     0b010 ==> 32-bit
#define  MCM_CFATR_SIZE_0            BIT4
#define  MCM_CFATR_SIZE_1            BIT5
#define  MCM_CFATR_SIZE_2            BIT6

#define  MCM_CFATR_DIR               BIT7
//   Direction of last faulted core access
//     0b0 ==> Core read access
//     0b1 ==> Core write access

#define  MCM_CFLOC_LOC               (BIT6|BIT7)
//   Location of last captured fault
//     0b00 ==> Error occurred on M0 (instruction bus)
//     0b01 ==> Error occured on M1 (operand A bus)
//     0b10 ==> Error occured on M2 (operand B bus)
//     0b11 ==> Reserved
#define  MCM_CFLOC_LOC_0             BIT6
#define  MCM_CFLOC_LOC_1             BIT7

#define  MCM_CFIER_ECFEI             BIT7
//   Enable core fault error interrupt
//     0b0 ==> Do not generate an error interrupt on a faulted system bus cycle
//     0b1 ==> Generate an error interrupt to the interrupt controller on a faulted system bus cycle

#define  MCM_CFISR_CFEI              BIT7
//   Core fault error interrupt flag
//     0b0 ==> No bus error
//     0b1 ==> A bus error has occurred. The faulting address, attributes (and possibly write data) are captured in the CFADR, CFATR, and CFDTR registers. The error interrupt is enabled only if CFIER[ECFEI] is set.

#define  MCM_CFDTR_DATA              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
//   Contains write data associated with the faulting access of the last internal bus write access. The data value is taken directly from the write data bus. Read data is not captured.
#define  MCM_CFDTR_DATA_0            BIT0
#define  MCM_CFDTR_DATA_1            BIT1
#define  MCM_CFDTR_DATA_2            BIT2
#define  MCM_CFDTR_DATA_3            BIT3
#define  MCM_CFDTR_DATA_4            BIT4
#define  MCM_CFDTR_DATA_5            BIT5
#define  MCM_CFDTR_DATA_6            BIT6
#define  MCM_CFDTR_DATA_7            BIT7
#define  MCM_CFDTR_DATA_8            BIT8
#define  MCM_CFDTR_DATA_9            BIT9
#define  MCM_CFDTR_DATA_10           BIT10
#define  MCM_CFDTR_DATA_11           BIT11
#define  MCM_CFDTR_DATA_12           BIT12
#define  MCM_CFDTR_DATA_13           BIT13
#define  MCM_CFDTR_DATA_14           BIT14
#define  MCM_CFDTR_DATA_15           BIT15
#define  MCM_CFDTR_DATA_16           BIT16
#define  MCM_CFDTR_DATA_17           BIT17
#define  MCM_CFDTR_DATA_18           BIT18
#define  MCM_CFDTR_DATA_19           BIT19
#define  MCM_CFDTR_DATA_20           BIT20
#define  MCM_CFDTR_DATA_21           BIT21
#define  MCM_CFDTR_DATA_22           BIT22
#define  MCM_CFDTR_DATA_23           BIT23
#define  MCM_CFDTR_DATA_24           BIT24
#define  MCM_CFDTR_DATA_25           BIT25
#define  MCM_CFDTR_DATA_26           BIT26
#define  MCM_CFDTR_DATA_27           BIT27
#define  MCM_CFDTR_DATA_28           BIT28
#define  MCM_CFDTR_DATA_29           BIT29
#define  MCM_CFDTR_DATA_30           BIT30
#define  MCM_CFDTR_DATA_31           BIT31

#define  MCM_RPCR_RPE                BIT0
//   Resource Protection Enable
//     0b0 ==> Resource protection disabled
//     0b1 ==> Resource protection enabled

#define  MCM_RPCR_RL                 BIT1
//   Register Lock
//     0b0 ==> RP register values may be changed
//     0b1 ==> RP registers are locked and may not be changed until after a system reset

#define  MCM_UFLASHBAR_FBA           (BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
//   Flash Base Address for User Region
#define  MCM_UFLASHBAR_FBA_0         BIT12
#define  MCM_UFLASHBAR_FBA_1         BIT13
#define  MCM_UFLASHBAR_FBA_2         BIT14
#define  MCM_UFLASHBAR_FBA_3         BIT15
#define  MCM_UFLASHBAR_FBA_4         BIT16
#define  MCM_UFLASHBAR_FBA_5         BIT17

#define  MCM_UPRAMBAR_RBA            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
//   Program RAM Base Address for User Region
#define  MCM_UPRAMBAR_RBA_0          BIT8
#define  MCM_UPRAMBAR_RBA_1          BIT9
#define  MCM_UPRAMBAR_RBA_2          BIT10
#define  MCM_UPRAMBAR_RBA_3          BIT11
#define  MCM_UPRAMBAR_RBA_4          BIT12
#define  MCM_UPRAMBAR_RBA_5          BIT13
#define  MCM_UPRAMBAR_RBA_6          BIT14

#define  MCM_SRPOSP_SRPOSP           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
//   Resource protection "other" SP
#define  MCM_SRPOSP_SRPOSP_0         BIT0
#define  MCM_SRPOSP_SRPOSP_1         BIT1
#define  MCM_SRPOSP_SRPOSP_2         BIT2
#define  MCM_SRPOSP_SRPOSP_3         BIT3
#define  MCM_SRPOSP_SRPOSP_4         BIT4
#define  MCM_SRPOSP_SRPOSP_5         BIT5
#define  MCM_SRPOSP_SRPOSP_6         BIT6
#define  MCM_SRPOSP_SRPOSP_7         BIT7
#define  MCM_SRPOSP_SRPOSP_8         BIT8
#define  MCM_SRPOSP_SRPOSP_9         BIT9
#define  MCM_SRPOSP_SRPOSP_10        BIT10
#define  MCM_SRPOSP_SRPOSP_11        BIT11
#define  MCM_SRPOSP_SRPOSP_12        BIT12
#define  MCM_SRPOSP_SRPOSP_13        BIT13
#define  MCM_SRPOSP_SRPOSP_14        BIT14
#define  MCM_SRPOSP_SRPOSP_15        BIT15
#define  MCM_SRPOSP_SRPOSP_16        BIT16
#define  MCM_SRPOSP_SRPOSP_17        BIT17
#define  MCM_SRPOSP_SRPOSP_18        BIT18
#define  MCM_SRPOSP_SRPOSP_19        BIT19
#define  MCM_SRPOSP_SRPOSP_20        BIT20
#define  MCM_SRPOSP_SRPOSP_21        BIT21
#define  MCM_SRPOSP_SRPOSP_22        BIT22
#define  MCM_SRPOSP_SRPOSP_23        BIT23

#define  MCM_SRPIPC_SRPIFPC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20)
//   Resource Protection Illegal Faulting PC
#define  MCM_SRPIPC_SRPIFPC_0        BIT0
#define  MCM_SRPIPC_SRPIFPC_1        BIT1
#define  MCM_SRPIPC_SRPIFPC_2        BIT2
#define  MCM_SRPIPC_SRPIFPC_3        BIT3
#define  MCM_SRPIPC_SRPIFPC_4        BIT4
#define  MCM_SRPIPC_SRPIFPC_5        BIT5
#define  MCM_SRPIPC_SRPIFPC_6        BIT6
#define  MCM_SRPIPC_SRPIFPC_7        BIT7
#define  MCM_SRPIPC_SRPIFPC_8        BIT8
#define  MCM_SRPIPC_SRPIFPC_9        BIT9
#define  MCM_SRPIPC_SRPIFPC_10       BIT10
#define  MCM_SRPIPC_SRPIFPC_11       BIT11
#define  MCM_SRPIPC_SRPIFPC_12       BIT12
#define  MCM_SRPIPC_SRPIFPC_13       BIT13
#define  MCM_SRPIPC_SRPIFPC_14       BIT14
#define  MCM_SRPIPC_SRPIFPC_15       BIT15
#define  MCM_SRPIPC_SRPIFPC_16       BIT16
#define  MCM_SRPIPC_SRPIFPC_17       BIT17
#define  MCM_SRPIPC_SRPIFPC_18       BIT18
#define  MCM_SRPIPC_SRPIFPC_19       BIT19
#define  MCM_SRPIPC_SRPIFPC_20       BIT20

#define  MCM_SRPIPC_SRPIFOR          BIT30
//   Resource Protection Illegal Fault Overrun

#define  MCM_SRPIPC_SRPIFV           BIT31
//   Resource Protection Illegal Fault Valid

#define  MCM_SRPMPC_SRPMFPC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20)
//   Resource Protection Misaligned Faulting PC
#define  MCM_SRPMPC_SRPMFPC_0        BIT0
#define  MCM_SRPMPC_SRPMFPC_1        BIT1
#define  MCM_SRPMPC_SRPMFPC_2        BIT2
#define  MCM_SRPMPC_SRPMFPC_3        BIT3
#define  MCM_SRPMPC_SRPMFPC_4        BIT4
#define  MCM_SRPMPC_SRPMFPC_5        BIT5
#define  MCM_SRPMPC_SRPMFPC_6        BIT6
#define  MCM_SRPMPC_SRPMFPC_7        BIT7
#define  MCM_SRPMPC_SRPMFPC_8        BIT8
#define  MCM_SRPMPC_SRPMFPC_9        BIT9
#define  MCM_SRPMPC_SRPMFPC_10       BIT10
#define  MCM_SRPMPC_SRPMFPC_11       BIT11
#define  MCM_SRPMPC_SRPMFPC_12       BIT12
#define  MCM_SRPMPC_SRPMFPC_13       BIT13
#define  MCM_SRPMPC_SRPMFPC_14       BIT14
#define  MCM_SRPMPC_SRPMFPC_15       BIT15
#define  MCM_SRPMPC_SRPMFPC_16       BIT16
#define  MCM_SRPMPC_SRPMFPC_17       BIT17
#define  MCM_SRPMPC_SRPMFPC_18       BIT18
#define  MCM_SRPMPC_SRPMFPC_19       BIT19
#define  MCM_SRPMPC_SRPMFPC_20       BIT20

#define  MCM_SRPMPC_SRPMFOR          BIT30
//   Resource Protection Misaligned Fault Overrun

#define  MCM_SRPMPC_SRPMFV           BIT31
//   Resource Protection Misaligned Fault Valid

#define  OCCS_CTRL_ZSRC              BIT0
//   CLOCK Source
//     0b0 ==> MSTR_OSC
//     0b1 ==> PLL output divided by 2

#define  OCCS_CTRL_PRECS             (BIT2|BIT3)
//   Prescaler Clock Select
//     0b00 ==> 8 MHz relaxation oscillator selected (reset value)
//     0b01 ==> External reference selected
//     0b10 ==> 32 kHz relaxation oscillator selected
//     0b11 ==> Reserved
#define  OCCS_CTRL_PRECS_0           BIT2
#define  OCCS_CTRL_PRECS_1           BIT3

#define  OCCS_CTRL_PLLPD             BIT4
//   PLL Power Down
//     0b0 ==> PLL enabled
//     0b1 ==> PLL powered down

#define  OCCS_CTRL_LCKON             BIT7
//   Lock Detector On
//     0b0 ==> Lock detector disabled
//     0b1 ==> Lock detector enabled

#define  OCCS_CTRL_LOCIE             BIT11
//   Loss of Reference Clock Interrupt Enable
//     0b0 ==> Interrupt disabled.
//     0b1 ==> Interrupt enabled.

#define  OCCS_CTRL_PLLIE0            (BIT12|BIT13)
//   PLL Interrupt Enable 0
//     0b00 ==> Disable interrupt.
//     0b01 ==> Enable interrupt on any rising edge of LCK0.
//     0b10 ==> Enable interrupt on falling edge of LCK0.
//     0b11 ==> Enable interrupt on any edge change of LCK0.
#define  OCCS_CTRL_PLLIE0_0          BIT12
#define  OCCS_CTRL_PLLIE0_1          BIT13

#define  OCCS_CTRL_PLLIE1            (BIT14|BIT15)
//   PLL Interrupt Enable 1
//     0b00 ==> Disable interrupt.
//     0b01 ==> Enable interrupt on any rising edge of LCK1.
//     0b10 ==> Enable interrupt on falling edge of LCK1.
//     0b11 ==> Enable interrupt on any edge change of LCK1.
#define  OCCS_CTRL_PLLIE1_0          BIT14
#define  OCCS_CTRL_PLLIE1_1          BIT15

#define  OCCS_DIVBY_PLLDB            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   PLL Divide By
#define  OCCS_DIVBY_PLLDB_0          BIT0
#define  OCCS_DIVBY_PLLDB_1          BIT1
#define  OCCS_DIVBY_PLLDB_2          BIT2
#define  OCCS_DIVBY_PLLDB_3          BIT3
#define  OCCS_DIVBY_PLLDB_4          BIT4
#define  OCCS_DIVBY_PLLDB_5          BIT5

#define  OCCS_DIVBY_COD              (BIT8|BIT9|BIT10|BIT11)
//   Clock Output Divide or Postscaler
//     0b0000 ==> Divide clock output by 1.
//     0b0001 ==> Divide clock output by 2.
//     0b0010 ==> Divide clock output by 4.
//     0b0011 ==> Divide clock output by 8.
//     0b0100 ==> Divide clock output by 16.
//     0b0101 ==> Divide clock output by 32.
//     0b0110 ==> Divide clock output by 64.
//     0b0111 ==> Divide clock output by 128.
//     0b1xxx ==> Divide clock output by 256.
#define  OCCS_DIVBY_COD_0            BIT8
#define  OCCS_DIVBY_COD_1            BIT9
#define  OCCS_DIVBY_COD_2            BIT10
#define  OCCS_DIVBY_COD_3            BIT11

#define  OCCS_DIVBY_LORTP            (BIT12|BIT13|BIT14|BIT15)
//   Loss of Reference Clock Trip Point
#define  OCCS_DIVBY_LORTP_0          BIT12
#define  OCCS_DIVBY_LORTP_1          BIT13
#define  OCCS_DIVBY_LORTP_2          BIT14
#define  OCCS_DIVBY_LORTP_3          BIT15

#define  OCCS_STAT_ZSRCS             (BIT0|BIT1)
//   CLOCK Source Status
//     0b00 ==> MSTR_OSC
//     0b01 ==> PLL output divided by 2
//     0b1x ==> Synchronization in progress
#define  OCCS_STAT_ZSRCS_0           BIT0
#define  OCCS_STAT_ZSRCS_1           BIT1

#define  OCCS_STAT_PLLPDN            BIT4
//   PLL Power Down
//     0b0 ==> PLL not powered down.
//     0b1 ==> PLL powered down.

#define  OCCS_STAT_LCK0              BIT5
//   PLL Lock 0 Status
//     0b0 ==> PLL is unlocked.
//     0b1 ==> PLL is locked (coarse).

#define  OCCS_STAT_LCK1              BIT6
//   PLL Lock 1 Status
//     0b0 ==> PLL is unlocked.
//     0b1 ==> PLL is locked (fine).

#define  OCCS_STAT_OSC_OK            BIT7
//   OSC_OK Indicator from XOSC
//     0b0 ==> Oscillator clock is still not stable, or XOSC is disabled.
//     0b1 ==> XOSC OK indicator after crystal oscillator startup.

#define  OCCS_STAT_MON_FAILURE       BIT8
//   XOSC Clock Monitor Failure Indicator
//     0b0 ==> No clock failure, or clock monitor is disabled.
//     0b1 ==> Clock failure detected on XOSC reference clock when clock monitor is enabled.

#define  OCCS_STAT_LOCI              BIT13
//   Loss of Reference Clock Interrupt
//     0b0 ==> Oscillator clock normal.
//     0b1 ==> Loss of oscillator clock detected.

#define  OCCS_STAT_LOLI0             BIT14
//   PLL Lock or Loss of Lock Interrupt 0
//     0b0 ==> No lock or loss of lock event has occurred.
//     0b1 ==> PLL lock status based on PLLIE0.

#define  OCCS_STAT_LOLI1             BIT15
//   PLL Lock or Loss of Lock Interrupt 1
//     0b0 ==> No lock or loss of lock event has occurred.
//     0b1 ==> PLL lock status based on PLLIE1.

#define  OCCS_OSCTL1_FREQ_TRIM8M     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
//   8 MHz Relaxation Oscillator Frequency Trim
#define  OCCS_OSCTL1_FREQ_TRIM8M_0   BIT0
#define  OCCS_OSCTL1_FREQ_TRIM8M_1   BIT1
#define  OCCS_OSCTL1_FREQ_TRIM8M_2   BIT2
#define  OCCS_OSCTL1_FREQ_TRIM8M_3   BIT3
#define  OCCS_OSCTL1_FREQ_TRIM8M_4   BIT4
#define  OCCS_OSCTL1_FREQ_TRIM8M_5   BIT5
#define  OCCS_OSCTL1_FREQ_TRIM8M_6   BIT6
#define  OCCS_OSCTL1_FREQ_TRIM8M_7   BIT7
#define  OCCS_OSCTL1_FREQ_TRIM8M_8   BIT8
#define  OCCS_OSCTL1_FREQ_TRIM8M_9   BIT9

#define  OCCS_OSCTL1_EXT_SEL         BIT10
//   External Clock In Select
//     0b0 ==> Use the output of the crystal oscillator as the external clock input.
//     0b1 ==> Use CLKIN as the external clock input.

#define  OCCS_OSCTL1_OSC_DIV2        BIT11
//   Oscillator Divide By 2
//     0b0 ==> External oscillator output is not divided.
//     0b1 ==> External oscillator output is divided by 2 before use as MSTR_OSC.

#define  OCCS_OSCTL1_CLK_MODE        BIT12
//   Crystal Oscillator Clock Mode
//     0b0 ==> Crystal oscillator enabled.
//     0b1 ==> External clock bypass mode. This enables the crystal oscillator's external clock bypass mode and allows an external clock source on the EXTAL input of the oscillator to propagate directly to the oscillator's clock output.

#define  OCCS_OSCTL1_COHL            BIT13
//   Crystal Oscillator High/Low Power Level
//     0b0 ==> High power mode.
//     0b1 ==> Low power mode.

#define  OCCS_OSCTL1_ROSB            BIT14
//   8 MHz Relaxation Oscillator Standby
//     0b0 ==> Normal mode. The relaxation oscillator output frequency is 8 MHz.
//     0b1 ==> Standby mode. The relaxation oscillator output frequency is reduced to 400 kHz (+/-50%). The PLL should be disabled in this mode and MSTR_OSC should be selected as the output clock.

#define  OCCS_OSCTL1_ROPD            BIT15
//   8 MHz Relaxation Oscillator Power Down
//     0b0 ==> Relaxation oscillator enabled.
//     0b1 ==> Relaxation oscillator powered down.

#define  OCCS_OSCTL2_FREQ_TRIM32K    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
//   32 kHz Internal RC Oscillator Frequency Trim
#define  OCCS_OSCTL2_FREQ_TRIM32K_0  BIT0
#define  OCCS_OSCTL2_FREQ_TRIM32K_1  BIT1
#define  OCCS_OSCTL2_FREQ_TRIM32K_2  BIT2
#define  OCCS_OSCTL2_FREQ_TRIM32K_3  BIT3
#define  OCCS_OSCTL2_FREQ_TRIM32K_4  BIT4
#define  OCCS_OSCTL2_FREQ_TRIM32K_5  BIT5
#define  OCCS_OSCTL2_FREQ_TRIM32K_6  BIT6
#define  OCCS_OSCTL2_FREQ_TRIM32K_7  BIT7
#define  OCCS_OSCTL2_FREQ_TRIM32K_8  BIT8

#define  OCCS_OSCTL2_MON_ENABLE      BIT9
//   XOSC Clock Monitor Enable Control

#define  OCCS_OSCTL2_TEMP_TRIM8M     (BIT10|BIT11|BIT12|BIT13)
//   8 MHz Internal Relaxation Oscillator Temperature Trim
#define  OCCS_OSCTL2_TEMP_TRIM8M_0   BIT10
#define  OCCS_OSCTL2_TEMP_TRIM8M_1   BIT11
#define  OCCS_OSCTL2_TEMP_TRIM8M_2   BIT12
#define  OCCS_OSCTL2_TEMP_TRIM8M_3   BIT13

#define  OCCS_OSCTL2_COPD            BIT14
//   Crystal Oscillator Power Down
//     0b0 ==> Crystal oscillator enabled.
//     0b1 ==> Crystal oscillator powered down.

#define  OCCS_OSCTL2_ROPD32K         BIT15
//   32 kHz RC Oscillator Power Down

#define  OCCS_CLKCHKR_REF_CNT        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
//   Reference Count
#define  OCCS_CLKCHKR_REF_CNT_0      BIT0
#define  OCCS_CLKCHKR_REF_CNT_1      BIT1
#define  OCCS_CLKCHKR_REF_CNT_2      BIT2
#define  OCCS_CLKCHKR_REF_CNT_3      BIT3
#define  OCCS_CLKCHKR_REF_CNT_4      BIT4
#define  OCCS_CLKCHKR_REF_CNT_5      BIT5
#define  OCCS_CLKCHKR_REF_CNT_6      BIT6

#define  OCCS_CLKCHKR_CHK_ENA        BIT15
//   Check Enable
//     0b0 ==> Writing a low while the clock checking operation is in progress stops the check in its current state. Reading a low after a check has been started indicates that the check operation is complete and the final values are valid in the REF_CNT and TARGET_CNT fields.
//     0b1 ==> Writing a one clears the REF_CNT and TARGET_CNT fields and starts the clock checking function. The CLK_ENA bit remains high while the operation is in progress.

#define  OCCS_CLKCHKT_TARGET_CNT     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
//   CLKCHKT Target Count
#define  OCCS_CLKCHKT_TARGET_CNT_0   BIT0
#define  OCCS_CLKCHKT_TARGET_CNT_1   BIT1
#define  OCCS_CLKCHKT_TARGET_CNT_2   BIT2
#define  OCCS_CLKCHKT_TARGET_CNT_3   BIT3
#define  OCCS_CLKCHKT_TARGET_CNT_4   BIT4
#define  OCCS_CLKCHKT_TARGET_CNT_5   BIT5
#define  OCCS_CLKCHKT_TARGET_CNT_6   BIT6
#define  OCCS_CLKCHKT_TARGET_CNT_7   BIT7
#define  OCCS_CLKCHKT_TARGET_CNT_8   BIT8
#define  OCCS_CLKCHKT_TARGET_CNT_9   BIT9
#define  OCCS_CLKCHKT_TARGET_CNT_10  BIT10

#define  OCCS_PROT_PLLEP             (BIT0|BIT1)
//   PLL Enable Protection
//     0b00 ==> Write protection off (default).
//     0b01 ==> Write protection on.
//     0b10 ==> Write protection off and locked until chip reset.
//     0b11 ==> Write protection on and locked until chip reset.
#define  OCCS_PROT_PLLEP_0           BIT0
#define  OCCS_PROT_PLLEP_1           BIT1

#define  OCCS_PROT_OSCEP             (BIT2|BIT3)
//   Oscillator Enable Protection
//     0b00 ==> Write protection off (default).
//     0b01 ==> Write protection on.
//     0b10 ==> Write protection off and locked until chip reset.
//     0b11 ==> Write protection on and locked until chip reset.
#define  OCCS_PROT_OSCEP_0           BIT2
#define  OCCS_PROT_OSCEP_1           BIT3

#define  OCCS_PROT_FRQEP             (BIT4|BIT5)
//   Frequency Enable Protection
//     0b00 ==> Write protection off (default).
//     0b01 ==> Write protection on.
//     0b10 ==> Write protection off and locked until chip reset.
//     0b11 ==> Write protection on and locked until chip reset.
#define  OCCS_PROT_FRQEP_0           BIT4
#define  OCCS_PROT_FRQEP_1           BIT5

#define  PDB0_MCTRL_PDBEN            BIT0
//   PDB Module Enable
//     0b0 ==> Counter is off and all Trigger and PreTrigger outputs are low.
//     0b1 ==> Counter is enabled.

#define  PDB0_MCTRL_TRIGSEL          (BIT4|BIT5|BIT6)
//   Input Trigger Select
//     0b000 ==> TriggerIn0 is selected.
//     0b001 ==> TriggerIn1 is selected.
//     0b010 ==> TriggerIn2 is selected.
//     0b011 ==> TriggerIn3 is selected.
//     0b100 ==> TriggerIn4 is selected.
//     0b101 ==> TriggerIn5 is selected.
//     0b110 ==> TriggerIn6 is selected.
//     0b111 ==> SWTRIG is selected.
#define  PDB0_MCTRL_TRIGSEL_0        BIT4
#define  PDB0_MCTRL_TRIGSEL_1        BIT5
#define  PDB0_MCTRL_TRIGSEL_2        BIT6

#define  PDB0_MCTRL_SWTRIG           BIT7
//   Software Trigger

#define  PDB0_MCTRL_COIE             BIT8
//   Counter Overflow Interrupt Enable
//     0b0 ==> Counter roll over interrupt requests disabled.
//     0b1 ==> Counter roll over interrupt requests enabled.

#define  PDB0_MCTRL_COF              BIT9
//   Counter Overflow Flag

#define  PDB0_MCTRL_CONT             BIT10
//   Continuous Mode Enable
//     0b0 ==> Module is in one-shot mode.
//     0b1 ==> Module is in continuous mode.

#define  PDB0_MCTRL_LDOK             BIT11
//   Load OK

#define  PDB0_MCTRL_LDMOD            BIT12
//   Load Mode Select
//     0b0 ==> DELAY* and MOD registers are loaded into a set of buffers and take effect immediately after logic 1 is written to the MCTRL[LDOK] bit.
//     0b1 ==> DELAY* and MOD registers are loaded into a set of buffers and take effect when the counter rolls over or a trigger signal is received after logic 1 is written to the MCTRL[LDOK] bit.

#define  PDB0_MCTRL_PRESCALER        (BIT13|BIT14|BIT15)
//   Clock Prescaler Select
//     0b000 ==> Timer uses peripheral clock.
//     0b001 ==> Timer uses peripheral clock / 2.
//     0b010 ==> Timer uses peripheral clock / 4.
//     0b011 ==> Timer uses peripheral clock / 8.
//     0b100 ==> Timer uses peripheral clock / 16.
//     0b101 ==> Timer uses peripheral clock / 32.
//     0b110 ==> Timer uses peripheral clock / 64.
//     0b111 ==> Timer uses peripheral clock / 128.
#define  PDB0_MCTRL_PRESCALER_0      BIT13
#define  PDB0_MCTRL_PRESCALER_1      BIT14
#define  PDB0_MCTRL_PRESCALER_2      BIT15

#define  PDB0_CTRLA_ENB              BIT0
//   Trigger B Enable
//     0b0 ==> Trigger B is disabled and forced to 0.
//     0b1 ==> Trigger B is enabled.

#define  PDB0_CTRLA_ENA              BIT1
//   Trigger A Enable
//     0b0 ==> Trigger A is disabled and forced to 0.
//     0b1 ==> Trigger A is enabled.

#define  PDB0_CTRLA_BYPB             BIT2
//   Bypass B
//     0b0 ==> Trigger B is generated normally.
//     0b1 ==> Trigger B generation is bypassed and Trigger B is a single pulse created by the selected trigger source.

#define  PDB0_CTRLA_BYPA             BIT3
//   Bypass A
//     0b0 ==> Trigger A is generated normally.
//     0b1 ==> Trigger A generation is bypassed and Trigger A is a single pulse created by the selected trigger source.

#define  PDB0_CTRLA_ABSEL            BIT4
//   Trigger A Output Select
//     0b0 ==> Trigger A is a function of DELAYA only. Trigger B is a function of DELAYB only.
//     0b1 ==> Trigger A and Trigger B outputs are a function of combined DELAYA and DELAYB. Trigger A is an extended pulse (as in trigger pulsed output operation) and Trigger B is a dual pulse (as in two-shot mode with trigger configured for simultaneous sampling).

#define  PDB0_CTRLA_AINIT            BIT5
//   Initial Value A

#define  PDB0_CTRLA_DBIE             BIT8
//   Delay B Interrupt Enable
//     0b0 ==> DELAYB successful compare interrupt requests disabled.
//     0b1 ==> DELAYB successful compare interrupt requests enabled.

#define  PDB0_CTRLA_DBF              BIT9
//   Delay B Flag

#define  PDB0_CTRLA_DAIE             BIT10
//   Delay A Interrupt Enable
//     0b0 ==> DELAYA successful compare interrupt requests disabled.
//     0b1 ==> DELAYA successful compare interrupt requests enabled.

#define  PDB0_CTRLA_DAF              BIT11
//   Delay A Flag

#define  PDB0_CTRLA_FLENA            BIT12
//   Fault A Length
//     0b0 ==> Fault input must be active at least 2 IPBus clock cycles.
//     0b1 ==> Fault input must be active at least 4 IPBus clock cycles.

#define  PDB0_CTRLA_FPOLA            BIT13
//   Fault A Polarity
//     0b0 ==> A logic 0 on Fault A indicates a fault condition
//     0b1 ==> A logic 1 on Fault A indicates a fault condition.

#define  PDB0_CTRLA_FLTAEN           BIT14
//   Fault A Enable
//     0b0 ==> Fault A input is ignored.
//     0b1 ==> A logic 1 on the Fault A input forces TriggerA output to CTRLA[AINIT] until a counter reload occurs.

#define  PDB0_CTRLA_FLTA             BIT15
//   Fault A Input Status

#define  PDB0_CTRLC_END              BIT0
//   Trigger D Enable
//     0b0 ==> Trigger D is disabled and forced to 0.
//     0b1 ==> Trigger D is enabled.

#define  PDB0_CTRLC_ENC              BIT1
//   Trigger C Enable
//     0b0 ==> Trigger C is disabled and forced to 0.
//     0b1 ==> Trigger C is enabled.

#define  PDB0_CTRLC_BYPD             BIT2
//   Bypass D
//     0b0 ==> Trigger D is generated normally.
//     0b1 ==> Trigger D generation is bypassed and Trigger D is a single pulse created by the selected trigger source.

#define  PDB0_CTRLC_BYPC             BIT3
//   Bypass C
//     0b0 ==> Trigger C is generated normally.
//     0b1 ==> Trigger C generation is bypassed and Trigger C is a single pulse created by the selected trigger source.

#define  PDB0_CTRLC_CDSEL            BIT4
//   Trigger C Output Select
//     0b0 ==> Trigger C is a function of DELAYC only. Trigger D is a function of DELAYD only.
//     0b1 ==> Trigger C and Trigger D outputs are a function of combined DELAYC and DELAYD. Trigger C is an extended pulse (as in trigger pulsed output operation) and Trigger D is a dual pulse (as in two-shot mode with trigger configured for simultaneous sampling).

#define  PDB0_CTRLC_CINIT            BIT5
//   Initial Value C

#define  PDB0_CTRLC_DDIE             BIT8
//   Delay D Interrupt Enable
//     0b0 ==> DELAYD successful compare interrupt requests disabled.
//     0b1 ==> DELAYD successful compare interrupt requests enabled.

#define  PDB0_CTRLC_DDF              BIT9
//   Delay D Flag

#define  PDB0_CTRLC_DCIE             BIT10
//   Delay C Interrupt Enable
//     0b0 ==> DELAYC successful compare interrupt requests disabled.
//     0b1 ==> DELAYC successful compare interrupt requests enabled.

#define  PDB0_CTRLC_DCF              BIT11
//   Delay C Flag

#define  PDB0_CTRLC_FLENC            BIT12
//   Fault C Length
//     0b0 ==> Fault input must be active at least 2 IPBus clock cycles.
//     0b1 ==> Fault input must be active at least 4 IPBus clock cycles.

#define  PDB0_CTRLC_FPOLC            BIT13
//   Fault C Polarity
//     0b0 ==> A logic 0 on Fault C indicates a fault condition.
//     0b1 ==> A logic 1 on Fault C indicates a fault condition.

#define  PDB0_CTRLC_FLTCEN           BIT14
//   Fault C Enable.
//     0b0 ==> Fault C input is ignored.
//     0b1 ==> A logic 1 on the Fault C input forces Trigger C output to CTRLC[CINIT] until a counter reload occurs.

#define  PDB0_CTRLC_FLTC             BIT15
//   Fault C Input Status

#define  PDB0_DELAYA_DELAYA          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Delay A
#define  PDB0_DELAYA_DELAYA_0        BIT0
#define  PDB0_DELAYA_DELAYA_1        BIT1
#define  PDB0_DELAYA_DELAYA_2        BIT2
#define  PDB0_DELAYA_DELAYA_3        BIT3
#define  PDB0_DELAYA_DELAYA_4        BIT4
#define  PDB0_DELAYA_DELAYA_5        BIT5
#define  PDB0_DELAYA_DELAYA_6        BIT6
#define  PDB0_DELAYA_DELAYA_7        BIT7
#define  PDB0_DELAYA_DELAYA_8        BIT8
#define  PDB0_DELAYA_DELAYA_9        BIT9
#define  PDB0_DELAYA_DELAYA_10       BIT10
#define  PDB0_DELAYA_DELAYA_11       BIT11
#define  PDB0_DELAYA_DELAYA_12       BIT12
#define  PDB0_DELAYA_DELAYA_13       BIT13
#define  PDB0_DELAYA_DELAYA_14       BIT14
#define  PDB0_DELAYA_DELAYA_15       BIT15

#define  PDB0_DELAYB_DELAYB          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Delay B
#define  PDB0_DELAYB_DELAYB_0        BIT0
#define  PDB0_DELAYB_DELAYB_1        BIT1
#define  PDB0_DELAYB_DELAYB_2        BIT2
#define  PDB0_DELAYB_DELAYB_3        BIT3
#define  PDB0_DELAYB_DELAYB_4        BIT4
#define  PDB0_DELAYB_DELAYB_5        BIT5
#define  PDB0_DELAYB_DELAYB_6        BIT6
#define  PDB0_DELAYB_DELAYB_7        BIT7
#define  PDB0_DELAYB_DELAYB_8        BIT8
#define  PDB0_DELAYB_DELAYB_9        BIT9
#define  PDB0_DELAYB_DELAYB_10       BIT10
#define  PDB0_DELAYB_DELAYB_11       BIT11
#define  PDB0_DELAYB_DELAYB_12       BIT12
#define  PDB0_DELAYB_DELAYB_13       BIT13
#define  PDB0_DELAYB_DELAYB_14       BIT14
#define  PDB0_DELAYB_DELAYB_15       BIT15

#define  PDB0_DELAYC_DELAYC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Delay C
#define  PDB0_DELAYC_DELAYC_0        BIT0
#define  PDB0_DELAYC_DELAYC_1        BIT1
#define  PDB0_DELAYC_DELAYC_2        BIT2
#define  PDB0_DELAYC_DELAYC_3        BIT3
#define  PDB0_DELAYC_DELAYC_4        BIT4
#define  PDB0_DELAYC_DELAYC_5        BIT5
#define  PDB0_DELAYC_DELAYC_6        BIT6
#define  PDB0_DELAYC_DELAYC_7        BIT7
#define  PDB0_DELAYC_DELAYC_8        BIT8
#define  PDB0_DELAYC_DELAYC_9        BIT9
#define  PDB0_DELAYC_DELAYC_10       BIT10
#define  PDB0_DELAYC_DELAYC_11       BIT11
#define  PDB0_DELAYC_DELAYC_12       BIT12
#define  PDB0_DELAYC_DELAYC_13       BIT13
#define  PDB0_DELAYC_DELAYC_14       BIT14
#define  PDB0_DELAYC_DELAYC_15       BIT15

#define  PDB0_DELAYD_DELAYD          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Delay D
#define  PDB0_DELAYD_DELAYD_0        BIT0
#define  PDB0_DELAYD_DELAYD_1        BIT1
#define  PDB0_DELAYD_DELAYD_2        BIT2
#define  PDB0_DELAYD_DELAYD_3        BIT3
#define  PDB0_DELAYD_DELAYD_4        BIT4
#define  PDB0_DELAYD_DELAYD_5        BIT5
#define  PDB0_DELAYD_DELAYD_6        BIT6
#define  PDB0_DELAYD_DELAYD_7        BIT7
#define  PDB0_DELAYD_DELAYD_8        BIT8
#define  PDB0_DELAYD_DELAYD_9        BIT9
#define  PDB0_DELAYD_DELAYD_10       BIT10
#define  PDB0_DELAYD_DELAYD_11       BIT11
#define  PDB0_DELAYD_DELAYD_12       BIT12
#define  PDB0_DELAYD_DELAYD_13       BIT13
#define  PDB0_DELAYD_DELAYD_14       BIT14
#define  PDB0_DELAYD_DELAYD_15       BIT15

#define  PDB0_MOD_MOD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  PDB0_MOD_MOD_0              BIT0
#define  PDB0_MOD_MOD_1              BIT1
#define  PDB0_MOD_MOD_2              BIT2
#define  PDB0_MOD_MOD_3              BIT3
#define  PDB0_MOD_MOD_4              BIT4
#define  PDB0_MOD_MOD_5              BIT5
#define  PDB0_MOD_MOD_6              BIT6
#define  PDB0_MOD_MOD_7              BIT7
#define  PDB0_MOD_MOD_8              BIT8
#define  PDB0_MOD_MOD_9              BIT9
#define  PDB0_MOD_MOD_10             BIT10
#define  PDB0_MOD_MOD_11             BIT11
#define  PDB0_MOD_MOD_12             BIT12
#define  PDB0_MOD_MOD_13             BIT13
#define  PDB0_MOD_MOD_14             BIT14
#define  PDB0_MOD_MOD_15             BIT15

#define  PDB0_CNTR_COUNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  PDB0_CNTR_COUNT_0           BIT0
#define  PDB0_CNTR_COUNT_1           BIT1
#define  PDB0_CNTR_COUNT_2           BIT2
#define  PDB0_CNTR_COUNT_3           BIT3
#define  PDB0_CNTR_COUNT_4           BIT4
#define  PDB0_CNTR_COUNT_5           BIT5
#define  PDB0_CNTR_COUNT_6           BIT6
#define  PDB0_CNTR_COUNT_7           BIT7
#define  PDB0_CNTR_COUNT_8           BIT8
#define  PDB0_CNTR_COUNT_9           BIT9
#define  PDB0_CNTR_COUNT_10          BIT10
#define  PDB0_CNTR_COUNT_11          BIT11
#define  PDB0_CNTR_COUNT_12          BIT12
#define  PDB0_CNTR_COUNT_13          BIT13
#define  PDB0_CNTR_COUNT_14          BIT14
#define  PDB0_CNTR_COUNT_15          BIT15

#define  PDB1_MCTRL_PDBEN            BIT0
//   PDB Module Enable
//     0b0 ==> Counter is off and all Trigger and PreTrigger outputs are low.
//     0b1 ==> Counter is enabled.

#define  PDB1_MCTRL_TRIGSEL          (BIT4|BIT5|BIT6)
//   Input Trigger Select
//     0b000 ==> TriggerIn0 is selected.
//     0b001 ==> TriggerIn1 is selected.
//     0b010 ==> TriggerIn2 is selected.
//     0b011 ==> TriggerIn3 is selected.
//     0b100 ==> TriggerIn4 is selected.
//     0b101 ==> TriggerIn5 is selected.
//     0b110 ==> TriggerIn6 is selected.
//     0b111 ==> SWTRIG is selected.
#define  PDB1_MCTRL_TRIGSEL_0        BIT4
#define  PDB1_MCTRL_TRIGSEL_1        BIT5
#define  PDB1_MCTRL_TRIGSEL_2        BIT6

#define  PDB1_MCTRL_SWTRIG           BIT7
//   Software Trigger

#define  PDB1_MCTRL_COIE             BIT8
//   Counter Overflow Interrupt Enable
//     0b0 ==> Counter roll over interrupt requests disabled.
//     0b1 ==> Counter roll over interrupt requests enabled.

#define  PDB1_MCTRL_COF              BIT9
//   Counter Overflow Flag

#define  PDB1_MCTRL_CONT             BIT10
//   Continuous Mode Enable
//     0b0 ==> Module is in one-shot mode.
//     0b1 ==> Module is in continuous mode.

#define  PDB1_MCTRL_LDOK             BIT11
//   Load OK

#define  PDB1_MCTRL_LDMOD            BIT12
//   Load Mode Select
//     0b0 ==> DELAY* and MOD registers are loaded into a set of buffers and take effect immediately after logic 1 is written to the MCTRL[LDOK] bit.
//     0b1 ==> DELAY* and MOD registers are loaded into a set of buffers and take effect when the counter rolls over or a trigger signal is received after logic 1 is written to the MCTRL[LDOK] bit.

#define  PDB1_MCTRL_PRESCALER        (BIT13|BIT14|BIT15)
//   Clock Prescaler Select
//     0b000 ==> Timer uses peripheral clock.
//     0b001 ==> Timer uses peripheral clock / 2.
//     0b010 ==> Timer uses peripheral clock / 4.
//     0b011 ==> Timer uses peripheral clock / 8.
//     0b100 ==> Timer uses peripheral clock / 16.
//     0b101 ==> Timer uses peripheral clock / 32.
//     0b110 ==> Timer uses peripheral clock / 64.
//     0b111 ==> Timer uses peripheral clock / 128.
#define  PDB1_MCTRL_PRESCALER_0      BIT13
#define  PDB1_MCTRL_PRESCALER_1      BIT14
#define  PDB1_MCTRL_PRESCALER_2      BIT15

#define  PDB1_CTRLA_ENB              BIT0
//   Trigger B Enable
//     0b0 ==> Trigger B is disabled and forced to 0.
//     0b1 ==> Trigger B is enabled.

#define  PDB1_CTRLA_ENA              BIT1
//   Trigger A Enable
//     0b0 ==> Trigger A is disabled and forced to 0.
//     0b1 ==> Trigger A is enabled.

#define  PDB1_CTRLA_BYPB             BIT2
//   Bypass B
//     0b0 ==> Trigger B is generated normally.
//     0b1 ==> Trigger B generation is bypassed and Trigger B is a single pulse created by the selected trigger source.

#define  PDB1_CTRLA_BYPA             BIT3
//   Bypass A
//     0b0 ==> Trigger A is generated normally.
//     0b1 ==> Trigger A generation is bypassed and Trigger A is a single pulse created by the selected trigger source.

#define  PDB1_CTRLA_ABSEL            BIT4
//   Trigger A Output Select
//     0b0 ==> Trigger A is a function of DELAYA only. Trigger B is a function of DELAYB only.
//     0b1 ==> Trigger A and Trigger B outputs are a function of combined DELAYA and DELAYB. Trigger A is an extended pulse (as in trigger pulsed output operation) and Trigger B is a dual pulse (as in two-shot mode with trigger configured for simultaneous sampling).

#define  PDB1_CTRLA_AINIT            BIT5
//   Initial Value A

#define  PDB1_CTRLA_DBIE             BIT8
//   Delay B Interrupt Enable
//     0b0 ==> DELAYB successful compare interrupt requests disabled.
//     0b1 ==> DELAYB successful compare interrupt requests enabled.

#define  PDB1_CTRLA_DBF              BIT9
//   Delay B Flag

#define  PDB1_CTRLA_DAIE             BIT10
//   Delay A Interrupt Enable
//     0b0 ==> DELAYA successful compare interrupt requests disabled.
//     0b1 ==> DELAYA successful compare interrupt requests enabled.

#define  PDB1_CTRLA_DAF              BIT11
//   Delay A Flag

#define  PDB1_CTRLA_FLENA            BIT12
//   Fault A Length
//     0b0 ==> Fault input must be active at least 2 IPBus clock cycles.
//     0b1 ==> Fault input must be active at least 4 IPBus clock cycles.

#define  PDB1_CTRLA_FPOLA            BIT13
//   Fault A Polarity
//     0b0 ==> A logic 0 on Fault A indicates a fault condition
//     0b1 ==> A logic 1 on Fault A indicates a fault condition.

#define  PDB1_CTRLA_FLTAEN           BIT14
//   Fault A Enable
//     0b0 ==> Fault A input is ignored.
//     0b1 ==> A logic 1 on the Fault A input forces TriggerA output to CTRLA[AINIT] until a counter reload occurs.

#define  PDB1_CTRLA_FLTA             BIT15
//   Fault A Input Status

#define  PDB1_CTRLC_END              BIT0
//   Trigger D Enable
//     0b0 ==> Trigger D is disabled and forced to 0.
//     0b1 ==> Trigger D is enabled.

#define  PDB1_CTRLC_ENC              BIT1
//   Trigger C Enable
//     0b0 ==> Trigger C is disabled and forced to 0.
//     0b1 ==> Trigger C is enabled.

#define  PDB1_CTRLC_BYPD             BIT2
//   Bypass D
//     0b0 ==> Trigger D is generated normally.
//     0b1 ==> Trigger D generation is bypassed and Trigger D is a single pulse created by the selected trigger source.

#define  PDB1_CTRLC_BYPC             BIT3
//   Bypass C
//     0b0 ==> Trigger C is generated normally.
//     0b1 ==> Trigger C generation is bypassed and Trigger C is a single pulse created by the selected trigger source.

#define  PDB1_CTRLC_CDSEL            BIT4
//   Trigger C Output Select
//     0b0 ==> Trigger C is a function of DELAYC only. Trigger D is a function of DELAYD only.
//     0b1 ==> Trigger C and Trigger D outputs are a function of combined DELAYC and DELAYD. Trigger C is an extended pulse (as in trigger pulsed output operation) and Trigger D is a dual pulse (as in two-shot mode with trigger configured for simultaneous sampling).

#define  PDB1_CTRLC_CINIT            BIT5
//   Initial Value C

#define  PDB1_CTRLC_DDIE             BIT8
//   Delay D Interrupt Enable
//     0b0 ==> DELAYD successful compare interrupt requests disabled.
//     0b1 ==> DELAYD successful compare interrupt requests enabled.

#define  PDB1_CTRLC_DDF              BIT9
//   Delay D Flag

#define  PDB1_CTRLC_DCIE             BIT10
//   Delay C Interrupt Enable
//     0b0 ==> DELAYC successful compare interrupt requests disabled.
//     0b1 ==> DELAYC successful compare interrupt requests enabled.

#define  PDB1_CTRLC_DCF              BIT11
//   Delay C Flag

#define  PDB1_CTRLC_FLENC            BIT12
//   Fault C Length
//     0b0 ==> Fault input must be active at least 2 IPBus clock cycles.
//     0b1 ==> Fault input must be active at least 4 IPBus clock cycles.

#define  PDB1_CTRLC_FPOLC            BIT13
//   Fault C Polarity
//     0b0 ==> A logic 0 on Fault C indicates a fault condition.
//     0b1 ==> A logic 1 on Fault C indicates a fault condition.

#define  PDB1_CTRLC_FLTCEN           BIT14
//   Fault C Enable.
//     0b0 ==> Fault C input is ignored.
//     0b1 ==> A logic 1 on the Fault C input forces Trigger C output to CTRLC[CINIT] until a counter reload occurs.

#define  PDB1_CTRLC_FLTC             BIT15
//   Fault C Input Status

#define  PDB1_DELAYA_DELAYA          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Delay A
#define  PDB1_DELAYA_DELAYA_0        BIT0
#define  PDB1_DELAYA_DELAYA_1        BIT1
#define  PDB1_DELAYA_DELAYA_2        BIT2
#define  PDB1_DELAYA_DELAYA_3        BIT3
#define  PDB1_DELAYA_DELAYA_4        BIT4
#define  PDB1_DELAYA_DELAYA_5        BIT5
#define  PDB1_DELAYA_DELAYA_6        BIT6
#define  PDB1_DELAYA_DELAYA_7        BIT7
#define  PDB1_DELAYA_DELAYA_8        BIT8
#define  PDB1_DELAYA_DELAYA_9        BIT9
#define  PDB1_DELAYA_DELAYA_10       BIT10
#define  PDB1_DELAYA_DELAYA_11       BIT11
#define  PDB1_DELAYA_DELAYA_12       BIT12
#define  PDB1_DELAYA_DELAYA_13       BIT13
#define  PDB1_DELAYA_DELAYA_14       BIT14
#define  PDB1_DELAYA_DELAYA_15       BIT15

#define  PDB1_DELAYB_DELAYB          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Delay B
#define  PDB1_DELAYB_DELAYB_0        BIT0
#define  PDB1_DELAYB_DELAYB_1        BIT1
#define  PDB1_DELAYB_DELAYB_2        BIT2
#define  PDB1_DELAYB_DELAYB_3        BIT3
#define  PDB1_DELAYB_DELAYB_4        BIT4
#define  PDB1_DELAYB_DELAYB_5        BIT5
#define  PDB1_DELAYB_DELAYB_6        BIT6
#define  PDB1_DELAYB_DELAYB_7        BIT7
#define  PDB1_DELAYB_DELAYB_8        BIT8
#define  PDB1_DELAYB_DELAYB_9        BIT9
#define  PDB1_DELAYB_DELAYB_10       BIT10
#define  PDB1_DELAYB_DELAYB_11       BIT11
#define  PDB1_DELAYB_DELAYB_12       BIT12
#define  PDB1_DELAYB_DELAYB_13       BIT13
#define  PDB1_DELAYB_DELAYB_14       BIT14
#define  PDB1_DELAYB_DELAYB_15       BIT15

#define  PDB1_DELAYC_DELAYC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Delay C
#define  PDB1_DELAYC_DELAYC_0        BIT0
#define  PDB1_DELAYC_DELAYC_1        BIT1
#define  PDB1_DELAYC_DELAYC_2        BIT2
#define  PDB1_DELAYC_DELAYC_3        BIT3
#define  PDB1_DELAYC_DELAYC_4        BIT4
#define  PDB1_DELAYC_DELAYC_5        BIT5
#define  PDB1_DELAYC_DELAYC_6        BIT6
#define  PDB1_DELAYC_DELAYC_7        BIT7
#define  PDB1_DELAYC_DELAYC_8        BIT8
#define  PDB1_DELAYC_DELAYC_9        BIT9
#define  PDB1_DELAYC_DELAYC_10       BIT10
#define  PDB1_DELAYC_DELAYC_11       BIT11
#define  PDB1_DELAYC_DELAYC_12       BIT12
#define  PDB1_DELAYC_DELAYC_13       BIT13
#define  PDB1_DELAYC_DELAYC_14       BIT14
#define  PDB1_DELAYC_DELAYC_15       BIT15

#define  PDB1_DELAYD_DELAYD          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Delay D
#define  PDB1_DELAYD_DELAYD_0        BIT0
#define  PDB1_DELAYD_DELAYD_1        BIT1
#define  PDB1_DELAYD_DELAYD_2        BIT2
#define  PDB1_DELAYD_DELAYD_3        BIT3
#define  PDB1_DELAYD_DELAYD_4        BIT4
#define  PDB1_DELAYD_DELAYD_5        BIT5
#define  PDB1_DELAYD_DELAYD_6        BIT6
#define  PDB1_DELAYD_DELAYD_7        BIT7
#define  PDB1_DELAYD_DELAYD_8        BIT8
#define  PDB1_DELAYD_DELAYD_9        BIT9
#define  PDB1_DELAYD_DELAYD_10       BIT10
#define  PDB1_DELAYD_DELAYD_11       BIT11
#define  PDB1_DELAYD_DELAYD_12       BIT12
#define  PDB1_DELAYD_DELAYD_13       BIT13
#define  PDB1_DELAYD_DELAYD_14       BIT14
#define  PDB1_DELAYD_DELAYD_15       BIT15

#define  PDB1_MOD_MOD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  PDB1_MOD_MOD_0              BIT0
#define  PDB1_MOD_MOD_1              BIT1
#define  PDB1_MOD_MOD_2              BIT2
#define  PDB1_MOD_MOD_3              BIT3
#define  PDB1_MOD_MOD_4              BIT4
#define  PDB1_MOD_MOD_5              BIT5
#define  PDB1_MOD_MOD_6              BIT6
#define  PDB1_MOD_MOD_7              BIT7
#define  PDB1_MOD_MOD_8              BIT8
#define  PDB1_MOD_MOD_9              BIT9
#define  PDB1_MOD_MOD_10             BIT10
#define  PDB1_MOD_MOD_11             BIT11
#define  PDB1_MOD_MOD_12             BIT12
#define  PDB1_MOD_MOD_13             BIT13
#define  PDB1_MOD_MOD_14             BIT14
#define  PDB1_MOD_MOD_15             BIT15

#define  PDB1_CNTR_COUNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  PDB1_CNTR_COUNT_0           BIT0
#define  PDB1_CNTR_COUNT_1           BIT1
#define  PDB1_CNTR_COUNT_2           BIT2
#define  PDB1_CNTR_COUNT_3           BIT3
#define  PDB1_CNTR_COUNT_4           BIT4
#define  PDB1_CNTR_COUNT_5           BIT5
#define  PDB1_CNTR_COUNT_6           BIT6
#define  PDB1_CNTR_COUNT_7           BIT7
#define  PDB1_CNTR_COUNT_8           BIT8
#define  PDB1_CNTR_COUNT_9           BIT9
#define  PDB1_CNTR_COUNT_10          BIT10
#define  PDB1_CNTR_COUNT_11          BIT11
#define  PDB1_CNTR_COUNT_12          BIT12
#define  PDB1_CNTR_COUNT_13          BIT13
#define  PDB1_CNTR_COUNT_14          BIT14
#define  PDB1_CNTR_COUNT_15          BIT15

#define  PIT0_CTRL_CNT_EN            BIT0
//   Count Enable
//     0b0 ==> PIT counter reset (default).
//     0b1 ==> PIT counter active.

#define  PIT0_CTRL_PRIE              BIT1
//   PIT Roll-Over Interrupt Enable.
//     0b0 ==> PIT roll-over interrupt disabled (default).
//     0b1 ==> PIT roll-over interrupt enabled.

#define  PIT0_CTRL_PRF               BIT2
//   PIT Roll-Over Flag.
//     0b0 ==> PIT counter has not reached the modulo value. (default)
//     0b1 ==> PIT counter has reached the modulo value.

#define  PIT0_CTRL_PRESCALER         (BIT3|BIT4|BIT5|BIT6)
//     0b0000 ==> Clock
//     0b0001 ==> Clock divided by 2
//     0b0010 ==> Clock divided by 4
//     0b0011 ==> Clock divided by 8
//     0b0100 ==> Clock divided by 16
//     0b0101 ==> Clock divided by 32
//     0b0110 ==> Clock divided by 64
//     0b0111 ==> Clock divided by 128
//     0b1000 ==> Clock divided by 256
//     0b1001 ==> Clock divided by 512
//     0b1010 ==> Clock divided by 1024
//     0b1011 ==> Clock divided by 2048
//     0b1100 ==> Clock divided by 4096
//     0b1101 ==> Clock divided by 8192
//     0b1110 ==> Clock divided by 16384
//     0b1111 ==> Clock divided by 32768
#define  PIT0_CTRL_PRESCALER_0       BIT3
#define  PIT0_CTRL_PRESCALER_1       BIT4
#define  PIT0_CTRL_PRESCALER_2       BIT5
#define  PIT0_CTRL_PRESCALER_3       BIT6

#define  PIT0_CTRL_CLKSEL            (BIT8|BIT9)
//     0b00 ==> Selects IPBus clock
//     0b01 ==> Selects alternate clock 1
//     0b10 ==> Selects alternate clock 2
//     0b11 ==> Selects alternate clock 3
#define  PIT0_CTRL_CLKSEL_0          BIT8
#define  PIT0_CTRL_CLKSEL_1          BIT9

#define  PIT0_CTRL_SLAVE             BIT15
//     0b0 ==> CNT_EN from this PIT is used to control operation (default).
//     0b1 ==> CNT_EN from master PIT is used to control operation.

#define  PIT0_MOD_MODULO_VALUE       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  PIT0_MOD_MODULO_VALUE_0     BIT0
#define  PIT0_MOD_MODULO_VALUE_1     BIT1
#define  PIT0_MOD_MODULO_VALUE_2     BIT2
#define  PIT0_MOD_MODULO_VALUE_3     BIT3
#define  PIT0_MOD_MODULO_VALUE_4     BIT4
#define  PIT0_MOD_MODULO_VALUE_5     BIT5
#define  PIT0_MOD_MODULO_VALUE_6     BIT6
#define  PIT0_MOD_MODULO_VALUE_7     BIT7
#define  PIT0_MOD_MODULO_VALUE_8     BIT8
#define  PIT0_MOD_MODULO_VALUE_9     BIT9
#define  PIT0_MOD_MODULO_VALUE_10    BIT10
#define  PIT0_MOD_MODULO_VALUE_11    BIT11
#define  PIT0_MOD_MODULO_VALUE_12    BIT12
#define  PIT0_MOD_MODULO_VALUE_13    BIT13
#define  PIT0_MOD_MODULO_VALUE_14    BIT14
#define  PIT0_MOD_MODULO_VALUE_15    BIT15

#define  PIT0_CNTR_COUNTER_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  PIT0_CNTR_COUNTER_VALUE_0   BIT0
#define  PIT0_CNTR_COUNTER_VALUE_1   BIT1
#define  PIT0_CNTR_COUNTER_VALUE_2   BIT2
#define  PIT0_CNTR_COUNTER_VALUE_3   BIT3
#define  PIT0_CNTR_COUNTER_VALUE_4   BIT4
#define  PIT0_CNTR_COUNTER_VALUE_5   BIT5
#define  PIT0_CNTR_COUNTER_VALUE_6   BIT6
#define  PIT0_CNTR_COUNTER_VALUE_7   BIT7
#define  PIT0_CNTR_COUNTER_VALUE_8   BIT8
#define  PIT0_CNTR_COUNTER_VALUE_9   BIT9
#define  PIT0_CNTR_COUNTER_VALUE_10  BIT10
#define  PIT0_CNTR_COUNTER_VALUE_11  BIT11
#define  PIT0_CNTR_COUNTER_VALUE_12  BIT12
#define  PIT0_CNTR_COUNTER_VALUE_13  BIT13
#define  PIT0_CNTR_COUNTER_VALUE_14  BIT14
#define  PIT0_CNTR_COUNTER_VALUE_15  BIT15

#define  PIT1_CTRL_CNT_EN            BIT0
//   Count Enable
//     0b0 ==> PIT counter reset (default).
//     0b1 ==> PIT counter active.

#define  PIT1_CTRL_PRIE              BIT1
//   PIT Roll-Over Interrupt Enable.
//     0b0 ==> PIT roll-over interrupt disabled (default).
//     0b1 ==> PIT roll-over interrupt enabled.

#define  PIT1_CTRL_PRF               BIT2
//   PIT Roll-Over Flag.
//     0b0 ==> PIT counter has not reached the modulo value. (default)
//     0b1 ==> PIT counter has reached the modulo value.

#define  PIT1_CTRL_PRESCALER         (BIT3|BIT4|BIT5|BIT6)
//     0b0000 ==> Clock
//     0b0001 ==> Clock divided by 2
//     0b0010 ==> Clock divided by 4
//     0b0011 ==> Clock divided by 8
//     0b0100 ==> Clock divided by 16
//     0b0101 ==> Clock divided by 32
//     0b0110 ==> Clock divided by 64
//     0b0111 ==> Clock divided by 128
//     0b1000 ==> Clock divided by 256
//     0b1001 ==> Clock divided by 512
//     0b1010 ==> Clock divided by 1024
//     0b1011 ==> Clock divided by 2048
//     0b1100 ==> Clock divided by 4096
//     0b1101 ==> Clock divided by 8192
//     0b1110 ==> Clock divided by 16384
//     0b1111 ==> Clock divided by 32768
#define  PIT1_CTRL_PRESCALER_0       BIT3
#define  PIT1_CTRL_PRESCALER_1       BIT4
#define  PIT1_CTRL_PRESCALER_2       BIT5
#define  PIT1_CTRL_PRESCALER_3       BIT6

#define  PIT1_CTRL_CLKSEL            (BIT8|BIT9)
//     0b00 ==> Selects IPBus clock
//     0b01 ==> Selects alternate clock 1
//     0b10 ==> Selects alternate clock 2
//     0b11 ==> Selects alternate clock 3
#define  PIT1_CTRL_CLKSEL_0          BIT8
#define  PIT1_CTRL_CLKSEL_1          BIT9

#define  PIT1_CTRL_SLAVE             BIT15
//     0b0 ==> CNT_EN from this PIT is used to control operation (default).
//     0b1 ==> CNT_EN from master PIT is used to control operation.

#define  PIT1_MOD_MODULO_VALUE       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  PIT1_MOD_MODULO_VALUE_0     BIT0
#define  PIT1_MOD_MODULO_VALUE_1     BIT1
#define  PIT1_MOD_MODULO_VALUE_2     BIT2
#define  PIT1_MOD_MODULO_VALUE_3     BIT3
#define  PIT1_MOD_MODULO_VALUE_4     BIT4
#define  PIT1_MOD_MODULO_VALUE_5     BIT5
#define  PIT1_MOD_MODULO_VALUE_6     BIT6
#define  PIT1_MOD_MODULO_VALUE_7     BIT7
#define  PIT1_MOD_MODULO_VALUE_8     BIT8
#define  PIT1_MOD_MODULO_VALUE_9     BIT9
#define  PIT1_MOD_MODULO_VALUE_10    BIT10
#define  PIT1_MOD_MODULO_VALUE_11    BIT11
#define  PIT1_MOD_MODULO_VALUE_12    BIT12
#define  PIT1_MOD_MODULO_VALUE_13    BIT13
#define  PIT1_MOD_MODULO_VALUE_14    BIT14
#define  PIT1_MOD_MODULO_VALUE_15    BIT15

#define  PIT1_CNTR_COUNTER_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
#define  PIT1_CNTR_COUNTER_VALUE_0   BIT0
#define  PIT1_CNTR_COUNTER_VALUE_1   BIT1
#define  PIT1_CNTR_COUNTER_VALUE_2   BIT2
#define  PIT1_CNTR_COUNTER_VALUE_3   BIT3
#define  PIT1_CNTR_COUNTER_VALUE_4   BIT4
#define  PIT1_CNTR_COUNTER_VALUE_5   BIT5
#define  PIT1_CNTR_COUNTER_VALUE_6   BIT6
#define  PIT1_CNTR_COUNTER_VALUE_7   BIT7
#define  PIT1_CNTR_COUNTER_VALUE_8   BIT8
#define  PIT1_CNTR_COUNTER_VALUE_9   BIT9
#define  PIT1_CNTR_COUNTER_VALUE_10  BIT10
#define  PIT1_CNTR_COUNTER_VALUE_11  BIT11
#define  PIT1_CNTR_COUNTER_VALUE_12  BIT12
#define  PIT1_CNTR_COUNTER_VALUE_13  BIT13
#define  PIT1_CNTR_COUNTER_VALUE_14  BIT14
#define  PIT1_CNTR_COUNTER_VALUE_15  BIT15

#define  PMC_CTRL_LV22IE             BIT0
//   2.2 V Low Voltage Interrupt Enable
//     0b0 ==> Disable setting the low voltage interrupt.
//     0b1 ==> Enable setting the low voltage interrupt.

#define  PMC_CTRL_LV27IE             BIT1
//   2.7 V Low Voltage Interrupt Enable
//     0b0 ==> Disable setting the low voltage interrupt.
//     0b1 ==> Enable setting the low voltage interrupt.

#define  PMC_CTRL_HV22IE             BIT2
//   2.2 V High Voltage Interrupt Enable
//     0b0 ==> Disable setting the high voltage interrupt.
//     0b1 ==> Enable setting the high voltage interrupt.

#define  PMC_CTRL_HV27IE             BIT3
//   2.7 V High Voltage Interrupt Enable
//     0b0 ==> Disable setting the high voltage interrupt.
//     0b1 ==> Enable setting the high voltage interrupt.

#define  PMC_CTRL_VRBEN              BIT7
//   Voltage Reference Buffer Enable
//     0b0 ==> Disable voltage reference buffering.
//     0b1 ==> Enable voltage reference buffering.

#define  PMC_CTRL_TRIM               (BIT12|BIT13|BIT14|BIT15)
//   Bandgap Trim
#define  PMC_CTRL_TRIM_0             BIT12
#define  PMC_CTRL_TRIM_1             BIT13
#define  PMC_CTRL_TRIM_2             BIT14
#define  PMC_CTRL_TRIM_3             BIT15

#define  PMC_STS_LV22F               BIT0
//   2.2 V Low Voltage Flag
//     0b0 ==> 3.3 V supply is not below the 2.2 V threshold.
//     0b1 ==> 3.3 V supply is below the 2.2 V threshold.

#define  PMC_STS_LV27F               BIT1
//   2.7 V Low Voltage Flag
//     0b0 ==> 3.3 V supply is not below the 2.7 V threshold.
//     0b1 ==> 3.3 V supply is below the 2.7 V threshold.

#define  PMC_STS_SLV22F              BIT2
//   Sticky 2.2 V Low Voltage Flag
//     0b0 ==> 3.3 V supply has not dropped below the 2.2 V threshold.
//     0b1 ==> 3.3 V supply has dropped below the 2.2 V threshold.

#define  PMC_STS_SLV27F              BIT3
//   Sticky 2.7 V Low Voltage Flag
//     0b0 ==> 3.3 V supply has not dropped below the 2.7 V threshold.
//     0b1 ==> 3.3 V supply has dropped below the 2.7 V threshold.

#define  PMC_STS_LVI                 BIT4
//   Low Voltage Interrupt
//     0b0 ==> Low voltage interrupt cleared.
//     0b1 ==> Low voltage interrupt asserted.

#define  PMC_STS_SR27                BIT5
//   Small Regulator 2.7 V Active Flag
//     0b0 ==> The small regulator 2.7 V supply is not ready to be used.
//     0b1 ==> The small regulator 2.7 V supply is ready to be used.

#define  PWMA_SM0CNT_CNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Counter Register Bits
#define  PWMA_SM0CNT_CNT_0           BIT0
#define  PWMA_SM0CNT_CNT_1           BIT1
#define  PWMA_SM0CNT_CNT_2           BIT2
#define  PWMA_SM0CNT_CNT_3           BIT3
#define  PWMA_SM0CNT_CNT_4           BIT4
#define  PWMA_SM0CNT_CNT_5           BIT5
#define  PWMA_SM0CNT_CNT_6           BIT6
#define  PWMA_SM0CNT_CNT_7           BIT7
#define  PWMA_SM0CNT_CNT_8           BIT8
#define  PWMA_SM0CNT_CNT_9           BIT9
#define  PWMA_SM0CNT_CNT_10          BIT10
#define  PWMA_SM0CNT_CNT_11          BIT11
#define  PWMA_SM0CNT_CNT_12          BIT12
#define  PWMA_SM0CNT_CNT_13          BIT13
#define  PWMA_SM0CNT_CNT_14          BIT14
#define  PWMA_SM0CNT_CNT_15          BIT15

#define  PWMA_SM0INIT_INIT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Initial Count Register Bits
#define  PWMA_SM0INIT_INIT_0         BIT0
#define  PWMA_SM0INIT_INIT_1         BIT1
#define  PWMA_SM0INIT_INIT_2         BIT2
#define  PWMA_SM0INIT_INIT_3         BIT3
#define  PWMA_SM0INIT_INIT_4         BIT4
#define  PWMA_SM0INIT_INIT_5         BIT5
#define  PWMA_SM0INIT_INIT_6         BIT6
#define  PWMA_SM0INIT_INIT_7         BIT7
#define  PWMA_SM0INIT_INIT_8         BIT8
#define  PWMA_SM0INIT_INIT_9         BIT9
#define  PWMA_SM0INIT_INIT_10        BIT10
#define  PWMA_SM0INIT_INIT_11        BIT11
#define  PWMA_SM0INIT_INIT_12        BIT12
#define  PWMA_SM0INIT_INIT_13        BIT13
#define  PWMA_SM0INIT_INIT_14        BIT14
#define  PWMA_SM0INIT_INIT_15        BIT15

#define  PWMA_SM0CTRL2_CLK_SEL       (BIT0|BIT1)
//   Clock Source Select
//     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
//     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
//     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
//     0b11 ==> reserved
#define  PWMA_SM0CTRL2_CLK_SEL_0     BIT0
#define  PWMA_SM0CTRL2_CLK_SEL_1     BIT1

#define  PWMA_SM0CTRL2_RELOAD_SEL    BIT2
//   Reload Source Select
//     0b0 ==> The local RELOAD signal is used to reload registers.
//     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

#define  PWMA_SM0CTRL2_FORCE_SEL     (BIT3|BIT4|BIT5)
//   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
//     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
//     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
//     0b010 ==> The local reload signal from this submodule is used to force updates.
//     0b011 ==> The master reload signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
//     0b100 ==> The local sync signal from this submodule is used to force updates.
//     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
//     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
//     0b111 ==> reserved
#define  PWMA_SM0CTRL2_FORCE_SEL_0   BIT3
#define  PWMA_SM0CTRL2_FORCE_SEL_1   BIT4
#define  PWMA_SM0CTRL2_FORCE_SEL_2   BIT5

#define  PWMA_SM0CTRL2_FORCE         BIT6
//   Force Initialization

#define  PWMA_SM0CTRL2_FRCEN         BIT7
//   Force Initialization Enable
//     0b0 ==> Initialization from a FORCE_OUT event is disabled.
//     0b1 ==> Initialization from a FORCE_OUT event is enabled.

#define  PWMA_SM0CTRL2_INIT_SEL      (BIT8|BIT9)
//   Initialization Control Select
//     0b00 ==> Local sync (PWM_X) causes initialization.
//     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
//     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
//     0b11 ==> EXT_SYNC causes initialization.
#define  PWMA_SM0CTRL2_INIT_SEL_0    BIT8
#define  PWMA_SM0CTRL2_INIT_SEL_1    BIT9

#define  PWMA_SM0CTRL2_PWMX_INIT     BIT10
//   PWM_X Initial Value

#define  PWMA_SM0CTRL2_PWM45_INIT    BIT11
//   PWM45 Initial Value

#define  PWMA_SM0CTRL2_PWM23_INIT    BIT12
//   PWM23 Initial Value

#define  PWMA_SM0CTRL2_INDEP         BIT13
//   Independent or Complementary Pair Operation
//     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
//     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

#define  PWMA_SM0CTRL2_WAITEN        BIT14
//   WAIT Enable

#define  PWMA_SM0CTRL2_DBGEN         BIT15
//   Debug Enable

#define  PWMA_SM0CTRL_DBLEN          BIT0
//   Double Switching Enable
//     0b0 ==> Double switching disabled.
//     0b1 ==> Double switching enabled.

#define  PWMA_SM0CTRL_DBLX           BIT1
//   PWMX Double Switching Enable
//     0b0 ==> PWMX double pulse disabled
//     0b1 ==> PWMX double pulse enabled

#define  PWMA_SM0CTRL_LDMOD          BIT2
//   Load Mode Select
//     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
//     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set.

#define  PWMA_SM0CTRL_PRSC           (BIT4|BIT5|BIT6)
//   Prescaler
//     0b000 ==> PWM clock frequency = fclk
//     0b001 ==> PWM clock frequency = fclk/2
//     0b010 ==> PWM clock frequency = fclk/4
//     0b011 ==> PWM clock frequency = fclk/8
//     0b100 ==> PWM clock frequency = fclk/16
//     0b101 ==> PWM clock frequency = fclk/32
//     0b110 ==> PWM clock frequency = fclk/64
//     0b111 ==> PWM clock frequency = fclk/128
#define  PWMA_SM0CTRL_PRSC_0         BIT4
#define  PWMA_SM0CTRL_PRSC_1         BIT5
#define  PWMA_SM0CTRL_PRSC_2         BIT6

#define  PWMA_SM0CTRL_DT             (BIT8|BIT9)
//   Deadtime
#define  PWMA_SM0CTRL_DT_0           BIT8
#define  PWMA_SM0CTRL_DT_1           BIT9

#define  PWMA_SM0CTRL_FULL           BIT10
//   Full Cycle Reload
//     0b0 ==> Full-cycle reloads disabled.
//     0b1 ==> Full-cycle reloads enabled.

#define  PWMA_SM0CTRL_HALF           BIT11
//   Half Cycle Reload
//     0b0 ==> Half-cycle reloads disabled.
//     0b1 ==> Half-cycle reloads enabled.

#define  PWMA_SM0CTRL_LDFQ           (BIT12|BIT13|BIT14|BIT15)
//     0b0000 ==> Every PWM opportunity
//     0b0001 ==> Every 2 PWM opportunities
//     0b0010 ==> Every 3 PWM opportunities
//     0b0011 ==> Every 4 PWM opportunities
//     0b0100 ==> Every 5 PWM opportunities
//     0b0101 ==> Every 6 PWM opportunities
//     0b0110 ==> Every 7 PWM opportunities
//     0b0111 ==> Every 8 PWM opportunities
//     0b1000 ==> Every 9 PWM opportunities
//     0b1001 ==> Every 10 PWM opportunities
//     0b1010 ==> Every 11 PWM opportunities
//     0b1011 ==> Every 12 PWM opportunities
//     0b1100 ==> Every 13 PWM opportunities
//     0b1101 ==> Every 14 PWM opportunities
//     0b1110 ==> Every 15 PWM opportunities
//     0b1111 ==> Every 16 PWM opportunities
#define  PWMA_SM0CTRL_LDFQ_0         BIT12
#define  PWMA_SM0CTRL_LDFQ_1         BIT13
#define  PWMA_SM0CTRL_LDFQ_2         BIT14
#define  PWMA_SM0CTRL_LDFQ_3         BIT15

#define  PWMA_SM0VAL0_VAL0           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Value Register 0
#define  PWMA_SM0VAL0_VAL0_0         BIT0
#define  PWMA_SM0VAL0_VAL0_1         BIT1
#define  PWMA_SM0VAL0_VAL0_2         BIT2
#define  PWMA_SM0VAL0_VAL0_3         BIT3
#define  PWMA_SM0VAL0_VAL0_4         BIT4
#define  PWMA_SM0VAL0_VAL0_5         BIT5
#define  PWMA_SM0VAL0_VAL0_6         BIT6
#define  PWMA_SM0VAL0_VAL0_7         BIT7
#define  PWMA_SM0VAL0_VAL0_8         BIT8
#define  PWMA_SM0VAL0_VAL0_9         BIT9
#define  PWMA_SM0VAL0_VAL0_10        BIT10
#define  PWMA_SM0VAL0_VAL0_11        BIT11
#define  PWMA_SM0VAL0_VAL0_12        BIT12
#define  PWMA_SM0VAL0_VAL0_13        BIT13
#define  PWMA_SM0VAL0_VAL0_14        BIT14
#define  PWMA_SM0VAL0_VAL0_15        BIT15

#define  PWMA_SM0FRACVAL1_FRACVAL1   (BIT11|BIT12|BIT13|BIT14|BIT15)
//   Fractional Value 1 Register
#define  PWMA_SM0FRACVAL1_FRACVAL1_0 BIT11
#define  PWMA_SM0FRACVAL1_FRACVAL1_1 BIT12
#define  PWMA_SM0FRACVAL1_FRACVAL1_2 BIT13
#define  PWMA_SM0FRACVAL1_FRACVAL1_3 BIT14
#define  PWMA_SM0FRACVAL1_FRACVAL1_4 BIT15

#define  PWMA_SM0VAL1_VAL1           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Value Register 1
#define  PWMA_SM0VAL1_VAL1_0         BIT0
#define  PWMA_SM0VAL1_VAL1_1         BIT1
#define  PWMA_SM0VAL1_VAL1_2         BIT2
#define  PWMA_SM0VAL1_VAL1_3         BIT3
#define  PWMA_SM0VAL1_VAL1_4         BIT4
#define  PWMA_SM0VAL1_VAL1_5         BIT5
#define  PWMA_SM0VAL1_VAL1_6         BIT6
#define  PWMA_SM0VAL1_VAL1_7         BIT7
#define  PWMA_SM0VAL1_VAL1_8         BIT8
#define  PWMA_SM0VAL1_VAL1_9         BIT9
#define  PWMA_SM0VAL1_VAL1_10        BIT10
#define  PWMA_SM0VAL1_VAL1_11        BIT11
#define  PWMA_SM0VAL1_VAL1_12        BIT12
#define  PWMA_SM0VAL1_VAL1_13        BIT13
#define  PWMA_SM0VAL1_VAL1_14        BIT14
#define  PWMA_SM0VAL1_VAL1_15        BIT15

#define  PWMA_SM0FRACVAL2_FRACVAL2   (BIT11|BIT12|BIT13|BIT14|BIT15)
//   Fractional Value 2
#define  PWMA_SM0FRACVAL2_FRACVAL2_0 BIT11
#define  PWMA_SM0FRACVAL2_FRACVAL2_1 BIT12
#define  PWMA_SM0FRACVAL2_FRACVAL2_2 BIT13
#define  PWMA_SM0FRACVAL2_FRACVAL2_3 BIT14
#define  PWMA_SM0FRACVAL2_FRACVAL2_4 BIT15

#define  PWMA_SM0VAL2_VAL2           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Value Register 2
#define  PWMA_SM0VAL2_VAL2_0         BIT0
#define  PWMA_SM0VAL2_VAL2_1         BIT1
#define  PWMA_SM0VAL2_VAL2_2         BIT2
#define  PWMA_SM0VAL2_VAL2_3         BIT3
#define  PWMA_SM0VAL2_VAL2_4         BIT4
#define  PWMA_SM0VAL2_VAL2_5         BIT5
#define  PWMA_SM0VAL2_VAL2_6         BIT6
#define  PWMA_SM0VAL2_VAL2_7         BIT7
#define  PWMA_SM0VAL2_VAL2_8         BIT8
#define  PWMA_SM0VAL2_VAL2_9         BIT9
#define  PWMA_SM0VAL2_VAL2_10        BIT10
#define  PWMA_SM0VAL2_VAL2_11        BIT11
#define  PWMA_SM0VAL2_VAL2_12        BIT12
#define  PWMA_SM0VAL2_VAL2_13        BIT13
#define  PWMA_SM0VAL2_VAL2_14        BIT14
#define  PWMA_SM0VAL2_VAL2_15        BIT15

#define  PWMA_SM0FRACVAL3_FRACVAL3   (BIT11|BIT12|BIT13|BIT14|BIT15)
//   Fractional Value 3
#define  PWMA_SM0FRACVAL3_FRACVAL3_0 BIT11
#define  PWMA_SM0FRACVAL3_FRACVAL3_1 BIT12
#define  PWMA_SM0FRACVAL3_FRACVAL3_2 BIT13
#define  PWMA_SM0FRACVAL3_FRACVAL3_3 BIT14
#define  PWMA_SM0FRACVAL3_FRACVAL3_4 BIT15

#define  PWMA_SM0VAL3_VAL3           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Value Register 3
#define  PWMA_SM0VAL3_VAL3_0         BIT0
#define  PWMA_SM0VAL3_VAL3_1         BIT1
#define  PWMA_SM0VAL3_VAL3_2         BIT2
#define  PWMA_SM0VAL3_VAL3_3         BIT3
#define  PWMA_SM0VAL3_VAL3_4         BIT4
#define  PWMA_SM0VAL3_VAL3_5         BIT5
#define  PWMA_SM0VAL3_VAL3_6         BIT6
#define  PWMA_SM0VAL3_VAL3_7         BIT7
#define  PWMA_SM0VAL3_VAL3_8         BIT8
#define  PWMA_SM0VAL3_VAL3_9         BIT9
#define  PWMA_SM0VAL3_VAL3_10        BIT10
#define  PWMA_SM0VAL3_VAL3_11        BIT11
#define  PWMA_SM0VAL3_VAL3_12        BIT12
#define  PWMA_SM0VAL3_VAL3_13        BIT13
#define  PWMA_SM0VAL3_VAL3_14        BIT14
#define  PWMA_SM0VAL3_VAL3_15        BIT15

#define  PWMA_SM0FRACVAL4_FRACVAL4   (BIT11|BIT12|BIT13|BIT14|BIT15)
//   Fractional Value 4
#define  PWMA_SM0FRACVAL4_FRACVAL4_0 BIT11
#define  PWMA_SM0FRACVAL4_FRACVAL4_1 BIT12
#define  PWMA_SM0FRACVAL4_FRACVAL4_2 BIT13
#define  PWMA_SM0FRACVAL4_FRACVAL4_3 BIT14
#define  PWMA_SM0FRACVAL4_FRACVAL4_4 BIT15

#define  PWMA_SM0VAL4_VAL4           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Value Register 4
#define  PWMA_SM0VAL4_VAL4_0         BIT0
#define  PWMA_SM0VAL4_VAL4_1         BIT1
#define  PWMA_SM0VAL4_VAL4_2         BIT2
#define  PWMA_SM0VAL4_VAL4_3         BIT3
#define  PWMA_SM0VAL4_VAL4_4         BIT4
#define  PWMA_SM0VAL4_VAL4_5         BIT5
#define  PWMA_SM0VAL4_VAL4_6         BIT6
#define  PWMA_SM0VAL4_VAL4_7         BIT7
#define  PWMA_SM0VAL4_VAL4_8         BIT8
#define  PWMA_SM0VAL4_VAL4_9         BIT9
#define  PWMA_SM0VAL4_VAL4_10        BIT10
#define  PWMA_SM0VAL4_VAL4_11        BIT11
#define  PWMA_SM0VAL4_VAL4_12        BIT12
#define  PWMA_SM0VAL4_VAL4_13        BIT13
#define  PWMA_SM0VAL4_VAL4_14        BIT14
#define  PWMA_SM0VAL4_VAL4_15        BIT15

#define  PWMA_SM0FRACVAL5_FRACVAL5   (BIT11|BIT12|BIT13|BIT14|BIT15)
//   Fractional Value 5
#define  PWMA_SM0FRACVAL5_FRACVAL5_0 BIT11
#define  PWMA_SM0FRACVAL5_FRACVAL5_1 BIT12
#define  PWMA_SM0FRACVAL5_FRACVAL5_2 BIT13
#define  PWMA_SM0FRACVAL5_FRACVAL5_3 BIT14
#define  PWMA_SM0FRACVAL5_FRACVAL5_4 BIT15

#define  PWMA_SM0VAL5_VAL5           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Value Register 5
#define  PWMA_SM0VAL5_VAL5_0         BIT0
#define  PWMA_SM0VAL5_VAL5_1         BIT1
#define  PWMA_SM0VAL5_VAL5_2         BIT2
#define  PWMA_SM0VAL5_VAL5_3         BIT3
#define  PWMA_SM0VAL5_VAL5_4         BIT4
#define  PWMA_SM0VAL5_VAL5_5         BIT5
#define  PWMA_SM0VAL5_VAL5_6         BIT6
#define  PWMA_SM0VAL5_VAL5_7         BIT7
#define  PWMA_SM0VAL5_VAL5_8         BIT8
#define  PWMA_SM0VAL5_VAL5_9         BIT9
#define  PWMA_SM0VAL5_VAL5_10        BIT10
#define  PWMA_SM0VAL5_VAL5_11        BIT11
#define  PWMA_SM0VAL5_VAL5_12        BIT12
#define  PWMA_SM0VAL5_VAL5_13        BIT13
#define  PWMA_SM0VAL5_VAL5_14        BIT14
#define  PWMA_SM0VAL5_VAL5_15        BIT15

#define  PWMA_SM0FRCTRL_FRAC1_EN     BIT1
//   Fractional Cycle PWM Period Enable
//     0b0 ==> Disable fractional cycle length for the PWM period.
//     0b1 ==> Enable fractional cycle length for the PWM period.

#define  PWMA_SM0FRCTRL_FRAC23_EN    BIT2
//   Fractional Cycle Placement Enable fpr PWM_A
//     0b0 ==> Disable fractional cycle placement for PWM_A.
//     0b1 ==> Enable fractional cycle placement for PWM_A.

#define  PWMA_SM0FRCTRL_FRAC45_EN    BIT4
//   Fractional Cycle Placement Enable fpr PWM_B
//     0b0 ==> Disable fractional cycle placement for PWM_B.
//     0b1 ==> Enable fractional cycle placement for PWM_B.

#define  PWMA_SM0FRCTRL_FRAC_PU      BIT8
//   Fractional Delay Circuit Power Up
//     0b0 ==> Turn off fractional delay logic.
//     0b1 ==> Power up fractional delay logic.

#define  PWMA_SM0FRCTRL_TEST         BIT15
//   Test Status Bit

#define  PWMA_SM0OCTRL_PWMXFS        (BIT0|BIT1)
//   PWM_X Fault State
//     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
//     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
//     0b10 ==> Output is tristated.
//     0b11 ==> Output is tristated.
#define  PWMA_SM0OCTRL_PWMXFS_0      BIT0
#define  PWMA_SM0OCTRL_PWMXFS_1      BIT1

#define  PWMA_SM0OCTRL_PWMBFS        (BIT2|BIT3)
//   PWM_B Fault State
//     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
//     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
//     0b10 ==> Output is tristated.
//     0b11 ==> Output is tristated.
#define  PWMA_SM0OCTRL_PWMBFS_0      BIT2
#define  PWMA_SM0OCTRL_PWMBFS_1      BIT3

#define  PWMA_SM0OCTRL_PWMAFS        (BIT4|BIT5)
//   PWM_A Fault State
//     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
//     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
//     0b10 ==> Output is tristated.
//     0b11 ==> Output is tristated.
#define  PWMA_SM0OCTRL_PWMAFS_0      BIT4
#define  PWMA_SM0OCTRL_PWMAFS_1      BIT5

#define  PWMA_SM0OCTRL_POLX          BIT8
//   PWM_X Output Polarity
//     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
//     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

#define  PWMA_SM0OCTRL_POLB          BIT9
//   PWM_B Output Polarity
//     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
//     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

#define  PWMA_SM0OCTRL_POLA          BIT10
//   PWM_A Output Polarity
//     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
//     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

#define  PWMA_SM0OCTRL_PWMX_IN       BIT13
//   PWM_X Input

#define  PWMA_SM0OCTRL_PWMB_IN       BIT14
//   PWM_B Input

#define  PWMA_SM0OCTRL_PWMA_IN       BIT15
//   PWM_A Input

#define  PWMA_SM0STS_CMPF            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   Compare Flags
//     0b0 ==> No compare event has occurred for a particular VALx value.
//     0b1 ==> A compare event has occurred for a particular VALx value.
#define  PWMA_SM0STS_CMPF_0          BIT0
#define  PWMA_SM0STS_CMPF_1          BIT1
#define  PWMA_SM0STS_CMPF_2          BIT2
#define  PWMA_SM0STS_CMPF_3          BIT3
#define  PWMA_SM0STS_CMPF_4          BIT4
#define  PWMA_SM0STS_CMPF_5          BIT5

#define  PWMA_SM0STS_CFX0            BIT6
//   Capture Flag X0

#define  PWMA_SM0STS_CFX1            BIT7
//   Capture Flag X1

#define  PWMA_SM0STS_CFB0            BIT8
//   Capture Flag B0

#define  PWMA_SM0STS_CFB1            BIT9
//   Capture Flag B1

#define  PWMA_SM0STS_CFA0            BIT10
//   Capture Flag A0

#define  PWMA_SM0STS_CFA1            BIT11
//   Capture Flag A1

#define  PWMA_SM0STS_RF              BIT12
//   Reload Flag
//     0b0 ==> No new reload cycle since last STS[RF] clearing
//     0b1 ==> New reload cycle since last STS[RF] clearing

#define  PWMA_SM0STS_REF             BIT13
//   Reload Error Flag
//     0b0 ==> No reload error occurred.
//     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

#define  PWMA_SM0STS_RUF             BIT14
//   Registers Updated Flag
//     0b0 ==> No register update has occurred since last reload.
//     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

#define  PWMA_SM0INTEN_CMPIE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   Compare Interrupt Enables
//     0b0 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
//     0b1 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
#define  PWMA_SM0INTEN_CMPIE_0       BIT0
#define  PWMA_SM0INTEN_CMPIE_1       BIT1
#define  PWMA_SM0INTEN_CMPIE_2       BIT2
#define  PWMA_SM0INTEN_CMPIE_3       BIT3
#define  PWMA_SM0INTEN_CMPIE_4       BIT4
#define  PWMA_SM0INTEN_CMPIE_5       BIT5

#define  PWMA_SM0INTEN_CX0IE         BIT6
//   Capture X 0 Interrupt Enable
//     0b0 ==> Interrupt request disabled for STS[CFX0].
//     0b1 ==> Interrupt request enabled for STS[CFX0].

#define  PWMA_SM0INTEN_CX1IE         BIT7
//   Capture X 1 Interrupt Enable
//     0b0 ==> Interrupt request disabled for STS[CFX1].
//     0b1 ==> Interrupt request enabled for STS[CFX1].

#define  PWMA_SM0INTEN_CB0IE         BIT8
//   Capture B 0 Interrupt Enable
//     0b0 ==> Interrupt request disabled for STS[CFB0].
//     0b1 ==> Interrupt request enabled for STS[CFB0].

#define  PWMA_SM0INTEN_CB1IE         BIT9
//   Capture B 1 Interrupt Enable
//     0b0 ==> Interrupt request disabled for STS[CFB1].
//     0b1 ==> Interrupt request enabled for STS[CFB1].

#define  PWMA_SM0INTEN_CA0IE         BIT10
//   Capture A 0 Interrupt Enable
//     0b0 ==> Interrupt request disabled for STS[CFA0].
//     0b1 ==> Interrupt request enabled for STS[CFA0].

#define  PWMA_SM0INTEN_CA1IE         BIT11
//   Capture A 1 Interrupt Enable
//     0b0 ==> Interrupt request disabled for STS[CFA1].
//     0b1 ==> Interrupt request enabled for STS[CFA1].

#define  PWMA_SM0INTEN_RIE           BIT12
//   Reload Interrupt Enable
//     0b0 ==> STS[RF] CPU interrupt requests disabled
//     0b1 ==> STS[RF] CPU interrupt requests enabled

#define  PWMA_SM0INTEN_REIE          BIT13
//   Reload Error Interrupt Enable
//     0b0 ==> STS[REF] CPU interrupt requests disabled
//     0b1 ==> STS[REF] CPU interrupt requests enabled

#define  PWMA_SM0DMAEN_CX0DE         BIT0
//   Capture X0 FIFO DMA Enable

#define  PWMA_SM0DMAEN_CX1DE         BIT1
//   Capture X1 FIFO DMA Enable

#define  PWMA_SM0DMAEN_CB0DE         BIT2
//   Capture B0 FIFO DMA Enable

#define  PWMA_SM0DMAEN_CB1DE         BIT3
//   Capture B1 FIFO DMA Enable

#define  PWMA_SM0DMAEN_CA0DE         BIT4
//   Capture A0 FIFO DMA Enable

#define  PWMA_SM0DMAEN_CA1DE         BIT5
//   Capture A1 FIFO DMA Enable

#define  PWMA_SM0DMAEN_CAPTDE        (BIT6|BIT7)
//   Capture DMA Enable Source Select
//     0b00 ==> Read DMA requests disabled.
//     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
//     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
//     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
#define  PWMA_SM0DMAEN_CAPTDE_0      BIT6
#define  PWMA_SM0DMAEN_CAPTDE_1      BIT7

#define  PWMA_SM0DMAEN_FAND          BIT8
//   FIFO Watermark AND Control
//     0b0 ==> Selected FIFO watermarks are OR'ed together.
//     0b1 ==> Selected FIFO watermarks are AND'ed together.

#define  PWMA_SM0DMAEN_VALDE         BIT9
//   Value Registers DMA Enable
//     0b0 ==> DMA write requests disabled
//     0b1 ==> DMA write requests for the VALx and FRACVALx registers enabled

#define  PWMA_SM0TCTRL_OUT_TRIG_EN   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
//   Output Trigger Enables
//     0b0 ==> PWM_OUT_TRIGx will not set when the counter value matches the VALx value.
//     0b1 ==> PWM_OUT_TRIGx will set when the counter value matches the VALx value.
#define  PWMA_SM0TCTRL_OUT_TRIG_EN_0 BIT0
#define  PWMA_SM0TCTRL_OUT_TRIG_EN_1 BIT1
#define  PWMA_SM0TCTRL_OUT_TRIG_EN_2 BIT2
#define  PWMA_SM0TCTRL_OUT_TRIG_EN_3 BIT3
#define  PWMA_SM0TCTRL_OUT_TRIG_EN_4 BIT4
#define  PWMA_SM0TCTRL_OUT_TRIG_EN_5 BIT5

#define  PWMA_SM0TCTRL_PWBOT1        BIT14
//   Output Trigger 1 Source Select
//     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_OUT_TRIG1 port.
//     0b1 ==> Route the PWMB output to the PWM_OUT_TRIG1 port.

#define  PWMA_SM0TCTRL_PWAOT0        BIT15
//   Output Trigger 0 Source Select
//     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_OUT_TRIG0 port.
//     0b1 ==> Route the PWMA output to the PWM_OUT_TRIG0 port.

#define  PWMA_SM0DISMAP0_DIS0A       (BIT0|BIT1|BIT2|BIT3)
//   PWM_A Fault Disable Mask 0
#define  PWMA_SM0DISMAP0_DIS0A_0     BIT0
#define  PWMA_SM0DISMAP0_DIS0A_1     BIT1
#define  PWMA_SM0DISMAP0_DIS0A_2     BIT2
#define  PWMA_SM0DISMAP0_DIS0A_3     BIT3

#define  PWMA_SM0DISMAP0_DIS0B       (BIT4|BIT5|BIT6|BIT7)
//   PWM_B Fault Disable Mask 0
#define  PWMA_SM0DISMAP0_DIS0B_0     BIT4
#define  PWMA_SM0DISMAP0_DIS0B_1     BIT5
#define  PWMA_SM0DISMAP0_DIS0B_2     BIT6
#define  PWMA_SM0DISMAP0_DIS0B_3     BIT7

#define  PWMA_SM0DISMAP0_DIS0X       (BIT8|BIT9|BIT10|BIT11)
//   PWM_X Fault Disable Mask 0
#define  PWMA_SM0DISMAP0_DIS0X_0     BIT8
#define  PWMA_SM0DISMAP0_DIS0X_1     BIT9
#define  PWMA_SM0DISMAP0_DIS0X_2     BIT10
#define  PWMA_SM0DISMAP0_DIS0X_3     BIT11

#define  PWMA_SM0DISMAP1_DIS1A       (BIT0|BIT1|BIT2|BIT3)
//   PWM_A Fault Disable Mask 1
#define  PWMA_SM0DISMAP1_DIS1A_0     BIT0
#define  PWMA_SM0DISMAP1_DIS1A_1     BIT1
#define  PWMA_SM0DISMAP1_DIS1A_2     BIT2
#define  PWMA_SM0DISMAP1_DIS1A_3     BIT3

#define  PWMA_SM0DISMAP1_DIS1B       (BIT4|BIT5|BIT6|BIT7)
//   PWM_B Fault Disable Mask 1
#define  PWMA_SM0DISMAP1_DIS1B_0     BIT4
#define  PWMA_SM0DISMAP1_DIS1B_1     BIT5
#define  PWMA_SM0DISMAP1_DIS1B_2     BIT6
#define  PWMA_SM0DISMAP1_DIS1B_3     BIT7

#define  PWMA_SM0DISMAP1_DIS1X       (BIT8|BIT9|BIT10|BIT11)
//   PWM_X Fault Disable Mask 1
#define  PWMA_SM0DISMAP1_DIS1X_0     BIT8
#define  PWMA_SM0DISMAP1_DIS1X_1     BIT9
#define  PWMA_SM0DISMAP1_DIS1X_2     BIT10
#define  PWMA_SM0DISMAP1_DIS1X_3     BIT11

#define  PWMA_SM0DTCNT0_DTCNT0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
//   Deadtime Count Register 0
#define  PWMA_SM0DTCNT0_DTCNT0_0     BIT0
#define  PWMA_SM0DTCNT0_DTCNT0_1     BIT1
#define  PWMA_SM0DTCNT0_DTCNT0_2     BIT2
#define  PWMA_SM0DTCNT0_DTCNT0_3     BIT3
#define  PWMA_SM0DTCNT0_DTCNT0_4     BIT4
#define  PWMA_SM0DTCNT0_DTCNT0_5     BIT5
#define  PWMA_SM0DTCNT0_DTCNT0_6     BIT6
#define  PWMA_SM0DTCNT0_DTCNT0_7     BIT7
#define  PWMA_SM0DTCNT0_DTCNT0_8     BIT8
#define  PWMA_SM0DTCNT0_DTCNT0_9     BIT9
#define  PWMA_SM0DTCNT0_DTCNT0_10    BIT10

#define  PWMA_SM0DTCNT1_DTCNT1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
//   Deadtime Count Register 1
#define  PWMA_SM0DTCNT1_DTCNT1_0     BIT0
#define  PWMA_SM0DTCNT1_DTCNT1_1     BIT1
#define  PWMA_SM0DTCNT1_DTCNT1_2     BIT2
#define  PWMA_SM0DTCNT1_DTCNT1_3     BIT3
#define  PWMA_SM0DTCNT1_DTCNT1_4     BIT4
#define  PWMA_SM0DTCNT1_DTCNT1_5     BIT5
#define  PWMA_SM0DTCNT1_DTCNT1_6     BIT6
#define  PWMA_SM0DTCNT1_DTCNT1_7     BIT7
#define  PWMA_SM0DTCNT1_DTCNT1_8     BIT8
#define  PWMA_SM0DTCNT1_DTCNT1_9     BIT9
#define  PWMA_SM0DTCNT1_DTCNT1_10    BIT10

#define  PWMA_SM0CAPTCTRLA_ARMA      BIT0
//   Arm A
//     0b0 ==> Input capture operation is disabled.
//     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

#define  PWMA_SM0CAPTCTRLA_ONESHOTA  BIT1
//   One Shot Mode A
//     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
//     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLA[ARMA] is cleared. No further captures will be performed until CAPTCTRLA[ARMA] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
//             capture circuit and CAPTCTRLA[ARMA] is then cleared.

#define  PWMA_SM0CAPTCTRLA_EDGA0     (BIT2|BIT3)
//   Edge A 0
//     0b00 ==> Disabled
//     0b01 ==> Capture falling edges
//     0b10 ==> Capture rising edges
//     0b11 ==> Capture any edge
#define  PWMA_SM0CAPTCTRLA_EDGA0_0   BIT2
#define  PWMA_SM0CAPTCTRLA_EDGA0_1   BIT3

#define  PWMA_SM0CAPTCTRLA_EDGA1     (BIT4|BIT5)
//   Edge A 1
//     0b00 ==> Disabled
//     0b01 ==> Capture falling edges
//     0b10 ==> Capture rising edges
//     0b11 ==> Capture any edge
#define  PWMA_SM0CAPTCTRLA_EDGA1_0   BIT4
#define  PWMA_SM0CAPTCTRLA_EDGA1_1   BIT5

#define  PWMA_SM0CAPTCTRLA_INP_SELA  BIT6
//   Input Select A
//     0b0 ==> Raw PWM_A input signal selected as source.
//     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLA[EDGA0] and CAPTCTRLA[EDGA1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRA[EDGA0] and/or CAPTCTRLA[EDGA1] fields in order to enable one or both of the capture registers.

#define  PWMA_SM0CAPTCTRLA_EDGCNTA_EN BIT7
//   Edge Counter A Enable
//     0b0 ==> Edge counter disabled and held in reset
//     0b1 ==> Edge counter enabled

#define  PWMA_SM0CAPTCTRLA_CFAWM     (BIT8|BIT9)
//   Capture A FIFOs Water Mark
#define  PWMA_SM0CAPTCTRLA_CFAWM_0   BIT8
#define  PWMA_SM0CAPTCTRLA_CFAWM_1   BIT9

#define  PWMA_SM0CAPTCTRLA_CA0CNT    (BIT10|BIT11|BIT12)
//   Capture A0 FIFO Word Count
#define  PWMA_SM0CAPTCTRLA_CA0CNT_0  BIT10
#define  PWMA_SM0CAPTCTRLA_CA0CNT_1  BIT11
#define  PWMA_SM0CAPTCTRLA_CA0CNT_2  BIT12

#define  PWMA_SM0CAPTCTRLA_CA1CNT    (BIT13|BIT14|BIT15)
//   Capture A1 FIFO Word Count
#define  PWMA_SM0CAPTCTRLA_CA1CNT_0  BIT13
#define  PWMA_SM0CAPTCTRLA_CA1CNT_1  BIT14
#define  PWMA_SM0CAPTCTRLA_CA1CNT_2  BIT15

#define  PWMA_SM0CAPTCOMPA_EDGCMPA   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Edge Compare A
#define  PWMA_SM0CAPTCOMPA_EDGCMPA_0 BIT0
#define  PWMA_SM0CAPTCOMPA_EDGCMPA_1 BIT1
#define  PWMA_SM0CAPTCOMPA_EDGCMPA_2 BIT2
#define  PWMA_SM0CAPTCOMPA_EDGCMPA_3 BIT3
#define  PWMA_SM0CAPTCOMPA_EDGCMPA_4 BIT4
#define  PWMA_SM0CAPTCOMPA_EDGCMPA_5 BIT5
#define  PWMA_SM0CAPTCOMPA_EDGCMPA_6 BIT6
#define  PWMA_SM0CAPTCOMPA_EDGCMPA_7 BIT7

#define  PWMA_SM0CAPTCOMPA_EDGCNTA   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Edge Counter A
#define  PWMA_SM0CAPTCOMPA_EDGCNTA_0 BIT8
#define  PWMA_SM0CAPTCOMPA_EDGCNTA_1 BIT9
#define  PWMA_SM0CAPTCOMPA_EDGCNTA_2 BIT10
#define  PWMA_SM0CAPTCOMPA_EDGCNTA_3 BIT11
#define  PWMA_SM0CAPTCOMPA_EDGCNTA_4 BIT12
#define  PWMA_SM0CAPTCOMPA_EDGCNTA_5 BIT13
#define  PWMA_SM0CAPTCOMPA_EDGCNTA_6 BIT14
#define  PWMA_SM0CAPTCOMPA_EDGCNTA_7 BIT15

#define  PWMA_SM0CAPTCTRLB_ARMB      BIT0
//   Arm B
//     0b0 ==> Input capture operation is disabled.
//     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

#define  PWMA_SM0CAPTCTRLB_ONESHOTB  BIT1
//   One Shot Mode B
//     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
//     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLB[ARMB] is cleared. No further captures will be performed until CAPTCTRLB[ARMB] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
//             capture circuit and CAPTCTRLB[ARMB] is then cleared.

#define  PWMA_SM0CAPTCTRLB_EDGB0     (BIT2|BIT3)
//   Edge B 0
//     0b00 ==> Disabled
//     0b01 ==> Capture falling edges
//     0b10 ==> Capture rising edges
//     0b11 ==> Capture any edge
#define  PWMA_SM0CAPTCTRLB_EDGB0_0   BIT2
#define  PWMA_SM0CAPTCTRLB_EDGB0_1   BIT3

#define  PWMA_SM0CAPTCTRLB_EDGB1     (BIT4|BIT5)
//   Edge B 1
//     0b00 ==> Disabled
//     0b01 ==> Capture falling edges
//     0b10 ==> Capture rising edges
//     0b11 ==> Capture any edge
#define  PWMA_SM0CAPTCTRLB_EDGB1_0   BIT4
#define  PWMA_SM0CAPTCTRLB_EDGB1_1   BIT5

#define  PWMA_SM0CAPTCTRLB_INP_SELB  BIT6
//   Input Select B
//     0b0 ==> Raw PWM_B input signal selected as source.
//     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLB[EDGB0] and CAPTCTRLB[EDGB1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRB[EDGB0] and/or CAPTCTRLB[EDGB1] fields in order to enable one or both of the capture registers.

#define  PWMA_SM0CAPTCTRLB_EDGCNTB_EN BIT7
//   Edge Counter B Enable
//     0b0 ==> Edge counter disabled and held in reset
//     0b1 ==> Edge counter enabled

#define  PWMA_SM0CAPTCTRLB_CFBWM     (BIT8|BIT9)
//   Capture B FIFOs Water Mark
#define  PWMA_SM0CAPTCTRLB_CFBWM_0   BIT8
#define  PWMA_SM0CAPTCTRLB_CFBWM_1   BIT9

#define  PWMA_SM0CAPTCTRLB_CB0CNT    (BIT10|BIT11|BIT12)
//   Capture B0 FIFO Word Count
#define  PWMA_SM0CAPTCTRLB_CB0CNT_0  BIT10
#define  PWMA_SM0CAPTCTRLB_CB0CNT_1  BIT11
#define  PWMA_SM0CAPTCTRLB_CB0CNT_2  BIT12

#define  PWMA_SM0CAPTCTRLB_CB1CNT    (BIT13|BIT14|BIT15)
//   Capture B1 FIFO Word Count
#define  PWMA_SM0CAPTCTRLB_CB1CNT_0  BIT13
#define  PWMA_SM0CAPTCTRLB_CB1CNT_1  BIT14
#define  PWMA_SM0CAPTCTRLB_CB1CNT_2  BIT15

#define  PWMA_SM0CAPTCOMPB_EDGCMPB   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
//   Edge Compare B
#define  PWMA_SM0CAPTCOMPB_EDGCMPB_0 BIT0
#define  PWMA_SM0CAPTCOMPB_EDGCMPB_1 BIT1
#define  PWMA_SM0CAPTCOMPB_EDGCMPB_2 BIT2
#define  PWMA_SM0CAPTCOMPB_EDGCMPB_3 BIT3
#define  PWMA_SM0CAPTCOMPB_EDGCMPB_4 BIT4
#define  PWMA_SM0CAPTCOMPB_EDGCMPB_5 BIT5
#define  PWMA_SM0CAPTCOMPB_EDGCMPB_6 BIT6
#define  PWMA_SM0CAPTCOMPB_EDGCMPB_7 BIT7

#define  PWMA_SM0CAPTCOMPB_EDGCNTB   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
//   Edge Counter B
#define  PWMA_SM0CAPTCOMPB_EDGCNTB_0 BIT8
#define  PWMA_SM0CAPTCOMPB_EDGCNTB_1 BIT9
#define  PWMA_SM0CAPTCOMPB_EDGCNTB_2 BIT10
#define  PWMA_SM0CAPTCOMPB_EDGCNTB_3 BIT11
#define  PWMA_SM0CAPTCOMPB_EDGCNTB_4 BIT12
#define  PWMA_SM0CAPTCOMPB_EDGCNTB_5 BIT13
#define  PWMA_SM0CAPTCOMPB_EDGCNTB_6 BIT14
#define  PWMA_SM0CAPTCOMPB_EDGCNTB_7 BIT15

#define  PWMA_SM0CAPTCTRLX_ARMX      BIT0
//   Arm X
//     0b0 ==> Input capture operation 