/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file      vector.c
*
* @version   1.0.4.0
* 
* @date      Mar-28-2012
* 
* @brief     MC9S12G128 Interrupt Vector Table.
*
*******************************************************************************/
#include "S12G128_devconfig.h"

#pragma CODE_SEG __NEAR_SEG NON_BANKED
static interrupt void dummy(void)
{
    asm "nop";
}

extern const void interrupt _Startup(void);


#ifdef IRQ_OFF_80_FCN
    extern void IRQ_OFF_80_FCN();
#endif

#ifdef IRQ_OFF_82_FCN
    extern void IRQ_OFF_84_FCN();
#endif

#ifdef IRQ_OFF_84_FCN
    extern void IRQ_OFF_84_FCN();
#endif

#ifdef IRQ_OFF_88_FCN
    extern void IRQ_OFF_88_FCN();
#endif

#ifdef IRQ_OFF_8A_FCN
    extern void IRQ_OFF_8A_FCN();
#endif

#ifdef IRQ_OFF_8C_FCN
    extern void IRQ_OFF_8C_FCN();
#endif

#ifdef IRQ_OFF_B0_FCN
    extern void IRQ_OFF_B0_FCN();
#endif

#ifdef IRQ_OFF_B2_FCN
    extern void IRQ_OFF_B2_FCN();
#endif

#ifdef IRQ_OFF_B4_FCN
    extern void IRQ_OFF_B4_FCN();
#endif

#ifdef IRQ_OFF_B6_FCN
    extern void IRQ_OFF_B6_FCN();
#endif

#ifdef IRQ_OFF_B8_FCN
    extern void IRQ_OFF_B8_FCN();
#endif

#ifdef IRQ_OFF_BA_FCN
    extern void IRQ_OFF_BA_FCN();
#endif

#ifdef IRQ_OFF_BC_FCN
    extern void IRQ_OFF_BC_FCN();
#endif

#ifdef IRQ_OFF_BE_FCN
    extern void IRQ_OFF_BE_FCN();
#endif

#ifdef IRQ_OFF_C2_FCN
    extern void IRQ_OFF_C2_FCN();
#endif

#ifdef IRQ_OFF_C6_FCN
    extern void IRQ_OFF_C6_FCN();
#endif

#ifdef IRQ_OFF_C8_FCN
    extern void IRQ_OFF_C8_FCN();
#endif

#ifdef IRQ_OFF_CC_FCN
    extern void IRQ_OFF_CC_FCN();
#endif

#ifdef IRQ_OFF_CE_FCN
    extern void IRQ_OFF_CE_FCN();
#endif

#ifdef IRQ_OFF_D2_FCN
    extern void IRQ_OFF_D2_FCN();
#endif

#ifdef IRQ_OFF_D4_FCN
    extern void IRQ_OFF_D4_FCN();
#endif

#ifdef IRQ_OFF_D6_FCN
    extern void IRQ_OFF_D6_FCN();
#endif

#ifdef IRQ_OFF_D8_FCN
    extern void IRQ_OFF_D8_FCN();
#endif

#ifdef IRQ_OFF_DA_FCN
    extern void IRQ_OFF_DA_FCN();
#endif

#ifdef IRQ_OFF_DC_FCN
    extern void IRQ_OFF_DC_FCN();
#endif

#ifdef IRQ_OFF_DE_FCN
    extern void IRQ_OFF_DE_FCN();
#endif

#ifdef IRQ_OFF_E0_FCN
    extern void IRQ_OFF_E0_FCN();
#endif

#ifdef IRQ_OFF_E2_FCN
    extern void IRQ_OFF_E2_FCN();
#endif

#ifdef IRQ_OFF_E4_FCN
    extern void IRQ_OFF_E4_FCN();
#endif

#ifdef IRQ_OFF_E6_FCN
    extern void IRQ_OFF_E6_FCN();
#endif

#ifdef IRQ_OFF_E8_FCN
    extern void IRQ_OFF_E8_FCN();
#endif

#ifdef IRQ_OFF_EA_FCN
    extern void IRQ_OFF_EA_FCN();
#endif

#ifdef IRQ_OFF_EC_FCN
    extern void IRQ_OFF_EC_FCN();
#endif

#ifdef IRQ_OFF_EE_FCN
    extern void IRQ_OFF_EE_FCN();
#endif

#ifdef IRQ_OFF_F0_FCN
    extern void IRQ_OFF_F0_FCN();
#endif

#ifdef IRQ_OFF_F2_FCN
    extern void IRQ_OFF_F2_FCN();
#endif

#ifdef IRQ_OFF_F4_FCN
    extern void IRQ_OFF_F4_FCN();
#endif

#ifdef IRQ_OFF_F6_FCN
    extern void IRQ_OFF_F6_FCN();
#endif

#ifdef IRQ_OFF_F8_FCN
    extern void IRQ_OFF_F8_FCN();
#endif

#ifdef IRQ_OFF_FA_FCN
    extern void IRQ_OFF_FA_FCN();
#endif

#ifdef IRQ_OFF_FC_FCN
    extern void IRQ_OFF_FC_FCN();
#endif

#ifdef IRQ_OFF_FE_FCN
    extern void IRQ_OFF_FE_FCN();
#endif

#pragma CONST_SEG ISR_VECTORS
void (* near const _vectab[])(void) @ 0xFF80 = \
{
    #ifdef IRQ_OFF_80_FCN   /* Spurious interrupt 0xFF80 */
        IRQ_OFF_80_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_82_FCN   /* Port AD interrupt 0xFF82 */
        IRQ_OFF_82_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_84_FCN   /* ADC compare interrupt 0xFF84 */
        IRQ_OFF_84_FCN,
    #else
        dummy,
    #endif
        dummy,              /* Reserved 0xFF86 */
    #ifdef IRQ_OFF_88_FCN   /* Autonomous periodical interrupt (API) 0xFF88 */
        IRQ_OFF_88_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_8A_FCN   /* Low-voltage interrupt (LVI) 0xFF8A */
        IRQ_OFF_8A_FCN,
    #else
        dummy,
    #endif
        dummy,              /* Reserved 0xFF8C */
    #ifdef IRQ_OFF_8E_FCN   /* Port P interrupt 0xFF8E */
        IRQ_OFF_8E_FCN,
    #else
        dummy,
    #endif
        dummy,              /* Reserved 0xFF90 */
        dummy,              /* Reserved 0xFF92 */
        dummy,              /* Reserved 0xFF94 */
        dummy,              /* Reserved 0xFF96 */
        dummy,              /* Reserved 0xFF98 */
        dummy,              /* Reserved 0xFF9A */
        dummy,              /* Reserved 0xFF9C */
        dummy,              /* Reserved 0xFF9E */
        dummy,              /* Reserved 0xFFA0 */
        dummy,              /* Reserved 0xFFA2 */
        dummy,              /* Reserved 0xFFA4 */
        dummy,              /* Reserved 0xFFA6 */
        dummy,              /* Reserved 0xFFA8 */
        dummy,              /* Reserved 0xFFAA */
        dummy,              /* Reserved 0xFFAC */
        dummy,              /* Reserved 0xFFAE */
    #ifdef IRQ_OFF_B0_FCN   /* CAN transmit 0xFFB0 */
        IRQ_OFF_B0_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_B2_FCN   /* CAN receive 0xFFB2 */
        IRQ_OFF_B2_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_B4_FCN   /* CAN errors 0xFFB4 */
        IRQ_OFF_B4_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_B6_FCN   /* CAN wake-up 0xFFB6 */
        IRQ_OFF_B6_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_B8_FCN   /* FLASH command 0xFFB8 */
        IRQ_OFF_B8_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_BA_FCN   /* FLASH error 0xFFBA */
        IRQ_OFF_BA_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_BC_FCN   /* SPI2 0xFFBC */
        IRQ_OFF_BC_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_BE_FCN   /* SPI1 0xFFBE */
        IRQ_OFF_BE_FCN,
    #else
        dummy,
    #endif
        dummy,              /* Reserved 0xFFC0 */
    #ifdef IRQ_OFF_C2_FCN   /* SCI2 0xFFC2 */
        IRQ_OFF_C2_FCN,
    #else
        dummy,
    #endif
        dummy,              /* Reserved 0xFFC4 */
    #ifdef IRQ_OFF_C6_FCN   /* PLL lock interrupt */
        IRQ_OFF_C6_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_C8_FCN   /* Oscillator status interrupt 0xFFC8 */
        IRQ_OFF_C8_FCN,
    #else
        dummy,
    #endif
        dummy,              /* Reserved 0xFFCA */
    #ifdef IRQ_OFF_CC_FCN   /* ACMP 0xFFCC */
        IRQ_OFF_CC_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_CE_FCN   /* Port J interrupt 0xFFCE */
        IRQ_OFF_CE_FCN,
    #else
        dummy,
    #endif
        dummy,              /* Reserved 0xFFD0 */
    #ifdef IRQ_OFF_D2_FCN   /* ADC 0xFFD2 */
        IRQ_OFF_D2_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_D4_FCN   /* SCI1 0xFFD4 */
        IRQ_OFF_D4_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_D6_FCN   /* SCI0 0xFFD6 */
        IRQ_OFF_D6_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_D8_FCN   /* SPI0 0xFFD8 */
        IRQ_OFF_D8_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_DA_FCN   /* TIM pulse accumulator input edge 0xFFDA */
        IRQ_OFF_DA_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_DC_FCN   /* TIM pulse accumulator A overflow 0xFFDC */
        IRQ_OFF_DC_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_DE_FCN   /* TIM timer overflow 0xFFDE */
        IRQ_OFF_DE_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_E0_FCN   /* TIM timer channel 7 0xFFE0 */
        IRQ_OFF_E0_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_E2_FCN   /* TIM timer channel 6 0xFFE2 */
        IRQ_OFF_E2_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_E4_FCN   /* TIM timer channel 5 0xFFE4 */
        IRQ_OFF_E4_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_E6_FCN   /* TIM timer channel 4 0xFFE6 */
        IRQ_OFF_E6_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_E8_FCN   /* TIM timer channel 3 0xFFE8 */
        IRQ_OFF_E8_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_EA_FCN   /* TIM timer channel 2 0xFFEA */
        IRQ_OFF_EA_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_EC_FCN   /* TIM timer channel 1 0xFFEC */
        IRQ_OFF_EC_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_EE_FCN   /* TIM timer channel 0 0xFFEE */
        IRQ_OFF_EE_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_F0_FCN   /* Real time interrupt 0xFFF0 */
        IRQ_OFF_F0_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_F2_FCN   /* IRQ 0xFFF2 */
        IRQ_OFF_F2_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_F4_FCN   /* XIRQ 0xFFF4 */
        IRQ_OFF_F4_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_F6_FCN   /* SWI 0xFFF6 */
        IRQ_OFF_F6_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_F8_FCN   /* Unimplemented instruction trap 0xFFF8 */
        IRQ_OFF_F8_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_FA_FCN   /* COP watchdog reset 0xFFFA */
        IRQ_OFF_FA_FCN,
    #else
        dummy,
    #endif
    #ifdef IRQ_OFF_FC_FCN   /* Clock monitor reset 0xFFFC */
        IRQ_OFF_FC_FCN,
    #else
        dummy,
    #endif
        _Startup            /* System reset or illegal access reset 0xFFFE */
};
#pragma CONST_SEG DEFAULT