/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     spi.h
*
* @author   B06050
* 
* @version  1.0.3.0
* 
* @date     Mar-28-2012
* 
* @brief    Serial Peripheral Interface SW module header file.
*
*******************************************************************************/
#ifndef _SPI_H
#define _SPI_H

/* Variable types and common definitions */
#include "derivative.h"
#include "typedefs.h"

/* SPIBaudRate = Bus_clock/BaudRateDivisor */
/* BaudRateDivisor = (SPPR+1)*2^(SPR+1) */
/* For SPIBaudRate = 3.125MHz and BusClock = 25MHz, BaudRateDivisor = 8 */
#define SPI_0_SPPR   0      /* (SPPR+1) = 1 */
#define SPI_0_SPR    2      /* 2^(SPR+1) = 8 */

/* Function prototypes */
void SPI_0_Init(void);
uint8_t SPI_0_SendByte(uint8_t data);
uint16_t SPI_0_SendWord(uint16_t data);

#endif /* _SPI_H */
