/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     S12G128_appconfig.h
*
* @author   B06050
* 
* @version  1.0.7.0
* 
* @date     Aug-20-2012
* 
* @brief    S12G128 BLDC sensorless motor control application configuration
*           parameter header file.
*
*******************************************************************************/
#define ALIGNMENT_TIME          200                 /* 200 ms Alignment time */
#define ALIGNMENT_DUTY_CYCLE    150                 /* 150 = 6us */

/* First commutation period @ fTIM1 = 1 MHz -> 819 ticks = 819us) */
#define START_FIRST_PERIOD      (819*40)//(781*40)

/* Number of commutation during start state */
#define START_CMT_CNT           8

/* Used in open loop start-up as accelerator constant  */
/* (commutation_period = commutation_period * 0.7711) */
#define START_CMT_ACCELERATION  FRAC16(0.7711)      /* 25268 */

/* Increments duty cycle every commutation during open-loop start-up */
#define START_DUTY_CYCLE_INC    6

/* next_cmt = TimerCNTwhileZCfound + ZC_period * ADVANCE_ANGLE */
#define ADVANCE_ANGLE           FRAC16(0.3815)      /* 12500 */

/* 220 * 1.28us = 300us -> time after CMT where Back-EMF is not sensed */
#define TIME_TOFF               300

/* MC33937 Deadtime + MC33937 high side turn ON time (in PWM clock ticks) */
#define DELAY                   25                  /* 1us @ 25MHz */

/* Back-EMF sensing point = duty_cycle * BEMF_SENSING_POINT_FRAC */
//#define BEMF_SENSING_POINT_FRAC FRAC16(0.66254)     /* 21710 */
#define BEMF_SENSING_POINT_FRAC FRAC16(0.5)         /* 19005 */

/* PWM period in ticks */
#define PWM_MODULO              1250                /* fBUS/20kHz */

/* Duty cycle limit for DC-Bus current measurement */
#define DC_THRESHOLD            234

/* Mechanical speed constant: SPEED_CALC_NUMERATOR = (60 * fTIM1) / 4 */
#define SPEED_CALC_NUMERATOR    15000000
#define SPEED_LOOP_PRESCALER    2                   /* Speed loop period 2ms */

#define STALLCHECK_MAX_ERRORS   6

/* Speed PI controller parameters */
#define SPEED_PI_UPPER_LIMIT    FRAC16(0.9)
#define SPEED_PI_LOWER_LIMIT    FRAC16(0.1) //0.175
#define SPEED_PI_CC1            FRAC16(0.01)
#define SPEED_PI_CC2            FRAC16(0.00)

/* Current PI controller parameters */
#define CURRENT_PI_UPPER_LIMIT    FRAC16(0.9)
#define CURRENT_PI_LOWER_LIMIT    FRAC16(0.1) //0.175
#define CURRENT_PI_CC1            FRAC16(0.01)
#define CURRENT_PI_CC2            FRAC16(0.04)

/* Voltage values used for scaling - determined by HW voltage sensing */
/* Vref=3.3V => Vdcb=<0,36.025>V, Idcb=<-10,10>A */
#define VOLT_RANGE_MAX          36.025
#define CURR_MAX                10.0
#define CURR_MIN                -10.0

/* DC-Bus braking trip voltage */
#define U_DCB_TRIP              27
/* DC-bus overvoltage limit */
#define DCBUS_OVERVOLT_THRESH   30

/* Current limitation threshold */
#define MAX_TORQUE              FRAC16(2.0/CURR_MAX)
#define TORQUE_FILT_CONST       FRAC16(0.16666667)

/* Min/max speed (RPM) */
#define MIN_SPEED               1000
#define MAX_SPEED               9000
#define SPEED_STEP              50

/* LED toggle periods (1ms timebase) */
#define PERIOD_FAULT            64
#define PERIOD_STOP             250

/* User button defines (1ms timebase) */
#define SW_PRESS_LONG           1000
#define SW_PRESS_SHORT_MAX      300
#define SW_PRESS_DEBOUNCE       20

/* FreeMASTER scale constants */
#define FM_U_SCALE              (VOLT_RANGE_MAX * 1000)
#define FM_I_SCALE              (CURR_MAX * 1000)