/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     pwm.h
*
* @author   B06050
* 
* @version  1.0.1.0
* 
* @date     Jul-10-2012
* 
* @brief    Pulse-Width Modulator SW module header file.
*
*******************************************************************************/
#ifndef _PWM_H
#define _PWM_H

/* Variable types and common definitions */
#include "derivative.h"

#define PWM_DISABLE     0x00    /* Disable all PWM channels */
#define PWM_ENABLE      0xAA    /* Enable PWM channels */

#define PWM_TRIG_EN     0x02    /* Enable PWM01 (ADC trigger) */

#define PWM_LS_RESET    0xF8    /* Low-side switches reset value (to be ANDed
                                   to the PORTA reg. value)*/
#define PWM_HS_ALIGN    0x82    /* Alignment state high-side PWM setup */
#define PWM_LS_ALIGN    0x07    /* Alignment state low-side control setup */

#define PWM_HS_SECT0    0x0A    /* Sector 0 high-side PWM setup */
#define PWM_LS_SECT0    0x03    /* Sector 0 low-side control setup */

#define PWM_HS_SECT1    0x0A    /* Sector 1 high-side PWM setup */
#define PWM_LS_SECT1    0x05    /* Sector 1 low-side control setup */

#define PWM_HS_SECT2    0x22    /* Sector 2 high-side PWM setup */
#define PWM_LS_SECT2    0x06    /* Sector 2 low-side control setup */

#define PWM_HS_SECT3    0x22    /* Sector 3 high-side PWM setup */
#define PWM_LS_SECT3    0x03    /* Sector 3 low-side control setup */

#define PWM_HS_SECT4    0x82    /* Sector 4 high-side PWM setup */
#define PWM_LS_SECT4    0x05    /* Sector 4 low-side control setup */

#define PWM_HS_SECT5    0x82    /* Sector 5 high-side PWM setup */
#define PWM_LS_SECT5    0x06    /* Sector 5 low-side control setup */

void PWM_Init(void);

#endif /* _PWM_H */