/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     api.c
*
* @author   B06050
* 
* @version  1.0.1.0
* 
* @date     Jul-10-2012
* 
* @brief    Autonomous periodic timer SW module source file.
*
*******************************************************************************/
#include "api.h"

/*******************************************************************************
*
* Function: void API_Delay(uint16_t u16period)
*
* Description:  This function generates a delay (blocking).
*
* Params[in]:   u16period       Delay period in API clock ticks
*
*******************************************************************************/
#pragma INLINE
void API_Delay(uint16_t u16period)
{
    CPMUAPIR = u16period;
    CPMUAPICTL = 0x80;  /* BUSclk source, external access disabled,
                           interrupt disabled */
    CPMUAPICTL |= 0x04; /* enable API */
    
    while(CPMUAPICTL_APIF != 1)
    {
    }
    CPMUAPICTL = 0x01;  /* Clear APIF flag and disable API */
}