/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     adc.h
*
* @author   B06050
* 
* @version  1.0.1.0
* 
* @date     Jul-10-2012
* 
* @brief    Analog-to-Digital Converter SW module header file.
*
*******************************************************************************/
#ifndef _ADC_H
#define _ADC_H

/* Variable types and common definitions */
#include "derivative.h"
#include "typedefs.h"

/* Mask to clear ATDCTL3[S8C,S4C,S2C,S1C] bits */
#define ADC_S_MASK      0x78

#define ADC_MULT_MODE   ATDCTL5_MULT_MASK

/* ADC channels number assignments */
#define ADC_INPUT_AN0   0x00
#define ADC_INPUT_AN1   0x01
#define ADC_INPUT_AN2   0x02
#define ADC_INPUT_AN3   0x03
#define ADC_INPUT_AN4   0x04
#define ADC_INPUT_AN5   0x05
#define ADC_DCBV_AN     0x06
#define ADC_TEMP_AN     0x07
#define ADC_SBC_MUX_AN  0x08

/* result registers definitions */
#define ADC_DCBI_RES    ATDDR0
#define ADC_DCBV_RES    ATDDR1

/* Function prototypes */
void ADC_Init(void);
void ADC_StartSingleConversion(uint8_t u8channel);
void ADC_EnableTrigSeq(uint8_t u8channel, uint8_t u8length);
void ADC_ModTrigSeqCh(uint8_t u8channel);

#endif /* _ADC_H */
