#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "ColdFire_Flash.h"
#include "srv_protection.h"
#include "msCANdrv.h"
#include "mcu.h"
#include "bootloader.h"

void CANMBsConfig(void);

void(*vfnptraCANBSM[])(void)= { vfnUnsec,
							    vfnSetAddr,
							    vfnLoadData,
							    vfnMassErase,
							    vfnSectErase,
							    vfnBurstProg,
							    vfnByteProg,
							    vfnBlankCheck,
							    vfnReadData,
							    vfnIdle};

/**********************************************************************/
/**********************************************************************/
/**********************************************************************/
const unsigned long Data @ 0x2000 = 0x31323334; //Test Var Remember to erase it at the end

//#pragma CODE_SEG DEFAULT
void main(void) 
{
	PTGPE |= 0x01;
	PTGDD &= ~(0x01 << 0);	
  vfnSwitchMode();	
  /*Bus clock 24Mhz*/
  SystemClockInit();
  /*Copy flash routines to RAM*/
  CopyInRAM();
  /*Initialize the flash clock divider; see BUS_CLOCK definition in ColdFire_Flash.h*/
  FlashInit();             
  /*Init MSCAN*/
  while(CAN_Init(FAST) != ERR_OK)
  {}
  CANMBsConfig(); /* config CAN message buffer */
  
  EnableInterrupts;

  u8gvbuffer = Idle; 
  for(;;) 
  {
    
    if(u8gvbuffer <= Idle)
    vfnptraCANBSM[u8gvbuffer]();
  }
}


