/******************************************************************************
*                                                       
*       Copyright (C) 2008 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     msCANvarlite.c                
*														                            
* Revision:      										                    
*														                            
* Functions:    msCAN driver lite variables 
*												                            
* Description:  
*
* Notes:        
*
******************************************************************************/

#ifndef MSCANVARLITE_C
#define MSCANVARLITE_C                /* this file */

#include "msCANstd.h"                   /* Standard defines */
#include "msCANdrv.h"                   /* General defines, enums, prototypes */
#include "msCANinc.h"                   /* Internal typedefs, prototypes */

/*****************************************************************************
Global Variables : static
*****************************************************************************/
static UINT8            MB_MSCAN[NO_OF_MSCAN_TXBUFFER];   /* Records which MB is in msCAN Transmit buffers */
static UINT8            MBP_MSCAN[NO_OF_MSCAN_TXBUFFER];  /* Records the Priority of each msCAN Transmit buffer */
static UINT8            DriverFlags;                      /* flags for driver */
static UINT8            LowestQueuedBuffer = 0xff;        /* the number of the lowest queued message for transmission */
static UINT8            AbortMessage = 0xff;              /* the number of the message that caused the abort */

static const UINT8      TX_BUFF0 = 0x01;
static const UINT8      TX_BUFF1 = 0x02;
static const UINT8      TX_BUFF2 = 0x04;

/*****************************************************************************
Global Variables : external
*****************************************************************************/
extern const UINT8      NoOfMB;
extern const UINT8      NoOfID;
extern const UINT8      TimeStampOption;
extern const UINT8      CANCTL0_Def;
extern const UINT8      CANCTL1_Def;
extern const UINT8      CANBTR0_Def;
extern const UINT8      CANBTR1_Def;
extern const UINT8      CANIDAC_Def;
extern const UINT8      CANIDFilter_Def[];

extern const UINT8      M_IdentifierType_CAN[];
extern const UINT32     M_Identifier_CAN[];

extern             UINT16     BufferTimeStamp_CAN[];
extern             UINT8      BufferID_Ref_CAN[];
extern             UINT8      BufferMode_CAN[];
extern             UINT8      BufferStatus_CAN[];
extern             UINT8      BufferDLC_CAN[];
extern             UINT8      BufferData_CAN[][8];

/*****************************************************************************/
#endif                                     /* end MSCANVARLITE_C */
