#ifndef MSCANREG_H
#define MSCANREG_H           /* This header file */
/******************************************************************************
*                                                       
*       Copyright (C) 2008 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     msCANreg.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    Defines msCAN registers
*														                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/******************************************************************************
 * Include 
 ******************************************************************************/
#include "msCANstd.h"
#include "derivative.h" /* include peripheral declarations */

/******************************************************************************
 * msCAN module registers 
 ******************************************************************************/

#define CANCTL0  		_CANCTL0.Byte
#define CANCTL1  	    _CANCTL1.Byte
#define CANBTR0  		_CANBTR0.Byte
#define CANBTR1  		_CANBTR1.Byte
#define CANRFLG  		_CANRFLG.Byte
#define CANRIER  		_CANRIER.Byte
#define CANTFLG  		_CANTFLG.Byte
#define CANTIER  		_CANTIER.Byte
#define CANTARQ  		_CANTARQ.Byte
#define CANTAAK  		_CANTAAK.Byte
#define CANTBSEL 		_CANTBSEL.Byte
#define CANIDAC  		_CANIDAC.Byte

#define CANRXERR 		_CANRXERR.Byte
#define CANTXERR 		_CANTXERR.Byte
#define CANIDAR0 		_CANIDAR0.Byte
#define CANIDAR1 		_CANIDAR1.Byte
#define CANIDAR2 		_CANIDAR2.Byte
#define CANIDAR3 		_CANIDAR3.Byte
#define CANIDMR0 		_CANIDMR0.Byte
#define CANIDMR1 		_CANIDMR1.Byte
#define CANIDMR2 		_CANIDMR2.Byte
#define CANIDMR3 		_CANIDMR3.Byte
#define CANIDAR4 		_CANIDAR4.Byte
#define CANIDAR5 		_CANIDAR5.Byte
#define CANIDAR6 		_CANIDAR6.Byte
#define CANIDAR7 		_CANIDAR7.Byte
#define CANIDMR4 		_CANIDMR4.Byte
#define CANIDMR5 	    _CANIDMR5.Byte
#define CANIDMR6 		_CANIDMR6.Byte
#define CANIDMR7 		_CANIDMR7.Byte
                	
#define RX_BUFF_IDR0    CANRIDR0
#define RX_BUFF_IDR1    CANRIDR1
#define RX_BUFF_IDR2    CANRIDR2
#define RX_BUFF_IDR3    CANRIDR3
#define RX_BUFF_DLR     _CANRDLR.Byte
#define RX_BUFF_TSR     _CANRTSR.Word

#define TX_BUFF_IDR0    CANTIDR0
#define TX_BUFF_IDR1    CANTIDR1
#define TX_BUFF_IDR2    CANTIDR2
#define TX_BUFF_IDR3    CANTIDR3
#define TX_BUFF_DLR     _CANTDLR.Byte
#define TX_BUFF_TBPR    _CANTTBPR.Byte
#define TX_BUFF_TSR     _CANTTSR.Word


/******************************************************************************
msCAN module bit defines 
******************************************************************************/
/* CANCTL0 */
#define INITRQ_MASK  0x01
#define SLPRQ_MASK   0x02
#define WUPE_MASK    0x04
#define TIME_MASK    0x08
#define SYNCH_MASK   0x10
#define CSWAI_MASK   0x20
#define RXACT_MASK   0x40
#define RXFRM_MASK   0x80

/* CANCTL1 */
#define INITAK_MASK  0x01
#define SLPAK_MASK   0x02

/* CANRFLG */
#define RXF_MASK     0x01
#define OVRIF_MASK   0x02
#define TSTAT0_MASK  0x04
#define TSTAT1_MASK  0x08
#define RSTAT0_MASK  0x10
#define RSTAT1_MASK  0x20
#define CSCIF_MASK   0x40
#define WUPIF_MASK   0x80
#define BUSOFF_MASK  0x0C

/* CANRIER */
#define RXFIE_MASK   0x01
#define OVRIE_MASK   0x02
#define TSTATE0_MASK 0x04
#define TSTATE1_MASK 0x08
#define RSTATE0_MASK 0x10
#define RSTATE1_MASK 0x20
#define CSCIE_MASK   0x40
#define WUPIE_MASK   0x80

/* TX BUFFERS */
#define IDR0_MASK    0x00
#define IDR1_MASK    0x01
#define IDR2_MASK    0x02
#define IDR3_MASK    0x03
#define DSR_MASK     0x04
#define DLR_MASK     0x0C
#define TBPR_MASK    0x0D
/*****************************************************************************/
#endif        /* end msCANreg.h */ 

