/*
 * bootloader.h
 *
 *  Created on: Feb 28, 2012
 *      Author: B31117
 */

#ifndef BOOTLOADER_H_
#define BOOTLOADER_H_

#define FLASHLASTADDRESS  0x20000
#define FLASHFIRSTADDRESS 0x02000
#define FLASHPCADDRESS    0x02004

/* Bridge commands to target */
#define BDG_UNSEC_TG           0x010U
#define BDG_SET_ADDR           0x011U
#define BDG_LOAD_DATA          0x012U
#define BDG_MASS_ERASE_TG      0x013U 
#define BDG_SECT_ERASE_TG      0x014U
#define BDG_BURST_PROG_TG      0x015U
#define BDG_BYTE_PROG_TG       0x016U
#define BDG_BLANK_CHECK_TG     0x017U
#define BDG_READ_TG            0x018U

extern unsigned long u32gvAddress;
extern unsigned long u32gvSize;
extern unsigned long u32gvSizebu;
extern unsigned char u8gaData[512];   //Buffer of data to burst program

void vfnSwitchMode(void);
/**********************************************************************/
void vfnSectErase(void);
void vfnMassErase(void);
void vfnBlankCheck(void);
void vfnByteProg(void);
void vfnBurstProg(void);
void vfnUnsec(void);
void vfnSetAddr(void);
void vfnLoadData(void);
void vfnReadData(void);
void vfnIdle(void);
void CANMBsConfig(void);
/**********************************************************************/

/**********************************************************************/

enum {
	Unsec,
	SetAddr,
	LoadData,
	MassErase,
	SectErase,
	BurstProg,
	ByteProg,
	BlankCheck,	
	ReadData,
	Idle
};


#endif /* BOOTLOADER_H_ */
