/*
 * bootloader.c
 *
 *  Created on: Feb 28, 2012
 *      Author: B31117
 */
#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "bootloader.h"
#include "msCANdrv.h"
#include "ColdFire_Flash.h"
#include "srv_protection.h"

unsigned long u32gvAddress = 0;
unsigned long u32gvSize = 0;
unsigned long u32gvSizebu = 0;
unsigned char u8gaData[512]; //Buffer of data to burst program
unsigned char u8MBData[9];
/**********************************************************************/
/**********************************************************************/
void vfnSwitchMode(void)
{
    unsigned long u32lvNewSP = *(unsigned long *) FLASHFIRSTADDRESS;
    unsigned long u32lvNewPC = *(unsigned long *) FLASHPCADDRESS;
    
    
    if (PTGD & 1) //
    {
        if ((u32lvNewSP != 0xFFFFFFFF) && (u32lvNewPC != 0xFFFFFFFF)) //jump to application if flash is not erased at that area.  		
        {
            asm
            {
                move.w #0x2700,sr
                move.l u32lvNewSP,a0
                move.l u32lvNewPC,a1
                move.l a0,a7
                jmp (a1)
            }
        }
    }
}

/**********************************************************************/
/**********************************************************************/
/******************** Main Functions **********************************/
/**********************************************************************/
/**********************************************************************/
void CANMBsConfig(void)
{
    unsigned char u8Index = 0U;

    /* MB0-15 are used to transmit can frame to bridge */
    /* MB16-31 are used to receive data and commands from bridge*/
    for (u8Index = 0U; u8Index < 9U; u8Index++)
    {
        CAN_ConfigMB(u8Index, TXDF, u8Index);
        CAN_ConfigMB((u8Index + 16U), RXDF, (u8Index + 16U));
    }
}
/**********************************************************************/
void vfnSectErase(void)
{
    unsigned long *u32lvAddress = (unsigned long *) &u8MBData[1];

    if (CAN_ReadDataMB(BDG_SECT_ERASE_TG, u8MBData) == ERR_OK)
    {
        DisableInterrupts;
        Flash_Erase(*u32lvAddress);
        EnableInterrupts;
        CAN_LoadMB(BDG_SECT_ERASE_TG - 16U, u8MBData);
        CAN_TransmitMB(BDG_SECT_ERASE_TG - 16U);

        u8gvbuffer = Idle;
    }

}
/**********************************************************************/
void vfnBlankCheck(void)
{
    unsigned long *u8lvFlashAddress = (unsigned long *) FLASHFIRSTADDRESS;
    unsigned char u8lvError = 0;

    if (CAN_ReadDataMB(BDG_BLANK_CHECK_TG, u8MBData) == ERR_OK)
    {
        while (u8lvFlashAddress < (unsigned long *) FLASHLASTADDRESS)
        {
            if (*u8lvFlashAddress++ != 0xFFFFFFFF)
            {
                u8lvError++;
            }
            __RESET_WATCHDOG();
        }
        u8MBData[0] = 1U; /* transmit one byte result */
        if (!u8lvError)
        {
            u8MBData[1] = 0xF1U; /* Flash is blank */
        }
        else
        {
            u8MBData[1] = 0xF0U; /* Flash is not blank */
        }
        CAN_LoadMB(BDG_BLANK_CHECK_TG - 16U, u8MBData);
        CAN_TransmitMB(BDG_BLANK_CHECK_TG - 16U);
        u8gvbuffer = Idle;
    }

}
/**********************************************************************/
void vfnMassErase(void)
{
    unsigned long u32lvAddress = (unsigned long) FLASHFIRSTADDRESS;
    static u8lvMassErasedone = 1;
    if (CAN_ReadDataMB(BDG_MASS_ERASE_TG, u8MBData) == ERR_OK)
    {
        DisableInterrupts;
        while (u32lvAddress < (unsigned long) FLASHLASTADDRESS)
		{
			Flash_Erase(u32lvAddress);
			u32lvAddress += 0x400;
		}    
        
        
        EnableInterrupts;
	    CAN_LoadMB(BDG_MASS_ERASE_TG - 16U, u8MBData);
	    CAN_TransmitMB(BDG_MASS_ERASE_TG - 16U);
	  
	    u8gvbuffer = Idle;
    }     
}
/**********************************************************************/
void vfnByteProg(void)
{
    unsigned long *u32lvAddress = (unsigned long *) &u8MBData[1];

    if (CAN_ReadDataMB(BDG_BYTE_PROG_TG, u8MBData) == ERR_OK)
    {
        DisableInterrupts;
        Flash_Program(*u32lvAddress,u8MBData[5]);
        EnableInterrupts;
        CAN_LoadMB(BDG_BYTE_PROG_TG - 16U, u8MBData);
        CAN_TransmitMB(BDG_BYTE_PROG_TG - 16U);

        u8gvbuffer = Idle;
    }
}
/**********************************************************************/
void vfnBurstProg(void)
{
    unsigned char u8lvIndex = 0;
    static unsigned char *u8lvAddress = (unsigned char *) &u8gaData[0];

    if (CAN_ReadDataMB(BDG_BURST_PROG_TG, u8MBData) == ERR_OK)
    {
       // __RESET_WATCHDOG();
    	DisableInterrupts;
        Flash_Burst(u32gvAddress, (u32gvSize/4U), u8gaData);
        EnableInterrupts;
        u8MBData[0] = 0;
        CAN_LoadMB(BDG_BURST_PROG_TG - 16U, u8MBData); //Send Response
        CAN_TransmitMB(BDG_BURST_PROG_TG - 16U);

        u8gvbuffer = Idle;
    }
}
/**********************************************************************/
void vfnUnsec(void)
{
    if (CAN_ReadDataMB(BDG_UNSEC_TG, u8MBData) == ERR_OK)
    {
        if (vfnBackdoorTest((unsigned long *) &u8MBData[1])) //if unsecured command ok 
            u8MBData[1] = 0xF0;
        else
            //Fail
            u8MBData[1] = 0xF1;

        u8MBData[0] = 1;
        CAN_LoadMB(BDG_UNSEC_TG - 16U, u8MBData);
        CAN_TransmitMB(BDG_UNSEC_TG - 16U);

        u8gvbuffer = Idle;
    }
}
/**********************************************************************/
void vfnSetAddr(void)
{
    unsigned long *u32lvAddress = (unsigned long *) &u8MBData[1];

    if (CAN_ReadDataMB(BDG_SET_ADDR, u8MBData) == ERR_OK)
    {
        u32gvAddress = *u32lvAddress;
        u32lvAddress = (unsigned long *) &u8MBData[5];
        u32gvSize = *u32lvAddress;
        u32gvSizebu = u32gvSize;
        CAN_LoadMB(BDG_SET_ADDR - 16U, u8MBData);
        CAN_TransmitMB(BDG_SET_ADDR - 16U);

        u8gvbuffer = Idle;
    }
}
/**********************************************************************/
void vfnLoadData(void)
{
    unsigned char u8lvIndex = 0;
    static unsigned char *u8lvAddress = (unsigned char *) &u8gaData[0];

    if (CAN_ReadDataMB(BDG_LOAD_DATA, u8MBData) == ERR_OK)
    {
        for (u8lvIndex = 0; u8lvIndex < u8MBData[0]; u8lvIndex++) //copy the amount of data given by the index 0 or DLC
        {
            *u8lvAddress++ = u8MBData[u8lvIndex + 1]; //Copy MB data to global buffer
            u32gvSizebu--;
        }
        CAN_LoadMB(BDG_LOAD_DATA - 16U, u8MBData); //Send Response
        CAN_TransmitMB(BDG_LOAD_DATA - 16U);
        if (!u32gvSizebu) //Decrease size --
         {
            u8lvAddress = (unsigned char *) &u8gaData[0]; //return pointer to global buffer
        }

        u8gvbuffer = Idle;
    }

}

/**********************************************************************/
void vfnReadData(void)
{
    unsigned char i = 0U;
    unsigned char *u32lvAddress;
    unsigned long u32lvDataLength = 0U;

    if (CAN_ReadDataMB(BDG_READ_TG, u8MBData) == ERR_OK)
    {

        u32lvAddress = (unsigned char *) (*(unsigned long *) &u8MBData[1]);
        u32lvDataLength = *(unsigned long *) &u8MBData[5];
        while (u32lvDataLength != 0U)
        {
          
            if (u32lvDataLength >= 8U)
            {
                u8MBData[0] = 8U;
                for (i = 1; i < 9U; i++)
                {
                    u8MBData[i] = *u32lvAddress++;
                }
                u32lvDataLength -= 8U;
                u8CANTxOK = 0U;
                CAN_LoadMB(BDG_READ_TG - 16U, u8MBData); //Send Response
                CAN_TransmitMB(BDG_READ_TG - 16U);
                while (u8CANTxOK == 0U)
                {
                 
                }
           }
            else
            {
                u8MBData[0] = (unsigned char) u32lvDataLength;
                for (i = 1; i <= u8MBData[0]; i++)
                {
                    u8MBData[i] = *u32lvAddress++;
                }
                u32lvDataLength = 0U;
                CAN_LoadMB(BDG_READ_TG - 16U, u8MBData); //Send Response
                CAN_TransmitMB(BDG_READ_TG - 16U);
            }
        }
        u8gvbuffer = Idle;
    }

}
/**********************************************************************/
void vfnIdle(void)
{
}
/**********************************************************************/